/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhGradeOfQualityCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsQcProcessDetailCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsReceiveShelvesDetailCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsQcProcessDetailMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsReceiveShelvesDetailMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhGradeOfQualityCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhWmsReceiveShelvesDetailCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsGradeOfQualityBarcode;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsHouseShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsQcProcessDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsQcProcessDetailExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReceiveShelvesDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReceiveShelvesDetailExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhGradeOfQualityService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsReceiveShelvesDetailService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhGradeOfQualityVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsGradeOfQualityVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsQcProcessDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReceiveShelvesDetailVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whWmsReceiveShelvesDetailService")
public class WhWmsReceiveShelvesDetailServiceImpl
implements WhWmsReceiveShelvesDetailService {
    private static final Logger log = LoggerFactory.getLogger(WhWmsReceiveShelvesDetailServiceImpl.class);
    @Autowired
    private WhWmsReceiveShelvesDetailMapper whWmsReceiveShelvesDetailMapper;
    @Autowired
    private WhWmsReceiveShelvesDetailCustomMapper whWmsReceiveShelvesDetailCustomMapper;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhGradeOfQualityService whGradeOfQualityService;
    @Autowired
    private WhGradeOfQualityCustomMapper whGradeOfQualityCustomMapper;
    @Autowired
    private WhWmsQcProcessDetailMapper whWmsQcProcessDetailMapper;

    @Override
    public WhWmsReceiveShelvesDetail findWhWmsReceiveShelvesDetailById(Long id) {
        return this.whWmsReceiveShelvesDetailMapper.selectByPrimaryKey(id);
    }

    @Override
    public WhWmsReceiveShelvesDetailVO findWhWmsReceiveShelvesDetailVOById(Long id, boolean fetchSkuImg) {
        WhWmsReceiveShelvesDetailVO vo = this.whWmsReceiveShelvesDetailCustomMapper.findVOById(id);
        if (EmptyUtil.isNotEmpty((Object)vo)) {
            this.fetchSkuImg(vo, fetchSkuImg);
        }
        return vo;
    }

    private void fetchSkuImg(WhWmsReceiveShelvesDetailVO vo, boolean fetchSkuImg) {
        if (fetchSkuImg && EmptyUtil.isNotEmpty((String)vo.getSkuImage())) {
            String[] skuImageIds = vo.getSkuImage().split(",");
            Long[] skuImageArr = (Long[])ConvertUtils.convert((String[])skuImageIds, Long.class);
            List commFileRefs = PegasusUtilFacade.getInstance().findCommFileRefByIds(Arrays.asList(skuImageArr));
            vo.setCommFileRefs(commFileRefs);
        }
    }

    @Override
    public WhWmsReceiveShelvesDetailVO findWhWmsReceiveShelvesDetailVOByCond(WhWmsReceiveShelvesDetailCond cond) {
        WhWmsReceiveShelvesDetailExample example = this.buildWhWmsReceiveShelvesDetailExampleByCond(cond);
        List<WhWmsReceiveShelvesDetail> shelvesDetails = this.whWmsReceiveShelvesDetailMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(shelvesDetails)) {
            WhWmsReceiveShelvesDetailVO vo = (WhWmsReceiveShelvesDetailVO)BeanUtil.buildFrom((Object)shelvesDetails.get(0), WhWmsReceiveShelvesDetailVO.class);
            this.fetchSkuImg(vo, cond.isFetchSkuImg());
            return vo;
        }
        return null;
    }

    private WhWmsReceiveShelvesDetailExample buildWhWmsReceiveShelvesDetailExampleByCond(WhWmsReceiveShelvesDetailCond cond) {
        WhWmsReceiveShelvesDetailExample example = new WhWmsReceiveShelvesDetailExample();
        WhWmsReceiveShelvesDetailExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)cond.getId())) {
            criteria.andIdEqualTo(cond.getId());
        } else if (CollectionUtils.isNotEmpty(cond.getIds())) {
            criteria.andIdIn((List)cond.getIds());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getRefCode())) {
            criteria.andRefCodeEqualTo(cond.getRefCode());
        } else if (CollectionUtils.isNotEmpty(cond.getRefCodes())) {
            criteria.andRefCodeIn((List)cond.getRefCodes());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getRefType())) {
            criteria.andRefTypeEqualTo(cond.getRefType());
        } else if (CollectionUtils.isNotEmpty(cond.getRefTypes())) {
            criteria.andRefTypeIn((List)cond.getRefTypes());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getQcId())) {
            criteria.andQcIdEqualTo(cond.getQcId());
        } else if (CollectionUtils.isNotEmpty(cond.getQcIds())) {
            criteria.andQcIdIn((List)cond.getQcIds());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getSkuStatus())) {
            criteria.andSkuStatusEqualTo(cond.getSkuStatus());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getSkuCode())) {
            criteria.andSkuCodeEqualTo(cond.getSkuCode());
        } else if (CollectionUtils.isNotEmpty(cond.getSkuCodes())) {
            criteria.andSkuCodeIn((List)cond.getSkuCodes());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getOriginType())) {
            criteria.andOriginTypeEqualTo(cond.getOriginType());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getCreateTimeStart())) {
            criteria.andCreateTimeGreaterThanOrEqualTo(DateUtil.parse((String)cond.getCreateTimeStart(), (String)"yyyy-MM-dd"));
        }
        if (EmptyUtil.isNotEmpty((String)cond.getCreateTimeEnd())) {
            criteria.andCreateTimeLessThanOrEqualTo(DateUtil.parse((String)cond.getCreateTimeEnd(), (String)"yyyy-MM-dd"));
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getCreateUserId())) {
            criteria.andCreateUserIdEqualTo(cond.getCreateUserId());
        }
        return example;
    }

    @Override
    public List<WhWmsReceiveShelvesDetail> findWhWmsReceiveShelvesDetailByCond(WhWmsReceiveShelvesDetailCond cond) {
        WhWmsReceiveShelvesDetailExample example = this.buildWhWmsReceiveShelvesDetailExampleByCond(cond);
        return this.whWmsReceiveShelvesDetailMapper.selectByExample(example);
    }

    @Override
    public List<WhWmsReceiveShelvesDetailVO> listWhWmsReceiveShelvesDetailVOByCond(WhWmsReceiveShelvesDetailCond cond) {
        List<WhWmsReceiveShelvesDetailVO> receiveShelvesDetailVOs = this.whWmsReceiveShelvesDetailCustomMapper.listWhWmsReceiveShelvesDetailVOByCond(cond);
        if (cond.isFetchSkuImg() && CollectionUtils.isNotEmpty(receiveShelvesDetailVOs)) {
            for (WhWmsReceiveShelvesDetailVO shelvesDetailVO : receiveShelvesDetailVOs) {
                this.fetchSkuImg(shelvesDetailVO, true);
            }
        }
        return receiveShelvesDetailVOs;
    }

    @Override
    public WhWmsQcProcessDetailVO findWhWmsQcProcessDetailVOByCond(WhWmsQcProcessDetailCond cond) {
        List<WhWmsQcProcessDetailVO> whWmsQcProcessDetailVOs = this.listWhWmsQcProcessDetailVOByCond(cond);
        if (CollectionUtils.isNotEmpty(whWmsQcProcessDetailVOs)) {
            return whWmsQcProcessDetailVOs.get(0);
        }
        return null;
    }

    @Override
    public List<WhWmsQcProcessDetailVO> listWhWmsQcProcessDetailVOByCond(WhWmsQcProcessDetailCond cond) {
        return this.whWmsReceiveShelvesDetailCustomMapper.listWhWmsQcProcessDetailVOByCond(cond);
    }

    @Override
    public WhWmsQcProcessDetail findWhWmsQcProcessDetailByCond(WhWmsQcProcessDetailCond cond) {
        List<WhWmsQcProcessDetail> whWmsQcProcessDetails = this.listWhWmsQcProcessDetailsByCond(cond);
        if (CollectionUtils.isNotEmpty(whWmsQcProcessDetails)) {
            return whWmsQcProcessDetails.get(0);
        }
        return null;
    }

    @Override
    public List<WhWmsQcProcessDetail> listWhWmsQcProcessDetailsByCond(WhWmsQcProcessDetailCond cond) {
        WhWmsQcProcessDetailExample example = this.buildWhWmsQcProcessDetailExampleByCond(cond);
        return this.whWmsQcProcessDetailMapper.selectByExample(example);
    }

    private WhWmsQcProcessDetailExample buildWhWmsQcProcessDetailExampleByCond(WhWmsQcProcessDetailCond cond) {
        WhWmsQcProcessDetailExample example = new WhWmsQcProcessDetailExample();
        WhWmsQcProcessDetailExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)cond.getQcId())) {
            criteria.andQcIdEqualTo(cond.getQcId());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getRefCode())) {
            criteria.andRefCodeEqualTo(cond.getRefCode());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getSkuCode())) {
            criteria.andSkuCodeEqualTo(cond.getSkuCode());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getInOutType())) {
            criteria.andInOutTypeEqualTo(cond.getInOutType());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getProcessStatus())) {
            criteria.andProcessStatusEqualTo(cond.getProcessStatus());
        }
        return example;
    }

    @Override
    @Transactional
    public void purchaseDefectiveProcess(List<WhWmsReceiveShelvesDetailVO> receiveShelvesDetailVOs, Long processUserId) throws Exception {
        HashSet<Long> qcIds = new HashSet<Long>();
        HashSet<String> refCodes = new HashSet<String>();
        HashSet<String> skuCodes = new HashSet<String>();
        for (WhWmsReceiveShelvesDetailVO shelvesDetailVO : receiveShelvesDetailVOs) {
            qcIds.add(shelvesDetailVO.getQcId());
            refCodes.add(shelvesDetailVO.getRefCode());
            skuCodes.add(shelvesDetailVO.getSkuCode());
            shelvesDetailVO.setCreateUserId(processUserId);
            shelvesDetailVO.setProcessUserId(processUserId);
            shelvesDetailVO.setCreateTime(new Date());
        }
        WhWmsReceiveShelvesDetailCond shelvesDetailCond = new WhWmsReceiveShelvesDetailCond();
        shelvesDetailCond.setRefCodes(Arrays.asList(refCodes.toArray(new String[refCodes.size()])));
        shelvesDetailCond.setQcIds(Arrays.asList(qcIds.toArray(new Long[qcIds.size()])));
        shelvesDetailCond.setSkuCodes(Arrays.asList(skuCodes.toArray(new String[skuCodes.size()])));
        shelvesDetailCond.setRefType(WhCommand.TYPE_PURCHASE_IN);
        shelvesDetailCond.setOriginType(2);
        this.deleteByCond(shelvesDetailCond);
        this.batchCreate(BeanUtil.buildListFrom(receiveShelvesDetailVOs, WhWmsReceiveShelvesDetail.class));
        ArrayList<String> keyList = new ArrayList<String>();
        String key = "";
        for (WhWmsReceiveShelvesDetailVO shelvesDetailVO : receiveShelvesDetailVOs) {
            key = shelvesDetailVO.getQcId() + shelvesDetailVO.getRefCode() + shelvesDetailVO.getSkuCode();
            if (keyList.contains(key)) continue;
            WhWmsQcProcessDetail whWmsQcProcessDetail = this.buildWhWmsQcProcessDetailByReceiveShelvesDetail(shelvesDetailVO);
            this.createWhWmsQcProcessDetail(whWmsQcProcessDetail);
            keyList.add(key);
        }
    }

    @Override
    public boolean createWhWmsQcProcessDetail(WhWmsQcProcessDetail whWmsQcProcessDetail) {
        return this.whWmsQcProcessDetailMapper.insert(whWmsQcProcessDetail) > 0;
    }

    public WhWmsQcProcessDetail buildWhWmsQcProcessDetailByReceiveShelvesDetail(WhWmsReceiveShelvesDetailVO shelvesDetailVO) {
        WhWmsQcProcessDetail whWmsQcProcessDetail = new WhWmsQcProcessDetail();
        whWmsQcProcessDetail.setQcId(shelvesDetailVO.getQcId());
        whWmsQcProcessDetail.setRefCode(shelvesDetailVO.getRefCode());
        whWmsQcProcessDetail.setSkuCode(shelvesDetailVO.getSkuCode());
        whWmsQcProcessDetail.setInOutType(shelvesDetailVO.getRefType());
        whWmsQcProcessDetail.setProcessStatus(1);
        whWmsQcProcessDetail.setProcessUserId(shelvesDetailVO.getProcessUserId());
        whWmsQcProcessDetail.setProcessTime(DateUtil.getNow());
        return whWmsQcProcessDetail;
    }

    @Override
    @Transactional
    public boolean create(WhWmsReceiveShelvesDetailVO vo) throws Exception {
        WhWmsReceiveShelvesDetail receiveShelvesDetail = (WhWmsReceiveShelvesDetail)BeanUtil.buildFrom((Object)vo, WhWmsReceiveShelvesDetail.class);
        receiveShelvesDetail.setCreateTime(DateUtil.getNow());
        int result = this.whWmsReceiveShelvesDetailMapper.insert(receiveShelvesDetail);
        vo.setId(receiveShelvesDetail.getId());
        return result > 0;
    }

    @Override
    @Transactional
    public boolean batchCreate(List<WhWmsReceiveShelvesDetail> receiveShelvesDetails) {
        return this.whWmsReceiveShelvesDetailCustomMapper.batchCreateReceiveShelvesDetail(receiveShelvesDetails) > 0;
    }

    @Override
    @Transactional
    public boolean deleteByCond(WhWmsReceiveShelvesDetailCond cond) {
        WhWmsReceiveShelvesDetailExample example = this.buildWhWmsReceiveShelvesDetailExampleByCond(cond);
        this.whWmsReceiveShelvesDetailMapper.deleteByExample(example);
        return true;
    }

    @Override
    @Transactional
    public boolean createOrUpdate(WhWmsReceiveShelvesDetailVO vo) throws Exception {
        boolean result = false;
        result = EmptyUtil.isNotEmpty((Object)vo.getId()) && EmptyUtil.isNotEmpty((Object)this.whWmsReceiveShelvesDetailMapper.selectByPrimaryKey(vo.getId())) ? this.update(vo) : this.create(vo);
        return result;
    }

    @Override
    @Transactional
    public boolean update(WhWmsReceiveShelvesDetailVO vo) throws Exception {
        WhWmsReceiveShelvesDetail receiveShelvesDetail = (WhWmsReceiveShelvesDetail)BeanUtil.buildFrom((Object)vo, WhWmsReceiveShelvesDetail.class);
        int result = this.whWmsReceiveShelvesDetailMapper.updateByPrimaryKeySelective(receiveShelvesDetail);
        return result > 0;
    }

    private void sendGradeAdjustApplyMail(WhWmsGradeOfQualityVO vo) {
        WhGradeOfQualityCond whGradeCond = new WhGradeOfQualityCond();
        whGradeCond.setRefId(vo.getId());
        List<WhGradeOfQualityVO> gradeOfQualityVOs = this.whGradeOfQualityCustomMapper.listWhGradeOfQualityVOByCond(whGradeCond);
        this.whGradeOfQualityService.gradeAdjustApplySendMail(gradeOfQualityVOs);
    }

    private Map<String, WhWmsHouseShelves> getHouseTypeMapByBarcodes(List<WhWmsGradeOfQualityBarcode> gradeBarcodes) {
        HashSet<String> shelvesCodes = new HashSet<String>();
        for (WhWmsGradeOfQualityBarcode barcode : gradeBarcodes) {
            shelvesCodes.add(barcode.getShelvesCode());
        }
        List<WhWmsHouseShelves> whWmsHouseShelves = this.whWmsHouseShelvesService.getHouseShelvesByCode(new ArrayList<String>(shelvesCodes));
        HashMap<String, WhWmsHouseShelves> shelvesMap = new HashMap<String, WhWmsHouseShelves>();
        for (WhWmsHouseShelves houseShelves : whWmsHouseShelves) {
            shelvesMap.put(houseShelves.getCode(), houseShelves);
        }
        return shelvesMap;
    }
}

