/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsPrdcJobTaskCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsPrdcMaterialDetailCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhPhysicalWarehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWarehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsPrdcJobTaskMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvOccupy;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsHouseShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsPrdcJobTask;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsPrdcJobTaskExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsPrdcMaterialDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuBarcode;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWarehouseArea;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInvService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsOccupyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsPrdcJobTaskDetailService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsPrdcJobTaskService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsPrdcMaterialDetailService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuBarcodeService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWaitPutawayService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWarehouseAreaService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhQualityControlVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhReceiveShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhReleaseOccupationVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsOccupyVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPrdcJobTaskDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPrdcJobTaskVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuBarcodeVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockRecordVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsStartPutawayVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsWaitPutawayVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Controller(value="whWmsPrdcJobTaskService")
public class WhWmsPrdcJobTaskServiceImpl
implements WhWmsPrdcJobTaskService {
    private static Logger log = LoggerFactory.getLogger(WhWmsPrdcJobTaskServiceImpl.class);
    @Autowired
    private WhWmsPrdcJobTaskMapper whWmsPrdcJobTaskMapper;
    @Autowired
    private WhWmsOccupyService whWmsOccupyService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhWmsPrdcJobTaskDetailService whWmsPrdcJobTaskDetailService;
    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelves;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsSkuBarcodeService whWmsSkuBarcodeService;
    @Autowired
    private WhWarehouseMapper whWarehouseMapper;
    @Autowired
    private WhPhysicalWarehouseMapper whPhysicalWarehouseMapper;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhInvService whInvService;
    @Autowired
    private WhWmsHouseShelvesService whHouseShelvesService;
    @Autowired
    private WhWmsWarehouseAreaService whWmsWarehouseAreaService;
    @Autowired
    private WhWmsWaitPutawayService whWmsWaitPutawayService;
    @Autowired
    private RedisDistributLock redisDistributLock;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhWmsPrdcMaterialDetailService whWmsPrdcMaterialDetailService;

    @Override
    public List<WhWmsPrdcJobTaskVO> getPrdcJobTaskByCond(WhWmsPrdcJobTaskCond cond) {
        List<WhWmsPrdcJobTask> jobTaskList = this.whWmsPrdcJobTaskMapper.getPrdcJobTaskByCond(cond);
        if (CollectionUtils.isEmpty(jobTaskList)) {
            return Collections.EMPTY_LIST;
        }
        List prdcJobTaskVOs = BeanUtil.buildListFrom(jobTaskList, WhWmsPrdcJobTaskVO.class);
        if (cond.isFetchTaskDetail()) {
            for (WhWmsPrdcJobTaskVO taskVO : prdcJobTaskVOs) {
                taskVO.setJobTaskDetailList(this.whWmsPrdcJobTaskDetailService.getTaskDetailByTaskCode(taskVO.getCode()));
            }
        }
        return prdcJobTaskVOs;
    }

    @Override
    public WhWmsPrdcJobTaskVO getPrdcJobTaskById(Long id) {
        WhWmsPrdcJobTask jobTask = this.whWmsPrdcJobTaskMapper.selectByPrimaryKey(id);
        if (EmptyUtil.isEmpty((Object)jobTask)) {
            return null;
        }
        WhWmsPrdcJobTaskVO jobTaskVO = (WhWmsPrdcJobTaskVO)BeanUtil.buildFrom((Object)jobTask, WhWmsPrdcJobTaskVO.class);
        List<WhWmsPrdcJobTaskDetailVO> taskDetailVOs = this.whWmsPrdcJobTaskDetailService.getTaskDetailByTaskCode(jobTask.getCode());
        jobTaskVO.setJobTaskDetailList(taskDetailVOs);
        return jobTaskVO;
    }

    @Override
    public WhWmsPrdcJobTaskVO getPrdcJobTaskByTaskCode(String taskCode) {
        WhWmsPrdcJobTaskExample example = new WhWmsPrdcJobTaskExample();
        example.createCriteria().andCodeEqualTo(taskCode);
        List<WhWmsPrdcJobTask> jobTasks = this.whWmsPrdcJobTaskMapper.selectByExample(example);
        if (EmptyUtil.isEmpty(jobTasks)) {
            return null;
        }
        List jobTaskVOs = BeanUtil.buildListFrom(jobTasks, WhWmsPrdcJobTaskVO.class);
        return (WhWmsPrdcJobTaskVO)jobTaskVOs.get(0);
    }

    @Override
    public List<WhWmsPrdcJobTaskVO> getPrdcJobTaskByJobCode(String jobCode) {
        WhWmsPrdcJobTaskExample example = new WhWmsPrdcJobTaskExample();
        example.createCriteria().andPrdcJobCodeEqualTo(jobCode);
        List<WhWmsPrdcJobTask> jobTasks = this.whWmsPrdcJobTaskMapper.selectByExample(example);
        List jobTaskVOs = BeanUtil.buildListFrom(jobTasks, WhWmsPrdcJobTaskVO.class);
        return jobTaskVOs;
    }

    @Override
    @Transactional
    public Boolean createJobTaskAndOccupyStock(WhWmsPrdcJobTaskVO vo) {
        if (WhWmsPrdcJobTaskVO.WMS_PLAN_STATUS_FINISHED.equals(vo.getJobPlanStatus())) {
            throw new WarehouseException("WH0001", "[" + vo.getPrdcJobCode() + "]\u52a0\u5de5\u5355\u5df2\u5b8c\u6210\uff01");
        }
        Map<String, Integer> skuQuantiyMap = this.computeTaskMaterial(vo);
        ArrayList<WhWmsSkuStockVO> pickStockList = new ArrayList<WhWmsSkuStockVO>();
        Map<String, Integer> shortageSkuMap = this.findTaskPickStock(vo.getPhysicalWarehouseCode(), vo.getSkuStatus(), skuQuantiyMap, pickStockList);
        if (!shortageSkuMap.isEmpty()) {
            this.sendOutOfStockEmil(vo.getAmount(), vo.getPhysicalWarehouseCode(), vo.getPrdcJobCode(), shortageSkuMap);
            return false;
        }
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
        cond.setHouseType("HOUSE_TYPE_PROCESSING");
        List<WhWmsHouseShelvesVO> targetShelves = this.whWmsHouseShelves.getHouseShelvesByCond(cond);
        if (CollectionUtils.isEmpty(targetShelves)) {
            throw new WarehouseException("WH0001", "\u52a0\u5de5\u533a\u65e0\u5e93\u4f4d\uff01");
        }
        WhWmsHouseShelvesVO processingShelves = targetShelves.get(0);
        List<WhWmsMoveSkuVO> moveSkuList = this.filterMoveStock(pickStockList, processingShelves);
        if (EmptyUtil.isNotEmpty(moveSkuList)) {
            WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
            moveStockVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
            moveStockVO.setCreateUserId(vo.getCreateUserId());
            moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_PRODUCTION);
            moveStockVO.setReferenceCode(vo.getPrdcJobCode());
            moveStockVO.setMoveSkuList(moveSkuList);
            this.whWmsMoveStockService.newMoveStock(moveStockVO);
            vo.setMoveStockCode(moveStockVO.getCode());
            return false;
        }
        vo.setCreateTime(DateUtil.getNow());
        vo.setFinishedDefectiveAmount(0);
        vo.setFinishedGoodsAmount(0);
        vo.setStatus(WhWmsPrdcJobTaskVO.STATUS_PROCESSING);
        vo.setCode(this.createNewCode("TK"));
        for (WhWmsPrdcJobTaskDetailVO taskDetailVO : vo.getJobTaskDetailList()) {
            taskDetailVO.setTaskCode(vo.getCode());
            taskDetailVO.setCode(this.createNewCode("TKD"));
        }
        List<WhWmsOccupyVO> occupyList = this.buildJobTaskOccupy(pickStockList, vo);
        this.whWmsOccupyService.wmsBatchOccupy(occupyList);
        this.whWmsPrdcJobTaskMapper.insert(vo);
        this.whWmsPrdcJobTaskDetailService.newTaskDetail(vo.getJobTaskDetailList());
        return true;
    }

    private List<WhWmsOccupyVO> buildJobTaskOccupy(List<WhWmsSkuStockVO> pickStockList, WhWmsPrdcJobTaskVO JobTask) {
        ArrayList<WhWmsOccupyVO> occupyList = new ArrayList<WhWmsOccupyVO>();
        for (WhWmsSkuStockVO pickStock : pickStockList) {
            WhWmsOccupyVO occupyVO = (WhWmsOccupyVO)BeanUtil.buildFrom((Object)pickStock, WhWmsOccupyVO.class);
            occupyVO.setType(WhWmsOccupyVO.TYPE_PRODUCTION);
            occupyVO.setStatus(WhWmsOccupyVO.OCCUPIED);
            occupyVO.setReceiptsNo(JobTask.getCode());
            occupyVO.setHouseType(pickStock.getHouseType());
            occupyVO.setOriShelvesCode(pickStock.getShelvesCode());
            occupyVO.setAmount(-pickStock.getAvailableAccount());
            occupyList.add(occupyVO);
        }
        return occupyList;
    }

    private List<WhWmsMoveSkuVO> filterMoveStock(List<WhWmsSkuStockVO> pickStockList, WhWmsHouseShelvesVO processingShelves) {
        ArrayList<WhWmsMoveSkuVO> moveSkus = new ArrayList<WhWmsMoveSkuVO>();
        if (EmptyUtil.isNotEmpty(pickStockList)) {
            for (WhWmsSkuStockVO pickStock : pickStockList) {
                if ("HOUSE_TYPE_PROCESSING".equals(pickStock.getHouseType())) continue;
                WhWmsMoveSkuVO moveSkuVO = (WhWmsMoveSkuVO)BeanUtil.buildFrom((Object)pickStock, WhWmsMoveSkuVO.class);
                moveSkuVO.setCreateTime(DateUtil.getNow());
                moveSkuVO.setOriginalHouseType(pickStock.getHouseType());
                moveSkuVO.setTargetHouseType(processingShelves.getHouseType());
                moveSkuVO.setAmount(pickStock.getAvailableAccount());
                moveSkuVO.setOriginalShelvesCode(pickStock.getShelvesCode());
                moveSkuVO.setTargetShelvesCode(processingShelves.getCode());
                moveSkus.add(moveSkuVO);
            }
        }
        return moveSkus;
    }

    private Map<String, Integer> findTaskPickStock(String physicalWarehouseCode, Integer skuStatus, Map<String, Integer> skuQuantityMap, List<WhWmsSkuStockVO> pickStockList) {
        List<String> skuCodes = Arrays.asList(skuQuantityMap.keySet().toArray(new String[skuQuantityMap.size()]));
        List<WhWmsSkuBarcode> skuBarcodeList = null;
        if (EmptyUtil.isNotEmpty(skuCodes)) {
            skuBarcodeList = this.whWmsSkuBarcodeService.findBarCodesForPickSkuStock(skuCodes);
        }
        if (NullUtil.isNull(skuBarcodeList)) {
            skuBarcodeList = new ArrayList<WhWmsSkuBarcode>();
        }
        HashMap<String, WhWmsSkuBarcode> barcodeMap = new HashMap<String, WhWmsSkuBarcode>();
        ArrayList<String> barCodes = new ArrayList<String>();
        for (WhWmsSkuBarcode barcode : skuBarcodeList) {
            barCodes.add(barcode.getBarCode());
            barcodeMap.put(barcode.getBarCode(), barcode);
        }
        Map<String, Integer> diffMap = skuQuantityMap;
        ArrayList<WhWmsSkuStockVO> canUseShelvesStockList = new ArrayList<WhWmsSkuStockVO>();
        if (EmptyUtil.isNotEmpty(barCodes)) {
            WhWmsSkuStockVO stockCond = new WhWmsSkuStockVO();
            stockCond.setPhysicalWarehouseCode(physicalWarehouseCode);
            stockCond.setSkuStatus(skuStatus);
            stockCond.setBarCodeList(barCodes);
            stockCond.setHouseTypes(Collections.singletonList("HOUSE_TYPE_PROCESSING"));
            List<WhWmsSkuStockVO> shelvesStockList = this.whWmsSkuStockService.findWmsSkuAvailableAccount(stockCond, true);
            if (EmptyUtil.isNotEmpty(shelvesStockList)) {
                canUseShelvesStockList.addAll(shelvesStockList);
                Map<String, Integer> stockSkuQuantityMap = this.groupStockBySku(shelvesStockList);
                diffMap = this.coumputeDiffMap(skuQuantityMap, stockSkuQuantityMap);
            }
            if (!diffMap.isEmpty()) {
                Map<String, WhWmsWarehouseArea> areaMap = this.whWmsWarehouseAreaService.getAreaHouseMapByType("NORMAL");
                List<String> houseTypes = Arrays.asList(areaMap.keySet().toArray(new String[areaMap.size()]));
                stockCond.setHouseTypes(houseTypes);
                ArrayList<Integer> shelvesTypeList = new ArrayList<Integer>();
                shelvesTypeList.add(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING);
                shelvesTypeList.add(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING);
                stockCond.setShelvesTypeList(shelvesTypeList);
                shelvesStockList = this.whWmsSkuStockService.findWmsSkuAvailableAccount(stockCond, true);
                if (EmptyUtil.isNotEmpty(shelvesStockList)) {
                    canUseShelvesStockList.addAll(shelvesStockList);
                    Map<String, Integer> stockSkuQuantityMap = this.groupStockBySku(shelvesStockList);
                    diffMap = this.coumputeDiffMap(diffMap, stockSkuQuantityMap);
                }
            }
        }
        if (!diffMap.isEmpty()) {
            return diffMap;
        }
        this.sortStockForJobTaskPickStock(canUseShelvesStockList, barcodeMap);
        List<WhWmsSkuStockVO> pickedStockList = this.computeTaskStock(canUseShelvesStockList, skuQuantityMap);
        pickStockList.addAll(pickedStockList);
        return diffMap;
    }

    private List<WhWmsSkuStockVO> computeTaskStock(List<WhWmsSkuStockVO> canUseShelvesStockListSorted, Map<String, Integer> skuQuantityMap) {
        HashMap<String, Integer> needMap = new HashMap<String, Integer>(skuQuantityMap);
        ArrayList<WhWmsSkuStockVO> stockList = new ArrayList<WhWmsSkuStockVO>();
        for (WhWmsSkuStockVO stock : canUseShelvesStockListSorted) {
            if (needMap.isEmpty()) break;
            Integer needQuantity = (Integer)needMap.get(stock.getSkuCode());
            if (NullUtil.isNull((Object)needQuantity) || stock.getAvailableAccount() <= 0) continue;
            int canuseQuantity = Math.min(stock.getAvailableAccount(), needQuantity);
            WhWmsSkuStockVO pickStock = (WhWmsSkuStockVO)BeanUtil.buildFrom((Object)stock, WhWmsSkuStockVO.class);
            pickStock.setAvailableAccount(canuseQuantity);
            needQuantity = needQuantity - canuseQuantity;
            needMap.put(stock.getSkuCode(), needQuantity);
            if (needQuantity == 0) {
                needMap.remove(stock.getSkuCode());
            }
            stockList.add(pickStock);
        }
        return stockList;
    }

    private void sortStockForJobTaskPickStock(List<WhWmsSkuStockVO> canUseShelvesStockList, final Map<String, WhWmsSkuBarcode> barcodeMap) {
        if (EmptyUtil.isEmpty(canUseShelvesStockList)) {
            return;
        }
        ArrayList<String> shelvesCodes = new ArrayList<String>();
        for (WhWmsSkuStockVO skuStock : canUseShelvesStockList) {
            shelvesCodes.add(skuStock.getShelvesCode());
        }
        final Map<String, WhWmsHouseShelves> shelvesMap = this.whHouseShelvesService.getHouseShelvesMapByCode(shelvesCodes);
        Collections.sort(canUseShelvesStockList, new Comparator<WhWmsSkuStockVO>(){

            @Override
            public int compare(WhWmsSkuStockVO o1, WhWmsSkuStockVO o2) {
                int result;
                WhWmsHouseShelves s1 = (WhWmsHouseShelves)shelvesMap.get(o1.getShelvesCode());
                WhWmsHouseShelves s2 = (WhWmsHouseShelves)shelvesMap.get(o2.getShelvesCode());
                Integer houseTypeSort1 = Integer.MAX_VALUE;
                Integer houseTypeSort2 = Integer.MAX_VALUE;
                if ("HOUSE_TYPE_PROCESSING".equals(s1.getHouseType())) {
                    houseTypeSort1 = Integer.MIN_VALUE;
                }
                if ("HOUSE_TYPE_PROCESSING".equals(s2.getHouseType())) {
                    houseTypeSort2 = Integer.MIN_VALUE;
                }
                if ((result = houseTypeSort1.compareTo(houseTypeSort2)) == 0 && (result = WhWmsPrdcJobTaskServiceImpl.this.whWmsSkuBarcodeService.compareBarCode((WhWmsSkuBarcode)barcodeMap.get(o1.getBarCode()), (WhWmsSkuBarcode)barcodeMap.get(o2.getBarCode()))) == 0 && (result = -s1.getShelvesType().compareTo(s2.getShelvesType())) == 0) {
                    Integer stock1 = o1.getAvailableAccount();
                    Integer stock2 = o2.getAvailableAccount();
                    result = stock1.compareTo(stock2);
                }
                return result;
            }
        });
    }

    private Map<String, Integer> groupStockBySku(List<WhWmsSkuStockVO> stockList) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (EmptyUtil.isNotEmpty(stockList)) {
            for (WhWmsSkuStockVO stock : stockList) {
                Integer total = (Integer)map.get(stock.getSkuCode());
                if (NullUtil.isNull((Object)total)) {
                    total = 0;
                }
                map.put(stock.getSkuCode(), total + stock.getAvailableAccount());
            }
        }
        return map;
    }

    private Map<String, Integer> coumputeDiffMap(Map<String, Integer> needMap, Map<String, Integer> stockMap) {
        HashMap<String, Integer> diffMap = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> needEntry : needMap.entrySet()) {
            String skuCode = needEntry.getKey();
            Integer needQuantity = needEntry.getValue();
            Integer stockQuantity = stockMap.get(skuCode);
            if (NullUtil.isNull((Object)stockQuantity)) {
                stockQuantity = 0;
            }
            if (needQuantity <= stockQuantity) continue;
            diffMap.put(skuCode, needQuantity - stockQuantity);
        }
        return diffMap;
    }

    private Map<String, Integer> computeTaskMaterial(WhWmsPrdcJobTaskVO vo) {
        HashMap<String, Integer> skuQuantiyMap = new HashMap<String, Integer>();
        if (WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE.equals(vo.getJobType())) {
            for (WhWmsPrdcJobTaskDetailVO taskDetailVO : vo.getJobTaskDetailList()) {
                skuQuantiyMap.put(taskDetailVO.getSkuCode(), taskDetailVO.getAmount().intValue());
            }
        } else if (WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT.equals(vo.getJobType())) {
            skuQuantiyMap.put(vo.getSkuCode(), vo.getAmount());
        }
        return skuQuantiyMap;
    }

    private Map<String, Float> buildTaskConsumeRecipeMaterial(WhWmsPrdcJobTaskVO vo) {
        HashMap<String, Float> skuQuantiyMap = new HashMap<String, Float>();
        if (WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE.equals(vo.getJobType())) {
            for (WhWmsPrdcJobTaskDetailVO taskDetailVO : vo.getJobTaskDetailList()) {
                skuQuantiyMap.put(taskDetailVO.getSkuCode(), taskDetailVO.getRecipeAmount());
            }
        } else if (WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT.equals(vo.getJobType())) {
            skuQuantiyMap.put(vo.getSkuCode(), Float.valueOf(1.0f));
        }
        return skuQuantiyMap;
    }

    @Deprecated
    public Boolean createJobTaskAndOccupyStock_old(WhWmsPrdcJobTaskVO vo) {
        List<WhWmsOccupyVO> kOccupyList = vo.getHistorykOccupyList();
        if (EmptyUtil.isEmpty((String)vo.getPrdcJobCode())) {
            throw new WarehouseException("", "the jobCode isnot can be null");
        }
        if (vo.getJobPlanStatus() == WhWmsPrdcJobTaskVO.WMS_PLAN_STATUS_FINISHED) {
            throw new WarehouseException("", "[" + vo.getPrdcJobCode() + "]the status of the job has been finished!");
        }
        if (EmptyUtil.isEmpty((Object)vo.getAmount())) {
            throw new WarehouseException("", "the production of quantity cannot be null!");
        }
        if (vo.getAmount() <= 0) {
            throw new WarehouseException("", "the production of quantity must be >0");
        }
        vo.setCreateTime(DateUtil.getNow());
        vo.setFinishedDefectiveAmount(0);
        vo.setFinishedGoodsAmount(0);
        vo.setStatus(WhWmsPrdcJobTaskVO.STATUS_PROCESSING);
        vo.setCode(this.createNewCode("TK"));
        List<WhWmsOccupyVO> occupyList = new ArrayList<WhWmsOccupyVO>();
        ArrayList<WhWmsSkuStockVO> stockList = new ArrayList<WhWmsSkuStockVO>();
        WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
        moveStockVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
        moveStockVO.setCreateUserId(vo.getCreateUserId());
        moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_PRODUCTION);
        moveStockVO.setReferenceCode(vo.getPrdcJobCode());
        boolean canStart = true;
        boolean ifMoveStock = false;
        HashedMap taskDetailDifferenceMap = new HashedMap();
        ArrayList<WhWmsMoveSkuVO> moveSkus = new ArrayList<WhWmsMoveSkuVO>();
        if (WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE.equals(vo.getJobType())) {
            for (WhWmsPrdcJobTaskDetailVO taskDetailVO : vo.getJobTaskDetailList()) {
                taskDetailVO.setTaskCode(vo.getCode());
                taskDetailVO.setCode(this.createNewCode("TKD"));
                List<WhWmsSkuStockVO> skuStockList = this.checkStockBeforeOccupy(vo, taskDetailVO, (Map<String, Integer>)taskDetailDifferenceMap, moveSkus, kOccupyList);
                if (EmptyUtil.isNotEmpty(skuStockList)) {
                    stockList.addAll(skuStockList);
                }
                if (taskDetailDifferenceMap.size() == 0) {
                    if (CollectionUtils.isNotEmpty(skuStockList) && moveSkus.size() == 0) {
                        for (WhWmsSkuStockVO skuStock : skuStockList) {
                            if (NumberUtil.isNullOrZero((Number)skuStock.getOccupiedAccount())) continue;
                            WhWmsOccupyVO occupyVO = new WhWmsOccupyVO();
                            occupyVO.setSkuCode(skuStock.getSkuCode());
                            occupyVO.setBarCode(skuStock.getBarCode());
                            occupyVO.setSkuStatus(skuStock.getSkuStatus());
                            occupyVO.setAmount(-((int)Math.ceil(skuStock.getOccupiedAccount())));
                            occupyVO.setStatus(WhWmsOccupyVO.OCCUPIED);
                            occupyVO.setReceiptsNo(vo.getCode());
                            occupyVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
                            occupyVO.setType(WhWmsOccupyVO.TYPE_PRODUCTION);
                            occupyVO.setHouseType("HOUSE_TYPE_PROCESSING");
                            occupyVO.setOriShelvesCode(skuStock.getShelvesCode());
                            occupyList.add(occupyVO);
                            boolean bl = canStart = canStart;
                            ifMoveStock = ifMoveStock;
                        }
                        continue;
                    }
                    if (!CollectionUtils.isNotEmpty(skuStockList) || !CollectionUtils.isNotEmpty(moveSkus)) continue;
                    if (!ifMoveStock) {
                        // empty if block
                    }
                    ifMoveStock = true;
                    if (canStart) {
                        // empty if block
                    }
                    canStart = false;
                    continue;
                }
                if (taskDetailDifferenceMap.size() != 0) {
                    ifMoveStock = false;
                    canStart = false;
                    continue;
                }
                canStart = false;
                ifMoveStock = false;
            }
        } else if (WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT.equals(vo.getJobType())) {
            for (WhWmsPrdcJobTaskDetailVO taskDetailVO : vo.getJobTaskDetailList()) {
                taskDetailVO.setTaskCode(vo.getCode());
                taskDetailVO.setCode(this.createNewCode("TKD"));
            }
            List<WhWmsSkuStockVO> skuStockList = this.checkStockBeforeOccupy(vo, null, (Map<String, Integer>)taskDetailDifferenceMap, moveSkus, kOccupyList);
            if (EmptyUtil.isNotEmpty(skuStockList)) {
                stockList.addAll(skuStockList);
            }
            if (CollectionUtils.isNotEmpty(skuStockList) && moveSkus.size() == 0 && taskDetailDifferenceMap.size() == 0) {
                for (WhWmsSkuStockVO skuStock : skuStockList) {
                    WhWmsOccupyVO occupyVO = new WhWmsOccupyVO();
                    occupyVO.setSkuCode(vo.getSkuCode());
                    occupyVO.setBarCode(skuStock.getBarCode());
                    occupyVO.setSkuStatus(skuStock.getSkuStatus());
                    occupyVO.setAmount(-((int)Math.ceil(skuStock.getOccupiedAccount())));
                    occupyVO.setStatus(WhWmsOccupyVO.OCCUPIED);
                    occupyVO.setReceiptsNo(vo.getCode());
                    occupyVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
                    occupyVO.setType(WhWmsOccupyVO.TYPE_PRODUCTION);
                    occupyVO.setHouseType("HOUSE_TYPE_PROCESSING");
                    occupyVO.setOriShelvesCode(skuStock.getShelvesCode());
                    occupyList.add(occupyVO);
                    canStart = true;
                    ifMoveStock = false;
                }
            } else if (CollectionUtils.isNotEmpty(skuStockList) && CollectionUtils.isNotEmpty(moveSkus)) {
                ifMoveStock = true;
                canStart = false;
            } else {
                ifMoveStock = false;
                canStart = false;
            }
        }
        if (canStart && !ifMoveStock) {
            this.whWmsOccupyService.wmsBatchOccupy(occupyList);
            int insertTask = this.whWmsPrdcJobTaskMapper.insert(vo);
            if (insertTask <= 0) {
                throw new WarehouseException("", "insert data failed!");
            }
            this.whWmsPrdcJobTaskDetailService.newTaskDetail(vo.getJobTaskDetailList());
            return true;
        }
        if (canStart && ifMoveStock && EmptyUtil.isNotEmpty(moveSkus)) {
            moveStockVO.setMoveSkuList(moveSkus);
            this.whWmsMoveStockService.newMoveStock(moveStockVO);
            vo.setMoveStockCode(moveStockVO.getCode());
            return this.createJobTaskAndOccupyStock(vo);
        }
        if (!canStart && ifMoveStock && EmptyUtil.isNotEmpty(moveSkus)) {
            occupyList = this.computeOccupyList(stockList, vo);
            this.reComputeOccupyList(occupyList, kOccupyList);
            vo.setHistorykOccupyList(kOccupyList);
            moveStockVO.setMoveSkuList(moveSkus);
            this.whWmsMoveStockService.newMoveStock(moveStockVO);
            vo.setMoveStockCode(moveStockVO.getCode());
        } else if (!canStart && !ifMoveStock) {
            this.sendOutOfStockEmil(vo.getAmount(), vo.getPhysicalWarehouseCode(), vo.getPrdcJobCode(), (Map<String, Integer>)taskDetailDifferenceMap);
        }
        return false;
    }

    public List<WhWmsSkuStockVO> checkStockBeforeOccupy(WhWmsPrdcJobTaskVO task, WhWmsPrdcJobTaskDetailVO taskDetail, Map<String, Integer> taskDetailDifferenceMap, List<WhWmsMoveSkuVO> moveSkus, List<WhWmsOccupyVO> kOccupyList) {
        int taskDetailNeedAmount = 0;
        ArrayList<WhWmsSkuStockVO> skuStockList = new ArrayList<WhWmsSkuStockVO>();
        WhWmsSkuStockVO skuStockVOCond = new WhWmsSkuStockVO();
        skuStockVOCond.setPhysicalWarehouseCode(task.getPhysicalWarehouseCode());
        skuStockVOCond.setSkuStatus(task.getSkuStatus());
        if (task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE) {
            taskDetailNeedAmount = taskDetail.getAmount().intValue();
            skuStockVOCond.setSkuCode(taskDetail.getSkuCode());
            skuStockVOCond.setSkuCodeLike(taskDetail.getSkuCode());
        } else if (task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT) {
            taskDetailNeedAmount = task.getAmount();
            skuStockVOCond.setSkuCode(task.getSkuCode());
            skuStockVOCond.setSkuCodeLike(task.getSkuCode());
        }
        int difference = taskDetailNeedAmount;
        ArrayList<String> houseTypeList = new ArrayList<String>();
        houseTypeList.add("HOUSE_TYPE_PROCESSING");
        houseTypeList.addAll(this.whWmsWarehouseAreaService.getHouseTypesByType("NORMAL"));
        skuStockVOCond.setHouseTypes(houseTypeList);
        List<WhWmsSkuStockVO> totalAreaStocks = this.whWmsSkuStockService.getWmsSkuStocksByCond(skuStockVOCond);
        if (CollectionUtils.isEmpty(totalAreaStocks)) {
            if (task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE) {
                taskDetailDifferenceMap.put(taskDetail.getSkuCode(), difference);
            }
            if (task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT) {
                taskDetailDifferenceMap.put(task.getSkuCode(), difference);
            }
            return Collections.EMPTY_LIST;
        }
        Integer totalAvailStock = 0;
        for (WhWmsSkuStockVO skuStock : totalAreaStocks) {
            if ((totalAvailStock = Integer.valueOf(totalAvailStock + skuStock.getAvailableAmount())).compareTo(taskDetailNeedAmount) < 0) continue;
            break;
        }
        if (totalAvailStock.compareTo(taskDetailNeedAmount) < 0) {
            difference = taskDetailNeedAmount - totalAvailStock;
            if (task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE) {
                taskDetailDifferenceMap.put(taskDetail.getSkuCode(), difference);
            }
            if (task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT) {
                taskDetailDifferenceMap.put(task.getSkuCode(), difference);
            }
            return Collections.EMPTY_LIST;
        }
        skuStockVOCond.setHouseTypes(null);
        block1: for (String houseType : houseTypeList) {
            int pagenum = 100;
            int currpage = 1;
            skuStockVOCond.setPagenum(pagenum);
            skuStockVOCond.setCurrpage(currpage);
            if (difference == 0) break;
            skuStockVOCond.setHouseType(houseType);
            List<WhWmsSkuStockVO> areaStocks = this.whWmsSkuStockService.getWmsSkuStocksByCond(skuStockVOCond);
            if (CollectionUtils.isEmpty(areaStocks)) continue;
            if (areaStocks.size() != 1) {
                throw new WarehouseException("", "error,the result isnot unique!");
            }
            WhWmsSkuStockVO areaStock = areaStocks.get(0);
            if (!houseType.equals("HOUSE_TYPE_PROCESSING") && areaStock.getAvailableAmount() <= 0) continue;
            do {
                WhWmsHouseShelvesVO houseShelvesVO;
                Integer areaAvailableAmount;
                WhWmsHouseShelvesVO houseShelves;
                skuStockVOCond.setCurrpage(currpage);
                areaStocks = this.whWmsSkuStockService.getWmsSkuStocksByShelvesCond(skuStockVOCond);
                this.reComputeSkuStockList(areaStocks, kOccupyList);
                if (CollectionUtils.isEmpty(areaStocks)) continue block1;
                if (areaStock.getAvailableAmount() <= 0) continue;
                if (areaStock.getAvailableAmount().compareTo(difference) < 0 && difference > 0 && areaStock.getAvailableAmount() > 0) {
                    if (CollectionUtils.isEmpty(areaStocks)) continue block1;
                    for (WhWmsSkuStockVO skuStock : areaStocks) {
                        houseShelves = this.whWmsHouseShelvesService.getHouseShelvesByCode(skuStock.getShelvesCode());
                        skuStock.setHouseType(houseShelves.getHouseType());
                        if (!WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelves.getShelvesType()) && !WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelves.getShelvesType()) && !houseType.equals("HOUSE_TYPE_PROCESSING") || (areaAvailableAmount = skuStock.getAvailableAmount()) <= 0) continue;
                        skuStock.setOccupiedAccount(areaAvailableAmount);
                        skuStockList.add(skuStock);
                        difference -= areaAvailableAmount.intValue();
                        if (houseType.equals("HOUSE_TYPE_PROCESSING") || skuStock.getOccupiedAccount() == 0 || EmptyUtil.isEmpty((Object)(houseShelvesVO = this.whWmsHouseShelvesService.getHouseShelvesByCode(skuStock.getShelvesCode()))) || !WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelvesVO.getShelvesType()) && !WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelvesVO.getShelvesType())) continue;
                        moveSkus.add(this.buildMoveSku(houseType, task, skuStock));
                    }
                } else if (areaStock.getAvailableAmount().compareTo(difference) >= 0 && difference > 0) {
                    Collections.sort(areaStocks, new Comparator<WhWmsSkuStockVO>(){

                        @Override
                        public int compare(WhWmsSkuStockVO vo1, WhWmsSkuStockVO vo2) {
                            return vo1.getAvailableAmount().compareTo(vo2.getAvailableAmount());
                        }
                    });
                    for (WhWmsSkuStockVO skuStock : areaStocks) {
                        houseShelves = this.whWmsHouseShelvesService.getHouseShelvesByCode(skuStock.getShelvesCode());
                        skuStock.setHouseType(houseShelves.getHouseType());
                        if (!WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelves.getShelvesType()) && !WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelves.getShelvesType()) && !houseType.equals("HOUSE_TYPE_PROCESSING")) continue;
                        areaAvailableAmount = skuStock.getAvailableAmount();
                        if (areaAvailableAmount.compareTo(difference) >= 0) {
                            skuStock.setOccupiedAccount(difference);
                            skuStockList.add(skuStock);
                            difference = 0;
                            if (!houseType.equals("HOUSE_TYPE_PROCESSING") && skuStock.getOccupiedAccount() != 0) {
                                houseShelvesVO = this.whWmsHouseShelvesService.getHouseShelvesByCode(skuStock.getShelvesCode());
                                if (EmptyUtil.isEmpty((Object)houseShelvesVO)) continue;
                                if (WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelvesVO.getShelvesType()) || WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelvesVO.getShelvesType())) {
                                    moveSkus.add(this.buildMoveSku(houseType, task, skuStock));
                                }
                            }
                            return skuStockList;
                        }
                        if (areaAvailableAmount <= 0) continue;
                        skuStock.setOccupiedAccount(areaAvailableAmount);
                        skuStockList.add(skuStock);
                        difference -= areaAvailableAmount.intValue();
                        if (houseType.equals("HOUSE_TYPE_PROCESSING") || skuStock.getOccupiedAccount() == 0 || EmptyUtil.isEmpty((Object)(houseShelvesVO = this.whWmsHouseShelvesService.getHouseShelvesByCode(skuStock.getShelvesCode()))) || !WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelvesVO.getShelvesType()) && !WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelvesVO.getShelvesType())) continue;
                        moveSkus.add(this.buildMoveSku(houseType, task, skuStock));
                    }
                } else {
                    throw new WarehouseException("", "error,the difference is abnormal");
                }
                ++currpage;
            } while (areaStocks.size() == pagenum);
        }
        if (difference > 0) {
            taskDetailDifferenceMap.put(taskDetail.getSkuCode(), difference);
        }
        return Collections.EMPTY_LIST;
    }

    private List<WhWmsOccupyVO> computeOccupyList(List<WhWmsSkuStockVO> skuStockList, WhWmsPrdcJobTaskVO vo) {
        ArrayList<WhWmsOccupyVO> occupyList = new ArrayList<WhWmsOccupyVO>();
        if (EmptyUtil.isEmpty(skuStockList)) {
            return occupyList;
        }
        for (WhWmsSkuStockVO skuStock : skuStockList) {
            if (!skuStock.getHouseType().equals("HOUSE_TYPE_PROCESSING")) continue;
            WhWmsOccupyVO occupyVO = new WhWmsOccupyVO();
            occupyVO.setSkuCode(skuStock.getSkuCode());
            occupyVO.setBarCode(skuStock.getBarCode());
            occupyVO.setSkuStatus(skuStock.getSkuStatus());
            occupyVO.setAmount(-((int)Math.ceil(skuStock.getOccupiedAccount())));
            occupyVO.setStatus(WhWmsOccupyVO.OCCUPIED);
            occupyVO.setReceiptsNo(null);
            occupyVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
            occupyVO.setType(WhWmsOccupyVO.TYPE_PRODUCTION);
            occupyVO.setHouseType("HOUSE_TYPE_PROCESSING");
            occupyVO.setOriShelvesCode(skuStock.getShelvesCode());
            occupyList.add(occupyVO);
        }
        return occupyList;
    }

    private void reComputeOccupyList(List<WhWmsOccupyVO> nowkOccupyList, List<WhWmsOccupyVO> oldkOccupyList) {
        if (EmptyUtil.isEmpty(nowkOccupyList)) {
            return;
        }
        if (NullUtil.isNull(oldkOccupyList)) {
            oldkOccupyList = new ArrayList<WhWmsOccupyVO>();
        }
        for (WhWmsOccupyVO n : nowkOccupyList) {
            boolean exist = false;
            for (WhWmsOccupyVO o : oldkOccupyList) {
                if (!o.getSkuCode().equals(n.getSkuCode()) || !o.getBarCode().equals(n.getBarCode()) || !o.getSkuStatus().equals(n.getSkuStatus()) || !o.getOriShelvesCode().equals(n.getOriShelvesCode()) || !o.getPhysicalWarehouseCode().equals(n.getPhysicalWarehouseCode())) continue;
                exist = true;
                o.setAmount(o.getAmount() + n.getAmount());
                break;
            }
            if (exist) continue;
            oldkOccupyList.add(n);
        }
    }

    private void reComputeSkuStockList(List<WhWmsSkuStockVO> areaStockList, List<WhWmsOccupyVO> kOccupyList) {
        if (EmptyUtil.isEmpty(areaStockList) || EmptyUtil.isEmpty(kOccupyList)) {
            return;
        }
        for (WhWmsSkuStockVO areaStock : areaStockList) {
            this.reComputeSkuStock(areaStock, kOccupyList);
        }
    }

    private void reComputeSkuStock(WhWmsSkuStockVO areaStock, List<WhWmsOccupyVO> kOccupyList) {
        if (EmptyUtil.isEmpty(kOccupyList) || NullUtil.isNull((Object)areaStock)) {
            return;
        }
        for (WhWmsOccupyVO occupy : kOccupyList) {
            if (!occupy.getSkuCode().equals(areaStock.getSkuCode()) || !occupy.getBarCode().equals(areaStock.getBarCode()) || !occupy.getSkuStatus().equals(areaStock.getSkuStatus()) || !occupy.getOriShelvesCode().equals(areaStock.getShelvesCode())) continue;
            areaStock.setAvailableAmount(areaStock.getAvailableAmount() + occupy.getAmount());
            break;
        }
    }

    @Override
    @Transactional
    public Boolean updateJobTask(WhWmsPrdcJobTaskVO vo) {
        int update = this.whWmsPrdcJobTaskMapper.updateByPrimaryKey(vo);
        if (update < 0) {
            throw new WarehouseException("", "update data failed");
        }
        return null;
    }

    @Override
    public Pagination<WhWmsPrdcJobTaskVO> getPrdcTaskByCondPage(WhWmsPrdcJobTaskCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int count = this.whWmsPrdcJobTaskMapper.getCountByCond(cond);
        page.setRecord(Integer.valueOf(count));
        if (NumberUtil.isNullOrZero((Number)count)) {
            return null;
        }
        page.setResultList(BeanUtil.buildListFrom(this.whWmsPrdcJobTaskMapper.getPrdcJobTaskByCondPage(cond), WhWmsPrdcJobTaskVO.class));
        return page;
    }

    @Override
    public int getPrdcJobMaxTask(WhWmsPrdcJobTaskVO vo) {
        Map<String, Float> skuQuantityConsumeMap = this.buildTaskConsumeRecipeMaterial(vo);
        List<String> skuCodes = Arrays.asList(skuQuantityConsumeMap.keySet().toArray(new String[skuQuantityConsumeMap.size()]));
        List<WhWmsSkuBarcode> skuBarcodeList = null;
        if (EmptyUtil.isNotEmpty(skuCodes)) {
            skuBarcodeList = this.whWmsSkuBarcodeService.findBarCodesForPickSkuStock(skuCodes);
        }
        if (NullUtil.isNull(skuBarcodeList)) {
            skuBarcodeList = new ArrayList<WhWmsSkuBarcode>();
        }
        HashMap<String, WhWmsSkuBarcode> barcodeMap = new HashMap<String, WhWmsSkuBarcode>();
        ArrayList<String> barCodes = new ArrayList<String>();
        for (WhWmsSkuBarcode barcode : skuBarcodeList) {
            barCodes.add(barcode.getBarCode());
            barcodeMap.put(barcode.getBarCode(), barcode);
        }
        ArrayList<WhWmsSkuStockVO> canUseShelvesStockList = new ArrayList<WhWmsSkuStockVO>();
        if (EmptyUtil.isNotEmpty(barCodes)) {
            WhWmsSkuStockVO stockCond = new WhWmsSkuStockVO();
            stockCond.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
            stockCond.setSkuStatus(vo.getSkuStatus());
            stockCond.setBarCodeList(barCodes);
            stockCond.setHouseTypes(Collections.singletonList("HOUSE_TYPE_PROCESSING"));
            List<WhWmsSkuStockVO> shelvesStockList = this.whWmsSkuStockService.findWmsSkuAvailableAccount(stockCond, true);
            if (EmptyUtil.isNotEmpty(shelvesStockList)) {
                canUseShelvesStockList.addAll(shelvesStockList);
            }
            Map<String, WhWmsWarehouseArea> areaMap = this.whWmsWarehouseAreaService.getAreaHouseMapByType("NORMAL");
            List<String> houseTypes = Arrays.asList(areaMap.keySet().toArray(new String[areaMap.size()]));
            stockCond.setHouseTypes(houseTypes);
            ArrayList<Integer> shelvesTypeList = new ArrayList<Integer>();
            shelvesTypeList.add(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING);
            shelvesTypeList.add(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING);
            stockCond.setShelvesTypeList(shelvesTypeList);
            shelvesStockList = this.whWmsSkuStockService.findWmsSkuAvailableAccount(stockCond, true);
            if (EmptyUtil.isNotEmpty(shelvesStockList)) {
                canUseShelvesStockList.addAll(shelvesStockList);
            }
        }
        Map<String, Integer> stockSkuQuantityMap = this.groupStockBySku(canUseShelvesStockList);
        Integer min = Integer.MAX_VALUE;
        for (Map.Entry<String, Float> entry : skuQuantityConsumeMap.entrySet()) {
            String skuCode = entry.getKey();
            Float materialAmount = entry.getValue();
            Integer totalStockAmount = stockSkuQuantityMap.get(skuCode);
            log.error("------skuCode:" + skuCode + ";totalStockAmount:" + totalStockAmount + ";materialAmount:" + materialAmount + ";Math.ceil(totalStockAmount/materialAmount):" + Math.ceil((float)totalStockAmount.intValue() / materialAmount.floatValue()));
            if (NullUtil.isNull((Object)totalStockAmount) || totalStockAmount < 0) {
                totalStockAmount = 0;
            }
            min = Math.min(min, (int)Math.ceil((float)totalStockAmount.intValue() / materialAmount.floatValue()));
        }
        return min;
    }

    @Deprecated
    public int getPrdcJobMaxTask_old(WhWmsPrdcJobTaskVO vo) {
        ArrayList<Integer> maxInts = new ArrayList<Integer>();
        List<WhWmsPrdcJobTaskDetailVO> taskDetails = vo.getJobTaskDetailList();
        if (vo.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE) {
            for (WhWmsPrdcJobTaskDetailVO taskDetail : taskDetails) {
                WhWmsSkuStockVO skuStockVOCond = new WhWmsSkuStockVO();
                skuStockVOCond.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
                skuStockVOCond.setSkuCode(taskDetail.getSkuCode());
                skuStockVOCond.setSkuCodeLike(taskDetail.getSkuCode());
                skuStockVOCond.setSkuStatus(vo.getSkuStatus());
                ArrayList<String> houseTypeList = new ArrayList<String>();
                houseTypeList.add("HOUSE_TYPE_PROCESSING");
                houseTypeList.addAll(this.whWmsWarehouseAreaService.getHouseTypesByType("NORMAL"));
                skuStockVOCond.setHouseTypes(houseTypeList);
                List<WhWmsSkuStockVO> totalStocks = this.whWmsSkuStockService.getWmsSkuStocksByCond(skuStockVOCond);
                if (CollectionUtils.isEmpty(totalStocks)) {
                    return NumberUtils.INTEGER_ZERO;
                }
                List<WhWmsSkuStockVO> totalAreaStocks = this.whWmsSkuStockService.getWmsSkuStocksByShelvesCond(skuStockVOCond);
                if (CollectionUtils.isEmpty(totalAreaStocks)) {
                    return NumberUtils.INTEGER_ZERO;
                }
                int totalAvailableAmount = 0;
                for (WhWmsSkuStockVO skustock : totalAreaStocks) {
                    WhWmsHouseShelvesVO houseShelvesVO = this.whWmsHouseShelvesService.getHouseShelvesByCode(skustock.getShelvesCode());
                    if (EmptyUtil.isEmpty((Object)houseShelvesVO) || !"HOUSE_TYPE_PROCESSING".equals(houseShelvesVO.getHouseType()) && !WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelvesVO.getShelvesType()) && !WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelvesVO.getShelvesType()) || skustock.getAvailableAmount() == 0) continue;
                    totalAvailableAmount += skustock.getAvailableAmount().intValue();
                }
                int max = (int)Math.floor((float)totalAvailableAmount / taskDetail.getRecipeAmount().floatValue());
                maxInts.add(max);
            }
            int min = (Integer)maxInts.get(0);
            int max = (Integer)maxInts.get(0);
            for (int j = 0; j < maxInts.size(); ++j) {
                if ((Integer)maxInts.get(j) > max) {
                    max = (Integer)maxInts.get(j);
                }
                if ((Integer)maxInts.get(j) >= min) continue;
                min = (Integer)maxInts.get(j);
            }
            if (min < 0) {
                return NumberUtils.INTEGER_ZERO;
            }
            return min;
        }
        if (vo.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT) {
            WhWmsSkuStockVO skuStockVOCond = new WhWmsSkuStockVO();
            skuStockVOCond.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
            skuStockVOCond.setSkuCode(vo.getSkuCode());
            skuStockVOCond.setSkuCodeLike(vo.getSkuCode());
            skuStockVOCond.setSkuStatus(vo.getSkuStatus());
            ArrayList<String> houseTypeList = new ArrayList<String>();
            houseTypeList.add("HOUSE_TYPE_PROCESSING");
            houseTypeList.addAll(this.whWmsWarehouseAreaService.getHouseTypesByType("NORMAL"));
            skuStockVOCond.setHouseTypes(houseTypeList);
            List<WhWmsSkuStockVO> totalStocks = this.whWmsSkuStockService.getWmsSkuStocksByCond(skuStockVOCond);
            if (CollectionUtils.isEmpty(totalStocks)) {
                return NumberUtils.INTEGER_ZERO;
            }
            List<WhWmsSkuStockVO> totalAreaStocks = this.whWmsSkuStockService.getWmsSkuStocksByShelvesCond(skuStockVOCond);
            if (CollectionUtils.isNotEmpty(totalAreaStocks)) {
                int totalAvailableAmount = 0;
                for (WhWmsSkuStockVO skustock : totalAreaStocks) {
                    WhWmsHouseShelvesVO houseShelvesVO = this.whWmsHouseShelvesService.getHouseShelvesByCode(skustock.getShelvesCode());
                    if (EmptyUtil.isEmpty((Object)houseShelvesVO) || !"HOUSE_TYPE_PROCESSING".equals(houseShelvesVO.getHouseType()) && !WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelvesVO.getShelvesType()) && !WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelvesVO.getShelvesType()) || skustock.getAvailableAmount() == 0) continue;
                    totalAvailableAmount += skustock.getAvailableAmount().intValue();
                }
                if (totalAvailableAmount < 0) {
                    return NumberUtils.INTEGER_ZERO;
                }
                return totalAvailableAmount;
            }
        }
        return NumberUtils.INTEGER_ZERO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public Boolean finishTaskAndUpdateStock(WhWmsPrdcJobTaskVO vo, Long userId) throws Exception {
        if (EmptyUtil.isEmpty((String)vo.getPrdcJobCode())) {
            throw new WarehouseException("", "the jobCode isnot can be null");
        }
        if (vo.getJobPlanStatus() == WhWmsPrdcJobTaskVO.WMS_PLAN_STATUS_FINISHED) {
            throw new WarehouseException("", "[" + vo.getPrdcJobCode() + "]the status of the job has been finished!");
        }
        WhWmsOccupyVO occupyCond = new WhWmsOccupyVO();
        occupyCond.setType(WhWmsOccupyVO.TYPE_PRODUCTION);
        occupyCond.setReceiptsNo(vo.getCode());
        occupyCond.setHouseType("HOUSE_TYPE_PROCESSING");
        occupyCond.setStatus(WhWmsOccupyVO.OCCUPIED);
        occupyCond.setSkuStatus(vo.getSkuStatus());
        occupyCond.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
        List<WhWmsOccupyVO> occupyList = this.whWmsOccupyService.getWmsOccupyByCond(occupyCond);
        this.releaseWmsOccupy(occupyCond);
        List<WhWmsSkuStockRecordVO> updateStocks = this.buildUpdateStockDatas(vo, userId, occupyList);
        List<WhWmsSkuStockRecordVO> typeInSkuStocks = this.filterSkuStocks(updateStocks, WhCommand.TYPE_PRODUCE_IN);
        List<WhWmsSkuStockRecordVO> typeOutSkuStocks = this.filterSkuStocks(updateStocks, WhCommand.TYPE_PRODUCE_OUT);
        String lockKey = "lock:wms:finishTaskAndUpdateStock" + vo.getCode();
        try {
            WhWmsSkuBarcodeVO skuBarcodeVO;
            Boolean getLock = this.redisDistributLock.tryLock(lockKey, 3L, TimeUnit.MINUTES);
            if (!getLock.booleanValue()) {
                log.info("\u83b7\u53d6\u9501\u5931\u8d25  " + lockKey);
                throw new WarehouseException("WH0001", "\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            this.updateWmsStocks(typeOutSkuStocks);
            this.updateWmsPrdcJobTask(vo, userId);
            vo.setCreateUserId(userId);
            this.updateScmStock(vo);
            String commandCode = this.createCommandThenRecordWaitPutAway(vo, userId, typeInSkuStocks);
            vo.setCommandCode(commandCode);
            String moveCode = this.moveSkuForTaskFinish(vo, userId, typeInSkuStocks);
            vo.setMoveStockCode(moveCode);
            if (EmptyUtil.isNotEmpty((String)moveCode)) {
                this.whWmsMoveStockService.doMoveStockAndReleaseOccupyAndFinish(moveCode, userId);
                String batchNo = this.startPutAway(commandCode, vo.getPhysicalWarehouseCode());
                vo.setBatchNo(batchNo);
            }
            if (vo.isMakeNewBarcode()) {
                this.recordPrdcMaterialDetail(vo, typeInSkuStocks, typeOutSkuStocks);
            }
            if (EmptyUtil.isNotEmpty((Object)vo.getBcId()) && EmptyUtil.isNotEmpty((Object)(skuBarcodeVO = this.whWmsSkuBarcodeService.findById(vo.getBcId()))) && EmptyUtil.isEmpty((String)skuBarcodeVO.getRefCode())) {
                skuBarcodeVO.setRefCode(vo.getPrdcJobCode());
                if (EmptyUtil.isEmpty((Object)skuBarcodeVO.getFirstInDate())) {
                    skuBarcodeVO.setFirstInDate(DateUtil.getNow());
                }
                this.whWmsSkuBarcodeService.update(skuBarcodeVO);
            }
        }
        finally {
            this.redisDistributLock.unLock(lockKey);
        }
        return true;
    }

    private void recordPrdcMaterialDetail(WhWmsPrdcJobTaskVO taskVO, List<WhWmsSkuStockRecordVO> typeInSkuStocks, List<WhWmsSkuStockRecordVO> typeOutSkuStocks) {
        ArrayList<WhWmsPrdcMaterialDetail> prdcMaterialDetails = new ArrayList<WhWmsPrdcMaterialDetail>();
        WhWmsSkuStockRecordVO prodSkuInfo = typeInSkuStocks.get(0);
        for (WhWmsSkuStockRecordVO materialVO : typeOutSkuStocks) {
            WhWmsPrdcMaterialDetail prdcMaterialDetail = new WhWmsPrdcMaterialDetail();
            prdcMaterialDetail.setMaterialSku(materialVO.getSkuCode());
            prdcMaterialDetail.setProdSku(prodSkuInfo.getSkuCode());
            prdcMaterialDetail.setMaterialBarcode(materialVO.getBarCode());
            prdcMaterialDetail.setProdBarcode(prodSkuInfo.getBarCode());
            prdcMaterialDetail.setSkuStatus(materialVO.getSkuStatus());
            prdcMaterialDetail.setRealAmount(Math.abs(materialVO.getQuantity()));
            prdcMaterialDetail.setPrdcTaskCode(taskVO.getCode());
            prdcMaterialDetails.add(prdcMaterialDetail);
        }
        this.whWmsPrdcMaterialDetailService.batchCreate(prdcMaterialDetails);
    }

    private String startPutAway(String commandCode, String physicalWarehouseCode) {
        List<WhWmsWaitPutawayVO> waitPutawayVOs = this.whWmsWaitPutawayService.findWmsWaitPutawayByReceiptsNo(commandCode);
        if (EmptyUtil.isEmpty(waitPutawayVOs)) {
            return null;
        }
        WhWmsWaitPutawayVO waitPutawayVO = new WhWmsWaitPutawayVO();
        waitPutawayVO.setPhysicalWarehouseCode(physicalWarehouseCode);
        ArrayList<WhWmsStartPutawayVO> startPutList = new ArrayList<WhWmsStartPutawayVO>();
        for (WhWmsWaitPutawayVO vo : waitPutawayVOs) {
            WhWmsStartPutawayVO tmp = new WhWmsStartPutawayVO();
            tmp.setId(vo.getId());
            tmp.setReceiptsNo(vo.getReceiptsNo());
            tmp.setBarCode(vo.getBarCode());
            tmp.setSkuCode(vo.getSkuCode());
            tmp.setSkuStatus(vo.getSkuStatus());
            tmp.setReceiveAmount(vo.getReceiveAmount());
            Map<String, Object> skuInfo = this.whWmsPrdcJobTaskMapper.getPcsSkuInfoBySkuCode(vo.getSkuCode());
            if (skuInfo == null) {
                throw new WarehouseException("WH0001", vo.getSkuCode() + "\u4e0d\u5b58\u5728");
            }
            Integer storageType = EmptyUtil.isEmpty((Object)skuInfo.get("storageType")) ? 1 : Integer.parseInt(skuInfo.get("storageType").toString());
            tmp.setStorageType(storageType);
            startPutList.add(tmp);
        }
        waitPutawayVO.setStartPutList(startPutList);
        return this.whWmsWaitPutawayService.startPutaway(waitPutawayVO);
    }

    private String createCommandThenRecordWaitPutAway(WhWmsPrdcJobTaskVO vo, Long userId, List<WhWmsSkuStockRecordVO> inUpdateStocks) throws Exception {
        String commandCode = null;
        HashMap<String, String> skuAndBarcodeMap = new HashMap<String, String>();
        List<WhCommandSku> commandSkus = this.buildSkuCommandList(inUpdateStocks, skuAndBarcodeMap);
        skuAndBarcodeMap.put(vo.getSkuCode(), vo.getBarcode());
        WhWarehouse whWarehouse = this.whInfoService.findDefaultInNondefectiveWarehouseByPhyWhCode(vo.getPhysicalWarehouseCode());
        if (EmptyUtil.isNotEmpty((Object)whWarehouse)) {
            if (commandSkus != null && !commandSkus.isEmpty()) {
                WhCommand whCommand = new WhCommand();
                whCommand.setReferenceCode(vo.getCode());
                whCommand.setWarehouseCode(whWarehouse.getCode());
                whCommand.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
                whCommand.setInOutType(WhCommand.TYPE_PRODUCE_IN);
                whCommand.setWhCommandSkuList(commandSkus);
                this.whCommandService.createCommand(whCommand);
                commandCode = whCommand.getCode();
                WhReceiveShelvesVO receiveShelvesVO = new WhReceiveShelvesVO();
                receiveShelvesVO.setWhCommandId(whCommand.getId().intValue());
                receiveShelvesVO.setWhCmdCode(whCommand.getCode());
                receiveShelvesVO.setOperatorId(userId.intValue());
                receiveShelvesVO.setReferenceCode(vo.getCode());
                receiveShelvesVO.setWhInType(WhCommand.TYPE_PRODUCE_IN);
                List<WhQualityControlVO> qcVoList = this.buildQualityControlDatas(vo, skuAndBarcodeMap);
                receiveShelvesVO.setQcList(qcVoList);
                receiveShelvesVO.setExistsBarcode(true);
                this.whCommandService.qualityControl(receiveShelvesVO, "HOUSE_TYPE_PROCESSING");
            }
        } else {
            throw new WarehouseException("WH0001", "\u4e0a\u67b6\u5931\u8d25\uff0c\u627e\u4e0d\u5230[" + vo.getPhysicalWarehouseCode() + "]\u5bf9\u5e94\u7684\u9ed8\u8ba4\u5165\u5e93\u826f\u54c1\u4ed3");
        }
        return commandCode;
    }

    private List<WhQualityControlVO> buildQualityControlDatas(WhWmsPrdcJobTaskVO vo, Map<String, String> skuAndBarcodeMap) {
        ArrayList<WhQualityControlVO> qcVoList = new ArrayList<WhQualityControlVO>();
        if (WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE == vo.getJobType()) {
            WhQualityControlVO qc = new WhQualityControlVO();
            qc.setQcSku(vo.getSkuCode());
            qc.setQcProdDate(vo.getProductDate());
            qc.setQcExpirationDate(vo.getExpirationDate());
            qc.setNondefectiveQuantity(0);
            qc.setDefectiveQuantity(0);
            qc.setSampleQuantity(0);
            if (vo.getFinishedGoodsAmount() != null && vo.getFinishedGoodsAmount() > 0) {
                qc.setNondefectiveQuantity(vo.getFinishedGoodsAmount());
            }
            if (vo.getFinishedDefectiveAmount() != null && vo.getFinishedDefectiveAmount() > 0) {
                qc.setDefectiveQuantity(vo.getFinishedDefectiveAmount());
            }
            qc.setBarCode(skuAndBarcodeMap.get(vo.getSkuCode()));
            qcVoList.add(qc);
        } else if (WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT == vo.getJobType()) {
            Integer amount = vo.getFinishedGoodsAmount();
            List<WhWmsPrdcJobTaskDetailVO> jobTaskDetailList = vo.getJobTaskDetailList();
            if (EmptyUtil.isNotEmpty(jobTaskDetailList) && amount > 0) {
                for (WhWmsPrdcJobTaskDetailVO taskDetailVO : jobTaskDetailList) {
                    Integer defectiveQuantity;
                    if (taskDetailVO.getMaterialType() == null || !WhWmsPrdcJobTaskDetailVO.MATERIALTYPE_MAIN.equals(taskDetailVO.getMaterialType())) continue;
                    WhQualityControlVO qc = new WhQualityControlVO();
                    qc.setQcSku(taskDetailVO.getSkuCode());
                    qc.setQcProdDate(taskDetailVO.getProductDate());
                    qc.setQcExpirationDate(taskDetailVO.getExpirationDate());
                    qc.setNondefectiveQuantity(0);
                    qc.setDefectiveQuantity(0);
                    qc.setSampleQuantity(0);
                    Integer totalAmount = amount * taskDetailVO.getRecipeAmount().intValue();
                    if (taskDetailVO.getRealAmount() > 0) {
                        qc.setNondefectiveQuantity(taskDetailVO.getRealAmount());
                    }
                    if ((defectiveQuantity = Integer.valueOf(totalAmount - taskDetailVO.getRealAmount())) > 0) {
                        qc.setDefectiveQuantity(defectiveQuantity);
                    }
                    qc.setBarCode(skuAndBarcodeMap.get(taskDetailVO.getSkuCode()));
                    qcVoList.add(qc);
                }
            }
        }
        return qcVoList;
    }

    private String moveSkuForTaskFinish(WhWmsPrdcJobTaskVO vo, Long userId, List<WhWmsSkuStockRecordVO> updateStocks) {
        String moveCode = null;
        List<WhWmsSkuStockRecordVO> inStocks = updateStocks;
        if (inStocks.isEmpty()) {
            return moveCode;
        }
        ArrayList<WhWmsMoveSkuVO> moveSkus = new ArrayList<WhWmsMoveSkuVO>();
        for (WhWmsSkuStockRecordVO stock : inStocks) {
            if (stock.getQuantity() == 0) continue;
            WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
            moveSkuVO.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
            moveSkuVO.setCreateTime(new Date());
            moveSkuVO.setOriginalHouseType(stock.getHouseType());
            moveSkuVO.setTargetHouseType("HOUSE_TYPE_RECEIVE");
            moveSkuVO.setSkuStatus(stock.getSkuStatus());
            moveSkuVO.setAmount(stock.getQuantity());
            moveSkuVO.setSkuCode(stock.getSkuCode());
            moveSkuVO.setBarCode(stock.getBarCode());
            moveSkuVO.setOriginalShelvesCode(stock.getShelvesCode());
            WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
            cond.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
            cond.setHouseType("HOUSE_TYPE_RECEIVE");
            List<WhWmsHouseShelvesVO> targetShelves = this.whWmsHouseShelves.getHouseShelvesByCond(cond);
            if (CollectionUtils.isEmpty(targetShelves)) {
                throw new WarehouseException("", stock.getPhysicalWarehouseCode() + ":\u6536\u8d27\u6682\u5b58\u533a\u5e93\u4f4d\u4e0d\u5b58\u5728!");
            }
            moveSkuVO.setTargetShelvesCode(targetShelves.get(0).getCode());
            moveSkus.add(moveSkuVO);
        }
        if (moveSkus != null && !moveSkus.isEmpty()) {
            WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
            moveStockVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
            moveStockVO.setCreateUserId(vo.getCreateUserId());
            moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_PRODUCTION);
            moveStockVO.setMoveSkuList(moveSkus);
            this.whWmsMoveStockService.newMoveStock(moveStockVO);
            moveCode = moveStockVO.getCode();
        }
        return moveCode;
    }

    private void updateWmsPrdcJobTask(WhWmsPrdcJobTaskVO vo, Long userId) {
        WhWmsPrdcJobTaskVO updateJobTaskVO = new WhWmsPrdcJobTaskVO();
        updateJobTaskVO.setId(vo.getId());
        updateJobTaskVO.setFinishedGoodsAmount(vo.getFinishedGoodsAmount());
        updateJobTaskVO.setFinishedDefectiveAmount(vo.getFinishedDefectiveAmount());
        updateJobTaskVO.setStatus(WhWmsPrdcJobTaskVO.STATUS_FINISHED);
        updateJobTaskVO.setFinishedUserId(userId);
        updateJobTaskVO.setFinishedTime(DateUtil.getNow());
        if (EmptyUtil.isNotEmpty((String)vo.getMemo())) {
            updateJobTaskVO.setMemo(vo.getMemo());
        }
        this.whWmsPrdcJobTaskMapper.updateByPrimaryKeySelective(updateJobTaskVO);
        if (vo.getJobTaskDetailList() != null) {
            for (WhWmsPrdcJobTaskDetailVO taskDetailVO : vo.getJobTaskDetailList()) {
                this.whWmsPrdcJobTaskDetailService.updateTaskDetailPrimaryKeySelective(taskDetailVO);
            }
        }
    }

    private void updateWmsStocks(List<WhWmsSkuStockRecordVO> updateStocks) {
        if (updateStocks == null || updateStocks.isEmpty()) {
            return;
        }
        for (WhWmsSkuStockRecordVO skuStock : updateStocks) {
            this.whWmsSkuStockService.updateStockByCond(skuStock.getQuantity(), skuStock.getPhysicalWarehouseCode(), skuStock.getHouseType(), skuStock.getBarCode(), skuStock.getShelvesCode(), skuStock.getSkuCode(), skuStock.getSkuStatus(), skuStock.getInOutType(), skuStock.getReceiptNo(), skuStock.getCreateUserId(), null, 1);
        }
    }

    private List<WhWmsSkuStockRecordVO> buildUpdateStockDatas(WhWmsPrdcJobTaskVO vo, Long userId, List<WhWmsOccupyVO> occupyList) {
        ArrayList<WhWmsSkuStockRecordVO> updateSkuStockList = new ArrayList<WhWmsSkuStockRecordVO>();
        List<WhWmsPrdcJobTaskDetailVO> jobTaskDetailList = vo.getJobTaskDetailList();
        WhWmsHouseShelvesVO shelvesVO = this.getWhWmsHouseShelvesVO(vo);
        if (WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE.equals(vo.getJobType())) {
            ArrayList<String> materialBarcodes = new ArrayList<String>();
            if (CollectionUtils.isNotEmpty(occupyList) && CollectionUtils.isNotEmpty(jobTaskDetailList)) {
                HashMap<String, String> skuBarcodeMap = new HashMap<String, String>();
                for (WhWmsOccupyVO occupyVO : occupyList) {
                    skuBarcodeMap.put(occupyVO.getSkuCode(), occupyVO.getBarCode());
                }
                for (WhWmsPrdcJobTaskDetailVO taskDetailVO : jobTaskDetailList) {
                    List<WhWmsSkuStockRecordVO> list = this.getAssembleStockUpdate(taskDetailVO, occupyList, userId);
                    updateSkuStockList.addAll(list);
                    if (!WhWmsPrdcJobTaskDetailVO.MATERIALTYPE_MAIN.equals(taskDetailVO.getMaterialType())) continue;
                    materialBarcodes.add((String)skuBarcodeMap.get(taskDetailVO.getSkuCode()));
                }
            }
            String barCode = vo.getBarcode();
            vo.setMaterialBarcodes(materialBarcodes);
            if (vo.getFinishedGoodsAmount() != null && vo.getFinishedGoodsAmount() > 0) {
                if (EmptyUtil.isEmpty((String)barCode)) {
                    barCode = this.getBarCodeByCond(WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE, vo, null, WhCommand.TYPE_PRODUCE_IN);
                }
                WhWmsSkuStockRecordVO skuStockGoods = this.buildSkuStock(vo.getFinishedGoodsAmount(), vo.getPhysicalWarehouseCode(), shelvesVO.getHouseType(), vo.getSkuCode(), barCode, shelvesVO.getCode(), WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE, WhCommand.TYPE_PRODUCE_IN, vo.getCode(), userId);
                updateSkuStockList.add(skuStockGoods);
            }
            if (vo.getFinishedDefectiveAmount() != null && vo.getFinishedDefectiveAmount() > 0) {
                if (EmptyUtil.isEmpty((String)barCode)) {
                    barCode = this.getBarCodeByCond(WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE, vo, null, WhCommand.TYPE_PRODUCE_IN);
                }
                WhWmsSkuStockRecordVO skuStockDefective = this.buildSkuStock(vo.getFinishedDefectiveAmount(), vo.getPhysicalWarehouseCode(), shelvesVO.getHouseType(), vo.getSkuCode(), barCode, shelvesVO.getCode(), WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED, WhCommand.TYPE_PRODUCE_IN, vo.getCode(), userId);
                updateSkuStockList.add(skuStockDefective);
            }
            vo.setBarcode(barCode);
        } else if (WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT.equals(vo.getJobType())) {
            HashMap<String, WhWmsOccupyVO> skuOccupyMap = new HashMap<String, WhWmsOccupyVO>();
            List<WhWmsSkuStockRecordVO> updateStocks = this.getSplitStockUpdate(vo, occupyList, userId, skuOccupyMap);
            if (EmptyUtil.isEmpty((String)vo.getBarcode()) && EmptyUtil.isNotEmpty(skuOccupyMap.get(vo.getSkuCode()))) {
                vo.setBarcode(((WhWmsOccupyVO)skuOccupyMap.get(vo.getSkuCode())).getBarCode());
            }
            updateSkuStockList.addAll(updateStocks);
            Integer amount = vo.getFinishedGoodsAmount();
            if (jobTaskDetailList != null && amount > 0) {
                for (WhWmsPrdcJobTaskDetailVO taskDetailVO : jobTaskDetailList) {
                    if (taskDetailVO.getMaterialType() == null || !WhWmsPrdcJobTaskDetailVO.MATERIALTYPE_MAIN.equals(taskDetailVO.getMaterialType())) continue;
                    Integer totalAmount = amount * taskDetailVO.getRecipeAmount().intValue();
                    String materialBarCode = null;
                    if (taskDetailVO.getRealAmount() > 0) {
                        materialBarCode = this.getBarCodeByCond(WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT, vo, taskDetailVO, WhCommand.TYPE_PRODUCE_IN);
                        WhWmsSkuStockRecordVO skuStockGood = this.buildSkuStock(taskDetailVO.getRealAmount(), vo.getPhysicalWarehouseCode(), shelvesVO.getHouseType(), taskDetailVO.getSkuCode(), materialBarCode, shelvesVO.getCode(), WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE, WhCommand.TYPE_PRODUCE_IN, taskDetailVO.getCode(), userId);
                        updateSkuStockList.add(skuStockGood);
                    }
                    if (totalAmount - taskDetailVO.getRealAmount() <= 0) continue;
                    if (EmptyUtil.isEmpty((String)materialBarCode)) {
                        materialBarCode = EmptyUtil.isNotEmpty((Object)taskDetailVO.getProductDate()) ? this.whCommandService.getBarCode(taskDetailVO.getSkuCode(), taskDetailVO.getProductDate()) : this.getBarCodeByCond(WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT, vo, taskDetailVO, WhCommand.TYPE_PRODUCE_IN);
                    }
                    WhWmsSkuStockRecordVO skuStockBad = this.buildSkuStock(totalAmount - taskDetailVO.getRealAmount(), vo.getPhysicalWarehouseCode(), shelvesVO.getHouseType(), taskDetailVO.getSkuCode(), materialBarCode, shelvesVO.getCode(), WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED, WhCommand.TYPE_PRODUCE_IN, taskDetailVO.getCode(), userId);
                    updateSkuStockList.add(skuStockBad);
                }
            }
        }
        return updateSkuStockList;
    }

    @Override
    public WhWmsSkuBarcode findMinExpiryDateByMaterialOccupy(WhWmsPrdcJobTaskVO vo) {
        if (EmptyUtil.isEmpty((Object)vo) || CollectionUtils.isEmpty(vo.getJobTaskDetailList()) || !WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE.equals(vo.getJobType())) {
            return null;
        }
        WhWmsOccupyVO occupyCond = new WhWmsOccupyVO();
        occupyCond.setType(WhWmsOccupyVO.TYPE_PRODUCTION);
        occupyCond.setReceiptsNo(vo.getCode());
        occupyCond.setHouseType("HOUSE_TYPE_PROCESSING");
        if (vo.isOccupyFlag()) {
            occupyCond.setStatus(WhWmsOccupyVO.OCCUPIED);
        }
        occupyCond.setSkuStatus(vo.getSkuStatus());
        occupyCond.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
        List<WhWmsOccupyVO> occupyList = this.whWmsOccupyService.getWmsOccupyByCond(occupyCond);
        List<WhWmsPrdcJobTaskDetailVO> jobTaskDetailList = vo.getJobTaskDetailList();
        ArrayList<String> materialBarcodes = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(occupyList)) {
            HashMap<String, String> skuBarcodeMap = new HashMap<String, String>();
            for (WhWmsOccupyVO occupyVO : occupyList) {
                skuBarcodeMap.put(occupyVO.getSkuCode(), occupyVO.getBarCode());
            }
            for (WhWmsPrdcJobTaskDetailVO taskDetailVO : jobTaskDetailList) {
                if (!WhWmsPrdcJobTaskDetailVO.MATERIALTYPE_MAIN.equals(taskDetailVO.getMaterialType())) continue;
                materialBarcodes.add((String)skuBarcodeMap.get(taskDetailVO.getSkuCode()));
            }
        }
        if (materialBarcodes.size() > 0) {
            WhWmsSkuBarcode whWmsSkuBarcode = this.whWmsSkuBarcodeService.findMinProdOrExpiryDateByBarCodes(materialBarcodes);
            return whWmsSkuBarcode;
        }
        return null;
    }

    private String getBarcodeBySkuCanCustomize(String skuCode) {
        WhWmsSkuBarcodeVO wmsSkuBarcodeVO = this.whWmsSkuBarcodeService.findSkuInfoBySkuCode(skuCode);
        if (EmptyUtil.isEmpty((Object)wmsSkuBarcodeVO)) {
            throw new RuntimeException("[" + skuCode + "],\u5f53\u524dSKU\u4e0d\u5b58\u5728!");
        }
        if (EmptyUtil.isNotEmpty((Object)wmsSkuBarcodeVO.getCanCustomize()) && wmsSkuBarcodeVO.getCanCustomize() == 1) {
            return this.whCommandService.createBarCodeWhenNotExists(skuCode, skuCode + "_0001", 1, null);
        }
        return null;
    }

    private String getBarCodeByCond(Integer jobType, WhWmsPrdcJobTaskVO vo, WhWmsPrdcJobTaskDetailVO taskDetailVO, Integer inOutType) {
        String barCode = "";
        if (WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE.equals(jobType)) {
            String barcode = this.getBarcodeBySkuCanCustomize(vo.getSkuCode());
            if (barcode != null) {
                return barcode;
            }
            WhQualityControlVO qcCond = new WhQualityControlVO();
            qcCond.setQcSku(vo.getSkuCode());
            Integer shelfLife = this.whWmsSkuBarcodeService.findSkuShelfLifeBySkuCode(vo.getSkuCode());
            if (EmptyUtil.isNotEmpty((Object)shelfLife) && shelfLife > 0 && CollectionUtils.isNotEmpty(vo.getMaterialBarcodes())) {
                WhWmsSkuBarcode whWmsSkuBarcode = this.whWmsSkuBarcodeService.findMinProdOrExpiryDateByBarCodes(vo.getMaterialBarcodes());
                if (EmptyUtil.isNotEmpty((Object)whWmsSkuBarcode)) {
                    qcCond.setQcProdDate(whWmsSkuBarcode.getProdDate());
                    qcCond.setQcExpirationDate(whWmsSkuBarcode.getExpirationDate());
                    qcCond.setManualCalculate(true);
                } else if (EmptyUtil.isNotEmpty((Object)vo.getProductDate())) {
                    qcCond.setQcProdDate(vo.getProductDate());
                }
            }
            qcCond.setReferenceCode(vo.getPrdcJobCode());
            qcCond.setWhInType(inOutType);
            barCode = this.whCommandService.getBarCode(qcCond);
            vo.setMakeNewBarcode(qcCond.isMakeNewBarcode());
        } else if (WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT.equals(jobType)) {
            Integer shelfLife = this.whWmsSkuBarcodeService.findSkuShelfLifeBySkuCode(taskDetailVO.getSkuCode());
            if (EmptyUtil.isNotEmpty((Object)taskDetailVO.getProductDate())) {
                Date expirationDate = null;
                if (shelfLife != null && shelfLife > 0) {
                    expirationDate = DateUtil.addDay((Date)taskDetailVO.getProductDate(), (int)shelfLife);
                }
                WhWmsSkuBarcodeVO barcodeCond = new WhWmsSkuBarcodeVO();
                barcodeCond.setSkuCode(taskDetailVO.getSkuCode());
                barcodeCond.setProdDate(taskDetailVO.getProductDate());
                barcodeCond.setExpirationDate(expirationDate);
                List<WhWmsSkuBarcodeVO> barCodeList = this.whWmsSkuBarcodeService.getWmsSkuBarcodeByCond(barcodeCond);
                if (CollectionUtils.isEmpty(barCodeList)) {
                    throw new WarehouseException("WH0001", "SKU[" + taskDetailVO.getSkuCode() + "],\u672a\u627e\u5230\u751f\u4ea7\u65e5\u671f\u5bf9\u5e94\u7684\u6279\u6b21\u53f7");
                }
                barCode = barCodeList.get(0).getBarCode();
            } else {
                WhWmsPrdcMaterialDetailCond cond = new WhWmsPrdcMaterialDetailCond();
                cond.setMaterialSku(taskDetailVO.getSkuCode());
                cond.setProdBarcode(vo.getBarcode());
                List<WhWmsPrdcMaterialDetail> prdcMaterialDetails = this.whWmsPrdcMaterialDetailService.listWhWmsPrdcMaterialDetailByCond(cond);
                if (CollectionUtils.isNotEmpty(prdcMaterialDetails)) {
                    if (prdcMaterialDetails.size() == 1) {
                        barCode = prdcMaterialDetails.get(0).getMaterialBarcode();
                    } else if (EmptyUtil.isNotEmpty((Object)shelfLife) && shelfLife > 0) {
                        List<String> barcodes = this.whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndUnexpiredSortByExpiredAsc(taskDetailVO.getSkuCode());
                        if (CollectionUtils.isEmpty(barcodes)) {
                            throw new WarehouseException("WH0001", "\u62c6\u5206\u65f6,\u627e\u4e0d\u5230\u6709\u6548\u671f\u7684\u8017\u6750\u6279\u6b21\u4fe1\u606f[" + taskDetailVO.getSkuCode() + "]");
                        }
                        barCode = barcodes.get(0);
                    } else {
                        barCode = taskDetailVO.getSkuCode() + "_0001";
                        this.whCommandService.createBarCodeWhenNotExists(taskDetailVO.getSkuCode(), barCode, 1, null);
                    }
                } else {
                    barCode = taskDetailVO.getSkuCode() + "_0001";
                    this.whCommandService.createBarCodeWhenNotExists(taskDetailVO.getSkuCode(), barCode, 1, null);
                }
            }
        }
        return barCode;
    }

    private void releaseWmsOccupy(WhWmsOccupyVO occupyCond) {
        this.whWmsOccupyService.releaseWmsOccupy(occupyCond);
    }

    private WhWmsHouseShelvesVO getWhWmsHouseShelvesVO(WhWmsPrdcJobTaskVO vo) {
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
        cond.setShelvesUsableStatus(WhWmsHouseShelvesVO.SHELVES_USABLE_SUATUS_AVAILABLE);
        cond.setHouseType("HOUSE_TYPE_PROCESSING");
        WhWmsHouseShelvesVO shelvesVO = null;
        List<WhWmsHouseShelvesVO> shelvesList = this.whWmsHouseShelvesService.getHouseShelvesByCond(cond);
        if (shelvesList == null || shelvesList.isEmpty()) {
            throw new WarehouseException("", "[" + vo.getPrdcJobCode() + "]\uff0c\u7269\u7406\u4ed3[" + cond.getPhysicalWarehouseCode() + "]\uff0c\u5e93\u533a[" + cond.getHouseType() + "]\u6ca1\u6709\u5e93\u4f4d\u5b58\u653e\u6210\u54c1!");
        }
        shelvesVO = shelvesList.get(0);
        return shelvesVO;
    }

    private List<String> getReferenceCodes(List<Map<String, Object>> prdcJobLineInfos) {
        ArrayList<String> codes = new ArrayList<String>();
        if (prdcJobLineInfos != null && !prdcJobLineInfos.isEmpty()) {
            for (Map<String, Object> prdcJobLineInfo : prdcJobLineInfos) {
                Object obj = prdcJobLineInfo.get("code");
                if (obj == null) continue;
                codes.add(obj.toString());
            }
        }
        return codes;
    }

    private WhInvOccupy getwhInvOccupy(List<WhInvOccupy> whInvOccupyList, String referenceCode) {
        if (whInvOccupyList != null && !whInvOccupyList.isEmpty()) {
            for (WhInvOccupy whInvOccupy : whInvOccupyList) {
                if (!referenceCode.equals(whInvOccupy.getReferenceCode())) continue;
                return whInvOccupy;
            }
        }
        return null;
    }

    private Map<String, Object> getPrdcJobLineInfoBySkuCode(List<Map<String, Object>> prdcJobLineInfos, String skuCode) {
        if (prdcJobLineInfos != null && !prdcJobLineInfos.isEmpty()) {
            for (Map<String, Object> prdcJobLineInfo : prdcJobLineInfos) {
                Object obj = prdcJobLineInfo.get("skuCode");
                if (obj == null || !skuCode.equals(obj)) continue;
                return prdcJobLineInfo;
            }
        }
        return null;
    }

    private List<WhWmsSkuStockRecordVO> getSplitStockUpdate(WhWmsPrdcJobTaskVO vo, List<WhWmsOccupyVO> occupyList, Long userId, Map<String, WhWmsOccupyVO> skuOccupyMap) {
        this.fullExpirationDateThenSort(occupyList);
        ArrayList<WhWmsSkuStockRecordVO> updateSkuStockList = new ArrayList<WhWmsSkuStockRecordVO>();
        Integer needAmount = vo.getFinishedDefectiveAmount() + vo.getFinishedGoodsAmount();
        if (needAmount == 0) {
            return updateSkuStockList;
        }
        for (WhWmsOccupyVO occupyVO : occupyList) {
            if (vo.getSkuCode().equals(occupyVO.getSkuCode())) {
                WhWmsSkuStockRecordVO skuStock;
                if (needAmount + occupyVO.getAmount() > 0) {
                    skuStock = this.buildSkuStock(occupyVO.getAmount(), occupyVO.getPhysicalWarehouseCode(), occupyVO.getHouseType(), occupyVO.getSkuCode(), occupyVO.getBarCode(), occupyVO.getOriShelvesCode(), occupyVO.getSkuStatus(), WhCommand.TYPE_PRODUCE_OUT, vo.getCode(), userId);
                    updateSkuStockList.add(skuStock);
                    needAmount = needAmount + occupyVO.getAmount();
                } else {
                    skuStock = this.buildSkuStock(-needAmount.intValue(), occupyVO.getPhysicalWarehouseCode(), occupyVO.getHouseType(), occupyVO.getSkuCode(), occupyVO.getBarCode(), occupyVO.getOriShelvesCode(), occupyVO.getSkuStatus(), WhCommand.TYPE_PRODUCE_OUT, vo.getCode(), userId);
                    updateSkuStockList.add(skuStock);
                    needAmount = 0;
                }
            }
            skuOccupyMap.put(occupyVO.getSkuCode(), occupyVO);
        }
        if (needAmount > 0) {
            throw new WarehouseException("WH0001", "\u5f85\u62c6\u5206\u7684sku\u5360\u7528\u6570\u91cf\u4e0d\u5bf9!");
        }
        return updateSkuStockList;
    }

    private List<WhWmsSkuStockRecordVO> getAssembleStockUpdate(WhWmsPrdcJobTaskDetailVO taskDetailVO, List<WhWmsOccupyVO> occupyList, Long userId) {
        this.fullExpirationDateThenSort(occupyList);
        ArrayList<WhWmsSkuStockRecordVO> list = new ArrayList<WhWmsSkuStockRecordVO>();
        int needAmount = taskDetailVO.getRealAmount();
        if (needAmount == 0) {
            return list;
        }
        for (WhWmsOccupyVO occupyVO : occupyList) {
            WhWmsSkuStockRecordVO skuStock;
            if (!occupyVO.getSkuCode().equals(taskDetailVO.getSkuCode())) continue;
            if (needAmount + occupyVO.getAmount() > 0) {
                skuStock = this.buildSkuStock(occupyVO.getAmount(), occupyVO.getPhysicalWarehouseCode(), occupyVO.getHouseType(), occupyVO.getSkuCode(), occupyVO.getBarCode(), occupyVO.getOriShelvesCode(), occupyVO.getSkuStatus(), WhCommand.TYPE_PRODUCE_OUT, taskDetailVO.getCode(), userId);
                list.add(skuStock);
                needAmount += occupyVO.getAmount().intValue();
                continue;
            }
            skuStock = this.buildSkuStock(-needAmount, occupyVO.getPhysicalWarehouseCode(), occupyVO.getHouseType(), occupyVO.getSkuCode(), occupyVO.getBarCode(), occupyVO.getOriShelvesCode(), occupyVO.getSkuStatus(), WhCommand.TYPE_PRODUCE_OUT, taskDetailVO.getCode(), userId);
            needAmount = 0;
            list.add(skuStock);
            break;
        }
        if (needAmount > 0) {
            // empty if block
        }
        return list;
    }

    private void updateScmStock(WhWmsPrdcJobTaskVO vo) throws Exception {
        ArrayList<WhInvOccupy> afterWhInvOccupyList;
        ArrayList<WhReleaseOccupationVO> releaseOccupations;
        ArrayList<WhCommand> commands;
        block15: {
            String physicalWarehouseCode;
            boolean jobFinished;
            List<WhInvOccupy> whInvOccupyList;
            List<Map<String, Object>> prdcJobLineInfos;
            block14: {
                commands = new ArrayList<WhCommand>();
                releaseOccupations = new ArrayList<WhReleaseOccupationVO>();
                prdcJobLineInfos = this.whWmsPrdcJobTaskMapper.getPrdcJobLineInfos(vo.getPrdcJobCode());
                whInvOccupyList = null;
                afterWhInvOccupyList = new ArrayList<WhInvOccupy>();
                jobFinished = false;
                ArrayList<String> prdcJobCodes = new ArrayList<String>();
                prdcJobCodes.add(vo.getPrdcJobCode());
                List<Map<String, Object>> wmsPrdcJobTaskInfos = this.getWmsPrdcJobTaskFinishedInfo(prdcJobCodes);
                Map<String, Object> prdcJob = this.whWmsPrdcJobTaskMapper.getPrdcJobInfo(vo.getPrdcJobCode());
                Map<String, Object> prdcTaskInfo = wmsPrdcJobTaskInfos.get(0);
                Integer estQuantity = Integer.parseInt(prdcJob.get("estQuantity").toString());
                Integer finishAmount = Integer.parseInt(prdcTaskInfo.get("amount").toString());
                if (finishAmount.equals(estQuantity)) {
                    jobFinished = true;
                }
                if (EmptyUtil.isEmpty((Object)prdcJob.get("physicalWarehouseCode"))) {
                    throw new WarehouseException("", prdcJob.get("code").toString() + "[\u6ca1\u6709\u7269\u7406\u4ed3]");
                }
                physicalWarehouseCode = prdcJob.get("physicalWarehouseCode").toString();
                if (WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT != vo.getJobType() || vo.getFinishedGoodsAmount() <= 0) break block14;
                ArrayList<String> referenceCodes = new ArrayList<String>();
                referenceCodes.add(prdcJob.get("code").toString());
                whInvOccupyList = this.whInvService.getWhInvOccupy(referenceCodes);
                String jobCode = prdcJob.get("code").toString();
                WhInvOccupy whInvOccupy = this.getwhInvOccupy(whInvOccupyList, jobCode);
                if (EmptyUtil.isEmpty((Object)whInvOccupy)) {
                    throw new WarehouseException("", jobCode + "[\u6ca1\u6709scm\u5360\u7528\u4fe1\u606f]");
                }
                WhCommand whCommandJob = new WhCommand();
                ArrayList<WhCommandSku> commandSkus = new ArrayList<WhCommandSku>();
                whCommandJob.setWarehouseCode(whInvOccupy.getWarehouseCode());
                whCommandJob.setPhysicalWarehouseCode(physicalWarehouseCode);
                whCommandJob.setReferenceCode(vo.getCode());
                whCommandJob.setPlanedDeliveryDate(DateUtil.getNow());
                whCommandJob.setInOutType(WhCommand.TYPE_PRODUCE_OUT);
                WhCommandSku jobLineSku = new WhCommandSku();
                jobLineSku.setSkuCode(vo.getSkuCode());
                jobLineSku.setPlanedQuantity(vo.getFinishedGoodsAmount());
                jobLineSku.setQuantity(vo.getFinishedGoodsAmount());
                jobLineSku.setDamagedQuantity(0);
                commandSkus.add(jobLineSku);
                whCommandJob.setWhCommandSkuList(commandSkus);
                whCommandJob.setOperatorId(vo.getCreateUserId());
                commands.add(whCommandJob);
                WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
                whReleaseOccupationVO.setOccupyType(WhInvOccupy.TYPE_PRODUCE_OUT);
                whReleaseOccupationVO.setReferenceCode(jobCode);
                releaseOccupations.add(whReleaseOccupationVO);
                if (jobFinished) break block15;
                Integer amount = vo.getFinishedGoodsAmount() + vo.getFinishedDefectiveAmount();
                if (whInvOccupy.getQuantity() <= amount) break block15;
                whInvOccupy.setQuantity(whInvOccupy.getQuantity() - amount);
                afterWhInvOccupyList.add(whInvOccupy);
                break block15;
            }
            if (WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE == vo.getJobType()) {
                whInvOccupyList = this.whInvService.getWhInvOccupy(this.getReferenceCodes(prdcJobLineInfos));
                List<WhWmsPrdcJobTaskDetailVO> jobTaskDetailList = vo.getJobTaskDetailList();
                if (CollectionUtils.isEmpty(whInvOccupyList)) {
                    throw new WarehouseException("", "\u6ca1\u6709\u5360\u7528\u5e93\u5b58");
                }
                String warehouseCode = whInvOccupyList.get(0).getWarehouseCode();
                if (jobTaskDetailList != null && !jobTaskDetailList.isEmpty()) {
                    for (WhWmsPrdcJobTaskDetailVO jobTaskDetail : jobTaskDetailList) {
                        Map<String, Object> prdcJobLineInfo;
                        String jobLineCode;
                        WhInvOccupy whInvOccupy;
                        ArrayList<WhCommandSku> commandSkus = new ArrayList<WhCommandSku>();
                        if (jobTaskDetail.getRealAmount() > 0) {
                            WhCommandSku jobLineSku = new WhCommandSku();
                            jobLineSku.setSkuCode(jobTaskDetail.getSkuCode());
                            jobLineSku.setPlanedQuantity(jobTaskDetail.getRealAmount());
                            if (WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED.equals(vo.getSkuStatus())) {
                                jobLineSku.setQuantity(0);
                                jobLineSku.setDamagedQuantity(jobTaskDetail.getRealAmount());
                            } else {
                                jobLineSku.setQuantity(jobTaskDetail.getRealAmount());
                                jobLineSku.setDamagedQuantity(0);
                            }
                            commandSkus.add(jobLineSku);
                        }
                        if (commandSkus != null && !commandSkus.isEmpty()) {
                            WhCommand whCommandJobLine = new WhCommand();
                            whCommandJobLine.setWarehouseCode(warehouseCode);
                            whCommandJobLine.setPhysicalWarehouseCode(physicalWarehouseCode);
                            whCommandJobLine.setReferenceCode(jobTaskDetail.getCode());
                            whCommandJobLine.setInOutType(WhCommand.TYPE_PRODUCE_OUT);
                            whCommandJobLine.setPlanedDeliveryDate(DateUtil.getNow());
                            whCommandJobLine.setWhCommandSkuList(commandSkus);
                            whCommandJobLine.setOperatorId(vo.getCreateUserId());
                            commands.add(whCommandJobLine);
                        }
                        if ((whInvOccupy = this.getwhInvOccupy(whInvOccupyList, jobLineCode = (prdcJobLineInfo = this.getPrdcJobLineInfoBySkuCode(prdcJobLineInfos, jobTaskDetail.getSkuCode())).get("code").toString())) != null && whInvOccupy != null) {
                            WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
                            whReleaseOccupationVO.setOccupyType(WhInvOccupy.TYPE_PRODUCE_OUT);
                            whReleaseOccupationVO.setReferenceCode(jobLineCode);
                            releaseOccupations.add(whReleaseOccupationVO);
                        }
                        if (jobFinished || whInvOccupy == null) continue;
                        if (whInvOccupy.getQuantity() > jobTaskDetail.getRealAmount()) {
                            whInvOccupy.setQuantity(whInvOccupy.getQuantity() - jobTaskDetail.getRealAmount());
                            afterWhInvOccupyList.add(whInvOccupy);
                            continue;
                        }
                        whInvOccupy.setQuantity(0);
                        afterWhInvOccupyList.add(whInvOccupy);
                    }
                }
            }
        }
        if (commands != null && !commands.isEmpty()) {
            this.whCommandService.createCommandsAfterReleaseThenFinishThenOccupy(commands, releaseOccupations, afterWhInvOccupyList);
        }
    }

    private void fullExpirationDateThenSort(List<WhWmsOccupyVO> occupyList) {
        if (occupyList != null && !occupyList.isEmpty()) {
            for (WhWmsOccupyVO occupy : occupyList) {
                WhWmsSkuBarcodeVO cond = new WhWmsSkuBarcodeVO();
                cond.setSkuCode(occupy.getSkuCode());
                cond.setBarCode(occupy.getBarCode());
                cond.setRefCode(occupy.getReceiptsNo());
                List<WhWmsSkuBarcodeVO> list = this.whWmsSkuBarcodeService.getWmsSkuBarcodeByCond(cond);
                if (list != null && !list.isEmpty()) {
                    occupy.setExpirationDate(list.get(0).getExpirationDate());
                    continue;
                }
                occupy.setExpirationDate(null);
            }
            this.sortOccupyListByExpirationDate(occupyList);
        }
    }

    private void sortOccupyListByExpirationDate(List<WhWmsOccupyVO> occupyList) {
        Collections.sort(occupyList, new Comparator<WhWmsOccupyVO>(){

            @Override
            public int compare(WhWmsOccupyVO o1, WhWmsOccupyVO o2) {
                int skuCodeCmp = o1.getSkuCode().compareTo(o2.getSkuCode());
                if (skuCodeCmp == 0) {
                    int skuStatusCmp = o1.getSkuStatus().compareTo(o2.getSkuStatus());
                    if (skuStatusCmp == 0) {
                        Date d1 = o1.getExpirationDate();
                        Date d2 = o2.getExpirationDate();
                        if (d1 == null && d2 == null) {
                            return 0;
                        }
                        if (d1 == null && d2 != null) {
                            return 1;
                        }
                        if (d1 != null && d2 == null) {
                            return -1;
                        }
                        if (d1 != null && d2 != null) {
                            return d1.compareTo(d2);
                        }
                    }
                    return skuStatusCmp;
                }
                return skuCodeCmp;
            }
        });
    }

    private List<WhWmsSkuStockRecordVO> filterSkuStocks(List<WhWmsSkuStockRecordVO> skuStocks, Integer inOutType) {
        ArrayList<WhWmsSkuStockRecordVO> rtList = new ArrayList<WhWmsSkuStockRecordVO>();
        if (skuStocks != null && inOutType != null) {
            for (WhWmsSkuStockRecordVO vo : skuStocks) {
                if (!vo.getInOutType().equals(inOutType) || vo.getQuantity() == 0) continue;
                rtList.add(vo);
            }
        }
        return rtList;
    }

    private List<WhCommandSku> buildSkuCommandList(List<WhWmsSkuStockRecordVO> stocks, Map<String, String> skuAndBarcodeMap) {
        ArrayList<WhCommandSku> commandSkus = new ArrayList<WhCommandSku>();
        if (stocks != null) {
            for (WhWmsSkuStockRecordVO stock : stocks) {
                this.buildWhCommandSku(commandSkus, stock);
                skuAndBarcodeMap.put(stock.getSkuCode(), stock.getBarCode());
            }
        }
        return commandSkus;
    }

    private void buildWhCommandSku(List<WhCommandSku> commandSkus, WhWmsSkuStockRecordVO stock) {
        WhCommandSku cmdSku = null;
        for (WhCommandSku commandSku : commandSkus) {
            if (!stock.getSkuCode().equals(commandSku.getSkuCode())) continue;
            cmdSku = commandSku;
            break;
        }
        if (cmdSku == null) {
            cmdSku = new WhCommandSku();
            cmdSku.setSkuCode(stock.getSkuCode());
            cmdSku.setPlanedQuantity(0);
            cmdSku.setQuantity(0);
            cmdSku.setDamagedQuantity(0);
            cmdSku.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
            cmdSku.setReceiptNo(stock.getReceiptNo());
            commandSkus.add(cmdSku);
        }
        if (WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED.equals(stock.getSkuStatus())) {
            cmdSku.setDamagedQuantity(cmdSku.getDamagedQuantity() + stock.getQuantity());
        } else if (WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(stock.getSkuStatus())) {
            cmdSku.setQuantity(cmdSku.getQuantity() + stock.getQuantity());
        }
        cmdSku.setPlanedQuantity(cmdSku.getQuantity() + cmdSku.getDamagedQuantity());
    }

    public List<WhWmsSkuStockVO> checkStockBeforeOccupy(WhWmsPrdcJobTaskVO task, WhWmsPrdcJobTaskDetailVO taskDetail, Map<String, Integer> taskDetailDifferenceMap, List<WhWmsMoveSkuVO> moveSkus) {
        int taskDetailNeedAmount = 0;
        ArrayList<WhWmsSkuStockVO> skuStockList = new ArrayList<WhWmsSkuStockVO>();
        WhWmsSkuStockVO skuStockVOCond = new WhWmsSkuStockVO();
        skuStockVOCond.setPhysicalWarehouseCode(task.getPhysicalWarehouseCode());
        skuStockVOCond.setSkuStatus(task.getSkuStatus());
        if (task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE) {
            taskDetailNeedAmount = taskDetail.getAmount().intValue();
            skuStockVOCond.setSkuCode(taskDetail.getSkuCode());
            skuStockVOCond.setSkuCodeLike(taskDetail.getSkuCode());
        } else if (task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT) {
            taskDetailNeedAmount = task.getAmount();
            skuStockVOCond.setSkuCode(task.getSkuCode());
            skuStockVOCond.setSkuCodeLike(task.getSkuCode());
        }
        int difference = taskDetailNeedAmount;
        ArrayList<String> houseTypeList = new ArrayList<String>();
        houseTypeList.add("HOUSE_TYPE_PROCESSING");
        houseTypeList.addAll(this.whWmsWarehouseAreaService.getHouseTypesByType("NORMAL"));
        skuStockVOCond.setHouseTypes(houseTypeList);
        List<WhWmsSkuStockVO> totalAreaStocks = this.whWmsSkuStockService.getWmsSkuStocksByCond(skuStockVOCond);
        if (CollectionUtils.isEmpty(totalAreaStocks)) {
            if (task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE) {
                taskDetailDifferenceMap.put(taskDetail.getSkuCode(), difference);
            }
            if (task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT) {
                taskDetailDifferenceMap.put(task.getSkuCode(), difference);
            }
            return Collections.EMPTY_LIST;
        }
        Integer totalAvailStock = 0;
        for (WhWmsSkuStockVO skuStock : totalAreaStocks) {
            if ((totalAvailStock = Integer.valueOf(totalAvailStock + skuStock.getAvailableAmount())).compareTo(taskDetailNeedAmount) < 0) continue;
            break;
        }
        if (totalAvailStock.compareTo(taskDetailNeedAmount) < 0) {
            difference = taskDetailNeedAmount - totalAvailStock;
            if (task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE) {
                taskDetailDifferenceMap.put(taskDetail.getSkuCode(), difference);
            }
            if (task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT) {
                taskDetailDifferenceMap.put(task.getSkuCode(), difference);
            }
            return Collections.EMPTY_LIST;
        }
        block1: for (final String houseType : houseTypeList) {
            int pagenum = 100;
            int currpage = 1;
            skuStockVOCond.setPagenum(pagenum);
            skuStockVOCond.setCurrpage(currpage);
            if (difference == 0) break;
            skuStockVOCond.setHouseTypes((List<String>)new ArrayList<String>(){
                {
                    this.add(houseType);
                }
            });
            skuStockVOCond.setHouseType(houseType);
            List<WhWmsSkuStockVO> areaStocks = this.whWmsSkuStockService.getWmsSkuStocksByCond(skuStockVOCond);
            if (CollectionUtils.isEmpty(areaStocks)) continue;
            if (areaStocks.size() != 1) {
                throw new WarehouseException("", "error,the result isnot unique!");
            }
            WhWmsSkuStockVO areaStock = areaStocks.get(0);
            if (!houseType.equals("HOUSE_TYPE_PROCESSING") && areaStock.getAvailableAmount() <= 0) continue;
            do {
                WhWmsHouseShelvesVO houseShelvesVO;
                Integer areaAvailableAmount;
                WhWmsHouseShelvesVO houseShelves;
                skuStockVOCond.setCurrpage(currpage);
                areaStocks = this.whWmsSkuStockService.getWmsSkuStocksByShelvesCond(skuStockVOCond);
                if (CollectionUtils.isEmpty(areaStocks)) continue block1;
                if (areaStock.getAvailableAmount() <= 0) continue;
                if (areaStock.getAvailableAmount().compareTo(difference) < 0 && difference > 0 && areaStock.getAvailableAmount() > 0) {
                    areaStocks = this.whWmsSkuStockService.getWmsSkuStocksByShelvesCond(skuStockVOCond);
                    if (CollectionUtils.isEmpty(areaStocks)) continue block1;
                    for (WhWmsSkuStockVO skuStock : areaStocks) {
                        houseShelves = this.whWmsHouseShelvesService.getHouseShelvesByCode(skuStock.getShelvesCode());
                        if (!WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelves.getShelvesType()) && !WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelves.getShelvesType()) && !houseType.equals("HOUSE_TYPE_PROCESSING") || (areaAvailableAmount = skuStock.getAvailableAmount()) <= 0) continue;
                        skuStock.setOccupiedAccount(areaAvailableAmount);
                        skuStockList.add(skuStock);
                        difference -= areaAvailableAmount.intValue();
                        if (houseType.equals("HOUSE_TYPE_PROCESSING") || skuStock.getOccupiedAccount() == 0 || EmptyUtil.isEmpty((Object)(houseShelvesVO = this.whWmsHouseShelvesService.getHouseShelvesByCode(skuStock.getShelvesCode()))) || !WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelvesVO.getShelvesType()) && !WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelvesVO.getShelvesType())) continue;
                        moveSkus.add(this.buildMoveSku(houseType, task, skuStock));
                    }
                } else if (areaStock.getAvailableAmount().compareTo(difference) >= 0 && difference > 0) {
                    Collections.sort(areaStocks, new Comparator<WhWmsSkuStockVO>(){

                        @Override
                        public int compare(WhWmsSkuStockVO vo1, WhWmsSkuStockVO vo2) {
                            return vo1.getAvailableAmount().compareTo(vo2.getAvailableAmount());
                        }
                    });
                    for (WhWmsSkuStockVO skuStock : areaStocks) {
                        houseShelves = this.whWmsHouseShelvesService.getHouseShelvesByCode(skuStock.getShelvesCode());
                        if (!WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelves.getShelvesType()) && !WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelves.getShelvesType()) && !houseType.equals("HOUSE_TYPE_PROCESSING")) continue;
                        areaAvailableAmount = skuStock.getAvailableAmount();
                        if (areaAvailableAmount.compareTo(difference) >= 0) {
                            skuStock.setOccupiedAccount(difference);
                            skuStockList.add(skuStock);
                            difference = 0;
                            if (!houseType.equals("HOUSE_TYPE_PROCESSING") && skuStock.getOccupiedAccount() != 0) {
                                houseShelvesVO = this.whWmsHouseShelvesService.getHouseShelvesByCode(skuStock.getShelvesCode());
                                if (EmptyUtil.isEmpty((Object)houseShelvesVO)) continue;
                                if (WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelvesVO.getShelvesType()) || WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelvesVO.getShelvesType())) {
                                    moveSkus.add(this.buildMoveSku(houseType, task, skuStock));
                                }
                            }
                            return skuStockList;
                        }
                        if (areaAvailableAmount <= 0) continue;
                        skuStock.setOccupiedAccount(areaAvailableAmount);
                        skuStockList.add(skuStock);
                        difference -= areaAvailableAmount.intValue();
                        if (houseType.equals("HOUSE_TYPE_PROCESSING") || skuStock.getOccupiedAccount() == 0 || EmptyUtil.isEmpty((Object)(houseShelvesVO = this.whWmsHouseShelvesService.getHouseShelvesByCode(skuStock.getShelvesCode()))) || !WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelvesVO.getShelvesType()) && !WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelvesVO.getShelvesType())) continue;
                        moveSkus.add(this.buildMoveSku(houseType, task, skuStock));
                    }
                } else {
                    throw new WarehouseException("", "error,the difference is abnormal");
                }
                ++currpage;
            } while (areaStocks.size() == pagenum);
        }
        if (difference > 0) {
            taskDetailDifferenceMap.put(taskDetail.getSkuCode(), difference);
        }
        return Collections.EMPTY_LIST;
    }

    private Integer getAreaAvailableStockAmount(List<WhWmsSkuStockVO> areaStocks, String houseType) {
        int total = 0;
        if (areaStocks != null) {
            for (WhWmsSkuStockVO stock : areaStocks) {
                if (houseType == null || !houseType.equals(stock.getHouseType())) continue;
                total += stock.getAvailableAmount().intValue();
            }
        }
        return total;
    }

    public String createNewCode(String head) {
        String taskCode = head + System.currentTimeMillis();
        if (EmptyUtil.isNotEmpty((Object)this.getPrdcJobTaskByTaskCode(taskCode))) {
            this.createNewCode(head);
        }
        return taskCode;
    }

    public boolean sendOutOfStockEmil(int amount, String physicalWasrehouseCode, String PrdcJobCode, Map<String, Integer> taskDetailDifferenceMap) {
        try {
            EmailVO emailVO = new EmailVO();
            emailVO.setToAddressList(Arrays.asList(PegasusUtilFacade.getInstance().findConfigByKey("wms-prdc-sendOutOfStockEmail_" + physicalWasrehouseCode).getConfigValue().split(",")));
            if (CollectionUtils.isEmpty((Collection)emailVO.getToAddressList())) {
                return false;
            }
            emailVO.setSubject("[ERROR]WMS-Task of ProductionAndProcessing Starting failed [" + PrdcJobCode + "]");
            StringBuffer contentBuffer = new StringBuffer("\u751f\u4ea7\u52a0\u5de5\u4efb\u52a1\u542f\u52a8\u5931\u8d25,\u539f\u56e0:\u5e93\u5b58\u4e0d\u8db3");
            contentBuffer.append("</br>");
            contentBuffer.append("\u751f\u4ea7\u8ba2\u5355\u53f7:" + PrdcJobCode + ",\u4ed3\u5e93:" + physicalWasrehouseCode);
            contentBuffer.append("</br>");
            contentBuffer.append("\u672c\u6b21\u542f\u52a8\u4efb\u52a1\u6570:" + amount);
            contentBuffer.append("</br>");
            for (Map.Entry<String, Integer> entry : taskDetailDifferenceMap.entrySet()) {
                contentBuffer.append("SKU:" + entry.getKey() + ",\u5dee\u989d:" + entry.getValue());
                contentBuffer.append("</br>");
            }
            emailVO.setContent(contentBuffer.toString());
            boolean tf = EmailUtil.getInstance().send(emailVO);
            return tf;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public WhWmsMoveSkuVO buildMoveSku(String houseType, WhWmsPrdcJobTaskVO task, WhWmsSkuStockVO skuStock) {
        WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
        moveSkuVO.setPhysicalWarehouseCode(task.getPhysicalWarehouseCode());
        moveSkuVO.setCreateTime(new Date());
        moveSkuVO.setOriginalHouseType(houseType);
        moveSkuVO.setTargetHouseType("HOUSE_TYPE_PROCESSING");
        moveSkuVO.setSkuStatus(task.getSkuStatus());
        moveSkuVO.setAmount(skuStock.getOccupiedAccount());
        moveSkuVO.setSkuCode(skuStock.getSkuCode());
        moveSkuVO.setBarCode(skuStock.getBarCode());
        moveSkuVO.setOriginalShelvesCode(skuStock.getShelvesCode());
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(skuStock.getPhysicalWarehouseCode());
        cond.setHouseType("HOUSE_TYPE_PROCESSING");
        List<WhWmsHouseShelvesVO> targetShelves = this.whWmsHouseShelves.getHouseShelvesByCond(cond);
        if (CollectionUtils.isEmpty(targetShelves)) {
            throw new WarehouseException("", "Illegal Param!");
        }
        moveSkuVO.setTargetShelvesCode(targetShelves.get(0).getCode());
        return moveSkuVO;
    }

    private WhWmsSkuStockRecordVO buildSkuStock(Integer amount, String physicalWarehouseCode, String houseType, String skuCode, String barcode, String shelvesCode, Integer skuStatus, Integer inOutType, String receiptNo, Long userId) {
        WhWmsSkuStockRecordVO skuStock = new WhWmsSkuStockRecordVO();
        skuStock.setQuantity(amount);
        skuStock.setPhysicalWarehouseCode(physicalWarehouseCode);
        skuStock.setHouseType(houseType);
        skuStock.setBarCode(barcode);
        skuStock.setShelvesCode(shelvesCode);
        skuStock.setSkuCode(skuCode);
        skuStock.setSkuStatus(skuStatus);
        skuStock.setCreateUserId(userId);
        skuStock.setInOutType(inOutType);
        skuStock.setReceiptNo(receiptNo);
        return skuStock;
    }

    @Override
    public List<Map<String, Object>> getWmsPrdcJobTaskFinishedInfo(List<String> prdcJobCodes) {
        return this.whWmsPrdcJobTaskMapper.getWmsPrdcJobTaskFinishedInfo(prdcJobCodes);
    }

    @Override
    public List<Map<String, Object>> getWmsPrdcJobTaskProcessingInfo(List<String> prdcJobCodes) {
        return this.whWmsPrdcJobTaskMapper.getWmsPrdcJobTaskProcessingInfo(prdcJobCodes);
    }

    @Override
    public List<Map<String, Object>> getWmsPrdcJobTaskFinishedRealAmount(List<String> prdcJobCodes) {
        return this.whWmsPrdcJobTaskMapper.getWmsPrdcJobTaskFinishedRealAmount(prdcJobCodes);
    }
}

