/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsPrdcJobTaskDetailMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsPrdcJobTaskDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsPrdcJobTaskDetailExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsPrdcJobTaskDetailService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPrdcJobTaskDetailVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="whWmsPrdcJobTaskDetailService")
public class WhWmsPrdcJobTaskDetailServiceImpl
implements WhWmsPrdcJobTaskDetailService {
    @Autowired
    private WhWmsPrdcJobTaskDetailMapper whWmsPrdcJobTaskDetailMapper;

    @Override
    public WhWmsPrdcJobTaskDetailVO getTaskTetailByCond() {
        return null;
    }

    @Override
    public WhWmsPrdcJobTaskDetail getTaskDetailById(Long id) {
        return this.whWmsPrdcJobTaskDetailMapper.selectByPrimaryKey(id);
    }

    @Override
    public WhWmsPrdcJobTaskDetail getTaskDetailBycode(String code) {
        WhWmsPrdcJobTaskDetailExample example = new WhWmsPrdcJobTaskDetailExample();
        example.createCriteria().andCodeEqualTo(code);
        List<WhWmsPrdcJobTaskDetail> taskDetails = this.whWmsPrdcJobTaskDetailMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(taskDetails)) {
            return null;
        }
        if (taskDetails.size() > 1) {
            throw new WarehouseException("", "\u5339\u914d\u5230\u591a\u6761\u8bb0\u5f55");
        }
        return taskDetails.get(0);
    }

    @Override
    public List<WhWmsPrdcJobTaskDetailVO> getTaskDetailByTaskCode(String taskCode) {
        WhWmsPrdcJobTaskDetailExample example = new WhWmsPrdcJobTaskDetailExample();
        example.createCriteria().andTaskCodeEqualTo(taskCode);
        List<WhWmsPrdcJobTaskDetail> taskDetails = this.whWmsPrdcJobTaskDetailMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(taskDetails)) {
            return Collections.EMPTY_LIST;
        }
        return BeanUtil.buildListFrom(taskDetails, WhWmsPrdcJobTaskDetailVO.class);
    }

    @Override
    public Boolean newTaskDetail(WhWmsPrdcJobTaskDetailVO taskDetailVO) {
        int insert = this.whWmsPrdcJobTaskDetailMapper.insert(taskDetailVO);
        if (insert <= 0) {
            throw new WarehouseException("", "\u63d2\u5165\u6570\u636e\u5931\u8d25");
        }
        return true;
    }

    @Override
    public Boolean newTaskDetail(List<WhWmsPrdcJobTaskDetailVO> taskDetailVOs) {
        for (WhWmsPrdcJobTaskDetailVO taskDetail : taskDetailVOs) {
            this.newTaskDetail(taskDetail);
        }
        return true;
    }

    @Override
    public Boolean updateTaskDetail(WhWmsPrdcJobTaskDetailVO taskDetailVO) {
        if (NumberUtil.isNullOrZero((Number)taskDetailVO.getId())) {
            throw new WarehouseException("", "\u4e3b\u952e");
        }
        int update = this.whWmsPrdcJobTaskDetailMapper.updateByPrimaryKey(taskDetailVO);
        if (update < 0) {
            throw new WarehouseException("", "\u66f4\u65b0\u6570\u636e\u5931\u8d25");
        }
        return true;
    }

    @Override
    public Boolean updateTaskDetailPrimaryKeySelective(WhWmsPrdcJobTaskDetailVO taskDetailVO) {
        if (NumberUtil.isNullOrZero((Number)taskDetailVO.getId())) {
            throw new WarehouseException("", "\u4e3b\u952e");
        }
        int update = this.whWmsPrdcJobTaskDetailMapper.updateByPrimaryKeySelective(taskDetailVO);
        if (update < 0) {
            throw new WarehouseException("", "\u66f4\u65b0\u6570\u636e\u5931\u8d25");
        }
        return true;
    }
}

