/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsOutStockRecordCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsOutStockRecordMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsOutStockRecord;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsOutStockRecordExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsOutStockRecordService;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whWmsOutStockRecordService")
public class WhWmsOutStockRecordServiceImpl
implements WhWmsOutStockRecordService {
    private static final Logger log = LoggerFactory.getLogger(WhWmsOutStockRecordServiceImpl.class);
    private PegasusUtilFacade pegasusUtilFacade = null;
    @Autowired
    private WhWmsOutStockRecordMapper whWmsOutStockRecordMapper;

    @Override
    @Transactional
    public WhWmsOutStockRecord createWhWmsOutStockRecord(WhWmsOutStockRecord whWmsOutStockRecord) {
        this.whWmsOutStockRecordMapper.insertSelective(whWmsOutStockRecord);
        return whWmsOutStockRecord;
    }

    @Override
    public List<WhWmsOutStockRecord> findWhWmsOutStockRecordsByCond(WhWmsOutStockRecordCond cond) {
        WhWmsOutStockRecordExample whWmsOutStockRecordExample = new WhWmsOutStockRecordExample();
        WhWmsOutStockRecordExample.Criteria criteria = whWmsOutStockRecordExample.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)cond.getInOutType())) {
            criteria.andInOutTypeEqualTo(cond.getInOutType());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getConnectId())) {
            criteria.andConnectIdEqualTo(cond.getConnectId());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getCommandCode())) {
            criteria.andCommandCodeEqualTo(cond.getCommandCode());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getOptType())) {
            criteria.andOptTypeEqualTo(cond.getOptType());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getRecordType())) {
            criteria.andRecordTypeEqualTo(cond.getRecordType());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getShelvesCode())) {
            criteria.andShelvesCodeEqualTo(cond.getShelvesCode());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getDisposeType())) {
            criteria.andDisposeTypeEqualTo(cond.getDisposeType());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getSkuCode())) {
            criteria.andSkuCodeEqualTo(cond.getSkuCode());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getOperatorId())) {
            criteria.andOperatorIdEqualTo(cond.getOperatorId());
        }
        whWmsOutStockRecordExample.setOrderByClause("ID DESC");
        return this.whWmsOutStockRecordMapper.selectByExample(whWmsOutStockRecordExample);
    }

    @Override
    @Transactional
    public boolean updateWhWmsOutStockRecordsByCond(WhWmsOutStockRecord record) {
        int result = this.whWmsOutStockRecordMapper.updateByPrimaryKeySelective(record);
        if (result <= 0) {
            throw new WarehouseException("", "update WhWmsOutStockRecord error!");
        }
        return true;
    }

    @Override
    @Transactional
    public boolean updateWhWmsOutStockRecordsByConds(List<WhWmsOutStockRecord> records) {
        for (WhWmsOutStockRecord record : records) {
            this.updateWhWmsOutStockRecordsByCond(record);
        }
        return true;
    }

    @PostConstruct
    public void init() {
        log.debug("[Service] ScmEntityOperationLogServiceImpl is initialing");
        this.pegasusUtilFacade = PegasusUtilFacade.getInstance();
        log.debug("[Service] ScmEntityOperationLogServiceImpl initialied");
    }
}

