/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsOperationCountCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsOperationRcdMapper;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandConnectService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsOperationRcdService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandConnectVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsOperationCountVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsOperationRcdVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whWmsOperationRcdService")
public class WhWmsOperationRcdServiceImpl
implements WhWmsOperationRcdService {
    @Autowired
    private WhWmsOperationRcdMapper whWmsOperationRcdMapper;
    @Autowired
    private WhWmsCommandConnectService whWmsCommandConnectService;

    @Override
    @Transactional
    public boolean insert(WhWmsOperationRcdVO rcd) {
        this.whWmsOperationRcdMapper.insert(rcd);
        return true;
    }

    @Override
    @Transactional
    public boolean batchInsert(List<WhWmsOperationRcdVO> rcdVOs) {
        this.whWmsOperationRcdMapper.batchInsert(rcdVOs);
        return true;
    }

    @Override
    @Transactional
    public boolean insert(List<WhWmsOperationRcdVO> rcdList) {
        if (EmptyUtil.isEmpty(rcdList)) {
            return false;
        }
        for (WhWmsOperationRcdVO rcd : rcdList) {
            this.insert(rcd);
        }
        return true;
    }

    @Override
    @Transactional
    public boolean insertRcdByConnectId(Long connectId, Long operatorId) {
        List<WhWmsOperationRcdVO> list = this.buildRcdListByConnectId(connectId, operatorId);
        return this.insert(list);
    }

    @Override
    @Transactional
    public boolean insertRcdByCommandCode(String commandCode, Long operatorId, Integer operateType) {
        WhWmsOperationRcdVO rcd = new WhWmsOperationRcdVO();
        rcd.setReferenceCode(commandCode);
        rcd.setOperateType(operateType);
        rcd.setCommandCode(commandCode);
        rcd.setOperatorId(operatorId);
        rcd.setOperateTime(DateUtil.getNow());
        return this.insert(rcd);
    }

    @Override
    public List<WhWmsOperationCountVO> getCountInfoByCond(WhWmsOperationCountCond cond) {
        List<WhWmsOperationCountVO> cmdCountList = this.whWmsOperationRcdMapper.getCountCommandByCond(cond);
        if (EmptyUtil.isEmpty(cmdCountList)) {
            return cmdCountList;
        }
        List<WhWmsOperationCountVO> cmdSkuCountList = null;
        if (WhWmsOperationRcdVO.OPERATOR_TYPE_PICKSKU.equals(cond.getOperateType())) {
            cmdSkuCountList = this.whWmsOperationRcdMapper.getCountCommandSkuPickSkuByCond(cond);
        } else if (WhWmsOperationRcdVO.OPERATOR_TYPE_DISTRIBUTION.equals(cond.getOperateType())) {
            cmdSkuCountList = this.whWmsOperationRcdMapper.getCountCommandSkuDistributionByCond(cond);
        } else if (WhWmsOperationRcdVO.OPERATOR_TYPE_CHECKOUT.equals(cond.getOperateType())) {
            cmdSkuCountList = this.whWmsOperationRcdMapper.getCountCommandSkuCheckOutByCond(cond);
        }
        if (EmptyUtil.isNotEmpty(cmdSkuCountList)) {
            HashMap<Long, Integer> operatorSkuQuantityMap = new HashMap<Long, Integer>();
            for (WhWmsOperationCountVO count : cmdSkuCountList) {
                if (!NullUtil.isNotNull((Object)count.getOperatorId())) continue;
                operatorSkuQuantityMap.put(count.getOperatorId(), count.getCmdSkuQuantityCount());
            }
            for (WhWmsOperationCountVO count : cmdCountList) {
                Integer operatorSkuQuantity = (Integer)operatorSkuQuantityMap.get(count.getOperatorId());
                if (NullUtil.isNull((Object)operatorSkuQuantity)) {
                    operatorSkuQuantity = 0;
                }
                count.setCmdSkuQuantityCount(operatorSkuQuantity);
            }
        }
        return cmdCountList;
    }

    private List<WhWmsOperationRcdVO> buildRcdListByConnectId(Long connectId, Long operatorId) {
        List<WhWmsCommandConnectVO> cmdConList = this.whWmsCommandConnectService.findNotCanceledByConnectId(connectId);
        if (EmptyUtil.isEmpty(cmdConList)) {
            return null;
        }
        ArrayList<WhWmsOperationRcdVO> list = new ArrayList<WhWmsOperationRcdVO>();
        Date operateTime = DateUtil.getNow();
        for (WhWmsCommandConnectVO cmdcon : cmdConList) {
            WhWmsOperationRcdVO rcd = new WhWmsOperationRcdVO();
            rcd.setReferenceCode(connectId.toString());
            rcd.setOperateType(WhWmsOperationRcdVO.OPERATOR_TYPE_PICKSKU);
            rcd.setCommandCode(cmdcon.getCommandCode());
            rcd.setOperatorId(operatorId);
            rcd.setOperateTime(operateTime);
            list.add(rcd);
        }
        return list;
    }
}

