/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsOccupyMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsSkuStockMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsOccupy;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsOccupyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsOccupyVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whWmsOccupyService")
public class WhWmsOccupyServiceImpl
implements WhWmsOccupyService {
    @Autowired
    private WhWmsOccupyMapper mapper;
    @Autowired
    private WhWmsSkuStockMapper skuStockMapper;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;

    @Override
    public Boolean update(WhWmsOccupyVO vo) {
        return this.mapper.updateByPrimaryKeySelective((WhWmsOccupy)BeanUtil.buildFrom((Object)vo, WhWmsOccupy.class)) != 0;
    }

    @Override
    public WhWmsOccupyVO findById(Long id) {
        WhWmsOccupy occupy = this.mapper.selectByPrimaryKey(id);
        if (occupy != null) {
            return (WhWmsOccupyVO)BeanUtil.buildFrom((Object)occupy, WhWmsOccupyVO.class);
        }
        return null;
    }

    @Override
    public Long wmsOccupy(WhWmsOccupyVO vo) {
        ArrayList<WhWmsOccupyVO> whInvOccupyList = new ArrayList<WhWmsOccupyVO>();
        whInvOccupyList.add(vo);
        return this.wmsBatchOccupy(whInvOccupyList).get(0);
    }

    @Override
    public List<Long> wmsBatchOccupy(List<WhWmsOccupyVO> voList) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (WhWmsOccupyVO occupyVO : voList) {
            if (occupyVO.getAmount() != null && occupyVO.getAmount() < 0) {
                WhWmsSkuStockVO vo = new WhWmsSkuStockVO();
                vo.setBarCode(occupyVO.getBarCode());
                vo.setPhysicalWarehouseCode(occupyVO.getPhysicalWarehouseCode());
                vo.setHouseType(occupyVO.getHouseType());
                vo.setShelvesCode(occupyVO.getOriShelvesCode());
                vo.setSkuCode(occupyVO.getSkuCode());
                vo.setSkuStatus(occupyVO.getSkuStatus());
                List<WhWmsSkuStockVO> stockVo = this.whWmsSkuStockService.findWmsSkuAvailableAccount(vo);
                Integer availableAccount = 0;
                for (WhWmsSkuStockVO sv : stockVo) {
                    availableAccount = availableAccount + sv.getAvailableAccount();
                }
                if (availableAccount < -occupyVO.getAmount().intValue()) {
                    throw new WarehouseException("WMS Occupy", "\u5360\u7528\u5931\u8d25\uff0c\u5e93\u5b58\u4e0d\u8db3\uff08" + availableAccount + "<" + -occupyVO.getAmount().intValue() + "\uff09\u3002 \u6761\u5f62\u7801 : " + occupyVO.getBarCode() + ",[" + occupyVO.getOriShelvesCode() + "],[" + occupyVO.getSkuStatus() + "]");
                }
            }
            occupyVO.setType(NumberUtil.isNullOrZero((Number)occupyVO.getType()) ? WhWmsOccupyVO.TYPE_MOVE : occupyVO.getType());
            occupyVO.setStatus(WMSConstants.WMS_OCCUPY_STATUS_IN_USE);
            WhWmsOccupy occupy = (WhWmsOccupy)BeanUtil.buildFrom((Object)occupyVO, WhWmsOccupy.class);
            if (this.mapper.insert(occupy) <= 0) {
                throw new WarehouseException("WMS Occupy", "insert\u5931\u8d25");
            }
            result.add(occupy.getId());
        }
        return result;
    }

    @Override
    public boolean releaseWmsOccupy(WhWmsOccupyVO cond) {
        List<WhWmsOccupyVO> occupyList = this.getWmsOccupyByCond(cond);
        if (CollectionUtils.isEmpty(occupyList)) {
            throw new WarehouseException("WH0001", "releaseWmsOccupy error,the occupy is not exist[ReceiptsNo:" + cond.getReceiptsNo() + ",OccupyType:" + cond.getType() + "],OccupyStatus:" + cond.getStatus() + "]");
        }
        return this.mapper.releaseOccupy(cond) != 0;
    }

    @Override
    public boolean releaseWmsOccupyById(WhWmsOccupyVO cond) {
        List<WhWmsOccupyVO> occupyList = this.getWmsOccupyByCond(cond);
        if (CollectionUtils.isEmpty(occupyList)) {
            throw new WarehouseException("WH0001", "releaseWmsOccupy error,the occupy is not exist[ReceiptsNo:" + cond.getReceiptsNo() + ",OccupyType:" + cond.getType() + "],OccupyStatus:" + cond.getStatus() + "]");
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (WhWmsOccupyVO vo : occupyList) {
            ids.add(vo.getId());
        }
        cond.setIds(ids);
        return this.mapper.releaseOccupy(cond) != 0;
    }

    @Override
    public boolean releaseWmsOccupyByConnectId(Long connectId) {
        WhWmsOccupyVO cond = new WhWmsOccupyVO();
        cond.setReceiptsNo(connectId.toString());
        cond.setType(WhWmsOccupyVO.TYPE_CONNECT);
        cond.setStatus(WhWmsOccupyVO.OCCUPIED);
        return this.mapper.releaseOccupy(cond) != 0;
    }

    @Override
    @Transactional
    public boolean releaseWmsOccupyByConnectId(List<Long> connectIds) {
        if (EmptyUtil.isEmpty(connectIds)) {
            return false;
        }
        ArrayList<String> receiptsNoList = new ArrayList<String>();
        for (Long connectId : connectIds) {
            receiptsNoList.add(connectId.toString());
        }
        WhWmsOccupyVO cond = new WhWmsOccupyVO();
        cond.setReceiptsNoList(receiptsNoList);
        cond.setType(WhWmsOccupyVO.TYPE_CONNECT);
        cond.setStatus(WhWmsOccupyVO.OCCUPIED);
        return this.mapper.releaseOccupy(cond) != 0;
    }

    @Override
    public boolean releaseWmsOccupyByMove(WhWmsOccupyVO cond) {
        List<WhWmsOccupyVO> occupyList = this.getWmsOccupyByCond(cond);
        if (occupyList.size() > 1) {
            WhWmsOccupyVO newCond = new WhWmsOccupyVO();
            ArrayList<Long> ids = new ArrayList<Long>();
            for (WhWmsOccupyVO vo : occupyList) {
                ids.add(vo.getId());
            }
            newCond.setIds(ids);
            return this.mapper.releaseOccupy(newCond) != 0;
        }
        cond.setId(null);
        return this.mapper.releaseOccupy(cond) != 0;
    }

    @Override
    @Transactional
    public boolean releaseWmsOccupyByCond(WhWmsOccupyVO cond) {
        return this.mapper.releaseOccupy(cond) != 0;
    }

    @Override
    public List<WhWmsOccupyVO> getWmsOccupyByCond(WhWmsOccupyVO cond) {
        List<WhWmsOccupy> list = this.mapper.getByCond(cond);
        List voList = BeanUtil.buildListFrom(list, WhWmsOccupyVO.class);
        return voList;
    }
}

