/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.utils.BeanUtil;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcdSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouseRelateWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsHouseShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStock;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStockRecord;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveWarehouseProcessService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveWarehouseService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPhysicalWarehouseRelateWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveHouseShelvesExcelVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveHouseSkuStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveHouseStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="whWmsMoveWarehouseService")
public class WhWmsMoveWarehouseServiceImpl
implements WhWmsMoveWarehouseService {
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhWmsMoveWarehouseProcessService whWmsMoveWarehouseProcessService;
    private static final String newPhyWh = "WH10580083";
    private static final String oldPhyWh = "WH02060001";

    @Override
    public boolean moveStock(List<WhWmsMoveHouseShelvesExcelVO> excelList, Long operatorId) {
        if (NullUtil.isNull((Object)operatorId)) {
            operatorId = 1L;
        }
        this.convertCode(excelList);
        List<String> sourceShelvesCodes = excelList.stream().map(WhWmsMoveHouseShelvesExcelVO::getSourceShelves).collect(Collectors.toList());
        Map<String, WhWmsHouseShelves> sourceShelvesMap = this.whWmsHouseShelvesService.getHouseShelvesMapByCode(sourceShelvesCodes);
        String sourceMsg = this.phyWhShelvesCheck(sourceShelvesCodes, oldPhyWh, sourceShelvesMap);
        List<String> targetShelvesCodes = excelList.stream().map(WhWmsMoveHouseShelvesExcelVO::getTargetShelves).collect(Collectors.toList());
        Map<String, WhWmsHouseShelves> targetShelvesMap = this.whWmsHouseShelvesService.getHouseShelvesMapByCode(targetShelvesCodes);
        String targetMsg = this.phyWhShelvesCheck(targetShelvesCodes, newPhyWh, targetShelvesMap);
        if (EmptyUtil.isNotEmpty((String)sourceMsg) || EmptyUtil.isNotEmpty((String)targetMsg)) {
            throw new WarehouseException("WH0001", sourceMsg + "<br/>" + targetMsg);
        }
        HashMap<String, WhWmsHouseShelves> shelvesMap = new HashMap<String, WhWmsHouseShelves>(sourceShelvesMap);
        shelvesMap.putAll(targetShelvesMap);
        WhWmsMoveHouseStockVO moveHouseStock = this.buildWhWmsMoveStoreStockInfo(excelList, shelvesMap);
        moveHouseStock.setOperatorId(operatorId);
        this.buildAllotRcd(moveHouseStock);
        this.buildPhyWhSkuStockRcd(moveHouseStock);
        this.whWmsMoveWarehouseProcessService.process(moveHouseStock);
        return true;
    }

    private void buildAllotRcd(WhWmsMoveHouseStockVO moveHouseStock) {
        Map<Integer, Map<String, Integer>> skuStatusMap = moveHouseStock.getSkuStockList().stream().collect(Collectors.groupingBy(WhWmsMoveHouseSkuStockVO::getSkuStatus, Collectors.groupingBy(WhWmsMoveHouseSkuStockVO::getSkuCode, Collectors.summingInt(WhWmsMoveHouseSkuStockVO::getQuantity))));
        Map<Integer, String> defalutInWhMap = this.findPhyWhDefaultInWarehouseCode(moveHouseStock.getSourcePhyWhCode());
        ArrayList<WhAllotRcd> altRcdList = new ArrayList<WhAllotRcd>();
        skuStatusMap.forEach((skuStatus, skuMap) -> {
            String whCode = (String)defalutInWhMap.get(skuStatus);
            if (NullUtil.isNull((Object)whCode)) {
                throw new WarehouseException("WH0001", String.format("\u5546\u54c1\u72b6\u6001[%s]\u65e0\u9ed8\u8ba4\u5165\u5e93\u4ed3", skuStatus));
            }
            WhAllotRcd whAllotRcd = new WhAllotRcd();
            whAllotRcd.setSourcePhysicalWarehouseCode(moveHouseStock.getSourcePhyWhCode());
            whAllotRcd.setSourceWarehouseCode(whCode);
            whAllotRcd.setTargetPhysicalWarehouseCode(moveHouseStock.getTargetPhyWhCode());
            whAllotRcd.setTargetWarehouseCode(whCode);
            whAllotRcd.setCreateUserId(moveHouseStock.getOperatorId().intValue());
            whAllotRcd.setCreateTime(DateUtil.getNow());
            whAllotRcd.setEstimatedAllocationDate(DateUtil.getNow());
            whAllotRcd.setFinishTime(DateUtil.getNow());
            whAllotRcd.setAllotType(WhAllotRcd.TYPE_NORMAL);
            whAllotRcd.setAllotStatus(WhAllotRcd.STATUS_FINISHED);
            whAllotRcd.setRemark("\u642c\u4ed3\u8c03\u62e8\u5355\uff0c\u7cfb\u7edf\u81ea\u52a8\u751f\u6210");
            ArrayList<WhAllotRcdSku> rcdSkuList = new ArrayList<WhAllotRcdSku>();
            skuMap.forEach((skuCode, quantity) -> {
                WhAllotRcdSku rcdSku = new WhAllotRcdSku();
                rcdSku.setSkuCode((String)skuCode);
                rcdSku.setQuantity((Integer)quantity);
                rcdSkuList.add(rcdSku);
            });
            whAllotRcd.setWhAllotRcdSkuList(rcdSkuList);
            altRcdList.add(whAllotRcd);
        });
        moveHouseStock.setAltRcdList(altRcdList);
    }

    private void buildPhyWhSkuStockRcd(WhWmsMoveHouseStockVO moveHouseStock) {
        Date now = DateUtil.getNow();
        String receiptNo = "MVWH_" + DateUtil.format((Date)now, (String)"yyyyMMddHHmmssSSS");
        List<WhWmsSkuStockRecord> skuStockRcdList = moveHouseStock.getSkuStockList().stream().map(stock -> {
            ArrayList<WhWmsSkuStockRecord> stockRcdList = new ArrayList<WhWmsSkuStockRecord>();
            WhWmsSkuStockRecord skuOutStockRcd = (WhWmsSkuStockRecord)BeanUtil.buildFrom((Object)stock, WhWmsSkuStockRecord.class);
            skuOutStockRcd.setPhysicalWarehouseCode(stock.getSourcePhyWhCode());
            skuOutStockRcd.setHouseType(stock.getSourceShelvesHouseType());
            skuOutStockRcd.setShelvesCode(stock.getSourceShelvesCode());
            skuOutStockRcd.setQuantity(-stock.getQuantity().intValue());
            skuOutStockRcd.setCreateUserId(moveHouseStock.getOperatorId());
            skuOutStockRcd.setCreateTime(now);
            skuOutStockRcd.setReceiptNo(receiptNo);
            skuOutStockRcd.setMemo("\u642c\u4ed3\u51fa\u5e93");
            skuOutStockRcd.setInOutType(WhCommand.TYPE_ALLOT_OUT);
            skuOutStockRcd.setIsUpdateScm(1);
            stockRcdList.add(skuOutStockRcd);
            WhWmsSkuStockRecord skuInStockRcd = (WhWmsSkuStockRecord)BeanUtil.buildFrom((Object)skuOutStockRcd, WhWmsSkuStockRecord.class);
            skuInStockRcd.setPhysicalWarehouseCode(stock.getTargetPhyWhCode());
            skuInStockRcd.setHouseType(stock.getTargetShelvesHouseType());
            skuInStockRcd.setShelvesCode(stock.getTargetShelvesCode());
            skuInStockRcd.setQuantity(stock.getQuantity());
            skuInStockRcd.setInOutType(WhCommand.TYPE_ALLOT_IN);
            skuInStockRcd.setMemo("\u642c\u4ed3\u5165\u5e93");
            stockRcdList.add(skuInStockRcd);
            return stockRcdList;
        }).flatMap(Collection::stream).collect(Collectors.toList());
        moveHouseStock.setSkuStockRcdList(skuStockRcdList);
    }

    private Map<Integer, String> findPhyWhDefaultInWarehouseCode(String phyWhCode) {
        WhPhysicalWarehouseRelateWarehouseVO cond = new WhPhysicalWarehouseRelateWarehouseVO();
        cond.setPhysicalWarehouseCode(phyWhCode);
        cond.setType(WhWarehouseVO.RELATE_IN);
        List<WhPhysicalWarehouseRelateWarehouseVO> list = this.whInfoService.findPhysicalWarehouseRelateWarehouseByCond(cond);
        return list.stream().filter(relate -> WhWarehouseVO.RELATE_IN.equals(relate.getType())).collect(Collectors.toMap(WhPhysicalWarehouseRelateWarehouse::getSkuStatus, WhPhysicalWarehouseRelateWarehouse::getWarehouseCode, (r1, r2) -> r1));
    }

    private WhWmsMoveHouseStockVO buildWhWmsMoveStoreStockInfo(List<WhWmsMoveHouseShelvesExcelVO> excelList, Map<String, WhWmsHouseShelves> shelvesMap) {
        List<String> sourceShelvesCodes = excelList.stream().map(WhWmsMoveHouseShelvesExcelVO::getSourceShelves).collect(Collectors.toList());
        WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
        cond.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        cond.setShelvesCodeList(sourceShelvesCodes);
        List<WhWmsSkuStock> skuStockList = this.whWmsSkuStockService.getStockByCond(cond);
        if (EmptyUtil.isEmpty(skuStockList)) {
            skuStockList = new ArrayList<WhWmsSkuStock>();
        }
        Map<String, List<WhWmsSkuStock>> stockMap = skuStockList.stream().collect(Collectors.groupingBy(skuStock -> this.buildMapKey(skuStock.getShelvesCode(), skuStock.getSkuCode())));
        List<WhWmsMoveHouseSkuStockVO> moveSkuStockList = excelList.stream().map(excelVo -> {
            String key = this.buildMapKey(excelVo.getSourceShelves(), excelVo.getSkuCode());
            ArrayList stockList = (ArrayList)stockMap.get(key);
            if (NullUtil.isNull((Object)stockList)) {
                stockList = new ArrayList();
            }
            WhWmsHouseShelves targetShelves = (WhWmsHouseShelves)shelvesMap.get(excelVo.getTargetShelves());
            return stockList.stream().filter(stock -> stock.getAmount() > 0).map(skuStock -> {
                WhWmsMoveHouseSkuStockVO moveSkuStock = (WhWmsMoveHouseSkuStockVO)BeanUtil.buildFrom((Object)skuStock, WhWmsMoveHouseSkuStockVO.class);
                moveSkuStock.setSourcePhyWhCode(skuStock.getPhysicalWarehouseCode());
                moveSkuStock.setSourceShelvesCode(skuStock.getShelvesCode());
                moveSkuStock.setSourceShelvesHouseType(skuStock.getHouseType());
                moveSkuStock.setTargetPhyWhCode(targetShelves.getPhysicalWarehouseCode());
                moveSkuStock.setTargetShelvesCode(targetShelves.getCode());
                moveSkuStock.setTargetShelvesHouseType(targetShelves.getHouseType());
                moveSkuStock.setQuantity(skuStock.getAmount());
                return moveSkuStock;
            }).collect(Collectors.toList());
        }).flatMap(Collection::stream).collect(Collectors.toList());
        WhWmsMoveHouseStockVO moveHouseStock = new WhWmsMoveHouseStockVO();
        moveHouseStock.setSourcePhyWhCode(oldPhyWh);
        moveHouseStock.setTargetPhyWhCode(newPhyWh);
        moveHouseStock.setSkuStockList(moveSkuStockList);
        return moveHouseStock;
    }

    private String buildMapKey(String shelveCode, String skuCode) {
        return shelveCode + "_" + skuCode;
    }

    private void convertCode(List<WhWmsMoveHouseShelvesExcelVO> excelList) {
        excelList.forEach(vo -> {
            vo.setSkuCode(vo.getSkuCode().toUpperCase());
            vo.setSourceShelves(vo.getSourceShelves().toUpperCase());
            vo.setTargetShelves(vo.getTargetShelves().toUpperCase());
        });
    }

    private String phyWhShelvesCheck(List<String> sourceShelvesCodes, String phyWhCode, Map<String, WhWmsHouseShelves> sourceShelvesMap) {
        StringBuilder errorBuffer = new StringBuilder();
        int rowNum = 1;
        for (String sourceShelvesCode : sourceShelvesCodes) {
            ++rowNum;
            WhWmsHouseShelves shelves = sourceShelvesMap.get(sourceShelvesCode);
            if (NullUtil.isNull((Object)shelves)) {
                errorBuffer.append(String.format("\u884c[%s]\u5e93\u4f4d[%s]\u4e0d\u5b58\u5728\uff01<br/>", rowNum, sourceShelvesCode));
                continue;
            }
            if (phyWhCode.equals(shelves.getPhysicalWarehouseCode())) continue;
            errorBuffer.append(String.format("\u884c[%s]\u5e93\u4f4d[%s]\u7269\u7406\u4ed3\u975e[%s]\uff01<br/>", rowNum, sourceShelvesCode, phyWhCode));
        }
        return errorBuffer.toString();
    }
}

