/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.service.WhAllotService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveWarehouseProcessService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveHouseStockVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whWmsMoveWarehouseProcessService")
public class WhWmsMoveWarehouseProcessServiceImpl
implements WhWmsMoveWarehouseProcessService {
    @Autowired
    private WhAllotService whAllotService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;

    @Override
    @Transactional
    public boolean process(WhWmsMoveHouseStockVO moveHouseStock) {
        if (EmptyUtil.isEmpty(moveHouseStock.getAltRcdList()) || EmptyUtil.isEmpty(moveHouseStock.getSkuStockRcdList())) {
            return false;
        }
        this.whAllotService.recordAllotRcd(moveHouseStock.getAltRcdList());
        this.whWmsSkuStockService.batchUpdateWhSkuStock(moveHouseStock.getSkuStockRcdList());
        return true;
    }
}

