/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsMoveStorehouseBarcodeCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsMoveStorehouseCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsMoveStorehouseBarcodeMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsMoveStorehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.enums.WhWmsMoveStorehouseStatusEnum;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcdSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsHouseShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveStorehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveStorehouseBarcode;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveStorehouseBarcodeExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveStorehouseExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStockRecord;
import com.thebeastshop.pegasus.service.warehouse.service.WhAllotService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveStorehouseService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsOccupyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveStorehouseBarcodeVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveStorehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsOccupyVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whWmsMoveStorehouseService")
public class WhWmsMoveStorehouseServiceImpl
implements WhWmsMoveStorehouseService {
    private static final Logger log = LoggerFactory.getLogger(WhWmsMoveStorehouseServiceImpl.class);
    @Autowired
    private WhWmsMoveStorehouseMapper whWmsMoveStorehouseMapper;
    @Autowired
    private WhWmsMoveStorehouseBarcodeMapper whWmsMoveStorehouseBarcodeMapper;
    @Autowired
    private RedisDistributLock redisDistributLock;
    @Autowired
    private WhWmsOccupyService whWmsOccupyService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;
    @Autowired
    private WhAllotService whAllotService;

    @Override
    public List<WhWmsMoveStorehouseVO> listWhWmsMoveStorehouseVOsByCond(WhWmsMoveStorehouseCond cond) {
        return this.whWmsMoveStorehouseMapper.listWhWmsMoveStorehouseVOsByCond(cond);
    }

    @Override
    public List<WhWmsMoveStorehouse> listWhWmsMoveStorehouseByCond(WhWmsMoveStorehouseCond cond) {
        WhWmsMoveStorehouseExample example = this.buildWhWmsMoveStorehouseExampleByCond(cond);
        return this.whWmsMoveStorehouseMapper.selectByExample(example);
    }

    @Override
    public void updateWhWmsMoveStorehouse(WhWmsMoveStorehouse record, WhWmsMoveStorehouseExample example) {
        this.whWmsMoveStorehouseMapper.updateByExampleSelective(record, example);
    }

    @Override
    public WhWmsMoveStorehouse findWhWmsMoveStorehouseById(Long id) {
        if (EmptyUtil.isEmpty((Object)id)) {
            return null;
        }
        return this.whWmsMoveStorehouseMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<WhWmsMoveStorehouseBarcodeVO> listWhWmsMoveStorehouseBarcodeVOsByCond(WhWmsMoveStorehouseBarcodeCond cond) {
        return this.whWmsMoveStorehouseBarcodeMapper.listWhWmsMoveStorehouseBarcodeVOsByCond(cond);
    }

    @Override
    public List<WhWmsMoveStorehouseBarcode> listWhWmsMoveStorehouseBarcodeByCond(WhWmsMoveStorehouseBarcodeCond cond) {
        WhWmsMoveStorehouseBarcodeExample example = this.buildWhWmsMoveStorehouseBarcodeExampleByCond(cond);
        return this.whWmsMoveStorehouseBarcodeMapper.selectByExample(example);
    }

    @Override
    @Transactional
    public void addOrEditWhWmsMoveStorehouseVO(WhWmsMoveStorehouseVO moveStorehouseVO) {
        if (EmptyUtil.isNotEmpty((Object)moveStorehouseVO.getId())) {
            WhWmsMoveStorehouseVO info = this.findWhWmsMoveStorehouseById(moveStorehouseVO.getId(), false);
            moveStorehouseVO.setCode(info.getCode());
            moveStorehouseVO.setSourcePhyCode(info.getSourcePhyCode());
            this.addMoveStorehouseBarcodes(moveStorehouseVO.getId(), moveStorehouseVO.getCode(), moveStorehouseVO.getMoveStorehouseBarcodes());
        } else {
            this.addMoveStorehouseAndBarcodes(moveStorehouseVO);
        }
        this.wmsOccupy(moveStorehouseVO.getMoveStorehouseBarcodes(), moveStorehouseVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wmsOccupy(List<WhWmsMoveStorehouseBarcode> moveStorehouseBarcodes, WhWmsMoveStorehouseVO vo) {
        if (EmptyUtil.isEmpty((String)vo.getSourcePhyCode()) || EmptyUtil.isEmpty((String)vo.getCode())) {
            throw new WarehouseException("WH0001", "\u53c2\u6570\u5f02\u5e38");
        }
        String lockKey = "lock:whWmsMoveStorehouse:wmsOccupy:" + vo.getCode();
        try {
            Boolean getLock = this.redisDistributLock.tryLock(lockKey, 3L, TimeUnit.SECONDS);
            if (!getLock.booleanValue()) {
                log.error("\u83b7\u53d6\u9501\u5931\u8d25   false  lockKey=" + lockKey);
                throw new WarehouseException("WH0001", "\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            Map<String, WhWmsHouseShelves> shelvesMap = this.getHouseTypeMapByBarcodes(moveStorehouseBarcodes);
            ArrayList<WhWmsOccupyVO> occupyList = new ArrayList<WhWmsOccupyVO>();
            for (WhWmsMoveStorehouseBarcode bc : moveStorehouseBarcodes) {
                if (!EmptyUtil.isNotEmpty((Object)shelvesMap.get(bc.getShelvesCode()))) continue;
                WhWmsOccupyVO occupyVO = new WhWmsOccupyVO();
                occupyVO.setSkuCode(bc.getSkuCode());
                occupyVO.setBarCode(bc.getBarCode());
                occupyVO.setSkuStatus(bc.getSkuStatus());
                occupyVO.setAmount(-bc.getQuantity().intValue());
                occupyVO.setHouseType(shelvesMap.get(bc.getShelvesCode()).getHouseType());
                occupyVO.setPhysicalWarehouseCode(vo.getSourcePhyCode());
                occupyVO.setReceiptsNo(vo.getCode() + "_" + bc.getId());
                occupyVO.setOriShelvesCode(bc.getShelvesCode());
                occupyVO.setType(WhWmsOccupyVO.TYPE_MOVE_STOREHOUSE);
                occupyVO.setStatus(WhWmsOccupyVO.OCCUPIED);
                occupyList.add(occupyVO);
            }
            this.whWmsOccupyService.wmsBatchOccupy(occupyList);
        }
        finally {
            this.redisDistributLock.unLock(lockKey);
        }
    }

    private Map<String, WhWmsHouseShelves> getHouseTypeMapByBarcodes(List<WhWmsMoveStorehouseBarcode> moveStorehouseBarcodes) {
        HashSet<String> shelvesCodes = new HashSet<String>();
        for (WhWmsMoveStorehouseBarcode barcode : moveStorehouseBarcodes) {
            shelvesCodes.add(barcode.getShelvesCode());
        }
        List<WhWmsHouseShelves> whWmsHouseShelves = this.whWmsHouseShelvesService.getHouseShelvesByCode(new ArrayList<String>(shelvesCodes));
        HashMap<String, WhWmsHouseShelves> shelvesMap = new HashMap<String, WhWmsHouseShelves>();
        for (WhWmsHouseShelves houseShelves : whWmsHouseShelves) {
            shelvesMap.put(houseShelves.getCode(), houseShelves);
        }
        return shelvesMap;
    }

    private void addMoveStorehouseAndBarcodes(WhWmsMoveStorehouseVO moveStorehouseVO) {
        WhWmsMoveStorehouse moveStorehouse = this.addWhWmsMoveStorehouse((WhWmsMoveStorehouse)BeanUtil.buildFrom((Object)moveStorehouseVO, WhWmsMoveStorehouse.class));
        moveStorehouseVO.setId(moveStorehouse.getId());
        this.addMoveStorehouseBarcodes(moveStorehouse.getId(), moveStorehouse.getCode(), moveStorehouseVO.getMoveStorehouseBarcodes());
    }

    private WhWmsMoveStorehouse addWhWmsMoveStorehouse(WhWmsMoveStorehouse moveStorehouse) {
        moveStorehouse.setCreateTime(DateUtil.getNow());
        this.whWmsMoveStorehouseMapper.insert(moveStorehouse);
        return moveStorehouse;
    }

    private void addMoveStorehouseBarcodes(Long refId, String refCode, List<WhWmsMoveStorehouseBarcode> moveStorehouseBarcodes) {
        if (CollectionUtils.isNotEmpty(moveStorehouseBarcodes)) {
            moveStorehouseBarcodes.forEach(bc -> {
                bc.setRefId(refId);
                bc.setRefCode(refCode);
                bc.setCreateTime(DateUtil.getNow());
                this.whWmsMoveStorehouseBarcodeMapper.insert((WhWmsMoveStorehouseBarcode)bc);
            });
        }
    }

    private WhWmsMoveStorehouseVO findWaitPutAwayMoveStorehouseByCode(String code) {
        WhWmsMoveStorehouseExample example = new WhWmsMoveStorehouseExample();
        example.createCriteria().andCodeEqualTo(code).andStatusEqualTo(WhWmsMoveStorehouseStatusEnum.truck_loaded.getValue());
        List<WhWmsMoveStorehouse> list = this.whWmsMoveStorehouseMapper.selectByExample(example);
        if (EmptyUtil.isEmpty(list)) {
            throw new WarehouseException("WH0001", String.format("[%s]\u65e0\u5f85\u4e0a\u67b6\u4efb\u52a1\uff01", code));
        }
        if (list.size() > 1) {
            throw new WarehouseException("WH0001", String.format("[%s]\u4e0a\u67b6\u4efb\u52a1\u6570\u636e\u5f02\u5e38\uff01", code));
        }
        WhWmsMoveStorehouseVO vo = (WhWmsMoveStorehouseVO)BeanUtil.buildFrom((Object)list.get(0), WhWmsMoveStorehouseVO.class);
        WhWmsMoveStorehouseBarcodeCond bcCond = new WhWmsMoveStorehouseBarcodeCond();
        bcCond.setRefId(vo.getId());
        List<WhWmsMoveStorehouseBarcodeVO> bcList = this.listWhWmsMoveStorehouseBarcodeVOsByCond(bcCond);
        vo.setMoveStorehouseBarcodeVOs(bcList);
        return vo;
    }

    @Override
    public WhWmsMoveStorehouseVO findWhWmsMoveStorehouseById(Long id, boolean cascade) {
        WhWmsMoveStorehouse moveStorehouse = this.whWmsMoveStorehouseMapper.selectByPrimaryKey(id);
        WhWmsMoveStorehouseVO vo = (WhWmsMoveStorehouseVO)BeanUtil.buildFrom((Object)moveStorehouse, WhWmsMoveStorehouseVO.class);
        if (NullUtil.isNotNull((Object)vo) && cascade) {
            WhWmsMoveStorehouseBarcodeCond bcCond = new WhWmsMoveStorehouseBarcodeCond();
            bcCond.setRefId(vo.getId());
            List<WhWmsMoveStorehouseBarcodeVO> bcList = this.listWhWmsMoveStorehouseBarcodeVOsByCond(bcCond);
            vo.setMoveStorehouseBarcodeVOs(bcList);
        }
        return vo;
    }

    @Override
    @Transactional
    public boolean moveStorehousePutAway(WhWmsMoveStorehouseVO vo) {
        if (WhWmsMoveStorehouseStatusEnum.in_storged.getValue().equals(vo.getStatus())) {
            throw new WarehouseException("WH0001", String.format("[%s]\u5f53\u524d\u72b6\u6001[%s]", vo.getCode(), WhWmsMoveStorehouseStatusEnum.getDescByValue(vo.getStatus())));
        }
        WhPhysicalWarehouse targetPhyWh = this.whInfoService.findPhysicalWarehouseByCode(vo.getTargetPhyCode());
        if (NullUtil.isNull((Object)targetPhyWh)) {
            throw new WarehouseException("WH0001", String.format("[%s]\u7269\u7406\u4ed3\u4e0d\u5b58\u5728\uff01", vo.getTargetPhyCode()));
        }
        WhWmsHouseShelvesVO targetShelves = this.whWmsHouseShelvesService.getHouseShelvesByCode(vo.getTargetShelvesCode());
        if (NullUtil.isNull((Object)targetShelves) || !targetShelves.getPhysicalWarehouseCode().equals(vo.getTargetPhyCode())) {
            throw new WarehouseException("WH0001", String.format("[%s]%s\u5e93\u4f4d\u4e0d\u5b58\u5728\uff01", vo.getTargetPhyCode(), vo.getTargetShelvesCode()));
        }
        this.updateMoveStorehouseFinish(vo);
        this.releaseWmsOccupy(vo);
        if (vo.getSourcePhyCode().equals(vo.getTargetPhyCode())) {
            return this.createMoveStockThenFinish(vo);
        }
        this.generateWhAltRcd(vo);
        this.processPhyWhSkuStock(vo);
        return true;
    }

    private void updateMoveStorehouseFinish(WhWmsMoveStorehouseVO vo) {
        boolean success;
        if (NullUtil.isNull((Object)vo.getFinishTime())) {
            vo.setFinishTime(DateUtil.getNow());
        }
        if (NullUtil.isNull((Object)vo.getFinishUserId())) {
            vo.setFinishUserId(1L);
        }
        vo.setStatus(WhWmsMoveStorehouseStatusEnum.in_storged.getValue());
        WhWmsMoveStorehouseExample example = new WhWmsMoveStorehouseExample();
        example.createCriteria().andIdEqualTo(vo.getId());
        boolean bl = success = this.whWmsMoveStorehouseMapper.updateByExampleSelective(vo, example) == 1;
        if (!success) {
            WhWmsMoveStorehouse tmp = this.findWhWmsMoveStorehouseById(vo.getId());
            throw new WarehouseException("WH0001", String.format("\u5f53\u524d\u72b6\u6001[%s]", this.getMoveStorehouseStatusName(tmp.getStatus())));
        }
    }

    private String getMoveStorehouseStatusName(Integer status) {
        WhWmsMoveStorehouseStatusEnum statusEnum = WhWmsMoveStorehouseStatusEnum.getEnumByValue(status);
        if (NullUtil.isNull((Object)((Object)statusEnum))) {
            return "";
        }
        return statusEnum.getDesc();
    }

    private boolean releaseWmsOccupy(WhWmsMoveStorehouseVO vo) {
        List<String> receiptsNoList = vo.getMoveStorehouseBarcodeVOs().stream().map(bc -> bc.getRefCode() + '_' + bc.getId()).collect(Collectors.toList());
        WhWmsOccupyVO cond = new WhWmsOccupyVO();
        cond.setReceiptsNoList(receiptsNoList);
        cond.setType(WhWmsOccupyVO.TYPE_MOVE_STOREHOUSE);
        cond.setStatus(WhWmsOccupyVO.OCCUPIED);
        return this.whWmsOccupyService.releaseWmsOccupyByCond(cond);
    }

    private boolean generateWhAltRcd(WhWmsMoveStorehouseVO vo) {
        Map<Integer, Map<String, Integer>> skuStatusMap = vo.getMoveStorehouseBarcodeVOs().stream().collect(Collectors.groupingBy(WhWmsMoveStorehouseBarcode::getSkuStatus, Collectors.groupingBy(WhWmsMoveStorehouseBarcode::getSkuCode, Collectors.summingInt(WhWmsMoveStorehouseBarcode::getQuantity))));
        ArrayList<WhAllotRcd> altRcdList = new ArrayList<WhAllotRcd>();
        skuStatusMap.forEach((skuStatus, skuMap) -> {
            WhWarehouse wh = this.whInfoService.findDefaultInOrOutWarehouseByPhyWhCode(vo.getSourcePhyCode(), WhWarehouseVO.RELATE_IN, (Integer)skuStatus);
            WhAllotRcd whAllotRcd = new WhAllotRcd();
            whAllotRcd.setSourcePhysicalWarehouseCode(vo.getSourcePhyCode());
            whAllotRcd.setSourceWarehouseCode(wh.getCode());
            whAllotRcd.setTargetPhysicalWarehouseCode(vo.getTargetPhyCode());
            whAllotRcd.setTargetWarehouseCode(wh.getCode());
            whAllotRcd.setCreateUserId(vo.getFinishUserId().intValue());
            whAllotRcd.setCreateTime(DateUtil.getNow());
            whAllotRcd.setEstimatedAllocationDate(DateUtil.getNow());
            whAllotRcd.setFinishTime(DateUtil.getNow());
            whAllotRcd.setAllotType(WhAllotRcd.TYPE_NORMAL);
            whAllotRcd.setAllotStatus(WhAllotRcd.STATUS_FINISHED);
            whAllotRcd.setRemark("\u642c\u4ed3-\u81ea\u52a8\u521b\u5efa");
            ArrayList<WhAllotRcdSku> rcdSkuList = new ArrayList<WhAllotRcdSku>();
            skuMap.forEach((skuCode, quantity) -> {
                WhAllotRcdSku rcdSku = new WhAllotRcdSku();
                rcdSku.setSkuCode((String)skuCode);
                rcdSku.setQuantity((Integer)quantity);
                rcdSkuList.add(rcdSku);
            });
            whAllotRcd.setWhAllotRcdSkuList(rcdSkuList);
            altRcdList.add(whAllotRcd);
        });
        this.whAllotService.recordAllotRcd(altRcdList);
        return true;
    }

    private boolean processPhyWhSkuStock(WhWmsMoveStorehouseVO vo) {
        List<String> shelvesCodes = vo.getMoveStorehouseBarcodeVOs().stream().map(WhWmsMoveStorehouseBarcode::getShelvesCode).distinct().collect(Collectors.toList());
        List<WhWmsHouseShelves> sourceShelvesList = this.whWmsHouseShelvesService.getHouseShelvesByCode(shelvesCodes);
        Map<String, WhWmsHouseShelves> sourceShelvesMap = sourceShelvesList.stream().collect(Collectors.toMap(WhWmsHouseShelves::getCode, s -> s, (s1, s2) -> s1));
        WhWmsHouseShelvesVO targetShelves = this.whWmsHouseShelvesService.getHouseShelvesByCode(vo.getTargetShelvesCode());
        if (NullUtil.isNull((Object)targetShelves)) {
            throw new WarehouseException("WH0001", String.format("[%s]\u5e93\u5b58\u4e0d\u5b58\u5728\uff01", vo.getTargetShelvesCode()));
        }
        List<WhWmsSkuStockRecord> skuStockRcdList = vo.getMoveStorehouseBarcodeVOs().stream().map(bc -> {
            ArrayList<WhWmsSkuStockRecord> stockRcdList = new ArrayList<WhWmsSkuStockRecord>();
            WhWmsHouseShelves sourceShelves = (WhWmsHouseShelves)sourceShelvesMap.get(bc.getShelvesCode());
            WhWmsSkuStockRecord skuOutStockRcd = (WhWmsSkuStockRecord)BeanUtil.buildFrom((Object)bc, WhWmsSkuStockRecord.class);
            skuOutStockRcd.setPhysicalWarehouseCode(vo.getSourcePhyCode());
            skuOutStockRcd.setHouseType(sourceShelves.getHouseType());
            skuOutStockRcd.setShelvesCode(sourceShelves.getCode());
            skuOutStockRcd.setQuantity(-bc.getQuantity().intValue());
            skuOutStockRcd.setCreateUserId(vo.getFinishUserId());
            skuOutStockRcd.setCreateTime(DateUtil.getNow());
            skuOutStockRcd.setReceiptNo(vo.getId() + "_" + bc.getId());
            skuOutStockRcd.setMemo("\u642c\u4ed3\u51fa\u5e93");
            skuOutStockRcd.setInOutType(WhCommand.TYPE_ALLOT_OUT);
            skuOutStockRcd.setIsUpdateScm(1);
            stockRcdList.add(skuOutStockRcd);
            WhWmsSkuStockRecord skuInStockRcd = (WhWmsSkuStockRecord)BeanUtil.buildFrom((Object)skuOutStockRcd, WhWmsSkuStockRecord.class);
            skuInStockRcd.setPhysicalWarehouseCode(vo.getTargetPhyCode());
            skuInStockRcd.setHouseType(targetShelves.getHouseType());
            skuInStockRcd.setShelvesCode(targetShelves.getCode());
            skuInStockRcd.setQuantity(bc.getQuantity());
            skuInStockRcd.setInOutType(WhCommand.TYPE_ALLOT_IN);
            skuInStockRcd.setMemo("\u642c\u4ed3\u5165\u5e93");
            stockRcdList.add(skuInStockRcd);
            return stockRcdList;
        }).flatMap(Collection::stream).collect(Collectors.toList());
        this.whWmsSkuStockService.batchUpdateWhSkuStock(skuStockRcdList);
        return true;
    }

    private boolean createMoveStockThenFinish(WhWmsMoveStorehouseVO vo) {
        WhWmsMoveStockVO moveStockInfo = new WhWmsMoveStockVO();
        moveStockInfo.setPhysicalWarehouseCode(vo.getSourcePhyCode());
        moveStockInfo.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_COMMON);
        moveStockInfo.setReferenceCode(vo.getId().toString());
        moveStockInfo.setCreateUserId(vo.getFinishUserId());
        moveStockInfo.setCreateTime(DateUtil.getNow());
        moveStockInfo.setOperatorId(vo.getFinishUserId());
        moveStockInfo.setOperateTime(DateUtil.getNow());
        List<String> shelvesCodes = vo.getMoveStorehouseBarcodeVOs().stream().map(WhWmsMoveStorehouseBarcode::getShelvesCode).distinct().collect(Collectors.toList());
        List<WhWmsHouseShelves> sourceShelvesList = this.whWmsHouseShelvesService.getHouseShelvesByCode(shelvesCodes);
        Map<String, WhWmsHouseShelves> sourceShelvesMap = sourceShelvesList.stream().collect(Collectors.toMap(WhWmsHouseShelves::getCode, s -> s, (s1, s2) -> s1));
        WhWmsHouseShelvesVO targetShelves = this.whWmsHouseShelvesService.getHouseShelvesByCode(vo.getTargetShelvesCode());
        if (NullUtil.isNull((Object)targetShelves)) {
            throw new WarehouseException("WH0001", String.format("[%s]\u5e93\u5b58\u4e0d\u5b58\u5728\uff01", vo.getTargetShelvesCode()));
        }
        Map skuStatusMap = vo.getMoveStorehouseBarcodeVOs().stream().collect(Collectors.groupingBy(WhWmsMoveStorehouseBarcode::getSkuStatus, Collectors.toList()));
        ArrayList moveStockList = new ArrayList();
        skuStatusMap.forEach((skuStatus, bcList) -> {
            WhWmsMoveStockVO moveStock = (WhWmsMoveStockVO)BeanUtil.buildFrom((Object)moveStockInfo, WhWmsMoveStockVO.class);
            List<WhWmsMoveSkuVO> moveSkuList = bcList.stream().map(bc -> {
                WhWmsHouseShelves sourceShelves = (WhWmsHouseShelves)sourceShelvesMap.get(bc.getShelvesCode());
                WhWmsMoveSkuVO moveSku = (WhWmsMoveSkuVO)BeanUtil.buildFrom((Object)bc, WhWmsMoveSkuVO.class);
                moveSku.setOriginalHouseType(sourceShelves.getHouseType());
                moveSku.setOriginalShelvesCode(sourceShelves.getCode());
                moveSku.setTargetHouseType(targetShelves.getHouseType());
                moveSku.setTargetShelvesCode(targetShelves.getCode());
                moveSku.setAmount(bc.getQuantity());
                moveSku.setSkuStatus((Integer)skuStatus);
                return moveSku;
            }).collect(Collectors.toList());
            moveStock.setMoveSkuList(moveSkuList);
            moveStockList.add(moveStock);
        });
        moveStockList.forEach(moveStock -> {
            this.whWmsMoveStockService.rebuildMoveStock((WhWmsMoveStockVO)moveStock);
            this.whWmsMoveStockService.executeMoveStock((WhWmsMoveStockVO)moveStock);
        });
        return true;
    }

    private WhWmsMoveStorehouseExample buildWhWmsMoveStorehouseExampleByCond(WhWmsMoveStorehouseCond cond) {
        WhWmsMoveStorehouseExample example = new WhWmsMoveStorehouseExample();
        WhWmsMoveStorehouseExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)cond.getId())) {
            criteria.andIdEqualTo(cond.getId());
        } else if (CollectionUtils.isNotEmpty(cond.getIds())) {
            criteria.andIdIn((List)cond.getIds());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getCode())) {
            criteria.andCodeEqualTo(cond.getCode());
        } else if (CollectionUtils.isNotEmpty(cond.getCodes())) {
            criteria.andCodeIn((List)cond.getCodes());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getStatus())) {
            criteria.andStatusEqualTo(cond.getStatus());
        } else if (CollectionUtils.isNotEmpty(cond.getStatusList())) {
            criteria.andStatusIn((List)cond.getStatusList());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getSourcePhyCode())) {
            criteria.andSourcePhyCodeEqualTo(cond.getSourcePhyCode());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getTargetPhyCode())) {
            criteria.andTargetPhyCodeEqualTo(cond.getTargetPhyCode());
        }
        return example;
    }

    private WhWmsMoveStorehouseBarcodeExample buildWhWmsMoveStorehouseBarcodeExampleByCond(WhWmsMoveStorehouseBarcodeCond cond) {
        WhWmsMoveStorehouseBarcodeExample example = new WhWmsMoveStorehouseBarcodeExample();
        WhWmsMoveStorehouseBarcodeExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)cond.getId())) {
            criteria.andIdEqualTo(cond.getId());
        } else if (CollectionUtils.isNotEmpty(cond.getIds())) {
            criteria.andIdIn((List)cond.getIds());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getRefId())) {
            criteria.andRefIdEqualTo(cond.getRefId());
        } else if (CollectionUtils.isNotEmpty(cond.getRefIds())) {
            criteria.andRefIdIn((List)cond.getRefIds());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getRefCode())) {
            criteria.andRefCodeEqualTo(cond.getRefCode());
        } else if (CollectionUtils.isNotEmpty(cond.getRefCodes())) {
            criteria.andRefCodeIn((List)cond.getRefCodes());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getSkuCode())) {
            criteria.andSkuCodeEqualTo(cond.getSkuCode());
        } else if (CollectionUtils.isNotEmpty(cond.getSkuCodes())) {
            criteria.andSkuCodeIn((List)cond.getSkuCodes());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getBarCode())) {
            criteria.andBarCodeEqualTo(cond.getBarCode());
        } else if (CollectionUtils.isNotEmpty(cond.getBarCodes())) {
            criteria.andBarCodeIn((List)cond.getBarCodes());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getShelvesCode())) {
            criteria.andShelvesCodeEqualTo(cond.getShelvesCode());
        } else if (CollectionUtils.isNotEmpty(cond.getShelvesCodes())) {
            criteria.andShelvesCodeIn((List)cond.getShelvesCodes());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getSkuStatus())) {
            criteria.andSkuStatusEqualTo(cond.getSkuStatus());
        } else if (CollectionUtils.isNotEmpty(cond.getSkuStatusList())) {
            criteria.andSkuStatusIn((List)cond.getSkuStatusList());
        } else if (CollectionUtils.isNotEmpty(cond.getNotSkuStatusList())) {
            criteria.andSkuStatusNotIn((List)cond.getNotSkuStatusList());
        }
        return example;
    }
}

