/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsMoveStockCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsReplenishInfoCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsMoveSkuMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsMoveStockMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveSkuExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveStock;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveStockExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReplenishInfo;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveSkuService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsOccupyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsReplenishInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsTaskAssignService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsOccupyVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReplenishInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsTaskAssignVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Service(value="whWmsMoveStockService")
public class WhWmsMoveStockServiceImpl
implements WhWmsMoveStockService {
    private static final Logger log = LoggerFactory.getLogger(WhWmsMoveStockServiceImpl.class);
    @Autowired
    private WhWmsMoveStockMapper whWmsMoveStockMapper;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhWmsOccupyService whWmsOccupyService;
    @Autowired
    private WhWmsMoveSkuService whWmsMoveSkuService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsMoveSkuMapper whWmsMoveSkuMapper;
    @Autowired
    private WhWmsTaskAssignService whWmsTaskAssignService;
    @Autowired
    private WhWmsReplenishInfoService whWmsReplenishInfoService;

    @Override
    public Pagination<WhWmsMoveStockVO> getMoveStockByCond(WhWmsMoveStockCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        List<WhWmsMoveStockVO> list = this.whWmsMoveStockMapper.getMoveStockByCond(cond);
        Integer counts = this.whWmsMoveStockMapper.countMoveStockByCond(cond);
        page.setResultList(list);
        page.setRecord(counts);
        return page;
    }

    @Override
    public List<WhWmsMoveStockVO> getMoveStockByCodes(List<String> moveCodes, boolean cascade) {
        if (EmptyUtil.isEmpty(moveCodes)) {
            return new ArrayList<WhWmsMoveStockVO>();
        }
        WhWmsMoveStockExample example = new WhWmsMoveStockExample();
        example.createCriteria().andCodeIn((List)moveCodes);
        List<WhWmsMoveStock> list = this.whWmsMoveStockMapper.selectByExample(example);
        List rtList = BeanUtil.buildListFrom(list, WhWmsMoveStockVO.class);
        if (cascade) {
            this.fullMoveStockSku(rtList);
        }
        return rtList;
    }

    private void fullMoveStockSku(List<WhWmsMoveStockVO> moveStockList) {
        if (EmptyUtil.isEmpty(moveStockList)) {
            return;
        }
        List codeList = moveStockList.stream().map(WhWmsMoveStockVO::getCode).collect(Collectors.toList());
        WhWmsMoveSkuExample example = new WhWmsMoveSkuExample();
        example.createCriteria().andMoveCodeIn(codeList);
        List<WhWmsMoveSku> moveSkuList = this.whWmsMoveSkuMapper.selectByExample(example);
        List voList = BeanUtil.buildListFrom(moveSkuList, WhWmsMoveSkuVO.class);
        Map<String, List<WhWmsMoveSkuVO>> groupMapByMoveCode = voList.stream().collect(Collectors.groupingBy(WhWmsMoveSku::getMoveCode));
        moveStockList.forEach(moveStock -> {
            List list = (List)groupMapByMoveCode.get(moveStock.getCode());
            moveStock.setMoveSkuList(list);
        });
    }

    @Override
    public List<WhWmsMoveSkuVO> findMoveStockSkuRf(String moveCode) {
        return this.whWmsMoveSkuMapper.findMoveStockSkuRf(moveCode);
    }

    @Override
    public WhWmsMoveStock getMoveStockById(Long id) {
        return this.whWmsMoveStockMapper.selectByPrimaryKey(new Long(id));
    }

    @Override
    public WhWmsMoveStockVO getMoveStockByCode(String code) {
        WhWmsMoveStockExample example = new WhWmsMoveStockExample();
        example.createCriteria().andCodeEqualTo(code);
        List<WhWmsMoveStock> moveStock = this.whWmsMoveStockMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(moveStock)) {
            return null;
        }
        return (WhWmsMoveStockVO)BeanUtil.buildListFrom(moveStock, WhWmsMoveStockVO.class).get(0);
    }

    private String createNewStockCode() {
        String newCode = "MS" + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS") + this.getCodeRandom();
        if (EmptyUtil.isNotEmpty((Object)this.getMoveStockByCode(newCode))) {
            newCode = this.createNewStockCode();
        }
        return newCode;
    }

    private int getCodeRandom() {
        return (int)Math.floor(Math.random() * 10.0);
    }

    @Override
    @Transactional
    public Boolean newMoveStock(WhWmsMoveStockVO moveStockVO) {
        this.rebuildMoveStock(moveStockVO);
        this.moveStockCheck(moveStockVO);
        int newMoveStock = this.whWmsMoveStockMapper.insert(moveStockVO);
        if (newMoveStock <= 0) {
            throw new WarehouseException("WH0001", "\u79fb\u5e93\u521b\u5efa\u5931\u8d25\uff01");
        }
        this.whWmsMoveSkuService.batchCreateMoveSku(moveStockVO.getMoveSkuList());
        List<WhWmsOccupyVO> occupyList = this.buildMoveStockOccupy(moveStockVO);
        this.whWmsOccupyService.wmsBatchOccupy(occupyList);
        return true;
    }

    private List<WhWmsMoveSku> findMoveSkuListByMoveCode(String moveCode) {
        WhWmsMoveSkuExample example = new WhWmsMoveSkuExample();
        example.createCriteria().andMoveCodeEqualTo(moveCode);
        return this.whWmsMoveSkuMapper.selectByExample(example);
    }

    @Override
    public boolean buildMoveStock(WhWmsMoveStockVO moveStockVO) {
        this.rebuildMoveStock(moveStockVO);
        this.moveStockCheck(moveStockVO);
        List<WhWmsMoveSkuVO> skuList = moveStockVO.getMoveSkuList();
        ArrayList<WhWmsOccupyVO> occupyList = new ArrayList<WhWmsOccupyVO>();
        for (WhWmsMoveSkuVO moveSkuVO : skuList) {
            WhWmsOccupyVO occupyOri = new WhWmsOccupyVO();
            occupyOri.setSkuCode(moveSkuVO.getSkuCode());
            occupyOri.setBarCode(moveSkuVO.getBarCode());
            occupyOri.setSkuStatus(moveSkuVO.getSkuStatus());
            occupyOri.setAmount(-moveSkuVO.getAmount().intValue());
            occupyOri.setHouseType(moveSkuVO.getOriginalHouseType());
            occupyOri.setPhysicalWarehouseCode(moveStockVO.getPhysicalWarehouseCode());
            occupyOri.setReceiptsNo(moveStockVO.getCode());
            occupyOri.setOriShelvesCode(moveSkuVO.getOriginalShelvesCode());
            if (EmptyUtil.isEmpty((Object)moveSkuVO.getMoveType())) {
                occupyOri.setType(WhWmsOccupyVO.TYPE_MOVE);
            }
            occupyOri.setStatus(WhWmsOccupyVO.OCCUPIED);
            occupyList.add(occupyOri);
        }
        moveStockVO.setOccupyList(occupyList);
        return true;
    }

    @Override
    @Transactional
    public String createMoveStock(WhWmsMoveStockVO moveStockVO) {
        int newMoveStock = this.whWmsMoveStockMapper.insert(moveStockVO);
        if (newMoveStock <= 0) {
            throw new WarehouseException("WH0001", "\u79fb\u5e93\u521b\u5efa\u5931\u8d25\uff01");
        }
        this.whWmsMoveSkuService.batchCreateMoveSku(moveStockVO.getMoveSkuList());
        List<WhWmsOccupyVO> occupyList = this.buildMoveStockOccupy(moveStockVO);
        this.whWmsOccupyService.wmsBatchOccupy(occupyList);
        return moveStockVO.getCode();
    }

    private List<WhWmsOccupyVO> buildMoveStockOccupy(WhWmsMoveStockVO moveStockVO) {
        List<WhWmsMoveSku> moveSkuList = this.findMoveSkuListByMoveCode(moveStockVO.getCode());
        ArrayList<WhWmsOccupyVO> occupyList = new ArrayList<WhWmsOccupyVO>();
        for (WhWmsMoveSku moveSkuVO : moveSkuList) {
            WhWmsOccupyVO occupyOri = new WhWmsOccupyVO();
            occupyOri.setSkuCode(moveSkuVO.getSkuCode());
            occupyOri.setBarCode(moveSkuVO.getBarCode());
            occupyOri.setSkuStatus(moveSkuVO.getSkuStatus());
            occupyOri.setAmount(-moveSkuVO.getAmount().intValue());
            occupyOri.setHouseType(moveSkuVO.getOriginalHouseType());
            occupyOri.setPhysicalWarehouseCode(moveStockVO.getPhysicalWarehouseCode());
            occupyOri.setReceiptsNo(moveSkuVO.getId().toString());
            occupyOri.setOriShelvesCode(moveSkuVO.getOriginalShelvesCode());
            if (EmptyUtil.isEmpty((Object)moveStockVO.getMoveType())) {
                occupyOri.setType(WhWmsOccupyVO.TYPE_MOVE);
            }
            occupyOri.setStatus(WhWmsOccupyVO.OCCUPIED);
            occupyList.add(occupyOri);
        }
        return occupyList;
    }

    @Override
    public String executeMoveStock(WhWmsMoveStockVO moveStockVO) {
        moveStockVO.setOperateTime(DateUtil.getNow());
        moveStockVO.setOperatorId(moveStockVO.getCreateUserId());
        moveStockVO.setStatus(WhWmsMoveStockVO.STATUS_FINISHED);
        int newMoveStock = this.whWmsMoveStockMapper.insert(moveStockVO);
        if (newMoveStock <= 0) {
            throw new WarehouseException("WH0001", "\u79fb\u5e93\u521b\u5efa\u5931\u8d25\uff01");
        }
        this.whWmsMoveSkuService.batchCreateMoveSku(moveStockVO.getMoveSkuList());
        for (WhWmsMoveSkuVO moveSkuVO : moveStockVO.getMoveSkuList()) {
            this.whWmsSkuStockService.updateStockByCond(-moveSkuVO.getAmount().intValue(), moveStockVO.getPhysicalWarehouseCode(), moveSkuVO.getOriginalHouseType(), moveSkuVO.getBarCode(), moveSkuVO.getOriginalShelvesCode(), moveSkuVO.getSkuCode(), moveSkuVO.getSkuStatus(), WhInvRcd.TYPE_MOVE_OUT, moveSkuVO.getMoveCode(), moveStockVO.getOperatorId());
            this.whWmsSkuStockService.updateStockByCond(moveSkuVO.getAmount(), moveStockVO.getPhysicalWarehouseCode(), moveSkuVO.getTargetHouseType(), moveSkuVO.getBarCode(), moveSkuVO.getTargetShelvesCode(), moveSkuVO.getSkuCode(), moveSkuVO.getSkuStatus(), WhInvRcd.TYPE_MOVE_IN, moveSkuVO.getMoveCode(), moveStockVO.getOperatorId());
        }
        return moveStockVO.getCode();
    }

    @Override
    @Transactional
    public String quickMoveStock(WhWmsMoveStockVO moveStockVO) {
        this.rebuildMoveStock(moveStockVO);
        this.moveStockCheck(moveStockVO);
        moveStockVO.setOperateTime(DateUtil.getNow());
        moveStockVO.setOperatorId(moveStockVO.getCreateUserId());
        moveStockVO.setStatus(WhWmsMoveStockVO.STATUS_FINISHED);
        int newMoveStock = this.whWmsMoveStockMapper.insert(moveStockVO);
        if (newMoveStock <= 0) {
            throw new WarehouseException("WH0001", "\u79fb\u5e93\u521b\u5efa\u5931\u8d25\uff01");
        }
        this.whWmsMoveSkuService.batchCreateMoveSku(moveStockVO.getMoveSkuList());
        for (WhWmsMoveSkuVO moveSkuVO : moveStockVO.getMoveSkuList()) {
            this.whWmsSkuStockService.updateStockByCond(-moveSkuVO.getAmount().intValue(), moveStockVO.getPhysicalWarehouseCode(), moveSkuVO.getOriginalHouseType(), moveSkuVO.getBarCode(), moveSkuVO.getOriginalShelvesCode(), moveSkuVO.getSkuCode(), moveSkuVO.getSkuStatus(), WhInvRcd.TYPE_MOVE_OUT, moveSkuVO.getMoveCode(), moveStockVO.getOperatorId());
            this.whWmsSkuStockService.updateStockByCond(moveSkuVO.getAmount(), moveStockVO.getPhysicalWarehouseCode(), moveSkuVO.getTargetHouseType(), moveSkuVO.getBarCode(), moveSkuVO.getTargetShelvesCode(), moveSkuVO.getSkuCode(), moveSkuVO.getSkuStatus(), WhInvRcd.TYPE_MOVE_IN, moveSkuVO.getMoveCode(), moveStockVO.getOperatorId());
        }
        return moveStockVO.getCode();
    }

    @Override
    public void rebuildMoveStock(WhWmsMoveStockVO moveStockVO) {
        if (EmptyUtil.isEmpty((Object)moveStockVO)) {
            throw new WarehouseException("WH0001", "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (EmptyUtil.isEmpty(moveStockVO.getMoveSkuList())) {
            throw new WarehouseException("WH0001", "\u79fb\u5e93\u884c\u4fe1\u606f\u4e3a\u7a7a");
        }
        moveStockVO.setCode(this.createNewStockCode());
        List<WhWmsMoveSkuVO> moveSkuVOs = moveStockVO.getMoveSkuList();
        HashMap<String, WhWmsMoveSkuVO> map = new HashMap<String, WhWmsMoveSkuVO>();
        for (WhWmsMoveSkuVO vo : moveSkuVOs) {
            StringBuffer sb = new StringBuffer();
            sb.append(vo.getOriginalShelvesCode());
            sb.append("_");
            sb.append(vo.getSkuCode());
            sb.append("_");
            sb.append(vo.getBarCode());
            sb.append("_");
            sb.append(vo.getSkuStatus());
            sb.append("_").append(vo.getTargetShelvesCode());
            if (vo.getAmount() <= 0) continue;
            if (map.get(sb.toString()) == null) {
                map.put(sb.toString(), vo);
                continue;
            }
            WhWmsMoveSkuVO whWmsMoveSkuVO = (WhWmsMoveSkuVO)map.get(sb.toString());
            whWmsMoveSkuVO.setAmount(whWmsMoveSkuVO.getAmount() + vo.getAmount());
        }
        ArrayList<WhWmsMoveSkuVO> moveSkuVOList = new ArrayList<WhWmsMoveSkuVO>();
        for (WhWmsMoveSkuVO vo : map.values()) {
            vo.setMoveCode(moveStockVO.getCode());
            moveSkuVOList.add(vo);
        }
        moveStockVO.setMoveSkuList(moveSkuVOList);
        moveStockVO.setStatus(WhWmsMoveStockVO.STATUS_WAITTINT_OUT);
        moveStockVO.setCreateTime(new Date());
    }

    @Override
    public void moveStockCheck(WhWmsMoveStockVO moveStockVO) {
        WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
        for (WhWmsMoveSkuVO moveSkuVO : moveStockVO.getMoveSkuList()) {
            if (EmptyUtil.isEmpty((String)moveSkuVO.getPhysicalWarehouseCode()) || EmptyUtil.isEmpty((String)moveSkuVO.getOriginalHouseType()) || EmptyUtil.isEmpty((String)moveSkuVO.getOriginalShelvesCode()) || EmptyUtil.isEmpty((String)moveSkuVO.getTargetShelvesCode()) || EmptyUtil.isEmpty((String)moveSkuVO.getTargetHouseType()) || EmptyUtil.isEmpty((String)moveSkuVO.getBarCode()) || moveSkuVO.getAmount() <= 0) {
                throw new WarehouseException("WH0001", "\u79fb\u5e93\u884c\u53c2\u6570\u4fe1\u606f\u4e3a\u7a7a</br>");
            }
            if (EmptyUtil.isEmpty((Object)this.whWmsHouseShelvesService.getHouseShelvesByCode(moveSkuVO.getOriginalShelvesCode()))) {
                throw new WarehouseException("WH0001", "\u6e90\u5e93\u4f4d[" + moveSkuVO.getOriginalShelvesCode() + "]\u4e0d\u5b58\u5728</br>");
            }
            if (EmptyUtil.isEmpty((Object)this.whWmsHouseShelvesService.getHouseShelvesByCode(moveSkuVO.getTargetShelvesCode()))) {
                throw new WarehouseException("WH0001", "\u76ee\u6807\u5e93\u4f4d[" + moveSkuVO.getTargetShelvesCode() + "]\u4e0d\u5b58\u5728</br>");
            }
            if (NumberUtil.isNullOrZero((Number)moveSkuVO.getAmount())) {
                throw new WarehouseException("WH0001", "\u79fb\u5e93\u6570\u91cf\u4e3a\u7a7a\u6216\u96f6</br>");
            }
            if (moveSkuVO.getOriginalShelvesCode().equals(moveSkuVO.getTargetShelvesCode())) {
                throw new WarehouseException("WH0001", "\u6e90\u5e93\u4f4d\u548c\u76ee\u6807\u5e93\u4f4d\u4e00\u81f4</br>");
            }
            cond.setSkuStatus(moveSkuVO.getSkuStatus());
            cond.setBarCode(moveSkuVO.getBarCode());
            cond.setPhysicalWarehouseCode(moveStockVO.getPhysicalWarehouseCode());
            cond.setHouseType(moveSkuVO.getOriginalHouseType());
            cond.setShelvesCode(moveSkuVO.getOriginalShelvesCode());
            cond.setSkuCode(moveSkuVO.getSkuCode());
        }
    }

    @Override
    @Transactional
    public Boolean createMoveStockThenFinish(WhWmsMoveStockVO moveStockVO) {
        this.quickMoveStock(moveStockVO);
        return true;
    }

    @Override
    @Transactional
    public Boolean moveStockFinishByMoveSku(String moveCode, Long operatorId, Long moveSkuId) {
        boolean result = false;
        Boolean update = false;
        WhWmsMoveStockVO moveStockVO = this.getMoveStockByCode(moveCode);
        if (EmptyUtil.isEmpty((Object)moveStockVO)) {
            throw new WarehouseException("", "error,not fund[" + moveCode + "]");
        }
        List<WhWmsMoveSkuVO> moveSkuVOs = moveStockVO.getMoveSkuVOs();
        boolean isFinished = true;
        if (WhWmsMoveStockVO.STATUS_WAITTINT_OUT.equals(moveStockVO.getStatus()) || WhWmsMoveStockVO.STATUS_PROCESSING.equals(moveStockVO.getStatus())) {
            for (WhWmsMoveSkuVO moveSkuVO : moveSkuVOs) {
                if (moveSkuVO.getId().equals(moveSkuId) && (moveSkuVO.getStatus() == null || moveSkuVO.getStatus().equals(WhWmsMoveSku.MOVE_SKU_STATUS_WAIT_MOVE))) {
                    Boolean bl = this.doMoveStock(moveSkuVO, moveStockVO, operatorId);
                }
                if (moveSkuVO.getStatus() != null && !moveSkuVO.getStatus().equals(WhWmsMoveSku.MOVE_SKU_STATUS_WAIT_MOVE)) continue;
                isFinished = false;
            }
            if (isFinished) {
                update = this.updateMoveStockStatusToFinish(moveStockVO);
            }
            if (!isFinished && WhWmsMoveStockVO.STATUS_WAITTINT_OUT.equals(moveStockVO.getStatus())) {
                this.updateMoveStockStatusToProcessing(moveStockVO.getId());
            }
            return update;
        }
        if (moveStockVO.getStatus() == WhWmsMoveStockVO.STATUS_WAITTING_IN) {
            throw new WarehouseException("", "[" + moveCode + "]\u72b6\u6001\u4e0d\u5408\u6cd5");
        }
        if (moveStockVO.getStatus() == WhWmsMoveStockVO.STATUS_FINISHED) {
            throw new WarehouseException("", "\u79fb\u5e93\u5355\u5df2\u5b8c\u6210[" + moveCode + "]");
        }
        return false;
    }

    @Override
    @Transactional
    public Boolean moveStockFinishByMoveSku(String moveCode, Long operatorId, Long moveSkuId, WhWmsTaskAssignVO taskAssignVO) {
        boolean result = this.moveStockFinishByMoveSku(moveCode, operatorId, moveSkuId);
        WhWmsMoveStockVO moveStockVO = this.getMoveStockByCode(moveCode);
        if (WhWmsMoveStockVO.STATUS_FINISHED.equals(moveStockVO.getStatus())) {
            this.whWmsTaskAssignService.finishTaskAssigned(taskAssignVO.getId(), taskAssignVO.getOperatorId());
        }
        return result;
    }

    @Override
    @Transactional
    public Boolean moveStockFinishByMoveSku(WhWmsMoveSkuVO whWmsMoveSkuVO, WhWmsTaskAssignVO taskAssignVO) {
        WhWmsMoveSkuVO oriMoveSkuVO = this.whWmsMoveSkuService.getMoveSkuById(whWmsMoveSkuVO.getId());
        if (NullUtil.isNull((Object)oriMoveSkuVO)) {
            throw new WarehouseException("WH0001", String.format("[%s]\u79fb\u5e93\u884c\u4e0d\u5b58\u5728\uff01", whWmsMoveSkuVO.getId()));
        }
        if (!oriMoveSkuVO.getTargetShelvesCode().equals(whWmsMoveSkuVO.getTargetShelvesCode())) {
            WhWmsMoveSku update = new WhWmsMoveSku();
            update.setId(oriMoveSkuVO.getId());
            update.setRecommendTargetShelvesCode(oriMoveSkuVO.getTargetShelvesCode());
            update.setRecommendTargetHouseType(oriMoveSkuVO.getTargetHouseType());
            update.setTargetShelvesCode(whWmsMoveSkuVO.getTargetShelvesCode());
            update.setTargetHouseType(whWmsMoveSkuVO.getTargetHouseType());
            this.whWmsMoveSkuMapper.updateByPrimaryKeySelective(update);
        }
        if (WhWmsMoveStockVO.STATUS_FINISHED.equals(oriMoveSkuVO.getStatus())) {
            throw new WarehouseException("WH0001", String.format("[%s]\u79fb\u5e93\u884c\u5df2\u5b8c\u6210", whWmsMoveSkuVO.getId()));
        }
        if (WhWmsMoveStockVO.STATUS_CANCEL.equals(oriMoveSkuVO.getStatus())) {
            throw new WarehouseException("WH0001", String.format("[%s]\u79fb\u5e93\u884c\u5df2\u53d6\u6d88", whWmsMoveSkuVO.getId()));
        }
        boolean result = this.moveStockFinishByMoveSku(oriMoveSkuVO.getMoveCode(), taskAssignVO.getOperatorId(), oriMoveSkuVO.getId(), taskAssignVO);
        if (result && !oriMoveSkuVO.getTargetShelvesCode().equals(whWmsMoveSkuVO.getTargetShelvesCode())) {
            WhWmsMoveSku update = new WhWmsMoveSku();
            update.setId(oriMoveSkuVO.getId());
            update.setTargetShelvesCode(whWmsMoveSkuVO.getTargetShelvesCode());
            this.whWmsMoveSkuMapper.updateByPrimaryKeySelective(update);
        }
        return result;
    }

    @Override
    public List<WhWmsMoveStock> findWmsMoveStockByPrdCode(String prdCode) {
        return this.whWmsMoveStockMapper.findWmsMoveStockByPrdCode(prdCode);
    }

    @Override
    public Integer cancelWmsMoveStockByIdList(List<Long> idList) {
        return this.whWmsMoveStockMapper.cancelWmsMoveStockByIdList(idList);
    }

    @Override
    @Transactional
    public void cancelMoveStock(List<WhWmsMoveStockVO> list, Long operatorId) {
        if (list != null && list.size() > 0) {
            for (WhWmsMoveStockVO vo : list) {
                vo.getMoveSkuList().forEach(moveSku -> {
                    WhWmsOccupyVO occupyVO = new WhWmsOccupyVO();
                    occupyVO.setReceiptsNo(moveSku.getId().toString());
                    occupyVO.setType(WhWmsOccupyVO.TYPE_MOVE);
                    this.whWmsOccupyService.releaseWmsOccupyByMove(occupyVO);
                });
                WhWmsMoveStock whWmsMoveStock = new WhWmsMoveStock();
                whWmsMoveStock.setId(vo.getId());
                whWmsMoveStock.setStatus(WhWmsMoveStockVO.STATUS_CANCEL);
                whWmsMoveStock.setOperatorId(operatorId);
                whWmsMoveStock.setOperateTime(Calendar.getInstance().getTime());
                this.whWmsMoveStockMapper.updateByPrimaryKeySelective(whWmsMoveStock);
            }
        }
    }

    @Override
    @Transactional
    public Boolean doMoveStockAndReleaseOccupyAndFinish(String moveCode, Long operatorId) {
        int result = 0;
        Boolean update = false;
        WhWmsMoveStockVO moveStockVO = this.getMoveStockByCode(moveCode);
        if (EmptyUtil.isEmpty((Object)moveStockVO)) {
            throw new WarehouseException("WH0001", "\u79fb\u5e93\u5355[" + moveCode + "]\u4e0d\u5b58\u5728");
        }
        List<WhWmsMoveSkuVO> moveSkuVOs = moveStockVO.getMoveSkuVOs();
        if (WhWmsMoveStockVO.STATUS_WAITTINT_OUT.equals(moveStockVO.getStatus())) {
            for (WhWmsMoveSkuVO moveSkuVO : moveSkuVOs) {
                Boolean success = this.doMoveStock(moveSkuVO, moveStockVO, operatorId);
                if (!success.booleanValue()) continue;
                ++result;
            }
            if (result == moveSkuVOs.size()) {
                moveStockVO.setOperatorId(operatorId);
                moveStockVO.setOperateTime(DateUtil.getNow());
                update = this.updateMoveStockStatusToFinish(moveStockVO);
            }
            return update;
        }
        if (moveStockVO.getStatus() == WhWmsMoveStockVO.STATUS_WAITTING_IN) {
            throw new WarehouseException("", "[" + moveCode + "]not open");
        }
        if (WhWmsMoveStockVO.STATUS_FINISHED.equals(moveStockVO.getStatus())) {
            throw new WarehouseException("WH0001", "\u79fb\u5e93\u5355[" + moveCode + "]\u5df2\u5b8c\u6210");
        }
        return false;
    }

    @Transactional
    private Boolean doMoveStock(WhWmsMoveSkuVO moveSkuVO, WhWmsMoveStockVO moveStockVO, Long operatorId) {
        if (EmptyUtil.isEmpty((String)moveSkuVO.getPhysicalWarehouseCode()) || EmptyUtil.isEmpty((Object)moveSkuVO.getAmount()) || EmptyUtil.isEmpty((String)moveSkuVO.getOriginalHouseType()) || EmptyUtil.isEmpty((String)moveSkuVO.getOriginalShelvesCode()) || EmptyUtil.isEmpty((String)moveSkuVO.getOriginalHouseType()) || EmptyUtil.isEmpty((String)moveSkuVO.getTargetShelvesCode()) || EmptyUtil.isEmpty((String)moveSkuVO.getTargetHouseType()) || EmptyUtil.isEmpty((String)moveSkuVO.getBarCode())) {
            throw new WarehouseException("", "null param!");
        }
        long time1 = Calendar.getInstance().getTimeInMillis();
        WhWmsOccupyVO oriOccupyCond = new WhWmsOccupyVO();
        oriOccupyCond.setBarCode(moveSkuVO.getBarCode());
        oriOccupyCond.setOriShelvesCode(moveSkuVO.getOriginalShelvesCode());
        oriOccupyCond.setAmount(-moveSkuVO.getAmount().intValue());
        oriOccupyCond.setReceiptsNo(moveSkuVO.getId().toString());
        oriOccupyCond.setSkuStatus(moveSkuVO.getSkuStatus());
        oriOccupyCond.setStatus(WhWmsOccupyVO.OCCUPIED);
        oriOccupyCond.setSkuCode(moveSkuVO.getSkuCode());
        oriOccupyCond.setPhysicalWarehouseCode(moveStockVO.getPhysicalWarehouseCode());
        oriOccupyCond.setHouseType(moveSkuVO.getOriginalHouseType());
        List<WhWmsOccupyVO> occupyVOList = this.whWmsOccupyService.getWmsOccupyByCond(oriOccupyCond);
        if (occupyVOList.size() > 1) {
            throw new WarehouseException("", "the occupy is not unique[" + moveStockVO.getCode() + "][" + moveSkuVO.getBarCode() + "]");
        }
        if (CollectionUtils.isEmpty(occupyVOList)) {
            throw new WarehouseException("", "the occupy is not exist[" + moveStockVO.getCode() + "][" + moveSkuVO.getBarCode() + "]");
        }
        long time2 = Calendar.getInstance().getTimeInMillis();
        log.warn(moveStockVO.getCode() + "\u79fb\u5e93\u5355\u6267\u884c\u7b2c1\u6b65\u8017\u8d39\u65f6\u95f4\uff1a" + (time2 - time1) + ";skuCode\uff1a" + moveSkuVO.getSkuCode());
        this.whWmsSkuStockService.updateStockByCond(-moveSkuVO.getAmount().intValue(), moveStockVO.getPhysicalWarehouseCode(), moveSkuVO.getOriginalHouseType(), moveSkuVO.getBarCode(), moveSkuVO.getOriginalShelvesCode(), moveSkuVO.getSkuCode(), moveSkuVO.getSkuStatus(), WhInvRcd.TYPE_MOVE_OUT, moveSkuVO.getMoveCode(), operatorId);
        long time3 = Calendar.getInstance().getTimeInMillis();
        log.warn(moveStockVO.getCode() + "\u79fb\u5e93\u5355\u6267\u884c\u7b2c2\u6b65\u8017\u8d39\u65f6\u95f4\uff1a" + (time3 - time2) + ";skuCode\uff1a" + moveSkuVO.getSkuCode());
        boolean success = this.whWmsOccupyService.releaseWmsOccupyByMove(oriOccupyCond);
        if (!success) {
            throw new WarehouseException("WH0001", "\u79fb\u5e93\u91ca\u653e\u5360\u7528\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
        long time4 = Calendar.getInstance().getTimeInMillis();
        log.warn(moveStockVO.getCode() + "\u79fb\u5e93\u5355\u6267\u884c\u7b2c3\u6b65\u8017\u8d39\u65f6\u95f4\uff1a" + (time4 - time3) + ";skuCode\uff1a" + moveSkuVO.getSkuCode());
        this.whWmsSkuStockService.updateStockByCond(moveSkuVO.getAmount(), moveStockVO.getPhysicalWarehouseCode(), moveSkuVO.getTargetHouseType(), moveSkuVO.getBarCode(), moveSkuVO.getTargetShelvesCode(), moveSkuVO.getSkuCode(), moveSkuVO.getSkuStatus(), WhInvRcd.TYPE_MOVE_IN, moveSkuVO.getMoveCode(), operatorId);
        long time5 = Calendar.getInstance().getTimeInMillis();
        log.warn(moveStockVO.getCode() + "\u79fb\u5e93\u5355\u6267\u884c\u7b2c4\u6b65\u8017\u8d39\u65f6\u95f4\uff1a" + (time5 - time4) + ";skuCode\uff1a" + moveSkuVO.getSkuCode());
        WhWmsMoveSku whWmsMoveSku = this.whWmsMoveSkuMapper.selectByPrimaryKey(moveSkuVO.getId());
        whWmsMoveSku.setStatus(WhWmsMoveSku.MOVE_SKU_STATUS_FINISH);
        this.whWmsMoveSkuMapper.updateByPrimaryKey(whWmsMoveSku);
        moveSkuVO.setStatus(WhWmsMoveSku.MOVE_SKU_STATUS_FINISH);
        return true;
    }

    public Boolean updateMoveStockStatusToFinish(WhWmsMoveStockVO moveStockVO) {
        moveStockVO.setStatus(WhWmsMoveStockVO.STATUS_FINISHED);
        int result = this.whWmsMoveStockMapper.updateByPrimaryKeySelective(moveStockVO);
        if (result <= 0) {
            throw new WarehouseException("", "\u66f4\u65b0\u5931\u8d25!");
        }
        this.updateReplenishStatusAfterMoveStockFinished(moveStockVO.getCode());
        return true;
    }

    private void updateReplenishStatusAfterMoveStockFinished(String moveStockCode) {
        WhWmsReplenishInfoCond cond = new WhWmsReplenishInfoCond();
        cond.setRefCode(moveStockCode);
        cond.setRefType(WhWmsReplenishInfoVO.REF_TYPE_MOVE_STOCK);
        List<WhWmsReplenishInfo> replenishInfos = this.whWmsReplenishInfoService.listWhWmsReplenishInfoByCond(cond);
        if (CollectionUtils.isNotEmpty(replenishInfos)) {
            this.whWmsReplenishInfoService.updateWhWmsReplenishInfoStatesByRefCode(cond.getRefCode(), cond.getRefType(), WhWmsReplenishInfoVO.STATES_REPLENISH_FINISHED);
        }
    }

    public boolean updateMoveStockStatusToProcessing(Long moveStockId) {
        WhWmsMoveStock update = new WhWmsMoveStock();
        update.setId(moveStockId);
        update.setStatus(WhWmsMoveStockVO.STATUS_PROCESSING);
        int result = this.whWmsMoveStockMapper.updateByPrimaryKeySelective(update);
        if (result <= 0) {
            throw new WarehouseException("", "\u66f4\u65b0\u5931\u8d25!");
        }
        return true;
    }
}

