/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsMoveSkuCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsMoveSkuMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveSkuService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveSkuVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Service(value="whWmsMoveSkuService")
public class WhWmsMoveSkuServiceImpl
implements WhWmsMoveSkuService {
    @Autowired
    private WhWmsMoveSkuMapper whWmsMoveSkuMapper;

    @Override
    public List<WhWmsMoveSkuVO> getMoveSkuByMoveCode(String moveCode) {
        List<WhWmsMoveSkuVO> list = this.whWmsMoveSkuMapper.getByMoveCode(moveCode);
        return list;
    }

    @Override
    @Transactional
    public Boolean newMoveSkuVO(WhWmsMoveSkuVO moveSkuVO) {
        if (EmptyUtil.isEmpty((String)moveSkuVO.getMoveCode())) {
            throw new WarehouseException("", "[" + moveSkuVO.getOriginalShelvesCode() + "][" + moveSkuVO.getBarCode() + "]\u521b\u5efa\u79fb\u5e93\u4efb\u52a1\u884c\u5931\u8d25");
        }
        int result = this.whWmsMoveSkuMapper.insert(moveSkuVO);
        if (result <= 0) {
            throw new WarehouseException("", "[" + moveSkuVO.getOriginalShelvesCode() + "][" + moveSkuVO.getBarCode() + "]\u6dfb\u52a0\u79fb\u5e93\u4efb\u52a1\u884c\u5931\u8d25");
        }
        return true;
    }

    @Override
    @Transactional
    public boolean batchCreateMoveSku(List<WhWmsMoveSkuVO> moveSkuVOList) {
        if (EmptyUtil.isEmpty(moveSkuVOList)) {
            throw new WarehouseException("WH0001", "\u79fb\u5e93\u884c\u4e3a\u7a7a\uff01");
        }
        this.whWmsMoveSkuMapper.batchInsert(moveSkuVOList);
        return true;
    }

    @Override
    public Pagination<WhWmsMoveSkuVO> getMoveSkuByMoveByCondPage(WhWmsMoveSkuCond cond) {
        Pagination pagination = new Pagination(cond.getCurrpage(), cond.getPagenum());
        pagination.setRecord(Integer.valueOf(this.whWmsMoveSkuMapper.getMoveSkuCountByCond(cond)));
        pagination.setResultList(this.whWmsMoveSkuMapper.getMoveSkuByCond(cond));
        return pagination;
    }

    @Override
    public WhWmsMoveSkuVO getMoveSkuById(Long id) {
        WhWmsMoveSkuCond cond = new WhWmsMoveSkuCond();
        cond.setId(id);
        List<WhWmsMoveSkuVO> moveSkuVOs = this.whWmsMoveSkuMapper.getMoveSkuByCond(cond);
        if (CollectionUtils.isEmpty(moveSkuVOs)) {
            return null;
        }
        return moveSkuVOs.get(0);
    }

    @Override
    public List<WhWmsMoveSkuVO> getMoveSkuByMoveByCond(WhWmsMoveSkuCond cond) {
        return this.whWmsMoveSkuMapper.getMoveSkuByCond(cond);
    }
}

