/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhPhysicalWarehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWarehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsManualInOutMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouseExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsManualInOut;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuBarcode;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsManualInOutService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuBarcodeService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsManualInOutVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuBarcodeVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="whWmsManualInOutService")
public class WhWmsManualInOutServiceImpl
implements WhWmsManualInOutService {
    private final Logger log = LoggerFactory.getLogger(WhWmsManualInOutServiceImpl.class);
    @Autowired
    private WhWmsManualInOutMapper whWmsManualInOutMapper;
    @Autowired
    private WhWmsSkuBarcodeService whWmsSkuBarcodeService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhWarehouseMapper whWarehouseMapper;
    @Autowired
    private WhPhysicalWarehouseMapper whPhysicalWarehouseMapper;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private RedisDistributLock redisDistributLock;

    @Override
    public int insert(WhWmsManualInOut record) {
        return this.whWmsManualInOutMapper.insertSelective(record);
    }

    @Override
    public int update(WhWmsManualInOut record) {
        return this.whWmsManualInOutMapper.updateByPrimaryKey(record);
    }

    @Override
    public boolean manualInOutStock(WhWmsManualInOutVO vo) throws Exception {
        if (vo.getQuantity() == null || vo.getShelvesCode() == null || vo.getSkuCode() == null || vo.getSkuStatus() == null || vo.getInOutType() == null || vo.getCreateUserId() == null) {
            throw new WarehouseException("WH0002", "NullPointerException");
        }
        String lockKey = "lock:wms:manualInOutStock:" + vo.getShelvesCode();
        try {
            Boolean getLock = this.redisDistributLock.tryLock(lockKey, 3L, TimeUnit.SECONDS);
            if (!getLock.booleanValue()) {
                this.log.info("\u83b7\u53d6\u9501\u5931\u8d25   false");
                throw new WarehouseException("WH0001", "\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            WhWmsHouseShelvesCond tarcond = new WhWmsHouseShelvesCond();
            tarcond.setCode(vo.getShelvesCode());
            tarcond.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
            List<WhWmsHouseShelvesVO> tarShelvesList = this.whWmsHouseShelvesService.getHouseShelvesByCond(tarcond);
            WhWmsHouseShelvesVO tarVo = null;
            if (tarShelvesList == null || tarShelvesList.size() <= 0) {
                throw new WarehouseException("WH0001", vo.getShelvesCode() + "\u8bbe\u7f6e\u7684\u76ee\u6807\u5e93\u4f4d\u4e0d\u5b58\u5728");
            }
            tarVo = tarShelvesList.get(0);
            if (this.isOut(vo.getInOutType())) {
                WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
                cond.setSkuCode(vo.getSkuCode());
                cond.setShelvesCode(vo.getShelvesCode());
                cond.setSkuStatus(vo.getSkuStatus());
                cond.setBarCode(vo.getBarCode());
                List<WhWmsSkuStockVO> shelvesStocks = this.whWmsSkuStockService.getWmsSkuStocksByShelvesCond(cond);
                if (EmptyUtil.isEmpty(shelvesStocks)) {
                    StringBuilder prefix = new StringBuilder();
                    prefix.append(vo.getShelvesCode()).append("[").append(vo.getSkuCode()).append("][").append(vo.getProductTime() != null ? vo.getProductTime() : vo.getBarCode()).append("]");
                    throw new WarehouseException("WH0001", prefix.toString() + "\u5e93\u5b58\u4e0d\u8db3!");
                }
                int avaAmount = 0;
                for (WhWmsSkuStockVO shelvesStock : shelvesStocks) {
                    avaAmount += shelvesStock.getAvailableAmount().intValue();
                }
                if (avaAmount + vo.getQuantity() < 0) {
                    StringBuilder prefix = new StringBuilder();
                    prefix.append(vo.getShelvesCode()).append("[").append(vo.getSkuCode()).append("][").append(vo.getProductTime() != null ? vo.getProductTime() : vo.getBarCode()).append("]");
                    throw new WarehouseException("WH0001", prefix.toString() + "\u5e93\u5b58\u4e0d\u8db3!");
                }
            }
            vo.setCode(null);
            vo.setPhysicalWarehouseCode(tarVo.getPhysicalWarehouseCode());
            this.insert(vo);
            String barCode = null;
            barCode = !StringUtils.isEmpty((Object)vo.getBarCode()) ? vo.getBarCode() : this.getBarCode(vo.getSkuCode(), vo.getProductTime());
            String code = "M" + vo.getId();
            vo.setCode(code);
            vo.setHouseType(tarVo.getHouseType());
            vo.setBarCode(barCode);
            this.update(vo);
            try {
                this.whWmsSkuStockService.updateStockByCond(vo.getQuantity(), tarVo.getPhysicalWarehouseCode(), tarVo.getHouseType(), barCode, vo.getShelvesCode(), vo.getSkuCode(), vo.getSkuStatus(), vo.getInOutType(), code, vo.getCreateUserId(), vo.getMemo(), WhWmsManualInOutVO.NEED_UPDATE_SCM_STOCK.equals(vo.getIsUpdateStock()) ? 1 : 2);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                StringBuilder prefix = new StringBuilder();
                prefix.append("[").append(vo.getShelvesCode()).append("][").append(vo.getSkuCode()).append("][").append(vo.getProductTime() != null ? vo.getProductTime() : vo.getBarCode()).append("]");
                throw new WarehouseException("WH0001", prefix.toString() + msg);
            }
            if (WhWmsManualInOutVO.NEED_UPDATE_SCM_STOCK.equals(vo.getIsUpdateStock())) {
                WhPhysicalWarehouseExample whPhysicalWarehouseExample = new WhPhysicalWarehouseExample();
                whPhysicalWarehouseExample.createCriteria().andCodeEqualTo(vo.getPhysicalWarehouseCode());
                List<WhPhysicalWarehouse> whPhysicalWarehouseList = this.whPhysicalWarehouseMapper.selectByExample(whPhysicalWarehouseExample);
                List<WhWarehouse> whWarehouseList = this.whInfoService.findWarehouseByPhysicalCodeAndStatus(whPhysicalWarehouseList.get(0).getCode(), vo.getSkuStatus());
                if (whWarehouseList != null && whWarehouseList.size() > 0) {
                    WhCommand whCommand = new WhCommand();
                    whCommand.setReferenceCode(vo.getCode());
                    whCommand.setWarehouseCode(whWarehouseList.get(0).getCode());
                    whCommand.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
                    Integer quantity = vo.getQuantity();
                    if (this.isOut(vo.getInOutType())) {
                        quantity = -quantity.intValue();
                    }
                    whCommand.setInOutType(vo.getInOutType());
                    ArrayList<WhCommandSku> skuList = new ArrayList<WhCommandSku>();
                    WhCommandSku commandSku = new WhCommandSku();
                    commandSku.setSkuCode(vo.getSkuCode());
                    commandSku.setPlanedQuantity(quantity);
                    skuList.add(commandSku);
                    whCommand.setWhCommandSkuList(skuList);
                    this.whCommandService.createCommandThenFinish(whCommand);
                } else {
                    throw new WarehouseException("WH0001", "\u66f4\u65b0\u5e93\u5b58\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u903b\u8f91\u4ed3\u5e93");
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.redisDistributLock.unLock(lockKey);
        }
    }

    @Override
    public boolean manualInOutStock(List<WhWmsManualInOutVO> records) throws Exception {
        boolean result;
        block1: {
            WhWmsManualInOutVO vo;
            result = false;
            if (records == null) break block1;
            Iterator<WhWmsManualInOutVO> iterator = records.iterator();
            while (iterator.hasNext() && (result = this.manualInOutStock(vo = iterator.next()))) {
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getBarCode(String skuCode, String prodDateStr) {
        WhWmsSkuBarcode skuBarcodeVo;
        Date expirationDate = null;
        Date prodDate = null;
        int batchNo = 1;
        Integer shelfLife = this.whWmsSkuBarcodeService.findSkuShelfLifeBySkuCode(skuCode);
        if (shelfLife != null && shelfLife > 0) {
            if (StringUtils.isEmpty((Object)prodDateStr)) {
                throw new WarehouseException("WH0002", "\u8bf7\u8f93\u5165\u751f\u4ea7\u65e5\u671f");
            }
            prodDate = DateUtil.parse((String)prodDateStr, (String)"yyyy-MM-dd");
            expirationDate = DateUtil.addDay((Date)prodDate, (int)shelfLife);
        }
        if (expirationDate != null) {
            skuBarcodeVo = this.whWmsSkuBarcodeService.findMaxBatchNo(skuCode, DateUtil.format(expirationDate, (String)"yyyy-MM-dd"), prodDateStr);
            if (skuBarcodeVo != null) return skuBarcodeVo.getBarCode();
            skuBarcodeVo = this.whWmsSkuBarcodeService.findMaxBatchNo(skuCode, null, null);
            if (skuBarcodeVo == null) return this.createBarCode(skuCode, batchNo, expirationDate, prodDate);
            batchNo = skuBarcodeVo.getBatchNo() + 1;
            return this.createBarCode(skuCode, batchNo, expirationDate, prodDate);
        } else {
            skuBarcodeVo = this.whWmsSkuBarcodeService.findMaxBatchNo(skuCode, null, null);
            if (skuBarcodeVo == null) return this.createBarCode(skuCode, batchNo, expirationDate, prodDate);
            return skuBarcodeVo.getBarCode();
        }
    }

    private String createBarCode(String skuCode, int batchNo, Date expirationDate, Date prodDate) {
        WhWmsSkuBarcodeVO bcVO = new WhWmsSkuBarcodeVO();
        bcVO.setSkuCode(skuCode);
        bcVO.setBatchNo(batchNo);
        bcVO.setProdDate(prodDate);
        bcVO.setExpirationDate(expirationDate);
        StringBuilder batch = new StringBuilder();
        batch.append(batchNo);
        while (batch.length() < 4) {
            batch.insert(0, "0");
        }
        String barcode = skuCode + "_" + batch.toString();
        bcVO.setBarCode(barcode.toString());
        this.whWmsSkuBarcodeService.create(bcVO);
        return barcode.toString();
    }

    private boolean isOut(Integer inOutType) {
        return inOutType / 10 == 2;
    }
}

