/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsInventoryPlanCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsInventoryPlanDiffDetailCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsInventoryPlanShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsInventoryPlanShelvesDetailCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsInventoryPlanCheckRcdMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsInventoryPlanMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsInventoryPlanShelvesDetailMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsInventoryPlanShelvesMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhTakeStockRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsHouseShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsInventoryPlanShelvesDetailExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsInventoryPlanShelvesExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsInventoryPlanDiffService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsInventoryService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsTaskAssignService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCountVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsInventoryPlanCheckRcdVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsInventoryPlanDiffDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsInventoryPlanDiffProcessVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsInventoryPlanShelvesDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsInventoryPlanShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsInventoryPlanVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsTaskAssignVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Service(value="whWmsInventoryService")
public class WhWmsInventoryServiceImpl
implements WhWmsInventoryService {
    @Autowired
    private WhWmsInventoryPlanMapper whWmsInventoryPlanMapper;
    @Autowired
    private WhWmsInventoryPlanShelvesMapper whWmsInventoryPlanShelvesMapper;
    @Autowired
    private WhWmsInventoryPlanShelvesDetailMapper whWmsInventoryPlanShelvesDetailMapper;
    @Autowired
    private WhWmsInventoryPlanCheckRcdMapper whWmsInventoryPlanCheckRcdMapper;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsTaskAssignService whWmsTaskAssignService;
    @Autowired
    private WhWmsInventoryPlanDiffService whWmsInventoryPlanDiffService;

    @Override
    public List<WhWmsInventoryPlanShelvesVO> findCanInventoryPlanShelvesByCond(WhWmsInventoryPlanShelvesDetailCond cond) {
        List<WhWmsInventoryPlanShelvesVO> regularList;
        ArrayList<WhWmsInventoryPlanShelvesVO> list = new ArrayList<WhWmsInventoryPlanShelvesVO>();
        if (WhWmsInventoryPlanVO.TYPE_DAYTODAY_INVENTORY.equals(cond.getInventoryType())) {
            List<WhWmsInventoryPlanShelvesVO> dayToDayList = this.findInventoryShelvesDetailForDaytoDay(cond);
            if (EmptyUtil.isNotEmpty(dayToDayList)) {
                list.addAll(dayToDayList);
            }
        } else if (WhWmsInventoryPlanVO.TYPE_REGULAR_INVENTORY.equals(cond.getInventoryType()) && EmptyUtil.isNotEmpty(regularList = this.whWmsInventoryPlanMapper.findInventoryShelvesForRegular(cond))) {
            list.addAll(regularList);
        }
        this.findNotFinishedInventoryPlanShelvesCode(list, cond.getInventoryPlanId());
        return list;
    }

    private List<WhWmsInventoryPlanShelvesVO> findInventoryShelvesDetailForDaytoDay(WhWmsInventoryPlanShelvesDetailCond cond) {
        ArrayList<WhWmsInventoryPlanShelvesVO> list = new ArrayList<WhWmsInventoryPlanShelvesVO>();
        List<WhWmsInventoryPlanShelvesDetailVO> planShelvesDetailList = this.whWmsInventoryPlanMapper.findInventoryShelvesDetailForDaytoDay(cond);
        if (EmptyUtil.isNotEmpty(planShelvesDetailList)) {
            HashMap<String, ArrayList<WhWmsInventoryPlanShelvesDetailVO>> shelvesMap = new HashMap<String, ArrayList<WhWmsInventoryPlanShelvesDetailVO>>();
            for (WhWmsInventoryPlanShelvesDetailVO whWmsInventoryPlanShelvesDetailVO : planShelvesDetailList) {
                ArrayList<WhWmsInventoryPlanShelvesDetailVO> tmpList = (ArrayList<WhWmsInventoryPlanShelvesDetailVO>)shelvesMap.get(whWmsInventoryPlanShelvesDetailVO.getShelvesCode());
                if (NullUtil.isNull((Object)tmpList)) {
                    tmpList = new ArrayList<WhWmsInventoryPlanShelvesDetailVO>();
                    shelvesMap.put(whWmsInventoryPlanShelvesDetailVO.getShelvesCode(), tmpList);
                }
                tmpList.add(whWmsInventoryPlanShelvesDetailVO);
            }
            for (Map.Entry entry : shelvesMap.entrySet()) {
                WhWmsInventoryPlanShelvesVO planShelves = new WhWmsInventoryPlanShelvesVO();
                planShelves.setShelvesCode((String)entry.getKey());
                planShelves.setInventoryShelvesDetailList((List)entry.getValue());
                list.add(planShelves);
            }
        }
        return list;
    }

    private void findNotFinishedInventoryPlanShelvesCode(List<WhWmsInventoryPlanShelvesVO> list, Long courrentPlanId) {
        if (EmptyUtil.isEmpty(list)) {
            return;
        }
        HashSet<String> shelvesCodes = new HashSet<String>();
        for (WhWmsInventoryPlanShelvesVO planShelves : list) {
            shelvesCodes.add(planShelves.getShelvesCode());
        }
        Set<String> notFinishedShelvesCodes = this.findNotFinishedInventoryPlanShelvesCode(null, Arrays.asList(shelvesCodes.toArray(new String[shelvesCodes.size()])), courrentPlanId);
        if (!notFinishedShelvesCodes.isEmpty()) {
            Iterator<WhWmsInventoryPlanShelvesVO> it = list.iterator();
            while (it.hasNext()) {
                WhWmsInventoryPlanShelvesVO planShelves = it.next();
                if (!notFinishedShelvesCodes.contains(planShelves.getShelvesCode().toUpperCase())) continue;
                it.remove();
            }
        }
    }

    @Override
    public WhWmsInventoryPlanVO findInventoryPlan(Long id, boolean cascade) {
        WhWmsInventoryPlanVO plan = this.whWmsInventoryPlanMapper.findInventoryPlanById(id);
        if (NullUtil.isNotNull((Object)plan) && cascade) {
            List<WhWmsInventoryPlanShelvesVO> planShelvesList = this.whWmsInventoryPlanShelvesMapper.findInventoryPlanShelvesByPlanId(plan.getId());
            this.fullInventoryPlanShelves(planShelvesList);
            plan.setInventroyShelvesList(planShelvesList);
        }
        return plan;
    }

    private void fullInventoryPlanShelves(List<WhWmsInventoryPlanShelvesVO> planShelvesList) {
        if (EmptyUtil.isEmpty(planShelvesList)) {
            return;
        }
        ArrayList<Long> planShelvesIdList = new ArrayList<Long>();
        for (WhWmsInventoryPlanShelvesVO planShelves : planShelvesList) {
            planShelvesIdList.add(planShelves.getId());
        }
        List<WhWmsInventoryPlanShelvesDetailVO> planShelvesDetailList = this.whWmsInventoryPlanShelvesDetailMapper.findInventoryPlanShelvesDetailByPlanShelvesId(planShelvesIdList);
        if (EmptyUtil.isNotEmpty(planShelvesDetailList)) {
            HashMap<Long, ArrayList<WhWmsInventoryPlanShelvesDetailVO>> map = new HashMap<Long, ArrayList<WhWmsInventoryPlanShelvesDetailVO>>();
            for (WhWmsInventoryPlanShelvesDetailVO shelvesDetail : planShelvesDetailList) {
                ArrayList<WhWmsInventoryPlanShelvesDetailVO> tmpList = (ArrayList<WhWmsInventoryPlanShelvesDetailVO>)map.get(shelvesDetail.getInventoryPlanShelvesId());
                if (NullUtil.isNull((Object)tmpList)) {
                    tmpList = new ArrayList<WhWmsInventoryPlanShelvesDetailVO>();
                    map.put(shelvesDetail.getInventoryPlanShelvesId(), tmpList);
                }
                tmpList.add(shelvesDetail);
            }
            for (WhWmsInventoryPlanShelvesVO planShelves : planShelvesList) {
                List detailList = (List)map.get(planShelves.getId());
                planShelves.setInventoryShelvesDetailList(detailList);
            }
        }
    }

    @Override
    public List<WhWmsInventoryPlanVO> findInventoryPlan(WhWmsInventoryPlanCond cond) {
        return this.whWmsInventoryPlanMapper.findInventoryPlan(cond);
    }

    @Override
    public Pagination<WhWmsInventoryPlanVO> findInventoryPlanPage(WhWmsInventoryPlanCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int total = this.whWmsInventoryPlanMapper.countInventoryPlan(cond);
        page.setRecord(Integer.valueOf(total));
        if (!NumberUtil.isNullOrZero((Number)total)) {
            List<WhWmsInventoryPlanVO> planList = this.findInventoryPlan(cond);
            page.setResultList(planList);
        }
        return page;
    }

    @Override
    @Transactional
    public boolean saveInventoryPlan(WhWmsInventoryPlanVO plan) {
        this.reBuildInventoryPlan(plan, true);
        if (NullUtil.isNull((Object)plan.getId())) {
            return this.createInventoryPlan(plan);
        }
        return this.updateInventoryPlan(plan);
    }

    private void reBuildInventoryPlan(WhWmsInventoryPlanVO plan, boolean needFilter) {
        List<WhWmsInventoryPlanShelvesVO> inventroyShelvesList = plan.getInventroyShelvesList();
        if (EmptyUtil.isEmpty(inventroyShelvesList)) {
            return;
        }
        ArrayList<String> shelvesCodes = new ArrayList<String>();
        for (WhWmsInventoryPlanShelvesVO planShelves : inventroyShelvesList) {
            planShelves.setShelvesCode(planShelves.getShelvesCode().toUpperCase());
            shelvesCodes.add(planShelves.getShelvesCode());
        }
        Set<String> notFinishedShelvesCodes = null;
        if (needFilter) {
            notFinishedShelvesCodes = this.findNotFinishedInventoryPlanShelvesCode(plan.getPhysicalWarehouseCode(), shelvesCodes, plan.getId());
        }
        Map<String, WhWmsHouseShelves> shelvesMap = this.whWmsHouseShelvesService.getHouseShelvesMapByCode(shelvesCodes);
        Iterator<WhWmsInventoryPlanShelvesVO> it = inventroyShelvesList.iterator();
        while (it.hasNext()) {
            WhWmsInventoryPlanShelvesVO planShelves = it.next();
            if (needFilter && NullUtil.isNotNull(notFinishedShelvesCodes) && notFinishedShelvesCodes.contains(planShelves.getShelvesCode())) {
                it.remove();
                continue;
            }
            WhWmsHouseShelves shelves = shelvesMap.get(planShelves.getShelvesCode());
            if (NullUtil.isNull((Object)shelves)) {
                throw new WarehouseException("WH0001", String.format("[%s]\u5e93\u4f4d\u4e0d\u5b58\u5728!", planShelves.getShelvesCode()));
            }
            planShelves.setShelvesHouseType(shelves.getHouseType());
            planShelves.setPhysicalWarehouseCode(shelves.getPhysicalWarehouseCode());
            List<WhWmsInventoryPlanShelvesDetailVO> inventoryShelvesDetailList = planShelves.getInventoryShelvesDetailList();
            if (!EmptyUtil.isNotEmpty(inventoryShelvesDetailList)) continue;
            for (WhWmsInventoryPlanShelvesDetailVO planShelvesDetail : inventoryShelvesDetailList) {
                planShelvesDetail.setShelvesHouseType(shelves.getHouseType());
                planShelvesDetail.setShelvesCode(shelves.getCode());
                planShelvesDetail.setSkuCode(planShelvesDetail.getSkuCode().toUpperCase());
                planShelvesDetail.setBarCode(planShelvesDetail.getBarCode().toUpperCase());
            }
        }
        if (EmptyUtil.isEmpty(inventroyShelvesList)) {
            throw new WarehouseException("WH0001", "\u4efb\u52a1\u884c\u4e3a\u7a7a\uff01");
        }
    }

    private Set<String> findNotFinishedInventoryPlanShelvesCode(String physicalWarehouseCode, List<String> shelvesCodes, Long planId) {
        Set<String> notFinishedShelvesCodes = this.findNotFinishedInventoryPlanShelvesCode(physicalWarehouseCode, shelvesCodes);
        if (NullUtil.isNotNull((Object)planId)) {
            WhWmsInventoryPlanShelvesCond planShelvesCond = new WhWmsInventoryPlanShelvesCond();
            planShelvesCond.setInventoryPlanId(planId);
            List<WhWmsInventoryPlanShelvesVO> planShelvesList = this.findInventoryPlanShelvesByCond(planShelvesCond);
            if (EmptyUtil.isNotEmpty(planShelvesList)) {
                for (WhWmsInventoryPlanShelvesVO planShelves : planShelvesList) {
                    notFinishedShelvesCodes.remove(planShelves.getShelvesCode());
                }
            }
        }
        return notFinishedShelvesCodes;
    }

    private Set<String> findNotFinishedInventoryPlanShelvesCode(String physicalWarehouseCode, List<String> shelvesCodes) {
        WhWmsInventoryPlanShelvesCond planShelvesCond = new WhWmsInventoryPlanShelvesCond();
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(WhWmsInventoryPlanShelvesVO.STATUS_PENDING);
        statusList.add(WhWmsInventoryPlanShelvesVO.STATUS_PROCESSING);
        statusList.add(WhWmsInventoryPlanShelvesVO.STATUS_CHECK_PENDING);
        planShelvesCond.setPhysicalWarehouseCode(physicalWarehouseCode);
        planShelvesCond.setStatusList(statusList);
        planShelvesCond.setShelvesCodes(shelvesCodes);
        List<WhWmsInventoryPlanShelvesVO> shelveList = this.findInventoryPlanShelvesByCond(planShelvesCond);
        HashSet<String> notFinishedShelvesCodes = new HashSet<String>();
        if (EmptyUtil.isNotEmpty(shelveList)) {
            for (WhWmsInventoryPlanShelvesVO planShelves : shelveList) {
                notFinishedShelvesCodes.add(planShelves.getShelvesCode());
            }
        }
        ArrayList<Integer> diffStatusList = new ArrayList<Integer>();
        diffStatusList.add(WhWmsInventoryPlanDiffDetailVO.STATUS_PENDING);
        diffStatusList.add(WhWmsInventoryPlanDiffDetailVO.STATUS_AUDITE_PENDING);
        diffStatusList.add(WhWmsInventoryPlanDiffDetailVO.STATUS_AUDITE_REFUSE);
        WhWmsInventoryPlanDiffDetailCond diffDetailCond = new WhWmsInventoryPlanDiffDetailCond();
        diffDetailCond.setPhysicalWarehouseCode(physicalWarehouseCode);
        diffDetailCond.setShelvesCodeList(shelvesCodes);
        diffDetailCond.setStatusList(diffStatusList);
        List<WhWmsInventoryPlanDiffDetailVO> diffList = this.whWmsInventoryPlanDiffService.findInventoryPlanDiffDetail(diffDetailCond);
        if (EmptyUtil.isNotEmpty(diffList)) {
            for (WhWmsInventoryPlanDiffDetailVO diffDetail : diffList) {
                notFinishedShelvesCodes.add(diffDetail.getShelvesCode());
            }
        }
        return notFinishedShelvesCodes;
    }

    @Override
    @Transactional
    public boolean cancelInventoryPlan(Long id) {
        WhWmsInventoryPlanVO plan = this.findInventoryPlan(id, true);
        if (NullUtil.isNull((Object)plan)) {
            throw new WarehouseException("WH0001", String.format("[%s]\u76d8\u70b9\u4efb\u52a1\u4e0d\u5b58\u5728\uff01", id));
        }
        if (!WhWmsInventoryPlanVO.STATUS_PENDING.equals(plan.getStatus())) {
            throw new WarehouseException("WH0001", String.format("\u76d8\u70b9\u4efb\u52a1\u72b6\u6001[%s]\uff01", plan.getStatusStr()));
        }
        plan.setStatus(WhWmsInventoryPlanVO.STATUS_CANCELED);
        this.whWmsInventoryPlanMapper.updateByPrimaryKey(plan);
        List<WhWmsInventoryPlanShelvesVO> planShelvesList = plan.getInventroyShelvesList();
        if (EmptyUtil.isNotEmpty(planShelvesList)) {
            for (WhWmsInventoryPlanShelvesVO planShelves : planShelvesList) {
                planShelves.setStatus(WhWmsInventoryPlanShelvesVO.STATUS_CANCELED);
                this.whWmsInventoryPlanShelvesMapper.updateByPrimaryKey(planShelves);
            }
        }
        return true;
    }

    private boolean createInventoryPlan(WhWmsInventoryPlanVO plan) {
        plan.setCreateTime(DateUtil.getNow());
        plan.setStatus(WhWmsInventoryPlanVO.STATUS_PENDING);
        this.whWmsInventoryPlanMapper.insert(plan);
        plan.setCode(this.buildCode(plan.getId()));
        this.whWmsInventoryPlanMapper.updateByPrimaryKey(plan);
        this.createInventoryPlanShelves(plan);
        return true;
    }

    private boolean createInventoryPlanShelves(WhWmsInventoryPlanVO plan) {
        List<WhWmsInventoryPlanShelvesVO> planShelvesList = plan.getInventroyShelvesList();
        if (EmptyUtil.isEmpty(planShelvesList)) {
            return true;
        }
        for (WhWmsInventoryPlanShelvesVO planShelves : planShelvesList) {
            planShelves.setInventoryPlanId(plan.getId());
            planShelves.setStatus(WhWmsInventoryPlanShelvesVO.STATUS_PENDING);
            this.whWmsInventoryPlanShelvesMapper.insert(planShelves);
            List<WhWmsInventoryPlanShelvesDetailVO> shelvesDetailList = planShelves.getInventoryShelvesDetailList();
            if (!EmptyUtil.isNotEmpty(shelvesDetailList)) continue;
            for (WhWmsInventoryPlanShelvesDetailVO detail : shelvesDetailList) {
                detail.setInventoryPlanShelvesId(planShelves.getId());
                this.whWmsInventoryPlanShelvesDetailMapper.insert(detail);
            }
        }
        return true;
    }

    private boolean deleteInventoryPlanShelves(Long planId) {
        WhWmsInventoryPlanVO plan = this.findInventoryPlan(planId, true);
        if (NullUtil.isNull((Object)plan) || EmptyUtil.isEmpty(plan.getInventroyShelvesList())) {
            return true;
        }
        List<WhWmsInventoryPlanShelvesVO> planShelvesList = plan.getInventroyShelvesList();
        ArrayList<Long> planShelvesIdList = new ArrayList<Long>();
        for (WhWmsInventoryPlanShelvesVO planShelves : planShelvesList) {
            planShelvesIdList.add(planShelves.getId());
        }
        WhWmsInventoryPlanShelvesDetailExample detailExample = new WhWmsInventoryPlanShelvesDetailExample();
        detailExample.createCriteria().andInventoryPlanShelvesIdIn(planShelvesIdList);
        this.whWmsInventoryPlanShelvesDetailMapper.deleteByExample(detailExample);
        WhWmsInventoryPlanShelvesExample shelvesExample = new WhWmsInventoryPlanShelvesExample();
        shelvesExample.createCriteria().andIdIn(planShelvesIdList);
        this.whWmsInventoryPlanShelvesMapper.deleteByExample(shelvesExample);
        return true;
    }

    private boolean updateInventoryPlan(WhWmsInventoryPlanVO plan) {
        if (!WhWmsInventoryPlanVO.STATUS_PENDING.equals(plan.getStatus())) {
            throw new WarehouseException("WH0001", String.format("\u76d8\u70b9\u4efb\u52a1\u72b6\u6001[%s]\uff01", plan.getStatusStr()));
        }
        this.whWmsInventoryPlanMapper.updateByPrimaryKey(plan);
        this.deleteInventoryPlanShelves(plan.getId());
        this.createInventoryPlanShelves(plan);
        return true;
    }

    private String buildCode(Long id) {
        String code = id.toString();
        for (int i = code.length(); i <= 4; ++i) {
            code = "0" + code;
        }
        return code;
    }

    @Override
    @Transactional
    public boolean updateInventoryPlanStatus(WhWmsInventoryPlanVO plan) {
        this.whWmsInventoryPlanMapper.updateByPrimaryKey(plan);
        return true;
    }

    @Override
    public WhWmsInventoryPlanShelvesVO findInventoryPlanShelves(Long planShelvesId, boolean cascade) {
        WhWmsInventoryPlanShelvesVO planShelves = this.whWmsInventoryPlanShelvesMapper.findInventoryPlanShelvesById(planShelvesId);
        if (NullUtil.isNotNull((Object)planShelves) && cascade) {
            this.fullInventoryPlanShelves(Collections.singletonList(planShelves));
        }
        return planShelves;
    }

    @Override
    public List<WhWmsInventoryPlanShelvesVO> findInventoryPlanShelvesByCond(WhWmsInventoryPlanShelvesCond cond) {
        return this.whWmsInventoryPlanShelvesMapper.findInventoryPlanShelvesByCond(cond);
    }

    @Override
    public Pagination<WhWmsInventoryPlanShelvesVO> findInventoryPlanShelvesByCondPage(WhWmsInventoryPlanShelvesCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        Integer total = this.whWmsInventoryPlanShelvesMapper.countInventoryPlanShelves(cond);
        page.setRecord(total);
        if (!NumberUtil.isNullOrZero((Number)total)) {
            List<WhWmsInventoryPlanShelvesVO> list = this.findInventoryPlanShelvesByCond(cond);
            page.setResultList(list);
        }
        return page;
    }

    @Override
    @Transactional
    public boolean updateInventoryPlanShelves(WhWmsInventoryPlanShelvesVO planShelves) {
        WhWmsInventoryPlanVO plan;
        if ((WhWmsInventoryPlanShelvesVO.STATUS_PROCESSING.equals(planShelves.getStatus()) || WhWmsInventoryPlanShelvesVO.STATUS_PENDING.equals(planShelves.getStatus())) && WhWmsInventoryPlanVO.STATUS_PENDING.equals((plan = this.findInventoryPlan(planShelves.getInventoryPlanId(), false)).getStatus())) {
            plan.setStatus(WhWmsInventoryPlanVO.STATUS_PROCESSING);
            this.updateInventoryPlanStatus(plan);
        }
        this.whWmsInventoryPlanShelvesMapper.updateByPrimaryKey(planShelves);
        if (WhWmsInventoryPlanShelvesVO.STATUS_FINISHED.equals(planShelves.getStatus())) {
            this.whWmsTaskAssignService.finishTaskAssigned(planShelves.getId().toString(), WhWmsTaskAssignVO.TASK_TYPE_INVENTORY, planShelves.getOperatorId());
            if (this.isInventoryPlanFinished(planShelves.getInventoryPlanId())) {
                plan = this.findInventoryPlan(planShelves.getInventoryPlanId(), false);
                plan.setStatus(WhWmsInventoryPlanVO.STATUS_FINISHED);
                this.updateInventoryPlanStatus(plan);
            }
        }
        return true;
    }

    private boolean isInventoryPlanFinished(Long inventoryPlanId) {
        List<WhWmsInventoryPlanShelvesVO> planShelvesList = this.whWmsInventoryPlanShelvesMapper.findInventoryPlanShelvesByPlanId(inventoryPlanId);
        if (EmptyUtil.isNotEmpty(planShelvesList)) {
            for (WhWmsInventoryPlanShelvesVO planShelves : planShelvesList) {
                if (WhWmsInventoryPlanShelvesVO.STATUS_FINISHED.equals(planShelves.getStatus())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Transactional
    public boolean complateInventoryPlanShelves(WhWmsInventoryPlanShelvesVO planShelves) {
        boolean isPlanShelvesExistDiff;
        if (!(WhWmsInventoryPlanShelvesVO.STATUS_PENDING.equals(planShelves.getStatus()) || WhWmsInventoryPlanShelvesVO.STATUS_PROCESSING.equals(planShelves.getStatus()) || WhWmsInventoryPlanShelvesVO.STATUS_CHECK_PENDING.equals(planShelves.getStatus()))) {
            throw new WarehouseException("WH0001", String.format("\u76d8\u70b9\u4efb\u52a1\u72b6\u6001[%s]\uff01", WhWmsInventoryPlanShelvesVO.getStatusName(planShelves.getStatus())));
        }
        this.buildPlanShelves(planShelves);
        boolean bl = isPlanShelvesExistDiff = !planShelves.isInventoryQuick() && this.isPlanShelvesExistDiff(planShelves);
        if ((WhWmsInventoryPlanShelvesVO.STATUS_PENDING.equals(planShelves.getStatus()) || WhWmsInventoryPlanShelvesVO.STATUS_PROCESSING.equals(planShelves.getStatus())) && isPlanShelvesExistDiff) {
            planShelves.setStatus(WhWmsInventoryPlanShelvesVO.STATUS_CHECK_PENDING);
            this.savePlanShelvesCheckRcd(planShelves);
        } else if (!isPlanShelvesExistDiff || WhWmsInventoryPlanShelvesVO.STATUS_CHECK_PENDING.equals(planShelves.getStatus())) {
            planShelves.setStatus(WhWmsInventoryPlanShelvesVO.STATUS_FINISHED);
            this.savePlanSelvesDiffDetail(planShelves);
        }
        this.updateInventoryPlanShelves(planShelves);
        return true;
    }

    @Override
    @Transactional
    public boolean inventoryQuick(List<WhWmsInventoryPlanVO> planList) {
        if (EmptyUtil.isNotEmpty(planList)) {
            for (WhWmsInventoryPlanVO plan : planList) {
                this.inventoryQuick(plan);
            }
        }
        return true;
    }

    @Override
    public List<WhCountVO> countInventoryPlan(Long operatorId, String physicalWarehouseCode) {
        return this.whWmsInventoryPlanShelvesMapper.countInventoryPlan(operatorId, physicalWarehouseCode);
    }

    private boolean inventoryQuick(WhWmsInventoryPlanVO plan) {
        List<WhWmsInventoryPlanShelvesVO> inventroyShelvesList = plan.getInventroyShelvesList();
        ArrayList<String> shelvesCodes = new ArrayList<String>();
        for (WhWmsInventoryPlanShelvesVO planShelves : inventroyShelvesList) {
            planShelves.setShelvesCode(planShelves.getShelvesCode().toUpperCase());
            shelvesCodes.add(planShelves.getShelvesCode());
        }
        Set<String> notFinishedShelvesCodes = this.findNotFinishedInventoryPlanShelvesCode(plan.getPhysicalWarehouseCode(), shelvesCodes);
        if (!notFinishedShelvesCodes.isEmpty()) {
            StringBuilder buff = new StringBuilder();
            for (String shelvesCode : notFinishedShelvesCodes) {
                buff.append(shelvesCode).append("<br/>");
            }
            throw new WarehouseException("WH0001", String.format("\u4ee5\u4e0b\u5e93\u4f4d\u5b58\u5728\u672a\u5b8c\u6210\u76d8\u70b9\u4efb\u52a1\uff01<br/>%s", buff.toString()));
        }
        this.reBuildInventoryPlan(plan, false);
        this.createInventoryPlan(plan);
        HashMap<Long, List<WhTakeStockRcd>> diffTakeStockMap = new HashMap<Long, List<WhTakeStockRcd>>();
        for (WhWmsInventoryPlanShelvesVO planShelves : plan.getInventroyShelvesList()) {
            planShelves.setInventoryQuick(true);
            planShelves.setOperatorId(plan.getCreateUserId());
            this.complateInventoryPlanShelves(planShelves);
            if (!EmptyUtil.isNotEmpty(planShelves.getShelvesDiffDetailList())) continue;
            for (WhWmsInventoryPlanDiffDetailVO whWmsInventoryPlanDiffDetailVO : planShelves.getShelvesDiffDetailList()) {
                diffTakeStockMap.put(whWmsInventoryPlanDiffDetailVO.getId(), whWmsInventoryPlanDiffDetailVO.getTakeStockList());
            }
        }
        WhWmsInventoryPlanDiffDetailCond cond = new WhWmsInventoryPlanDiffDetailCond();
        cond.setInventoryPlanId(plan.getId());
        cond.setNeedDiff(true);
        List<WhWmsInventoryPlanDiffDetailVO> diffList = this.whWmsInventoryPlanDiffService.findInventoryPlanDiffDetail(cond);
        if (EmptyUtil.isNotEmpty(diffList)) {
            ArrayList<Long> diffIdList = new ArrayList<Long>();
            for (WhWmsInventoryPlanDiffDetailVO diffDetail : diffList) {
                diffIdList.add(diffDetail.getId());
                List takeStockRcdList = (List)diffTakeStockMap.get(diffDetail.getId());
                if (NullUtil.isNull((Object)takeStockRcdList)) {
                    throw new WarehouseException("WH0001", "SCM\u540c\u6b65\u5e93\u5b58\u8ba1\u7b97\u9519\u8bef");
                }
                diffDetail.setTakeStockList(takeStockRcdList);
            }
            WhWmsInventoryPlanDiffProcessVO whWmsInventoryPlanDiffProcessVO = new WhWmsInventoryPlanDiffProcessVO();
            whWmsInventoryPlanDiffProcessVO.setOperatorId(plan.getCreateUserId());
            whWmsInventoryPlanDiffProcessVO.setIdList(diffIdList);
            whWmsInventoryPlanDiffProcessVO.setProcessType(WhWmsInventoryPlanDiffDetailVO.PROCESS_TYPE_PROFIT_OR_LOSS);
            this.whWmsInventoryPlanDiffService.processInventoryPlanDiff(whWmsInventoryPlanDiffProcessVO);
        }
        return true;
    }

    private void buildPlanShelves(WhWmsInventoryPlanShelvesVO planShelves) {
        WhWmsHouseShelvesVO shelves = this.whWmsHouseShelvesService.getHouseShelvesByCode(planShelves.getShelvesCode());
        if (EmptyUtil.isNotEmpty(planShelves.getShelvesDiffDetailList())) {
            for (WhWmsInventoryPlanDiffDetailVO diffDetail : planShelves.getShelvesDiffDetailList()) {
                String skuCode;
                if (NullUtil.isNull((Object)diffDetail.getOriAmount()) || NullUtil.isNull((Object)diffDetail.getRealAmount()) || diffDetail.getOriAmount() < 0 || diffDetail.getRealAmount() < 0) {
                    throw new WarehouseException("WH0001", String.format("[%s]\u76d8\u70b9\u5e93\u5b58\u6570\u91cf\u5f02\u5e38", diffDetail.getShelvesCode()));
                }
                diffDetail.setPhysicalWarehouseCode(planShelves.getPhysicalWarehouseCode());
                diffDetail.setShelvesCode(diffDetail.getShelvesCode().toUpperCase());
                diffDetail.setBarCode(diffDetail.getBarCode().toUpperCase());
                diffDetail.setSkuCode(diffDetail.getSkuCode().toUpperCase());
                diffDetail.setHouseType(shelves.getHouseType());
                diffDetail.setDiffAmount(diffDetail.getRealAmount() - diffDetail.getOriAmount());
                diffDetail.setCreateTime(DateUtil.getNow());
                diffDetail.setCreateUserId(planShelves.getOperatorId());
                diffDetail.setStatus(WhWmsInventoryPlanDiffDetailVO.STATUS_PENDING);
                if (!this.isPlanShelvesDetailExistDiff(diffDetail)) {
                    diffDetail.setStatus(WhWmsInventoryPlanDiffDetailVO.STATUS_AUDITE_PASS);
                }
                if ((skuCode = diffDetail.getBarCode().split("_")[0]).equals(diffDetail.getSkuCode())) continue;
                throw new WarehouseException("WH0001", String.format("[%s][%s]SKU\u6279\u6b21\u6570\u636e\u5f02\u5e38", diffDetail.getSkuCode(), diffDetail.getBarCode()));
            }
        }
    }

    private boolean savePlanSelvesDiffDetail(WhWmsInventoryPlanShelvesVO planShelves) {
        if (EmptyUtil.isNotEmpty(planShelves.getShelvesDiffDetailList())) {
            for (WhWmsInventoryPlanDiffDetailVO diffDetail : planShelves.getShelvesDiffDetailList()) {
                diffDetail.setInventoryPlanId(planShelves.getInventoryPlanId());
                diffDetail.setInventoryPlanShelvesId(planShelves.getId());
                if (this.isPlanShelvesDetailExistDiff(diffDetail)) {
                    diffDetail.setStatus(WhWmsInventoryPlanDiffDetailVO.STATUS_PENDING);
                } else {
                    diffDetail.setStatus(WhWmsInventoryPlanDiffDetailVO.STATUS_AUDITE_PASS);
                }
                this.whWmsInventoryPlanDiffService.insert(diffDetail);
            }
        }
        return true;
    }

    private boolean savePlanShelvesCheckRcd(WhWmsInventoryPlanShelvesVO planShelves) {
        if (EmptyUtil.isNotEmpty(planShelves.getShelvesDiffDetailList())) {
            ArrayList<WhWmsInventoryPlanCheckRcdVO> checkRcdList = new ArrayList<WhWmsInventoryPlanCheckRcdVO>();
            for (WhWmsInventoryPlanDiffDetailVO diffDetail : planShelves.getShelvesDiffDetailList()) {
                WhWmsInventoryPlanCheckRcdVO checkRcd = (WhWmsInventoryPlanCheckRcdVO)BeanUtil.buildFrom((Object)diffDetail, WhWmsInventoryPlanCheckRcdVO.class);
                checkRcd.setCheckTime(DateUtil.getNow());
                checkRcd.setCheckUserId(diffDetail.getCreateUserId());
                checkRcdList.add(checkRcd);
            }
            this.whWmsInventoryPlanCheckRcdMapper.batchInsert(checkRcdList);
        }
        return true;
    }

    private boolean isPlanShelvesExistDiff(WhWmsInventoryPlanShelvesVO planShelves) {
        boolean diff;
        block1: {
            WhWmsInventoryPlanDiffDetailVO diffDetail;
            diff = false;
            if (!EmptyUtil.isNotEmpty(planShelves.getShelvesDiffDetailList())) break block1;
            Iterator<WhWmsInventoryPlanDiffDetailVO> iterator = planShelves.getShelvesDiffDetailList().iterator();
            while (iterator.hasNext() && !(diff = this.isPlanShelvesDetailExistDiff(diffDetail = iterator.next()))) {
            }
        }
        return diff;
    }

    private boolean isPlanShelvesDetailExistDiff(WhWmsInventoryPlanDiffDetailVO diffDetail) {
        return !diffDetail.getOriAmount().equals(diffDetail.getRealAmount());
    }
}

