/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsInventoryPlanDiffDetailCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsInventoryPlanDiffDetailMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhTakeStock;
import com.thebeastshop.pegasus.service.warehouse.model.WhTakeStockRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsInventoryPlanDiffDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsInventoryPlanDiffDetailExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStockRecord;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInvService;
import com.thebeastshop.pegasus.service.warehouse.service.WhTakeStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsInventoryPlanDiffService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsInventoryPlanDiffAuditeVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsInventoryPlanDiffDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsInventoryPlanDiffProcessVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Service(value="whWmsInventoryPlanDiffService")
public class WhWmsInventoryPlanDiffServiceImpl
implements WhWmsInventoryPlanDiffService {
    @Autowired
    private WhWmsInventoryPlanDiffDetailMapper whWmsInventoryPlanDiffDetailMapper;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhInvService whInvService;
    @Autowired
    private WhTakeStockService whTakeStockService;

    @Override
    public Pagination<WhWmsInventoryPlanDiffDetailVO> findInventoryPlanDiffDetailPage(WhWmsInventoryPlanDiffDetailCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int total = this.whWmsInventoryPlanDiffDetailMapper.countInventoryPlanDiffDetail(cond);
        page.setRecord(Integer.valueOf(total));
        if (!NumberUtil.isNullOrZero((Number)total)) {
            List<WhWmsInventoryPlanDiffDetailVO> list = this.findInventoryPlanDiffDetail(cond);
            page.setResultList(list);
        }
        return page;
    }

    @Override
    public List<WhWmsInventoryPlanDiffDetailVO> findInventoryPlanDiffDetail(WhWmsInventoryPlanDiffDetailCond cond) {
        return this.whWmsInventoryPlanDiffDetailMapper.findInventoryPlanDiffDetail(cond);
    }

    public List<WhWmsInventoryPlanDiffDetailVO> findInventoryPlanDiffDetail(List<Long> idList) {
        WhWmsInventoryPlanDiffDetailCond cond = new WhWmsInventoryPlanDiffDetailCond();
        cond.setIdList(idList);
        return this.whWmsInventoryPlanDiffDetailMapper.findInventoryPlanDiffDetail(cond);
    }

    @Override
    @Transactional
    public int batchInsert(List<WhWmsInventoryPlanDiffDetailVO> rcdList) {
        if (EmptyUtil.isEmpty(rcdList)) {
            return 0;
        }
        return this.whWmsInventoryPlanDiffDetailMapper.batchInsert(rcdList);
    }

    @Override
    @Transactional
    public int insert(WhWmsInventoryPlanDiffDetailVO diffDetail) {
        return this.whWmsInventoryPlanDiffDetailMapper.insert(diffDetail);
    }

    @Override
    @Transactional
    public List<Long> processInventoryPlanDiff(WhWmsInventoryPlanDiffProcessVO processVO) {
        if (EmptyUtil.isEmpty(processVO.getIdList())) {
            throw new WarehouseException("WH0001", "\u65e0\u9700\u8981\u5904\u7406\u7684\u6570\u636e");
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(WhWmsInventoryPlanDiffDetailVO.STATUS_PENDING);
        statusList.add(WhWmsInventoryPlanDiffDetailVO.STATUS_AUDITE_REFUSE);
        WhWmsInventoryPlanDiffDetailCond cond = new WhWmsInventoryPlanDiffDetailCond();
        cond.setIdList(processVO.getIdList());
        cond.setStatusList(statusList);
        List<WhWmsInventoryPlanDiffDetailVO> detailList = this.findInventoryPlanDiffDetail(cond);
        if (EmptyUtil.isEmpty(detailList)) {
            throw new WarehouseException("WH0001", "\u65e0\u9700\u8981\u5904\u7406\u7684\u6570\u636e!");
        }
        for (WhWmsInventoryPlanDiffDetailVO diffDetail : detailList) {
            idList.add(diffDetail.getId());
        }
        processVO.setIdList(idList);
        int rows = this.whWmsInventoryPlanDiffDetailMapper.batchProcessInventoryPlanDiff(processVO);
        if (rows != idList.size()) {
            throw new WarehouseException("WH0001", "\u8bf7\u91cd\u8bd5!");
        }
        if (WhWmsInventoryPlanDiffDetailVO.PROCESS_TYPE_NOTHING.equals(processVO.getProcessType())) {
            WhWmsInventoryPlanDiffDetailExample example = new WhWmsInventoryPlanDiffDetailExample();
            example.createCriteria().andIdIn(idList).andStatusEqualTo(WhWmsInventoryPlanDiffDetailVO.STATUS_AUDITE_PENDING);
            WhWmsInventoryPlanDiffDetail update = new WhWmsInventoryPlanDiffDetail();
            update.setStatus(WhWmsInventoryPlanDiffDetailVO.STATUS_AUDITE_PASS);
            this.whWmsInventoryPlanDiffDetailMapper.updateByExampleSelective(update, example);
        }
        return idList;
    }

    @Override
    @Transactional
    public List<Long> auditeInventoryPlanDiff(WhWmsInventoryPlanDiffAuditeVO auditeVO) {
        if (auditeVO.isPass()) {
            return this.auditeInventoryPlanDiffPass(auditeVO);
        }
        return this.auditeInventoryPlanDiffRefuse(auditeVO);
    }

    private List<Long> auditeInventoryPlanDiffRefuse(WhWmsInventoryPlanDiffAuditeVO auditeVO) {
        if (EmptyUtil.isEmpty(auditeVO.getIdList())) {
            throw new WarehouseException("WH0001", "\u65e0\u9700\u8981\u5904\u7406\u7684\u6570\u636e");
        }
        WhWmsInventoryPlanDiffDetailCond cond = new WhWmsInventoryPlanDiffDetailCond();
        cond.setIdList(auditeVO.getIdList());
        cond.setStatus(WhWmsInventoryPlanDiffDetailVO.STATUS_AUDITE_PENDING);
        List<WhWmsInventoryPlanDiffDetailVO> diffList = this.findInventoryPlanDiffDetail(cond);
        ArrayList<Long> idList = new ArrayList<Long>();
        if (EmptyUtil.isNotEmpty(diffList)) {
            for (WhWmsInventoryPlanDiffDetailVO diffDetaill : diffList) {
                idList.add(diffDetaill.getId());
            }
        }
        WhWmsInventoryPlanDiffDetailExample example = new WhWmsInventoryPlanDiffDetailExample();
        example.createCriteria().andIdIn(idList).andStatusEqualTo(WhWmsInventoryPlanDiffDetailVO.STATUS_AUDITE_PENDING);
        WhWmsInventoryPlanDiffDetail update = new WhWmsInventoryPlanDiffDetail();
        update.setStatus(WhWmsInventoryPlanDiffDetailVO.STATUS_AUDITE_REFUSE);
        int row = this.whWmsInventoryPlanDiffDetailMapper.updateByExampleSelective(update, example);
        if (row != idList.size()) {
            throw new WarehouseException("WH0001", "\u8bf7\u91cd\u8bd5");
        }
        return idList;
    }

    private List<Long> auditeInventoryPlanDiffPass(WhWmsInventoryPlanDiffAuditeVO auditeVO) {
        if (EmptyUtil.isEmpty(auditeVO.getProcessDiffList())) {
            throw new WarehouseException("WH0001", "\u65e0\u9700\u8981\u5904\u7406\u7684\u6570\u636e");
        }
        List<WhWmsInventoryPlanDiffDetailVO> diffList = auditeVO.getProcessDiffList();
        if (EmptyUtil.isEmpty(diffList)) {
            throw new WarehouseException("WH0001", "\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684\u6570\u636e");
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        HashMap<Long, List<WhTakeStockRcd>> diffTakeStockMap = new HashMap<Long, List<WhTakeStockRcd>>();
        for (WhWmsInventoryPlanDiffDetailVO whWmsInventoryPlanDiffDetailVO : diffList) {
            idList.add(whWmsInventoryPlanDiffDetailVO.getId());
            diffTakeStockMap.put(whWmsInventoryPlanDiffDetailVO.getId(), whWmsInventoryPlanDiffDetailVO.getTakeStockList());
        }
        auditeVO.setIdList(idList);
        List<WhWmsInventoryPlanDiffDetailVO> detailList = this.findInventoryPlanDiffDetail(idList);
        for (WhWmsInventoryPlanDiffDetailVO diffDetail : detailList) {
            diffDetail.setTakeStockList((List)diffTakeStockMap.get(diffDetail.getId()));
        }
        int n = this.whWmsInventoryPlanDiffDetailMapper.batchAuditeInventoryPlanDiff(auditeVO);
        if (n != idList.size()) {
            throw new WarehouseException("WH0001", "\u8bf7\u91cd\u8bd5!");
        }
        this.processWmsStock(diffList, auditeVO);
        this.processScmStockV2(auditeVO);
        return idList;
    }

    private boolean processWmsStock(List<WhWmsInventoryPlanDiffDetailVO> diffList, WhWmsInventoryPlanDiffAuditeVO auditeVO) {
        if (EmptyUtil.isEmpty(diffList)) {
            return true;
        }
        ArrayList<WhWmsSkuStockRecord> skuStockRecordList = new ArrayList<WhWmsSkuStockRecord>();
        for (WhWmsInventoryPlanDiffDetailVO diffDetail : diffList) {
            if (diffDetail.getDiffAmount() == 0) continue;
            WhWmsSkuStockRecord stockRecord = (WhWmsSkuStockRecord)BeanUtil.buildFrom((Object)diffDetail, WhWmsSkuStockRecord.class);
            stockRecord.setInOutType(this.getInventoryInOutType(diffDetail));
            stockRecord.setQuantity(diffDetail.getDiffAmount());
            stockRecord.setReceiptNo(diffDetail.getId().toString());
            stockRecord.setMemo(diffDetail.getAdjustMemo());
            stockRecord.setIsUpdateScm(2);
            stockRecord.setCreateUserId(auditeVO.getOperatorId());
            skuStockRecordList.add(stockRecord);
        }
        this.whWmsSkuStockService.batchUpdateWhSkuStock(skuStockRecordList);
        return true;
    }

    private boolean processScmStockV2(WhWmsInventoryPlanDiffAuditeVO auditeVO) {
        if (EmptyUtil.isEmpty(auditeVO.getProcessDiffList())) {
            return true;
        }
        ArrayList<WhTakeStockRcd> takeStockRcdList = new ArrayList<WhTakeStockRcd>();
        for (WhWmsInventoryPlanDiffDetailVO diffDetail : auditeVO.getProcessDiffList()) {
            if (!EmptyUtil.isNotEmpty(diffDetail.getTakeStockList())) continue;
            for (WhTakeStockRcd whTakeStockRcd : diffDetail.getTakeStockList()) {
                String memo = "(WMS\u76d8\u70b9\u540c\u6b65:" + diffDetail.getInventoryPlanId() + ")";
                if (EmptyUtil.isNotEmpty((String)diffDetail.getAdjustMemo())) {
                    memo = memo + diffDetail.getAdjustMemo();
                }
                whTakeStockRcd.setMemo(memo);
                if (NullUtil.isNotNull((Object)diffDetail.getId())) {
                    whTakeStockRcd.setWmsTakeStockRcdId(diffDetail.getId().intValue());
                }
                takeStockRcdList.add(whTakeStockRcd);
            }
        }
        this.createWhTakeStock(takeStockRcdList, auditeVO);
        return true;
    }

    private void createWhTakeStock(List<WhTakeStockRcd> whRcdList, WhWmsInventoryPlanDiffAuditeVO auditeVO) {
        ArrayList<WhTakeStock> takeStockList = new ArrayList<WhTakeStock>();
        for (WhTakeStockRcd takeStockRcd : whRcdList) {
            WhTakeStock whTakeStock = new WhTakeStock();
            whTakeStock.setType(WhTakeStock.TYPE_WMS);
            whTakeStock.setFromWms(true);
            whTakeStock.setSyncThirdpartStock(true);
            whTakeStock.setUpdatePhyWhStock(false);
            whTakeStock.setCreateUserId(auditeVO.getOperatorId());
            whTakeStock.setWarehouseCode(takeStockRcd.getTakeStockWarehouseCode());
            whTakeStock.setReferenceId(takeStockRcd.getWmsTakeStockRcdId().longValue());
            whTakeStock.setWhTakeStockRcdList(Collections.singletonList(takeStockRcd));
            takeStockList.add(whTakeStock);
        }
        try {
            this.whTakeStockService.batchCreateTakeStock(takeStockList);
        }
        catch (Exception e) {
            throw new WarehouseException("WH0001", "\u540c\u6b65SCM\u5e93\u5b58\u5f02\u5e38:" + e.getMessage());
        }
    }

    private List<WhTakeStockRcd> buildWhTakeStockRcdList(List<WhWmsInventoryPlanDiffDetailVO> diffList, WhWmsInventoryPlanDiffProcessVO processVO, Integer commodityStatus) {
        if (WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(commodityStatus)) {
            throw new WarehouseException("WH0001", "\u975e\u6cd5\u64cd\u4f5c");
        }
        this.buildInOutWh(processVO, commodityStatus);
        return this.buildWhTackStockRcdList(diffList, processVO);
    }

    private List<WhTakeStockRcd> buildWhTakeStockRcdForNondefective(List<WhWmsInventoryPlanDiffDetailVO> diffList, WhWmsInventoryPlanDiffProcessVO processVO) {
        String waitForDispatchingWhCode = "WH020600010096";
        WhWarehouse waitForDispatchingWh = this.whInfoService.findWarehouseByCode(waitForDispatchingWhCode);
        Map<Integer, List<WhWmsInventoryPlanDiffDetailVO>> inOutMap = this.groupByInOut(diffList);
        Map<String, Integer> profitMap = this.groupBySku(inOutMap, WhInvRcd.TYPE_PROFIT_IN);
        Map<String, Integer> lossMap = this.groupBySku(inOutMap, WhInvRcd.TYPE_LOSS_OUT);
        List<String> lossSkuCodes = Arrays.asList(lossMap.keySet().toArray(new String[lossMap.size()]));
        ArrayList<WhTakeStockRcd> takeStockRcdList = new ArrayList<WhTakeStockRcd>();
        List<WhWmsInventoryPlanDiffDetailVO> profitDiffList = inOutMap.get(WhInvRcd.TYPE_PROFIT_IN);
        if (EmptyUtil.isNotEmpty(profitDiffList)) {
            processVO.setInWhWarehouse(waitForDispatchingWh);
            processVO.setOutWhWarehouse(waitForDispatchingWh);
            takeStockRcdList.addAll(this.buildWhTackStockRcdList(profitDiffList, processVO));
        }
        if (EmptyUtil.isEmpty(lossSkuCodes)) {
            return takeStockRcdList;
        }
        Map<String, Integer> dispatchingInvMap = this.findCanUseQttBySkuCodesAndWarehouseCode(lossSkuCodes, waitForDispatchingWhCode);
        this.joinProfitMap(lossSkuCodes, dispatchingInvMap, profitMap);
        WhWarehouse officialWh = this.whInfoService.findWarehouseByCode("WH020600010102");
        Map<String, Integer> officialInvMap = this.findCanUseQttBySkuCodesAndWarehouseCode(lossSkuCodes, officialWh.getCode());
        List<WhTakeStockRcd> lossTaksStockRcdList = this.buildWhWmsTakeStockRcdForLoss(inOutMap.get(WhInvRcd.TYPE_LOSS_OUT), dispatchingInvMap, officialInvMap, waitForDispatchingWh, officialWh);
        takeStockRcdList.addAll(lossTaksStockRcdList);
        return takeStockRcdList;
    }

    private List<WhTakeStockRcd> buildWhWmsTakeStockRcdForLoss(List<WhWmsInventoryPlanDiffDetailVO> diffList, Map<String, Integer> dispatchingInvMap, Map<String, Integer> officialInvMap, WhWarehouse waitForDispatchingWh, WhWarehouse officialWh) {
        ArrayList<WhTakeStockRcd> takeStockRcdList = new ArrayList<WhTakeStockRcd>();
        for (WhWmsInventoryPlanDiffDetailVO rcd : diffList) {
            int dispatchingLossInv;
            Integer diffAmount = rcd.getDiffAmount();
            Integer dispatchingInv = dispatchingInvMap.get(rcd.getSkuCode());
            Integer officialInv = officialInvMap.get(rcd.getSkuCode());
            if (NullUtil.isNull((Object)dispatchingInv)) {
                dispatchingInv = 0;
            }
            if (NullUtil.isNull((Object)officialInv)) {
                officialInv = 0;
            }
            if ((dispatchingLossInv = this.computeDispatchingLossInv(diffAmount, dispatchingInv, officialInv)) != 0) {
                WhTakeStockRcd dispatchingWhTakeStockRcd = this.buildWhTakeStockRcd(rcd, waitForDispatchingWh);
                dispatchingWhTakeStockRcd.setQuantity(dispatchingLossInv);
                takeStockRcdList.add(dispatchingWhTakeStockRcd);
                dispatchingInvMap.put(rcd.getSkuCode(), dispatchingInv + dispatchingLossInv);
            }
            if (dispatchingLossInv == diffAmount) continue;
            int officialLoosInv = diffAmount - dispatchingLossInv;
            WhTakeStockRcd officialWhTakeStockRcd = this.buildWhTakeStockRcd(rcd, officialWh);
            officialWhTakeStockRcd.setQuantity(officialLoosInv);
            takeStockRcdList.add(officialWhTakeStockRcd);
            officialInvMap.put(rcd.getSkuCode(), officialInv + officialLoosInv);
        }
        return takeStockRcdList;
    }

    private int computeDispatchingLossInv(Integer diffAmount, Integer dispatchingInv, Integer officialInv) {
        int totalInv;
        if (NullUtil.isNull((Object)dispatchingInv) || dispatchingInv < 0) {
            dispatchingInv = 0;
        }
        if (NullUtil.isNull((Object)officialInv) || officialInv < 0) {
            officialInv = 0;
        }
        if ((totalInv = dispatchingInv + officialInv) <= -diffAmount.intValue()) {
            return diffAmount + officialInv;
        }
        if (dispatchingInv >= -diffAmount.intValue()) {
            return diffAmount;
        }
        return -dispatchingInv.intValue();
    }

    private Map<Integer, List<WhWmsInventoryPlanDiffDetailVO>> groupByInOut(List<WhWmsInventoryPlanDiffDetailVO> diffList) {
        HashMap<Integer, List<WhWmsInventoryPlanDiffDetailVO>> map = new HashMap<Integer, List<WhWmsInventoryPlanDiffDetailVO>>();
        for (WhWmsInventoryPlanDiffDetailVO diffDetail : diffList) {
            Integer inOutType = this.getInventoryInOutType(diffDetail);
            ArrayList<WhWmsInventoryPlanDiffDetailVO> tmpList = (ArrayList<WhWmsInventoryPlanDiffDetailVO>)map.get(inOutType);
            if (NullUtil.isNull((Object)tmpList)) {
                tmpList = new ArrayList<WhWmsInventoryPlanDiffDetailVO>();
                map.put(inOutType, tmpList);
            }
            tmpList.add(diffDetail);
        }
        return map;
    }

    private Map<String, Integer> groupBySku(Map<Integer, List<WhWmsInventoryPlanDiffDetailVO>> inOutMap, Integer inOut) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<WhWmsInventoryPlanDiffDetailVO> list = inOutMap.get(inOut);
        if (EmptyUtil.isNotEmpty(list)) {
            for (WhWmsInventoryPlanDiffDetailVO diffDetail : list) {
                Integer total = (Integer)map.get(diffDetail.getSkuCode());
                if (NullUtil.isNull((Object)total)) {
                    total = 0;
                }
                map.put(diffDetail.getSkuCode(), total + diffDetail.getDiffAmount());
            }
        }
        return map;
    }

    private Map<String, Integer> findCanUseQttBySkuCodesAndWarehouseCode(List<String> skuCodes, String warehouseCode) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (EmptyUtil.isEmpty((String)warehouseCode)) {
            return map;
        }
        Map<String, WhInvVO> waitForDispatchingInvMap = this.whInvService.findCanUseQttBySkuCodesAndWarehouseCode(skuCodes, warehouseCode);
        if (NullUtil.isNotNull(waitForDispatchingInvMap) && !waitForDispatchingInvMap.isEmpty()) {
            for (Map.Entry<String, WhInvVO> entry : waitForDispatchingInvMap.entrySet()) {
                map.put(entry.getKey(), entry.getValue().getCanUseInv());
            }
        }
        return map;
    }

    private void joinProfitMap(List<String> skuCodes, Map<String, Integer> dispatchingInvMap, Map<String, Integer> profitMap) {
        for (String skuCode : skuCodes) {
            Integer profitInv = profitMap.get(skuCode);
            if (NullUtil.isNull((Object)profitInv)) continue;
            Integer dispatchingInv = dispatchingInvMap.get(skuCode);
            if (NullUtil.isNull((Object)dispatchingInv)) {
                dispatchingInv = 0;
            }
            dispatchingInv = dispatchingInv + profitInv;
            dispatchingInvMap.put(skuCode, dispatchingInv);
        }
    }

    private void buildInOutWh(WhWmsInventoryPlanDiffProcessVO processVO, Integer commodityStatus) {
        if ("WH02060001".equals(processVO.getPhysicalWarehouseCode())) {
            String inOutWarehouseCode = null;
            if (WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(commodityStatus)) {
                inOutWarehouseCode = "WH020600010096";
            } else if (WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE.equals(commodityStatus)) {
                inOutWarehouseCode = "WH020600010101";
            } else if (WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED.equals(commodityStatus)) {
                inOutWarehouseCode = "WH020600010098";
            } else if (WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED.equals(commodityStatus)) {
                inOutWarehouseCode = "WH020600010097";
            } else if (WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED.equals(commodityStatus)) {
                inOutWarehouseCode = this.getWarehoueByConfig("zxl.warehouseModerateDefectiveCode");
            } else if (WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED.equals(commodityStatus)) {
                inOutWarehouseCode = this.getWarehoueByConfig("zxl.warehouseSevereDefectiveCode");
            } else if (WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY.equals(commodityStatus)) {
                inOutWarehouseCode = this.getWarehoueByConfig("zxl.warehouseDisplayCode");
            }
            if (EmptyUtil.isNotEmpty((String)inOutWarehouseCode)) {
                throw new WarehouseException("WH0001", String.format("\u65e0\u53ef\u7528\u903b\u8f91\u4ed3\u5e93\uff0c\u7269\u7406\u4ed3[%s]\uff0c\u5546\u54c1\u72b6\u6001[%s]", processVO.getPhysicalWarehouseCode(), commodityStatus));
            }
            WhWarehouse whWarehouse = this.whInfoService.findWarehouseByCode(inOutWarehouseCode);
            processVO.setOutWhWarehouse(whWarehouse);
            processVO.setInWhWarehouse(whWarehouse);
        } else {
            this.setWarehouseByPhysicalCodeAndStatus(processVO, commodityStatus);
        }
    }

    private List<WhTakeStockRcd> buildWhTackStockRcdList(List<WhWmsInventoryPlanDiffDetailVO> diffList, WhWmsInventoryPlanDiffProcessVO processVO) {
        ArrayList<WhTakeStockRcd> whTakeStockRcds = new ArrayList<WhTakeStockRcd>();
        for (WhWmsInventoryPlanDiffDetailVO rcd : diffList) {
            whTakeStockRcds.add(this.buildWhTakeStockRcd(rcd, processVO));
        }
        return whTakeStockRcds;
    }

    private WhTakeStockRcd buildWhTakeStockRcd(WhWmsInventoryPlanDiffDetailVO diffDetail, WhWmsInventoryPlanDiffProcessVO processVO) {
        WhWarehouse warehouse = null;
        if (diffDetail.getDiffAmount() >= 0) {
            warehouse = processVO.getInWhWarehouse();
            if (NullUtil.isNull((Object)warehouse)) {
                throw new WarehouseException("WH0001", processVO.getNotExicstInWhWarehouseMsg());
            }
        } else {
            warehouse = processVO.getOutWhWarehouse();
            if (NullUtil.isNull((Object)warehouse)) {
                throw new WarehouseException("WH0001", processVO.getNotExicstOutWhWarehouseMsg());
            }
        }
        return this.buildWhTakeStockRcd(diffDetail, warehouse);
    }

    private WhTakeStockRcd buildWhTakeStockRcd(WhWmsInventoryPlanDiffDetailVO diffDetail, WhWarehouse warehouse) {
        WhTakeStockRcd whTakeStockRcd = new WhTakeStockRcd();
        whTakeStockRcd.setQuantity(diffDetail.getDiffAmount());
        whTakeStockRcd.setSkuCode(diffDetail.getSkuCode());
        String memo = "(WMS\u76d8\u70b9\u540c\u6b65:" + diffDetail.getInventoryPlanId() + ")";
        if (EmptyUtil.isNotEmpty((String)diffDetail.getAdjustMemo())) {
            memo = memo + diffDetail.getAdjustMemo();
        }
        whTakeStockRcd.setMemo(memo);
        if (NullUtil.isNotNull((Object)diffDetail.getId())) {
            whTakeStockRcd.setWmsTakeStockRcdId(diffDetail.getId().intValue());
        }
        whTakeStockRcd.setTakeStockWarehouseCode(warehouse.getCode());
        diffDetail.setTakeStockList(Collections.singletonList(whTakeStockRcd));
        return whTakeStockRcd;
    }

    private void setWarehouseByPhysicalCodeAndStatus(WhWmsInventoryPlanDiffProcessVO processVO, Integer skuStatus) {
        List<WhWarehouse> whWarehouses = this.whInfoService.findWarehouseByPhysicalCodeAndStatus(processVO.getPhysicalWarehouseCode(), skuStatus);
        for (WhWarehouse whWarehouse : whWarehouses) {
            if (WhWarehouseVO.RELATE_OUT.equals(whWarehouse.getRelateType())) {
                processVO.setOutWhWarehouse(whWarehouse);
                continue;
            }
            if (!WhWarehouseVO.RELATE_IN.equals(whWarehouse.getRelateType())) continue;
            processVO.setInWhWarehouse(whWarehouse);
        }
        if (EmptyUtil.isEmpty((Object)processVO.getOutWhWarehouse())) {
            processVO.setNotExicstOutWhWarehouseMsg(String.format("\u65e0\u53ef\u7528\u903b\u8f91\u4ed3\u5e93\uff0c\u7269\u7406\u4ed3[%s]\uff0c\u5546\u54c1\u72b6\u6001[%s]\uff0c[%s]", processVO.getPhysicalWarehouseCode(), skuStatus, "\u51fa"));
        }
        if (EmptyUtil.isEmpty((Object)processVO.getInWhWarehouse())) {
            processVO.setNotExicstInWhWarehouseMsg(String.format("\u65e0\u53ef\u7528\u903b\u8f91\u4ed3\u5e93\uff0c\u7269\u7406\u4ed3[%s]\uff0c\u5546\u54c1\u72b6\u6001[%s]\uff0c[%s]", processVO.getPhysicalWarehouseCode(), skuStatus, "\u5165"));
        }
    }

    private String getWarehoueByConfig(String configValueParam) {
        CommGlobalConfig config = PegasusUtilFacade.getInstance().findConfigByKey(configValueParam);
        if (EmptyUtil.isNotEmpty((Object)config) && EmptyUtil.isNotEmpty((String)config.getConfigValue())) {
            return config.getConfigValue();
        }
        return null;
    }

    private Map<Integer, List<WhWmsInventoryPlanDiffDetailVO>> filterThenGroupBySkuStatus(List<WhWmsInventoryPlanDiffDetailVO> diffList) {
        HashMap<Integer, List<WhWmsInventoryPlanDiffDetailVO>> map = new HashMap<Integer, List<WhWmsInventoryPlanDiffDetailVO>>();
        if (EmptyUtil.isNotEmpty(diffList)) {
            for (WhWmsInventoryPlanDiffDetailVO rcd : diffList) {
                if (rcd.getDiffAmount() == 0) continue;
                ArrayList<WhWmsInventoryPlanDiffDetailVO> tmpList = (ArrayList<WhWmsInventoryPlanDiffDetailVO>)map.get(rcd.getSkuStatus());
                if (NullUtil.isNull((Object)tmpList)) {
                    tmpList = new ArrayList<WhWmsInventoryPlanDiffDetailVO>();
                    map.put(rcd.getSkuStatus(), tmpList);
                }
                tmpList.add(rcd);
            }
        }
        return map;
    }

    private Integer getInventoryInOutType(WhWmsInventoryPlanDiffDetailVO diffDetail) {
        return diffDetail.getDiffAmount() > 0 ? WhInvRcd.TYPE_PROFIT_IN : WhInvRcd.TYPE_LOSS_OUT;
    }
}

