/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsHouseShelvesMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsHouseShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsHouseShelvesExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWarehouseAreaService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Controller(value="whWmsHouseShelvesService")
public class WhWmsHouseShelvesServiceImpl
implements WhWmsHouseShelvesService {
    @Autowired
    private WhWmsHouseShelvesMapper whHouseShelvesMapper;
    @Autowired
    private WhWmsWarehouseAreaService whWmsWarehouseAreaService;
    @Autowired
    private WhInfoService whInfoService;

    @Override
    public List<WhWmsHouseShelvesVO> getHouseShelvesByCond(WhWmsHouseShelvesCond cond) {
        return this.whHouseShelvesMapper.getByCondPage(cond);
    }

    @Override
    public WhWmsHouseShelvesVO getHouseShelvesByCode(String code) {
        WhWmsHouseShelvesExample example = new WhWmsHouseShelvesExample();
        example.createCriteria().andCodeEqualTo(code);
        List<WhWmsHouseShelves> houseShelveses = this.whHouseShelvesMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(houseShelveses)) {
            return null;
        }
        WhWmsHouseShelvesVO vo = (WhWmsHouseShelvesVO)BeanUtil.buildFrom((Object)houseShelveses.get(0), WhWmsHouseShelvesVO.class);
        return vo;
    }

    @Override
    public List<WhWmsHouseShelves> getHouseShelvesByCode(List<String> codes) {
        WhWmsHouseShelvesExample example = new WhWmsHouseShelvesExample();
        example.createCriteria().andCodeIn((List)codes);
        return this.whHouseShelvesMapper.selectByExample(example);
    }

    @Override
    public Map<String, WhWmsHouseShelves> getHouseShelvesMapByCode(List<String> codes) {
        List<WhWmsHouseShelves> list;
        HashMap<String, WhWmsHouseShelves> map = new HashMap<String, WhWmsHouseShelves>();
        if (EmptyUtil.isNotEmpty(codes) && EmptyUtil.isNotEmpty(list = this.getHouseShelvesByCode(codes))) {
            for (WhWmsHouseShelves shelves : list) {
                map.put(shelves.getCode(), shelves);
            }
        }
        return map;
    }

    @Override
    public WhWmsHouseShelvesVO getHouseShelvesById(Integer id) {
        if (NumberUtil.isNullOrZero((Number)id)) {
            return null;
        }
        WhWmsHouseShelvesExample example = new WhWmsHouseShelvesExample();
        example.createCriteria().andIdEqualTo(new Long(id.intValue()));
        List<WhWmsHouseShelves> houseShelveses = this.whHouseShelvesMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(houseShelveses)) {
            return null;
        }
        WhWmsHouseShelvesVO vo = (WhWmsHouseShelvesVO)BeanUtil.buildFrom((Object)houseShelveses.get(0), WhWmsHouseShelvesVO.class);
        return vo;
    }

    @Override
    @Transactional
    public Boolean newHouseShelves(WhWmsHouseShelves houseShelves) {
        if (EmptyUtil.isEmpty((String)houseShelves.getCode())) {
            throw new WarehouseException("", "null param");
        }
        if (EmptyUtil.isNotEmpty((Object)this.getHouseShelvesByCode(houseShelves.getCode()))) {
            throw new WarehouseException("", "[" + houseShelves.getCode() + "]the code is already exist!");
        }
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setHouseType(houseShelves.getHouseType());
        cond.setPhysicalWarehouseCode(houseShelves.getPhysicalWarehouseCode());
        if (houseShelves.getHouseType().equals("HOUSE_TYPE_RECEIVE")) {
            if (EmptyUtil.isNotEmpty(this.getHouseShelvesByCondNoPage(cond))) {
                throw new WarehouseException("", "\u6536\u8d27\u6682\u5b58\u533a(A) \u53ea\u5141\u8bb8\u6709\u4e00\u4e2a\u5e93\u4f4d");
            }
        } else if (houseShelves.getHouseType().equals("HOUSE_TYPE_PACKING")) {
            if (EmptyUtil.isNotEmpty(this.getHouseShelvesByCondNoPage(cond))) {
                throw new WarehouseException("", "\u52a0\u5de5\u533a(K) \u53ea\u5141\u8bb8\u6709\u4e00\u4e2a\u5e93\u4f4d");
            }
        } else if (houseShelves.getHouseType().equals("HOUSE_TYPE_PROCESSING")) {
            if (EmptyUtil.isNotEmpty(this.getHouseShelvesByCondNoPage(cond))) {
                throw new WarehouseException("", "\u5206\u62e8\u5305\u88c5\u533a(M) \u53ea\u5141\u8bb8\u6709\u4e00\u4e2a\u5e93\u4f4d");
            }
        } else if (houseShelves.getHouseType().equals("HOUSE_TYPE_PROCESSING")) {
            if (EmptyUtil.isNotEmpty(this.getHouseShelvesByCondNoPage(cond))) {
                throw new WarehouseException("", "\u4ea4\u63a5\u533a(N) \u53ea\u5141\u8bb8\u6709\u4e00\u4e2a\u5e93\u4f4d");
            }
        } else if (houseShelves.getHouseType().equals("HOUSE_TYPE_PROCESSING") && EmptyUtil.isNotEmpty(this.getHouseShelvesByCondNoPage(cond))) {
            throw new WarehouseException("", "\u5dee\u5f02\u533a(O) \u53ea\u5141\u8bb8\u6709\u4e00\u4e2a\u5e93\u4f4d");
        }
        this.validate(houseShelves);
        int result = this.whHouseShelvesMapper.insert(houseShelves);
        if (result <= 0) {
            throw new WarehouseException("", "insert data error!");
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean updateHouseShelves(WhWmsHouseShelves houseShelves) {
        if (EmptyUtil.isEmpty((String)houseShelves.getCode()) || NumberUtil.isNullOrZero((Number)houseShelves.getId())) {
            throw new WarehouseException("", "null param");
        }
        this.validate(houseShelves);
        int result = this.whHouseShelvesMapper.updateByPrimaryKey(houseShelves);
        if (result <= 0) {
            throw new WarehouseException("", "update data error!");
        }
        return true;
    }

    @Override
    public Pagination<WhWmsHouseShelvesVO> getHouseShelvesByCondPage(WhWmsHouseShelvesCond cond) {
        List<WhWmsHouseShelvesVO> voList = this.whHouseShelvesMapper.getByCondPage(cond);
        if (CollectionUtils.isEmpty(voList)) {
            return null;
        }
        Pagination pagination = new Pagination(cond.getCurrpage(), cond.getPagenum());
        pagination.setRecord(Integer.valueOf(this.whHouseShelvesMapper.getCountByCond(cond)));
        pagination.setResultList(voList);
        return pagination;
    }

    @Override
    public List<WhWmsHouseShelves> getHouseShelvesByCondNoPage(WhWmsHouseShelvesCond cond) {
        if (EmptyUtil.isNotEmpty((String)cond.getCodeLike())) {
            cond.setCodeLike(SQLUtils.allLike((String)cond.getCodeLike()));
        }
        return this.whHouseShelvesMapper.getByCondNoPage(cond);
    }

    @Override
    public List<WhWmsHouseShelves> getHouseShelvesLikeCode(String name) {
        return this.whHouseShelvesMapper.getHouseShelvesLikeCode(name);
    }

    public void validate(WhWmsHouseShelves houseShelves) {
        String physicalHouseNo = this.whInfoService.findPhysicalWarehouseByCode(houseShelves.getPhysicalWarehouseCode()).getHouseNo();
        String[] element = houseShelves.getCode().split("-");
        if (element.length != 6) {
            throw new WarehouseException("", "\u5e93\u4f4d\u683c\u5f0f\u9519\u8bef(\u4f8b:01-01-01-01)");
        }
        if (EmptyUtil.isNotEmpty((Object)houseShelves.getMaxAmount()) && EmptyUtil.isNotEmpty((Object)houseShelves.getSafeAmount()) && houseShelves.getSafeAmount() >= houseShelves.getMaxAmount()) {
            throw new WarehouseException("", "\u5b89\u5168\u5e93\u5b58\u4e0d\u5f97\u5927\u4e8e\u7b49\u4e8e\u6700\u5927\u4fdd\u7ba1\u91cf");
        }
        if (!element[0].equals(physicalHouseNo)) {
            throw new WarehouseException("", "[" + houseShelves.getCode() + "]error,the code is not matching the physical warehouse!");
        }
        if (this.whWmsWarehouseAreaService.getAreaByType(houseShelves.getHouseType(), element[1]) == null) {
            throw new WarehouseException("", "[" + houseShelves.getCode() + "]error,\u533a\u57df\u548c\u533a\u57df\u7f16\u7801\u4e0d\u5339\u914d!");
        }
        if (EmptyUtil.isEmpty((String)houseShelves.getSkuCode())) {
            if (EmptyUtil.isNotEmpty((Object)houseShelves.getSafeAmount())) {
                throw new WarehouseException("", "\u672a\u7ed1\u5b9aSKU\uff0c\u5b89\u5168\u5e93\u5b58\u5e94\u4e3a\u7a7a");
            }
            if (EmptyUtil.isNotEmpty((Object)houseShelves.getMaxAmount())) {
                throw new WarehouseException("", "\u672a\u7ed1\u5b9aSKU\uff0c\u6700\u5927\u4fdd\u7ba1\u91cf\u5e94\u4e3a\u7a7a");
            }
        }
    }
}

