/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.common.exception.BusinessException;
import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.service.warehouse.cond.WhGradeOfQualityCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhInvRcdCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsGradeOfQualityBarcodeCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsGradeOfQualityCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsGradeOfQualitySkuCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsGradeOfQualityBarcodeMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsGradeOfQualityMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsGradeOfQualitySkuMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhGradeOfQualityCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhWmsGradeOfQualityCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhGradeOfQualityDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvOccupy;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsGradeOfQuality;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsGradeOfQualityBarcode;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsGradeOfQualityBarcodeExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsGradeOfQualityExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsGradeOfQualitySku;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsGradeOfQualitySkuExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsHouseShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWarehouseArea;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhGradeOfQualityService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInvService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsGradeOfQualityService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsOccupyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWaitPutawayService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWarehouseAreaService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhGradeOfQualityVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhGradeSalesOrderVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseSkuInvVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsGradeOfQualityBarcodeVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsGradeOfQualitySkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsGradeOfQualityVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsOccupyVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsStartPutawayVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Service(value="whWmsGradeOfQualityService")
public class WhWmsGradeOfQualityServiceImpl
implements WhWmsGradeOfQualityService {
    private static final Logger log = LoggerFactory.getLogger(WhWmsGradeOfQualityServiceImpl.class);
    @Autowired
    private WhWmsGradeOfQualityMapper whWmsGradeOfQualityMapper;
    @Autowired
    private WhWmsGradeOfQualitySkuMapper whWmsGradeOfQualitySkuMapper;
    @Autowired
    private WhWmsGradeOfQualityBarcodeMapper whWmsGradeOfQualityBarcodeMapper;
    @Autowired
    private WhWmsGradeOfQualityCustomMapper whWmsGradeOfQualityCustomMapper;
    @Autowired
    private WhWmsOccupyService whWmsOccupyService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsWaitPutawayService whWmsWaitPutawayService;
    @Autowired
    private WhGradeOfQualityService whGradeOfQualityService;
    @Autowired
    private WhGradeOfQualityCustomMapper whGradeOfQualityCustomMapper;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhInvService whInvService;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;
    @Autowired
    private WhWmsWarehouseAreaService whWmsWarehouseAreaService;
    @Autowired
    private RedisDistributLock redisDistributLock;

    @Override
    public Pagination<WhWmsGradeOfQualityVO> listWhWmsGradeOfQualityVOByCond(WhWmsGradeOfQualityCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int count = this.countWhWmsGradeOfQuality(cond);
        page.setRecord(Integer.valueOf(count));
        if (NumberUtil.isNullOrZero((Number)count)) {
            return page;
        }
        List<WhWmsGradeOfQualityVO> gradeOfQualityVOs = this.whWmsGradeOfQualityCustomMapper.listWhWmsGradeOfQualityVOByCond(cond);
        page.setResultList(gradeOfQualityVOs);
        return page;
    }

    private int countWhWmsGradeOfQuality(WhWmsGradeOfQualityCond cond) {
        return this.whWmsGradeOfQualityCustomMapper.countWhWmsGradeOfQualityByCond(cond);
    }

    @Override
    public WhWmsGradeOfQuality findWhWmsGradeOfQualityById(Long id) {
        return this.whWmsGradeOfQualityMapper.selectByPrimaryKey(id);
    }

    @Override
    public WhWmsGradeOfQualityVO findWhWmsGradeOfQualityVOById(Long id, boolean fetchGradeSku, boolean fetchGradeBarcode) {
        WhWmsGradeOfQualityVO vo = this.whWmsGradeOfQualityCustomMapper.findVOById(id);
        if (EmptyUtil.isNotEmpty((Object)vo)) {
            this.fetchGradeDetail(vo, fetchGradeSku, fetchGradeBarcode);
        }
        return vo;
    }

    @Override
    public List<WhWmsGradeOfQualitySku> listWhWmsGradeOfQualitySkuByCond(WhWmsGradeOfQualitySkuCond skuCond) {
        WhWmsGradeOfQualitySkuExample example = this.buildWhWmsGradeOfQualitySkuExampleByCond(skuCond);
        return this.whWmsGradeOfQualitySkuMapper.selectByExample(example);
    }

    @Override
    public List<WhWmsGradeOfQualityBarcode> listWhWmsGradeOfQualityBarcodeByCond(WhWmsGradeOfQualityBarcodeCond barcodeCond) {
        WhWmsGradeOfQualityBarcodeExample example = this.buildWhWmsGradeOfQualityBarcodeExampleByCond(barcodeCond);
        return this.whWmsGradeOfQualityBarcodeMapper.selectByExample(example);
    }

    @Override
    public List<WhWmsGradeOfQualityBarcode> listWhWmsGradeOfQualityBarcodeByWmsGradeSkuId(Long wmsGradeSkuId) {
        WhWmsGradeOfQualityBarcodeCond barcodeCond = new WhWmsGradeOfQualityBarcodeCond();
        barcodeCond.setWmsGradeSkuId(wmsGradeSkuId);
        return this.listWhWmsGradeOfQualityBarcodeByCond(barcodeCond);
    }

    @Override
    public List<WhWmsGradeOfQualityBarcode> listWhWmsGradeOfQualityBarcodesByWmsGradeId(Long wmsGradeId) {
        WhWmsGradeOfQualityBarcodeCond barcodeCond = new WhWmsGradeOfQualityBarcodeCond();
        barcodeCond.setWmsGradeId(wmsGradeId);
        return this.listWhWmsGradeOfQualityBarcodeByCond(barcodeCond);
    }

    @Override
    public List<WhWmsGradeOfQualitySkuVO> listWhWmsGradeOfQualitySkuVOsByCond(WhWmsGradeOfQualitySkuCond skuCond) {
        List wmsGradeSkuVOs = BeanUtil.buildListFrom(this.listWhWmsGradeOfQualitySkuByCond(skuCond), WhWmsGradeOfQualitySkuVO.class);
        if (CollectionUtils.isNotEmpty((Collection)wmsGradeSkuVOs) && skuCond.isFetchGradeBarcode()) {
            for (WhWmsGradeOfQualitySkuVO skuVO : wmsGradeSkuVOs) {
                skuVO.setGradeBarcodes(this.listWhWmsGradeOfQualityBarcodeByWmsGradeSkuId(skuVO.getId()));
            }
        }
        return wmsGradeSkuVOs;
    }

    @Override
    public List<WhWmsGradeOfQualitySkuVO> listWhWmsGradeOfQualitySkuVOsByWmsGradeId(Long wmsGradeId, boolean fetchGradeBarcode) {
        WhWmsGradeOfQualitySkuCond skuCond = new WhWmsGradeOfQualitySkuCond();
        skuCond.setWmsGradeId(wmsGradeId);
        skuCond.setFetchGradeBarcode(fetchGradeBarcode);
        return this.listWhWmsGradeOfQualitySkuVOsByCond(skuCond);
    }

    private void fetchGradeDetail(WhWmsGradeOfQualityVO vo, boolean fetchGradeSku, boolean fetchGradeBarcode) {
        if (fetchGradeSku) {
            WhWmsGradeOfQualitySkuCond skuCond = new WhWmsGradeOfQualitySkuCond();
            skuCond.setWmsGradeId(vo.getId());
            List<WhWmsGradeOfQualitySkuVO> gradeSkuVOs = this.whWmsGradeOfQualityCustomMapper.listWhWmsGradeOfQualitySkuVOByCond(skuCond);
            vo.setGradeSkuVOs(gradeSkuVOs);
        }
        if (fetchGradeBarcode) {
            WhWmsGradeOfQualityBarcodeCond barcodeCond = new WhWmsGradeOfQualityBarcodeCond();
            barcodeCond.setWmsGradeId(vo.getId());
            List<WhWmsGradeOfQualityBarcodeVO> gradeBarcodeVOs = this.whWmsGradeOfQualityCustomMapper.listWhWmsGradeOfQualityBarcodeVOByCond(barcodeCond);
            vo.setGradeBarcodeVOs(gradeBarcodeVOs);
        }
    }

    private void fetchGradeSku(WhWmsGradeOfQualityVO vo, boolean fetchGradeBarcode) {
        WhWmsGradeOfQualitySkuCond skuCond = new WhWmsGradeOfQualitySkuCond();
        skuCond.setWmsGradeId(vo.getId());
        List<WhWmsGradeOfQualitySkuVO> gradeSkuVOs = this.whWmsGradeOfQualityCustomMapper.listWhWmsGradeOfQualitySkuVOByCond(skuCond);
        if (CollectionUtils.isNotEmpty(gradeSkuVOs) && fetchGradeBarcode) {
            for (WhWmsGradeOfQualitySkuVO skuVO : gradeSkuVOs) {
                List<WhWmsGradeOfQualityBarcode> gradeBarcodes = this.listWhWmsGradeOfQualityBarcodeByWmsGradeSkuId(skuVO.getId());
                skuVO.setGradeBarcodes(gradeBarcodes);
            }
            vo.setGradeSkuVOs(gradeSkuVOs);
        }
    }

    @Override
    public WhWmsGradeOfQualityVO findWhWmsGradeOfQualityVOByCond(WhWmsGradeOfQualityCond cond) {
        WhWmsGradeOfQualityExample example = this.buildWhWmsGradeOfQualityExampleByCond(cond);
        List<WhWmsGradeOfQuality> gradeOfQualities = this.whWmsGradeOfQualityMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(gradeOfQualities)) {
            WhWmsGradeOfQualityVO vo = (WhWmsGradeOfQualityVO)BeanUtil.buildFrom((Object)gradeOfQualities.get(0), WhWmsGradeOfQualityVO.class);
            this.fetchGradeDetail(vo, cond.isFetchGradeSku(), cond.isFetchGradeBarcode());
            return vo;
        }
        return null;
    }

    private WhWmsGradeOfQualityExample buildWhWmsGradeOfQualityExampleByCond(WhWmsGradeOfQualityCond cond) {
        WhWmsGradeOfQualityExample example = new WhWmsGradeOfQualityExample();
        WhWmsGradeOfQualityExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)cond.getId())) {
            criteria.andIdEqualTo(cond.getId());
        } else if (CollectionUtils.isNotEmpty(cond.getIds())) {
            criteria.andIdIn((List)cond.getIds());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getCode())) {
            criteria.andCodeEqualTo(cond.getCode());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getWhGradeId())) {
            criteria.andWhGradeIdEqualTo(cond.getWhGradeId());
        } else if (CollectionUtils.isNotEmpty(cond.getWhGradeIds())) {
            criteria.andWhGradeIdIn((List)cond.getWhGradeIds());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getPhysicalWarehouseCode())) {
            criteria.andPhysicalWarehouseCodeEqualTo(cond.getPhysicalWarehouseCode());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getSourceGrade())) {
            criteria.andSourceGradeEqualTo(cond.getSourceGrade());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getTargetGrade())) {
            criteria.andTargetGradeEqualTo(cond.getTargetGrade());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getApproveStatus())) {
            criteria.andApproveStatusEqualTo(cond.getApproveStatus());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getCreateTimeStart())) {
            criteria.andCreateTimeGreaterThanOrEqualTo(DateUtil.parse((String)cond.getCreateTimeStart(), (String)"yyyy-MM-dd"));
        }
        if (EmptyUtil.isNotEmpty((String)cond.getCreateTimeEnd())) {
            criteria.andCreateTimeLessThanOrEqualTo(DateUtil.parse((String)cond.getCreateTimeEnd(), (String)"yyyy-MM-dd"));
        }
        if (EmptyUtil.isNotEmpty((String)cond.getSubmitTimeStart())) {
            criteria.andSubmitTimeGreaterThanOrEqualTo(DateUtil.parse((String)cond.getSubmitTimeStart(), (String)"yyyy-MM-dd"));
        }
        if (EmptyUtil.isNotEmpty((String)cond.getSubmitTimeEnd())) {
            criteria.andSubmitTimeLessThanOrEqualTo(DateUtil.parse((String)cond.getSubmitTimeEnd(), (String)"yyyy-MM-dd"));
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getCreateUserId())) {
            criteria.andCreateUserIdEqualTo(cond.getCreateUserId());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getSubmitUserId())) {
            criteria.andSubmitUserIdEqualTo(cond.getSubmitUserId());
        }
        return example;
    }

    private WhWmsGradeOfQualitySkuExample buildWhWmsGradeOfQualitySkuExampleByCond(WhWmsGradeOfQualitySkuCond cond) {
        WhWmsGradeOfQualitySkuExample example = new WhWmsGradeOfQualitySkuExample();
        WhWmsGradeOfQualitySkuExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)cond.getId())) {
            criteria.andIdEqualTo(cond.getId());
        } else if (CollectionUtils.isNotEmpty(cond.getIds())) {
            criteria.andIdIn((List)cond.getIds());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getWmsGradeId())) {
            criteria.andWmsGradeIdEqualTo(cond.getWmsGradeId());
        } else if (CollectionUtils.isNotEmpty(cond.getWmsGradeIds())) {
            criteria.andWmsGradeIdIn((List)cond.getWmsGradeIds());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getSkuCode())) {
            criteria.andSkuCodeEqualTo(cond.getSkuCode());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getAdjustType())) {
            criteria.andAdjustTypeEqualTo(cond.getAdjustType());
        }
        return example;
    }

    private WhWmsGradeOfQualityBarcodeExample buildWhWmsGradeOfQualityBarcodeExampleByCond(WhWmsGradeOfQualityBarcodeCond cond) {
        WhWmsGradeOfQualityBarcodeExample example = new WhWmsGradeOfQualityBarcodeExample();
        WhWmsGradeOfQualityBarcodeExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)cond.getId())) {
            criteria.andIdEqualTo(cond.getId());
        } else if (CollectionUtils.isNotEmpty(cond.getIds())) {
            criteria.andIdIn((List)cond.getIds());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getWmsGradeId())) {
            criteria.andWmsGradeIdEqualTo(cond.getWmsGradeId());
        } else if (CollectionUtils.isNotEmpty(cond.getWmsGradeIds())) {
            criteria.andWmsGradeIdIn((List)cond.getWmsGradeIds());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getWmsGradeSkuId())) {
            criteria.andWmsGradeSkuIdEqualTo(cond.getWmsGradeSkuId());
        } else if (CollectionUtils.isNotEmpty(cond.getWmsGradeSkuIds())) {
            criteria.andWmsGradeSkuIdIn((List)cond.getWmsGradeSkuIds());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getSkuCode())) {
            criteria.andSkuCodeEqualTo(cond.getSkuCode());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getBarcode())) {
            criteria.andBarcodeEqualTo(cond.getBarcode());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getShelvesCode())) {
            criteria.andSkuCodeEqualTo(cond.getShelvesCode());
        }
        return example;
    }

    @Override
    public List<WhWmsGradeOfQuality> findWhWmsGradeOfQualityByCond(WhWmsGradeOfQualityCond cond) {
        WhWmsGradeOfQualityExample example = this.buildWhWmsGradeOfQualityExampleByCond(cond);
        return this.whWmsGradeOfQualityMapper.selectByExample(example);
    }

    @Override
    @Transactional
    public boolean create(WhWmsGradeOfQualityVO vo) throws Exception {
        WhWmsGradeOfQuality gradeOfQuality = (WhWmsGradeOfQuality)BeanUtil.buildFrom((Object)vo, WhWmsGradeOfQuality.class);
        gradeOfQuality.setCreateTime(DateUtil.getNow());
        int result = this.whWmsGradeOfQualityMapper.insert(gradeOfQuality);
        vo.setId(gradeOfQuality.getId());
        if (result > 0) {
            this.insertGradeSkuAndBarcodes(vo);
            HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
            params.put("createTime", gradeOfQuality.getCreateTime());
            params.put("sourceGrade", gradeOfQuality.getSourceGrade());
            params.put("id", gradeOfQuality.getId());
            String code = CodeGenerator.getInstance().generate("WMS_GA_CODE", params);
            gradeOfQuality.setCode(code);
            vo.setCode(code);
            this.whWmsGradeOfQualityMapper.updateByPrimaryKeySelective(gradeOfQuality);
            if (1 == vo.getApproveStatus()) {
                this.submitWmsApprove(vo);
            }
        }
        return result > 0;
    }

    private void submitWmsApprove(WhWmsGradeOfQualityVO vo) throws Exception {
        vo.setSubmitUserId(vo.getCreateUserId());
        this.wmsOccupy(vo);
        this.createWhGrade(vo);
        boolean manualApprove = this.manualApprovalFlag(vo);
        if (manualApprove) {
            this.sendGradeAdjustApplyMail(vo);
        } else {
            this.doAutoApprove(vo);
        }
    }

    private void sendGradeAdjustApplyMail(WhWmsGradeOfQualityVO vo) {
        WhGradeOfQualityCond whGradeCond = new WhGradeOfQualityCond();
        whGradeCond.setRefId(vo.getId());
        List<WhGradeOfQualityVO> gradeOfQualityVOs = this.whGradeOfQualityCustomMapper.listWhGradeOfQualityVOByCond(whGradeCond);
        this.whGradeOfQualityService.gradeAdjustApplySendMail(gradeOfQualityVOs);
    }

    public boolean doAutoApprove(WhWmsGradeOfQualityVO vo) throws Exception {
        WhGradeOfQualityCond cond = new WhGradeOfQualityCond();
        cond.setRefId(vo.getId());
        List<WhGradeOfQualityVO> whGradeOfQualityVOs = this.whGradeOfQualityService.listWhGradeOfQualityVOByCond(cond);
        if (CollectionUtils.isNotEmpty(whGradeOfQualityVOs)) {
            for (WhGradeOfQualityVO whGradeVO : whGradeOfQualityVOs) {
                boolean result;
                whGradeVO.setOptPass(true);
                if (EmptyUtil.isNotEmpty((Object)vo.getSubmitUserId())) {
                    whGradeVO.setApproveUserId(vo.getSubmitUserId());
                } else {
                    whGradeVO.setApproveUserId(whGradeVO.getCreateUserId());
                }
                if (!(result = this.whGradeOfQualityService.auditWhGradeOfQuality(whGradeVO))) continue;
                vo.setAutoApproveSuccess(true);
            }
        }
        return true;
    }

    @Override
    public boolean manualApprovalFlag(WhWmsGradeOfQualityVO vo) {
        String configValue;
        if (vo.isSystemAutoPass()) {
            return false;
        }
        CommGlobalConfig config = PegasusUtilFacade.getInstance().findConfigByKey("grade.needManualApproveTargetGradeStatus");
        if (EmptyUtil.isNotEmpty((Object)config) && EmptyUtil.isNotEmpty((String)(configValue = config.getConfigValue()))) {
            HashSet<Integer> statusSet = new HashSet<Integer>();
            for (String status : configValue.split(",")) {
                statusSet.add(Integer.parseInt(status));
            }
            return statusSet.contains(vo.getTargetGrade());
        }
        return false;
    }

    @Override
    @Transactional
    public boolean approveWhWmsGradeOfQuality(WhWmsGradeOfQualityVO vo) throws Exception {
        this.wmsOccupy(vo);
        this.createWhGrade(vo);
        WhWmsGradeOfQuality gradeOfQuality = new WhWmsGradeOfQuality();
        gradeOfQuality.setId(vo.getId());
        gradeOfQuality.setApproveStatus(1);
        gradeOfQuality.setSubmitTime(DateUtil.getNow());
        gradeOfQuality.setSubmitUserId(vo.getSubmitUserId());
        boolean result = this.whWmsGradeOfQualityMapper.updateByPrimaryKeySelective(gradeOfQuality) > 0;
        boolean manualApprove = this.manualApprovalFlag(vo);
        if (result) {
            if (manualApprove) {
                this.sendGradeAdjustApplyMail(vo);
            } else {
                result = this.doAutoApprove(vo);
            }
        }
        return result;
    }

    @Override
    public List<WhGradeSalesOrderVO> listSalesOrderByWmsOccupyRefCodes(WhWmsGradeOfQualityCond cond) throws Exception {
        return this.whWmsGradeOfQualityCustomMapper.listSalesOrderByWmsOccupyRefCodes(cond);
    }

    @Override
    @Transactional
    public void createWhGrade(WhWmsGradeOfQualityVO vo) throws Exception {
        this.createWhGrades(vo);
    }

    @Override
    @Transactional
    public boolean createOrUpdate(WhWmsGradeOfQualityVO vo) throws Exception {
        boolean result = false;
        result = EmptyUtil.isNotEmpty((Object)vo.getId()) && EmptyUtil.isNotEmpty((Object)this.whWmsGradeOfQualityMapper.selectByPrimaryKey(vo.getId())) ? this.update(vo) : this.create(vo);
        return result;
    }

    @Override
    public boolean cancelWhWmsGradeOfQuality(WhWmsGradeOfQuality record) throws Exception {
        WhWmsGradeOfQualityExample example = new WhWmsGradeOfQualityExample();
        WhWmsGradeOfQualityExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(record.getId());
        criteria.andApproveStatusEqualTo(record.getApproveStatus());
        WhWmsGradeOfQuality waitUpdateGrade = new WhWmsGradeOfQuality();
        waitUpdateGrade.setApproveStatus(-2);
        boolean result = this.whWmsGradeOfQualityMapper.updateByExampleSelective(waitUpdateGrade, example) > 0;
        WhWmsGradeOfQualitySkuCond gradeSkuCond = new WhWmsGradeOfQualitySkuCond();
        gradeSkuCond.setWmsGradeId(record.getId());
        if (result && CollectionUtils.isNotEmpty(this.whWmsGradeOfQualityCustomMapper.listWhWmsGradeOfQualitySkuVOByCond(gradeSkuCond))) {
            result = this.cancelWhWmsGradeOfQualitySkuByCond(gradeSkuCond);
        }
        return result;
    }

    @Override
    public boolean cancelWhWmsGradeOfQualitySku(WhWmsGradeOfQualitySku record) throws Exception {
        WhWmsGradeOfQualitySku waitUpdate = new WhWmsGradeOfQualitySku();
        waitUpdate.setId(record.getId());
        waitUpdate.setStatus(-2);
        return this.whWmsGradeOfQualitySkuMapper.updateByPrimaryKey(waitUpdate) > 0;
    }

    @Override
    public boolean cancelWhWmsGradeOfQualitySkuByCond(WhWmsGradeOfQualitySkuCond cond) throws Exception {
        WhWmsGradeOfQualitySkuExample example = new WhWmsGradeOfQualitySkuExample();
        WhWmsGradeOfQualitySkuExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(cond.getIds())) {
            criteria.andIdIn((List)cond.getIds());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getWmsGradeId())) {
            criteria.andWmsGradeIdEqualTo(cond.getWmsGradeId());
        } else if (CollectionUtils.isNotEmpty(cond.getWmsGradeIds())) {
            criteria.andWmsGradeIdIn((List)cond.getWmsGradeIds());
        }
        WhWmsGradeOfQualitySku waitUpdate = new WhWmsGradeOfQualitySku();
        waitUpdate.setStatus(-2);
        return this.whWmsGradeOfQualitySkuMapper.updateByExampleSelective(waitUpdate, example) > 0;
    }

    private void createWhGrades(WhWmsGradeOfQualityVO vo) throws Exception {
        if (CollectionUtils.isEmpty(vo.getGradeSkuVOs())) {
            throw new WarehouseException("WH0001", "\u54c1\u7ea7\u8c03\u6574\u5ba1\u6279\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6784\u5efaSCM\u8c03\u6574\u5355!");
        }
        ArrayList<WhGradeOfQualityVO> whGradeVOs = new ArrayList<WhGradeOfQualityVO>();
        for (WhWmsGradeOfQualitySkuVO gradeSkuVO : vo.getGradeSkuVOs()) {
            if (!EmptyUtil.isNotEmpty((Object)gradeSkuVO.getWhGradeVO())) continue;
            WhGradeOfQualityVO whGradeVO = gradeSkuVO.getWhGradeVO();
            whGradeVO.setRefId(vo.getId());
            whGradeVO.setRefCode(vo.getCode());
            whGradeVO.setWmsGradeSkuId(gradeSkuVO.getId());
            whGradeVOs.add(whGradeVO);
        }
        vo.setWhGradeVOS(whGradeVOs);
        this.whGradeOfQualityService.batchCreateWhGradeAndFetch(vo.getWhGradeVOS());
    }

    @Deprecated
    private void buildeWhGradeAndCreate(WhWmsGradeOfQualityVO vo, List<WhGradeOfQualityVO> whGradeVOS) throws Exception {
        if (CollectionUtils.isEmpty(vo.getGradeSkuVOs())) {
            throw new WarehouseException("WH0001", "\u54c1\u7ea7\u8c03\u6574\u5355 \u884cSKU\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6784\u5efaSCM\u8c03\u6574\u5355!");
        }
        for (WhWmsGradeOfQualitySku whWmsGradeOfQualitySku : vo.getGradeSkuVOs()) {
            WhGradeOfQualityVO whGradeVO = new WhGradeOfQualityVO();
            whGradeVO.setRefId(vo.getId());
            whGradeVO.setRefCode(vo.getCode());
            whGradeVO.setSkuCode(whWmsGradeOfQualitySku.getSkuCode());
            whGradeVO.setAdjustAmount(whWmsGradeOfQualitySku.getAdjustAmount());
            whGradeVO.setSourceGrade(vo.getSourceGrade());
            whGradeVO.setTargetGrade(vo.getTargetGrade());
            whGradeVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
            whGradeVO.setApproveStatus(1);
            whGradeVO.setCreateUserId(vo.getCreateUserId());
            whGradeVO.setAdjustReason(whWmsGradeOfQualitySku.getAdjustReason());
            whGradeVO.setSkuImage(whWmsGradeOfQualitySku.getSkuImage());
            whGradeVO.setOriginType(1);
            WhWarehouse targetWhWarehouse = this.findGradeWarehouseByCond(vo.getPhysicalWarehouseCode(), WhWarehouseVO.RELATE_IN, vo.getTargetGrade());
            List<WhWarehouse> whWarehouses = this.whInfoService.findAllWarehousesByPhyCodeAndStatus(vo.getPhysicalWarehouseCode(), vo.getSourceGrade(), WhWarehouseVO.RELATE_OUT);
            ArrayList<String> warehouseCodes = new ArrayList<String>();
            for (WhWarehouse warehouse : whWarehouses) {
                warehouseCodes.add(warehouse.getCode());
            }
            List<WhWarehouseSkuInvVO> whWarehouseSkuInvVOs = this.whInvService.findWarehousesSkuInvByCond(warehouseCodes, whWmsGradeOfQualitySku.getSkuCode());
            Map<String, WhWarehouse> warehouseMap = this.whInvService.getWarehouseMap(warehouseCodes);
            this.sortWhSkuInvList(whWarehouseSkuInvVOs, warehouseMap);
            int adjustAmount = whWmsGradeOfQualitySku.getAdjustAmount();
            int canUseInv = 0;
            for (WhWarehouseSkuInvVO whWarehouseSkuInvVO : whWarehouseSkuInvVOs) {
                canUseInv += whWarehouseSkuInvVO.getCanUseInv();
            }
            ArrayList<WhGradeOfQualityDetail> whGradeDetails = new ArrayList<WhGradeOfQualityDetail>();
            for (WhWarehouseSkuInvVO skuInvVO3 : whWarehouseSkuInvVOs) {
                if (skuInvVO3.getCanUseInv() >= adjustAmount) {
                    adjustAmount = 0;
                    this.buildWhGradeOfQualityDetails(vo, whWmsGradeOfQualitySku, adjustAmount, skuInvVO3.getWarehouseCode(), targetWhWarehouse.getCode(), whGradeDetails);
                    break;
                }
                adjustAmount -= skuInvVO3.getCanUseInv();
                this.buildWhGradeOfQualityDetails(vo, whWmsGradeOfQualitySku, skuInvVO3.getCanUseInv(), skuInvVO3.getWarehouseCode(), targetWhWarehouse.getCode(), whGradeDetails);
            }
            if (adjustAmount > 0) {
                WhInvRcdCond whInvRcdCond = new WhInvRcdCond();
                whInvRcdCond.setWarehouseCodes(warehouseCodes);
                whInvRcdCond.setSkuCode(whWmsGradeOfQualitySku.getSkuCode());
                ArrayList<Integer> inOutTypes = new ArrayList<Integer>(){
                    {
                        this.add(WhInvRcd.TYPE_SALES_OUT);
                        this.add(WhInvRcd.TYPE_CHANGE_OUT);
                    }
                };
                whInvRcdCond.setInOutTypes((List<Integer>)inOutTypes);
                List<WhInvOccupy> invOccupyList = this.whInvService.getInvOccupyByCond(whInvRcdCond);
                ArrayList<WhInvOccupy> soInvOccupyList = new ArrayList<WhInvOccupy>();
                ArrayList<WhInvOccupy> cmdInvOccupyList = new ArrayList<WhInvOccupy>();
                ArrayList<String> commandSkuCodes = new ArrayList<String>();
                for (WhInvOccupy occupy : invOccupyList) {
                    if (occupy.getReferenceCode().startsWith("SO")) {
                        soInvOccupyList.add(occupy);
                        continue;
                    }
                    if (!occupy.getReferenceCode().startsWith("CMD")) continue;
                    cmdInvOccupyList.add(occupy);
                    commandSkuCodes.add(occupy.getReferenceCode());
                }
                List<WhCommandSku> list = this.whCommandService.findCommandSkuByCommandSkuCodes(commandSkuCodes);
            }
            whGradeVO.setWhGradeDetails(whGradeDetails);
            whGradeVOS.add(whGradeVO);
        }
        this.whGradeOfQualityService.batchCreateWhGradeAndFetch(whGradeVOS);
    }

    private void buildWhGradeOfQualityDetails(WhWmsGradeOfQualityVO vo, WhWmsGradeOfQualitySku gradeSku, Integer adjustAmount, String sourceWarehouseCode, String targetWarehouseCode, List<WhGradeOfQualityDetail> whGradeDetails) {
        WhGradeOfQualityDetail gradeDetail = new WhGradeOfQualityDetail();
        gradeDetail.setWmsGradeId(vo.getId());
        gradeDetail.setWmsGradeSkuId(gradeSku.getId());
        gradeDetail.setSkuCode(gradeSku.getSkuCode());
        gradeDetail.setAdjustAmount(adjustAmount);
        gradeDetail.setSourceWarehouseCode(sourceWarehouseCode);
        gradeDetail.setApproveStatus(0);
        gradeDetail.setTargetWarehouseCode(targetWarehouseCode);
        whGradeDetails.add(gradeDetail);
    }

    private void sortWhSkuInvList(List<WhWarehouseSkuInvVO> whSkuInvList, final Map<String, WhWarehouse> warehouseMap) {
        if (EmptyUtil.isEmpty(whSkuInvList) || whSkuInvList.size() == 1) {
            return;
        }
        Collections.sort(whSkuInvList, new Comparator<WhWarehouseSkuInvVO>(){

            @Override
            public int compare(WhWarehouseSkuInvVO o1, WhWarehouseSkuInvVO o2) {
                WhWarehouse warehouse1 = (WhWarehouse)warehouseMap.get(o1.getWarehouseCode());
                WhWarehouse warehouse2 = (WhWarehouse)warehouseMap.get(o2.getWarehouseCode());
                if (EmptyUtil.isEmpty((Object)warehouse1.getSort()) && EmptyUtil.isEmpty((Object)warehouse2.getSort())) {
                    return -2;
                }
                if (EmptyUtil.isEmpty((Object)warehouse1.getSort())) {
                    return 1;
                }
                if (EmptyUtil.isEmpty((Object)warehouse2.getSort())) {
                    return -1;
                }
                return warehouse1.getSort().compareTo(warehouse2.getSort());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wmsReleaseOccupy(WhWmsGradeOfQualityVO vo, Long wmsGradeSkuId) {
        String receiptNo = vo.getCode() + "_" + wmsGradeSkuId;
        String lockKey = "lock:whWmsGrade:wmsReleaseOccupy:" + receiptNo;
        try {
            Boolean getLock = this.redisDistributLock.tryLock(lockKey, 3L, TimeUnit.SECONDS);
            if (!getLock.booleanValue()) {
                log.error("\u83b7\u53d6\u9501\u5931\u8d25   false  lockKey=" + lockKey);
                throw new WarehouseException("WH0001", "\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            WhWmsOccupyVO cond = new WhWmsOccupyVO();
            cond.setReceiptsNo(receiptNo);
            cond.setType(WhWmsOccupyVO.TYPE_GRADE_ADJUST);
            cond.setStatus(WhWmsOccupyVO.OCCUPIED);
            log.info("wmsReleaseOccupy start [" + receiptNo + "] Thread=" + Thread.currentThread().getName() + "  time=" + System.currentTimeMillis());
            boolean bl = this.whWmsOccupyService.releaseWmsOccupyById(cond);
            return bl;
        }
        finally {
            this.redisDistributLock.unLock(lockKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public boolean passWmsGradeOfQuality(WhWmsGradeOfQualityVO vo, Long wmsGradeSkuId) {
        WhWmsGradeOfQualitySku gradeSku = this.whWmsGradeOfQualitySkuMapper.selectByPrimaryKey(wmsGradeSkuId);
        if (EmptyUtil.isEmpty((Object)gradeSku)) {
            throw new WarehouseException("WH0001", "wmsGradeSkuId[" + wmsGradeSkuId + "]\u4e0d\u5b58\u5728!");
        }
        boolean flag = this.updateSkuStockByCond(vo, gradeSku.getSkuCode(), wmsGradeSkuId);
        if (flag) {
            this.wmsReleaseOccupy(vo, wmsGradeSkuId);
            WhWmsGradeOfQualitySku gradeOfQualitySku = new WhWmsGradeOfQualitySku();
            gradeOfQualitySku.setId(wmsGradeSkuId);
            gradeOfQualitySku.setStatus(1);
            this.whWmsGradeOfQualitySkuMapper.updateByPrimaryKeySelective(gradeOfQualitySku);
            String lockKey = "lock:whWmsGrade:passWmsGradeOfQuality:" + vo.getId();
            try {
                Boolean getLock = this.redisDistributLock.tryLock(lockKey, 2L, TimeUnit.MINUTES);
                log.info("tryGetLock start passWmsGradeOfQuality [wmsGradeId]=" + vo.getId() + "  [wmsGradeSkuId]=" + wmsGradeSkuId + "  == " + System.currentTimeMillis());
                if (!getLock.booleanValue()) {
                    log.error("\u83b7\u53d6\u9501\u5931\u8d25   false  lockKey=" + lockKey);
                    throw new WarehouseException("WH0001", "\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
                }
                log.info("tryGetLock end passWmsGradeOfQuality [wmsGradeId]=" + vo.getId() + "  [wmsGradeSkuId]=" + wmsGradeSkuId + "  == " + System.currentTimeMillis());
                WhWmsGradeOfQualityVO wmsGradeOfQualityVO = this.findWhWmsGradeOfQualityVOById(vo.getId(), true, false);
                HashSet<Integer> statusSet = new HashSet<Integer>();
                for (WhWmsGradeOfQualitySkuVO skuVO : wmsGradeOfQualityVO.getGradeSkuVOs()) {
                    statusSet.add(skuVO.getStatus());
                }
                int approveStatus = 0;
                if (statusSet.contains(0) && (statusSet.contains(1) || statusSet.contains(-1))) {
                    approveStatus = 2;
                } else if (!statusSet.contains(0) && !statusSet.contains(-1)) {
                    approveStatus = 4;
                } else if (!statusSet.contains(0) && statusSet.contains(1) && statusSet.contains(-1)) {
                    approveStatus = 3;
                }
                WhWmsGradeOfQuality gradeOfQuality = new WhWmsGradeOfQuality();
                gradeOfQuality.setId(vo.getId());
                gradeOfQuality.setApproveStatus(approveStatus);
                gradeOfQuality.setSubmitUserId(vo.getSubmitUserId());
                gradeOfQuality.setSubmitTime(DateUtil.getNow());
                int result = this.whWmsGradeOfQualityMapper.updateByPrimaryKeySelective(gradeOfQuality);
                if (result > 0) {
                    this.buildAndCreateMoveStock(gradeOfQuality);
                }
                boolean bl = result > 0;
                return bl;
            }
            finally {
                this.redisDistributLock.unLock(lockKey);
            }
        }
        throw new WarehouseException("WH0001", "WMS\u54c1\u7ea7\u7533\u8bf7\u901a\u8fc7\u65f6,\u66f4\u65b0\u7269\u7406\u4ed3\u5e93\u5b58\u5931\u8d25!");
    }

    private String getHouseTypeByShelvesCode(Map<String, String> shelvesMap, String shelvesCode) {
        return EmptyUtil.isNotEmpty((String)shelvesMap.get(shelvesCode)) ? shelvesMap.get(shelvesCode) : "";
    }

    private void buildAndCreateMoveStock(WhWmsGradeOfQuality gradeOfQuality) {
        WhWmsGradeOfQualityVO wmsGradeVO;
        if ((gradeOfQuality.getApproveStatus() == 3 || gradeOfQuality.getApproveStatus() == 4) && EmptyUtil.isNotEmpty((Object)(wmsGradeVO = this.whWmsGradeOfQualityCustomMapper.findVOById(gradeOfQuality.getId())))) {
            this.fetchGradeSku(wmsGradeVO, true);
            List<WhWmsGradeOfQualityBarcode> gradeBarcodes = new ArrayList<WhWmsGradeOfQualityBarcode>();
            if (CollectionUtils.isNotEmpty(wmsGradeVO.getGradeSkuVOs())) {
                for (WhWmsGradeOfQualitySkuVO gradeSkuVO : wmsGradeVO.getGradeSkuVOs()) {
                    if (1 != gradeSkuVO.getStatus() || !CollectionUtils.isNotEmpty(gradeSkuVO.getGradeBarcodes())) continue;
                    gradeBarcodes.addAll(gradeSkuVO.getGradeBarcodes());
                }
            }
            if (CollectionUtils.isNotEmpty(gradeBarcodes = this.aggregateAdjustAmountByBarcodes(gradeBarcodes))) {
                Map<String, WhWmsHouseShelves> shelvesMap = this.getHouseTypeMapByBarcodes(gradeBarcodes);
                ArrayList<WhWmsMoveSkuVO> moveSkuList = new ArrayList<WhWmsMoveSkuVO>();
                for (WhWmsGradeOfQualityBarcode barcode : gradeBarcodes) {
                    if (!EmptyUtil.isNotEmpty((Object)shelvesMap.get(barcode.getShelvesCode()))) continue;
                    WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                    moveSkuVO.setPhysicalWarehouseCode(wmsGradeVO.getPhysicalWarehouseCode());
                    moveSkuVO.setCreateTime(DateUtil.getNow());
                    moveSkuVO.setOriginalHouseType(shelvesMap.get(barcode.getShelvesCode()).getHouseType());
                    moveSkuVO.setAmount(barcode.getAdjustAmount());
                    moveSkuVO.setOriginalShelvesCode(barcode.getShelvesCode());
                    moveSkuVO.setTargetShelvesCode(this.generateTargetByRule(shelvesMap.get(barcode.getShelvesCode()), wmsGradeVO.getTargetGrade(), wmsGradeVO.getPhysicalWarehouseCode()));
                    moveSkuVO.setTargetHouseType(this.getHouseTypeByCode(moveSkuVO.getTargetShelvesCode()));
                    moveSkuVO.setBarCode(barcode.getBarcode());
                    moveSkuVO.setSkuCode(barcode.getSkuCode());
                    moveSkuVO.setSkuStatus(wmsGradeVO.getTargetGrade());
                    moveSkuVO.setStatus(WhWmsMoveSku.MOVE_SKU_STATUS_WAIT_MOVE);
                    if (!EmptyUtil.isNotEmpty((String)moveSkuVO.getTargetHouseType())) continue;
                    moveSkuList.add(moveSkuVO);
                }
                if (EmptyUtil.isNotEmpty(moveSkuList)) {
                    WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
                    moveStockVO.setPhysicalWarehouseCode(wmsGradeVO.getPhysicalWarehouseCode());
                    moveStockVO.setCreateUserId(wmsGradeVO.getSubmitUserId());
                    moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_SKU_TRANSLATE);
                    moveStockVO.setReferenceCode(wmsGradeVO.getCode());
                    moveStockVO.setMoveSkuList(moveSkuList);
                    this.whWmsMoveStockService.newMoveStock(moveStockVO);
                }
            }
        }
    }

    private String generateTargetByRule(WhWmsHouseShelves whWmsHouseShelves, Integer skuStatus, String phyCode) {
        if ("WH00650041".equals(phyCode)) {
            if (WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(skuStatus)) {
                return "02-B-01-01-01-01";
            }
            return "02-D-01-01-01-01";
        }
        if (whWmsHouseShelves.getCode().contains("H")) {
            return "01-H-10-02-01-01";
        }
        if (whWmsHouseShelves.getCode().contains("G")) {
            return "01-G-98-04-04-04";
        }
        if (WhWarehouseVO.isDamagedCommodity(skuStatus)) {
            return "01-D-06-02-01-04";
        }
        if (WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(skuStatus)) {
            return "01-L-01-01-01-01";
        }
        if (WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE.equals(skuStatus) || WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY.equals(skuStatus)) {
            return "01-R-01-01-01-01";
        }
        if (WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED.equals(skuStatus)) {
            return "01-P-01-01-01-01";
        }
        return "";
    }

    private String getHouseTypeByCode(String shelvesCode) {
        if (EmptyUtil.isEmpty((String)shelvesCode)) {
            return "";
        }
        WhWmsHouseShelvesVO houseShelvesVO = this.whWmsHouseShelvesService.getHouseShelvesByCode(shelvesCode);
        if (EmptyUtil.isNotEmpty((Object)houseShelvesVO)) {
            return houseShelvesVO.getHouseType();
        }
        return "";
    }

    private Map<String, String> getTargetShelvesCodeByConfig() {
        List<WhWmsWarehouseArea> whWmsWarehouseAreas = this.whWmsWarehouseAreaService.getAllArea();
        CommGlobalConfig config = PegasusUtilFacade.getInstance().findConfigByKey("grade.gradeAdjustMoveTargetShelvesCode");
        HashMap<String, String> targetShelvesMap = new HashMap<String, String>();
        if (EmptyUtil.isNotEmpty((Object)config) && EmptyUtil.isNotEmpty((String)config.getConfigValue())) {
            JSONObject json = JSONObject.parseObject((String)config.getConfigValue());
            for (WhWmsWarehouseArea whWmsWarehouseArea : whWmsWarehouseAreas) {
                json.get((Object)whWmsWarehouseArea.getCode());
                if (!EmptyUtil.isEmpty((Object)json.get((Object)whWmsWarehouseArea.getCode()))) continue;
                targetShelvesMap.put(whWmsWarehouseArea.getHouseType(), json.get((Object)whWmsWarehouseArea.getCode()).toString());
            }
        }
        return targetShelvesMap;
    }

    private boolean createMoveByPutawayLogic(WhWmsGradeOfQuality wmsGrade, List<WhWmsGradeOfQualityBarcode> gradeBarcodes) {
        List<WhWmsMoveSkuVO> moveskuList;
        ArrayList<WhWmsStartPutawayVO> pvoList = new ArrayList<WhWmsStartPutawayVO>();
        if (EmptyUtil.isNotEmpty((Object)wmsGrade) && CollectionUtils.isNotEmpty(gradeBarcodes)) {
            for (WhWmsGradeOfQualityBarcode item : gradeBarcodes) {
                WhWmsStartPutawayVO pt = new WhWmsStartPutawayVO();
                WhWmsHouseShelvesVO shelvesVO = this.whWmsHouseShelvesService.getHouseShelvesByCode(item.getShelvesCode());
                pt.setSourceShelvesVO(shelvesVO);
                pt.setPhysicalWarehouseCode(shelvesVO.getPhysicalWarehouseCode());
                pt.setPutawayAmount(0);
                pt.setSkuCode(item.getSkuCode());
                pt.setBarCode(item.getBarcode());
                pt.setSkuStatus(wmsGrade.getTargetGrade());
                pt.setReceiveAmount(item.getAdjustAmount());
                pt.setStorageType(0);
                pvoList.add(pt);
            }
        }
        if (EmptyUtil.isNotEmpty(pvoList) && CollectionUtils.isNotEmpty(moveskuList = this.whWmsWaitPutawayService.recommendWmsHouseShelves(pvoList))) {
            WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
            moveStockVO.setPhysicalWarehouseCode(wmsGrade.getPhysicalWarehouseCode());
            moveStockVO.setCreateUserId(wmsGrade.getSubmitUserId());
            moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_COMMON);
            moveStockVO.setReferenceCode(wmsGrade.getCode());
            moveStockVO.setMoveSkuList(moveskuList);
            return this.whWmsMoveStockService.newMoveStock(moveStockVO);
        }
        return false;
    }

    @Override
    public boolean rejectWmsGradeOfQuality(WhWmsGradeOfQualityVO vo, Long wmsGradeSkuId) {
        if (this.wmsReleaseOccupy(vo, wmsGradeSkuId)) {
            WhWmsGradeOfQualitySku gradeOfQualitySku = new WhWmsGradeOfQualitySku();
            gradeOfQualitySku.setId(wmsGradeSkuId);
            gradeOfQualitySku.setStatus(-1);
            this.whWmsGradeOfQualitySkuMapper.updateByPrimaryKeySelective(gradeOfQualitySku);
            WhWmsGradeOfQualityVO wmsGradeOfQualityVO = this.findWhWmsGradeOfQualityVOById(vo.getId(), true, false);
            HashSet<Integer> statusSet = new HashSet<Integer>();
            for (WhWmsGradeOfQualitySkuVO skuVO : wmsGradeOfQualityVO.getGradeSkuVOs()) {
                statusSet.add(skuVO.getStatus());
            }
            int approveStatus = 0;
            if (statusSet.contains(0) && (statusSet.contains(1) || statusSet.contains(-1))) {
                approveStatus = 2;
            } else if (!statusSet.contains(0) && !statusSet.contains(1)) {
                approveStatus = -1;
            } else if (!statusSet.contains(0) && statusSet.contains(1)) {
                approveStatus = 3;
            }
            WhWmsGradeOfQuality gradeOfQuality = new WhWmsGradeOfQuality();
            gradeOfQuality.setId(vo.getId());
            gradeOfQuality.setApproveStatus(approveStatus);
            int result = this.whWmsGradeOfQualityMapper.updateByPrimaryKeySelective(gradeOfQuality);
            if (result > 0) {
                this.buildAndCreateMoveStock(gradeOfQuality);
            }
            return result > 0;
        }
        return false;
    }

    private Map<String, WhWmsHouseShelves> getHouseTypeMapByBarcodes(List<WhWmsGradeOfQualityBarcode> gradeBarcodes) {
        HashSet<String> shelvesCodes = new HashSet<String>();
        for (WhWmsGradeOfQualityBarcode barcode : gradeBarcodes) {
            shelvesCodes.add(barcode.getShelvesCode());
        }
        List<WhWmsHouseShelves> whWmsHouseShelves = this.whWmsHouseShelvesService.getHouseShelvesByCode(new ArrayList<String>(shelvesCodes));
        HashMap<String, WhWmsHouseShelves> shelvesMap = new HashMap<String, WhWmsHouseShelves>();
        for (WhWmsHouseShelves houseShelves : whWmsHouseShelves) {
            shelvesMap.put(houseShelves.getCode(), houseShelves);
        }
        return shelvesMap;
    }

    private List<WhWmsGradeOfQualityBarcode> aggregateAdjustAmountByBarcodes(List<WhWmsGradeOfQualityBarcode> gradeBarcodes) {
        HashMap<String, WhWmsGradeOfQualityBarcode> gradeBarcodeMap = new HashMap<String, WhWmsGradeOfQualityBarcode>();
        for (WhWmsGradeOfQualityBarcode barcode : gradeBarcodes) {
            String key = barcode.getBarcode() + barcode.getShelvesCode();
            WhWmsGradeOfQualityBarcode gradeBc = (WhWmsGradeOfQualityBarcode)gradeBarcodeMap.get(key);
            if (EmptyUtil.isEmpty((Object)gradeBc)) {
                gradeBarcodeMap.put(key, barcode);
                continue;
            }
            gradeBc.setAdjustAmount(gradeBc.getAdjustAmount() + barcode.getAdjustAmount());
        }
        ArrayList<WhWmsGradeOfQualityBarcode> newGradeBarcodes = new ArrayList<WhWmsGradeOfQualityBarcode>();
        for (String key : gradeBarcodeMap.keySet()) {
            newGradeBarcodes.add((WhWmsGradeOfQualityBarcode)gradeBarcodeMap.get(key));
        }
        return newGradeBarcodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wmsOccupy(WhWmsGradeOfQualityVO vo) {
        String lockKey = "lock:whWmsGrade:wmsOccupy:" + vo.getId();
        try {
            Boolean getLock = this.redisDistributLock.tryLock(lockKey, 3L, TimeUnit.SECONDS);
            if (!getLock.booleanValue()) {
                log.error("\u83b7\u53d6\u9501\u5931\u8d25   false  lockKey=" + lockKey);
                throw new WarehouseException("WH0001", "\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            List<WhWmsGradeOfQualityBarcode> gradeBarcodes = this.listWhWmsGradeOfQualityBarcodesByWmsGradeId(vo.getId());
            if (CollectionUtils.isEmpty(gradeBarcodes)) {
                throw new WarehouseException("WH0001", "\u54c1\u7ea7\u8c03\u6574\u5355\u8be6\u60c5\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5360\u7528!");
            }
            Map<String, WhWmsHouseShelves> shelvesMap = this.getHouseTypeMapByBarcodes(gradeBarcodes);
            ArrayList<WhWmsOccupyVO> occupyList = new ArrayList<WhWmsOccupyVO>();
            for (WhWmsGradeOfQualityBarcode bc : gradeBarcodes) {
                if (!EmptyUtil.isNotEmpty((Object)shelvesMap.get(bc.getShelvesCode()))) continue;
                WhWmsOccupyVO occupyVO = new WhWmsOccupyVO();
                occupyVO.setSkuCode(bc.getSkuCode());
                occupyVO.setBarCode(bc.getBarcode());
                occupyVO.setSkuStatus(vo.getSourceGrade());
                occupyVO.setAmount(-bc.getAdjustAmount().intValue());
                occupyVO.setHouseType(shelvesMap.get(bc.getShelvesCode()).getHouseType());
                occupyVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
                occupyVO.setReceiptsNo(vo.getCode() + "_" + bc.getWmsGradeSkuId());
                occupyVO.setOriShelvesCode(bc.getShelvesCode());
                occupyVO.setType(WhWmsOccupyVO.TYPE_GRADE_ADJUST);
                occupyVO.setStatus(WhWmsOccupyVO.OCCUPIED);
                occupyList.add(occupyVO);
            }
            this.whWmsOccupyService.wmsBatchOccupy(occupyList);
        }
        finally {
            this.redisDistributLock.unLock(lockKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateSkuStockByCond(WhWmsGradeOfQualityVO whWmsGradeVO, String skuCode, Long wmsGradeSkuId) {
        String lockKey = "lock:whWmsGrade:updateSkuStockByCond:" + whWmsGradeVO.getCode() + "_" + wmsGradeSkuId;
        try {
            Boolean getLock = this.redisDistributLock.tryLock(lockKey, 2L, TimeUnit.MINUTES);
            if (!getLock.booleanValue()) {
                log.error("\u83b7\u53d6\u9501\u5931\u8d25   false  lockKey=" + lockKey);
                throw new WarehouseException("WH0001", "\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            WhWmsOccupyVO cond = new WhWmsOccupyVO();
            cond.setReceiptsNo(whWmsGradeVO.getCode() + "_" + wmsGradeSkuId);
            cond.setType(WhWmsOccupyVO.TYPE_GRADE_ADJUST);
            cond.setStatus(WhWmsOccupyVO.OCCUPIED);
            cond.setSkuCode(skuCode);
            List<WhWmsOccupyVO> whWmsOccupyVOs = this.whWmsOccupyService.getWmsOccupyByCond(cond);
            for (WhWmsOccupyVO occupyVO : whWmsOccupyVOs) {
                this.whWmsSkuStockService.updateStockByCond(occupyVO.getAmount(), occupyVO.getPhysicalWarehouseCode(), occupyVO.getHouseType(), occupyVO.getBarCode(), occupyVO.getOriShelvesCode(), skuCode, whWmsGradeVO.getSourceGrade(), WhInvRcd.TYPE_GRADE_ADJUST_OUT, whWmsGradeVO.getCode() + "_" + skuCode, whWmsGradeVO.getSubmitUserId(), "\u54c1\u7ea7\u8c03\u6574\u51fa\u5e93:" + whWmsGradeVO.getMemo(), 2);
                this.whWmsSkuStockService.updateStockByCond(Math.abs(occupyVO.getAmount()), occupyVO.getPhysicalWarehouseCode(), occupyVO.getHouseType(), occupyVO.getBarCode(), occupyVO.getOriShelvesCode(), skuCode, whWmsGradeVO.getTargetGrade(), WhInvRcd.TYPE_GRADE_ADJUST_IN, whWmsGradeVO.getCode() + "_" + skuCode, whWmsGradeVO.getSubmitUserId(), "\u54c1\u7ea7\u8c03\u6574\u5165\u5e93:" + whWmsGradeVO.getMemo(), 2);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.redisDistributLock.unLock(lockKey);
        }
    }

    @Override
    public boolean modifyStatus(WhWmsGradeOfQualityVO vo) {
        WhWmsGradeOfQuality gradeOfQuality = (WhWmsGradeOfQuality)BeanUtil.buildFrom((Object)vo, WhWmsGradeOfQuality.class);
        int result = this.whWmsGradeOfQualityMapper.updateByPrimaryKeySelective(gradeOfQuality);
        if (result > 0) {
            WhWmsGradeOfQualitySkuCond skuCond = new WhWmsGradeOfQualitySkuCond();
            skuCond.setWmsGradeId(vo.getId());
            WhWmsGradeOfQualitySkuExample skuExample = this.buildWhWmsGradeOfQualitySkuExampleByCond(skuCond);
            WhWmsGradeOfQualitySku record = new WhWmsGradeOfQualitySku();
            record.setStatus(vo.getApproveStatus());
            this.whWmsGradeOfQualitySkuMapper.updateByExampleSelective(record, skuExample);
            if (this.deleteGradeSkuAndBarcodes(vo.getId())) {
                this.insertGradeSkuAndBarcodes(vo);
            }
        }
        return result > 0;
    }

    @Override
    @Transactional
    public boolean update(WhWmsGradeOfQualityVO vo) throws Exception {
        WhWmsGradeOfQuality gradeOfQuality = (WhWmsGradeOfQuality)BeanUtil.buildFrom((Object)vo, WhWmsGradeOfQuality.class);
        int result = this.whWmsGradeOfQualityMapper.updateByPrimaryKeySelective(gradeOfQuality);
        if (result > 0) {
            if (this.deleteGradeSkuAndBarcodes(vo.getId())) {
                this.insertGradeSkuAndBarcodes(vo);
            }
            if (1 == vo.getApproveStatus()) {
                this.submitWmsApprove(vo);
            }
        }
        return result > 0;
    }

    public boolean deleteGradeSkuAndBarcodes(Long gradeId) {
        WhWmsGradeOfQualityBarcodeCond barcodeCond = new WhWmsGradeOfQualityBarcodeCond();
        barcodeCond.setWmsGradeId(gradeId);
        boolean result = this.deleteGradeBarcode(barcodeCond);
        if (result) {
            WhWmsGradeOfQualitySkuCond skuCond = new WhWmsGradeOfQualitySkuCond();
            skuCond.setWmsGradeId(gradeId);
            result = this.deleteGradeSku(skuCond);
        }
        return result;
    }

    public boolean deleteGradeSku(WhWmsGradeOfQualitySkuCond skuCond) {
        WhWmsGradeOfQualitySkuExample example = this.buildWhWmsGradeOfQualitySkuExampleByCond(skuCond);
        return this.whWmsGradeOfQualitySkuMapper.deleteByExample(example) > 0;
    }

    public boolean deleteGradeBarcode(WhWmsGradeOfQualityBarcodeCond barcodeCond) {
        WhWmsGradeOfQualityBarcodeExample example = this.buildWhWmsGradeOfQualityBarcodeExampleByCond(barcodeCond);
        return this.whWmsGradeOfQualityBarcodeMapper.deleteByExample(example) > 0;
    }

    public List<WhWmsGradeOfQualityBarcode> selectGradeBarcodeByCond(WhWmsGradeOfQualityBarcodeCond barcodeCond) {
        WhWmsGradeOfQualityBarcodeExample example = this.buildWhWmsGradeOfQualityBarcodeExampleByCond(barcodeCond);
        return this.whWmsGradeOfQualityBarcodeMapper.selectByExample(example);
    }

    private void insertGradeSkuAndBarcodes(WhWmsGradeOfQualityVO vo) {
        if (CollectionUtils.isNotEmpty(vo.getGradeSkuVOs())) {
            for (WhWmsGradeOfQualitySkuVO skuVO : vo.getGradeSkuVOs()) {
                WhWmsGradeOfQualitySku gradeSku = (WhWmsGradeOfQualitySku)BeanUtil.buildFrom((Object)skuVO, WhWmsGradeOfQualitySku.class);
                gradeSku.setWmsGradeId(vo.getId());
                gradeSku.setStatus(0);
                if (EmptyUtil.isNotEmpty((String)gradeSku.getSkuImage()) && gradeSku.getSkuImage().endsWith(",")) {
                    gradeSku.setSkuImage(gradeSku.getSkuImage().substring(0, gradeSku.getSkuImage().length() - 1));
                }
                this.whWmsGradeOfQualitySkuMapper.insert(gradeSku);
                skuVO.setId(gradeSku.getId());
                if (!CollectionUtils.isNotEmpty(skuVO.getGradeBarcodes())) continue;
                for (WhWmsGradeOfQualityBarcode barcode : skuVO.getGradeBarcodes()) {
                    barcode.setWmsGradeId(vo.getId());
                    barcode.setWmsGradeSkuId(gradeSku.getId());
                    this.whWmsGradeOfQualityBarcodeMapper.insert(barcode);
                }
            }
        }
    }

    @Override
    @Transactional
    public boolean updateWhWmsGradeOfQualitySku(WhWmsGradeOfQualityVO vo) {
        return false;
    }

    @Override
    @Transactional
    public boolean updateWhWmsGradeOfQualityBarcode(WhWmsGradeOfQualityVO vo) {
        return false;
    }

    @Override
    @Transactional
    public boolean batchCreateWhWmsGradeOfQualitySku(List<WhWmsGradeOfQualitySku> gradeOfQualitySkus) {
        return false;
    }

    @Override
    @Transactional
    public boolean batchCreateWhWmsGradeOfQualityBarcode(List<WhWmsGradeOfQualityBarcode> gradeOfQualityBarcodes) {
        return false;
    }

    @Override
    public boolean batchDeleteWhWmsGradeOfQualitySkuByCond(WhWmsGradeOfQualitySkuCond cond) {
        return false;
    }

    @Override
    public boolean batchDeleteWhWmsGradeOfQualityBarcodeByCond(WhWmsGradeOfQualityBarcodeCond cond) {
        return false;
    }

    @Override
    public WhWarehouse findGradeWarehouseByCond(String phyCode, Integer relateType, Integer skuStatus) throws Exception {
        WhWarehouse whWarehouse = this.whInfoService.findDefaultInOrOutWarehouseByPhyWhCode(phyCode, relateType, skuStatus);
        if (EmptyUtil.isEmpty((Object)whWarehouse)) {
            throw new BusinessException("\u521b\u5efa\u5931\u8d25\uff0c\u7269\u7406\u4ed3[" + phyCode + "],\u5546\u54c1\u72b6\u6001[" + WhWarehouseVO.getSkuStatusName(skuStatus) + "]\u627e\u4e0d\u5230\u51fa\u5e93\u903b\u8f91\u4ed3");
        }
        if (!WhWarehouseVO.WAREHOUSE_STATUS_CAN_USE.equals(whWarehouse.getWarehouseStatus())) {
            throw new BusinessException("\u521b\u5efa\u5931\u8d25\uff0c\u903b\u8f91\u4ed3[" + whWarehouse.getCode() + "],\u4e3a\u7981\u7528\u72b6\u6001");
        }
        return whWarehouse;
    }
}

