/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageRowBounds;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuSimpleVO;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsConsumableSkuCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConsumableSkuMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConsumableSku;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConsumableService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConsumableSkuVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="whWmsConsumableService")
public class WhWmsConsumableServiceImpl
implements WhWmsConsumableService {
    @Autowired
    private WhWmsConsumableSkuMapper whWmsConsumableSkuMapper;

    @Override
    public PageInfo<WhWmsConsumableSkuVO> findWmsConsumableSkuByCond(WhWmsConsumableSkuCond cond) {
        PageRowBounds pageRowBounds = new PageRowBounds(cond.getRowBounds().getOffset(), cond.getRowBounds().getLimit());
        List<WhWmsConsumableSkuVO> list = this.whWmsConsumableSkuMapper.findWmsConsumableSkuByCond(cond, pageRowBounds);
        PageInfo pageInfo = new PageInfo(list);
        pageInfo.setTotal(pageRowBounds.getTotal().longValue());
        return pageInfo;
    }

    @Override
    public List<Integer> batchCreate(List<WhWmsConsumableSkuVO> consumableSkuVOList) {
        List<WhWmsConsumableSku> consumableSkuList = this.buildListVO2PO(consumableSkuVOList);
        if (EmptyUtil.isEmpty(consumableSkuList)) {
            throw new WarehouseException("\u6279\u91cf\u521b\u5efa\u8017\u6750SKU \u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.whWmsConsumableSkuMapper.batchInsert(consumableSkuList);
        return new ArrayList<Integer>();
    }

    @Override
    public void batchDeleteConsumableSku(List<String> skuCodes) {
        this.whWmsConsumableSkuMapper.batchDeleteConsumableSku(skuCodes);
    }

    @Override
    public List<PcsSkuSimpleVO> findConsumableSkuByCodeOrName(String skuCodeOrName) {
        return this.whWmsConsumableSkuMapper.selectConsumableSkuByCodeOrName(skuCodeOrName);
    }

    @Override
    public List<WhWmsConsumableSku> buildListVO2PO(List<WhWmsConsumableSkuVO> whWmsConsumableSkuVOList) {
        ArrayList<WhWmsConsumableSku> consumableSkuList = new ArrayList<WhWmsConsumableSku>();
        for (WhWmsConsumableSkuVO whWmsConsumableSkuVO : whWmsConsumableSkuVOList) {
            WhWmsConsumableSku whWmsConsumableSku = new WhWmsConsumableSku();
            BeanUtils.copyProperties((Object)whWmsConsumableSkuVO, (Object)whWmsConsumableSku);
            whWmsConsumableSku.setIsDel(whWmsConsumableSkuVO.getBeenDel());
            consumableSkuList.add(whWmsConsumableSku);
        }
        return consumableSkuList;
    }

    @Override
    public List<String> findBySkuCodes(List<String> skuCodes) {
        return this.whWmsConsumableSkuMapper.selectBySkuCodes(skuCodes);
    }
}

