/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.exception.BusinessException;
import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsCommandPreOccupyCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsReplenishInfoCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsReplenishRuleCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsShelvesSkuInfoCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsWaitOutStockCond;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsCommandShortRecord;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsHouseShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuBarcode;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWarehouseArea;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandPreOccupyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectStartService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsReplenishRuleService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsShelvesSkuInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuBarcodeService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWarehouseAreaService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCommandPickStockInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCommandSkuPickStockInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandPreOccupyVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectPickSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartActiveConditionVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartChannelConditionVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartConditionsVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartCountConfigVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartResultVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartRuleDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartRuleVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartShelvesAreaConditionVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPreOccupyBlackListInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReplenishRuleBlacklistVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReplenishRuleHousetypeVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReplenishRuleVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsShelvesSkuInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsWaitOutStockVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import com.thebeastshop.pegasus.util.model.CommTypeValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service(value="whWmsConnectStartService")
public class WhWmsConnectStartServiceImpl
implements WhWmsConnectStartService {
    private static final String shortKey = "short";
    private static final String shelvesAreaRuleKey = "shelvesAreaRule";
    private static final String noShelvesAreaRuleKey = "noShelvesAreaRuleKey";
    private static final String splitFlag = ":";
    private static final String splitAreaFlag = "|";
    private static final String splitAreaFlagRegx = "\\|";
    private static final String GROUP_SHELVE = "SHELVE";
    private static final String GROUP_HOUSETYPE = "HOUSETYPE";
    private static final String GROUP_NONE = "NONE";
    @Autowired
    private WhWmsSkuBarcodeService whWmsSkuBarcodeService;
    @Autowired
    private WhWmsWarehouseAreaService whWmsWarehouseAreaService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsConnectInfoService whWmsConnectInfoService;
    @Autowired
    private WhWmsCommandPreOccupyService whWmsCommandPreOccupyService;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhWmsShelvesSkuInfoService whWmsShelvesSkuInfoService;
    @Autowired
    private WhWmsReplenishRuleService whWmsReplenishRuleService;
    @Autowired
    private TaskExecutor taskScheduler;
    @Autowired
    private RedisDistributLock redisDistributLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commandPreOccupy(String physicalWarehouseCode, Integer skuStatus) {
        String lockKey = "lock:preOccupy:" + physicalWarehouseCode + splitFlag + skuStatus;
        try {
            Boolean getLock = this.redisDistributLock.tryLock(lockKey, 3L, TimeUnit.MINUTES);
            if (!getLock.booleanValue()) {
                throw new WarehouseException("WH0001", "\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            List<WhWmsWaitOutStockVO> waitOutStockList = this.getWaitOutStockToday(physicalWarehouseCode, skuStatus, true);
            this.createCommandPreOccupy(physicalWarehouseCode, skuStatus, waitOutStockList);
        }
        finally {
            this.redisDistributLock.unLock(lockKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commandPreOccupy(String physicalWarehouseCode, Integer skuStatus, List<String> commandCodes) {
        String lockKey = "lock:preOccupy:" + physicalWarehouseCode + splitFlag + skuStatus;
        try {
            Boolean getLock = this.redisDistributLock.tryLock(lockKey, 3L, TimeUnit.MINUTES);
            if (!getLock.booleanValue()) {
                throw new WarehouseException("WH0001", "\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            List<WhWmsWaitOutStockVO> waitOutStockList = this.getWaitOutStock(physicalWarehouseCode, skuStatus, commandCodes, true);
            this.createCommandPreOccupy(physicalWarehouseCode, skuStatus, waitOutStockList);
        }
        finally {
            this.redisDistributLock.unLock(lockKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean releasePreOccupy(String physicalWarehouseCode) {
        String lockKey = "lock:preOccupy:" + physicalWarehouseCode + splitFlag + WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE;
        try {
            Boolean getLock = this.redisDistributLock.tryLock(lockKey, 3L, TimeUnit.MINUTES);
            if (!getLock.booleanValue()) {
                throw new WarehouseException("WH0001", "\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            boolean bl = this.whWmsCommandPreOccupyService.releasePreOccupy(physicalWarehouseCode);
            return bl;
        }
        finally {
            this.redisDistributLock.unLock(lockKey);
        }
    }

    private void createCommandPreOccupy(String physicalWarehouseCode, Integer skuStatus, List<WhWmsWaitOutStockVO> waitOutStockList) {
        List<WhCommandPickStockInfoVO> pickStockInfoList = this.computePickStock(physicalWarehouseCode, skuStatus, waitOutStockList);
        this.commandShortRecordThenReplenish(physicalWarehouseCode, pickStockInfoList);
        List allList = ListUtils.partition(pickStockInfoList, (int)100);
        for (List partList : allList) {
            List<WhWmsCommandPreOccupyVO> preOccupyList = this.buildPreOccupy(partList);
            this.whWmsCommandPreOccupyService.createPreOccupy(preOccupyList);
        }
    }

    private void commandShortRecordThenReplenish(String physicalWarehouseCode, List<WhCommandPickStockInfoVO> pickStockInfoList) {
        if (EmptyUtil.isEmpty(pickStockInfoList)) {
            return;
        }
        ArrayList<String> shortCommands = new ArrayList<String>();
        ArrayList<WhWmsCommandShortRecord> shortRecordList = new ArrayList<WhWmsCommandShortRecord>();
        Map<String, Integer> shortSkuMap = null;
        ArrayList<String> skuCodes = new ArrayList<String>();
        for (WhCommandPickStockInfoVO pickStockInfo : pickStockInfoList) {
            if (pickStockInfo.isEnough()) continue;
            shortCommands.add(pickStockInfo.getCommandCode());
            shortSkuMap = pickStockInfo.getShortSkuMap();
            for (Map.Entry<String, Integer> entry : shortSkuMap.entrySet()) {
                WhWmsCommandShortRecord shortRecord = new WhWmsCommandShortRecord();
                shortRecord.setCommandCode(pickStockInfo.getCommandCode());
                shortRecord.setSkuCode(entry.getKey());
                shortRecord.setShortAmount(entry.getValue());
                shortRecordList.add(shortRecord);
                skuCodes.add(entry.getKey());
            }
        }
        if (EmptyUtil.isNotEmpty(shortCommands)) {
            this.whCommandService.failureStartConnect(shortCommands);
            this.whCommandService.recordCommandShortSku(shortRecordList);
            WhWmsPreOccupyBlackListInfoVO blackListInfo = this.findPreOccupyBlackListInfo(physicalWarehouseCode);
            if (NullUtil.isNotNull((Object)blackListInfo) && blackListInfo.isOn()) {
                ReplenishTask replenishTask = new ReplenishTask(physicalWarehouseCode, skuCodes);
                this.taskScheduler.execute((Runnable)replenishTask);
            }
        }
    }

    @Override
    public WhWmsConnectStartResultVO connectStart(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig) {
        if (NullUtil.isNull((Object)countConfig.getNeedAmount()) || countConfig.isIntercept()) {
            countConfig.setNeedAmount(9999999);
        }
        WhWmsConnectStartResultVO resultVO = WhWmsConnectStartResultVO.newInstance();
        resultVO.setNeedAmount(countConfig.getNeedAmount());
        resultVO.setPlanedAmount(countConfig.getNeedAmount());
        resultVO.setOperaterId(countConfig.getOperaterId());
        resultVO.setAutoDistribute(conditions.isAutoDistribute());
        this.startLargeSizedPackage(pickStockInfoList, countConfig, resultVO);
        if (resultVO.isEnough()) {
            return resultVO;
        }
        this.startGeSkuMinCountOrGeSkuQanitlyMinCount(pickStockInfoList, countConfig, resultVO);
        if (resultVO.isEnough()) {
            return resultVO;
        }
        this.startSingleProductSinglePiece(pickStockInfoList, conditions, countConfig, resultVO);
        if (resultVO.isEnough()) {
            return resultVO;
        }
        this.startMultiPieceActivity(pickStockInfoList, conditions, countConfig, resultVO);
        if (resultVO.isEnough()) {
            return resultVO;
        }
        this.startMultiProductMultiPiece(pickStockInfoList, conditions, countConfig, resultVO, false);
        if (resultVO.isEnough()) {
            return resultVO;
        }
        this.startMultiProductSinglePieceV2(pickStockInfoList, conditions, countConfig, resultVO);
        if (resultVO.isEnough()) {
            return resultVO;
        }
        this.startMultiProductMultiPiece(pickStockInfoList, conditions, countConfig, resultVO, true);
        if (resultVO.isEnough()) {
            return resultVO;
        }
        this.startForInterceptOrManual(pickStockInfoList, conditions, countConfig, resultVO);
        return resultVO;
    }

    @Override
    public WhWmsConnectStartResultVO connectStartWithConnectType(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig) {
        if (EmptyUtil.isEmpty((String)countConfig.getStartConnectType())) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u7c7b\u578b\u672a\u8bbe\u7f6e");
        }
        if ("single_product_single_piece".equals(countConfig.getStartConnectType())) {
            return this.connectStartSingleProductSinglePiece(pickStockInfoList, conditions, countConfig);
        }
        if ("multi_product_single_piece".equals(countConfig.getStartConnectType())) {
            return this.connectStartMultiProductSinglePiece(pickStockInfoList, conditions, countConfig);
        }
        if ("multi_product_multi_piece".equals(countConfig.getStartConnectType())) {
            return this.connectStartMultiProductMultiPiece(pickStockInfoList, conditions, countConfig);
        }
        throw new WarehouseException("WH0001", "\u6ce2\u6b21\u7c7b\u578b\u5f02\u5e38");
    }

    private WhWmsConnectStartResultVO connectStartSingleProductSinglePiece(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig) {
        if (NullUtil.isNull((Object)countConfig.getNeedAmount()) || countConfig.isIntercept()) {
            countConfig.setNeedAmount(9999999);
        }
        WhWmsConnectStartResultVO resultVO = WhWmsConnectStartResultVO.newInstance();
        resultVO.setNeedAmount(countConfig.getNeedAmount());
        resultVO.setPlanedAmount(countConfig.getNeedAmount());
        resultVO.setOperaterId(countConfig.getOperaterId());
        resultVO.setAutoDistribute(conditions.isAutoDistribute());
        if (EmptyUtil.isEmpty(pickStockInfoList)) {
            return resultVO;
        }
        this.startLargeSizedPackage(pickStockInfoList, countConfig, resultVO);
        if (resultVO.isEnough()) {
            return resultVO;
        }
        this.startSingleProductSinglePiece(pickStockInfoList, conditions, countConfig, resultVO);
        if (resultVO.isEnough()) {
            return resultVO;
        }
        return resultVO;
    }

    private WhWmsConnectStartResultVO connectStartMultiProductSinglePiece(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig) {
        if (NullUtil.isNull((Object)countConfig.getNeedAmount()) || countConfig.isIntercept()) {
            countConfig.setNeedAmount(9999999);
        }
        WhWmsConnectStartResultVO resultVO = WhWmsConnectStartResultVO.newInstance();
        resultVO.setNeedAmount(countConfig.getNeedAmount());
        resultVO.setPlanedAmount(countConfig.getNeedAmount());
        resultVO.setOperaterId(countConfig.getOperaterId());
        resultVO.setAutoDistribute(conditions.isAutoDistribute());
        if (EmptyUtil.isEmpty(pickStockInfoList)) {
            return resultVO;
        }
        this.startLargeSizedPackage(pickStockInfoList, countConfig, resultVO);
        if (resultVO.isEnough()) {
            return resultVO;
        }
        this.startMultiProductSinglePieceV2(pickStockInfoList, conditions, countConfig, resultVO);
        if (resultVO.isEnough()) {
            return resultVO;
        }
        this.startMultiPieceActivity(pickStockInfoList, conditions, countConfig, resultVO);
        if (resultVO.isEnough()) {
            return resultVO;
        }
        return resultVO;
    }

    public WhWmsConnectStartResultVO connectStartMultiProductMultiPiece(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig) {
        if (NullUtil.isNull((Object)countConfig.getNeedAmount()) || countConfig.isIntercept()) {
            countConfig.setNeedAmount(9999999);
        }
        WhWmsConnectStartResultVO resultVO = WhWmsConnectStartResultVO.newInstance();
        resultVO.setNeedAmount(countConfig.getNeedAmount());
        resultVO.setPlanedAmount(countConfig.getNeedAmount());
        resultVO.setOperaterId(countConfig.getOperaterId());
        resultVO.setAutoDistribute(conditions.isAutoDistribute());
        this.startLargeSizedPackage(pickStockInfoList, countConfig, resultVO);
        if (resultVO.isEnough()) {
            return resultVO;
        }
        this.startGeSkuMinCountOrGeSkuQanitlyMinCount(pickStockInfoList, countConfig, resultVO);
        if (resultVO.isEnough()) {
            return resultVO;
        }
        String startConnectType = countConfig.getStartConnectType();
        if (countConfig.isUseAutoFlow()) {
            countConfig.setStartConnectType(null);
        }
        this.startMultiProductMultiPiece(pickStockInfoList, conditions, countConfig, resultVO, false);
        countConfig.setStartConnectType(startConnectType);
        if (resultVO.isEnough()) {
            return resultVO;
        }
        return resultVO;
    }

    private void startForInterceptOrManual(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig, WhWmsConnectStartResultVO resultVO) {
        if (!countConfig.isIntercept()) {
            return;
        }
        HashMap<String, ArrayList<WhCommandPickStockInfoVO>> groupMultiProductMultiPieceMap = new HashMap<String, ArrayList<WhCommandPickStockInfoVO>>();
        String groupKey = null;
        Iterator<WhCommandPickStockInfoVO> iterator = pickStockInfoList.iterator();
        while (iterator.hasNext()) {
            WhCommandPickStockInfoVO pickStockInfo = iterator.next();
            groupKey = this.computeGroupKey(pickStockInfo, conditions);
            ArrayList<WhCommandPickStockInfoVO> multiPieceMultiPieceList = (ArrayList<WhCommandPickStockInfoVO>)groupMultiProductMultiPieceMap.get(groupKey);
            if (EmptyUtil.isEmpty((List)multiPieceMultiPieceList)) {
                multiPieceMultiPieceList = new ArrayList<WhCommandPickStockInfoVO>(countConfig.getMultiProductMultiPieceMaxCount());
                groupMultiProductMultiPieceMap.put(groupKey, multiPieceMultiPieceList);
            }
            multiPieceMultiPieceList.add(pickStockInfo);
            iterator.remove();
        }
        for (List mixList : groupMultiProductMultiPieceMap.values()) {
            while (!EmptyUtil.isEmpty((List)mixList)) {
                int size = Math.min(mixList.size(), countConfig.getMultiProductMultiPieceMaxCount());
                List<WhCommandPickStockInfoVO> needStartList = this.removeRange(mixList, 0, size);
                this.buildThenCreateConnectInfo(needStartList, "multi_product_multi_piece", resultVO);
            }
        }
    }

    private void step4(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig, WhWmsConnectStartResultVO resultVO) {
        HashMap<String, ArrayList<WhCommandPickStockInfoVO>> groupMultiProductMultiPieceMap = new HashMap<String, ArrayList<WhCommandPickStockInfoVO>>();
        String groupKey = null;
        Iterator<WhCommandPickStockInfoVO> iterator = pickStockInfoList.iterator();
        while (iterator.hasNext()) {
            WhCommandPickStockInfoVO pickStockInfo = iterator.next();
            groupKey = this.computeGroupKey(pickStockInfo, conditions);
            ArrayList<WhCommandPickStockInfoVO> multiPieceMultiPieceList = (ArrayList<WhCommandPickStockInfoVO>)groupMultiProductMultiPieceMap.get(groupKey);
            if (EmptyUtil.isEmpty((List)multiPieceMultiPieceList)) {
                multiPieceMultiPieceList = new ArrayList<WhCommandPickStockInfoVO>(countConfig.getMultiProductMultiPieceMaxCount());
                groupMultiProductMultiPieceMap.put(groupKey, multiPieceMultiPieceList);
            }
            multiPieceMultiPieceList.add(pickStockInfo);
            iterator.remove();
            if (multiPieceMultiPieceList.size() != countConfig.getMultiProductMultiPieceMaxCount().intValue()) continue;
            this.buildThenCreateConnectInfo(multiPieceMultiPieceList, "multi_product_multi_piece", resultVO);
            if (resultVO.isEnough()) {
                return;
            }
            groupMultiProductMultiPieceMap.remove(groupKey);
        }
        for (List mixList : groupMultiProductMultiPieceMap.values()) {
            if (mixList.size() >= countConfig.getMultiProductMultiPieceMinCount()) {
                this.buildThenCreateConnectInfo(mixList, "multi_product_multi_piece", resultVO);
                if (!resultVO.isEnough()) continue;
                return;
            }
            if (!EmptyUtil.isNotEmpty((List)mixList)) continue;
            pickStockInfoList.addAll(mixList);
        }
    }

    private void startMultiProductSinglePiece(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig, WhWmsConnectStartResultVO resultVO) {
        Map<String, List<WhCommandPickStockInfoVO>> multiProductSinglePieceAreaMap;
        Map<String, Map<String, List<WhCommandPickStockInfoVO>>> groupMultiProductSinglePieceMap = this.filterAndStartMaxMultiProductSinglePiece(pickStockInfoList, conditions, countConfig, resultVO);
        if (resultVO.isEnough() || groupMultiProductSinglePieceMap.isEmpty()) {
            return;
        }
        String groupKey = null;
        HashMap<String, HashMap<String, List<WhCommandPickStockInfoVO>>> groupMultiProductSinglePieceAreaMap = new HashMap<String, HashMap<String, List<WhCommandPickStockInfoVO>>>();
        for (Map.Entry<String, Map<String, List<WhCommandPickStockInfoVO>>> entry : groupMultiProductSinglePieceMap.entrySet()) {
            groupKey = entry.getKey();
            HashMap<String, List<WhCommandPickStockInfoVO>> areaMap = (HashMap<String, List<WhCommandPickStockInfoVO>>)groupMultiProductSinglePieceAreaMap.get(groupKey);
            if (NullUtil.isNull((Object)areaMap)) {
                areaMap = new HashMap<String, List<WhCommandPickStockInfoVO>>();
                groupMultiProductSinglePieceAreaMap.put(groupKey, areaMap);
            }
            Map<String, List<WhCommandPickStockInfoVO>> shelvesMap = entry.getValue();
            for (List<WhCommandPickStockInfoVO> shelvesPickList : shelvesMap.values()) {
                WhCommandPickStockInfoVO oneShelvesPickInfo = shelvesPickList.get(0);
                String singleHouseType = oneShelvesPickInfo.getSingleHouseType();
                List<WhCommandPickStockInfoVO> areaPickList = this.getGroupPickList(areaMap, singleHouseType, countConfig.getMultiProductSinglePieceMaxCount());
                areaPickList.addAll(shelvesPickList);
                if (areaPickList.size() < countConfig.getMultiProductSinglePieceMaxCount()) continue;
                List<WhCommandPickStockInfoVO> needStartList = this.removeRange(areaPickList, 0, countConfig.getMultiProductSinglePieceMaxCount());
                this.buildThenCreateConnectInfo(needStartList, "multi_product_single_piece", resultVO);
                if (!resultVO.isEnough()) continue;
                return;
            }
        }
        for (Map.Entry<String, Map<String, List<WhCommandPickStockInfoVO>>> entry : groupMultiProductSinglePieceAreaMap.entrySet()) {
            multiProductSinglePieceAreaMap = entry.getValue();
            Iterator<Map.Entry<String, List<WhCommandPickStockInfoVO>>> it = multiProductSinglePieceAreaMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, List<WhCommandPickStockInfoVO>> entry2 = it.next();
                List<WhCommandPickStockInfoVO> areaList = entry2.getValue();
                if (areaList.size() < countConfig.getMultiProductSinglePieceMinCount()) continue;
                this.buildThenCreateConnectInfo(areaList, "multi_product_single_piece", resultVO);
                if (resultVO.isEnough()) {
                    return;
                }
                it.remove();
            }
        }
        for (Map.Entry<String, Map<String, List<WhCommandPickStockInfoVO>>> entry : groupMultiProductSinglePieceAreaMap.entrySet()) {
            multiProductSinglePieceAreaMap = entry.getValue();
            Collection<List<WhCommandPickStockInfoVO>> areaLists = multiProductSinglePieceAreaMap.values();
            if (Boolean.TRUE.equals(countConfig.getMultiProductSinglePieceMergeShelvesArea())) {
                areaLists = this.sortThenFull(multiProductSinglePieceAreaMap.values(), countConfig.getMultiProductSinglePieceMaxCount());
            }
            for (List<WhCommandPickStockInfoVO> areaList : areaLists) {
                int size = areaList.size();
                if (size == countConfig.getMultiProductSinglePieceMaxCount() || size >= countConfig.getMultiProductSinglePieceMinCount() || "multi_product_single_piece".equals(countConfig.getStartConnectType()) && !countConfig.isUseAutoFlow()) {
                    this.buildThenCreateConnectInfo(areaList, "multi_product_single_piece", resultVO);
                    if (!resultVO.isEnough()) continue;
                    return;
                }
                pickStockInfoList.addAll(areaList);
            }
        }
    }

    private Map<String, Map<String, List<WhCommandPickStockInfoVO>>> filterAndStartMaxMultiProductSinglePiece(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig, WhWmsConnectStartResultVO resultVO) {
        HashMap<String, Map<String, List<WhCommandPickStockInfoVO>>> groupMultiProductSinglePieceMap = new HashMap<String, Map<String, List<WhCommandPickStockInfoVO>>>();
        String groupKey = null;
        Iterator<WhCommandPickStockInfoVO> iterator = pickStockInfoList.iterator();
        while (iterator.hasNext()) {
            WhCommandPickStockInfoVO pickStockInfo = iterator.next();
            groupKey = this.computeGroupKey(pickStockInfo, conditions);
            if (!pickStockInfo.isSingle()) continue;
            HashMap<String, List<WhCommandPickStockInfoVO>> multiProductSinglePieceAreaShelvesMap = (HashMap<String, List<WhCommandPickStockInfoVO>>)groupMultiProductSinglePieceMap.get(groupKey);
            if (NullUtil.isNull((Object)multiProductSinglePieceAreaShelvesMap)) {
                multiProductSinglePieceAreaShelvesMap = new HashMap<String, List<WhCommandPickStockInfoVO>>();
                groupMultiProductSinglePieceMap.put(groupKey, multiProductSinglePieceAreaShelvesMap);
            }
            WhWmsCommandPreOccupyVO preOccupy = pickStockInfo.getPreOccupyList().get(0);
            String singlePickShelvesCode = preOccupy.getShelvesCode();
            List<WhCommandPickStockInfoVO> areaShelvesList = this.getGroupPickList(multiProductSinglePieceAreaShelvesMap, singlePickShelvesCode, countConfig.getMultiProductSinglePieceMaxCount());
            areaShelvesList.add(pickStockInfo);
            iterator.remove();
            if (areaShelvesList.size() != countConfig.getMultiProductSinglePieceMaxCount().intValue()) continue;
            this.buildThenCreateConnectInfo(areaShelvesList, "multi_product_single_piece", resultVO);
            multiProductSinglePieceAreaShelvesMap.remove(singlePickShelvesCode);
            if (!resultVO.isEnough()) continue;
            return groupMultiProductSinglePieceMap;
        }
        return groupMultiProductSinglePieceMap;
    }

    private void startMultiProductSinglePieceV2(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig, WhWmsConnectStartResultVO resultVO) {
        Map<String, Map<String, Map<String, Map<String, List<WhCommandPickStockInfoVO>>>>> groupMultiProductSinglePieceMap = this.filterAndStartMultiProductSinglePieceShelveSkuBarcode(pickStockInfoList, conditions, countConfig, resultVO, GROUP_SHELVE, false);
        if (resultVO.isEnough() || groupMultiProductSinglePieceMap.isEmpty()) {
            return;
        }
        List<WhCommandPickStockInfoVO> housePickList = this.resetPickStockInfo(groupMultiProductSinglePieceMap);
        Map<String, Map<String, Map<String, Map<String, List<WhCommandPickStockInfoVO>>>>> houseGroupMultiProductSinglePieceMap = this.filterAndStartMultiProductSinglePieceShelveSkuBarcode(housePickList, conditions, countConfig, resultVO, GROUP_HOUSETYPE, false);
        if (resultVO.isEnough() || houseGroupMultiProductSinglePieceMap.isEmpty()) {
            return;
        }
        List<WhCommandPickStockInfoVO> nonehousePickList = this.resetPickStockInfo(houseGroupMultiProductSinglePieceMap);
        if (Boolean.TRUE.equals(countConfig.getMultiProductSinglePieceMergeShelvesArea())) {
            Map<String, Map<String, Map<String, Map<String, List<WhCommandPickStockInfoVO>>>>> noneGroupMap = this.filterAndStartMultiProductSinglePieceShelveSkuBarcode(nonehousePickList, conditions, countConfig, resultVO, GROUP_NONE, true);
            if (resultVO.isEnough() || noneGroupMap.isEmpty()) {
                return;
            }
            List<WhCommandPickStockInfoVO> restList = this.resetPickStockInfo(noneGroupMap);
            if (EmptyUtil.isNotEmpty(restList)) {
                pickStockInfoList.addAll(restList);
            }
        } else {
            Map<String, Map<String, Map<String, Map<String, List<WhCommandPickStockInfoVO>>>>> houseTypeGroupMap = this.filterAndStartMultiProductSinglePieceShelveSkuBarcode(nonehousePickList, conditions, countConfig, resultVO, GROUP_HOUSETYPE, true);
            if (resultVO.isEnough() || houseTypeGroupMap.isEmpty()) {
                return;
            }
            List<WhCommandPickStockInfoVO> restList = this.resetPickStockInfo(houseTypeGroupMap);
            if (EmptyUtil.isNotEmpty(restList)) {
                pickStockInfoList.addAll(restList);
            }
        }
    }

    private List<WhCommandPickStockInfoVO> resetPickStockInfo(Map<String, Map<String, Map<String, Map<String, List<WhCommandPickStockInfoVO>>>>> groupShelveSkuBarcodeMap) {
        ArrayList<WhCommandPickStockInfoVO> pickStockInfoList = new ArrayList<WhCommandPickStockInfoVO>();
        for (Map<String, Map<String, Map<String, List<WhCommandPickStockInfoVO>>>> shelveSkuBarcodMap : groupShelveSkuBarcodeMap.values()) {
            for (Map<String, Map<String, List<WhCommandPickStockInfoVO>>> skuBarcodeMap : shelveSkuBarcodMap.values()) {
                for (Map<String, List<WhCommandPickStockInfoVO>> barcodeMap : skuBarcodeMap.values()) {
                    for (List<WhCommandPickStockInfoVO> barcodePickStockList : barcodeMap.values()) {
                        if (!EmptyUtil.isNotEmpty(barcodePickStockList)) continue;
                        pickStockInfoList.addAll(barcodePickStockList);
                    }
                }
            }
        }
        return pickStockInfoList;
    }

    private Map<String, Map<String, Map<String, Map<String, List<WhCommandPickStockInfoVO>>>>> filterAndStartMultiProductSinglePieceShelveSkuBarcode(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig, WhWmsConnectStartResultVO resultVO, String groupType, boolean needJoin) {
        HashMap<String, Map<String, Map<String, Map<String, List<WhCommandPickStockInfoVO>>>>> groupMultiProductSinglePieceMap = new HashMap<String, Map<String, Map<String, Map<String, List<WhCommandPickStockInfoVO>>>>>();
        this.buildAndStartMaxLimitSingleShelveMultSkuSingleBarcode(groupMultiProductSinglePieceMap, pickStockInfoList, conditions, countConfig, resultVO, groupType);
        if (resultVO.isEnough()) {
            return groupMultiProductSinglePieceMap;
        }
        for (Map groupShelveMap : groupMultiProductSinglePieceMap.values()) {
            for (Map.Entry singleBarcodeMapEntry : groupShelveMap.entrySet()) {
                String shelveCode = (String)singleBarcodeMapEntry.getKey();
                Map shelveSkuMap = (Map)singleBarcodeMapEntry.getValue();
                ArrayList<WhCommandPickStockInfoVO> shelveBarcodePickList = new ArrayList<WhCommandPickStockInfoVO>();
                boolean nextShelve = false;
                while (!nextShelve) {
                    nextShelve = true;
                    Iterator entryIt = shelveSkuMap.entrySet().iterator();
                    while (entryIt.hasNext()) {
                        Map.Entry entry = entryIt.next();
                        String skuCode = (String)entry.getKey();
                        Map skuBarcodeMap = (Map)entry.getValue();
                        List<WhCommandPickStockInfoVO> barCodePickList = this.getMaxBarCodePickStockList(skuBarcodeMap);
                        if (EmptyUtil.isEmpty(barCodePickList)) continue;
                        WhCommandPickStockInfoVO pickInfo = barCodePickList.get(0);
                        String barCode = pickInfo.getSingleBarcode();
                        skuBarcodeMap.remove(barCode);
                        this.tryFullToLimit(shelveBarcodePickList, barCodePickList, countConfig.getMultiProductSinglePieceMaxCount());
                        if (EmptyUtil.isNotEmpty(barCodePickList)) {
                            skuBarcodeMap.put(pickInfo.getSingleBarcode(), barCodePickList);
                        }
                        if (skuBarcodeMap.isEmpty()) {
                            entryIt.remove();
                        }
                        if (!EmptyUtil.isNotEmpty(shelveBarcodePickList) || shelveBarcodePickList.size() != countConfig.getMultiProductSinglePieceMaxCount().intValue() && (!GROUP_HOUSETYPE.equals(groupType) && !GROUP_NONE.equals(groupType) || shelveBarcodePickList.size() < countConfig.getMultiProductSinglePieceMinCount() || entryIt.hasNext()) && (!GROUP_HOUSETYPE.equals(groupType) && !GROUP_NONE.equals(groupType) || !needJoin || !"multi_product_single_piece".equals(countConfig.getStartConnectType()) || countConfig.isUseAutoFlow() || entryIt.hasNext())) continue;
                        this.buildThenCreateConnectInfo(shelveBarcodePickList, "multi_product_single_piece", resultVO);
                        shelveBarcodePickList.clear();
                        nextShelve = false;
                        if (!resultVO.isEnough()) break;
                        return groupMultiProductSinglePieceMap;
                    }
                    if (!EmptyUtil.isNotEmpty(shelveBarcodePickList)) continue;
                    this.buildAndStartMaxLimitSingleShelveMultSkuSingleBarcode(groupMultiProductSinglePieceMap, shelveBarcodePickList, conditions, countConfig, resultVO, groupType);
                }
            }
        }
        return groupMultiProductSinglePieceMap;
    }

    private void buildAndStartMaxLimitSingleShelveMultSkuSingleBarcode(Map<String, Map<String, Map<String, Map<String, List<WhCommandPickStockInfoVO>>>>> groupMultiProductSinglePieceMap, List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig, WhWmsConnectStartResultVO resultVO, String groupType) {
        String groupKey = null;
        Iterator<WhCommandPickStockInfoVO> iterator = pickStockInfoList.iterator();
        while (iterator.hasNext()) {
            Map<String, List<WhCommandPickStockInfoVO>> barCodeMap;
            WhCommandPickStockInfoVO pickStockInfo = iterator.next();
            groupKey = this.computeGroupKey(pickStockInfo, conditions);
            if (!pickStockInfo.isSingle()) continue;
            Map<String, Map<String, Map<String, List<WhCommandPickStockInfoVO>>>> multiProductSinglePieceAreaShelvesMap = groupMultiProductSinglePieceMap.get(groupKey);
            if (NullUtil.isNull(multiProductSinglePieceAreaShelvesMap)) {
                multiProductSinglePieceAreaShelvesMap = new HashMap<String, Map<String, Map<String, List<WhCommandPickStockInfoVO>>>>();
                groupMultiProductSinglePieceMap.put(groupKey, multiProductSinglePieceAreaShelvesMap);
            }
            WhWmsCommandPreOccupyVO preOccupy = pickStockInfo.getPreOccupyList().get(0);
            String singlePickShelvesCode = null;
            if (GROUP_SHELVE.equals(groupType)) {
                singlePickShelvesCode = preOccupy.getShelvesCode();
            } else if (GROUP_HOUSETYPE.equals(groupType)) {
                singlePickShelvesCode = preOccupy.getHouseType();
            } else if (GROUP_NONE.equals(groupType)) {
                singlePickShelvesCode = GROUP_NONE;
            }
            String skuCode = preOccupy.getSkuCode();
            String barCode = preOccupy.getBarCode();
            Map<String, Map<String, List<WhCommandPickStockInfoVO>>> shelveSkuMap = multiProductSinglePieceAreaShelvesMap.get(singlePickShelvesCode);
            if (NullUtil.isNull(shelveSkuMap)) {
                shelveSkuMap = new HashMap<String, Map<String, List<WhCommandPickStockInfoVO>>>();
                multiProductSinglePieceAreaShelvesMap.put(singlePickShelvesCode, shelveSkuMap);
            }
            if (NullUtil.isNull(barCodeMap = shelveSkuMap.get(skuCode))) {
                barCodeMap = new HashMap<String, List<WhCommandPickStockInfoVO>>();
                shelveSkuMap.put(skuCode, barCodeMap);
            }
            List<WhCommandPickStockInfoVO> barCodeShelvesList = this.getGroupPickList(barCodeMap, barCode, countConfig.getMultiProductSinglePieceMaxCount());
            barCodeShelvesList.add(pickStockInfo);
            iterator.remove();
            if (barCodeShelvesList.size() != countConfig.getMultiProductSinglePieceMaxCount().intValue()) continue;
            this.buildThenCreateConnectInfo(barCodeShelvesList, "multi_product_single_piece", resultVO);
            barCodeMap.remove(barCode);
            if (!resultVO.isEnough()) continue;
            return;
        }
    }

    private void tryFullToLimit(List<WhCommandPickStockInfoVO> shelveBarcodePickList, List<WhCommandPickStockInfoVO> barCodePickList, int limit) {
        int comeAmount;
        int pickAmount = shelveBarcodePickList.size();
        if (pickAmount + (comeAmount = barCodePickList.size()) > limit) {
            List<WhCommandPickStockInfoVO> needStartList = this.removeRange(barCodePickList, 0, limit - pickAmount);
            shelveBarcodePickList.addAll(needStartList);
        } else {
            shelveBarcodePickList.addAll(barCodePickList);
            barCodePickList.clear();
        }
    }

    private List<WhCommandPickStockInfoVO> getMaxBarCodePickStockList(Map<String, List<WhCommandPickStockInfoVO>> skuBarcodeMap) {
        List<WhCommandPickStockInfoVO> maxList = Collections.emptyList();
        for (List<WhCommandPickStockInfoVO> skuBarcodePickList : skuBarcodeMap.values()) {
            if (maxList.size() >= skuBarcodePickList.size()) continue;
            maxList = skuBarcodePickList;
        }
        return maxList;
    }

    private List<List<WhCommandPickStockInfoVO>> sortThenFull(Collection<List<WhCommandPickStockInfoVO>> collection, int limit) {
        List<List<WhCommandPickStockInfoVO>> sortList = this.sortByHouseTypeDesc(collection);
        if (EmptyUtil.isNotEmpty(sortList)) {
            int size = sortList.size();
            int beforeIndex = 0;
            int backIndex = size - 1;
            List<WhCommandPickStockInfoVO> beforeList = sortList.get(beforeIndex);
            List<WhCommandPickStockInfoVO> backList = sortList.get(backIndex);
            while (beforeIndex < backIndex) {
                int needSize = limit - beforeList.size();
                int avaliableSize = backList.size();
                if (avaliableSize > needSize) {
                    List<WhCommandPickStockInfoVO> tmpList = backList.subList(0, needSize);
                    beforeList.addAll(tmpList);
                    backList.removeAll(tmpList);
                    beforeList = sortList.get(++beforeIndex);
                    continue;
                }
                beforeList.addAll(backList);
                sortList.remove(backIndex);
                backList = sortList.get(--backIndex);
            }
        }
        return sortList;
    }

    private List<String> findAllGiftCardSkuCode() {
        ArrayList<String> skuCodes = new ArrayList<String>();
        PegasusUtilFacade utilFacade = PegasusUtilFacade.getInstance();
        List commTypeValues = utilFacade.getCommTypeValuesByType("giftCardSkuCode");
        if (EmptyUtil.isNotEmpty((List)commTypeValues)) {
            for (CommTypeValue value : commTypeValues) {
                skuCodes.add(value.getValue());
            }
        }
        return skuCodes;
    }

    private boolean containGiftCardSku(WhCommandPickStockInfoVO pickStockInfo, List<String> giftCardSkuCodes) {
        if (EmptyUtil.isEmpty(pickStockInfo.getPreOccupyList())) {
            throw new WarehouseException("WH0001", "\u9884\u5360\u7528\u672a\u7a7a");
        }
        if (EmptyUtil.isNotEmpty(giftCardSkuCodes)) {
            for (WhWmsCommandPreOccupyVO preOccupy : pickStockInfo.getPreOccupyList()) {
                if (!giftCardSkuCodes.contains(preOccupy.getSkuCode())) continue;
                return true;
            }
        }
        return false;
    }

    private void startSingleProductSinglePiece(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig, WhWmsConnectStartResultVO resultVO) {
        HashMap<String, List<WhCommandPickStockInfoVO>> singleProductSinglePieceMap = new HashMap<String, List<WhCommandPickStockInfoVO>>();
        String groupKey = null;
        Object skuCodeKey = null;
        String mixKey = null;
        Iterator<WhCommandPickStockInfoVO> iterator = pickStockInfoList.iterator();
        List<String> giftCardSkuCodes = this.findAllGiftCardSkuCode();
        while (iterator.hasNext()) {
            WhCommandPickStockInfoVO pickStockInfo = iterator.next();
            if (pickStockInfo.isNeedCard() || !pickStockInfo.isSingle() || this.containGiftCardSku(pickStockInfo, giftCardSkuCodes)) continue;
            groupKey = this.computeGroupKey(pickStockInfo, conditions);
            mixKey = this.computeMixKey(groupKey, pickStockInfo.getSingleBarcode());
            List<WhCommandPickStockInfoVO> singleSkuList = this.getGroupPickList(singleProductSinglePieceMap, mixKey, countConfig.getSingleProductSinglePieceMaxCount());
            singleSkuList.add(pickStockInfo);
            iterator.remove();
            if (singleSkuList.size() != countConfig.getSingleProductSinglePieceMaxCount().intValue()) continue;
            this.buildThenCreateConnectInfo(singleSkuList, "single_product_single_piece", resultVO);
            if (resultVO.isEnough()) {
                return;
            }
            singleSkuList.clear();
        }
        this.handleRestPickStockInfo(singleProductSinglePieceMap, resultVO, countConfig, "single_product_single_piece", pickStockInfoList);
    }

    private void startMultiPieceActivity(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig, WhWmsConnectStartResultVO resultVO) {
        if (EmptyUtil.isEmpty(conditions.getActiveConditions())) {
            return;
        }
        HashMap<String, List<WhCommandPickStockInfoVO>> groupMultiProductActivityMap = new HashMap<String, List<WhCommandPickStockInfoVO>>();
        String groupKey = null;
        String activityKey = null;
        String mixKey = null;
        Iterator<WhCommandPickStockInfoVO> iterator = pickStockInfoList.iterator();
        List<String> giftCardSkuCodes = this.findAllGiftCardSkuCode();
        while (iterator.hasNext()) {
            WhCommandPickStockInfoVO pickStockInfo = iterator.next();
            if (pickStockInfo.isNeedCard() || this.containGiftCardSku(pickStockInfo, giftCardSkuCodes) || EmptyUtil.isEmpty((String)(activityKey = this.computeActivityKey(pickStockInfo, conditions)))) continue;
            groupKey = this.computeGroupKey(pickStockInfo, conditions);
            mixKey = this.computeMixKey(groupKey, activityKey);
            List<WhCommandPickStockInfoVO> multiProductActivityPickList = this.getGroupPickList(groupMultiProductActivityMap, mixKey, countConfig.getMultiPieceActivityMaxCount());
            multiProductActivityPickList.add(pickStockInfo);
            iterator.remove();
            if (multiProductActivityPickList.size() != countConfig.getMultiPieceActivityMaxCount().intValue()) continue;
            this.buildThenCreateConnectInfo(multiProductActivityPickList, "multi_piece_activity", resultVO);
            if (resultVO.isEnough()) {
                return;
            }
            multiProductActivityPickList.clear();
        }
        String needConnectType = countConfig.getStartConnectType();
        if ("multi_product_single_piece".equals(countConfig.getStartConnectType())) {
            countConfig.setStartConnectType("multi_piece_activity");
        }
        this.handleRestPickStockInfo(groupMultiProductActivityMap, resultVO, countConfig, "multi_piece_activity", pickStockInfoList);
        countConfig.setStartConnectType(needConnectType);
    }

    private List<WhCommandPickStockInfoVO> getGroupPickList(Map<String, List<WhCommandPickStockInfoVO>> groupListMap, String groupKey, Integer defaultSize) {
        List<WhCommandPickStockInfoVO> pickList = groupListMap.get(groupKey);
        if (NullUtil.isNull(pickList)) {
            pickList = NullUtil.isNull((Object)defaultSize) ? new ArrayList<WhCommandPickStockInfoVO>() : new ArrayList<WhCommandPickStockInfoVO>(defaultSize);
            groupListMap.put(groupKey, pickList);
        }
        return pickList;
    }

    private void handleRestPickStockInfo(Map<String, List<WhCommandPickStockInfoVO>> groupPickStockInfoMap, WhWmsConnectStartResultVO resultVO, WhWmsConnectStartCountConfigVO countConfig, String startConnectType, List<WhCommandPickStockInfoVO> pickStockInfoPool) {
        Integer minCount = this.getConnectMinCount(countConfig, startConnectType);
        for (List<WhCommandPickStockInfoVO> groupList : groupPickStockInfoMap.values()) {
            if (EmptyUtil.isEmpty(groupList) || NullUtil.isNull((Object)minCount)) continue;
            if (groupList.size() >= minCount || startConnectType.equals(countConfig.getStartConnectType()) && !countConfig.isUseAutoFlow()) {
                this.buildThenCreateConnectInfo(groupList, startConnectType, resultVO);
                if (!resultVO.isEnough()) continue;
                return;
            }
            if (!EmptyUtil.isNotEmpty(groupList)) continue;
            pickStockInfoPool.addAll(groupList);
        }
    }

    private Integer getConnectMinCount(WhWmsConnectStartCountConfigVO countConfig, String startConnectType) {
        return "single_product_single_piece".equals(startConnectType) ? countConfig.getSingleProductSinglePieceMinCount() : ("multi_product_single_piece".equals(startConnectType) ? countConfig.getMultiProductSinglePieceMinCount() : ("multi_piece_activity".equals(startConnectType) ? countConfig.getMultiPieceActivityMinCount() : ("bulk_order".equals(startConnectType) ? countConfig.getMultiProductMultiPieceMinCount() : ("multi_product_multi_piece".equals(startConnectType) ? countConfig.getMultiProductMultiPieceMinCount() : null))));
    }

    private String computeActivityKey(WhCommandPickStockInfoVO pickStockInfo, WhWmsConnectStartConditionsVO conditions) {
        List<WhWmsCommandPreOccupyVO> preOccupyList = pickStockInfo.getPreOccupyList();
        HashMap<String, Integer> pickSkuQuantityMap = new HashMap<String, Integer>();
        TreeMap<String, Integer> pickBarCodeQuantityMap = new TreeMap<String, Integer>();
        HashMap<String, String> barCodeMap = new HashMap<String, String>();
        for (WhWmsCommandPreOccupyVO whWmsCommandPreOccupyVO : preOccupyList) {
            String barCode = (String)barCodeMap.get(whWmsCommandPreOccupyVO.getSkuCode());
            if (NullUtil.isNull((Object)barCode)) {
                barCodeMap.put(whWmsCommandPreOccupyVO.getSkuCode(), whWmsCommandPreOccupyVO.getBarCode());
            } else if (!barCode.equals(whWmsCommandPreOccupyVO.getBarCode())) {
                return null;
            }
            Integer total = (Integer)pickSkuQuantityMap.get(whWmsCommandPreOccupyVO.getSkuCode());
            if (NullUtil.isNull((Object)total)) {
                total = 0;
            }
            total = total - whWmsCommandPreOccupyVO.getAmount();
            pickBarCodeQuantityMap.put(whWmsCommandPreOccupyVO.getBarCode(), total);
            pickSkuQuantityMap.put(whWmsCommandPreOccupyVO.getSkuCode(), total);
        }
        WhWmsConnectStartActiveConditionVO avaliableActivity = null;
        for (WhWmsConnectStartActiveConditionVO condition : conditions.getActiveConditions()) {
            Map<String, Integer> skuQuantityMap = condition.getSkuQuantiyMap();
            int diffSize = pickSkuQuantityMap.size() - skuQuantityMap.size();
            if (diffSize != 0 && diffSize != 1) continue;
            boolean avaliable = true;
            for (Map.Entry<String, Integer> activeEntry : skuQuantityMap.entrySet()) {
                Integer pickAmount;
                String skuCode = activeEntry.getKey();
                Integer activeQuantity = activeEntry.getValue();
                if (activeQuantity.equals(pickAmount = (Integer)pickSkuQuantityMap.get(skuCode))) continue;
                avaliable = false;
                break;
            }
            boolean diffSkuSingle = true;
            if (avaliable && diffSize == 1) {
                for (Map.Entry pickSkuEntry : pickSkuQuantityMap.entrySet()) {
                    if (!NullUtil.isNull((Object)skuQuantityMap.get(pickSkuEntry.getKey()))) continue;
                    if (((Integer)pickSkuEntry.getValue()).equals(1)) break;
                    diffSkuSingle = false;
                    break;
                }
            }
            if (!avaliable || !diffSkuSingle) continue;
            avaliableActivity = condition;
            break;
        }
        if (NullUtil.isNotNull(avaliableActivity)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry pickBarCodeEntry : pickBarCodeQuantityMap.entrySet()) {
                stringBuilder.append((String)pickBarCodeEntry.getKey()).append(splitFlag).append(pickBarCodeEntry.getValue()).append(splitFlag);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    private void startMultiProductMultiPiece(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig, WhWmsConnectStartResultVO resultVO, boolean ignoreConnectType) {
        HashMap<String, List<WhCommandPickStockInfoVO>> groupMultiProductMultiPieceMap = new HashMap<String, List<WhCommandPickStockInfoVO>>();
        TreeMap<Integer, Set<String>> keySizeMap = new TreeMap<Integer, Set<String>>();
        String groupKey = null;
        String houseTypeKey = null;
        String mixKey = null;
        Iterator<WhCommandPickStockInfoVO> iterator = pickStockInfoList.iterator();
        while (iterator.hasNext()) {
            WhCommandPickStockInfoVO pickStockInfo = iterator.next();
            if (pickStockInfo.isSingle() && !"multi_product_multi_piece".equals(countConfig.getStartConnectType()) && !ignoreConnectType) continue;
            groupKey = this.getGroupKey(pickStockInfo, conditions);
            houseTypeKey = this.getHouseTypeKey(pickStockInfo);
            mixKey = this.computeMixKey(groupKey, houseTypeKey);
            HashSet<String> keySizeSet = (HashSet<String>)keySizeMap.get(pickStockInfo.getPickAreaSize());
            if (NullUtil.isNull((Object)keySizeSet)) {
                keySizeSet = new HashSet<String>();
                keySizeMap.put(pickStockInfo.getPickAreaSize(), keySizeSet);
            }
            keySizeSet.add(mixKey);
            List<WhCommandPickStockInfoVO> multiPieceMultiPieceList = this.getGroupPickList(groupMultiProductMultiPieceMap, mixKey, countConfig.getMultiProductMultiPieceMaxCount());
            multiPieceMultiPieceList.add(pickStockInfo);
            if (multiPieceMultiPieceList.size() == countConfig.getMultiProductMultiPieceMaxCount().intValue()) {
                this.buildThenCreateConnectInfo(multiPieceMultiPieceList, "multi_product_multi_piece", resultVO);
                if (resultVO.isEnough()) {
                    return;
                }
                multiPieceMultiPieceList.clear();
            }
            iterator.remove();
        }
        if (countConfig.isUseAutoFlow()) {
            this.combinationThenStartMultiProductMultiPiece(groupMultiProductMultiPieceMap, conditions, countConfig, resultVO, keySizeMap);
            for (List list : groupMultiProductMultiPieceMap.values()) {
                pickStockInfoList.addAll(list);
            }
        } else {
            this.mixThenStartMultiProductMultiPiece(groupMultiProductMultiPieceMap, conditions, countConfig, resultVO, pickStockInfoList);
        }
    }

    private void mixThenStartMultiProductMultiPiece(Map<String, List<WhCommandPickStockInfoVO>> groupMultiProductMultiPieceMap, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig, WhWmsConnectStartResultVO resultVO, List<WhCommandPickStockInfoVO> poolList) {
        String groupKey = null;
        HashMap<String, List<WhCommandPickStockInfoVO>> groupMap = new HashMap<String, List<WhCommandPickStockInfoVO>>();
        for (List<WhCommandPickStockInfoVO> houseTypePickList : groupMultiProductMultiPieceMap.values()) {
            if (EmptyUtil.isEmpty(houseTypePickList)) continue;
            WhCommandPickStockInfoVO onePickInfo = houseTypePickList.get(0);
            groupKey = this.getGroupKey(onePickInfo, conditions);
            List<WhCommandPickStockInfoVO> mixList = this.getGroupPickList(groupMap, groupKey, countConfig.getMultiProductMultiPieceMaxCount());
            mixList.addAll(houseTypePickList);
            if (mixList.size() < countConfig.getMultiProductMultiPieceMaxCount()) continue;
            List<WhCommandPickStockInfoVO> needStartList = this.removeRange(mixList, 0, countConfig.getMultiProductMultiPieceMaxCount());
            this.buildThenCreateConnectInfo(needStartList, "multi_product_multi_piece", resultVO);
            if (!resultVO.isEnough()) continue;
            return;
        }
        this.handleRestPickStockInfo(groupMap, resultVO, countConfig, "multi_product_multi_piece", poolList);
    }

    private void combinationThenStartMultiProductMultiPiece(Map<String, List<WhCommandPickStockInfoVO>> groupMultiProductMultiPieceMap, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig, WhWmsConnectStartResultVO resultVO, Map<Integer, Set<String>> keySizeMap) {
        List<WhCommandPickStockInfoVO> subMultiPieceMultiPieceList = null;
        String subMixKey = null;
        String groupKey = null;
        String houseTypeKey = null;
        for (Map.Entry<Integer, Set<String>> keySizeEntry : keySizeMap.entrySet()) {
            Set<String> keySet = keySizeEntry.getValue();
            for (String mixGroupKey : keySet) {
                String[] keyParts = mixGroupKey.split(splitAreaFlagRegx);
                groupKey = keyParts[0];
                houseTypeKey = keyParts[1];
                List<String> houseTypeKeyCombination = this.computeKeyCombination(houseTypeKey.split(splitFlag));
                ArrayList<WhCommandPickStockInfoVO> multiPieceMultiPieceList = new ArrayList<WhCommandPickStockInfoVO>();
                int keyCombinationSize = houseTypeKeyCombination.size();
                String houseTypeKeyItem = null;
                for (int i = 0; i < keyCombinationSize; ++i) {
                    int endIdx;
                    houseTypeKeyItem = houseTypeKeyCombination.get(i);
                    subMixKey = this.computeMixKey(groupKey, houseTypeKeyItem);
                    subMultiPieceMultiPieceList = groupMultiProductMultiPieceMap.remove(subMixKey);
                    if (EmptyUtil.isNotEmpty(subMultiPieceMultiPieceList)) {
                        multiPieceMultiPieceList.addAll(subMultiPieceMultiPieceList);
                    }
                    if (multiPieceMultiPieceList.size() < countConfig.getMultiProductMultiPieceMaxCount() && i != keyCombinationSize - 1) continue;
                    while (!EmptyUtil.isEmpty(multiPieceMultiPieceList) && ((endIdx = Math.min(multiPieceMultiPieceList.size(), countConfig.getMultiProductMultiPieceMaxCount())) >= countConfig.getMultiProductMultiPieceMaxCount() || i == keyCombinationSize - 1 && endIdx >= countConfig.getMultiProductMultiPieceMinCount() || i == keyCombinationSize - 1 && "multi_product_multi_piece".equals(countConfig.getStartConnectType()) && !countConfig.isUseAutoFlow())) {
                        List<WhCommandPickStockInfoVO> needStartList = this.removeRange(multiPieceMultiPieceList, 0, endIdx);
                        this.buildThenCreateConnectInfo(needStartList, "multi_product_multi_piece", resultVO);
                        if (!resultVO.isEnough()) continue;
                        return;
                    }
                }
                if (!EmptyUtil.isNotEmpty(multiPieceMultiPieceList)) continue;
                this.giveUpPickInfo(multiPieceMultiPieceList, conditions, groupMultiProductMultiPieceMap);
            }
        }
    }

    private void giveUpPickInfo(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, Map<String, List<WhCommandPickStockInfoVO>> groupMultiProductMultiPieceMap) {
        String groupKey = null;
        String houseTypeKey = null;
        String mixKey = null;
        Iterator<WhCommandPickStockInfoVO> iterator = pickStockInfoList.iterator();
        while (iterator.hasNext()) {
            WhCommandPickStockInfoVO pickStockInfo = iterator.next();
            groupKey = this.getGroupKey(pickStockInfo, conditions);
            mixKey = this.computeMixKey(groupKey, houseTypeKey = this.getHouseTypeKey(pickStockInfo));
            List<WhCommandPickStockInfoVO> tmpMultiPieceMultiPieceList = groupMultiProductMultiPieceMap.get(mixKey);
            if (EmptyUtil.isEmpty(tmpMultiPieceMultiPieceList)) {
                tmpMultiPieceMultiPieceList = new ArrayList<WhCommandPickStockInfoVO>();
                groupMultiProductMultiPieceMap.put(mixKey, tmpMultiPieceMultiPieceList);
            }
            tmpMultiPieceMultiPieceList.add(pickStockInfo);
            iterator.remove();
        }
    }

    private List<WhCommandPickStockInfoVO> removeRange(List<WhCommandPickStockInfoVO> list, int fromIndex, int toIndex) {
        ArrayList<WhCommandPickStockInfoVO> removedList = new ArrayList<WhCommandPickStockInfoVO>();
        ListIterator<WhCommandPickStockInfoVO> it = list.listIterator(fromIndex);
        int n = toIndex - fromIndex;
        for (int i = 0; i < n; ++i) {
            removedList.add(it.next());
            it.remove();
        }
        return removedList;
    }

    private List<String> computeKeyCombination(String[] dataList) {
        ArrayList<String> keys = new ArrayList<String>();
        if (EmptyUtil.isNotEmpty((Object[])dataList)) {
            List<String[]> collection = WhWmsConnectStartServiceImpl.combination(dataList);
            for (String[] parts : collection) {
                String key = "";
                for (String part : parts) {
                    key = key + part + splitFlag;
                }
                keys.add(key);
            }
        }
        return keys;
    }

    public static List<String[]> combination(String[] dataList) {
        ArrayList<String[]> collection = new ArrayList<String[]>();
        for (int i = dataList.length; i > 0; --i) {
            collection.addAll(WhWmsConnectStartServiceImpl.combinationSelect(dataList, i));
        }
        return collection;
    }

    public static List<String[]> combinationSelect(String[] dataList, int n) {
        ArrayList<String[]> collection = new ArrayList<String[]>();
        WhWmsConnectStartServiceImpl.combinationSelect(dataList, 0, new String[n], 0, collection);
        return collection;
    }

    private static void combinationSelect(String[] dataList, int dataIndex, String[] resultList, int resultIndex, List<String[]> collection) {
        int resultCount = resultIndex + 1;
        int resultLen = resultList.length;
        if (resultCount > resultLen) {
            collection.add(Arrays.copyOf(resultList, resultList.length));
            return;
        }
        for (int i = dataIndex; i < dataList.length + resultCount - resultLen; ++i) {
            resultList[resultIndex] = dataList[i];
            WhWmsConnectStartServiceImpl.combinationSelect(dataList, i + 1, resultList, resultIndex + 1, collection);
        }
    }

    private static long factorial(int n) {
        return n > 1 ? (long)n * WhWmsConnectStartServiceImpl.factorial(n - 1) : 1L;
    }

    private String getHouseTypeKey(WhCommandPickStockInfoVO pickStockInfo) {
        String houseTypeKey = pickStockInfo.getHouseTypeKey();
        if (EmptyUtil.isEmpty((String)houseTypeKey)) {
            Set<String> pickHouseTypes = pickStockInfo.getPickHouseTypes();
            houseTypeKey = this.buildPickHouseTypeKey(pickHouseTypes);
            pickStockInfo.setHouseTypeKey(houseTypeKey);
        }
        return houseTypeKey;
    }

    private String buildPickHouseTypeKey(Set<String> pickHouseTypes) {
        ArrayList<String> sortList = new ArrayList<String>();
        sortList.addAll(pickHouseTypes);
        Collections.sort(sortList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        StringBuilder buffer = new StringBuilder();
        for (String houseType : sortList) {
            buffer.append(houseType).append(splitFlag);
        }
        return buffer.toString();
    }

    @Deprecated
    private void step0ForAssemble(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig, WhWmsConnectStartResultVO resultVO) {
        HashMap<String, ArrayList<WhCommandPickStockInfoVO>> groupMultiProductMultiPieceMap = new HashMap<String, ArrayList<WhCommandPickStockInfoVO>>();
        String groupKey = null;
        Iterator<WhCommandPickStockInfoVO> iterator = pickStockInfoList.iterator();
        while (iterator.hasNext()) {
            WhCommandPickStockInfoVO pickStockInfo = iterator.next();
            if (!pickStockInfo.isAssemble()) continue;
            groupKey = this.computeGroupKey(pickStockInfo, conditions);
            ArrayList<WhCommandPickStockInfoVO> multiPieceMultiPieceList = (ArrayList<WhCommandPickStockInfoVO>)groupMultiProductMultiPieceMap.get(groupKey);
            if (EmptyUtil.isEmpty((List)multiPieceMultiPieceList)) {
                multiPieceMultiPieceList = new ArrayList<WhCommandPickStockInfoVO>();
                groupMultiProductMultiPieceMap.put(groupKey, multiPieceMultiPieceList);
            }
            multiPieceMultiPieceList.add(pickStockInfo);
            iterator.remove();
        }
        for (List assembleList : groupMultiProductMultiPieceMap.values()) {
            List<List<WhCommandPickStockInfoVO>> lists = this.splitList(assembleList, countConfig.getMultiProductMultiPieceMaxCount());
            for (List<WhCommandPickStockInfoVO> partAssembleList : lists) {
                this.buildThenCreateConnectInfo(partAssembleList, "multi_product_multi_piece", resultVO);
            }
        }
    }

    private void startLargeSizedPackage(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartCountConfigVO countConfig, WhWmsConnectStartResultVO resultVO) {
        List<List<WhCommandPickStockInfoVO>> geMinCountList = this.filterLargeSizedPackage(pickStockInfoList, countConfig);
        for (List<WhCommandPickStockInfoVO> groupList : geMinCountList) {
            this.buildThenCreateConnectInfo(groupList, "large_sized_package", resultVO);
        }
    }

    private List<List<WhCommandPickStockInfoVO>> filterLargeSizedPackage(List<WhCommandPickStockInfoVO> commandPickStockInfoList, WhWmsConnectStartCountConfigVO countConfigVO) {
        HashSet<String> skuCodes = new HashSet<String>();
        for (WhCommandPickStockInfoVO pickStockInfo : commandPickStockInfoList) {
            for (WhWmsCommandPreOccupyVO preOccupy : pickStockInfo.getPreOccupyList()) {
                skuCodes.add(preOccupy.getSkuCode());
            }
        }
        Map<String, WhWmsShelvesSkuInfoVO> shelvesSkuInfoMap = this.findWmShelvesSkuInfo(Arrays.asList(skuCodes.toArray(new String[skuCodes.size()])));
        ArrayList<List<WhCommandPickStockInfoVO>> groupList = new ArrayList<List<WhCommandPickStockInfoVO>>();
        Iterator<WhCommandPickStockInfoVO> iterator = commandPickStockInfoList.iterator();
        WhCommandPickStockInfoVO pickStockInfoVO = null;
        while (iterator.hasNext()) {
            pickStockInfoVO = iterator.next();
            if (pickStockInfoVO.isAssemble() || !this.isLargeSizesPackage(pickStockInfoVO, countConfigVO, shelvesSkuInfoMap)) continue;
            ArrayList<WhCommandPickStockInfoVO> singleGroup = new ArrayList<WhCommandPickStockInfoVO>();
            singleGroup.add(pickStockInfoVO);
            groupList.add(singleGroup);
            iterator.remove();
        }
        return groupList;
    }

    private boolean isLargeSizesPackage(WhCommandPickStockInfoVO pickStockInfo, WhWmsConnectStartCountConfigVO countConfigVO, Map<String, WhWmsShelvesSkuInfoVO> shelvesSkuInfoMap) {
        if (NullUtil.isNull((Object)countConfigVO.getSkuMinSingleLength()) || NullUtil.isNull((Object)countConfigVO.getSkuMinVolume())) {
            return false;
        }
        BigDecimal minVolume = new BigDecimal(countConfigVO.getSkuMinVolume());
        minVolume = minVolume.setScale(3, 4);
        for (WhWmsCommandPreOccupyVO preOccupy : pickStockInfo.getPreOccupyList()) {
            WhWmsShelvesSkuInfoVO shelvesSkuInfo = shelvesSkuInfoMap.get(preOccupy.getSkuCode());
            if (NullUtil.isNull((Object)shelvesSkuInfo)) continue;
            if (countConfigVO.getSkuMinSingleLength() > 0 && (shelvesSkuInfo.getSkuLength().floatValue() >= (float)countConfigVO.getSkuMinSingleLength().intValue() || shelvesSkuInfo.getSkuWidth().floatValue() >= (float)countConfigVO.getSkuMinSingleLength().intValue() || shelvesSkuInfo.getSkuHeight().floatValue() >= (float)countConfigVO.getSkuMinSingleLength().intValue())) {
                return true;
            }
            if (minVolume.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal volumeDecimal = new BigDecimal(shelvesSkuInfo.getSkuLength().floatValue());
            if ((volumeDecimal = volumeDecimal.multiply(new BigDecimal(shelvesSkuInfo.getSkuWidth().floatValue())).multiply(new BigDecimal(shelvesSkuInfo.getSkuHeight().floatValue())).divide(new BigDecimal(1000000000), 3, 4)).compareTo(minVolume) < 0) continue;
            return true;
        }
        return false;
    }

    private Map<String, WhWmsShelvesSkuInfoVO> findWmShelvesSkuInfo(List<String> skuCodes) {
        HashMap<String, WhWmsShelvesSkuInfoVO> map = new HashMap<String, WhWmsShelvesSkuInfoVO>();
        if (EmptyUtil.isEmpty(skuCodes)) {
            return map;
        }
        WhWmsShelvesSkuInfoCond cond = new WhWmsShelvesSkuInfoCond();
        cond.setSkuCodes(skuCodes);
        List<WhWmsShelvesSkuInfoVO> wmsSkuInfoList = this.whWmsShelvesSkuInfoService.getSkuInfoByCond(cond);
        if (EmptyUtil.isNotEmpty(wmsSkuInfoList)) {
            for (WhWmsShelvesSkuInfoVO wmsSkuInfo : wmsSkuInfoList) {
                if (NullUtil.isNull((Object)wmsSkuInfo.getSkuWidth())) {
                    wmsSkuInfo.setSkuWidth(Float.valueOf(0.0f));
                }
                if (NullUtil.isNull((Object)wmsSkuInfo.getSkuHeight())) {
                    wmsSkuInfo.setSkuHeight(Float.valueOf(0.0f));
                }
                if (NullUtil.isNull((Object)wmsSkuInfo.getSkuLength())) {
                    wmsSkuInfo.setSkuLength(Float.valueOf(0.0f));
                }
                map.put(wmsSkuInfo.getSkuCode(), wmsSkuInfo);
            }
        }
        return map;
    }

    private void startGeSkuMinCountOrGeSkuQanitlyMinCount(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartCountConfigVO countConfig, WhWmsConnectStartResultVO resultVO) {
        List<List<WhCommandPickStockInfoVO>> geMinCountList = this.filterGeMinCount(pickStockInfoList, countConfig);
        for (List<WhCommandPickStockInfoVO> groupList : geMinCountList) {
            this.buildThenCreateConnectInfo(groupList, "bulk_order", resultVO);
        }
    }

    private List<List<WhCommandPickStockInfoVO>> splitList(List<WhCommandPickStockInfoVO> list, int limit) {
        ArrayList<List<WhCommandPickStockInfoVO>> lists = new ArrayList<List<WhCommandPickStockInfoVO>>();
        int size = list.size();
        int split = size / limit + 1;
        for (int i = 0; i < split; ++i) {
            int begin = i * limit;
            int end = begin + limit;
            if (end > size) {
                end = size;
            }
            lists.add(list.subList(begin, end));
        }
        return lists;
    }

    private String computeMixKey(String groupKey, String houseTypeKey) {
        return groupKey + splitAreaFlag + houseTypeKey;
    }

    private String getGroupKey(WhCommandPickStockInfoVO pickStockInfo, WhWmsConnectStartConditionsVO conditions) {
        String groupKey = pickStockInfo.getGroupKey();
        if (NullUtil.isNull((Object)groupKey)) {
            groupKey = this.computeGroupKey(pickStockInfo, conditions);
            pickStockInfo.setGroupKey(groupKey);
        }
        return groupKey;
    }

    private String computeGroupKey(WhCommandPickStockInfoVO pickStockInfo, WhWmsConnectStartConditionsVO conditions) {
        Map<String, String> channelGroupMap = conditions.getChannelGroupMap();
        Map<Long, String> expressGroupMap = conditions.getExpressGroupMap();
        String channelGroupKey = channelGroupMap.get(pickStockInfo.getChannelCode());
        if (NullUtil.isNull((Object)channelGroupKey)) {
            channelGroupKey = pickStockInfo.getChannelCode();
        }
        String shelvesAreaKey = NullUtil.isNull((Object)pickStockInfo.getConnectShelveAreaRuleId()) ? "0" : "1";
        String expressGroupKey = expressGroupMap.get(pickStockInfo.getExpressType());
        if (NullUtil.isNull((Object)expressGroupKey)) {
            expressGroupKey = pickStockInfo.getExpressType().toString();
        }
        return pickStockInfo.getSkuStatus() + splitFlag + channelGroupKey + splitFlag + shelvesAreaKey + splitFlag + pickStockInfo.getInOutType() + splitFlag + expressGroupKey + splitFlag + pickStockInfo.isAssemble();
    }

    private String computeShelvesAreaKey(Set<String> pickHouseTypes, List<String> shelvesAreas) {
        for (String pickHouseType : pickHouseTypes) {
            if (!shelvesAreas.contains(pickHouseType)) continue;
            return "1";
        }
        return "0";
    }

    private void buildThenCreateConnectInfo(List<WhCommandPickStockInfoVO> pickStockInfoList, String connectType, WhWmsConnectStartResultVO resultVO) {
        WhCommandPickStockInfoVO pickStockInfo = pickStockInfoList.get(0);
        WhWmsConnectInfoVO connectInfo = this.buildConnectInfo(pickStockInfoList, connectType, pickStockInfo.getSkuStatus(), pickStockInfo.getInOutType(), resultVO.getOperaterId(), resultVO.isAutoDistribute());
        boolean success = this.createConnectInfo(connectInfo);
        if (!success) {
            resultVO.addFailure(pickStockInfoList);
        } else {
            resultVO.needAmountAuotDec().startedAmountAuotInc().addStartConnectInfo(connectInfo);
        }
    }

    private boolean createConnectInfo(WhWmsConnectInfoVO connectInfo) {
        try {
            return this.whWmsConnectInfoService.startConnect(connectInfo);
        }
        catch (Exception e) {
            this.whWmsCommandPreOccupyService.releasePreOccupy(connectInfo.getWhCommandsCodes());
            return false;
        }
    }

    private WhWmsConnectInfoVO buildConnectInfo(List<WhCommandPickStockInfoVO> pickStockInfoList, String connectType, Integer skuStatus, Integer inOutType, Long operaterId, boolean autoDistribute) {
        WhCommandPickStockInfoVO pickStockInfo = pickStockInfoList.get(0);
        WhWmsConnectInfoVO connectInfo = new WhWmsConnectInfoVO();
        connectInfo.setConnectDate(DateUtil.getNow());
        connectInfo.setConnectUserId(NullUtil.isNull((Object)operaterId) ? 1L : operaterId);
        connectInfo.setConnectType(connectType);
        connectInfo.setConnectStatus(WMSConstants.ConnectStatus.WAITING_PROCESS);
        connectInfo.setPhysicalWarehouseCode(pickStockInfo.getPhysicalWarehouseCode());
        connectInfo.setSkuStatus(skuStatus);
        connectInfo.setInOutType(inOutType);
        connectInfo.setDistributeStatus(autoDistribute ? 1 : 0);
        if (NullUtil.isNull((Object)pickStockInfo.getConnectChannelRuleId())) {
            connectInfo.setChannelCode(pickStockInfo.getChannelCode());
        }
        connectInfo.setConnectChannelRuleId(pickStockInfo.getConnectChannelRuleId());
        connectInfo.setConnectShelveAreaRuleId(pickStockInfo.getConnectShelveAreaRuleId());
        HashSet<String> commandCodes = new HashSet<String>();
        HashMap<String, Integer> barCodeShelvesAmountMap = new HashMap<String, Integer>();
        String key = null;
        Integer total = null;
        for (WhCommandPickStockInfoVO stockInfo : pickStockInfoList) {
            commandCodes.add(stockInfo.getCommandCode());
            for (WhWmsCommandPreOccupyVO whWmsCommandPreOccupyVO : stockInfo.getPreOccupyList()) {
                key = whWmsCommandPreOccupyVO.getSkuCode() + splitFlag + whWmsCommandPreOccupyVO.getBarCode() + splitFlag + whWmsCommandPreOccupyVO.getShelvesCode() + splitFlag + whWmsCommandPreOccupyVO.getHouseType();
                total = (Integer)barCodeShelvesAmountMap.get(key);
                if (NullUtil.isNull((Object)total)) {
                    total = 0;
                }
                barCodeShelvesAmountMap.put(key, total - whWmsCommandPreOccupyVO.getAmount());
            }
        }
        connectInfo.setWhCommandsCodes(Arrays.asList(commandCodes.toArray(new String[commandCodes.size()])));
        ArrayList<WhWmsConnectPickSkuVO> pickSkuList = new ArrayList<WhWmsConnectPickSkuVO>();
        String[] arrs = null;
        for (Map.Entry entry : barCodeShelvesAmountMap.entrySet()) {
            key = (String)entry.getKey();
            arrs = key.split(splitFlag);
            WhWmsConnectPickSkuVO pickSku = new WhWmsConnectPickSkuVO();
            pickSku.setSkuStatus(skuStatus);
            pickSku.setSkuCode(arrs[0]);
            pickSku.setBarCode(arrs[1]);
            pickSku.setShelvesCode(arrs[2]);
            pickSku.setHouseType(arrs[3]);
            pickSku.setNeedAmount((Integer)entry.getValue());
            pickSku.setStatus(WhWmsConnectPickSkuVO.STATUS_PENDING);
            pickSkuList.add(pickSku);
        }
        connectInfo.setWhWmsConnectPickSkuVOs(pickSkuList);
        return connectInfo;
    }

    @Override
    public WhWmsCommandPreOccupyCond buildPreOccupyCond(WhWmsConnectStartConditionsVO conditions) {
        List<WhWmsConnectStartChannelConditionVO> channelConditionList;
        WhWmsCommandPreOccupyCond preOccupyCond = (WhWmsCommandPreOccupyCond)((Object)BeanUtil.buildFrom((Object)conditions.getInOutCondition(), WhWmsCommandPreOccupyCond.class));
        WhWmsConnectStartShelvesAreaConditionVO shelvesAreaCondition = conditions.getShelvesAreaCondition();
        if (NullUtil.isNotNull((Object)shelvesAreaCondition)) {
            if (Boolean.TRUE.equals(shelvesAreaCondition.getInclude())) {
                preOccupyCond.setHouseTypes(shelvesAreaCondition.getHouseTypes());
            } else if (Boolean.FALSE.equals(shelvesAreaCondition.getInclude())) {
                preOccupyCond.setExcludeHouseTypes(shelvesAreaCondition.getHouseTypes());
            }
        }
        if (EmptyUtil.isNotEmpty(channelConditionList = conditions.getChannelConditions())) {
            ArrayList<String> channelCodes = new ArrayList<String>();
            for (WhWmsConnectStartChannelConditionVO channelCondition : channelConditionList) {
                if (!EmptyUtil.isNotEmpty(channelCondition.getChannelCodes())) continue;
                for (String channelCode : channelCondition.getChannelCodes()) {
                    channelCodes.add(channelCode);
                }
            }
            preOccupyCond.setChannelCodes(channelCodes);
        }
        if (EmptyUtil.isNotEmpty(conditions.getSkuStatusList())) {
            preOccupyCond.setSkuStatusList(conditions.getSkuStatusList());
        }
        if (NullUtil.isNotNull((Object)conditions.getPlanedDeliveryDate())) {
            preOccupyCond.setPlanedDeliveryDateEnd(DateUtil.dayStart((Date)conditions.getPlanedDeliveryDate()));
        }
        return preOccupyCond;
    }

    @Override
    public List<WhCommandPickStockInfoVO> convertPickStockInfoFromPreOccupy(List<WhWmsCommandPreOccupyVO> preOccupyList, WhWmsConnectStartConditionsVO conditions) {
        List<WhWmsConnectStartChannelConditionVO> channelConditionList = conditions.getChannelConditions();
        WhWmsConnectStartShelvesAreaConditionVO shelvesAreaCondition = conditions.getShelvesAreaCondition();
        ArrayList<WhCommandPickStockInfoVO> pickStockInfoList = new ArrayList<WhCommandPickStockInfoVO>();
        if (EmptyUtil.isEmpty(preOccupyList)) {
            return pickStockInfoList;
        }
        HashMap<String, ArrayList<WhWmsCommandPreOccupyVO>> commandPreOccupyMap = new HashMap<String, ArrayList<WhWmsCommandPreOccupyVO>>();
        for (WhWmsCommandPreOccupyVO preOccupy : preOccupyList) {
            ArrayList<WhWmsCommandPreOccupyVO> tmpList = (ArrayList<WhWmsCommandPreOccupyVO>)commandPreOccupyMap.get(preOccupy.getCommandCode());
            if (NullUtil.isNull((Object)tmpList)) {
                tmpList = new ArrayList<WhWmsCommandPreOccupyVO>();
                commandPreOccupyMap.put(preOccupy.getCommandCode(), tmpList);
            }
            tmpList.add(preOccupy);
        }
        Object commandCode = null;
        List cmdPreOccupyList = null;
        WhWmsCommandPreOccupyVO preOccupyVO = null;
        HashMap<String, Integer> skuQuantityMap = new HashMap<String, Integer>();
        HashSet<String> houseTypes = null;
        String lastSkuCode = null;
        String lastBarcode = null;
        String lasthouseType = null;
        HashMap<String, Long> channelRuleMap = new HashMap<String, Long>();
        for (WhWmsConnectStartChannelConditionVO whWmsConnectStartChannelConditionVO : channelConditionList) {
            if (!EmptyUtil.isNotEmpty(whWmsConnectStartChannelConditionVO.getChannelCodes())) continue;
            for (String channelCode : whWmsConnectStartChannelConditionVO.getChannelCodes()) {
                channelRuleMap.put(channelCode, whWmsConnectStartChannelConditionVO.getChannelRuleId());
            }
        }
        for (Map.Entry entry : commandPreOccupyMap.entrySet()) {
            skuQuantityMap.clear();
            cmdPreOccupyList = (List)entry.getValue();
            preOccupyVO = (WhWmsCommandPreOccupyVO)cmdPreOccupyList.get(0);
            WhCommandPickStockInfoVO pickStockInfoVO = (WhCommandPickStockInfoVO)BeanUtil.buildFrom((Object)preOccupyVO, WhCommandPickStockInfoVO.class);
            pickStockInfoVO.setPreOccupyList(cmdPreOccupyList);
            pickStockInfoVO.setEnough(true);
            pickStockInfoVO.setSingle(WhCommand.SINGLE_YES.equals(preOccupyVO.getSingle()));
            pickStockInfoVO.setConnectChannelRuleId((Long)channelRuleMap.get(preOccupyVO.getChannelCode()));
            houseTypes = new HashSet<String>();
            for (WhWmsCommandPreOccupyVO preOccupy : cmdPreOccupyList) {
                lastSkuCode = preOccupy.getSkuCode();
                lasthouseType = preOccupy.getHouseType();
                lastBarcode = preOccupy.getBarCode();
                Integer total = (Integer)skuQuantityMap.get(preOccupy.getSkuCode());
                houseTypes.add(preOccupy.getHouseType());
                if (NullUtil.isNull((Object)total)) {
                    total = 0;
                }
                skuQuantityMap.put(preOccupy.getSkuCode(), total - preOccupy.getAmount());
            }
            if (pickStockInfoVO.isSingle() && !pickStockInfoVO.isNeedCard()) {
                pickStockInfoVO.setSingleSkuCode(lastSkuCode);
                pickStockInfoVO.setSingleBarcode(lastBarcode);
            }
            if (pickStockInfoVO.isSingle()) {
                pickStockInfoVO.setSingleSkuCode(lastSkuCode);
                pickStockInfoVO.setSingleBarcode(lastBarcode);
                pickStockInfoVO.setSingleHouseType(lasthouseType);
            }
            pickStockInfoVO.setPickHouseTypes(houseTypes);
            pickStockInfoVO.setConnectShelveAreaRuleId(this.getShelvesAreaRuleId(houseTypes, shelvesAreaCondition));
            pickStockInfoVO.setSkuAmount(skuQuantityMap.size());
            pickStockInfoVO.setSkuMaxQuantity(this.getMaxValue(skuQuantityMap.values()));
            pickStockInfoList.add(pickStockInfoVO);
        }
        return pickStockInfoList;
    }

    private Long getShelvesAreaRuleId(Set<String> houseTypes, WhWmsConnectStartShelvesAreaConditionVO shelvesAreaCondition) {
        if (NullUtil.isNotNull(houseTypes) && !houseTypes.isEmpty()) {
            for (String houseType : houseTypes) {
                if (!EmptyUtil.isNotEmpty(shelvesAreaCondition.getHouseTypes()) || !shelvesAreaCondition.getHouseTypes().contains(houseType)) continue;
                return shelvesAreaCondition.getId();
            }
        }
        return null;
    }

    private List<WhWmsWaitOutStockVO> getWaitOutStock(String physicalWarehouseCode, Integer skuStatus, List<String> commandCodes, boolean fetch) {
        ArrayList<Integer> inOutTypes = new ArrayList<Integer>();
        inOutTypes.add(WhCommand.TYPE_SALES_OUT);
        inOutTypes.add(WhCommand.TYPE_CHANGE_OUT);
        WhWmsWaitOutStockCond waitOutStockCond = new WhWmsWaitOutStockCond();
        waitOutStockCond.setPhysicalWarehouseCode(physicalWarehouseCode);
        waitOutStockCond.setInOutTypeList(inOutTypes);
        waitOutStockCond.setSkuStatus(skuStatus);
        waitOutStockCond.setFetch(fetch);
        waitOutStockCond.setCommandCodes(commandCodes);
        waitOutStockCond.setAutoOccupy(true);
        return this.whWmsConnectInfoService.findWaitOutStockCommandSaleOutByCond(waitOutStockCond);
    }

    private List<WhWmsWaitOutStockVO> getWaitOutStockToday(String physicalWarehouseCode, Integer skuStatus, boolean fetch) {
        Date today = this.getToday();
        ArrayList<Integer> inOutTypes = new ArrayList<Integer>();
        inOutTypes.add(WhCommand.TYPE_SALES_OUT);
        inOutTypes.add(WhCommand.TYPE_CHANGE_OUT);
        WhWmsWaitOutStockCond waitOutStockCond = new WhWmsWaitOutStockCond();
        waitOutStockCond.setPhysicalWarehouseCode(physicalWarehouseCode);
        waitOutStockCond.setInOutTypeList(inOutTypes);
        waitOutStockCond.setSkuStatus(skuStatus);
        waitOutStockCond.setFetch(fetch);
        waitOutStockCond.setPlanedDeliveryDateEnd(today);
        List<String> excludeSkuCodes = this.getExcludeSkuCodes();
        if (EmptyUtil.isNotEmpty(excludeSkuCodes)) {
            waitOutStockCond.setExcludeSkuCodes(excludeSkuCodes);
        }
        waitOutStockCond.setAutoOccupy(true);
        waitOutStockCond.setCurrpage(1);
        waitOutStockCond.setPagenum(1000);
        return this.whWmsConnectInfoService.findWaitOutStockCommandSaleOutByCond(waitOutStockCond);
    }

    private List<String> getExcludeSkuCodes() {
        ArrayList<String> skuCodes = new ArrayList<String>();
        PegasusUtilFacade utilFacade = PegasusUtilFacade.getInstance();
        String configValue = utilFacade.findByConfigKey("wms.autoConnect.excludeSku");
        if (EmptyUtil.isNotEmpty((String)configValue)) {
            for (String skuCode : configValue.split(";")) {
                skuCodes.add(skuCode);
            }
        }
        return skuCodes;
    }

    private List<WhWmsCommandPreOccupyVO> buildPreOccupy(List<WhCommandPickStockInfoVO> pickStockInfoList) {
        ArrayList<WhWmsCommandPreOccupyVO> preOccupyList = new ArrayList<WhWmsCommandPreOccupyVO>();
        if (EmptyUtil.isNotEmpty(pickStockInfoList)) {
            for (WhCommandPickStockInfoVO pickStockInfo : pickStockInfoList) {
                this.buildPreOccupyFromPickStockInfo(pickStockInfo, preOccupyList);
            }
        }
        return preOccupyList;
    }

    private void buildPreOccupyFromPickStockInfo(WhCommandPickStockInfoVO pickStockInfo, List<WhWmsCommandPreOccupyVO> preOccupyList) {
        if (!pickStockInfo.isEnough() || EmptyUtil.isEmpty(pickStockInfo.getPickSkuList())) {
            return;
        }
        for (WhCommandSkuPickStockInfoVO skuPickStockInfo : pickStockInfo.getPickSkuList()) {
            if (!EmptyUtil.isNotEmpty(skuPickStockInfo.getStockList())) continue;
            for (WhWmsSkuStockVO skuStock : skuPickStockInfo.getStockList()) {
                WhWmsCommandPreOccupyVO preOccupy = (WhWmsCommandPreOccupyVO)BeanUtil.buildFrom((Object)skuStock, WhWmsCommandPreOccupyVO.class);
                preOccupy.setCommandCode(pickStockInfo.getCommandCode());
                preOccupy.setReceiptsNo(skuPickStockInfo.getCode());
                preOccupy.setCardType(pickStockInfo.getCardType());
                preOccupy.setPhysicalWarehouseCode(pickStockInfo.getPhysicalWarehouseCode());
                preOccupy.setAmount(0 - preOccupy.getAmount());
                preOccupy.setStatus(WMSConstants.WMS_OCCUPY_STATUS_IN_USE);
                preOccupy.setType(WhWmsCommandPreOccupyVO.TYPE_CONNECT);
                preOccupy.setCardType(pickStockInfo.getCardType());
                preOccupy.setSingle(pickStockInfo.isSingle() ? WhCommand.SINGLE_YES : WhCommand.SINGLE_NO);
                preOccupyList.add(preOccupy);
            }
        }
    }

    @Override
    public List<WhCommandPickStockInfoVO> computePickStock(String physicalWarehouseCode, Integer skuStatus, List<WhWmsWaitOutStockVO> waitOutCommandList) {
        Map<String, Integer> skuPlanedQuantityMap = this.computePlanedQuantityMap(waitOutCommandList);
        List<String> skuCodes = Arrays.asList(skuPlanedQuantityMap.keySet().toArray(new String[skuPlanedQuantityMap.size()]));
        List<WhWmsSkuBarcode> skuBarcodeList = null;
        if (EmptyUtil.isNotEmpty(skuCodes)) {
            skuBarcodeList = this.whWmsSkuBarcodeService.findBarCodesForPickSkuStock(skuCodes);
        }
        if (NullUtil.isNull(skuBarcodeList)) {
            skuBarcodeList = new ArrayList<WhWmsSkuBarcode>();
        }
        HashMap<String, WhWmsSkuBarcode> barcodeMap = new HashMap<String, WhWmsSkuBarcode>();
        ArrayList<String> barCodes = new ArrayList<String>();
        for (WhWmsSkuBarcode barcode : skuBarcodeList) {
            barCodes.add(barcode.getBarCode());
            barcodeMap.put(barcode.getBarCode(), barcode);
        }
        Map<String, WhWmsWarehouseArea> areaMap = this.whWmsWarehouseAreaService.getAreaHouseMapByType("NORMAL");
        List<String> houseTypes = Arrays.asList(areaMap.keySet().toArray(new String[areaMap.size()]));
        List<WhWmsSkuStockVO> stockList = null;
        if (EmptyUtil.isNotEmpty(barCodes)) {
            WhWmsSkuStockVO stockCond = new WhWmsSkuStockVO();
            stockCond.setPhysicalWarehouseCode(physicalWarehouseCode);
            stockCond.setSkuStatus(skuStatus);
            stockCond.setBarCodeList(barCodes);
            stockCond.setHouseTypes(houseTypes);
            ArrayList shelvesTypeList = new ArrayList();
            shelvesTypeList.add(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING);
            shelvesTypeList.add(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING);
            stockCond.setShelvesTypeList(shelvesTypeList);
            stockList = this.whWmsSkuStockService.findWmsSkuAvailableAccountWithPreOccupy(stockCond, true);
        }
        if (NullUtil.isNull(stockList)) {
            stockList = new ArrayList<WhWmsSkuStockVO>();
        }
        HashSet<String> shelvesCodes = new HashSet<String>();
        for (WhWmsSkuStockVO skuStock : stockList) {
            shelvesCodes.add(skuStock.getShelvesCode());
        }
        Map<String, WhWmsHouseShelves> shelvesMap = this.whWmsHouseShelvesService.getHouseShelvesMapByCode(Arrays.asList(shelvesCodes.toArray(new String[shelvesCodes.size()])));
        this.filterPickStock(stockList, physicalWarehouseCode, shelvesMap);
        this.sortStock(stockList, barcodeMap, areaMap, shelvesMap);
        return this.distribteStock(physicalWarehouseCode, waitOutCommandList, stockList);
    }

    private void filterPickStock(List<WhWmsSkuStockVO> stockList, String physicalWarehouseCode, Map<String, WhWmsHouseShelves> shelvesMap) {
        if (EmptyUtil.isEmpty(stockList)) {
            return;
        }
        WhWmsPreOccupyBlackListInfoVO blackListInfo = this.findPreOccupyBlackListInfo(physicalWarehouseCode);
        if (NullUtil.isNull((Object)blackListInfo) || !blackListInfo.isOn()) {
            return;
        }
        Iterator<WhWmsSkuStockVO> it = stockList.iterator();
        while (it.hasNext()) {
            WhWmsSkuStockVO skuShelvesStock = it.next();
            WhWmsHouseShelves shelves = shelvesMap.get(skuShelvesStock.getShelvesCode());
            if (NullUtil.isNull((Object)shelves)) {
                it.remove();
            }
            if (WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(shelves.getShelvesType()) || !blackListInfo.getHouseTypeList().contains(shelves.getHouseType()) || blackListInfo.getSkuCodes().contains(skuShelvesStock.getSkuCode())) continue;
            it.remove();
        }
    }

    private WhWmsPreOccupyBlackListInfoVO findPreOccupyBlackListInfo(String physicalWarehouseCode) {
        WhWmsReplenishRuleVO replenishRule = this.whWmsReplenishRuleService.findWhWmsReplenishRuleVOByPhyCode(physicalWarehouseCode, true, true);
        if (NullUtil.isNull((Object)replenishRule)) {
            return null;
        }
        WhWmsPreOccupyBlackListInfoVO blackListInfo = new WhWmsPreOccupyBlackListInfoVO();
        if (NullUtil.isNotNull((Object)replenishRule.getRuleState()) && 1 == replenishRule.getRuleState()) {
            blackListInfo.setOn(true);
        }
        blackListInfo.setPhysicalWarehouseCode(physicalWarehouseCode);
        ArrayList<String> houseTypeList = new ArrayList<String>();
        blackListInfo.setHouseTypeList(houseTypeList);
        if (EmptyUtil.isNotEmpty(replenishRule.getRuleHousetypeVOs())) {
            for (WhWmsReplenishRuleHousetypeVO ruleHousetype : replenishRule.getRuleHousetypeVOs()) {
                houseTypeList.add(ruleHousetype.getHouseType());
            }
        }
        ArrayList<String> skuCodes = new ArrayList<String>();
        blackListInfo.setSkuCodes(skuCodes);
        if (EmptyUtil.isNotEmpty(replenishRule.getRuleBlacklistVOs())) {
            ArrayList<Long> skuSecondCategoryIds = new ArrayList<Long>();
            for (WhWmsReplenishRuleBlacklistVO blacklist : replenishRule.getRuleBlacklistVOs()) {
                if (EmptyUtil.isNotEmpty((String)blacklist.getSkuCode())) {
                    skuCodes.add(blacklist.getSkuCode());
                }
                if (!NullUtil.isNull((Object)blacklist.getSecondCategoryId())) continue;
                skuSecondCategoryIds.add(blacklist.getSecondCategoryId());
            }
            if (EmptyUtil.isNotEmpty(skuSecondCategoryIds)) {
                WhWmsReplenishRuleCond cond = new WhWmsReplenishRuleCond();
                cond.setSecondCategoryIds(skuSecondCategoryIds);
                List<WhWmsReplenishRuleVO> skuList = this.whWmsReplenishRuleService.listPcsSkuVOsByCond(cond);
                if (EmptyUtil.isNotEmpty(skuList)) {
                    for (WhWmsReplenishRuleVO sku : skuList) {
                        skuCodes.add(sku.getSkuCode());
                    }
                }
            }
        }
        return blackListInfo;
    }

    private List<WhCommandPickStockInfoVO> distribteStock(String physicalWarehouseCode, List<WhWmsWaitOutStockVO> waitOutCommandList, List<WhWmsSkuStockVO> stockList) {
        Map<String, List<WhWmsSkuStockVO>> skuStockMap = this.organizeStock(stockList);
        ArrayList<WhCommandPickStockInfoVO> commandPickStockInfoList = new ArrayList<WhCommandPickStockInfoVO>();
        HashMap<String, Integer> cmdSkuMap = new HashMap<String, Integer>();
        for (WhWmsWaitOutStockVO waitOutStockVO : waitOutCommandList) {
            boolean allEnough = true;
            cmdSkuMap.clear();
            HashMap<String, Integer> shortCmdSkuMap = new HashMap<String, Integer>();
            WhCommandPickStockInfoVO commandPickStockInfo = new WhCommandPickStockInfoVO();
            commandPickStockInfo.setShortSkuMap(shortCmdSkuMap);
            commandPickStockInfo.setCommandCode(waitOutStockVO.getCode());
            commandPickStockInfo.setPhysicalWarehouseCode(physicalWarehouseCode);
            ArrayList<WhCommandSkuPickStockInfoVO> pickStockInfoList = new ArrayList<WhCommandSkuPickStockInfoVO>();
            commandPickStockInfo.setPickSkuList(pickStockInfoList);
            String lastSkuCode = null;
            String lastHouseType = null;
            for (WhCommandSku commandSku : waitOutStockVO.getWhCommandSkuList()) {
                lastSkuCode = commandSku.getSkuCode();
                Integer totalQuantity = (Integer)cmdSkuMap.get(commandSku.getSkuCode());
                if (NullUtil.isNull((Object)totalQuantity)) {
                    totalQuantity = 0;
                }
                cmdSkuMap.put(commandSku.getSkuCode(), commandSku.getPlanedQuantity() + totalQuantity);
                WhCommandSkuPickStockInfoVO pickStockInfoVO = new WhCommandSkuPickStockInfoVO();
                pickStockInfoList.add(pickStockInfoVO);
                pickStockInfoVO.setSkuCode(commandSku.getSkuCode());
                pickStockInfoVO.setCode(commandSku.getCode());
                ArrayList<WhWmsSkuStockVO> pickStockList = new ArrayList<WhWmsSkuStockVO>();
                pickStockInfoVO.setStockList(pickStockList);
                int needQuantity = commandSku.getPlanedQuantity();
                List<WhWmsSkuStockVO> skuStockList = skuStockMap.get(commandSku.getSkuCode());
                if (EmptyUtil.isNotEmpty(skuStockList)) {
                    Iterator<WhWmsSkuStockVO> it = skuStockList.iterator();
                    while (it.hasNext() && needQuantity != 0) {
                        WhWmsSkuStockVO stockVO = it.next();
                        if (stockVO.getAvailableAccount() <= 0) continue;
                        Set<String> pickHouseTyps = commandPickStockInfo.getPickHouseTypes();
                        if (NullUtil.isNull(pickHouseTyps)) {
                            pickHouseTyps = new HashSet<String>();
                            commandPickStockInfo.setPickHouseTypes(pickHouseTyps);
                        }
                        lastHouseType = stockVO.getHouseType();
                        pickHouseTyps.add(stockVO.getHouseType());
                        WhWmsSkuStockVO pickStock = (WhWmsSkuStockVO)BeanUtil.buildFrom((Object)stockVO, WhWmsSkuStockVO.class);
                        pickStock.setReceiptNo(commandSku.getCode());
                        if (stockVO.getAvailableAccount() > needQuantity) {
                            pickStock.setAmount(needQuantity);
                            stockVO.setAvailableAccount(stockVO.getAvailableAccount() - needQuantity);
                            needQuantity = 0;
                        } else {
                            pickStock.setAmount(stockVO.getAvailableAccount());
                            needQuantity -= stockVO.getAvailableAccount();
                            stockVO.setAvailableAccount(0);
                            it.remove();
                        }
                        pickStockList.add(pickStock);
                    }
                }
                if (needQuantity == 0) {
                    pickStockInfoVO.setEnough(true);
                    continue;
                }
                allEnough = false;
                shortCmdSkuMap.put(commandSku.getSkuCode(), needQuantity);
                this.giveUpPickStock(skuStockMap, pickStockList);
            }
            commandPickStockInfo.setEnough(allEnough);
            int skuAmount = cmdSkuMap.size();
            commandPickStockInfo.setSkuAmount(skuAmount);
            commandPickStockInfo.setSkuMaxQuantity(this.getMaxValue(cmdSkuMap.values()));
            commandPickStockInfo.setCardType(waitOutStockVO.getCardType());
            if (skuAmount == 1) {
                int singleSkuQuantity = (Integer)cmdSkuMap.get(lastSkuCode);
                if (singleSkuQuantity == 1) {
                    commandPickStockInfo.setSingle(true);
                }
                commandPickStockInfo.setSingleSkuCode(lastSkuCode);
                commandPickStockInfo.setSingleHouseType(lastHouseType);
            }
            commandPickStockInfoList.add(commandPickStockInfo);
        }
        return commandPickStockInfoList;
    }

    private void giveUpPickStock(Map<String, List<WhWmsSkuStockVO>> skuStockMap, List<WhWmsSkuStockVO> pickStockList) {
        if (EmptyUtil.isNotEmpty(pickStockList)) {
            Iterator<WhWmsSkuStockVO> it = pickStockList.iterator();
            WhWmsSkuStockVO pickSkuStock = null;
            while (it.hasNext()) {
                pickSkuStock = it.next();
                List<WhWmsSkuStockVO> skuStockList = skuStockMap.get(pickSkuStock.getSkuCode());
                if (EmptyUtil.isEmpty(skuStockList)) {
                    skuStockList = new ArrayList<WhWmsSkuStockVO>();
                    skuStockMap.put(pickSkuStock.getSkuCode(), skuStockList);
                    pickSkuStock.setAmount(null);
                    skuStockList.add(pickSkuStock);
                } else {
                    for (WhWmsSkuStockVO skuStock : skuStockList) {
                        if (!skuStock.getBarCode().equals(pickSkuStock.getBarCode()) || !skuStock.getShelvesCode().equals(pickSkuStock.getShelvesCode())) continue;
                        skuStock.setAvailableAccount(skuStock.getAvailableAccount() + pickSkuStock.getAmount());
                        break;
                    }
                }
                it.remove();
            }
        }
    }

    private int getMaxValue(Collection<Integer> values) {
        int max = 0;
        for (Integer v : values) {
            max = Math.max(max, v);
        }
        return max;
    }

    private Map<String, List<WhWmsSkuStockVO>> organizeStock(List<WhWmsSkuStockVO> stockList) {
        HashMap<String, List<WhWmsSkuStockVO>> skuStockMap = new HashMap<String, List<WhWmsSkuStockVO>>();
        for (WhWmsSkuStockVO skuStockVO : stockList) {
            ArrayList<WhWmsSkuStockVO> stockInfoList = (ArrayList<WhWmsSkuStockVO>)skuStockMap.get(skuStockVO.getSkuCode());
            if (NullUtil.isNull((Object)stockInfoList)) {
                stockInfoList = new ArrayList<WhWmsSkuStockVO>();
                skuStockMap.put(skuStockVO.getSkuCode(), stockInfoList);
            }
            stockInfoList.add(skuStockVO);
        }
        return skuStockMap;
    }

    private void sortStock(List<WhWmsSkuStockVO> stockList, final Map<String, WhWmsSkuBarcode> barcodeMap, final Map<String, WhWmsWarehouseArea> areaMap, final Map<String, WhWmsHouseShelves> shelvesMap) {
        Collections.sort(stockList, new Comparator<WhWmsSkuStockVO>(){

            @Override
            public int compare(WhWmsSkuStockVO s1, WhWmsSkuStockVO s2) {
                int result = WhWmsConnectStartServiceImpl.this.compareBarCode((WhWmsSkuBarcode)barcodeMap.get(s1.getBarCode()), (WhWmsSkuBarcode)barcodeMap.get(s2.getBarCode()));
                if (result == 0 && (result = WhWmsConnectStartServiceImpl.this.compareShelvesArea((WhWmsWarehouseArea)areaMap.get(s1.getHouseType()), (WhWmsWarehouseArea)areaMap.get(s2.getHouseType()))) == 0 && (result = WhWmsConnectStartServiceImpl.this.compareShelvesType((WhWmsHouseShelves)shelvesMap.get(s1.getShelvesCode()), (WhWmsHouseShelves)shelvesMap.get(s2.getShelvesCode()))) == 0) {
                    result = s1.getAvailableAccount() - s2.getAvailableAccount();
                }
                return result;
            }
        });
    }

    private int compareShelvesType(WhWmsHouseShelves s1, WhWmsHouseShelves s2) {
        if (NullUtil.isNull((Object)s1.getShelvesType()) && NullUtil.isNull((Object)s2.getShelvesType())) {
            return 0;
        }
        if (NullUtil.isNull((Object)s1.getShelvesType())) {
            return 1;
        }
        if (NullUtil.isNull((Object)s2.getShelvesType())) {
            return -1;
        }
        return s1.getShelvesType().compareTo(s2.getShelvesType());
    }

    private int compareShelvesSortOrder(WhWmsHouseShelves s1, WhWmsHouseShelves s2) {
        if (NullUtil.isNull((Object)s1.getSortOrder()) && NullUtil.isNull((Object)s1.getSortOrder())) {
            return 0;
        }
        if (NullUtil.isNull((Object)s1.getSortOrder())) {
            return 1;
        }
        if (NullUtil.isNull((Object)s1.getSortOrder())) {
            return -1;
        }
        return s1.getSortOrder().compareTo(s1.getSortOrder());
    }

    private int compareShelvesArea(WhWmsWarehouseArea a1, WhWmsWarehouseArea a2) {
        if (NullUtil.isNull((Object)a1.getSortOrder()) && NullUtil.isNull((Object)a2.getSortOrder())) {
            return 0;
        }
        if (NullUtil.isNull((Object)a1.getSortOrder())) {
            return 1;
        }
        if (NullUtil.isNull((Object)a2.getSortOrder())) {
            return -1;
        }
        return a1.getSortOrder().compareTo(a2.getSortOrder());
    }

    public int compareBarCode(WhWmsSkuBarcode barcode1, WhWmsSkuBarcode barcode2) {
        return this.whWmsSkuBarcodeService.compareBarCode(barcode1, barcode2);
    }

    private Map<String, Integer> computePlanedQuantityMap(List<WhWmsWaitOutStockVO> waitOutCommandList) {
        HashMap<String, Integer> skuPlanedQuantityMap = new HashMap<String, Integer>();
        for (WhWmsWaitOutStockVO waitOutStock : waitOutCommandList) {
            if (EmptyUtil.isEmpty(waitOutStock.getWhCommandSkuList())) continue;
            for (WhCommandSku commandSku : waitOutStock.getWhCommandSkuList()) {
                Integer quantity = (Integer)skuPlanedQuantityMap.get(commandSku.getSkuCode());
                if (NullUtil.isNull((Object)quantity)) {
                    quantity = 0;
                }
                if (!NullUtil.isNotNull((Object)commandSku.getPlanedQuantity())) continue;
                skuPlanedQuantityMap.put(commandSku.getSkuCode(), quantity + commandSku.getPlanedQuantity());
            }
        }
        return skuPlanedQuantityMap;
    }

    private List<List<WhCommandPickStockInfoVO>> filterGeMinCount(List<WhCommandPickStockInfoVO> commandPickStockInfoList, WhWmsConnectStartCountConfigVO countConfigVO) {
        ArrayList<List<WhCommandPickStockInfoVO>> groupList = new ArrayList<List<WhCommandPickStockInfoVO>>();
        Iterator<WhCommandPickStockInfoVO> iterator = commandPickStockInfoList.iterator();
        WhCommandPickStockInfoVO pickStockInfoVO = null;
        while (iterator.hasNext()) {
            ArrayList<WhCommandPickStockInfoVO> singleGroup;
            pickStockInfoVO = iterator.next();
            if (pickStockInfoVO.isAssemble()) continue;
            if (!NumberUtil.isNullOrZero((Number)countConfigVO.getSkuMinCount()) && countConfigVO.getSkuMinCount() <= pickStockInfoVO.getSkuAmount()) {
                singleGroup = new ArrayList<WhCommandPickStockInfoVO>();
                singleGroup.add(pickStockInfoVO);
                groupList.add(singleGroup);
                iterator.remove();
                continue;
            }
            if (NumberUtil.isNullOrZero((Number)countConfigVO.getSkuQanitlyMinCount()) || countConfigVO.getSkuQanitlyMinCount() > pickStockInfoVO.getSkuMaxQuantity()) continue;
            singleGroup = new ArrayList();
            singleGroup.add(pickStockInfoVO);
            groupList.add(singleGroup);
            iterator.remove();
        }
        return groupList;
    }

    private void groupPickStockInfoCommands(List<WhCommandPickStockInfoVO> commandPickStockInfoList, WhWmsConnectStartCountConfigVO countConfigVO) {
        int waitMultiProductSinglePieceCount;
        ArrayList groupList = new ArrayList();
        HashMap<String, ArrayList<WhCommandPickStockInfoVO>> singleProductSinglePieceMap = new HashMap<String, ArrayList<WhCommandPickStockInfoVO>>();
        ArrayList<WhCommandPickStockInfoVO> waitMultiProductMultiPieceList = new ArrayList<WhCommandPickStockInfoVO>();
        ArrayList<WhCommandPickStockInfoVO> multiProductSinglePieceList = new ArrayList<WhCommandPickStockInfoVO>();
        for (WhCommandPickStockInfoVO pickStockInfoVO : commandPickStockInfoList) {
            ArrayList<WhCommandPickStockInfoVO> singleGroup;
            if (!NumberUtil.isNullOrZero((Number)countConfigVO.getSkuMinCount()) && countConfigVO.getSkuMinCount() <= pickStockInfoVO.getSkuAmount()) {
                singleGroup = new ArrayList<WhCommandPickStockInfoVO>();
                singleGroup.add(pickStockInfoVO);
                groupList.add(singleGroup);
                continue;
            }
            if (!NumberUtil.isNullOrZero((Number)countConfigVO.getSkuQanitlyMinCount()) && countConfigVO.getSkuQanitlyMinCount() <= pickStockInfoVO.getSkuMaxQuantity()) {
                singleGroup = new ArrayList();
                singleGroup.add(pickStockInfoVO);
                groupList.add(singleGroup);
                continue;
            }
            if (!pickStockInfoVO.isNeedCard() && pickStockInfoVO.getSkuAmount() == 1) {
                ArrayList<WhCommandPickStockInfoVO> skuGroupList = (ArrayList<WhCommandPickStockInfoVO>)singleProductSinglePieceMap.get(pickStockInfoVO.getSingleSkuCode());
                if (EmptyUtil.isEmpty((List)skuGroupList)) {
                    skuGroupList = new ArrayList<WhCommandPickStockInfoVO>();
                    singleProductSinglePieceMap.put(pickStockInfoVO.getSingleSkuCode(), skuGroupList);
                }
                skuGroupList.add(pickStockInfoVO);
                if (skuGroupList.size() != countConfigVO.getSingleProductSinglePieceMaxCount().intValue()) continue;
                groupList.add(skuGroupList);
                skuGroupList = new ArrayList();
                singleProductSinglePieceMap.put(pickStockInfoVO.getSingleSkuCode(), skuGroupList);
                continue;
            }
            if (pickStockInfoVO.getSkuAmount() == 1) {
                multiProductSinglePieceList.add(pickStockInfoVO);
                continue;
            }
            if (pickStockInfoVO.getSkuAmount() <= 1) continue;
            waitMultiProductMultiPieceList.add(pickStockInfoVO);
            if (waitMultiProductMultiPieceList.size() != countConfigVO.getMultiProductMultiPieceMaxCount().intValue()) continue;
            groupList.add(waitMultiProductMultiPieceList);
            waitMultiProductMultiPieceList = new ArrayList();
        }
        for (Object waitingSingleProductSinglePieceList : singleProductSinglePieceMap.values()) {
            multiProductSinglePieceList.addAll((Collection<WhCommandPickStockInfoVO>)waitingSingleProductSinglePieceList);
        }
        HashMap<String, ArrayList<WhCommandPickStockInfoVO>> multiProductSinglePieceMap = new HashMap<String, ArrayList<WhCommandPickStockInfoVO>>();
        for (WhCommandPickStockInfoVO pickStockInfoVO : multiProductSinglePieceList) {
            ArrayList<WhCommandPickStockInfoVO> tmpGroupList = (ArrayList<WhCommandPickStockInfoVO>)multiProductSinglePieceMap.get(pickStockInfoVO.getSingleHouseType());
            if (NullUtil.isNull((Object)tmpGroupList)) {
                tmpGroupList = new ArrayList<WhCommandPickStockInfoVO>();
                multiProductSinglePieceMap.put(pickStockInfoVO.getSingleHouseType(), tmpGroupList);
            }
            tmpGroupList.add(pickStockInfoVO);
            if (tmpGroupList.size() != countConfigVO.getMultiProductSinglePieceMaxCount().intValue()) continue;
            groupList.add(tmpGroupList);
            tmpGroupList = new ArrayList();
            multiProductSinglePieceMap.put(pickStockInfoVO.getSingleHouseType(), tmpGroupList);
        }
        ArrayList<List<WhCommandPickStockInfoVO>> multiProductSinglePieceMultiAreaCanStarList = new ArrayList<List<WhCommandPickStockInfoVO>>();
        List<WhCommandPickStockInfoVO> multiProductSinglePieceMultiAreaWaitingList = new ArrayList<WhCommandPickStockInfoVO>();
        List<List<WhCommandPickStockInfoVO>> multiProductSinglePieceSortList = this.sortByHouseTypeDesc(multiProductSinglePieceMap.values());
        this.multiProductSinglePieceGroupByHouseType(multiProductSinglePieceSortList, countConfigVO.getMultiProductSinglePieceMaxCount(), multiProductSinglePieceMultiAreaCanStarList, multiProductSinglePieceMultiAreaWaitingList);
        if (EmptyUtil.isNotEmpty(waitMultiProductMultiPieceList)) {
            int avaliableSize;
            int needSize = countConfigVO.getMultiProductMultiPieceMaxCount() - waitMultiProductMultiPieceList.size();
            if (needSize >= (avaliableSize = multiProductSinglePieceMultiAreaWaitingList.size())) {
                waitMultiProductMultiPieceList.addAll(multiProductSinglePieceMultiAreaWaitingList);
                multiProductSinglePieceMultiAreaWaitingList.clear();
            } else {
                waitMultiProductMultiPieceList.addAll(multiProductSinglePieceMultiAreaWaitingList.subList(0, needSize));
                multiProductSinglePieceMultiAreaWaitingList = multiProductSinglePieceMultiAreaWaitingList.subList(needSize, avaliableSize);
            }
        }
        ArrayList<WhCommandPickStockInfoVO> waittingList = new ArrayList<WhCommandPickStockInfoVO>();
        int waitMultiProductMultiPieceCount = waitMultiProductMultiPieceList.size();
        if (waitMultiProductMultiPieceCount > 0 && waitMultiProductMultiPieceCount < countConfigVO.getMultiProductMultiPieceMaxCount()) {
            waittingList.addAll(waitMultiProductMultiPieceList);
        }
        if ((waitMultiProductSinglePieceCount = multiProductSinglePieceMultiAreaWaitingList.size()) > 0 && waitMultiProductSinglePieceCount < countConfigVO.getMultiProductMultiPieceMaxCount()) {
            waittingList.addAll(multiProductSinglePieceMultiAreaWaitingList);
        }
    }

    private void multiProductSinglePieceGroupByHouseType(List<List<WhCommandPickStockInfoVO>> sortList, int limit, List<List<WhCommandPickStockInfoVO>> canStartList, List<WhCommandPickStockInfoVO> waitList) {
        int size = sortList.size();
        int beforIndex = 0;
        int backIndex = size - 1;
        List<WhCommandPickStockInfoVO> beforeList = sortList.get(beforIndex);
        List<WhCommandPickStockInfoVO> backList = sortList.get(backIndex);
        while (beforIndex < backIndex) {
            int needSize = limit - beforeList.size();
            int avaliableSize = backList.size();
            if (avaliableSize >= needSize) {
                beforeList.addAll(backList.subList(0, needSize));
                canStartList.add(beforeList);
                backList = backList.subList(needSize, avaliableSize);
                beforeList = sortList.get(++beforIndex);
                continue;
            }
            beforeList.addAll(backList);
            sortList.remove(backIndex);
            backList = sortList.get(--backIndex);
        }
        if (EmptyUtil.isNotEmpty(beforeList)) {
            waitList.addAll(beforeList);
        }
    }

    private List<List<WhCommandPickStockInfoVO>> sortByHouseTypeDesc(Collection<List<WhCommandPickStockInfoVO>> collections) {
        ArrayList<List<WhCommandPickStockInfoVO>> list = new ArrayList<List<WhCommandPickStockInfoVO>>();
        for (List<WhCommandPickStockInfoVO> voList : collections) {
            if (voList.isEmpty()) continue;
            list.add(voList);
        }
        Collections.sort(list, new Comparator<List<WhCommandPickStockInfoVO>>(){

            @Override
            public int compare(List<WhCommandPickStockInfoVO> o1, List<WhCommandPickStockInfoVO> o2) {
                return o1.size() - o2.size();
            }
        });
        return list;
    }

    private Map<String, List<WhCommandPickStockInfoVO>> groupCommandByConnectStartShelvesAreaRule(List<WhCommandPickStockInfoVO> commandPickStockInfoList, WhWmsConnectStartRuleVO shelvesAreaRule) {
        HashMap<String, List<WhCommandPickStockInfoVO>> shelvesAreaGroupMap = new HashMap<String, List<WhCommandPickStockInfoVO>>();
        boolean shelvesAreaRuleExist = true;
        if (NullUtil.isNull((Object)shelvesAreaRule) || EmptyUtil.isEmpty(shelvesAreaRule.getDetails())) {
            shelvesAreaRuleExist = false;
        }
        HashSet<String> shelvesAreaSet = new HashSet<String>();
        for (WhWmsConnectStartRuleDetailVO shelvesArea : shelvesAreaRule.getDetails()) {
            shelvesAreaSet.add(shelvesArea.getValue());
        }
        for (WhCommandPickStockInfoVO pickStockInfoVO : commandPickStockInfoList) {
            List<WhCommandPickStockInfoVO> tmpList;
            if (!pickStockInfoVO.isEnough()) {
                ArrayList<WhCommandPickStockInfoVO> shortList = (ArrayList<WhCommandPickStockInfoVO>)shelvesAreaGroupMap.get(shortKey);
                if (NullUtil.isNull((Object)shortList)) {
                    shortList = new ArrayList<WhCommandPickStockInfoVO>();
                    shelvesAreaGroupMap.put(shortKey, shortList);
                }
                shortList.add(pickStockInfoVO);
                continue;
            }
            if (shelvesAreaRuleExist && shelvesAreaSet.containsAll(pickStockInfoVO.getPickHouseTypes())) {
                tmpList = (List)shelvesAreaGroupMap.get(shelvesAreaRuleKey);
                if (NullUtil.isNull((Object)tmpList)) {
                    tmpList = new ArrayList();
                    shelvesAreaGroupMap.put(shelvesAreaRuleKey, tmpList);
                }
                tmpList.add(pickStockInfoVO);
                continue;
            }
            tmpList = (ArrayList<WhCommandPickStockInfoVO>)shelvesAreaGroupMap.get(noShelvesAreaRuleKey);
            if (NullUtil.isNull((Object)tmpList)) {
                tmpList = new ArrayList<WhCommandPickStockInfoVO>();
                shelvesAreaGroupMap.put(noShelvesAreaRuleKey, tmpList);
            }
            tmpList.add(pickStockInfoVO);
        }
        return shelvesAreaGroupMap;
    }

    private Date getToday() {
        Date now = DateUtil.getNow();
        return DateUtil.dayStart((Date)now);
    }

    private class ReplenishTask
    implements Runnable {
        private String physicalWarehouseCode;
        private List<String> skuCodes;

        private ReplenishTask(String physicalWarehouseCode, List<String> skuCodes) {
            this.physicalWarehouseCode = physicalWarehouseCode;
            this.skuCodes = skuCodes;
        }

        @Override
        public void run() {
            if (EmptyUtil.isEmpty((String)this.physicalWarehouseCode) || EmptyUtil.isEmpty(this.skuCodes)) {
                return;
            }
            WhWmsReplenishInfoCond cond = new WhWmsReplenishInfoCond();
            cond.setPhysicalWarehouseCode(this.physicalWarehouseCode);
            cond.setSkuCodes(this.skuCodes);
            cond.setCreateUserId(1L);
            cond.setAutoReplenish(true);
            cond.setSourceConnectStart(true);
            try {
                String warnMsg = WhWmsConnectStartServiceImpl.this.whWmsReplenishRuleService.replenishInfoGenerateByCond(cond);
                this.sendMailAfterMakeReplenishFailed(warnMsg);
            }
            catch (BusinessException e) {
                this.sendMailAfterMakeReplenishFailed(e.getMessage());
            }
        }

        private void sendMailAfterMakeReplenishFailed(String warnMsg) {
            CommGlobalConfig commGlobalConfig;
            if (EmptyUtil.isNotEmpty((String)warnMsg) && EmptyUtil.isNotEmpty((Object)(commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("mail.sendMailAfterMakeReplenishFailed"))) && EmptyUtil.isNotEmpty((String)commGlobalConfig.getConfigValue())) {
                String[] msgArr = warnMsg.split("</br>");
                StringBuilder emailContent = new StringBuilder();
                for (String msg : msgArr) {
                    emailContent.append("<div>" + msg + "</div>");
                }
                EmailVO emailVO = new EmailVO();
                emailVO.setToAddressList(Arrays.asList(commGlobalConfig.getConfigValue().split(",")));
                emailVO.setSubject("\u6ce2\u6b21\u542f\u52a8\u7f3a\u8d27\uff0c\u751f\u6210\u8865\u8d27\u5355\u5931\u8d25");
                emailVO.setContent(emailContent.toString());
                EmailUtil.getInstance().send(emailVO);
            }
        }
    }
}

