/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.utils.BeanUtil;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectStartRuleAssignMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectStartRuleDetailMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectStartRuleMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartRule;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartRuleAssign;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartRuleAssignExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartRuleDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartRuleDetailExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartRuleExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectStartRuleService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartRuleAssignVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartRuleDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartRuleVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="WhWmsConnectStartRuleService")
public class WhWmsConnectStartRuleServiceImpl
implements WhWmsConnectStartRuleService {
    @Autowired
    private WhWmsConnectStartRuleMapper whWmsConnectStartRuleMapper;
    @Autowired
    private WhWmsConnectStartRuleDetailMapper whWmsConnectStartRuleDetailMapper;
    @Autowired
    private WhWmsConnectStartRuleAssignMapper whWmsConnectStartRuleAssignMapper;

    @Override
    public List<WhWmsConnectStartRuleVO> findConnectStartRule(String physicalWarehouseCode, Integer ruleType) {
        return this.findConnectStartRule(physicalWarehouseCode, ruleType, true);
    }

    @Override
    public List<WhWmsConnectStartRuleVO> findConnectStartRule(String physicalWarehouseCode, Integer ruleType, Boolean enableOrNot) {
        WhWmsConnectStartRuleExample ruleExample = new WhWmsConnectStartRuleExample();
        WhWmsConnectStartRuleExample.Criteria ruleCriteria = ruleExample.createCriteria();
        ruleCriteria.andPhysicalWarehouseCodeEqualTo(physicalWarehouseCode).andTypeEqualTo(ruleType);
        if (Boolean.TRUE.equals(enableOrNot)) {
            ruleCriteria.andEnableEqualTo(1);
        } else if (Boolean.FALSE.equals(enableOrNot)) {
            ruleCriteria.andEnableEqualTo(0);
        }
        List<WhWmsConnectStartRule> list = this.whWmsConnectStartRuleMapper.selectByExample(ruleExample);
        List ruleList = BeanUtil.buildListFrom(list, WhWmsConnectStartRuleVO.class);
        this.fullCascadeInfo(ruleList);
        return ruleList;
    }

    @Override
    public WhWmsConnectStartRuleVO findConnectStartRule(Long ruleId, boolean cascade) {
        WhWmsConnectStartRule rule = this.whWmsConnectStartRuleMapper.selectByPrimaryKey(ruleId);
        if (NullUtil.isNotNull((Object)rule) && cascade) {
            WhWmsConnectStartRuleVO ruleVO = (WhWmsConnectStartRuleVO)BeanUtil.buildFrom((Object)rule, WhWmsConnectStartRuleVO.class);
            this.fullCascadeInfo(Collections.singletonList(ruleVO));
            return ruleVO;
        }
        return null;
    }

    private void fullCascadeInfo(List<WhWmsConnectStartRuleVO> ruleList) {
        if (EmptyUtil.isNotEmpty(ruleList)) {
            ArrayList<Long> ruleIdList = new ArrayList<Long>();
            for (WhWmsConnectStartRuleVO ruleVO : ruleList) {
                ruleIdList.add(ruleVO.getId());
            }
            Map<Long, List<WhWmsConnectStartRuleDetailVO>> detailsMap = this.getDetailsMap(ruleIdList);
            Map<Long, List<WhWmsConnectStartRuleAssignVO>> assignedOperatersMap = this.getAssignedOperatersMap(ruleIdList);
            for (WhWmsConnectStartRuleVO ruleVO : ruleList) {
                ruleVO.setDetails(detailsMap.get(ruleVO.getId()));
                ruleVO.setAssignedOperaters(assignedOperatersMap.get(ruleVO.getId()));
            }
        }
    }

    @Override
    @Transactional
    public boolean saveConnectStartRule(WhWmsConnectStartRuleVO startRuleVO) {
        this.checkRuleName(startRuleVO);
        if (NullUtil.isNotNull((Object)startRuleVO.getId())) {
            return this.updateConnectStartRule(startRuleVO);
        }
        return this.addConnectStartRule(startRuleVO);
    }

    @Override
    @Transactional
    public boolean saveConnectStartRuleForChannel(WhWmsConnectStartRuleVO startRuleVO) {
        startRuleVO.setType(WhWmsConnectStartRuleVO.TYPE_CHANNEL);
        startRuleVO.setEnable(1);
        try {
            return this.saveConnectStartRule(startRuleVO);
        }
        catch (DuplicateKeyException e) {
            throw new WarehouseException("WH0001", "\u5b58\u5728\u6e20\u9053\u5df2\u7f16\u8f91");
        }
    }

    @Override
    @Transactional
    public boolean saveConnectStartRuleForShelvesArea(WhWmsConnectStartRuleVO shelvesAreaRuleVO) {
        List<WhWmsConnectStartRuleVO> list;
        shelvesAreaRuleVO.setType(WhWmsConnectStartRuleVO.TYPE_WAREHOUSE_AREA);
        shelvesAreaRuleVO.setEnable(1);
        if (NullUtil.isNull((Object)shelvesAreaRuleVO.getId()) && EmptyUtil.isNotEmpty(list = this.findConnectStartRule(shelvesAreaRuleVO.getPhysicalWarehouseCode(), WhWmsConnectStartRuleVO.TYPE_WAREHOUSE_AREA))) {
            throw new WarehouseException("WH0001", "\u5e93\u533a\u89c4\u5219\u53ea\u80fd\u6709\u4e00\u4e2a");
        }
        try {
            return this.saveConnectStartRule(shelvesAreaRuleVO);
        }
        catch (DuplicateKeyException e) {
            throw new WarehouseException("WH0001", "\u5b58\u5728\u5e93\u533a\u5df2\u7f16\u8f91");
        }
    }

    @Override
    @Transactional
    public boolean delConnectStartRule(Long startRuleId) {
        WhWmsConnectStartRule record = new WhWmsConnectStartRule();
        record.setId(startRuleId);
        record.setEnable(0);
        this.whWmsConnectStartRuleMapper.updateByPrimaryKeySelective(record);
        return true;
    }

    private void checkRuleName(WhWmsConnectStartRuleVO ruleVO) {
        WhWmsConnectStartRuleExample ruleExample = new WhWmsConnectStartRuleExample();
        WhWmsConnectStartRuleExample.Criteria criteria = ruleExample.createCriteria();
        if (NullUtil.isNotNull((Object)ruleVO.getId())) {
            criteria.andIdNotEqualTo(ruleVO.getId());
        }
        criteria.andTypeEqualTo(ruleVO.getType()).andNameEqualTo(ruleVO.getName()).andEnableEqualTo(1);
        int count = this.whWmsConnectStartRuleMapper.countByExample(ruleExample);
        if (count > 0) {
            throw new WarehouseException("WH0001", "\u89c4\u5219\u540d\u79f0\u91cd\u590d");
        }
        List<WhWmsConnectStartRuleVO> ruleList = this.findConnectStartRule(ruleVO.getPhysicalWarehouseCode(), ruleVO.getType());
        if (EmptyUtil.isNotEmpty(ruleList)) {
            ArrayList<String> otherDetails = new ArrayList<String>();
            for (WhWmsConnectStartRuleVO rule : ruleList) {
                if (rule.getId().equals(ruleVO.getId()) || !EmptyUtil.isNotEmpty(rule.getDetails())) continue;
                for (WhWmsConnectStartRuleDetailVO detail : rule.getDetails()) {
                    otherDetails.add(detail.getValue());
                }
            }
            if (EmptyUtil.isNotEmpty(ruleVO.getDetails())) {
                for (WhWmsConnectStartRuleDetailVO detail : ruleVO.getDetails()) {
                    if (!otherDetails.contains(detail.getValue())) continue;
                    if (WhWmsConnectStartRuleVO.TYPE_CHANNEL.equals(ruleVO.getType())) {
                        throw new WarehouseException("WH0001", String.format("[%s]\u6e20\u9053\u5df2\u7f16\u8f91", detail.getValue()));
                    }
                    throw new WarehouseException("WH0001", String.format("[%s]\u5e93\u533a\u5df2\u7f16\u8f91", detail.getValue()));
                }
            }
        }
    }

    private boolean addConnectStartRule(WhWmsConnectStartRuleVO startRuleVO) {
        this.whWmsConnectStartRuleMapper.insert(startRuleVO);
        if (EmptyUtil.isNotEmpty(startRuleVO.getDetails())) {
            for (WhWmsConnectStartRuleDetailVO detailVO : startRuleVO.getDetails()) {
                detailVO.setRuleId(startRuleVO.getId());
                detailVO.setPhysicalWarehouseCode(startRuleVO.getPhysicalWarehouseCode());
                this.whWmsConnectStartRuleDetailMapper.insert(detailVO);
            }
        }
        if (EmptyUtil.isNotEmpty(startRuleVO.getAssignedOperaters())) {
            for (WhWmsConnectStartRuleAssignVO assignVO : startRuleVO.getAssignedOperaters()) {
                assignVO.setRuleId(startRuleVO.getId());
                this.whWmsConnectStartRuleAssignMapper.insert(assignVO);
            }
        }
        return true;
    }

    private boolean updateConnectStartRule(WhWmsConnectStartRuleVO startRuleVO) {
        this.whWmsConnectStartRuleMapper.updateByPrimaryKey(startRuleVO);
        this.delConnectStartRuleDetail(startRuleVO.getId());
        if (EmptyUtil.isNotEmpty(startRuleVO.getDetails())) {
            for (WhWmsConnectStartRuleDetailVO detailVO : startRuleVO.getDetails()) {
                detailVO.setRuleId(startRuleVO.getId());
                detailVO.setPhysicalWarehouseCode(startRuleVO.getPhysicalWarehouseCode());
                this.whWmsConnectStartRuleDetailMapper.insert(detailVO);
            }
        }
        this.delConnectStartRuleAssignOperater(startRuleVO.getId());
        if (EmptyUtil.isNotEmpty(startRuleVO.getAssignedOperaters())) {
            for (WhWmsConnectStartRuleAssignVO assignVO : startRuleVO.getAssignedOperaters()) {
                assignVO.setRuleId(startRuleVO.getId());
                this.whWmsConnectStartRuleAssignMapper.insert(assignVO);
            }
        }
        return true;
    }

    private boolean delConnectStartRuleDetail(Long startRuleId) {
        WhWmsConnectStartRuleDetailExample detailExample = new WhWmsConnectStartRuleDetailExample();
        detailExample.createCriteria().andRuleIdEqualTo(startRuleId);
        this.whWmsConnectStartRuleDetailMapper.deleteByExample(detailExample);
        return true;
    }

    private boolean delConnectStartRuleAssignOperater(Long startRuleId) {
        WhWmsConnectStartRuleAssignExample assignExample = new WhWmsConnectStartRuleAssignExample();
        assignExample.createCriteria().andRuleIdEqualTo(startRuleId);
        this.whWmsConnectStartRuleAssignMapper.deleteByExample(assignExample);
        return true;
    }

    private Map<Long, List<WhWmsConnectStartRuleDetailVO>> getDetailsMap(List<Long> ruleIdList) {
        HashMap<Long, List<WhWmsConnectStartRuleDetailVO>> detailsMap = new HashMap<Long, List<WhWmsConnectStartRuleDetailVO>>();
        WhWmsConnectStartRuleDetailExample detailExample = new WhWmsConnectStartRuleDetailExample();
        detailExample.createCriteria().andRuleIdIn((List)ruleIdList);
        List<WhWmsConnectStartRuleDetail> detailList = this.whWmsConnectStartRuleDetailMapper.selectByExample(detailExample);
        if (EmptyUtil.isNotEmpty(detailList)) {
            for (WhWmsConnectStartRuleDetail detail : detailList) {
                ArrayList<Object> detailVOList = (ArrayList<Object>)detailsMap.get(detail.getRuleId());
                if (NullUtil.isNull((Object)detailVOList)) {
                    detailVOList = new ArrayList<Object>();
                    detailsMap.put(detail.getRuleId(), detailVOList);
                }
                detailVOList.add(BeanUtil.buildFrom((Object)detail, WhWmsConnectStartRuleDetailVO.class));
            }
        }
        return detailsMap;
    }

    private Map<Long, List<WhWmsConnectStartRuleAssignVO>> getAssignedOperatersMap(List<Long> ruleIdList) {
        HashMap<Long, List<WhWmsConnectStartRuleAssignVO>> map = new HashMap<Long, List<WhWmsConnectStartRuleAssignVO>>();
        WhWmsConnectStartRuleAssignExample example = new WhWmsConnectStartRuleAssignExample();
        example.createCriteria().andRuleIdIn((List)ruleIdList);
        List<WhWmsConnectStartRuleAssign> list = this.whWmsConnectStartRuleAssignMapper.selectByExample(example);
        List voList = BeanUtil.buildListFrom(list, WhWmsConnectStartRuleAssignVO.class);
        if (EmptyUtil.isNotEmpty((List)voList)) {
            for (WhWmsConnectStartRuleAssignVO vo : voList) {
                ArrayList<WhWmsConnectStartRuleAssignVO> tmpList = (ArrayList<WhWmsConnectStartRuleAssignVO>)map.get(vo.getRuleId());
                if (NullUtil.isNull((Object)tmpList)) {
                    tmpList = new ArrayList<WhWmsConnectStartRuleAssignVO>();
                    map.put(vo.getRuleId(), tmpList);
                }
                tmpList.add(vo);
            }
        }
        return map;
    }
}

