/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectStartForbideRuleDetailMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectStartForbideRuleMapper;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartForbideRule;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartForbideRuleDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartForbideRuleDetailExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartForbideRuleExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectStartForbideRuleService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartForbideRuleDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartForbideRuleVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whWmsConnectStartForbideRuleService")
public class WhWmsConnectStartForbideRuleServiceImpl
implements WhWmsConnectStartForbideRuleService {
    @Autowired
    private WhWmsConnectStartForbideRuleMapper whWmsConnectStartForbideRuleMapper;
    @Autowired
    private WhWmsConnectStartForbideRuleDetailMapper whWmsConnectStartForbideRuleDetailMapper;

    @Override
    public List<WhWmsConnectStartForbideRuleVO> findConnectStartForbideRule(String physicalWarehouseCode, boolean cascade) {
        WhWmsConnectStartForbideRuleExample example = new WhWmsConnectStartForbideRuleExample();
        example.createCriteria().andPhysicalWarehouseCodeEqualTo(physicalWarehouseCode);
        List<WhWmsConnectStartForbideRule> list = this.whWmsConnectStartForbideRuleMapper.selectByExample(example);
        List forbideRuleVOList = BeanUtil.buildListFrom(list, WhWmsConnectStartForbideRuleVO.class);
        if (cascade && EmptyUtil.isNotEmpty((List)forbideRuleVOList)) {
            ArrayList<Long> forbideRuleIdList = new ArrayList<Long>();
            for (WhWmsConnectStartForbideRuleVO forbideRuleVO : forbideRuleVOList) {
                forbideRuleIdList.add(forbideRuleVO.getId());
            }
            Map<Long, List<WhWmsConnectStartForbideRuleDetailVO>> detailsMap = this.getDetailsMap(forbideRuleIdList);
            for (WhWmsConnectStartForbideRuleVO forbideRuleVO : forbideRuleVOList) {
                forbideRuleVO.setDetails(detailsMap.get(forbideRuleVO.getId()));
            }
        }
        return forbideRuleVOList;
    }

    @Override
    public WhWmsConnectStartForbideRuleVO findConnectStartForbideRule(Long forbideRuleId, boolean cascade) {
        WhWmsConnectStartForbideRule forbideRule = this.whWmsConnectStartForbideRuleMapper.selectByPrimaryKey(forbideRuleId);
        WhWmsConnectStartForbideRuleVO forbideRuleVO = (WhWmsConnectStartForbideRuleVO)BeanUtil.buildFrom((Object)forbideRule, WhWmsConnectStartForbideRuleVO.class);
        if (NullUtil.isNotNull((Object)forbideRuleVO) && cascade) {
            Map<Long, List<WhWmsConnectStartForbideRuleDetailVO>> detailsMap = this.getDetailsMap(Collections.singletonList(forbideRuleVO.getId()));
            forbideRuleVO.setDetails(detailsMap.get(forbideRuleVO.getId()));
        }
        return forbideRuleVO;
    }

    @Override
    @Transactional
    public boolean saveConnectStartForbideRule(WhWmsConnectStartForbideRuleVO forbideRuleVO) {
        if (NullUtil.isNull((Object)forbideRuleVO.getId())) {
            return this.addConnectStartForbideRule(forbideRuleVO);
        }
        return this.updateConnectStartForbideRule(forbideRuleVO);
    }

    @Override
    @Transactional
    public boolean enableDisableConnectStartForbideRule(Long forbideRuleId, Integer enableOrDisable) {
        WhWmsConnectStartForbideRule update = new WhWmsConnectStartForbideRule();
        update.setId(forbideRuleId);
        update.setEnable(enableOrDisable);
        this.whWmsConnectStartForbideRuleMapper.updateByPrimaryKeySelective(update);
        return true;
    }

    @Override
    @Transactional
    public void disableExpireConnectStartForbideRule() {
        this.whWmsConnectStartForbideRuleMapper.disableExpireConnectStartForbideRule();
    }

    private boolean addConnectStartForbideRule(WhWmsConnectStartForbideRuleVO forbideRuleVO) {
        this.whWmsConnectStartForbideRuleMapper.insert(forbideRuleVO);
        if (EmptyUtil.isNotEmpty(forbideRuleVO.getDetails())) {
            for (WhWmsConnectStartForbideRuleDetailVO detailVO : forbideRuleVO.getDetails()) {
                detailVO.setForbideRuleId(forbideRuleVO.getId());
                this.whWmsConnectStartForbideRuleDetailMapper.insert(detailVO);
            }
        }
        return true;
    }

    private boolean updateConnectStartForbideRule(WhWmsConnectStartForbideRuleVO forbideRuleVO) {
        this.whWmsConnectStartForbideRuleMapper.updateByPrimaryKey(forbideRuleVO);
        this.delConnectStartForbideRuleDetail(forbideRuleVO.getId());
        if (EmptyUtil.isNotEmpty(forbideRuleVO.getDetails())) {
            for (WhWmsConnectStartForbideRuleDetailVO detailVO : forbideRuleVO.getDetails()) {
                detailVO.setForbideRuleId(forbideRuleVO.getId());
                this.whWmsConnectStartForbideRuleDetailMapper.insert(detailVO);
            }
        }
        return true;
    }

    private boolean delConnectStartForbideRuleDetail(Long forbideRuleId) {
        WhWmsConnectStartForbideRuleDetailExample example = new WhWmsConnectStartForbideRuleDetailExample();
        example.createCriteria().andForbideRuleIdEqualTo(forbideRuleId);
        this.whWmsConnectStartForbideRuleDetailMapper.deleteByExample(example);
        return true;
    }

    private Map<Long, List<WhWmsConnectStartForbideRuleDetailVO>> getDetailsMap(List<Long> forbideRuleIdList) {
        HashMap<Long, List<WhWmsConnectStartForbideRuleDetailVO>> map = new HashMap<Long, List<WhWmsConnectStartForbideRuleDetailVO>>();
        WhWmsConnectStartForbideRuleDetailExample example = new WhWmsConnectStartForbideRuleDetailExample();
        example.createCriteria().andForbideRuleIdIn((List)forbideRuleIdList);
        List<WhWmsConnectStartForbideRuleDetail> list = this.whWmsConnectStartForbideRuleDetailMapper.selectByExample(example);
        if (EmptyUtil.isNotEmpty(list)) {
            List detailVOList = BeanUtil.buildListFrom(list, WhWmsConnectStartForbideRuleDetailVO.class);
            for (WhWmsConnectStartForbideRuleDetailVO detailVO : detailVOList) {
                ArrayList<WhWmsConnectStartForbideRuleDetailVO> tmpList = (ArrayList<WhWmsConnectStartForbideRuleDetailVO>)map.get(detailVO.getForbideRuleId());
                if (NullUtil.isNull((Object)tmpList)) {
                    tmpList = new ArrayList<WhWmsConnectStartForbideRuleDetailVO>();
                    map.put(detailVO.getForbideRuleId(), tmpList);
                }
                tmpList.add(detailVO);
            }
        }
        return map;
    }
}

