/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectStartDurationMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartDuration;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartDurationExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectStartDurationService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartDurationVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whWmsConnectStartDurationService")
public class WhWmsConnectStartDurationServiceImpl
implements WhWmsConnectStartDurationService {
    @Autowired
    private WhWmsConnectStartDurationMapper whWmsConnectStartDurationMapper;

    @Override
    public List<WhWmsConnectStartDurationVO> findConnectStartDuration(String physicalWarehouseCode) {
        WhWmsConnectStartDurationExample durationExample = new WhWmsConnectStartDurationExample();
        durationExample.createCriteria().andPhysicalWarehouseCodeEqualTo(physicalWarehouseCode);
        durationExample.setOrderByClause(" BEGIN_TIME asc");
        List<WhWmsConnectStartDuration> list = this.whWmsConnectStartDurationMapper.selectByExample(durationExample);
        return BeanUtil.buildListFrom(list, WhWmsConnectStartDurationVO.class);
    }

    @Override
    public WhWmsConnectStartDurationVO findConnectStartDuration(Long startDurationId) {
        WhWmsConnectStartDuration duration = this.whWmsConnectStartDurationMapper.selectByPrimaryKey(startDurationId);
        return (WhWmsConnectStartDurationVO)BeanUtil.buildFrom((Object)duration, WhWmsConnectStartDurationVO.class);
    }

    @Override
    @Transactional
    public boolean saveConnectStartDuration(WhWmsConnectStartDurationVO startDurationVO) {
        this.checkTime(startDurationVO);
        if (NullUtil.isNull((Object)startDurationVO.getId())) {
            startDurationVO.setEnable(1);
            return this.addConnectStartDuration(startDurationVO);
        }
        WhWmsConnectStartDurationVO old = this.findConnectStartDuration(startDurationVO.getId());
        startDurationVO.setEnable(old.getEnable());
        return this.updateConnectStartDuration(startDurationVO);
    }

    private boolean addConnectStartDuration(WhWmsConnectStartDurationVO startDurationVO) {
        this.whWmsConnectStartDurationMapper.insert(startDurationVO);
        return true;
    }

    private boolean updateConnectStartDuration(WhWmsConnectStartDurationVO startDurationVO) {
        this.whWmsConnectStartDurationMapper.updateByPrimaryKey(startDurationVO);
        return true;
    }

    @Override
    @Transactional
    public boolean delConnectStartDuration(Long startDurationId) {
        boolean success;
        boolean bl = success = this.whWmsConnectStartDurationMapper.deleteByPrimaryKey(startDurationId) == 1;
        if (!success) {
            throw new WarehouseException("WH0001", "\u5df2\u5220\u9664");
        }
        return success;
    }

    private void checkTime(WhWmsConnectStartDurationVO startDurationVO) {
        Date endDateTime;
        List<WhWmsConnectStartDurationVO> list = this.findConnectStartDuration(startDurationVO.getPhysicalWarehouseCode());
        Date beginDateTime = this.getDateTime(startDurationVO.getBeginTime());
        if (beginDateTime.compareTo(endDateTime = this.getDateTime(startDurationVO.getEndTime())) > 0) {
            throw new WarehouseException("WH0001", "\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65f6\u95f4");
        }
        if (EmptyUtil.isNotEmpty(list)) {
            Date beginTime2 = null;
            Date endTime2 = null;
            for (WhWmsConnectStartDurationVO item : list) {
                if (item.getId().equals(startDurationVO.getId())) continue;
                beginTime2 = this.getDateTime(item.getBeginTime());
                endTime2 = this.getDateTime(item.getEndTime());
                if (beginDateTime.compareTo(endTime2) > 0 || endDateTime.compareTo(beginTime2) < 0) continue;
                throw new WarehouseException("WH0001", String.format("\u5df2\u5b58\u5728[%s~%s]\u7684\u89c4\u5219\u4e2d\u5305\u542b\u91cd\u590d\u7684\u65f6\u95f4\u6bb5", DateUtil.format((Date)beginTime2, (String)"HH:mm:ss"), DateUtil.format((Date)endTime2, (String)"HH:mm:ss")));
            }
        }
    }

    private Date getDateTime(Date date) {
        return DateUtil.parse((String)DateUtil.format((Date)date, (String)"HH:mm:ss"), (String)"HH:mm:ss");
    }
}

