/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectStartConfigMapper;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartConfig;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartConfigExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectStartConfigService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartConfigVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartCountConfigVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartRuleConfigVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whWmsConnectStartConfigService")
public class WhWmsConnectStartConfigServiceImpl
implements WhWmsConnectStartConfigService {
    @Autowired
    private WhWmsConnectStartConfigMapper whWmsConnectStartConfigMapper;

    @Override
    public List<WhWmsConnectStartCountConfigVO> findAllConnectStartCountConfig() {
        List<WhWmsConnectStartConfigVO> countConfigList = this.findConnectStartConfig(WhWmsConnectStartConfigVO.TYPE_CONNECT_START_COUNT);
        if (EmptyUtil.isEmpty(countConfigList)) {
            return Collections.emptyList();
        }
        ArrayList<WhWmsConnectStartCountConfigVO> voList = new ArrayList<WhWmsConnectStartCountConfigVO>();
        for (WhWmsConnectStartConfigVO countConfig : countConfigList) {
            JSONObject json = JSON.parseObject((String)countConfig.getValue());
            WhWmsConnectStartCountConfigVO vo = (WhWmsConnectStartCountConfigVO)JSONObject.toJavaObject((JSON)json, WhWmsConnectStartCountConfigVO.class);
            vo.setId(countConfig.getId());
            voList.add(vo);
        }
        return voList;
    }

    @Override
    public WhWmsConnectStartCountConfigVO findConnectStartCountConfig(String physicalWarehouseCode) {
        WhWmsConnectStartConfigVO configVO = this.findConnectStartConfig(physicalWarehouseCode, WhWmsConnectStartConfigVO.TYPE_CONNECT_START_COUNT);
        if (NullUtil.isNull((Object)configVO)) {
            return null;
        }
        if (EmptyUtil.isNotEmpty((String)configVO.getValue())) {
            JSONObject json = JSON.parseObject((String)configVO.getValue());
            WhWmsConnectStartCountConfigVO countConfigVO = (WhWmsConnectStartCountConfigVO)JSONObject.toJavaObject((JSON)json, WhWmsConnectStartCountConfigVO.class);
            countConfigVO.setId(configVO.getId());
            return countConfigVO;
        }
        WhWmsConnectStartCountConfigVO countConfigVO = new WhWmsConnectStartCountConfigVO();
        countConfigVO.setId(configVO.getId());
        return countConfigVO;
    }

    @Override
    @Transactional
    public boolean saveConnectStartCountConfig(WhWmsConnectStartCountConfigVO countConfigVO) {
        WhWmsConnectStartConfigVO configVO = (WhWmsConnectStartConfigVO)BeanUtil.buildFrom((Object)countConfigVO, WhWmsConnectStartConfigVO.class);
        configVO.setValue(JSONObject.toJSONString((Object)countConfigVO));
        configVO.setType(WhWmsConnectStartConfigVO.TYPE_CONNECT_START_COUNT);
        return this.saveConnectStartConfig(configVO);
    }

    @Override
    public WhWmsConnectStartRuleConfigVO findConnectStartRuleConfig(String physicalWarehouseCode) {
        WhWmsConnectStartConfigVO configVO = this.findConnectStartConfig(physicalWarehouseCode, WhWmsConnectStartConfigVO.TYPE_CONNECT_START_SETTING);
        if (NullUtil.isNull((Object)configVO)) {
            return null;
        }
        if (EmptyUtil.isNotEmpty((String)configVO.getValue())) {
            JSONObject json = JSON.parseObject((String)configVO.getValue());
            WhWmsConnectStartRuleConfigVO ruleConfigVO = (WhWmsConnectStartRuleConfigVO)JSONObject.toJavaObject((JSON)json, WhWmsConnectStartRuleConfigVO.class);
            ruleConfigVO.setId(configVO.getId());
            return ruleConfigVO;
        }
        WhWmsConnectStartRuleConfigVO ruleConfigVO = new WhWmsConnectStartRuleConfigVO();
        ruleConfigVO.setId(configVO.getId());
        return ruleConfigVO;
    }

    @Override
    public List<WhWmsConnectStartRuleConfigVO> findAllConnectStartRuleConfig() {
        List<WhWmsConnectStartConfigVO> startRuleConfigList = this.findConnectStartConfig(WhWmsConnectStartConfigVO.TYPE_CONNECT_START_SETTING);
        if (EmptyUtil.isEmpty(startRuleConfigList)) {
            return Collections.emptyList();
        }
        ArrayList<WhWmsConnectStartRuleConfigVO> voList = new ArrayList<WhWmsConnectStartRuleConfigVO>();
        for (WhWmsConnectStartConfigVO startRuleConfig : startRuleConfigList) {
            JSONObject json = JSON.parseObject((String)startRuleConfig.getValue());
            WhWmsConnectStartRuleConfigVO vo = (WhWmsConnectStartRuleConfigVO)JSONObject.toJavaObject((JSON)json, WhWmsConnectStartRuleConfigVO.class);
            vo.setId(startRuleConfig.getId());
            voList.add(vo);
        }
        return voList;
    }

    @Override
    @Transactional
    public boolean saveConnectStartRuleConfig(WhWmsConnectStartRuleConfigVO ruleConfigVO) {
        WhWmsConnectStartConfigVO configVO = (WhWmsConnectStartConfigVO)BeanUtil.buildFrom((Object)ruleConfigVO, WhWmsConnectStartConfigVO.class);
        configVO.setValue(JSONObject.toJSONString((Object)ruleConfigVO));
        configVO.setType(WhWmsConnectStartConfigVO.TYPE_CONNECT_START_SETTING);
        return this.saveConnectStartConfig(configVO);
    }

    private boolean saveConnectStartConfig(WhWmsConnectStartConfigVO configVO) {
        if (NullUtil.isNull((Object)configVO.getId())) {
            this.whWmsConnectStartConfigMapper.insert(configVO);
        } else {
            this.whWmsConnectStartConfigMapper.updateByPrimaryKey(configVO);
        }
        return true;
    }

    private List<WhWmsConnectStartConfigVO> findConnectStartConfig(Integer configType) {
        WhWmsConnectStartConfigExample example = new WhWmsConnectStartConfigExample();
        example.createCriteria().andTypeEqualTo(configType);
        List<WhWmsConnectStartConfig> list = this.whWmsConnectStartConfigMapper.selectByExample(example);
        if (EmptyUtil.isNotEmpty(list)) {
            return BeanUtil.buildListFrom(list, WhWmsConnectStartConfigVO.class);
        }
        return Collections.emptyList();
    }

    private WhWmsConnectStartConfigVO findConnectStartConfig(String physicalWarehouseCode, Integer configType) {
        WhWmsConnectStartConfigExample example = new WhWmsConnectStartConfigExample();
        example.createCriteria().andPhysicalWarehouseCodeEqualTo(physicalWarehouseCode).andTypeEqualTo(configType);
        List<WhWmsConnectStartConfig> list = this.whWmsConnectStartConfigMapper.selectByExample(example);
        if (EmptyUtil.isNotEmpty(list)) {
            return (WhWmsConnectStartConfigVO)BeanUtil.buildFrom((Object)list.get(0), WhWmsConnectStartConfigVO.class);
        }
        return null;
    }
}

