/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsConnectPickSkuCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhCommandMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsCommandCheckMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectDistributionMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectPickSkuMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectTurnoverBoxMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsHouseShelvesMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandOutFinish;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectDistribution;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectDistributionExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectPickSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectPickSkuExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectTurnoverBox;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectTurnoverBoxExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsHouseShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsOutStockRecord;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStock;
import com.thebeastshop.pegasus.service.warehouse.service.WhAllotService;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandConnectService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectPickSkuService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsOccupyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsOperationRcdService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsOutStockRecordService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsTaskAssignService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCountVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandConnectVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectAllotPackageVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectPickSkuSubmitDataVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectPickSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsOutStockRecordVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whWmsConnectPickSkuService")
public class WhWmsConnectPickSkuServiceImpl
implements WhWmsConnectPickSkuService {
    private static final Logger log = LoggerFactory.getLogger(WhWmsConnectPickSkuServiceImpl.class);
    @Autowired
    private WhWmsConnectPickSkuMapper mapper;
    @Autowired
    private WhWmsConnectTurnoverBoxMapper boxMapper;
    @Autowired
    private WhWmsConnectInfoService whWmsConnectInfoService;
    @Autowired
    private WhWmsCommandConnectService whWmsCommandConnectService;
    @Autowired
    private WhWmsOccupyService whWmsOccupyService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhAllotService whAllotService;
    @Autowired
    private WhWmsHouseShelvesMapper whWmsHouseShelvesMapper;
    @Autowired
    private WhCommandMapper whCommandMapper;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhWmsCommandCheckMapper whWmsCommandCheckMapper;
    @Autowired
    private WhWmsTaskAssignService whWmsTaskAssignService;
    @Autowired
    private WhWmsOperationRcdService whWmsOperationRcdService;
    @Autowired
    private WhWmsConnectDistributionMapper whWmsConnectDistributionMapper;
    @Autowired
    private WhWmsOutStockRecordService whWmsOutStockRecordService;

    @Override
    public WhWmsConnectPickSkuVO create(WhWmsConnectPickSkuVO vo) {
        this.validateBeforeCreate(vo);
        WhWmsConnectPickSku whWmsConnectPickSku = (WhWmsConnectPickSku)BeanUtil.buildFrom((Object)vo, WhWmsConnectPickSku.class);
        whWmsConnectPickSku.setStatus(WhWmsConnectPickSkuVO.STATUS_PENDING);
        this.mapper.insert(whWmsConnectPickSku);
        vo.setId(whWmsConnectPickSku.getId());
        return vo;
    }

    @Override
    @Transactional
    public boolean batchCreate(List<WhWmsConnectPickSkuVO> voList) {
        if (EmptyUtil.isNotEmpty(voList)) {
            for (WhWmsConnectPickSkuVO vo : voList) {
                vo.setStatus(WhWmsConnectPickSkuVO.STATUS_PENDING);
            }
            return this.mapper.batchInsert(voList) == voList.size();
        }
        return false;
    }

    @Override
    public boolean cancelConnectPickSku(List<Long> connectIds) {
        if (EmptyUtil.isEmpty(connectIds)) {
            return false;
        }
        List<WhWmsConnectPickSkuVO> pickSkuList = this.findByConnectIds(connectIds);
        if (EmptyUtil.isEmpty(pickSkuList)) {
            return false;
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        for (WhWmsConnectPickSkuVO pickSku : pickSkuList) {
            idList.add(pickSku.getId());
        }
        int count = this.mapper.batchCancel(idList);
        return count == idList.size();
    }

    @Override
    public Boolean update(WhWmsConnectPickSkuVO vo) {
        boolean success;
        boolean bl = success = this.mapper.connectPickskuFinishById(vo) == 1;
        if (!success) {
            throw new WarehouseException("WH0001", "\u5df2\u5b8c\u6210\u6216\u5df2\u53d6\u6d88\u4efb\u52a1\u4e0d\u53ef\u64cd\u4f5c[" + vo.getId() + "]");
        }
        return true;
    }

    @Override
    public void updateWhWmsConnectPickSkuByKey(WhWmsConnectPickSku vo) {
        this.mapper.updateByPrimaryKeySelective(vo);
    }

    private void updatePickSkuList(WhWmsConnectInfoVO connectVO, List<WhWmsConnectPickSkuVO> pickSkuVOList, Long operatorId, List<WhWmsConnectPickSkuVO> connectPickSkuVOs) {
        if (EmptyUtil.isEmpty(connectPickSkuVOs) || EmptyUtil.isEmpty(pickSkuVOList)) {
            return;
        }
        HashMap<Long, WhWmsConnectPickSkuVO> connectPickSkuVOMap = new HashMap<Long, WhWmsConnectPickSkuVO>();
        boolean isStart = true;
        for (WhWmsConnectPickSkuVO whWmsConnectPickSkuVO : connectPickSkuVOs) {
            connectPickSkuVOMap.put(whWmsConnectPickSkuVO.getId(), whWmsConnectPickSkuVO);
            if (whWmsConnectPickSkuVO.getStatus() != 1) continue;
            isStart = false;
        }
        if (isStart) {
            WhWmsOutStockRecord whWmsOutStockRecord = new WhWmsOutStockRecord();
            whWmsOutStockRecord.setInOutType(connectVO.getInOutType());
            whWmsOutStockRecord.setConnectId(connectVO.getId().intValue());
            whWmsOutStockRecord.setOptType(3);
            whWmsOutStockRecord.setOperatorId(operatorId.intValue());
            whWmsOutStockRecord.setOperatorTime(Calendar.getInstance().getTime());
            whWmsOutStockRecord.setDisposeType(1);
            whWmsOutStockRecord.setCreateTime(Calendar.getInstance().getTime());
            whWmsOutStockRecord.setOptDesc(WhWmsOutStockRecordVO.OptTypeDescEnum.PICKING_START.getOptDesc());
            this.whWmsOutStockRecordService.createWhWmsOutStockRecord(whWmsOutStockRecord);
        }
        for (WhWmsConnectPickSkuVO whWmsConnectPickSkuVO : pickSkuVOList) {
            WhWmsConnectPickSkuVO connectPickSkuVO = (WhWmsConnectPickSkuVO)connectPickSkuVOMap.get(whWmsConnectPickSkuVO.getId());
            if (connectPickSkuVO != null) {
                if (WhWmsConnectPickSkuVO.STATUS_FINISH.equals(connectPickSkuVO.getStatus())) {
                    throw new WarehouseException("WH0001", "\u4efb\u52a1\u5df2\u5b8c\u6210[" + connectPickSkuVO.getId() + "]");
                }
                if ("receive_waste".equals(connectVO.getConnectType()) && !connectPickSkuVO.getNeedAmount().equals(whWmsConnectPickSkuVO.getActualAmount())) {
                    throw new WarehouseException("WH0001", "\u62a5\u5e9f\u51fa\u5e93\u6570\u91cf\u5fc5\u987b\u548c\u9700\u62e3\u8d27\u6570\u636e\u4e00\u81f4");
                }
                connectPickSkuVO.setStatus(WhWmsConnectPickSkuVO.STATUS_FINISH);
                connectPickSkuVO.setActualAmount(whWmsConnectPickSkuVO.getActualAmount());
                WhWmsOutStockRecord whWmsOutStockRecord = new WhWmsOutStockRecord();
                whWmsOutStockRecord.setInOutType(connectVO.getInOutType());
                whWmsOutStockRecord.setConnectId(connectVO.getId().intValue());
                whWmsOutStockRecord.setOptType(8);
                whWmsOutStockRecord.setOptDesc(WhWmsOutStockRecordVO.OptTypeDescEnum.PICKING_DETAIL.getOptDesc());
                whWmsOutStockRecord.setRecordType(10);
                whWmsOutStockRecord.setOperatorTime(DateUtil.getNow());
                whWmsOutStockRecord.setShelvesCode(connectPickSkuVO.getShelvesCode());
                whWmsOutStockRecord.setSkuCode(connectPickSkuVO.getSkuCode());
                whWmsOutStockRecord.setQuantity(connectPickSkuVO.getActualAmount());
                whWmsOutStockRecord.setOperatorId(operatorId.intValue());
                whWmsOutStockRecord.setCreateTime(Calendar.getInstance().getTime());
                whWmsOutStockRecord.setRefDesc("WhWmsPickSku");
                this.whWmsOutStockRecordService.createWhWmsOutStockRecord(whWmsOutStockRecord);
                this.update(connectPickSkuVO);
                continue;
            }
            throw new WarehouseException("WH0001", "\u627e\u4e0d\u5230\u62e3\u8d27\u6570\u636e");
        }
    }

    @Override
    public boolean isConnectPickSkuFinish(List<WhWmsConnectPickSkuVO> connectPickSkuVOs) {
        if (EmptyUtil.isEmpty(connectPickSkuVOs)) {
            return true;
        }
        for (WhWmsConnectPickSkuVO pickSkuVO : connectPickSkuVOs) {
            if (WhWmsConnectPickSkuVO.STATUS_FINISH.equals(pickSkuVO.getStatus())) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<WhCountVO> countConnectPickSku(Long operatorId, String physicalWarehouseCode) {
        return this.mapper.countConnectPickSku(operatorId, physicalWarehouseCode);
    }

    @Override
    public void autoProcessShelvesStatus() {
        List<WhWmsHouseShelves> WaitNoUseList;
        List<WhWmsHouseShelves> waitUseList = this.whWmsHouseShelvesMapper.findShelvesStatusWaitUse();
        if (waitUseList != null && waitUseList.size() > 0) {
            for (WhWmsHouseShelves whWmsHouseShelves : waitUseList) {
                whWmsHouseShelves.setShelvesStatus(1);
                this.whWmsHouseShelvesMapper.updateByPrimaryKeySelective(whWmsHouseShelves);
            }
        }
        if ((WaitNoUseList = this.whWmsHouseShelvesMapper.findShelvesStatusWaitNoUse()) != null && WaitNoUseList.size() > 0) {
            for (WhWmsHouseShelves whWmsHouseShelves : WaitNoUseList) {
                whWmsHouseShelves.setShelvesStatus(0);
                this.whWmsHouseShelvesMapper.updateByPrimaryKeySelective(whWmsHouseShelves);
            }
        }
    }

    @Override
    public WhWmsConnectPickSkuVO findById(Long id) {
        WhWmsConnectPickSku whWmsConnectPickSku = this.mapper.selectByPrimaryKey(id);
        if (whWmsConnectPickSku != null) {
            return (WhWmsConnectPickSkuVO)BeanUtil.buildFrom((Object)whWmsConnectPickSku, WhWmsConnectPickSkuVO.class);
        }
        return null;
    }

    @Override
    public List<WhWmsConnectPickSkuVO> findByCond(WhWmsConnectPickSkuCond cond) {
        WhWmsConnectPickSkuExample example = new WhWmsConnectPickSkuExample();
        WhWmsConnectPickSkuExample.Criteria criteria = example.createCriteria();
        if (!NumberUtil.isNullOrZero((Number)cond.getConnectId())) {
            criteria.andConnectIdEqualTo(cond.getConnectId());
        }
        if (EmptyUtil.isNotEmpty(cond.getConnectIds())) {
            criteria.andConnectIdIn((List)cond.getConnectIds());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getBarCode())) {
            criteria.andBarCodeEqualTo(cond.getBarCode());
        }
        example.setOrderByClause(" ID ASC ");
        List<WhWmsConnectPickSku> whWmsConnectPickSkus = this.mapper.selectByExample(example);
        if (CollectionUtils.isEmpty(whWmsConnectPickSkus)) {
            return Collections.emptyList();
        }
        ArrayList<WhWmsConnectPickSkuVO> vos = new ArrayList<WhWmsConnectPickSkuVO>(whWmsConnectPickSkus.size());
        for (WhWmsConnectPickSku whWmsConnectPickSku : whWmsConnectPickSkus) {
            vos.add((WhWmsConnectPickSkuVO)BeanUtil.buildFrom((Object)whWmsConnectPickSku, WhWmsConnectPickSkuVO.class));
        }
        return vos;
    }

    @Override
    public List<WhWmsConnectPickSkuVO> findByConnectId(Long connectId) {
        WhWmsConnectPickSkuCond cond = new WhWmsConnectPickSkuCond();
        cond.setConnectId(connectId);
        return this.findByCond(cond);
    }

    @Override
    public List<WhWmsConnectPickSkuVO> findConnectPickSkuByCond(WhWmsConnectPickSkuCond cond) {
        return this.findByCond(cond);
    }

    @Override
    public List<WhWmsConnectPickSkuVO> findByConnectIds(List<Long> connectIds) {
        WhWmsConnectPickSkuCond cond = new WhWmsConnectPickSkuCond();
        cond.setConnectIds(connectIds);
        return this.findByCond(cond);
    }

    @Override
    public List<WhWmsConnectPickSkuVO> findListConnectPickSku(List<Long> connectIds) {
        return this.mapper.findListConnectPickSku(connectIds);
    }

    @Override
    public boolean preSubmitConnectPickSku(WhWmsConnectInfoVO connectVO, List<WhWmsConnectPickSkuVO> pickSkuVOList, Long operatorId, WhCommand cmd, List<WhWmsCommandConnectVO> commandConnects) throws Exception {
        if (EmptyUtil.isNotEmpty(pickSkuVOList)) {
            WhWmsConnectTurnoverBox condBox = new WhWmsConnectTurnoverBox();
            condBox.setConnectId(connectVO.getId());
            List<WhWmsConnectTurnoverBox> boxList = this.findBoxByCond(condBox);
            if (CollectionUtils.isEmpty(boxList)) {
                throw new WarehouseException("WH0001", "\u6ce2\u6b21\u6ca1\u6709\u7ed1\u5b9a\u4efb\u4f55\u4e00\u4e2a\u62e3\u8d27\u5468\u8f6c\u7bb1");
            }
        }
        List<WhWmsConnectPickSkuVO> connectPickSkuVOs = this.findByConnectId(connectVO.getId());
        this.updatePickSkuList(connectVO, pickSkuVOList, operatorId, connectPickSkuVOs);
        if (!this.isConnectPickSkuFinish(connectPickSkuVOs)) {
            return true;
        }
        this.whWmsOperationRcdService.insertRcdByConnectId(connectVO.getId(), operatorId);
        pickSkuVOList.clear();
        for (WhWmsConnectPickSkuVO whWmsConnectPickSkuVO : connectPickSkuVOs) {
            pickSkuVOList.add(whWmsConnectPickSkuVO);
        }
        List<WhWmsCommandConnectVO> whWmsCommandConnectVOList = this.whWmsCommandConnectService.findNotCanceledByConnectId(connectVO.getId());
        for (WhWmsCommandConnectVO vo : whWmsCommandConnectVOList) {
            commandConnects.add(vo);
        }
        WhCommand whCommand = this.whCommandService.findCommandByCode(commandConnects.get(0).getCommandCode(), false);
        BeanUtils.copyProperties((Object)whCommand, (Object)cmd);
        return false;
    }

    @Override
    public WhWmsConnectPickSkuSubmitDataVO checkSubmitConnectPickSku(WhWmsConnectInfoVO connectVO, List<WhWmsConnectPickSkuVO> pickSkuVOList, Long operatorId, WhCommand cmd, List<WhWmsCommandConnectVO> commandConnects) throws Exception {
        WhWmsConnectPickSkuSubmitDataVO returnVo = new WhWmsConnectPickSkuSubmitDataVO();
        returnVo.setConnectVO(connectVO);
        WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
        whWmsHouseShelvesCond.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
        Integer newCommandStatus = null;
        if ("multi_product_multi_piece".equals(connectVO.getConnectType())) {
            connectVO.setConnectStatus(WMSConstants.ConnectStatus.DISTRIBUTION);
            newCommandStatus = WhCommand.STATUS_DISTRIBUTION;
        } else if ("single_product_single_piece".equals(connectVO.getConnectType()) || "multi_piece_activity".equals(connectVO.getConnectType()) || "multi_product_single_piece".equals(connectVO.getConnectType()) || "bulk_order".equals(connectVO.getConnectType()) || "large_sized_package".equals(connectVO.getConnectType())) {
            connectVO.setConnectStatus(WMSConstants.ConnectStatus.FINISHED);
            newCommandStatus = WhCommand.STATUS_PACKING;
        } else {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u7c7b\u578b\u5f02\u5e38");
        }
        whWmsHouseShelvesCond.setHouseType("HOUSE_TYPE_PACKING");
        List<WhWmsHouseShelvesVO> hs = this.whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if (CollectionUtils.isEmpty(hs) || hs.size() > 1) {
            throw new WarehouseException("WMS0001", "\u6ca1\u6709\u5408\u9002\u7684\u76ee\u6807\u5e93\u4f4d,\u5206\u62e8\u5305\u88c5\u533a");
        }
        WhWmsHouseShelvesVO targetShelvesVO = hs.get(0);
        ArrayList<String> houseShelvesCodeList = new ArrayList<String>();
        for (WhWmsConnectPickSkuVO connectPickSkuVO : pickSkuVOList) {
            houseShelvesCodeList.add(connectPickSkuVO.getShelvesCode());
        }
        Map<String, WhWmsHouseShelves> shelvesMap = this.whWmsHouseShelvesService.getHouseShelvesMapByCode(houseShelvesCodeList);
        WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
        moveStockVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
        moveStockVO.setCreateUserId(operatorId);
        moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_COMMON);
        moveStockVO.setReferenceCode(connectVO.getId().toString());
        ArrayList<WhWmsMoveSkuVO> moveStockSkuList = new ArrayList<WhWmsMoveSkuVO>();
        moveStockVO.setMoveSkuList(moveStockSkuList);
        for (WhWmsConnectPickSkuVO connectPickSkuVO : pickSkuVOList) {
            WhWmsHouseShelves houseShelvesVO = shelvesMap.get(connectPickSkuVO.getShelvesCode());
            WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
            moveSkuVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
            moveSkuVO.setSkuCode(connectPickSkuVO.getSkuCode());
            moveSkuVO.setSkuStatus(connectPickSkuVO.getSkuStatus());
            moveSkuVO.setBarCode(connectPickSkuVO.getBarCode());
            moveSkuVO.setOriginalHouseType(houseShelvesVO.getHouseType());
            moveSkuVO.setOriginalShelvesCode(connectPickSkuVO.getShelvesCode());
            moveSkuVO.setTargetHouseType(targetShelvesVO.getHouseType());
            moveSkuVO.setTargetShelvesCode(targetShelvesVO.getCode());
            moveSkuVO.setAmount(connectPickSkuVO.getActualAmount());
            moveStockSkuList.add(moveSkuVO);
        }
        this.whWmsMoveStockService.rebuildMoveStock(moveStockVO);
        this.whWmsMoveStockService.moveStockCheck(moveStockVO);
        returnVo.setMoveStockVO(moveStockVO);
        HashMap<Integer, List<String>> toStatusMap = new HashMap<Integer, List<String>>();
        for (WhWmsCommandConnectVO commandConnectVO : commandConnects) {
            ArrayList<String> commandCodes = (ArrayList<String>)toStatusMap.get(newCommandStatus);
            if (NullUtil.isNull((Object)commandCodes)) {
                commandCodes = new ArrayList<String>();
                toStatusMap.put(newCommandStatus, commandCodes);
            }
            commandCodes.add(commandConnectVO.getCommandCode());
        }
        returnVo.setToStatusMap(toStatusMap);
        return returnVo;
    }

    @Override
    @Transactional
    public Boolean submitConnectPickSku(WhWmsConnectPickSkuSubmitDataVO processVo) {
        Map<Integer, List<String>> toStatusMap;
        WhWmsMoveStockVO moveStockVO;
        WhWmsConnectInfoVO connectVO = processVo.getConnectVO();
        if (connectVO != null) {
            this.whWmsConnectInfoService.update(connectVO);
            this.whWmsOccupyService.releaseWmsOccupyByConnectId(connectVO.getId());
        }
        if ((moveStockVO = processVo.getMoveStockVO()) != null) {
            this.whWmsMoveStockService.executeMoveStock(moveStockVO);
        }
        if ((toStatusMap = processVo.getToStatusMap()) != null && toStatusMap.size() > 0) {
            for (Integer key : toStatusMap.keySet()) {
                this.whCommandService.batchUpdateCommandStatus(toStatusMap.get(key), key, WhCommand.STATUS_PICKING);
            }
        }
        return true;
    }

    @Override
    public WhWmsConnectPickSkuSubmitDataVO checkSubmitConnectPickSkuRecWaste(WhWmsConnectInfoVO connectVO, List<WhWmsCommandConnectVO> commandConnectList, List<WhWmsConnectPickSkuVO> pickSkuVOList, Long operatorId) throws Exception {
        WhWmsConnectPickSkuSubmitDataVO returnVo = new WhWmsConnectPickSkuSubmitDataVO();
        if (EmptyUtil.isEmpty(commandConnectList)) {
            throw new WarehouseException("\u6ce2\u6b21\u72b6\u6001\u4e0b\u6307\u4ee4\u5df2\u5168\u90e8\u53d6\u6d88");
        }
        returnVo.setConnectVO(connectVO);
        ArrayList<String> commandCodes = new ArrayList<String>();
        for (WhWmsCommandConnectVO whWmsCommandConnectVO : commandConnectList) {
            commandCodes.add(whWmsCommandConnectVO.getCommandCode());
        }
        List<WhCommand> commandList = this.whCommandService.findCommandByCodes(commandCodes, true);
        for (WhCommand command : commandList) {
            for (WhCommandSku commandSku : command.getWhCommandSkuList()) {
                commandSku.setQuantity(0);
                commandSku.setDamagedQuantity(0);
            }
        }
        List<WhWmsConnectPickSkuVO> list = this.updateConnectPickSku(connectVO.getId(), pickSkuVOList);
        this.pickCommandSkuPcsRtn(connectVO, commandList, list);
        returnVo.setCommandList(commandList);
        returnVo.setPickSkuVOList(pickSkuVOList);
        returnVo.setActualPickSkuList(list);
        return returnVo;
    }

    @Override
    @Transactional
    public boolean submitConnectPickSkuRecWaste(WhWmsConnectPickSkuSubmitDataVO vo, Long operatorId) throws Exception {
        WhWmsConnectInfoVO connectVO = vo.getConnectVO();
        Long connectId = connectVO.getId();
        this.delConnectBox(connectId);
        connectVO.setConnectStatus(WMSConstants.ConnectStatus.FINISHED);
        this.whWmsConnectInfoService.update(connectVO);
        List<WhWmsConnectPickSkuVO> pickSkuVOList = vo.getPickSkuVOList();
        List<WhCommand> commandList = vo.getCommandList();
        if (CollectionUtils.isEmpty(pickSkuVOList)) {
            throw new WarehouseException("WH0001", "\u62e3\u8d27\u6570\u636e\u5f02\u5e38\uff01");
        }
        List<WhWmsConnectPickSkuVO> actualPickSkuList = vo.getActualPickSkuList();
        for (WhCommand whCommand : commandList) {
            this.whCommandService.updateCommandStatusById(whCommand.getId().intValue(), WhCommand.STATUS_DELIVERYCOMPLETION);
            this.whCommandMapper.updatePackageStatusToAlreadyReceive(whCommand.getReferenceCode());
            WhCommandOutFinish whCommandOutFinish = new WhCommandOutFinish();
            whCommandOutFinish.setCommandCode(whCommand.getCode());
            whCommandOutFinish.setStatus(1);
            whCommandOutFinish.setWhStatus(0);
            whCommandOutFinish.setFinishDate(DateUtil.getNow());
            whCommandOutFinish.setWeightUserId(operatorId);
            this.whCommandService.insertWhCommandOutFinish(whCommandOutFinish);
        }
        this.whWmsOccupyService.releaseWmsOccupyByConnectId(connectId);
        for (WhWmsConnectPickSkuVO connectPickSkuVO : actualPickSkuList) {
            if (NullUtil.isNull((Object)connectPickSkuVO.getActualAmount()) || connectPickSkuVO.getActualAmount() <= 0) continue;
            WhWmsHouseShelvesVO hs = this.whWmsHouseShelvesService.getHouseShelvesByCode(connectPickSkuVO.getShelvesCode());
            this.whWmsSkuStockService.updateStockByCond(0 - connectPickSkuVO.getActualAmount(), hs.getPhysicalWarehouseCode(), hs.getHouseType(), connectPickSkuVO.getBarCode(), connectPickSkuVO.getShelvesCode(), connectPickSkuVO.getSkuCode(), connectPickSkuVO.getSkuStatus(), connectVO.getInOutType(), "JH" + connectPickSkuVO.getId(), operatorId);
        }
        return true;
    }

    @Override
    public WhWmsConnectPickSkuSubmitDataVO checkSubmitConnectPickSkuPcsRtn(WhWmsConnectInfoVO connectVO, List<WhWmsCommandConnectVO> commandConnectList, List<WhWmsConnectPickSkuVO> pickSkuVOList, Long operatorId) throws Exception {
        WhWmsConnectPickSkuSubmitDataVO returnVo = new WhWmsConnectPickSkuSubmitDataVO();
        if (EmptyUtil.isEmpty(commandConnectList)) {
            throw new WarehouseException("\u6ce2\u6b21\u72b6\u6001\u4e0b\u6307\u4ee4\u5df2\u5168\u90e8\u53d6\u6d88");
        }
        returnVo.setConnectVO(connectVO);
        ArrayList<String> commandCodes = new ArrayList<String>();
        for (WhWmsCommandConnectVO whWmsCommandConnectVO : commandConnectList) {
            commandCodes.add(whWmsCommandConnectVO.getCommandCode());
        }
        List<WhCommand> commandList = this.whCommandService.findCommandByCodes(commandCodes, true);
        for (WhCommand command : commandList) {
            for (WhCommandSku commandSku : command.getWhCommandSkuList()) {
                commandSku.setQuantity(0);
                commandSku.setDamagedQuantity(0);
            }
        }
        List<WhWmsConnectPickSkuVO> list = this.updateConnectPickSku(connectVO.getId(), pickSkuVOList);
        this.pickCommandSkuPcsRtn(connectVO, commandList, list);
        returnVo.setCommandList(commandList);
        returnVo.setPickSkuVOList(pickSkuVOList);
        returnVo.setActualPickSkuList(list);
        return returnVo;
    }

    @Override
    @Transactional
    public boolean submitConnectPickSkuPcsRtn(WhWmsConnectPickSkuSubmitDataVO vo, Long operatorId) throws Exception {
        WhWmsConnectInfoVO connectVO = vo.getConnectVO();
        Long connectId = connectVO.getId();
        this.delConnectBox(connectId);
        connectVO.setConnectStatus(WMSConstants.ConnectStatus.FINISHED);
        this.whWmsConnectInfoService.update(connectVO);
        List<WhWmsConnectPickSkuVO> pickSkuVOList = vo.getPickSkuVOList();
        List<WhCommand> commandList = vo.getCommandList();
        if (CollectionUtils.isEmpty(pickSkuVOList)) {
            for (WhCommand whCommand : commandList) {
                whCommand.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
                this.whCommandService.finishCommand(whCommand);
                this.whCommandService.updateCommandStatusById(whCommand.getId().intValue(), WhCommand.STATUS_DELIVERYCOMPLETION);
                this.whCommandService.cancelPurchaseRtnByWhCommand(whCommand);
            }
            return true;
        }
        List<WhWmsConnectPickSkuVO> actualPickSkuList = vo.getActualPickSkuList();
        for (WhCommand whCommand : commandList) {
            whCommand.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
            this.whCommandService.finishCommand(whCommand);
            this.whCommandService.updateCommandStatusById(whCommand.getId().intValue(), WhCommand.STATUS_DELIVERYCOMPLETION);
            if (this.isZeroPickSkuPcsRtn(pickSkuVOList)) {
                this.whCommandService.cancelPurchaseRtnByWhCommand(whCommand);
                continue;
            }
            this.whCommandService.finishPurchaseRtnByWhCommand(whCommand);
        }
        this.whWmsOccupyService.releaseWmsOccupyByConnectId(connectId);
        for (WhWmsConnectPickSkuVO connectPickSkuVO : actualPickSkuList) {
            if (NullUtil.isNull((Object)connectPickSkuVO.getActualAmount()) || connectPickSkuVO.getActualAmount() <= 0) continue;
            WhWmsHouseShelvesVO hs = this.whWmsHouseShelvesService.getHouseShelvesByCode(connectPickSkuVO.getShelvesCode());
            this.whWmsSkuStockService.updateStockByCond(0 - connectPickSkuVO.getActualAmount(), hs.getPhysicalWarehouseCode(), hs.getHouseType(), connectPickSkuVO.getBarCode(), connectPickSkuVO.getShelvesCode(), connectPickSkuVO.getSkuCode(), connectPickSkuVO.getSkuStatus(), WhCommand.TYPE_PURCHASE_RETURN_OUT, "JH" + connectPickSkuVO.getId(), operatorId);
        }
        return true;
    }

    @Override
    public boolean consumableReceiveOutInPut(String dispatchBillCode, Map<String, Integer> quantityMap, List<WhWmsSkuStock> whWmsSkuStocks, Long operatorId) throws Exception {
        WhCommand whCommand = this.whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_SALES_OUT, dispatchBillCode, true);
        if (EmptyUtil.isNotEmpty((Object)whCommand)) {
            for (WhWmsSkuStock whWmsSkuStock : whWmsSkuStocks) {
                this.whWmsSkuStockService.updateStockByCond(0 - (whWmsSkuStock.getAmount() == null ? 0 : whWmsSkuStock.getAmount()), whWmsSkuStock.getPhysicalWarehouseCode(), whWmsSkuStock.getHouseType(), whWmsSkuStock.getBarCode(), whWmsSkuStock.getShelvesCode(), whWmsSkuStock.getSkuCode(), whWmsSkuStock.getSkuStatus(), WhCommand.TYPE_SALES_OUT, whCommand.getCode(), operatorId);
            }
        }
        return true;
    }

    private boolean isZeroPickSkuPcsRtn(List<WhWmsConnectPickSkuVO> pickSkuVOList) {
        for (WhWmsConnectPickSkuVO pickSkuVO : pickSkuVOList) {
            if (pickSkuVO.getActualAmount() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public WhWmsConnectPickSkuSubmitDataVO checkSubmitConnectPickSkuAlt(WhWmsConnectInfoVO connectVO, List<WhWmsConnectPickSkuVO> pickSkuVOList, Long operatorId) throws Exception {
        WhWmsConnectPickSkuSubmitDataVO returnVo = new WhWmsConnectPickSkuSubmitDataVO();
        returnVo.setConnectVO(connectVO);
        if (!CollectionUtils.isEmpty(pickSkuVOList)) {
            WhWmsConnectTurnoverBox cond = new WhWmsConnectTurnoverBox();
            cond.setConnectId(connectVO.getId());
            List<WhWmsConnectTurnoverBox> boxes = this.findBoxByCond(cond);
            if (CollectionUtils.isEmpty(boxes)) {
                throw new WarehouseException("WH0001", "\u6ce2\u6b21\u6ca1\u6709\u7ed1\u5b9a\u4efb\u4f55\u4e00\u4e2a\u62e3\u8d27\u5468\u8f6c\u7bb1");
            }
            List<WhWmsConnectPickSkuVO> connectPickSkuVOs = this.findByConnectId(connectVO.getId());
            for (WhWmsConnectPickSkuVO connectPickSkuVO : connectPickSkuVOs) {
                boolean found = false;
                for (WhWmsConnectPickSkuVO pickSkuVO : pickSkuVOList) {
                    if (!pickSkuVO.getId().equals(connectPickSkuVO.getId())) continue;
                    if (pickSkuVO.getActualAmount() > connectPickSkuVO.getNeedAmount()) {
                        throw new WarehouseException("WH0002", "\u62e3\u8d27\u5b9e\u9645\u6570\u91cf\u5927\u4e8e\u8ba1\u5212\u6570\u91cf");
                    }
                    connectPickSkuVO.setActualAmount(pickSkuVO.getActualAmount());
                    found = true;
                    break;
                }
                if (found) continue;
                throw new WarehouseException("WH0002", "\u627e\u4e0d\u5230\u62e3\u8d27\u4efb\u52a1");
            }
            WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
            whWmsHouseShelvesCond.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
            whWmsHouseShelvesCond.setHouseType("HOUSE_TYPE_HANDOVER");
            List<WhWmsHouseShelvesVO> hs = this.whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
            if (CollectionUtils.isEmpty(hs) || hs.size() > 1) {
                throw new WarehouseException("WMS0001", "\u6ca1\u6709\u5408\u9002\u7684\u76ee\u6807\u5e93\u4f4d,\u4ea4\u63a5\u533a");
            }
            WhWmsHouseShelvesVO targetShelvesVO = hs.get(0);
            WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
            moveStockVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
            moveStockVO.setCreateUserId(operatorId);
            moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_COMMON);
            ArrayList<WhWmsMoveSkuVO> moveStockSkuList = new ArrayList<WhWmsMoveSkuVO>();
            moveStockVO.setMoveSkuList(moveStockSkuList);
            for (WhWmsConnectPickSkuVO connectPickSkuVO : connectPickSkuVOs) {
                WhWmsHouseShelvesVO houseShelvesVO = this.whWmsHouseShelvesService.getHouseShelvesByCode(connectPickSkuVO.getShelvesCode());
                WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                moveSkuVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
                moveSkuVO.setSkuCode(connectPickSkuVO.getSkuCode());
                moveSkuVO.setSkuStatus(connectPickSkuVO.getSkuStatus());
                moveSkuVO.setBarCode(connectPickSkuVO.getBarCode());
                moveSkuVO.setOriginalHouseType(houseShelvesVO.getHouseType());
                moveSkuVO.setOriginalShelvesCode(connectPickSkuVO.getShelvesCode());
                moveSkuVO.setTargetHouseType(targetShelvesVO.getHouseType());
                moveSkuVO.setTargetShelvesCode(targetShelvesVO.getCode());
                moveSkuVO.setAmount(connectPickSkuVO.getActualAmount());
                moveStockSkuList.add(moveSkuVO);
            }
            this.whWmsMoveStockService.rebuildMoveStock(moveStockVO);
            this.whWmsMoveStockService.moveStockCheck(moveStockVO);
            returnVo.setMoveStockVO(moveStockVO);
            returnVo.setPickSkuVOList(pickSkuVOList);
        }
        return returnVo;
    }

    @Override
    @Transactional
    public boolean submitConnectPickSkuAlt(WhWmsConnectPickSkuSubmitDataVO vo, Long operatorId) throws Exception {
        WhWmsConnectInfoVO connectVO = vo.getConnectVO();
        connectVO.setConnectStatus(WMSConstants.ConnectStatus.WAITING_PACK);
        this.whWmsConnectInfoService.update(connectVO);
        List<WhWmsConnectPickSkuVO> pickSkuVOList = vo.getPickSkuVOList();
        if (CollectionUtils.isEmpty(pickSkuVOList)) {
            WhWmsConnectAllotPackageVO packageVO = new WhWmsConnectAllotPackageVO();
            packageVO.setConnectId(connectVO.getId());
            packageVO.setOperatorId(operatorId);
            packageVO.setFocusFinish(true);
            return this.whWmsConnectInfoService.submitConnectAltCheck(packageVO);
        }
        this.whWmsOccupyService.releaseWmsOccupyByConnectId(connectVO.getId());
        WhWmsMoveStockVO moveStockVO = vo.getMoveStockVO();
        this.whWmsMoveStockService.executeMoveStock(moveStockVO);
        for (WhWmsCommandConnectVO commandConnectVO : this.whWmsCommandConnectService.findNotCanceledByConnectId(connectVO.getId())) {
            this.whCommandService.commandInPickingToHandover(commandConnectVO.getCommandCode());
        }
        return true;
    }

    private void checkTurnoverValid(String turnoverBoxNo) {
        WhWmsConnectTurnoverBoxExample boxExample = new WhWmsConnectTurnoverBoxExample();
        boxExample.createCriteria().andTurnoverBoxNoEqualTo(turnoverBoxNo).andCancelFlagEqualTo(0).andStatusEqualTo(WhWmsConnectTurnoverBox.STATUS_OCCUPY);
        List<WhWmsConnectTurnoverBox> boxes = this.boxMapper.selectByExample(boxExample);
        if (CollectionUtils.isNotEmpty(boxes)) {
            throw new WarehouseException("WH0001", "\u5df2\u7ed1\u5b9a\u8fc7\u6ce2\u6b21\u5468\u8f6c\u7bb1[" + turnoverBoxNo + "]");
        }
    }

    private void checkDistributionValid(String distributionCode) {
        WhWmsConnectDistributionExample boxExample = new WhWmsConnectDistributionExample();
        boxExample.createCriteria().andDistributionCodeEqualTo(distributionCode).andCancelFlagEqualTo(0);
        List<WhWmsConnectDistribution> boxes = this.whWmsConnectDistributionMapper.selectByExample(boxExample);
        if (CollectionUtils.isNotEmpty(boxes)) {
            throw new WarehouseException("WH0001", "\u5df2\u7ed1\u5b9a\u8fc7\u5206\u62e8\u5468\u8f6c\u7bb1[" + distributionCode + "]");
        }
    }

    @Override
    public Boolean bindConnectBox(Long connectId, String turnoverBoxNo, Long createUserId) {
        WhWmsConnectInfoVO connectVO = this.whWmsConnectInfoService.findById(connectId);
        if (connectVO == null || !connectVO.getConnectStatus().equals(WMSConstants.ConnectStatus.WAITING_PROCESS) && !connectVO.getConnectStatus().equals(WMSConstants.ConnectStatus.PROCESSING)) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u4e0d\u662f\u5f85\u62e3\u8d27\u72b6\u6001");
        }
        this.checkTurnoverValid(turnoverBoxNo);
        this.boxMapper.updateByPhysicalWarehouseCodeAndBoxNo(turnoverBoxNo);
        WhWmsConnectTurnoverBox box = new WhWmsConnectTurnoverBox();
        box.setConnectId(connectId);
        box.setTurnoverBoxNo(turnoverBoxNo);
        box.setCreateUserId(createUserId);
        box.setCancelFlag(0);
        box.setStatus(WhWmsConnectTurnoverBox.STATUS_OCCUPY);
        box.setCreateTime(DateUtil.getNow());
        this.boxMapper.insert(box);
        return true;
    }

    @Override
    public List<WhWmsConnectTurnoverBox> findConnectBoxByConnectId(Long connectId) {
        WhWmsConnectTurnoverBoxExample example = new WhWmsConnectTurnoverBoxExample();
        example.createCriteria().andConnectIdEqualTo(connectId).andCancelFlagEqualTo(0);
        return this.boxMapper.selectByExample(example);
    }

    @Override
    public Boolean deleteConnectBox(Long connectId) {
        WhWmsConnectTurnoverBoxExample boxExample = new WhWmsConnectTurnoverBoxExample();
        boxExample.createCriteria().andConnectIdEqualTo(connectId);
        WhWmsConnectTurnoverBox whWmsConnectTurnoverBox = new WhWmsConnectTurnoverBox();
        whWmsConnectTurnoverBox.setCancelFlag(1);
        this.boxMapper.updateByExampleSelective(whWmsConnectTurnoverBox, boxExample);
        return true;
    }

    @Override
    public Boolean delConnectBox(Long connectId, String turnoverBoxNo) {
        WhWmsConnectTurnoverBoxExample boxExample = new WhWmsConnectTurnoverBoxExample();
        boxExample.createCriteria().andConnectIdEqualTo(connectId).andTurnoverBoxNoEqualTo(turnoverBoxNo);
        return this.boxMapper.deleteByExample(boxExample) != 0;
    }

    private Boolean delConnectBox(Long connectId) {
        WhWmsConnectTurnoverBoxExample boxExample = new WhWmsConnectTurnoverBoxExample();
        boxExample.createCriteria().andConnectIdEqualTo(connectId);
        return this.boxMapper.deleteByExample(boxExample) != 0;
    }

    @Override
    public List<WhWmsConnectTurnoverBox> findBoxByCond(WhWmsConnectTurnoverBox cond) {
        WhWmsConnectTurnoverBoxExample example = new WhWmsConnectTurnoverBoxExample();
        WhWmsConnectTurnoverBoxExample.Criteria criteria = example.createCriteria();
        if (!NumberUtil.isNullOrZero((Number)cond.getConnectId())) {
            criteria.andConnectIdEqualTo(cond.getConnectId());
        }
        if (cond.getCancelFlag() != null && (cond.getCancelFlag().equals(1) || cond.getCancelFlag().equals(0))) {
            criteria.andCancelFlagEqualTo(cond.getCancelFlag());
        }
        if (cond.getStatus() != null && (cond.getStatus().equals(WhWmsConnectTurnoverBox.STATUS_OCCUPY) || cond.getStatus().equals(WhWmsConnectTurnoverBox.STATUS_RELEASED))) {
            criteria.andStatusEqualTo(cond.getCancelFlag());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getTurnoverBoxNo())) {
            criteria.andTurnoverBoxNoEqualTo(cond.getTurnoverBoxNo());
        }
        if (EmptyUtil.isNotEmpty(cond.getConnectIds())) {
            criteria.andConnectIdIn((List)cond.getConnectIds());
        }
        example.setOrderByClause(" ID ASC ");
        List<WhWmsConnectTurnoverBox> WhWmsConnectTurnoverBoxes = this.boxMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(WhWmsConnectTurnoverBoxes)) {
            return Collections.emptyList();
        }
        return WhWmsConnectTurnoverBoxes;
    }

    @Override
    public int findPickCommandCount(Long connectId) {
        return this.boxMapper.findPickCommandCount(connectId);
    }

    private void validateBeforeCreate(WhWmsConnectPickSkuVO vo) {
    }

    private void pickCommandSkuPcsRtn(WhWmsConnectInfoVO connect, List<WhCommand> commandList, List<WhWmsConnectPickSkuVO> pickSkuVOList) {
        for (WhCommand whCommand : commandList) {
            for (WhCommandSku commandSku : whCommand.getWhCommandSkuList()) {
                commandSku.setQuantity(0);
                commandSku.setDamagedQuantity(0);
            }
        }
        Collections.sort(commandList, new Comparator<WhCommand>(){

            @Override
            public int compare(WhCommand o1, WhCommand o2) {
                if (NullUtil.isNull((Object)o1) || NullUtil.isNull((Object)o2)) {
                    return -1;
                }
                return -o1.getCreateTime().compareTo(o2.getCreateTime());
            }
        });
        HashMap<String, Integer> pickedSkuQMap = new HashMap<String, Integer>();
        for (WhWmsConnectPickSkuVO detail : pickSkuVOList) {
            String key = detail.getSkuCode();
            Integer quantity = (Integer)pickedSkuQMap.get(key);
            if (NullUtil.isNull((Object)quantity)) {
                pickedSkuQMap.put(key, detail.getActualAmount());
                continue;
            }
            pickedSkuQMap.put(key, detail.getActualAmount() + quantity);
        }
        Integer n = connect.getSkuStatus();
        for (WhCommand command : commandList) {
            for (WhCommandSku commandSku : command.getWhCommandSkuList()) {
                String skuCode = commandSku.getSkuCode();
                Integer pickedQuantity = (Integer)pickedSkuQMap.get(skuCode);
                if (NullUtil.isNull((Object)pickedQuantity)) continue;
                Integer usedQuantity = 0;
                if (pickedQuantity > 0 && pickedQuantity > commandSku.getPlanedQuantity()) {
                    usedQuantity = commandSku.getPlanedQuantity();
                    pickedSkuQMap.put(skuCode, pickedQuantity - usedQuantity);
                } else {
                    usedQuantity = pickedQuantity;
                    pickedSkuQMap.put(skuCode, 0);
                }
                commandSku.setQuantity(usedQuantity);
            }
        }
    }

    private List<WhWmsConnectPickSkuVO> updateConnectPickSku(Long connectId, List<WhWmsConnectPickSkuVO> pickSkuVOList) {
        if (EmptyUtil.isEmpty(pickSkuVOList)) {
            throw new WarehouseException("\u65e0\u5b9e\u9645\u62e3\u8d27");
        }
        List<WhWmsConnectPickSkuVO> connectPickSkuVOs = this.findByConnectId(connectId);
        for (WhWmsConnectPickSkuVO connectPickSkuVO : connectPickSkuVOs) {
            boolean found = false;
            for (WhWmsConnectPickSkuVO pickSkuVO : pickSkuVOList) {
                if (!pickSkuVO.getId().equals(connectPickSkuVO.getId())) continue;
                if (pickSkuVO.getActualAmount() > connectPickSkuVO.getNeedAmount()) {
                    throw new WarehouseException("WH0002", "\u62e3\u8d27\u5b9e\u9645\u6570\u91cf\u5927\u4e8e\u8ba1\u5212\u6570\u91cf");
                }
                connectPickSkuVO.setActualAmount(pickSkuVO.getActualAmount());
                found = true;
                break;
            }
            if (found) continue;
            throw new WarehouseException("WH0002", "\u627e\u4e0d\u5230\u62e3\u8d27\u4efb\u52a1");
        }
        return connectPickSkuVOs;
    }
}

