/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsConnectParaCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectParaMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectPara;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectParaExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectParaService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectParaVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="whWmsConnectParaService")
public class WhWmsConnectParaServiceImpl
implements WhWmsConnectParaService {
    @Autowired
    private WhWmsConnectParaMapper mapper;

    @Override
    public WhWmsConnectParaVO create(WhWmsConnectParaVO vo) {
        this.validateBeforeSave(vo);
        WhWmsConnectPara whWmsConnectPara = (WhWmsConnectPara)BeanUtil.buildFrom((Object)vo, WhWmsConnectPara.class);
        this.mapper.insert(whWmsConnectPara);
        vo.setId(whWmsConnectPara.getId());
        return vo;
    }

    @Override
    public Boolean update(WhWmsConnectParaVO vo) {
        this.validateBeforeSave(vo);
        return this.mapper.updateByPrimaryKeySelective((WhWmsConnectPara)BeanUtil.buildFrom((Object)vo, WhWmsConnectPara.class)) != 0;
    }

    @Override
    public WhWmsConnectParaVO findById(Long id) {
        WhWmsConnectPara whWmsConnectPara = this.mapper.selectByPrimaryKey(id);
        if (whWmsConnectPara != null) {
            return (WhWmsConnectParaVO)BeanUtil.buildFrom((Object)whWmsConnectPara, WhWmsConnectParaVO.class);
        }
        return null;
    }

    @Override
    public Integer findValueById(Long id) {
        WhWmsConnectParaVO opConnectParaVO = this.findById(id);
        if (opConnectParaVO != null && opConnectParaVO.getParaValue() != null) {
            return opConnectParaVO.getParaValue();
        }
        return null;
    }

    @Override
    public List<WhWmsConnectParaVO> findByCond(WhWmsConnectParaCond cond) {
        WhWmsConnectParaExample example = new WhWmsConnectParaExample();
        WhWmsConnectParaExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotBlank((String)cond.getParaName())) {
            criteria.andParaNameLike(SQLUtils.allLike((String)cond.getParaName()));
        }
        example.setOrderByClause(" ID " + cond.getCriteriaStr());
        List<WhWmsConnectPara> whWmsConnectParas = this.mapper.selectByExample(example);
        if (CollectionUtils.isEmpty(whWmsConnectParas)) {
            return Collections.emptyList();
        }
        ArrayList<WhWmsConnectParaVO> vos = new ArrayList<WhWmsConnectParaVO>(whWmsConnectParas.size());
        for (WhWmsConnectPara whWmsConnectPara : whWmsConnectParas) {
            vos.add((WhWmsConnectParaVO)BeanUtil.buildFrom((Object)whWmsConnectPara, WhWmsConnectParaVO.class));
        }
        return vos;
    }

    @Override
    public WhWmsConnectParaVO findByName(String name) {
        WhWmsConnectParaExample example = new WhWmsConnectParaExample();
        example.createCriteria().andParaNameEqualTo(name);
        List<WhWmsConnectPara> whWmsConnectParas = this.mapper.selectByExample(example);
        if (CollectionUtils.isEmpty(whWmsConnectParas)) {
            return null;
        }
        if (whWmsConnectParas.size() == 1) {
            return (WhWmsConnectParaVO)BeanUtil.buildFrom((Object)whWmsConnectParas.get(0), WhWmsConnectParaVO.class);
        }
        return null;
    }

    @Override
    public Integer findValueByName(String name) {
        WhWmsConnectParaVO opConnectParaVO = this.findByName(name);
        if (opConnectParaVO != null && opConnectParaVO.getParaValue() != null) {
            return opConnectParaVO.getParaValue();
        }
        return null;
    }

    private void validateBeforeSave(WhWmsConnectParaVO vo) {
        if (vo.getParaName() == null) {
            throw new WarehouseException("WH0002", "\u540d\u5b57\u4e3a\u7a7a");
        }
        if (this.existByName(vo).booleanValue()) {
            throw new WarehouseException("WH0002", "\u540d\u5b57\u91cd\u590d");
        }
        if (NumberUtil.isNullOrZero((Number)vo.getParaValue()) || vo.getParaValue() < 0) {
            throw new WarehouseException("WH0002", "\u53c2\u6570\u5c0f\u4e8e\u7b49\u4e8e0");
        }
    }

    private Boolean existByName(WhWmsConnectParaVO vo) {
        WhWmsConnectParaVO exist;
        Boolean result = false;
        if (vo.getParaName() != null && (exist = this.findByName(vo.getParaName())) != null && exist.getId().equals(vo.getId())) {
            result = true;
        }
        return result;
    }
}

