/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsBoxNumberCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsCommandConnectCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsConnectInfoCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsTaskAssignCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsWaitOutStockCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsWaitOutStockCondAlt;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsWaitOutStockCondPcsRtn;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsWaitOutStockCondRecWaste;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsBoxNumberMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsCommandPreOccupyIdxMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectInfoMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectTurnoverBoxMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsBoxNumber;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsBoxNumberExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectInfo;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectTurnoverBox;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectTurnoverBoxExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhAllotService;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandConnectService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandPreOccupyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectAllotPackageService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectPickSkuService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsOccupyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsTaskAssignService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCountVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhSkuInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsBoxNumberVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandConnectVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectAllotPackageDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectAllotPackageVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectCountInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectCountVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectDistributVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectPickSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsOccupyVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsTaskAssignVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsWaitOutStockVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Service(value="whWmsConnectInfoService")
public class WhWmsConnectInfoServiceImpl
implements WhWmsConnectInfoService {
    private final Logger log = LoggerFactory.getLogger(WhWmsConnectInfoServiceImpl.class);
    @Autowired
    private WhWmsConnectInfoMapper mapper;
    @Autowired
    private WhWmsConnectTurnoverBoxMapper boxMapper;
    @Autowired
    private WhWmsCommandConnectService whWmsCommandConnectService;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhWmsConnectPickSkuService whWmsConnectPickSkuService;
    @Autowired
    private WhWmsOccupyService whWmsOccupyService;
    @Autowired
    private WhAllotService whAllotService;
    @Autowired
    private WhWmsConnectAllotPackageService whWmsConnectAllotPackageService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsBoxNumberMapper whWmsBoxNumberMapper;
    @Autowired
    private WhWmsCommandPreOccupyService whWmsCommandPreOccupyService;
    @Autowired
    private WhWmsCommandPreOccupyIdxMapper whWmsCommandPreOccupyIdxMapper;
    @Autowired
    private WhWmsTaskAssignService whWmsTaskAssignService;
    @Autowired
    private RedisDistributLock redisDistributLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WhWmsConnectInfoVO> createWhWmsConnectInfo(WhWmsConnectInfoVO vo, int count) throws Exception {
        ArrayList<WhCommand> whCommands;
        ArrayList<String> whCommandCodes;
        List<WhWmsWaitOutStockVO> commandList;
        ArrayList<Integer> inOutTypeList;
        WhCommand headCommand = this.whCommandService.findCommandByCode(vo.getWhCommandsCodes().get(0), false);
        WhWarehouse headWh = this.whInfoService.findWarehouseByCode(headCommand.getWarehouseCode());
        vo.setSkuStatus(WhWarehouseVO.convertSkuStatusByCommodityStatus(headWh.getCommodityStatus()));
        if (count <= 0) {
            throw new WarehouseException("WH0002", "count<1");
        }
        this.validateCommandConnect(vo);
        ArrayList<WhWmsConnectInfoVO> result = new ArrayList<WhWmsConnectInfoVO>();
        Map<String, Boolean> cmdCombineMap = vo.getCmdCombinedMap();
        if (headCommand.getInOutType().equals(WhCommand.TYPE_ALLOT_OUT)) {
            HashMap<String, Iterator<WhWmsWaitOutStockVO>> groupByPhysicalWhCode = new HashMap<String, Iterator<WhWmsWaitOutStockVO>>();
            for (WhCommand cmd : vo.getWhCommands()) {
                Iterator<WhWmsWaitOutStockVO> another;
                WhAllotRcd allotRcd = this.whAllotService.findAllotRcdByCode(cmd.getReferenceCode(), false);
                if (allotRcd == null) {
                    throw new WarehouseException("", "\u6839\u636e\u76f8\u5173\u5355\u636e\u53f7\u627e\u4e0d\u5230\u8c03\u62e8\u5355");
                }
                WhPhysicalWarehouse physicalWh = this.whInfoService.findPhysicalWarehouseByCode(allotRcd.getTargetPhysicalWarehouseCode());
                if (!groupByPhysicalWhCode.containsKey(physicalWh.getCode())) {
                    another = new WhWmsConnectInfoVO();
                    BeanUtils.copyProperties((Object)vo, (Object)another);
                    ArrayList<String> whCommandCodes2 = new ArrayList<String>();
                    ArrayList<WhCommand> whCommands2 = new ArrayList<WhCommand>();
                    ArrayList<String> failureShortageCommandCodes = new ArrayList<String>();
                    ((WhWmsConnectInfoVO)((Object)another)).setWhCommandsCodes(whCommandCodes2);
                    ((WhWmsConnectInfoVO)((Object)another)).setWhCommands(whCommands2);
                    ((WhWmsConnectInfoVO)((Object)another)).setFailureShortageCommandCodes(failureShortageCommandCodes);
                    ((WhWmsConnectInfo)((Object)another)).setInOutType(WhCommand.TYPE_ALLOT_OUT);
                    groupByPhysicalWhCode.put(physicalWh.getCode(), another);
                }
                another = (WhWmsConnectInfoVO)groupByPhysicalWhCode.get(physicalWh.getCode());
                ((WhWmsConnectInfoVO)((Object)another)).getWhCommandsCodes().add(cmd.getCode());
                ((WhWmsConnectInfoVO)((Object)another)).getWhCommands().add(cmd);
            }
            for (WhWmsConnectInfoVO whWmsConnectInfoVO : groupByPhysicalWhCode.values()) {
                List<WhWmsConnectInfoVO> others = this.divideConnectInfo(whWmsConnectInfoVO, count);
                if (!EmptyUtil.isNotEmpty(others)) continue;
                result.addAll(others);
            }
        } else if (!"single_product_single_piece".equals(vo.getConnectType()) && (headCommand.getInOutType().equals(WhCommand.TYPE_SALES_OUT) || headCommand.getInOutType().equals(WhCommand.TYPE_CHANGE_OUT))) {
            WhPhysicalWarehouse physicalWh = this.whInfoService.findPhysicalWarehouseByCode(headCommand.getPhysicalWarehouseCode());
            WhWmsWaitOutStockCond cond = new WhWmsWaitOutStockCond();
            cond.setCommandCodes(vo.getWhCommandsCodes());
            cond.setPhysicalWarehouseCode(physicalWh.getCode());
            inOutTypeList = new ArrayList<Integer>();
            inOutTypeList.add(headCommand.getInOutType());
            cond.setInOutTypeList(inOutTypeList);
            commandList = this.findWaitOutStockCommandByCond(cond);
            HashMap<String, WhWmsConnectInfoVO> groupByChannelCode = new HashMap<String, WhWmsConnectInfoVO>();
            for (WhWmsWaitOutStockVO command : commandList) {
                WhWmsConnectInfoVO another;
                String channelCode = command.getChannelCode();
                if (!groupByChannelCode.containsKey(channelCode)) {
                    another = new WhWmsConnectInfoVO();
                    BeanUtils.copyProperties((Object)vo, (Object)another);
                    ArrayList<String> whCommandCodes3 = new ArrayList<String>();
                    ArrayList<WhCommand> whCommands3 = new ArrayList<WhCommand>();
                    ArrayList<String> failureShortageCommandCodes = new ArrayList<String>();
                    another.setWhCommandsCodes(whCommandCodes3);
                    another.setWhCommands(whCommands3);
                    another.setFailureShortageCommandCodes(failureShortageCommandCodes);
                    another.setInOutType(command.getInOutType());
                    another.setChannelCode(channelCode);
                    groupByChannelCode.put(channelCode, another);
                }
                another = (WhWmsConnectInfoVO)groupByChannelCode.get(channelCode);
                another.getWhCommandsCodes().add(command.getCode());
                if (EmptyUtil.isNotEmpty(cmdCombineMap)) {
                    command.setNeedConfirm(cmdCombineMap.get(command.getCode()) == null ? false : cmdCombineMap.get(command.getCode()));
                }
                another.getWhCommands().add(command);
            }
            for (WhWmsConnectInfoVO whWmsConnectInfoVO : groupByChannelCode.values()) {
                List<WhWmsConnectInfoVO> others = this.divideConnectInfo(whWmsConnectInfoVO, count);
                if (!EmptyUtil.isNotEmpty(others)) continue;
                result.addAll(others);
            }
        } else if ("single_product_single_piece".equals(vo.getConnectType())) {
            WhPhysicalWarehouse physicalWh = this.whInfoService.findPhysicalWarehouseByCode(headCommand.getPhysicalWarehouseCode());
            WhWmsWaitOutStockCond cond = new WhWmsWaitOutStockCond();
            cond.setCommandCodes(vo.getWhCommandsCodes());
            cond.setPhysicalWarehouseCode(physicalWh.getCode());
            inOutTypeList = new ArrayList();
            inOutTypeList.add(headCommand.getInOutType());
            cond.setInOutTypeList(inOutTypeList);
            commandList = this.findWaitOutStockCommandByCond(cond);
            HashMap<String, WhWmsConnectInfoVO> group = new HashMap<String, WhWmsConnectInfoVO>();
            for (WhWmsWaitOutStockVO command : commandList) {
                WhWmsConnectInfoVO another;
                String channelCode = command.getChannelCode();
                StringBuilder s = new StringBuilder();
                if (command.needCard()) {
                    s.append("1|");
                } else {
                    s.append("2|");
                }
                s.append(command.getExpressType()).append("|");
                s.append(channelCode);
                String key = s.toString();
                if (!group.containsKey(key)) {
                    another = new WhWmsConnectInfoVO();
                    BeanUtils.copyProperties((Object)vo, (Object)another);
                    ArrayList<String> whCommandCodes4 = new ArrayList<String>();
                    ArrayList<WhCommand> whCommands4 = new ArrayList<WhCommand>();
                    ArrayList<String> failureShortageCommandCodes = new ArrayList<String>();
                    another.setWhCommandsCodes(whCommandCodes4);
                    another.setWhCommands(whCommands4);
                    another.setFailureShortageCommandCodes(failureShortageCommandCodes);
                    another.setInOutType(command.getInOutType());
                    another.setChannelCode(channelCode);
                    group.put(key, another);
                }
                another = (WhWmsConnectInfoVO)group.get(key);
                another.getWhCommandsCodes().add(command.getCode());
                if (EmptyUtil.isNotEmpty(cmdCombineMap)) {
                    command.setNeedConfirm(cmdCombineMap.get(command.getCode()) == null ? false : cmdCombineMap.get(command.getCode()));
                }
                another.getWhCommands().add(command);
            }
            for (WhWmsConnectInfoVO whWmsConnectInfoVO : group.values()) {
                List<WhWmsConnectInfoVO> others = this.divideConnectInfo(whWmsConnectInfoVO, count);
                if (!EmptyUtil.isNotEmpty(others)) continue;
                result.addAll(others);
            }
        } else {
            int i = 0;
            for (int loops = new BigDecimal(vo.getWhCommandsCodes().size()).divide(new BigDecimal(count), 0, 0).intValue(); loops > 0; --loops) {
                WhWmsConnectInfoVO another = new WhWmsConnectInfoVO();
                BeanUtils.copyProperties((Object)vo, (Object)another);
                whCommandCodes = new ArrayList<String>();
                whCommands = new ArrayList<WhCommand>();
                ArrayList<String> failureShortageCommandCodes = new ArrayList<String>();
                another.setWhCommandsCodes(whCommandCodes);
                another.setWhCommands(whCommands);
                another.setFailureShortageCommandCodes(failureShortageCommandCodes);
                for (int j = 1; j <= count; ++j) {
                    if (i >= vo.getWhCommandsCodes().size()) continue;
                    int cursor = i++;
                    whCommandCodes.add(vo.getWhCommandsCodes().get(cursor));
                    whCommands.add(vo.getWhCommands().get(cursor));
                }
                if (!CollectionUtils.isEmpty(whCommandCodes)) {
                    result.add(another);
                    continue;
                }
                break;
            }
        }
        if (CollectionUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        if (EmptyUtil.isEmpty((Object)vo.getInOutType())) {
            vo.setInOutType(headCommand.getInOutType());
        }
        ArrayList<WhWmsConnectInfoVO> newResult = new ArrayList<WhWmsConnectInfoVO>();
        for (WhWmsConnectInfoVO whWmsConnectInfoVO : result) {
            whCommandCodes = new ArrayList();
            whCommands = new ArrayList();
            WhWmsConnectInfoVO assambleProd = new WhWmsConnectInfoVO();
            BeanUtils.copyProperties((Object)whWmsConnectInfoVO, (Object)assambleProd);
            assambleProd.setWhCommandsCodes(whCommandCodes);
            assambleProd.setWhCommands(whCommands);
            WhWmsConnectInfoVO noAssambleProd = new WhWmsConnectInfoVO();
            BeanUtils.copyProperties((Object)whWmsConnectInfoVO, (Object)noAssambleProd);
            ArrayList<String> whCommandCodes2 = new ArrayList<String>();
            ArrayList<WhCommand> whCommands2 = new ArrayList<WhCommand>();
            noAssambleProd.setWhCommandsCodes(whCommandCodes2);
            noAssambleProd.setWhCommands(whCommands2);
            for (WhCommand whCommand : whWmsConnectInfoVO.getWhCommands()) {
                if (whCommand.isNeedConfirm()) {
                    assambleProd.getWhCommands().add(whCommand);
                    assambleProd.getWhCommandsCodes().add(whCommand.getCode());
                    continue;
                }
                noAssambleProd.getWhCommands().add(whCommand);
                noAssambleProd.getWhCommandsCodes().add(whCommand.getCode());
            }
            if (CollectionUtils.isNotEmpty(assambleProd.getWhCommands()) && assambleProd.getWhCommands().size() > 0) {
                newResult.add(assambleProd);
            }
            if (!CollectionUtils.isNotEmpty(noAssambleProd.getWhCommands()) || noAssambleProd.getWhCommands().size() <= 0) continue;
            newResult.add(noAssambleProd);
        }
        String lockKey = "lock:wmsWh:create:connect_info";
        try {
            Boolean getLock = this.redisDistributLock.tryLock(lockKey, 3L, TimeUnit.MINUTES);
            if (!getLock.booleanValue()) {
                this.log.info("\u83b7\u53d6\u9501\u5931\u8d25 " + lockKey);
                throw new WarehouseException("WH0001", "\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            for (WhWmsConnectInfoVO whWmsConnectInfoVO : newResult) {
                this.create(whWmsConnectInfoVO);
            }
        }
        finally {
            this.redisDistributLock.unLock(lockKey);
        }
        return result;
    }

    @Override
    public List<WhWmsConnectCountVO> connectCount(String physicalWarehouseCode) {
        return this.mapper.connectCount(physicalWarehouseCode);
    }

    @Override
    @Transactional
    public boolean connectDistribute(WhWmsConnectDistributVO connectDistribut) {
        if (this.gtZero(connectDistribut.getSingleProductSinglePieceAmount())) {
            this.mapper.connectDistribute(connectDistribut.getPhysicalWarehouseCode(), "single_product_single_piece", connectDistribut.getSingleProductSinglePieceAmount(), connectDistribut.getSingleProductSinglePieceIncludeSkuCode());
        }
        if (this.gtZero(connectDistribut.getMultiPieceActivityAmount())) {
            this.mapper.connectDistribute(connectDistribut.getPhysicalWarehouseCode(), "multi_piece_activity", connectDistribut.getMultiPieceActivityAmount(), connectDistribut.getMultiPieceActivityIncludeSkuCode());
        }
        if (this.gtZero(connectDistribut.getMultiProductSinglePieceAmount())) {
            this.mapper.connectDistribute(connectDistribut.getPhysicalWarehouseCode(), "multi_product_single_piece", connectDistribut.getMultiProductSinglePieceAmount(), null);
        }
        if (this.gtZero(connectDistribut.getMultiProductMultiPieceAmount())) {
            this.mapper.connectDistribute(connectDistribut.getPhysicalWarehouseCode(), "multi_product_multi_piece", connectDistribut.getMultiProductMultiPieceAmount(), null);
        }
        if (this.gtZero(connectDistribut.getBulkOrderAmount())) {
            this.mapper.connectDistribute(connectDistribut.getPhysicalWarehouseCode(), "bulk_order", connectDistribut.getBulkOrderAmount(), null);
        }
        if (this.gtZero(connectDistribut.getLargeSizedPackageAmount())) {
            this.mapper.connectDistribute(connectDistribut.getPhysicalWarehouseCode(), "large_sized_package", connectDistribut.getLargeSizedPackageAmount(), null);
        }
        return true;
    }

    @Override
    @Transactional
    public boolean connectDistribute(Long connectId) {
        WhWmsConnectInfoVO connectInfo = this.findById(connectId);
        if (NullUtil.isNull((Object)connectInfo)) {
            throw new WarehouseException("WH0001", String.format("[%s]\u6ce2\u6b21\u4e0d\u5b58\u5728\uff01", connectId));
        }
        if (NullUtil.isNotNull((Object)connectInfo.getDistributeStatus()) && 1 == connectInfo.getDistributeStatus()) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u5df2\u5206\u53d1");
        }
        WhWmsConnectInfo update = new WhWmsConnectInfo();
        update.setId(connectId);
        update.setDistributeStatus(1);
        this.mapper.updateByPrimaryKeySelective(update);
        return true;
    }

    private boolean gtZero(Integer num) {
        return NullUtil.isNotNull((Object)num) && num > 0;
    }

    @Override
    @Transactional
    public boolean startConnect(WhWmsConnectInfoVO connectInfo) throws Exception {
        this.createConnectInfo(connectInfo);
        List<WhWmsOccupyVO> occupyList = this.buildOccupyFormPickStock(connectInfo);
        this.whWmsOccupyService.wmsBatchOccupy(occupyList);
        List<WhWmsConnectPickSkuVO> pickSkuList = connectInfo.getWhWmsConnectPickSkuVOs();
        if (EmptyUtil.isNotEmpty(pickSkuList)) {
            for (WhWmsConnectPickSkuVO pickSku : pickSkuList) {
                pickSku.setConnectId(connectInfo.getId());
            }
        }
        this.whWmsConnectPickSkuService.batchCreate(pickSkuList);
        ArrayList<WhWmsCommandConnectVO> commandConnectList = new ArrayList<WhWmsCommandConnectVO>();
        for (String commandCode : connectInfo.getWhCommandsCodes()) {
            WhWmsCommandConnectVO commandConnect = new WhWmsCommandConnectVO();
            commandConnect.setConnectId(connectInfo.getId());
            commandConnect.setCommandCode(commandCode);
            commandConnect.setCancelFlag(0);
            commandConnectList.add(commandConnect);
        }
        this.whWmsCommandConnectService.create(commandConnectList);
        this.whCommandService.batchUpdateCommandStatus(connectInfo.getWhCommandsCodes(), WhCommand.STATUS_PICKING, WhCommand.STATUS_IN_PROCESSING);
        this.whWmsCommandPreOccupyService.releasePreOccupyForConnectStart(connectInfo.getWhCommandsCodes());
        return true;
    }

    private List<WhWmsOccupyVO> buildOccupyFormPickStock(WhWmsConnectInfoVO connectInfo) {
        ArrayList<WhWmsOccupyVO> occupyList = new ArrayList<WhWmsOccupyVO>();
        for (WhWmsConnectPickSkuVO pickSku : connectInfo.getWhWmsConnectPickSkuVOs()) {
            WhWmsOccupyVO occupy = (WhWmsOccupyVO)BeanUtil.buildFrom((Object)pickSku, WhWmsOccupyVO.class);
            occupy.setPhysicalWarehouseCode(connectInfo.getPhysicalWarehouseCode());
            occupy.setReceiptsNo(connectInfo.getId().toString());
            occupy.setOriShelvesCode(pickSku.getShelvesCode());
            occupy.setAmount(0 - pickSku.getNeedAmount());
            occupy.setType(WhWmsOccupyVO.TYPE_CONNECT);
            occupyList.add(occupy);
        }
        return occupyList;
    }

    private boolean createConnectInfo(WhWmsConnectInfoVO vo) {
        vo.setConnectDate(DateUtil.getNow());
        vo.setConnectStatus(WMSConstants.ConnectStatus.WAITING_PROCESS);
        this.mapper.insert(vo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public List<WhWmsConnectInfoVO> createWhWmsConnectInfoAlt(WhWmsConnectInfoVO vo, int count) throws Exception {
        if (count <= 0) {
            throw new WarehouseException("WH0002", "count<1");
        }
        boolean focusCreate = vo.isFocusCreate();
        this.validateCommandConnect(vo);
        ArrayList<WhWmsConnectInfoVO> result = new ArrayList<WhWmsConnectInfoVO>();
        HashMap<String, WhWmsConnectInfoVO> groupByPhysicalWhCode = new HashMap<String, WhWmsConnectInfoVO>();
        for (WhCommand cmd : vo.getWhCommands()) {
            WhAllotRcd allotRcd = this.whAllotService.findAllotRcdByCode(cmd.getReferenceCode(), false);
            if (allotRcd == null) {
                throw new WarehouseException("", "\u6839\u636e\u76f8\u5173\u5355\u636e\u53f7\u627e\u4e0d\u5230\u8c03\u62e8\u5355");
            }
            WhWmsConnectInfoVO connectInfoVO = new WhWmsConnectInfoVO();
            connectInfoVO = this.wrapConnectInfo(connectInfoVO, vo);
            connectInfoVO.getWhCommandsCodes().add(cmd.getCode());
            connectInfoVO.getWhCommands().add(cmd);
            groupByPhysicalWhCode.put(allotRcd.getCode(), connectInfoVO);
        }
        result.addAll(groupByPhysicalWhCode.values());
        if (CollectionUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        String lockKey = "lock:wmsWh:create:createWhWmsConnectInfoAlt";
        try {
            Boolean getLock = this.redisDistributLock.tryLock(lockKey, 3L, TimeUnit.MINUTES);
            if (!getLock.booleanValue()) {
                this.log.info("\u83b7\u53d6\u9501\u5931\u8d25 " + lockKey);
                throw new WarehouseException("WH0001", "\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            for (WhWmsConnectInfoVO whWmsConnectInfoVO : result) {
                this.createConnectInfoAlt(whWmsConnectInfoVO);
            }
        }
        finally {
            this.redisDistributLock.unLock(lockKey);
        }
        this.checkReceiveAreaStockForAlt(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public List<WhWmsConnectInfoVO> createWhWmsConnectInfoRecWaste(WhWmsConnectInfoVO vo, int count) throws Exception {
        if (count <= 0) {
            throw new WarehouseException("WH0002", "count<1");
        }
        this.validateCommandConnect(vo);
        ArrayList startList = new ArrayList();
        HashMap<String, WhWmsConnectInfoVO> groupBy = new HashMap<String, WhWmsConnectInfoVO>();
        for (WhCommand cmd : vo.getWhCommands()) {
            ArrayList<String> whCommandCodes = new ArrayList<String>();
            ArrayList<WhCommand> whCommands = new ArrayList<WhCommand>();
            ArrayList<String> failureShortageCommandCodes = new ArrayList<String>();
            WhWmsConnectInfoVO connectInfoVO = (WhWmsConnectInfoVO)BeanUtil.buildFrom((Object)vo, WhWmsConnectInfoVO.class);
            connectInfoVO.setWhCommandsCodes(whCommandCodes);
            connectInfoVO.setWhCommands(whCommands);
            connectInfoVO.setFailureShortageCommandCodes(failureShortageCommandCodes);
            connectInfoVO.setInOutType(cmd.getInOutType());
            connectInfoVO.getWhCommandsCodes().add(cmd.getCode());
            connectInfoVO.getWhCommands().add(cmd);
            groupBy.put(cmd.getCode(), connectInfoVO);
        }
        startList.addAll(groupBy.values());
        if (EmptyUtil.isEmpty(startList)) {
            return Collections.emptyList();
        }
        ArrayList<WhWmsConnectInfoVO> retList = new ArrayList<WhWmsConnectInfoVO>();
        String lockKey = "lock:wmsWh:create:createWhWmsConnectInfoRecWaste";
        try {
            Boolean getLock = this.redisDistributLock.tryLock(lockKey, 3L, TimeUnit.MINUTES);
            if (!getLock.booleanValue()) {
                this.log.info("\u83b7\u53d6\u9501\u5931\u8d25 " + lockKey);
                throw new WarehouseException("WH0001", "\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            for (WhWmsConnectInfoVO whWmsConnectInfoVO : startList) {
                WhWmsConnectInfoVO startedConnect = this.createConnectInfoRecWaste(whWmsConnectInfoVO);
                if (!NullUtil.isNotNull((Object)startedConnect)) continue;
                retList.add(startedConnect);
            }
        }
        finally {
            this.redisDistributLock.unLock(lockKey);
        }
        return retList;
    }

    /*
     * WARNING - void declaration
     */
    private void checkReceiveAreaStockForAlt(List<WhWmsConnectInfoVO> connectInfos) {
        String receiveStr;
        if (EmptyUtil.isEmpty(connectInfos)) {
            return;
        }
        HashMap<String, Integer> cmdSkuQuantityMap = new HashMap<String, Integer>();
        HashMap<String, Integer> connectSkuQuantityMap = new HashMap<String, Integer>();
        for (WhWmsConnectInfoVO whWmsConnectInfoVO : connectInfos) {
            List<WhWmsConnectPickSkuVO> list;
            List<WhCommand> list2 = whWmsConnectInfoVO.getWhCommands();
            if (EmptyUtil.isNotEmpty(list2)) {
                for (WhCommand whCommand : list2) {
                    List<WhCommandSku> commandSkuList = whCommand.getWhCommandSkuList();
                    if (!EmptyUtil.isNotEmpty(commandSkuList)) continue;
                    String key = null;
                    for (WhCommandSku commandSku : commandSkuList) {
                        key = commandSku.getSkuCode();
                        Integer n = (Integer)cmdSkuQuantityMap.get(key);
                        if (NullUtil.isNull((Object)n)) {
                            cmdSkuQuantityMap.put(key, commandSku.getPlanedQuantity());
                            continue;
                        }
                        cmdSkuQuantityMap.put(key, n + commandSku.getPlanedQuantity());
                    }
                }
            }
            if (!EmptyUtil.isNotEmpty(list = whWmsConnectInfoVO.getWhWmsConnectPickSkuVOs())) continue;
            for (WhWmsConnectPickSkuVO pickSkuVO : list) {
                Integer pickSkuAmount = (Integer)connectSkuQuantityMap.get(pickSkuVO.getSkuCode());
                if (NullUtil.isNull((Object)pickSkuAmount)) {
                    connectSkuQuantityMap.put(pickSkuVO.getSkuCode(), pickSkuVO.getNeedAmount());
                    continue;
                }
                connectSkuQuantityMap.put(pickSkuVO.getSkuCode(), pickSkuAmount + pickSkuVO.getNeedAmount());
            }
        }
        ArrayList<String> cmdSkuList = new ArrayList<String>();
        for (String string : cmdSkuQuantityMap.keySet()) {
            cmdSkuList.add(string);
        }
        for (String string : cmdSkuList) {
            void var8_30;
            Integer n = (Integer)cmdSkuQuantityMap.get(string);
            Integer n2 = (Integer)connectSkuQuantityMap.get(string);
            if (NullUtil.isNull((Object)n2)) {
                Integer n3 = 0;
            }
            if (var8_30.intValue() < n) {
                cmdSkuQuantityMap.put(string, n - var8_30.intValue());
                continue;
            }
            cmdSkuQuantityMap.remove(string);
        }
        if (EmptyUtil.isEmpty(cmdSkuQuantityMap)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : cmdSkuQuantityMap.entrySet()) {
            Integer n = (Integer)entry.getValue();
            if (n <= 0) continue;
            stringBuilder.append((String)entry.getKey()).append(";").append(entry.getValue()).append(",");
        }
        WhWmsConnectInfoVO whWmsConnectInfoVO = connectInfos.get(0);
        WhWmsSkuStockVO whWmsSkuStockVO = new WhWmsSkuStockVO();
        whWmsSkuStockVO.setSkuCodeList(Arrays.asList(cmdSkuQuantityMap.keySet().toArray(new String[cmdSkuQuantityMap.keySet().size()])));
        whWmsSkuStockVO.setSkuStatus(whWmsConnectInfoVO.getSkuStatus());
        whWmsSkuStockVO.setHouseType("HOUSE_TYPE_RECEIVE");
        whWmsSkuStockVO.setPhysicalWarehouseCode(whWmsConnectInfoVO.getPhysicalWarehouseCode());
        List<WhWmsSkuStockVO> list = this.whWmsSkuStockService.getWmsSkuStockByVO(whWmsSkuStockVO);
        StringBuilder sb = new StringBuilder();
        if (EmptyUtil.isNotEmpty(list)) {
            HashMap<String, Integer> receiveSkuQuantityMap = new HashMap<String, Integer>();
            String key = null;
            for (WhWmsSkuStockVO whWmsSkuStockVO2 : list) {
                if (NullUtil.isNull((Object)whWmsSkuStockVO2.getAmount()) || whWmsSkuStockVO2.getAmount() <= 0) continue;
                key = whWmsSkuStockVO2.getSkuCode();
                Integer quantity = (Integer)receiveSkuQuantityMap.get(key);
                if (NullUtil.isNull((Object)quantity)) {
                    receiveSkuQuantityMap.put(key, whWmsSkuStockVO2.getAmount());
                    continue;
                }
                receiveSkuQuantityMap.put(key, whWmsSkuStockVO2.getAmount() + quantity);
            }
            for (Map.Entry entry : cmdSkuQuantityMap.entrySet()) {
                Integer diffQuantity = (Integer)entry.getValue();
                if (diffQuantity <= 0) continue;
                sb.append((String)entry.getKey()).append(";").append(entry.getValue()).append(",");
            }
        }
        if (EmptyUtil.isNotEmpty((String)(receiveStr = sb.toString()))) {
            stringBuilder.append("--").append(receiveStr);
        }
        throw new WarehouseException("WH0202", stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    private void checkReceiveAreaStock(List<WhWmsConnectInfoVO> connectInfos) {
        if (EmptyUtil.isEmpty(connectInfos)) {
            return;
        }
        HashMap<String, Integer> cmdSkuQuantityMap = new HashMap<String, Integer>();
        HashMap<String, Integer> connectSkuQuantityMap = new HashMap<String, Integer>();
        for (WhWmsConnectInfoVO whWmsConnectInfoVO : connectInfos) {
            List<WhWmsConnectPickSkuVO> pickSkuVOList;
            List<WhCommand> commandList = whWmsConnectInfoVO.getWhCommands();
            if (EmptyUtil.isNotEmpty(commandList)) {
                for (WhCommand whCommand : commandList) {
                    List<WhCommandSku> commandSkuList = whCommand.getWhCommandSkuList();
                    if (!EmptyUtil.isNotEmpty(commandSkuList)) continue;
                    String key = null;
                    for (WhCommandSku commandSku : commandSkuList) {
                        key = commandSku.getSkuCode();
                        Integer quantity = (Integer)cmdSkuQuantityMap.get(key);
                        if (NullUtil.isNull((Object)quantity)) {
                            cmdSkuQuantityMap.put(key, commandSku.getPlanedQuantity());
                            continue;
                        }
                        cmdSkuQuantityMap.put(key, quantity + commandSku.getPlanedQuantity());
                    }
                }
            }
            if (!EmptyUtil.isNotEmpty(pickSkuVOList = whWmsConnectInfoVO.getWhWmsConnectPickSkuVOs())) continue;
            for (WhWmsConnectPickSkuVO pickSkuVO : pickSkuVOList) {
                Integer pickSkuAmount = (Integer)connectSkuQuantityMap.get(pickSkuVO.getSkuCode());
                if (NullUtil.isNull((Object)pickSkuAmount)) {
                    connectSkuQuantityMap.put(pickSkuVO.getSkuCode(), pickSkuVO.getNeedAmount());
                    continue;
                }
                connectSkuQuantityMap.put(pickSkuVO.getSkuCode(), pickSkuAmount + pickSkuVO.getNeedAmount());
            }
        }
        ArrayList<String> cmdSkuList = new ArrayList<String>();
        for (String skuCode : cmdSkuQuantityMap.keySet()) {
            cmdSkuList.add(skuCode);
        }
        for (String skuCode : cmdSkuList) {
            void var8_17;
            Integer commandSkuQuantity = (Integer)cmdSkuQuantityMap.get(skuCode);
            Integer n = (Integer)connectSkuQuantityMap.get(skuCode);
            if (NullUtil.isNull((Object)n)) {
                Integer n2 = 0;
            }
            if (var8_17.intValue() < commandSkuQuantity) {
                cmdSkuQuantityMap.put(skuCode, commandSkuQuantity - var8_17.intValue());
                continue;
            }
            cmdSkuQuantityMap.remove(skuCode);
        }
        if (EmptyUtil.isEmpty(cmdSkuQuantityMap)) {
            return;
        }
        WhWmsConnectInfoVO whWmsConnectInfoVO = connectInfos.get(0);
        WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
        cond.setSkuCodeList(Arrays.asList(cmdSkuQuantityMap.keySet().toArray(new String[cmdSkuQuantityMap.keySet().size()])));
        cond.setSkuStatus(whWmsConnectInfoVO.getSkuStatus());
        cond.setHouseType("HOUSE_TYPE_RECEIVE");
        cond.setPhysicalWarehouseCode(whWmsConnectInfoVO.getPhysicalWarehouseCode());
        List<WhWmsSkuStockVO> skuStockVOList = this.whWmsSkuStockService.getWmsSkuStockByVO(cond);
        if (EmptyUtil.isNotEmpty(skuStockVOList)) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            String key = null;
            for (WhWmsSkuStockVO whWmsSkuStockVO : skuStockVOList) {
                if (NullUtil.isNull((Object)whWmsSkuStockVO.getAmount()) || whWmsSkuStockVO.getAmount() <= 0) continue;
                key = whWmsSkuStockVO.getSkuCode();
                Integer quantity = (Integer)hashMap.get(key);
                if (NullUtil.isNull((Object)quantity)) {
                    hashMap.put(key, whWmsSkuStockVO.getAmount());
                    continue;
                }
                hashMap.put(key, whWmsSkuStockVO.getAmount() + quantity);
            }
            StringBuilder sb = new StringBuilder();
            for (String skuCode : hashMap.keySet()) {
                sb.append(skuCode).append(",");
            }
            String string = sb.toString();
            if (EmptyUtil.isNotEmpty((String)string)) {
                throw new WarehouseException("WH0202", string);
            }
        }
    }

    private WhWmsConnectInfoVO wrapConnectInfo(WhWmsConnectInfoVO another, WhWmsConnectInfoVO vo) {
        BeanUtils.copyProperties((Object)vo, (Object)another);
        ArrayList<String> whCommandCodes = new ArrayList<String>();
        ArrayList<WhCommand> whCommands = new ArrayList<WhCommand>();
        ArrayList<String> failureShortageCommandCodes = new ArrayList<String>();
        another.setWhCommandsCodes(whCommandCodes);
        another.setWhCommands(whCommands);
        another.setFailureShortageCommandCodes(failureShortageCommandCodes);
        another.setInOutType(WhCommand.TYPE_ALLOT_OUT);
        return another;
    }

    /*
     * WARNING - void declaration
     */
    private void checkAltStock(List<WhWmsConnectInfoVO> connectInfos) {
        if (EmptyUtil.isEmpty(connectInfos)) {
            return;
        }
        HashMap<String, Integer> cmdSkuQuantityMap = new HashMap<String, Integer>();
        HashMap<String, Integer> connectSkuQuantityMap = new HashMap<String, Integer>();
        for (WhWmsConnectInfoVO whWmsConnectInfoVO : connectInfos) {
            List<WhWmsConnectPickSkuVO> pickSkuVOList;
            List<WhCommand> commandList = whWmsConnectInfoVO.getWhCommands();
            if (EmptyUtil.isNotEmpty(commandList)) {
                for (WhCommand whCommand : commandList) {
                    List<WhCommandSku> commandSkuList = whCommand.getWhCommandSkuList();
                    if (!EmptyUtil.isNotEmpty(commandSkuList)) continue;
                    Object key = null;
                    for (WhCommandSku commandSku : commandSkuList) {
                        key = commandSku.getSkuCode();
                        Integer quantity = (Integer)cmdSkuQuantityMap.get(key);
                        if (NullUtil.isNull((Object)quantity)) {
                            cmdSkuQuantityMap.put((String)key, commandSku.getPlanedQuantity());
                            continue;
                        }
                        cmdSkuQuantityMap.put((String)key, quantity + commandSku.getPlanedQuantity());
                    }
                }
            }
            if (!EmptyUtil.isNotEmpty(pickSkuVOList = whWmsConnectInfoVO.getWhWmsConnectPickSkuVOs())) continue;
            for (WhWmsConnectPickSkuVO pickSkuVO : pickSkuVOList) {
                connectSkuQuantityMap.put(pickSkuVO.getSkuCode(), pickSkuVO.getNeedAmount());
            }
        }
        ArrayList<String> cmdSkuList = new ArrayList<String>();
        for (String skuCode : cmdSkuQuantityMap.keySet()) {
            cmdSkuList.add(skuCode);
        }
        for (String skuCode : cmdSkuList) {
            void var8_17;
            Integer commandSkuQuantity = (Integer)cmdSkuQuantityMap.get(skuCode);
            Integer n = (Integer)connectSkuQuantityMap.get(skuCode);
            if (NullUtil.isNull((Object)n)) {
                Integer n2 = 0;
            }
            if (var8_17.intValue() < commandSkuQuantity) {
                cmdSkuQuantityMap.put(skuCode, commandSkuQuantity - var8_17.intValue());
                continue;
            }
            cmdSkuQuantityMap.remove(skuCode);
        }
        if (EmptyUtil.isEmpty(cmdSkuQuantityMap)) {
            return;
        }
        WhWmsConnectInfoVO whWmsConnectInfoVO = connectInfos.get(0);
        WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
        cond.setSkuCodeList(Arrays.asList(cmdSkuQuantityMap.keySet().toArray(new String[cmdSkuQuantityMap.keySet().size()])));
        cond.setSkuStatus(whWmsConnectInfoVO.getSkuStatus());
        cond.setHouseType("HOUSE_TYPE_RECEIVE");
        cond.setPhysicalWarehouseCode(whWmsConnectInfoVO.getPhysicalWarehouseCode());
        List<WhWmsSkuStockVO> skuStockVOList = this.whWmsSkuStockService.getWmsSkuStockByVO(cond);
        if (EmptyUtil.isNotEmpty(skuStockVOList)) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            String key = null;
            for (WhWmsSkuStockVO whWmsSkuStockVO : skuStockVOList) {
                if (NullUtil.isNull((Object)whWmsSkuStockVO.getAmount()) || whWmsSkuStockVO.getAmount() <= 0) continue;
                key = whWmsSkuStockVO.getSkuCode();
                Integer quantity = (Integer)hashMap.get(key);
                if (NullUtil.isNull((Object)quantity)) {
                    hashMap.put(key, whWmsSkuStockVO.getAmount());
                    continue;
                }
                hashMap.put(key, whWmsSkuStockVO.getAmount() + quantity);
            }
            StringBuilder sb = new StringBuilder();
            for (String skuCode : hashMap.keySet()) {
                sb.append(skuCode).append(",");
            }
            String string = sb.toString();
            if (EmptyUtil.isNotEmpty((String)string)) {
                throw new WarehouseException("WH0202", string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public List<WhWmsConnectInfoVO> createWhWmsConnectInfoPcsRtn(WhWmsConnectInfoVO vo, int count) throws Exception {
        if (count <= 0) {
            throw new WarehouseException("WH0002", "count<1");
        }
        this.validateCommandConnect(vo);
        ArrayList<WhWmsConnectInfoVO> result = new ArrayList<WhWmsConnectInfoVO>();
        HashMap<String, WhWmsConnectInfoVO> groupByPurchaseReturnCode = new HashMap<String, WhWmsConnectInfoVO>();
        for (WhCommand cmd : vo.getWhCommands()) {
            WhWmsConnectInfoVO another;
            String purchaseReturnCode = cmd.getReferenceCode();
            if (NullUtil.isNull((Object)purchaseReturnCode)) {
                throw new WarehouseException("", "\u91c7\u8d2d\u5355\u53f7\u4e0d\u5b58\u5728");
            }
            if (!groupByPurchaseReturnCode.containsKey(purchaseReturnCode)) {
                another = new WhWmsConnectInfoVO();
                BeanUtils.copyProperties((Object)vo, (Object)another);
                ArrayList<String> whCommandCodes = new ArrayList<String>();
                ArrayList<WhCommand> whCommands = new ArrayList<WhCommand>();
                ArrayList<String> failureShortageCommandCodes = new ArrayList<String>();
                another.setWhCommandsCodes(whCommandCodes);
                another.setWhCommands(whCommands);
                another.setFailureShortageCommandCodes(failureShortageCommandCodes);
                another.setInOutType(WhCommand.TYPE_PURCHASE_RETURN_OUT);
                groupByPurchaseReturnCode.put(purchaseReturnCode, another);
            }
            another = (WhWmsConnectInfoVO)groupByPurchaseReturnCode.get(purchaseReturnCode);
            another.getWhCommandsCodes().add(cmd.getCode());
            another.getWhCommands().add(cmd);
        }
        for (WhWmsConnectInfoVO whWmsConnectInfoVO : groupByPurchaseReturnCode.values()) {
            List<WhWmsConnectInfoVO> others = this.divideConnectInfo(whWmsConnectInfoVO, count);
            if (!EmptyUtil.isNotEmpty(others)) continue;
            result.addAll(others);
        }
        if (CollectionUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        String lockKey = "lock:wmsWh:create:createWhWmsConnectInfoPcsRtn";
        try {
            Boolean getLock = this.redisDistributLock.tryLock(lockKey, 3L, TimeUnit.MINUTES);
            if (!getLock.booleanValue()) {
                this.log.info("\u83b7\u53d6\u9501\u5931\u8d25 " + lockKey);
                throw new WarehouseException("WH0001", "\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            for (WhWmsConnectInfoVO whWmsConnectInfoVO : result) {
                this.createConnectInfoPcsRtn(whWmsConnectInfoVO);
            }
        }
        finally {
            this.redisDistributLock.unLock(lockKey);
        }
        boolean focusCreate = vo.isFocusCreate();
        if (!focusCreate) {
            this.checkReceiveAreaStock(result);
        }
        return result;
    }

    private List<WhWmsConnectInfoVO> divideConnectInfo(WhWmsConnectInfoVO connectInfo, int count) {
        ArrayList<WhWmsConnectInfoVO> list = new ArrayList<WhWmsConnectInfoVO>();
        List<String> commandCodes = connectInfo.getWhCommandsCodes();
        List<WhCommand> commands = connectInfo.getWhCommands();
        if (EmptyUtil.isEmpty(commandCodes)) {
            return list;
        }
        int size = commandCodes.size();
        WhWmsConnectInfoVO another = null;
        for (int i = 0; i < size; ++i) {
            if (i % count == 0) {
                another = new WhWmsConnectInfoVO();
                BeanUtils.copyProperties((Object)connectInfo, (Object)another);
                ArrayList<String> whCommandCodes = new ArrayList<String>();
                ArrayList<WhCommand> whCommands = new ArrayList<WhCommand>();
                ArrayList<String> failureShortageCommandCodes = new ArrayList<String>();
                another.setWhCommandsCodes(whCommandCodes);
                another.setWhCommands(whCommands);
                another.setFailureShortageCommandCodes(failureShortageCommandCodes);
                list.add(another);
            }
            another.getWhCommandsCodes().add(commandCodes.get(i));
            another.getWhCommands().add(commands.get(i));
        }
        return list;
    }

    private WhWmsConnectInfoVO createConnectInfoRecWaste(WhWmsConnectInfoVO vo) throws Exception {
        this.validateBeforeCreate(vo);
        if (EmptyUtil.isEmpty(vo.getWhCommandsCodes())) {
            return null;
        }
        vo.setConnectDate(DateUtil.getNow());
        vo.setConnectStatus(WMSConstants.ConnectStatus.WAITING_PROCESS);
        vo.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED);
        if (NullUtil.isNull((Object)vo.getDistributeStatus())) {
            vo.setDistributeStatus(1);
        }
        WhWmsConnectInfo whWmsConnectInfo = (WhWmsConnectInfo)BeanUtil.buildFrom((Object)vo, WhWmsConnectInfo.class);
        this.mapper.insert(whWmsConnectInfo);
        vo.setId(whWmsConnectInfo.getId());
        List<WhWmsCommandConnectVO> connectInfoList = this.whWmsCommandConnectService.createConnectInfoRecWaste(vo);
        if (EmptyUtil.isNotEmpty(connectInfoList)) {
            vo.getWhWmsCommandConnectVOs().addAll(connectInfoList);
            WhWmsOccupyVO cond = new WhWmsOccupyVO();
            cond.setReceiptsNo(vo.getId().toString());
            List<WhWmsOccupyVO> occupyVOList = this.whWmsOccupyService.getWmsOccupyByCond(cond);
            this.createConnectPickSkuByOccupy(vo, occupyVOList);
        }
        return vo;
    }

    private WhWmsConnectInfoVO createConnectInfoPcsRtn(WhWmsConnectInfoVO vo) throws Exception {
        this.validateBeforeCreate(vo);
        if (CollectionUtils.isEmpty(vo.getWhCommandsCodes())) {
            return null;
        }
        vo.setConnectDate(DateUtil.getNow());
        vo.setConnectStatus(WMSConstants.ConnectStatus.WAITING_PROCESS);
        if (NullUtil.isNull((Object)vo.getDistributeStatus())) {
            vo.setDistributeStatus(1);
        }
        WhWmsConnectInfo whWmsConnectInfo = (WhWmsConnectInfo)BeanUtil.buildFrom((Object)vo, WhWmsConnectInfo.class);
        this.mapper.insert(whWmsConnectInfo);
        vo.setId(whWmsConnectInfo.getId());
        List<WhWmsCommandConnectVO> connectInfoList = this.whWmsCommandConnectService.createConnectInfoPcsRtn(vo);
        vo.getWhWmsCommandConnectVOs().addAll(connectInfoList);
        this.afterCreatePcsRtnConnectInfo(vo);
        return vo;
    }

    private WhWmsConnectInfoVO createConnectInfoAlt(WhWmsConnectInfoVO vo) throws Exception {
        this.validateBeforeCreate(vo);
        if (CollectionUtils.isEmpty(vo.getWhCommandsCodes())) {
            return null;
        }
        vo.setConnectDate(DateUtil.getNow());
        vo.setConnectStatus(WMSConstants.ConnectStatus.WAITING_PROCESS);
        if (NullUtil.isNull((Object)vo.getDistributeStatus())) {
            vo.setDistributeStatus(1);
        }
        WhWmsConnectInfo whWmsConnectInfo = (WhWmsConnectInfo)BeanUtil.buildFrom((Object)vo, WhWmsConnectInfo.class);
        this.mapper.insert(whWmsConnectInfo);
        vo.setId(whWmsConnectInfo.getId());
        List<WhWmsCommandConnectVO> connectInfoList = this.whWmsCommandConnectService.createConnectInfoAlt(vo);
        vo.getWhWmsCommandConnectVOs().addAll(connectInfoList);
        this.afterCreateAltConnectInfo(vo);
        return vo;
    }

    @Override
    public WhWmsConnectInfoVO create(WhWmsConnectInfoVO vo) throws Exception {
        this.validateBeforeCreate(vo);
        if (CollectionUtils.isEmpty(vo.getWhCommandsCodes())) {
            return null;
        }
        vo.setConnectDate(DateUtil.getNow());
        vo.setConnectStatus(WMSConstants.ConnectStatus.WAITING_PROCESS);
        WhWmsConnectInfo whWmsConnectInfo = (WhWmsConnectInfo)BeanUtil.buildFrom((Object)vo, WhWmsConnectInfo.class);
        this.mapper.insert(whWmsConnectInfo);
        vo.setId(whWmsConnectInfo.getId());
        vo.getWhWmsCommandConnectVOs().addAll(this.whWmsCommandConnectService.create(vo));
        this.afterCreate(vo);
        return vo;
    }

    @Override
    public Boolean update(WhWmsConnectInfoVO vo) {
        return this.mapper.updateByPrimaryKeySelective((WhWmsConnectInfo)BeanUtil.buildFrom((Object)vo, WhWmsConnectInfo.class)) != 0;
    }

    @Override
    public Boolean connectStatusTransform(Long connectId, Integer beforeStatus, Integer afterStatus) {
        return this.connectStatusTransform(Collections.singleton(connectId), beforeStatus, afterStatus);
    }

    private boolean connectStatusTransform(Set<Long> connectIds, Integer beforeStatus, Integer afterStatus) {
        int count = this.mapper.connectStatusTransform(connectIds, beforeStatus, afterStatus);
        return count == connectIds.size();
    }

    @Override
    public boolean deleteById(Long id) {
        return this.mapper.deleteByPrimaryKey(id) != 0;
    }

    @Override
    @Transactional
    public boolean cancelConnect(List<Long> idList) {
        WhWmsConnectInfoCond cond = new WhWmsConnectInfoCond();
        cond.setConnectIds(idList);
        List<WhWmsConnectInfo> connectList = this.mapper.findByCond(cond);
        if (EmptyUtil.isEmpty(connectList)) {
            throw new WarehouseException("WH0001", "\u65e0\u6ce2\u6b21\u6570\u636e\uff01");
        }
        List<Long> connectIdList = this.connectCancelCheck(connectList);
        HashSet<Long> ids = new HashSet<Long>();
        ids.addAll(connectIdList);
        boolean result = this.connectStatusTransform(ids, WMSConstants.ConnectStatus.WAITING_PROCESS, WMSConstants.ConnectStatus.CANCELED);
        if (!result) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u72b6\u6001\u4e0d\u662f\u5f85\u62e3\u8d27");
        }
        result = this.whWmsConnectPickSkuService.cancelConnectPickSku(connectIdList);
        if (!result) {
            throw new WarehouseException("WH0001", "\u5df2\u5f00\u59cb\u62e3\u8d27\u4e0d\u53ef\u53d6\u6d88\uff01");
        }
        this.whWmsOccupyService.releaseWmsOccupyByConnectId(connectIdList);
        this.deleteConnectTurnoverBox(connectIdList);
        this.whWmsCommandConnectService.batchCancelByConnectId(connectIdList);
        WhWmsCommandConnectCond cmdConnectCond = new WhWmsCommandConnectCond();
        cmdConnectCond.setConnectIds(connectIdList);
        List<WhWmsCommandConnectVO> commandConnectList = this.whWmsCommandConnectService.findByCond(cmdConnectCond);
        if (EmptyUtil.isNotEmpty(commandConnectList)) {
            ArrayList<String> commandCodes = new ArrayList<String>();
            for (WhWmsCommandConnectVO commandConnect : commandConnectList) {
                commandCodes.add(commandConnect.getCommandCode());
            }
            this.whCommandService.batchUpdateCommandStatus(commandCodes, WhCommand.STATUS_IN_PROCESSING, WhCommand.STATUS_PICKING);
            this.whWmsCommandPreOccupyIdxMapper.batchDelete(commandCodes);
        }
        return true;
    }

    private boolean deleteConnectTurnoverBox(List<Long> connectIds) {
        WhWmsConnectTurnoverBoxExample boxExample = new WhWmsConnectTurnoverBoxExample();
        boxExample.createCriteria().andConnectIdIn((List)connectIds);
        WhWmsConnectTurnoverBox whWmsConnectTurnoverBox = new WhWmsConnectTurnoverBox();
        whWmsConnectTurnoverBox.setCancelFlag(1);
        this.boxMapper.updateByExampleSelective(whWmsConnectTurnoverBox, boxExample);
        return true;
    }

    private List<Long> connectCancelCheck(List<WhWmsConnectInfo> connectList) {
        ArrayList<String> referenceCodes = new ArrayList<String>();
        ArrayList<Long> connectIdList = new ArrayList<Long>();
        for (WhWmsConnectInfo connectInfo : connectList) {
            connectIdList.add(connectInfo.getId());
            referenceCodes.add(connectInfo.getId().toString());
            if (WMSConstants.ConnectStatus.WAITING_PROCESS.equals(connectInfo.getConnectStatus())) continue;
            throw new WarehouseException("WH0001", String.format("\u6ce2\u6b21[%s]\u5f53\u524d\u72b6\u6001\u4e3a%s,\u4e0d\u53ef\u53d6\u6d88", connectInfo.getId(), WhWmsConnectInfoVO.getConnectStatusStr(connectInfo.getConnectStatus())));
        }
        WhWmsTaskAssignCond taskCond = new WhWmsTaskAssignCond();
        taskCond.setType(WhWmsTaskAssignVO.TASK_TYPE_CONNPICKSKU);
        taskCond.setReferenceCodeList(referenceCodes);
        List<WhWmsTaskAssignVO> taskList = this.whWmsTaskAssignService.findWhWmsTaskAssignByCond(taskCond);
        if (EmptyUtil.isNotEmpty(taskList)) {
            StringBuilder buff = new StringBuilder();
            for (WhWmsTaskAssignVO taskAssign : taskList) {
                buff.append(String.format("\u6ce2\u6b21[%s]\u5df2\u9886\u53d6\u65e0\u6cd5\u53d6\u6d88!<br/>", taskAssign.getReferenceCode()));
            }
            throw new WarehouseException("WH0001", buff.toString());
        }
        return connectIdList;
    }

    @Override
    public WhWmsConnectInfoVO findById(Long id) {
        WhWmsConnectInfo whWmsConnectInfo = this.mapper.selectByPrimaryKey(id);
        if (whWmsConnectInfo != null) {
            return (WhWmsConnectInfoVO)BeanUtil.buildFrom((Object)whWmsConnectInfo, WhWmsConnectInfoVO.class);
        }
        return null;
    }

    @Override
    public List<WhWmsConnectInfoVO> findNeedHandleConnect() {
        List<WhWmsConnectInfo> list = this.mapper.findNeedHandleConnect();
        if (EmptyUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        return BeanUtil.buildListFrom(list, WhWmsConnectInfoVO.class);
    }

    @Override
    public List<WhWmsConnectInfo> findConnectInfoByCond(WhWmsConnectInfoCond cond) {
        return this.mapper.findByCond(cond);
    }

    @Override
    public Pagination<WhWmsConnectInfoVO> findByCond(WhWmsConnectInfoCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        List<WhWmsConnectInfo> whWmsConnectInfos = this.mapper.findByCond(cond);
        Integer counts = this.mapper.countFindByCond(cond);
        if (CollectionUtils.isEmpty(whWmsConnectInfos)) {
            return page;
        }
        ArrayList<WhWmsConnectInfoVO> vos = new ArrayList<WhWmsConnectInfoVO>(whWmsConnectInfos.size());
        ArrayList<Long> connectIds = new ArrayList<Long>();
        for (WhWmsConnectInfo whWmsConnectInfo : whWmsConnectInfos) {
            connectIds.add(whWmsConnectInfo.getId());
            WhWmsConnectInfoVO whWmsConnectInfoVO = (WhWmsConnectInfoVO)BeanUtil.buildFrom((Object)whWmsConnectInfo, WhWmsConnectInfoVO.class);
            vos.add(whWmsConnectInfoVO);
        }
        List<WhCountVO> countList = this.whWmsCommandConnectService.countConnectCommandByConnectId(connectIds);
        if (EmptyUtil.isNotEmpty(countList)) {
            HashMap<String, WhCountVO> countMap = new HashMap<String, WhCountVO>();
            for (WhCountVO count : countList) {
                countMap.put(count.getCode(), count);
            }
            for (WhWmsConnectInfoVO vo : vos) {
                WhCountVO count = (WhCountVO)countMap.get(vo.getId().toString());
                if (!NullUtil.isNotNull((Object)count)) continue;
                vo.setCmdConnectCount(count.getAmount());
            }
        }
        page.setResultList(vos);
        page.setRecord(counts);
        return page;
    }

    @Override
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandByCond(WhWmsWaitOutStockCond cond) {
        List<WhWmsWaitOutStockVO> vos;
        if (EmptyUtil.isEmpty((String)cond.getPhysicalWarehouseCode())) {
            throw new WarehouseException("WH0002", "\u7269\u7406\u4ed3\u7f16\u7801\u5fc5\u586b");
        }
        cond.setFetch(true);
        cond.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
        if (CollectionUtils.isEmpty(cond.getInOutTypeList())) {
            cond.setInOutTypeList(WhCommand.getAllOutType());
        }
        if (CollectionUtils.isEmpty(vos = this.whCommandService.findWaitOutStockCommandByCond(cond))) {
            return Collections.emptyList();
        }
        return vos;
    }

    @Override
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandSaleOutByCond(WhWmsWaitOutStockCond cond) {
        if (EmptyUtil.isEmpty((String)cond.getPhysicalWarehouseCode())) {
            throw new WarehouseException("WH0002", "\u7269\u7406\u4ed3\u7f16\u7801\u5fc5\u586b");
        }
        cond.setFetch(true);
        cond.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
        if (CollectionUtils.isEmpty(cond.getInOutTypeList())) {
            cond.setInOutTypeList(WhCommand.getAllOutType());
        }
        return this.whCommandService.findWaitOutStockCommandSaleOutByCond(cond);
    }

    @Override
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandAltByCond(WhWmsWaitOutStockCondAlt cond) {
        List<WhWmsWaitOutStockVO> vos;
        if (EmptyUtil.isEmpty((String)cond.getPhysicalWarehouseCode())) {
            throw new WarehouseException("WH0002", "\u7269\u7406\u4ed3\u7f16\u7801\u5fc5\u586b");
        }
        cond.setFetch(true);
        cond.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
        if (CollectionUtils.isEmpty(cond.getInOutTypeList())) {
            cond.setInOutTypeList(WhCommand.getAllOutType());
        }
        if (CollectionUtils.isEmpty(vos = this.whCommandService.findWaitOutStockCommandAltByCond(cond))) {
            return Collections.emptyList();
        }
        return vos;
    }

    @Override
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandPcsRtnByCond(WhWmsWaitOutStockCondPcsRtn cond) {
        List<WhWmsWaitOutStockVO> vos;
        if (EmptyUtil.isEmpty((String)cond.getPhysicalWarehouseCode())) {
            throw new WarehouseException("WH0002", "\u7269\u7406\u4ed3\u7f16\u7801\u5fc5\u586b");
        }
        cond.setFetch(true);
        cond.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
        if (CollectionUtils.isEmpty(cond.getInOutTypeList())) {
            cond.setInOutTypeList(WhCommand.getAllOutType());
        }
        if (CollectionUtils.isEmpty(vos = this.whCommandService.findWaitOutStockCommandPcsRtnByCond(cond))) {
            return Collections.emptyList();
        }
        return vos;
    }

    @Override
    public Pagination<WhWmsWaitOutStockVO> findWaitOutStockCommandRecWasteByCond(WhWmsWaitOutStockCondRecWaste cond) {
        if (EmptyUtil.isEmpty((String)cond.getPhysicalWarehouseCode())) {
            throw new WarehouseException("WH0002", "\u7269\u7406\u4ed3\u7f16\u7801\u5fc5\u586b");
        }
        cond.setFetch(true);
        cond.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
        return this.whCommandService.findWaitOutStockCommandRecWasteByCond(cond);
    }

    @Override
    @Transactional
    public boolean submitConnectAltCheck(WhWmsConnectAllotPackageVO packageVO) throws Exception {
        boolean finished;
        Long connectId = packageVO.getConnectId();
        if (EmptyUtil.isNotEmpty(packageVO.getDetails())) {
            this.checkAltPackageInfo(packageVO);
            this.whWmsConnectAllotPackageService.add(packageVO);
        }
        List<WhWmsConnectPickSkuVO> pickSkuList = this.whWmsConnectPickSkuService.findByConnectId(connectId);
        List<WhWmsConnectAllotPackageDetailVO> packedDetailList = this.whWmsConnectAllotPackageService.findConnectAltPackageDetailsByConnectId(connectId);
        if (NullUtil.isNull(packedDetailList)) {
            packedDetailList = new ArrayList<WhWmsConnectAllotPackageDetailVO>();
        }
        boolean bl = finished = packageVO.isFocusFinish() || this.checkConnectAltFinished(pickSkuList, packedDetailList);
        if (finished) {
            packageVO.setConnectAltDone(true);
            this.finishConnectAlt(connectId, pickSkuList, packedDetailList, packageVO.getOperatorId());
        }
        return true;
    }

    private boolean checkAltPackageInfo(WhWmsConnectAllotPackageVO packageVO) {
        List<WhWmsConnectPickSkuVO> picSkuList = this.whWmsConnectPickSkuService.findByConnectId(packageVO.getConnectId());
        if (EmptyUtil.isEmpty(packageVO.getDetails())) {
            return true;
        }
        if (EmptyUtil.isEmpty(picSkuList)) {
            throw new WarehouseException("WH0001", "\u65e0\u62e3\u8d27\u6570\u636e");
        }
        HashMap<String, Integer> skuQuantityMap = new HashMap<String, Integer>();
        for (WhWmsConnectPickSkuVO pickSku : picSkuList) {
            Integer pickSkuQuantity = (Integer)skuQuantityMap.get(pickSku.getSkuCode());
            pickSkuQuantity = NullUtil.isNull((Object)pickSkuQuantity) ? pickSku.getActualAmount() : Integer.valueOf(pickSkuQuantity + pickSku.getActualAmount());
            skuQuantityMap.put(pickSku.getSkuCode(), pickSkuQuantity);
        }
        List<WhWmsConnectAllotPackageVO> allotPackageList = this.whWmsConnectAllotPackageService.findByConnectId(packageVO.getConnectId());
        if (EmptyUtil.isNotEmpty(allotPackageList)) {
            for (WhWmsConnectAllotPackageVO allotPackage : allotPackageList) {
                List<WhWmsConnectAllotPackageDetailVO> packageDetailList = allotPackage.getDetails();
                if (!EmptyUtil.isNotEmpty(packageDetailList)) continue;
                for (WhWmsConnectAllotPackageDetailVO detail : packageDetailList) {
                    Integer pickSkuQuantity = (Integer)skuQuantityMap.get(detail.getSkuCode());
                    if (NullUtil.isNull((Object)pickSkuQuantity)) {
                        throw new WarehouseException("WH0001", String.format("[%s]\u65e0\u62e3\u8d27\u8bb0\u5f55", detail.getSkuCode()));
                    }
                    skuQuantityMap.put(detail.getSkuCode(), pickSkuQuantity - detail.getQuantity());
                }
            }
        }
        for (WhWmsConnectAllotPackageDetailVO detail : packageVO.getDetails()) {
            Integer pickSkuQuantity = (Integer)skuQuantityMap.get(detail.getSkuCode());
            if (NullUtil.isNull((Object)pickSkuQuantity)) {
                throw new WarehouseException("WH0001", String.format("[%s]\u65e0\u62e3\u8d27\u8bb0\u5f55", detail.getSkuCode()));
            }
            if (pickSkuQuantity < detail.getQuantity()) {
                throw new WarehouseException("WH0001", String.format("[%s]\u6253\u5305\u6570\u91cf\u8fc7\u591a[%d<%d]", detail.getSkuCode(), pickSkuQuantity, detail.getQuantity()));
            }
            skuQuantityMap.put(detail.getSkuCode(), pickSkuQuantity - detail.getQuantity());
        }
        return true;
    }

    private boolean finishConnectAlt(Long connectId, List<WhWmsConnectPickSkuVO> pickSkuList, List<WhWmsConnectAllotPackageDetailVO> packedDetailList, Long operatorId) throws Exception {
        WhWmsConnectInfoVO connect = this.findById(connectId);
        if (!WMSConstants.ConnectStatus.WAITING_PACK.equals(connect.getConnectStatus())) {
            throw new WarehouseException("\u6ce2\u6b21\u72b6\u6001\u4e0d\u662f\u5f85\u6253\u5305");
        }
        this.delConnectBox(connectId);
        connect.setConnectStatus(WMSConstants.ConnectStatus.FINISHED);
        this.update(connect);
        List<WhWmsCommandConnectVO> commandConnectList = this.whWmsCommandConnectService.findNotCanceledByConnectId(connectId);
        if (EmptyUtil.isEmpty(commandConnectList)) {
            throw new WarehouseException("\u6ce2\u6b21\u72b6\u6001\u4e0b\u6307\u4ee4\u5df2\u5168\u90e8\u53d6\u6d88");
        }
        ArrayList<String> commandCodes = new ArrayList<String>();
        for (WhWmsCommandConnectVO cmdConn : commandConnectList) {
            commandCodes.add(cmdConn.getCommandCode());
        }
        List<WhCommand> commandList = this.whCommandService.findCommandByCodes(commandCodes, true);
        this.fullAltCommand(connect, commandList, packedDetailList);
        for (WhCommand whCommand : commandList) {
            whCommand.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
            whCommand.setOperatorId(operatorId);
            this.whCommandService.finishCommand(whCommand);
            this.whCommandService.updateCommandStatusById(whCommand.getId().intValue(), WhCommand.STATUS_DELIVERYCOMPLETION);
        }
        this.updateWmsStockWhenConnectAltFinished(connectId, operatorId);
        return true;
    }

    private void updateWmsStockWhenConnectAltFinished(Long connectId, Long operatorId) {
        WhWmsConnectInfoVO connect = this.findById(connectId);
        if (!WMSConstants.ConnectStatus.FINISHED.equals(connect.getConnectStatus())) {
            throw new WarehouseException("\u6ce2\u6b21\u72b6\u6001\u4e0d\u662f\u5df2\u5b8c\u6210");
        }
        List<WhWmsConnectAllotPackageDetailVO> packedDetailList = this.whWmsConnectAllotPackageService.findConnectAltPackageDetailsByConnectId(connectId);
        if (EmptyUtil.isEmpty(packedDetailList)) {
            return;
        }
        HashMap<String, Integer> packedSkuQMap = new HashMap<String, Integer>();
        for (WhWmsConnectAllotPackageDetailVO detail : packedDetailList) {
            String key = detail.getSkuCode() + ":" + detail.getBarCode();
            Integer quantity = (Integer)packedSkuQMap.get(key);
            if (NullUtil.isNull((Object)quantity)) {
                packedSkuQMap.put(key, detail.getQuantity());
                continue;
            }
            packedSkuQMap.put(key, detail.getQuantity() + quantity);
        }
        WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
        whWmsHouseShelvesCond.setPhysicalWarehouseCode(connect.getPhysicalWarehouseCode());
        whWmsHouseShelvesCond.setHouseType("HOUSE_TYPE_HANDOVER");
        List<WhWmsHouseShelvesVO> hs = this.whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if (CollectionUtils.isEmpty(hs) || hs.size() > 1) {
            throw new WarehouseException("WMS0001", "\u6ca1\u6709\u5408\u9002\u7684\u76ee\u6807\u5e93\u4f4d,\u4ea4\u63a5\u533a");
        }
        WhWmsHouseShelvesVO updateShelvesVO = hs.get(0);
        for (String key : packedSkuQMap.keySet()) {
            String[] parts = key.split(":");
            if (parts.length != 2) {
                throw new WarehouseException("\u6253\u5305\u6570\u636e\u5f02\u5e38");
            }
            String skuCode = parts[0];
            String barCode = parts[1];
            Integer quantity = (Integer)packedSkuQMap.get(key);
            if (NullUtil.isNull((Object)quantity) || quantity <= 0) continue;
            this.whWmsSkuStockService.updateStockByCond(0 - quantity, updateShelvesVO.getPhysicalWarehouseCode(), updateShelvesVO.getHouseType(), barCode, updateShelvesVO.getCode(), skuCode, connect.getSkuStatus(), WhCommand.TYPE_ALLOT_OUT, connectId.toString(), operatorId, null, 1);
        }
    }

    List<WhCommand> filterShortageCommand(List<WhCommand> commandList) {
        ArrayList<WhCommand> shortageList = new ArrayList<WhCommand>();
        for (WhCommand command : commandList) {
            boolean shortage = true;
            for (WhCommandSku commandSku : command.getWhCommandSkuList()) {
                if (commandSku.getQuantity() <= 0 && commandSku.getDamagedQuantity() <= 0) continue;
                shortage = false;
                break;
            }
            if (!shortage) continue;
            shortageList.add(command);
        }
        return shortageList;
    }

    private void fullAltCommand(WhWmsConnectInfoVO connect, List<WhCommand> commandList, List<WhWmsConnectAllotPackageDetailVO> packedDetailList) {
        for (WhCommand whCommand : commandList) {
            for (WhCommandSku commandSku : whCommand.getWhCommandSkuList()) {
                commandSku.setQuantity(0);
                commandSku.setDamagedQuantity(0);
            }
        }
        Collections.sort(commandList, new Comparator<WhCommand>(){

            @Override
            public int compare(WhCommand o1, WhCommand o2) {
                if (NullUtil.isNull((Object)o1) || NullUtil.isNull((Object)o2)) {
                    return -1;
                }
                return -o1.getCreateTime().compareTo(o2.getCreateTime());
            }
        });
        HashMap<String, Integer> packedSkuQMap = new HashMap<String, Integer>();
        for (WhWmsConnectAllotPackageDetailVO detail : packedDetailList) {
            String key = detail.getSkuCode();
            Integer quantity = (Integer)packedSkuQMap.get(key);
            if (NullUtil.isNull((Object)quantity)) {
                packedSkuQMap.put(key, detail.getQuantity());
                continue;
            }
            packedSkuQMap.put(key, detail.getQuantity() + quantity);
        }
        Integer n = connect.getSkuStatus();
        for (WhCommand command : commandList) {
            for (WhCommandSku commandSku : command.getWhCommandSkuList()) {
                String skuCode = commandSku.getSkuCode();
                Integer packedQuantity = (Integer)packedSkuQMap.get(skuCode);
                if (NullUtil.isNull((Object)packedQuantity)) continue;
                Integer usedQuantity = 0;
                if (packedQuantity > 0 && packedQuantity > commandSku.getPlanedQuantity()) {
                    usedQuantity = commandSku.getPlanedQuantity();
                    packedSkuQMap.put(skuCode, packedQuantity - usedQuantity);
                } else {
                    usedQuantity = packedQuantity;
                    packedSkuQMap.put(skuCode, 0);
                }
                commandSku.setQuantity(usedQuantity);
            }
        }
    }

    private boolean checkConnectAltFinished(List<WhWmsConnectPickSkuVO> pickSkuList, List<WhWmsConnectAllotPackageDetailVO> detailList) {
        String key;
        if (EmptyUtil.isEmpty(pickSkuList)) {
            throw new WarehouseException("\u62e3\u8d27\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (EmptyUtil.isEmpty(detailList)) {
            return false;
        }
        HashMap<String, Integer> barCodeQMap = new HashMap<String, Integer>();
        for (WhWmsConnectPickSkuVO pickSku : pickSkuList) {
            key = pickSku.getBarCode();
            Integer pickQuantity = (Integer)barCodeQMap.get(key);
            if (NullUtil.isNull((Object)pickQuantity)) {
                barCodeQMap.put(key, pickSku.getActualAmount());
                continue;
            }
            barCodeQMap.put(key, pickQuantity + pickSku.getActualAmount());
        }
        for (WhWmsConnectAllotPackageDetailVO pDetail : detailList) {
            key = pDetail.getBarCode();
            Integer quantity = (Integer)barCodeQMap.get(key);
            if (NullUtil.isNull((Object)quantity)) {
                throw new WarehouseException("\u6279\u6b21\u4e0d\u5728\u62e3\u8d27\u5355\u4e2d:" + key);
            }
            barCodeQMap.put(key, quantity - pDetail.getQuantity());
        }
        for (String barCode : barCodeQMap.keySet()) {
            Integer quantity = (Integer)barCodeQMap.get(barCode);
            if (quantity > 0) {
                return false;
            }
            if (quantity >= 0) continue;
            throw new WarehouseException("WH0001", String.format("[%s]\u6570\u91cf\u8d85\u4e86[%d]", barCode, -quantity.intValue()));
        }
        return true;
    }

    private Boolean delConnectBox(Long connectId) {
        WhWmsConnectTurnoverBoxExample boxExample = new WhWmsConnectTurnoverBoxExample();
        boxExample.createCriteria().andConnectIdEqualTo(connectId);
        return this.boxMapper.deleteByExample(boxExample) != 0;
    }

    @Override
    public List<WhSkuInfoVO> findWaitOutStockCommandSkuByCond(WhWmsWaitOutStockCond cond) {
        cond.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
        if (NullUtil.isNull((Object)cond.getPhysicalWarehouseCode())) {
            return null;
        }
        return this.whCommandService.findWaitOutStockCommandSkuByCond(cond);
    }

    private void validateBeforeCreate(WhWmsConnectInfoVO vo) {
        if (vo.getConnectUserId() == null) {
            throw new WarehouseException("WH0002", "\u521b\u5efa\u4eba\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)vo.getConnectType())) {
            throw new WarehouseException("WH0002", "\u6ce2\u6b21\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (!WMSConstants.ConnectType.ALL.contains(vo.getConnectType())) {
            throw new WarehouseException("WH0002", "\u6ce2\u6b21\u7c7b\u578b\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185");
        }
    }

    private void validateCommandConnect(WhWmsConnectInfoVO vo) {
        int i;
        if (CollectionUtils.isEmpty(vo.getWhCommandsCodes())) {
            throw new WarehouseException("WH0002", "whCommandCodes\u4e3a\u7a7a");
        }
        for (i = 0; i < vo.getWhCommandsCodes().size(); ++i) {
            String cmdCode = vo.getWhCommandsCodes().get(i);
            if (cmdCode == null) {
                throw new WarehouseException("WH0002", "commandCode\u4e3a\u7a7a");
            }
            if (this.whWmsCommandConnectService.findNotCanceledByWhCommandCode(cmdCode) != null) {
                throw new WarehouseException("WH0002", "command[" + cmdCode + "] \u5df2\u7ecf\u542f\u52a8\u6ce2\u6b21");
            }
            WhCommand cmd = this.whCommandService.findCommandByCode(cmdCode, true);
            if (cmd == null) {
                throw new WarehouseException("WH0002", "command[" + cmdCode + "] \u5b9e\u4f53\u4e3a\u7a7a");
            }
            if (!cmd.getCommandStatus().equals(WhCommand.STATUS_IN_PROCESSING)) {
                throw new WarehouseException("WH0002", "command[" + cmdCode + "] status \u5fc5\u987b\u662f\u6267\u884c\u4e2d");
            }
            if (!WhCommand.getAllOutType().contains(cmd.getInOutType())) {
                throw new WarehouseException("WH0002", "command[" + cmdCode + "] type \u5fc5\u987b\u662f\u51fa\u5e93\u7c7b\u578b");
            }
            vo.getWhCommands().add(cmd);
        }
        Collections.sort(vo.getWhCommands(), new Comparator<WhCommand>(){

            @Override
            public int compare(WhCommand o1, WhCommand o2) {
                if (o1.getCreateTime() == null && o2.getCreateTime() == null) {
                    return 0;
                }
                if (o1.getCreateTime() == null) {
                    return 1;
                }
                if (o2.getCreateTime() == null) {
                    return -1;
                }
                return o1.getCreateTime().compareTo(o2.getCreateTime());
            }
        });
        for (i = 0; i < vo.getWhCommands().size(); ++i) {
            vo.getWhCommandsCodes().set(i, vo.getWhCommands().get(i).getCode());
        }
        CommandConnectStrategyContext context = new CommandConnectStrategyContext(vo);
        context.validate();
    }

    private void afterCreate(WhWmsConnectInfoVO vo) throws Exception {
        WhWmsOccupyVO cond = new WhWmsOccupyVO();
        cond.setReceiptsNo(vo.getId().toString());
        List<WhWmsOccupyVO> occupyVOList = this.whWmsOccupyService.getWmsOccupyByCond(cond);
        this.createConnectPickSkuByOccupy(vo, occupyVOList);
        if (EmptyUtil.isNotEmpty(vo.getWhCommandsCodes()) && vo.getWhCommands().get(0).getInOutType().equals(WhCommand.TYPE_ALLOT_OUT) && EmptyUtil.isEmpty(occupyVOList)) {
            WhWmsConnectAllotPackageVO packageVO = new WhWmsConnectAllotPackageVO();
            packageVO.setConnectId(vo.getId());
            packageVO.setOperatorId(vo.getConnectUserId());
            packageVO.setFocusFinish(true);
            this.submitConnectAltCheck(packageVO);
        }
    }

    private void createConnectPickSkuByOccupy(WhWmsConnectInfoVO vo, List<WhWmsOccupyVO> occupyVOList) {
        ArrayList<WhWmsConnectPickSkuVO> pickSkuVOList = new ArrayList<WhWmsConnectPickSkuVO>();
        for (WhWmsOccupyVO occupyVO : occupyVOList) {
            WhWmsConnectPickSkuVO connectPickSkuVO = new WhWmsConnectPickSkuVO();
            connectPickSkuVO.setConnectId(vo.getId());
            connectPickSkuVO.setSkuStatus(occupyVO.getSkuStatus());
            connectPickSkuVO.setSkuCode(occupyVO.getSkuCode());
            connectPickSkuVO.setBarCode(occupyVO.getBarCode());
            connectPickSkuVO.setShelvesCode(occupyVO.getOriShelvesCode());
            connectPickSkuVO.setNeedAmount(Math.abs(occupyVO.getAmount()));
            connectPickSkuVO.setActualAmount(0);
            pickSkuVOList.add(connectPickSkuVO);
        }
        this.whWmsConnectPickSkuService.batchCreate(pickSkuVOList);
    }

    private void afterCreatePcsRtnConnectInfo(WhWmsConnectInfoVO vo) throws Exception {
        WhWmsOccupyVO cond = new WhWmsOccupyVO();
        cond.setReceiptsNo(vo.getId().toString());
        List<WhWmsOccupyVO> occupyVOList = this.whWmsOccupyService.getWmsOccupyByCond(cond);
        this.createConnectPickSkuByOccupy(vo, occupyVOList);
        List<WhWmsConnectPickSkuVO> whWmsConnectPickSkuVOs = this.whWmsConnectPickSkuService.findByConnectId(vo.getId());
        vo.setWhWmsConnectPickSkuVOs(whWmsConnectPickSkuVOs);
        if (EmptyUtil.isNotEmpty(vo.getWhCommandsCodes()) && EmptyUtil.isEmpty(occupyVOList)) {
            if (NullUtil.isNotNull((Object)vo.getId())) {
                this.connectStatusTransform(vo.getId(), WMSConstants.ConnectStatus.WAITING_PROCESS, WMSConstants.ConnectStatus.FINISHED);
            }
            List<WhWmsCommandConnectVO> whWmsCommandConnectVOList = this.whWmsCommandConnectService.findNotCanceledByConnectId(vo.getId());
            ArrayList<String> commandCodes = new ArrayList<String>();
            for (WhWmsCommandConnectVO cmdConn : whWmsCommandConnectVOList) {
                commandCodes.add(cmdConn.getCommandCode());
            }
            List<WhCommand> commandList = this.whCommandService.findCommandByCodes(commandCodes, true);
            for (WhCommand command : commandList) {
                for (WhCommandSku commandSku : command.getWhCommandSkuList()) {
                    commandSku.setQuantity(0);
                    commandSku.setDamagedQuantity(0);
                }
            }
            for (WhCommand whCommand : commandList) {
                whCommand.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
                this.whCommandService.finishCommand(whCommand);
                this.whCommandService.updateCommandStatusById(whCommand.getId().intValue(), WhCommand.STATUS_DELIVERYCOMPLETION);
                this.whCommandService.cancelPurchaseRtnByWhCommand(whCommand);
            }
        }
    }

    private void afterCreateAltConnectInfo(WhWmsConnectInfoVO vo) throws Exception {
        WhWmsOccupyVO cond = new WhWmsOccupyVO();
        cond.setReceiptsNo(vo.getId().toString());
        List<WhWmsOccupyVO> occupyVOList = this.whWmsOccupyService.getWmsOccupyByCond(cond);
        this.createConnectPickSkuByOccupy(vo, occupyVOList);
        List<WhWmsConnectPickSkuVO> whWmsConnectPickSkuVOs = this.whWmsConnectPickSkuService.findByConnectId(vo.getId());
        vo.setWhWmsConnectPickSkuVOs(whWmsConnectPickSkuVOs);
    }

    @Override
    public List<WhWmsBoxNumber> findWmsBoxNumberByCond(WhWmsBoxNumberCond cond) {
        List<WhWmsBoxNumber> whWmsBoxNumbers = this.whWmsBoxNumberMapper.listBoxNumber(cond);
        if (CollectionUtils.isEmpty(whWmsBoxNumbers)) {
            return Collections.emptyList();
        }
        return whWmsBoxNumbers;
    }

    @Override
    public List<WhWmsBoxNumberVO> findSingleBoxNumberByCond(WhWmsBoxNumberCond cond) {
        WhWmsBoxNumberExample example = new WhWmsBoxNumberExample();
        WhWmsBoxNumberExample.Criteria criteria = example.createCriteria();
        if (cond.getPhysicalWarehouseCode() != null) {
            criteria.andPhysicalWarehouseCodeEqualTo(cond.getPhysicalWarehouseCode());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getBoxNumber())) {
            criteria.andBoxNumberLike(cond.getBoxNumber());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getBoxType()) && cond.getBoxType() != 0) {
            criteria.andBoxTypeEqualTo(cond.getBoxType());
        }
        example.setOrderByClause(" ID DESC " + cond.getCriteriaStr());
        List<WhWmsBoxNumber> whWmsBoxNumbers = this.whWmsBoxNumberMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(whWmsBoxNumbers)) {
            return Collections.emptyList();
        }
        ArrayList<WhWmsBoxNumberVO> vos = new ArrayList<WhWmsBoxNumberVO>(whWmsBoxNumbers.size());
        for (WhWmsBoxNumber whWmsBoxNumber : whWmsBoxNumbers) {
            WhWmsBoxNumberVO whWmsConnectInfoVO = (WhWmsBoxNumberVO)BeanUtil.buildFrom((Object)whWmsBoxNumber, WhWmsBoxNumberVO.class);
            vos.add(whWmsConnectInfoVO);
        }
        return vos;
    }

    @Override
    public Map<Integer, WhWmsConnectCountInfoVO> countUnfinishedConnect(String physicalWarehouseCode) {
        HashMap<Integer, WhWmsConnectCountInfoVO> map = new HashMap<Integer, WhWmsConnectCountInfoVO>();
        List<WhWmsConnectCountInfoVO> countInfoList = this.mapper.countUnfinishedConnect(physicalWarehouseCode);
        if (EmptyUtil.isNotEmpty(countInfoList)) {
            for (WhWmsConnectCountInfoVO countInfo : countInfoList) {
                map.put(countInfo.getType(), countInfo);
            }
        }
        return map;
    }

    @Override
    public boolean updateBoxNumber(WhWmsBoxNumberVO vo) {
        WhWmsBoxNumber whWmsBoxNumber = (WhWmsBoxNumber)BeanUtil.buildFrom((Object)vo, WhWmsBoxNumber.class);
        return this.whWmsBoxNumberMapper.updateByPrimaryKeySelective(whWmsBoxNumber) > 0;
    }

    @Override
    public WhWmsBoxNumberVO createBoxNumber(WhWmsBoxNumberVO vo) {
        WhWmsBoxNumber whWmsBoxNumber = (WhWmsBoxNumber)BeanUtil.buildFrom((Object)vo, WhWmsBoxNumber.class);
        whWmsBoxNumber.setCreateTime(DateUtil.getNow());
        if (EmptyUtil.isNotEmpty((String)whWmsBoxNumber.getBoxNumber())) {
            whWmsBoxNumber.setBoxNumber(null);
        }
        if (this.whWmsBoxNumberMapper.insert(whWmsBoxNumber) > 0) {
            WhPhysicalWarehouse whPhysicalWarehouse = this.whInfoService.findPhysicalWarehouseByCode(whWmsBoxNumber.getPhysicalWarehouseCode());
            if (NullUtil.isNull((Object)whPhysicalWarehouse) || EmptyUtil.isEmpty((String)whPhysicalWarehouse.getHouseNo())) {
                throw new WarehouseException("WH0001", String.format("[%s]\u4ed3\u5e93\u7f16\u53f7\u4e3a\u7a7a", whWmsBoxNumber.getPhysicalWarehouseCode()));
            }
            WhWmsBoxNumber newBoxNumber = new WhWmsBoxNumber(whWmsBoxNumber.getId(), whPhysicalWarehouse.getHouseNo() + whWmsBoxNumber.getBoxType() + whWmsBoxNumber.getId());
            if (this.whWmsBoxNumberMapper.updateByPrimaryKeySelective(newBoxNumber) > 0) {
                whWmsBoxNumber.setBoxNumber(newBoxNumber.getBoxNumber());
                return (WhWmsBoxNumberVO)BeanUtil.buildFrom((Object)whWmsBoxNumber, WhWmsBoxNumberVO.class);
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean createBoxNumber(WhWmsBoxNumber boxNumber) {
        return this.whWmsBoxNumberMapper.insert(boxNumber) > 0;
    }

    private class MultiProductMultiPieceCommandConnectStrategy
    extends AbstractCommandConnectStrategy {
        private MultiProductMultiPieceCommandConnectStrategy() {
        }

        @Override
        public boolean validate(CommandConnectStrategyContext context) {
            return true;
        }
    }

    private class MultiProductSinglePieceCommandConnectStrategy
    extends AbstractCommandConnectStrategy {
        private MultiProductSinglePieceCommandConnectStrategy() {
        }

        @Override
        public boolean validate(CommandConnectStrategyContext context) {
            for (WhCommand whCommand : context.whWmsConnectInfoVO.getWhCommands()) {
                if (whCommand.getWhCommandSkuList().size() > 1) {
                    throw new WarehouseException("WH0201", "\u591a\u54c1\u5355\u4ef6\u9a8c\u8bc1\u4e0d\u901a\u8fc7,command[" + whCommand.getCode() + "] sku \u79cd\u6570\u8d85\u8fc7\u4e00\u4e2a");
                }
                for (WhCommandSku whCommandSku : whCommand.getWhCommandSkuList()) {
                    if (whCommandSku.getPlanedQuantity() <= 1) continue;
                    throw new WarehouseException("WH0201", "\u591a\u54c1\u5355\u4ef6\u9a8c\u8bc1\u4e0d\u901a\u8fc7,command[" + whCommand.getCode() + "] sku \u6570\u91cf\u8d85\u8fc7\u4e00\u4e2a");
                }
            }
            return true;
        }
    }

    private class SingleProductSinglePieceCommandConnectStrategy
    extends AbstractCommandConnectStrategy {
        private SingleProductSinglePieceCommandConnectStrategy() {
        }

        @Override
        public boolean validate(CommandConnectStrategyContext context) {
            if (org.springframework.util.StringUtils.isEmpty((Object)context.whWmsConnectInfoVO.getSkuCode())) {
                throw new WarehouseException("WH0201", "\u5355\u54c1\u5355\u4ef6\u9a8c\u8bc1\u4e0d\u901a\u8fc7,skuCode \u4e3a\u7a7a");
            }
            HashMap<String, Integer> skus = new HashMap<String, Integer>();
            for (WhCommand whCommand : context.whWmsConnectInfoVO.getWhCommands()) {
                for (WhCommandSku whCommandSku : whCommand.getWhCommandSkuList()) {
                    if (whCommandSku.getPlanedQuantity() > 1) {
                        throw new WarehouseException("WH0201", "\u5355\u54c1\u5355\u4ef6\u9a8c\u8bc1\u4e0d\u901a\u8fc7,command[" + whCommand.getCode() + "] sku \u6570\u91cf\u8d85\u8fc7\u4e00\u4e2a");
                    }
                    if (skus.containsKey(whCommandSku.getSkuCode())) {
                        skus.put(whCommandSku.getSkuCode(), whCommandSku.getPlanedQuantity() + (Integer)skus.get(whCommandSku.getSkuCode()));
                        continue;
                    }
                    skus.put(whCommandSku.getSkuCode(), whCommandSku.getPlanedQuantity());
                }
            }
            if (skus.values().size() != 1) {
                throw new WarehouseException("WH0201", "\u5355\u54c1\u5355\u4ef6\u9a8c\u8bc1\u4e0d\u901a\u8fc7,commandSku \u4e0d\u662f\u5355\u54c1");
            }
            Set skuCodes = skus.keySet();
            for (String skuCode : skuCodes) {
                if (skuCode.equals(context.whWmsConnectInfoVO.getSkuCode())) continue;
                throw new WarehouseException("WH0201", "\u5355\u54c1\u5355\u4ef6\u9a8c\u8bc1\u4e0d\u901a\u8fc7,commandSku[" + skuCode + "] \u4e0d\u5339\u914d");
            }
            return true;
        }
    }

    private abstract class AbstractCommandConnectStrategy {
        private AbstractCommandConnectStrategy() {
        }

        public abstract boolean validate(CommandConnectStrategyContext var1);
    }

    private class CommandConnectStrategyContext {
        private WhWmsConnectInfoVO whWmsConnectInfoVO;
        private AbstractCommandConnectStrategy strategy;

        public CommandConnectStrategyContext(WhWmsConnectInfoVO whWmsConnectInfoVO) {
            this.whWmsConnectInfoVO = whWmsConnectInfoVO;
            if (whWmsConnectInfoVO.getConnectType().equals("single_product_single_piece")) {
                this.strategy = new SingleProductSinglePieceCommandConnectStrategy();
            } else if (whWmsConnectInfoVO.getConnectType().equals("multi_product_single_piece")) {
                this.strategy = new MultiProductSinglePieceCommandConnectStrategy();
            } else if (whWmsConnectInfoVO.getConnectType().equals("multi_product_multi_piece")) {
                this.strategy = new MultiProductMultiPieceCommandConnectStrategy();
            } else if (whWmsConnectInfoVO.getConnectType().equals("receive_waste")) {
                this.strategy = new MultiProductMultiPieceCommandConnectStrategy();
            } else {
                throw new WarehouseException("WH0002", "not found strategy");
            }
        }

        public void validate() {
            boolean result = this.strategy.validate(this);
        }
    }
}

