/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsCommandPreOccupyIdxMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectDistributionMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectDistribution;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectDistributionExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandConnectService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectDistributionService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectPickSkuService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsOperationRcdService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandCheckVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandConnectVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandDistributeInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectDistributeInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectDistributionVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsOperationRcdVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whWmsConnectDistributionService")
public class WhWmsConnectDistributionServiceImpl
implements WhWmsConnectDistributionService {
    @Autowired
    private WhWmsConnectDistributionMapper mapper;
    @Autowired
    private WhWmsConnectInfoService whWmsConnectInfoService;
    @Autowired
    private WhWmsConnectPickSkuService whWmsConnectPickSkuService;
    @Autowired
    private WhWmsCommandConnectService whWmsCommandConnectService;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;
    @Autowired
    private WhWmsCommandPreOccupyIdxMapper whWmsCommandPreOccupyIdxMapper;
    @Autowired
    private WhWmsOperationRcdService whWmsOperationRcdService;

    @Override
    public List<WhWmsConnectDistributionVO> create(List<WhWmsConnectDistributionVO> vos) {
        if (CollectionUtils.isEmpty(vos)) {
            throw new WarehouseException("WH0002");
        }
        HashSet<Long> connectIds = new HashSet<Long>();
        for (WhWmsConnectDistributionVO vo : vos) {
            connectIds.add(vo.getConnectId());
        }
        if (CollectionUtils.isEmpty(connectIds) || connectIds.size() > 1) {
            throw new WarehouseException("WH0002");
        }
        WhWmsConnectInfoVO connectVO = this.whWmsConnectInfoService.findById(vos.get(0).getConnectId());
        if (!connectVO.getConnectStatus().equals(WMSConstants.ConnectStatus.DISTRIBUTION)) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u5fc5\u987b\u662f\u5f85\u5206\u62e8\u72b6\u6001");
        }
        boolean reslut = this.whWmsConnectInfoService.connectStatusTransform(connectVO.getId(), WMSConstants.ConnectStatus.DISTRIBUTION, WMSConstants.ConnectStatus.FINISHED);
        if (!reslut) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u5fc5\u987b\u662f\u5f85\u5206\u62e8\u72b6\u6001");
        }
        this.whWmsConnectPickSkuService.deleteConnectBox(vos.get(0).getConnectId());
        for (WhWmsCommandConnectVO commandConnectVO : this.whWmsCommandConnectService.findNotCanceledByConnectId(vos.get(0).getConnectId())) {
            this.whCommandService.commandInDistributionToPacking(commandConnectVO.getCommandCode());
        }
        for (WhWmsConnectDistributionVO vo : vos) {
            vo.setSkuStatus(connectVO.getSkuStatus());
            this.create(vo);
        }
        return vos;
    }

    private void buildOperationRcdThenInsert(WhWmsConnectDistributionVO vo, Long operatorId) {
        WhWmsOperationRcdVO rcd = new WhWmsOperationRcdVO();
        rcd.setReferenceCode(vo.getId().toString());
        rcd.setOperateType(WhWmsOperationRcdVO.OPERATOR_TYPE_DISTRIBUTION);
        rcd.setCommandCode(vo.getCommandCode());
        rcd.setOperatorId(operatorId);
        rcd.setOperateTime(DateUtil.getNow());
        this.whWmsOperationRcdService.insert(rcd);
    }

    @Override
    @Transactional
    public List<WhWmsConnectDistributionVO> create(List<WhWmsConnectDistributionVO> vos, Long operatorId) {
        List<WhWmsConnectDistributionVO> result = this.create(vos);
        if (EmptyUtil.isNotEmpty(result)) {
            HashMap<String, String> commandMap = new HashMap<String, String>();
            for (WhWmsConnectDistributionVO vo : result) {
                if (!NullUtil.isNull(commandMap.get(vo.getCommandCode()))) continue;
                commandMap.put(vo.getCommandCode(), vo.getCommandCode());
                this.buildOperationRcdThenInsert(vo, operatorId);
            }
        }
        return result;
    }

    @Override
    @Transactional
    public boolean connectDistribute(WhWmsConnectDistributeInfoVO connectDistributeInfo) {
        boolean reslut = this.whWmsConnectInfoService.connectStatusTransform(connectDistributeInfo.getConnectId(), WMSConstants.ConnectStatus.DISTRIBUTION, WMSConstants.ConnectStatus.FINISHED);
        if (!reslut) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u5fc5\u987b\u662f\u5f85\u5206\u62e8\u72b6\u6001");
        }
        this.whWmsConnectPickSkuService.deleteConnectBox(connectDistributeInfo.getConnectId());
        List<WhWmsCommandDistributeInfoVO> commandDistributeInfoList = connectDistributeInfo.getCommandDistributeList();
        ArrayList<String> commandDistributionToPackings = new ArrayList<String>();
        if (EmptyUtil.isNotEmpty(commandDistributeInfoList)) {
            ArrayList<WhWmsConnectDistributionVO> distributeList = new ArrayList<WhWmsConnectDistributionVO>();
            for (WhWmsCommandDistributeInfoVO commandDistributeInfo : commandDistributeInfoList) {
                commandDistributionToPackings.add(commandDistributeInfo.getCommandCode());
                distributeList.addAll(commandDistributeInfo.getDistributeList());
            }
            this.whCommandService.batchUpdateCommandStatus(commandDistributionToPackings, WhCommand.STATUS_PACKING, WhCommand.STATUS_DISTRIBUTION);
            for (WhWmsConnectDistributionVO vo : distributeList) {
                this.create(vo);
                this.buildOperationRcdThenInsert(vo, connectDistributeInfo.getOperatorId());
            }
        }
        if (EmptyUtil.isNotEmpty(connectDistributeInfo.getShortageCommandCodes())) {
            this.whCommandService.failureStartConnect(connectDistributeInfo.getShortageCommandCodes());
            this.whCommandService.batchUpdateCommandStatus(connectDistributeInfo.getShortageCommandCodes(), WhCommand.STATUS_IN_PROCESSING, WhCommand.STATUS_DISTRIBUTION);
            this.whWmsCommandConnectService.batchCancel(connectDistributeInfo.getShortageCommandCodes(), connectDistributeInfo.getConnectId());
            this.whWmsCommandPreOccupyIdxMapper.batchDelete(connectDistributeInfo.getShortageCommandCodes());
        }
        if (EmptyUtil.isNotEmpty(connectDistributeInfo.getMoveStockList())) {
            for (WhWmsMoveStockVO moveStock : connectDistributeInfo.getMoveStockList()) {
                if (NullUtil.isNull((Object)moveStock)) continue;
                if (moveStock.isAutoFinish()) {
                    this.whWmsMoveStockService.executeMoveStock(moveStock);
                } else {
                    this.whWmsMoveStockService.createMoveStock(moveStock);
                }
                if (!WhWmsMoveStockVO.MOVE_TYPE_CANCEL_MAKE.equals(moveStock.getMoveType())) continue;
                connectDistributeInfo.setToCancelMoveCode(moveStock.getCode());
            }
        }
        return true;
    }

    @Transactional
    private WhWmsConnectDistributionVO create(WhWmsConnectDistributionVO vo) {
        WhWmsConnectDistribution whWmsConnectDistribution = (WhWmsConnectDistribution)BeanUtil.buildFrom((Object)vo, WhWmsConnectDistribution.class);
        this.mapper.insert(whWmsConnectDistribution);
        vo.setId(whWmsConnectDistribution.getId());
        return vo;
    }

    @Override
    public Boolean update(WhWmsConnectDistributionVO vo) {
        return this.mapper.updateByPrimaryKeySelective((WhWmsConnectDistribution)BeanUtil.buildFrom((Object)vo, WhWmsConnectDistribution.class)) != 0;
    }

    @Override
    @Transactional
    public boolean deleteConnectDistribution(Long connectId, String commandCode) {
        WhWmsConnectDistributionExample distributionExample = new WhWmsConnectDistributionExample();
        distributionExample.createCriteria().andConnectIdEqualTo(connectId).andCommandCodeEqualTo(commandCode);
        WhWmsConnectDistribution whWmsConnectDistribution = new WhWmsConnectDistribution();
        whWmsConnectDistribution.setCancelFlag(1);
        int count = this.mapper.updateByExampleSelective(whWmsConnectDistribution, distributionExample);
        return true;
    }

    @Override
    @Transactional
    public boolean batchDeleteConnectDistribution(Long connectId, List<String> commandCodes) {
        WhWmsConnectDistributionExample distributionExample = new WhWmsConnectDistributionExample();
        distributionExample.createCriteria().andConnectIdEqualTo(connectId).andCommandCodeIn((List)commandCodes);
        WhWmsConnectDistribution whWmsConnectDistribution = new WhWmsConnectDistribution();
        whWmsConnectDistribution.setCancelFlag(1);
        int count = this.mapper.updateByExampleSelective(whWmsConnectDistribution, distributionExample);
        if (count == 0) {
            this.whWmsConnectPickSkuService.deleteConnectBox(connectId);
        }
        return true;
    }

    @Override
    public WhWmsConnectDistributionVO findById(Long id) {
        WhWmsConnectDistribution whWmsConnectDistribution = this.mapper.selectByPrimaryKey(id);
        if (whWmsConnectDistribution != null) {
            return (WhWmsConnectDistributionVO)BeanUtil.buildFrom((Object)whWmsConnectDistribution, WhWmsConnectDistributionVO.class);
        }
        return null;
    }

    @Override
    public Map<String, List<String>> findPackageDistributionBoxNo(List<Long> commandIdList, List<String> commandCodeList) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        List<WhWmsConnectDistribution> list = this.mapper.findPackageDistributionBoxNo(commandIdList, commandCodeList);
        if (list != null && list.size() > 0) {
            for (WhWmsConnectDistribution whWmsConnectDistribution : list) {
                ArrayList<String> packageCodeList = (ArrayList<String>)map.get(whWmsConnectDistribution.getCommandCode());
                if (packageCodeList == null) {
                    packageCodeList = new ArrayList<String>();
                }
                packageCodeList.add(whWmsConnectDistribution.getDistributionCode());
                map.put(whWmsConnectDistribution.getCommandCode(), packageCodeList);
            }
        }
        return map;
    }

    @Override
    public List<WhWmsConnectDistributionVO> findByCond(WhWmsConnectDistributionVO cond) {
        WhWmsConnectDistributionExample example = new WhWmsConnectDistributionExample();
        WhWmsConnectDistributionExample.Criteria criteria = example.createCriteria();
        if (cond.getConnectId() != null) {
            criteria.andConnectIdEqualTo(cond.getConnectId());
        }
        if (cond.getDistributionCode() != null) {
            criteria.andDistributionCodeEqualTo(cond.getDistributionCode());
        }
        if (cond.getCancelFlag() != null) {
            criteria.andCancelFlagEqualTo(cond.getCancelFlag());
        }
        if (cond.getCommandCode() != null) {
            criteria.andCommandCodeEqualTo(cond.getCommandCode());
        } else if (CollectionUtils.isNotEmpty(cond.getCommandCodes())) {
            criteria.andCommandCodeIn((List)cond.getCommandCodes());
        }
        List<WhWmsConnectDistribution> whWmsConnectDistributions = this.mapper.selectByExample(example);
        if (CollectionUtils.isEmpty(whWmsConnectDistributions)) {
            return Collections.emptyList();
        }
        ArrayList<WhWmsConnectDistributionVO> vos = new ArrayList<WhWmsConnectDistributionVO>(whWmsConnectDistributions.size());
        for (WhWmsConnectDistribution whWmsConnectDistribution : whWmsConnectDistributions) {
            WhWmsConnectDistributionVO whWmsConnectDistributionVO = (WhWmsConnectDistributionVO)BeanUtil.buildFrom((Object)whWmsConnectDistribution, WhWmsConnectDistributionVO.class);
            vos.add(whWmsConnectDistributionVO);
        }
        return vos;
    }

    @Override
    public boolean checkConnectDistribution(Long connectId, String commandCode, List<WhWmsCommandCheckVO> paras) {
        WhWmsConnectDistributionExample example = new WhWmsConnectDistributionExample();
        WhWmsConnectDistributionExample.Criteria criteria = example.createCriteria();
        criteria.andConnectIdEqualTo(connectId);
        criteria.andCommandCodeEqualTo(commandCode);
        criteria.andCancelFlagEqualTo(0);
        List<WhWmsConnectDistribution> whWmsConnectDistributions = this.mapper.selectByExample(example);
        if (CollectionUtils.isEmpty(whWmsConnectDistributions)) {
            throw new WarehouseException("WH0001", "\u627e\u4e0d\u5230cmd\u5206\u62e8\u6570\u636e");
        }
        for (WhWmsConnectDistribution whWmsConnectDistribution : whWmsConnectDistributions) {
            for (WhWmsCommandCheckVO para : paras) {
                if (!whWmsConnectDistribution.getSkuCode().equals(para.getSkuCode()) || !whWmsConnectDistribution.getBarCode().equals(para.getBarCode())) continue;
                whWmsConnectDistribution.setCheckAmount(para.getCheckAmount());
            }
        }
        StringBuilder sb = new StringBuilder("");
        for (WhWmsConnectDistribution cd : whWmsConnectDistributions) {
            if (cd.getDistributAmount().equals(cd.getCheckAmount())) continue;
            sb.append("skucode:");
            sb.append(cd.getSkuCode());
            sb.append(",barcode:");
            sb.append(cd.getBarCode());
            sb.append(",\u5206\u62e8\u6570:");
            sb.append(cd.getDistributAmount());
            sb.append(",\u5b9e\u9645\u5206\u62e8\u6570:");
            sb.append(cd.getCheckAmount());
            sb.append("\n");
        }
        String string = sb.toString();
        if (EmptyUtil.isNotEmpty((String)string)) {
            throw new WarehouseException("WH0001", "\u5206\u62e8\u6570\u636ebarcode\u5339\u914d\u4e0d\u4e0a\r\n" + string);
        }
        return true;
    }

    @Override
    public List<WhWmsConnectDistribution> cancelCheckConnectDistribution(Long connectId, String commandCode, List<WhWmsCommandCheckVO> paras) {
        WhWmsConnectDistributionExample example = new WhWmsConnectDistributionExample();
        WhWmsConnectDistributionExample.Criteria criteria = example.createCriteria();
        criteria.andConnectIdEqualTo(connectId);
        criteria.andCommandCodeEqualTo(commandCode);
        criteria.andCancelFlagEqualTo(0);
        List<WhWmsConnectDistribution> whWmsConnectDistributions = this.mapper.selectByExample(example);
        if (CollectionUtils.isEmpty(whWmsConnectDistributions)) {
            throw new WarehouseException("WH0001", "\u627e\u4e0d\u5230cmd\u5206\u62e8\u6570\u636e");
        }
        for (WhWmsConnectDistribution cd : whWmsConnectDistributions) {
            for (WhWmsCommandCheckVO para : paras) {
                if (!cd.getSkuCode().equals(para.getSkuCode()) || !cd.getBarCode().equals(para.getBarCode())) continue;
                cd.setCheckAmount(para.getCheckAmount());
            }
        }
        return whWmsConnectDistributions;
    }

    @Override
    public boolean checkBoxNo(String code) {
        WhWmsConnectDistributionExample example = new WhWmsConnectDistributionExample();
        WhWmsConnectDistributionExample.Criteria criteria = example.createCriteria();
        criteria.andDistributionCodeEqualTo(code);
        criteria.andCancelFlagEqualTo(0);
        List<WhWmsConnectDistribution> whWmsConnectDistributions = this.mapper.selectByExample(example);
        return !CollectionUtils.isNotEmpty(whWmsConnectDistributions);
    }
}

