/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhAllotCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhConnectAltPackageCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsCommandConnectCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectAllotPackageDetailMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectAllotPackageMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectAllotPackage;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectAllotPackageDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectAllotPackageDetailExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectAllotPackageExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhAllotService;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandConnectService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectAllotPackageService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectInfoService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandConnectVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectAllotPackageDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectAllotPackageVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectInfoVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Service(value="whWmsConnectAllotPackageService")
public class WhWmsConnectAllotPackageServiceImpl
implements WhWmsConnectAllotPackageService {
    @Autowired
    private WhWmsConnectAllotPackageMapper whWmsConnectAllotPackageMapper;
    @Autowired
    private WhWmsConnectAllotPackageDetailMapper whWmsConnectAllotPackageDetailMapper;
    @Autowired
    private WhWmsConnectInfoService whWmsConnectInfoService;
    @Autowired
    private WhWmsCommandConnectService whWmsCommandConnectService;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhAllotService whAllotService;

    @Override
    public void add(WhWmsConnectAllotPackageVO vo) {
        if (EmptyUtil.isEmpty(vo.getDetails())) {
            return;
        }
        if (NullUtil.isNull((Object)vo.getStatus())) {
            vo.setStatus(WhWmsConnectAllotPackageVO.STATUS_WAITING_RECEIVE);
        }
        WhWmsConnectAllotPackageExample example = new WhWmsConnectAllotPackageExample();
        example.createCriteria().andConnectIdEqualTo(vo.getConnectId());
        List<WhWmsConnectAllotPackage> packageList = this.whWmsConnectAllotPackageMapper.selectByExample(example);
        String code = null;
        code = EmptyUtil.isEmpty(packageList) ? this.getCode(vo.getConnectId(), 1) : this.getCode(vo.getConnectId(), packageList.size() + 1);
        vo.setCode(code);
        this.whWmsConnectAllotPackageMapper.insert(vo);
        if (EmptyUtil.isNotEmpty(vo.getDetails())) {
            for (WhWmsConnectAllotPackageDetailVO detailVO : vo.getDetails()) {
                detailVO.setConnectAllotPackageId(vo.getId());
                detailVO.setConnectAllotPackageCode(vo.getCode());
                this.whWmsConnectAllotPackageDetailMapper.insert(detailVO);
            }
        }
    }

    @Override
    public WhWmsConnectAllotPackageVO findById(Long id) {
        WhWmsConnectAllotPackageExample example = new WhWmsConnectAllotPackageExample();
        example.createCriteria().andIdEqualTo(id);
        List<WhWmsConnectAllotPackage> packageList = this.whWmsConnectAllotPackageMapper.selectByExample(example);
        if (EmptyUtil.isEmpty(packageList)) {
            return null;
        }
        WhWmsConnectAllotPackageVO vo = (WhWmsConnectAllotPackageVO)BeanUtil.buildFrom((Object)packageList.get(0), WhWmsConnectAllotPackageVO.class);
        WhWmsConnectAllotPackageDetailExample de = new WhWmsConnectAllotPackageDetailExample();
        de.createCriteria().andConnectAllotPackageIdEqualTo(id);
        List<WhWmsConnectAllotPackageDetail> details = this.whWmsConnectAllotPackageDetailMapper.selectByExample(de);
        if (EmptyUtil.isNotEmpty(details)) {
            List detailVOs = BeanUtil.buildListFrom(details, WhWmsConnectAllotPackageDetailVO.class);
            vo.setDetails(detailVOs);
        }
        return vo;
    }

    @Override
    public List<WhWmsConnectAllotPackageVO> findByConnectId(Long connectId) {
        WhWmsConnectAllotPackageExample example = new WhWmsConnectAllotPackageExample();
        example.createCriteria().andConnectIdEqualTo(connectId);
        List<WhWmsConnectAllotPackage> packageList = this.whWmsConnectAllotPackageMapper.selectByExample(example);
        if (EmptyUtil.isEmpty(packageList)) {
            return new ArrayList<WhWmsConnectAllotPackageVO>();
        }
        List packageVOs = BeanUtil.buildListFrom(packageList, WhWmsConnectAllotPackageVO.class);
        ArrayList<Long> packageIds = new ArrayList<Long>();
        for (WhWmsConnectAllotPackageVO vo : packageVOs) {
            packageIds.add(vo.getId());
        }
        WhWmsConnectAllotPackageDetailExample de = new WhWmsConnectAllotPackageDetailExample();
        de.createCriteria().andConnectAllotPackageIdIn(packageIds);
        List<WhWmsConnectAllotPackageDetail> details = this.whWmsConnectAllotPackageDetailMapper.selectByExample(de);
        if (EmptyUtil.isNotEmpty(details)) {
            List detailVOs = BeanUtil.buildListFrom(details, WhWmsConnectAllotPackageDetailVO.class);
            HashMap<Long, ArrayList<WhWmsConnectAllotPackageDetailVO>> pakcageDetailMap = new HashMap<Long, ArrayList<WhWmsConnectAllotPackageDetailVO>>();
            for (WhWmsConnectAllotPackageDetailVO detailVO : detailVOs) {
                ArrayList<WhWmsConnectAllotPackageDetailVO> tmpList = (ArrayList<WhWmsConnectAllotPackageDetailVO>)pakcageDetailMap.get(detailVO.getConnectAllotPackageId());
                if (NullUtil.isNull((Object)tmpList)) {
                    tmpList = new ArrayList<WhWmsConnectAllotPackageDetailVO>();
                    pakcageDetailMap.put(detailVO.getConnectAllotPackageId(), tmpList);
                }
                tmpList.add(detailVO);
            }
            for (WhWmsConnectAllotPackageVO vo : packageVOs) {
                List detailList = (List)pakcageDetailMap.get(vo.getId());
                if (!NullUtil.isNotNull((Object)detailList)) continue;
                vo.setDetails(detailList);
            }
        }
        return packageVOs;
    }

    @Override
    public Pagination<WhWmsConnectAllotPackageVO> findByCond(WhConnectAltPackageCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        Integer counts = this.whWmsConnectAllotPackageMapper.CountByCond(cond);
        page.setRecord(counts);
        if (NumberUtil.isNullOrZero((Number)counts)) {
            return page;
        }
        List<WhWmsConnectAllotPackageVO> packageVOs = this.findConnectAltPackageList(cond);
        page.setResultList(packageVOs);
        return page;
    }

    @Override
    public List<WhWmsConnectAllotPackageVO> findConnectAltPackageList(WhConnectAltPackageCond cond) {
        List<WhWmsConnectAllotPackageVO> packageVOs = this.whWmsConnectAllotPackageMapper.findByCond(cond);
        if (EmptyUtil.isEmpty(packageVOs)) {
            return packageVOs;
        }
        if (cond.isFetch() || cond.isFetchAllot()) {
            ArrayList<Long> packageIds = new ArrayList<Long>();
            ArrayList<Long> connectIds = new ArrayList<Long>();
            for (WhWmsConnectAllotPackageVO vo : packageVOs) {
                packageIds.add(vo.getId());
                connectIds.add(vo.getConnectId());
            }
            Map<Long, List<WhWmsConnectAllotPackageDetailVO>> pakcageDetailMap = this.mapConnectAllotPackageDetailByIds(packageIds, cond.isFetch());
            Map<Long, WhAllotRcd> connectAllotMap = this.mapConnectAllotByConnectIds(connectIds, cond.isFetchAllot());
            for (WhWmsConnectAllotPackageVO vo : packageVOs) {
                WhAllotRcd whAllotRcdTmp;
                List<WhWmsConnectAllotPackageDetailVO> detailList;
                if (cond.isFetch() && pakcageDetailMap.size() > 0 && NullUtil.isNotNull(detailList = pakcageDetailMap.get(vo.getId()))) {
                    vo.setDetails(detailList);
                }
                if (!cond.isFetchAllot() || connectAllotMap.size() <= 0 || !EmptyUtil.isNotEmpty((Object)(whAllotRcdTmp = connectAllotMap.get(vo.getConnectId())))) continue;
                vo.setAllotCode(whAllotRcdTmp.getCode());
                vo.setAllotRemark(whAllotRcdTmp.getRemark());
            }
        }
        return packageVOs;
    }

    private Map<Long, WhAllotRcd> mapConnectAllotByConnectIds(List<Long> connectIds, boolean fetchAllot) {
        HashMap<Long, WhAllotRcd> connectAllotMap = new HashMap<Long, WhAllotRcd>();
        if (fetchAllot) {
            WhWmsCommandConnectCond commandConnectCond = new WhWmsCommandConnectCond();
            commandConnectCond.setConnectIds(connectIds);
            commandConnectCond.setCancelFlag(0);
            List<WhWmsCommandConnectVO> commandConnectVOs = this.whWmsCommandConnectService.findByCond(commandConnectCond);
            if (CollectionUtils.isNotEmpty(commandConnectVOs)) {
                ArrayList<String> commandCodes = new ArrayList<String>();
                for (WhWmsCommandConnectVO commandConnectVO : commandConnectVOs) {
                    commandCodes.add(commandConnectVO.getCommandCode());
                }
                final Map<String, String> commandMap = this.whCommandService.findReferenceCodesByCommdCodes(commandCodes);
                WhAllotCond allotCond = new WhAllotCond();
                allotCond.setCodes((List<String>)new ArrayList<String>(){
                    {
                        this.addAll(commandMap.values());
                    }
                });
                List<WhAllotRcd> whAllotRcds = this.whAllotService.selectAllotRcdByCond(allotCond);
                if (CollectionUtils.isNotEmpty(whAllotRcds)) {
                    HashMap<String, WhAllotRcd> allotRcdMap = new HashMap<String, WhAllotRcd>();
                    for (WhAllotRcd allotRcd : whAllotRcds) {
                        allotRcdMap.put(allotRcd.getCode(), allotRcd);
                    }
                    HashMap commandAllotMap = new HashMap();
                    for (Map.Entry<String, String> entry : commandMap.entrySet()) {
                        commandAllotMap.put(entry.getKey(), allotRcdMap.get(entry.getValue()));
                    }
                    for (WhWmsCommandConnectVO commandConnectVO : commandConnectVOs) {
                        connectAllotMap.put(commandConnectVO.getConnectId(), (WhAllotRcd)commandAllotMap.get(commandConnectVO.getCommandCode()));
                    }
                }
            }
        }
        return connectAllotMap;
    }

    private Map<Long, List<WhWmsConnectAllotPackageDetailVO>> mapConnectAllotPackageDetailByIds(List<Long> packageIds, boolean fetch) {
        HashMap<Long, List<WhWmsConnectAllotPackageDetailVO>> pakcageDetailMap = new HashMap<Long, List<WhWmsConnectAllotPackageDetailVO>>();
        if (fetch) {
            WhWmsConnectAllotPackageDetailExample de = new WhWmsConnectAllotPackageDetailExample();
            de.createCriteria().andConnectAllotPackageIdIn((List)packageIds);
            List<WhWmsConnectAllotPackageDetail> details = this.whWmsConnectAllotPackageDetailMapper.selectByExample(de);
            if (EmptyUtil.isNotEmpty(details)) {
                List detailVOs = BeanUtil.buildListFrom(details, WhWmsConnectAllotPackageDetailVO.class);
                for (WhWmsConnectAllotPackageDetailVO detailVO : detailVOs) {
                    ArrayList<WhWmsConnectAllotPackageDetailVO> tmpList = (ArrayList<WhWmsConnectAllotPackageDetailVO>)pakcageDetailMap.get(detailVO.getConnectAllotPackageId());
                    if (NullUtil.isNull((Object)tmpList)) {
                        tmpList = new ArrayList<WhWmsConnectAllotPackageDetailVO>();
                        pakcageDetailMap.put(detailVO.getConnectAllotPackageId(), tmpList);
                    }
                    tmpList.add(detailVO);
                }
            }
        }
        return pakcageDetailMap;
    }

    @Override
    public WhWmsConnectAllotPackageVO findConnectAltPackage(String allotPackageCode) {
        WhConnectAltPackageCond cond = new WhConnectAltPackageCond();
        cond.setCode(allotPackageCode);
        cond.setFetch(true);
        List<WhWmsConnectAllotPackageVO> list = this.findConnectAltPackageList(cond);
        if (EmptyUtil.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    @Transactional
    public boolean splitAllotPackage(WhWmsConnectAllotPackageVO allotPackage) {
        if (NullUtil.isNull((Object)allotPackage.getSourceAltPackageId()) || EmptyUtil.isEmpty(allotPackage.getDetails())) {
            throw new WarehouseException("WH0001", "\u53c2\u6570\u5f02\u5e38");
        }
        WhWmsConnectAllotPackageVO sourcePackageInfo = this.findById(allotPackage.getSourceAltPackageId());
        if (NullUtil.isNull((Object)sourcePackageInfo)) {
            throw new WarehouseException("WH0001", "\u6e90\u8c03\u62e8\u7bb1\u4e0d\u5b58\u5728\uff01");
        }
        WhWmsConnectInfoVO connectInfo = this.whWmsConnectInfoService.findById(sourcePackageInfo.getConnectId());
        HashMap<Long, WhWmsConnectAllotPackageDetailVO> sourcePackageDetailMap = new HashMap<Long, WhWmsConnectAllotPackageDetailVO>();
        for (WhWmsConnectAllotPackageDetailVO sourceDetail : sourcePackageInfo.getDetails()) {
            sourcePackageDetailMap.put(sourceDetail.getId(), sourceDetail);
        }
        allotPackage.setPackageTime(DateUtil.getNow());
        allotPackage.setConnectId(sourcePackageInfo.getConnectId());
        allotPackage.setOperatorId(allotPackage.getOperatorId());
        allotPackage.setSourcePhysicalWarehouseCode(sourcePackageInfo.getSourcePhysicalWarehouseCode());
        allotPackage.setSourceWarehouseCode(sourcePackageInfo.getSourceWarehouseCode());
        allotPackage.setTargetPhysicalWarehouseCode(sourcePackageInfo.getTargetPhysicalWarehouseCode());
        allotPackage.setTargetWarehouseCode(sourcePackageInfo.getTargetWarehouseCode());
        ArrayList<WhWmsConnectAllotPackageDetailVO> sourceSplitDetailList = new ArrayList<WhWmsConnectAllotPackageDetailVO>();
        for (WhWmsConnectAllotPackageDetailVO detail : allotPackage.getDetails()) {
            WhWmsConnectAllotPackageDetailVO sourceDetail = (WhWmsConnectAllotPackageDetailVO)sourcePackageDetailMap.get(detail.getId());
            if (NullUtil.isNull((Object)sourceDetail)) {
                throw new WarehouseException("WH0001", "\u62c6\u5206\u6570\u636e\u5f02\u5e38");
            }
            if (sourceDetail.getQuantity() < detail.getQuantity()) {
                throw new WarehouseException("WH0001", String.format("[%s]\u62c6\u5206\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u539f\u88c5\u7bb1\u5355\u6570\u91cf", sourceDetail.getBarCode()));
            }
            sourceDetail.setQuantity(sourceDetail.getQuantity() - detail.getQuantity());
            sourceSplitDetailList.add(sourceDetail);
        }
        for (WhWmsConnectAllotPackageDetailVO sourceDetail : sourceSplitDetailList) {
            this.whWmsConnectAllotPackageDetailMapper.updateByPrimaryKeySelective(sourceDetail);
        }
        if (this.isEmptyAltPackage(sourcePackageInfo)) {
            sourcePackageInfo.setStatus(WhWmsConnectAllotPackageVO.STATUS_RECEIVED);
            this.updateCnnectAltPackage(sourcePackageInfo);
        }
        this.add(allotPackage);
        return true;
    }

    private boolean isEmptyAltPackage(WhWmsConnectAllotPackageVO altPackage) {
        if (EmptyUtil.isNotEmpty(altPackage.getDetails())) {
            for (WhWmsConnectAllotPackageDetailVO detail : altPackage.getDetails()) {
                if (detail.getQuantity() == 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Transactional
    public boolean updateCnnectAltPackage(WhWmsConnectAllotPackageVO altPackage) {
        this.whWmsConnectAllotPackageMapper.updateByPrimaryKeySelective(altPackage);
        return true;
    }

    @Override
    public List<WhWmsConnectAllotPackageVO> findMinEstimatedAllocationDate(List<Long> packageIdList) {
        return this.whWmsConnectAllotPackageMapper.findMinEstimatedAllocationDate(packageIdList);
    }

    @Override
    public WhWmsConnectAllotPackageVO findConnectBoxsByCond(WhConnectAltPackageCond cond) {
        WhWmsConnectAllotPackageVO packageVOs = this.whWmsConnectAllotPackageMapper.findConnectBoxsByCond(cond);
        return packageVOs;
    }

    @Override
    public List<WhWmsConnectAllotPackageVO> findAllotTypeByByCond(WhConnectAltPackageCond cond) {
        List<WhWmsConnectAllotPackageVO> packageVOs = this.whWmsConnectAllotPackageMapper.findAllotTypeByByCond(cond);
        return packageVOs;
    }

    private String getCode(Long connectId, int num) {
        int size;
        StringBuilder buff = new StringBuilder(connectId.toString());
        for (int i = size = new StringBuilder().append(num).append("").toString().length(); i < 3; ++i) {
            buff.append(0);
        }
        buff.append(num);
        return buff.toString();
    }

    @Override
    public List<WhWmsConnectAllotPackageDetailVO> findConnectAltPackageDetailsByConnectId(Long connectId) {
        WhWmsConnectAllotPackageDetailExample de = new WhWmsConnectAllotPackageDetailExample();
        de.createCriteria().andConnectIdEqualTo(connectId);
        List<WhWmsConnectAllotPackageDetail> details = this.whWmsConnectAllotPackageDetailMapper.selectByExample(de);
        if (EmptyUtil.isNotEmpty(details)) {
            return BeanUtil.buildListFrom(details, WhWmsConnectAllotPackageDetailVO.class);
        }
        return null;
    }

    @Override
    public boolean associateExpress(WhWmsConnectAllotPackageVO vo) {
        WhWmsConnectAllotPackageVO update = new WhWmsConnectAllotPackageVO();
        update.setId(vo.getId());
        update.setExpressNo(vo.getExpressNo());
        update.setExpressType(vo.getExpressType());
        this.whWmsConnectAllotPackageMapper.updateByPrimaryKeySelective(update);
        return true;
    }
}

