/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsConnectActiveRuleCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectActivityRuleDetailMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectActivityRuleMapper;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectActivityRuleDetailExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectActivityRuleService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectActivityRuleDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectActivityRuleVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Service(value="whWmsConnectActivityRuleService")
public class WhWmsConnectActivityRuleServiceImpl
implements WhWmsConnectActivityRuleService {
    @Autowired
    private WhWmsConnectActivityRuleMapper whWmsConnectActivityRuleMapper;
    @Autowired
    private WhWmsConnectActivityRuleDetailMapper whWmsConnectActivityRuleDetailMapper;

    @Override
    public List<WhWmsConnectActivityRuleVO> findConnectActivityRuleByCond(WhWmsConnectActiveRuleCond cond, boolean cascade) {
        List<WhWmsConnectActivityRuleVO> ruleList = this.whWmsConnectActivityRuleMapper.findConnectActivityRuleByCond(cond);
        if (EmptyUtil.isEmpty(ruleList) || !cascade) {
            return ruleList;
        }
        this.fullCascade(ruleList);
        return ruleList;
    }

    @Override
    public Pagination<WhWmsConnectActivityRuleVO> findConnectActivityRuleByCondPage(WhWmsConnectActiveRuleCond cond, boolean cascade) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int total = this.whWmsConnectActivityRuleMapper.countConnectActivityRuleByCond(cond);
        page.setRecord(Integer.valueOf(total));
        if (!NumberUtil.isNullOrZero((Number)total)) {
            page.setResultList(this.findConnectActivityRuleByCond(cond, cascade));
        }
        return page;
    }

    @Override
    public WhWmsConnectActivityRuleVO findConnectActivityRule(Long ruleId) {
        WhWmsConnectActiveRuleCond cond = new WhWmsConnectActiveRuleCond();
        cond.setId(ruleId);
        List<WhWmsConnectActivityRuleVO> list = this.findConnectActivityRuleByCond(cond, true);
        if (EmptyUtil.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    @Transactional
    public boolean saveConnectActivityRule(WhWmsConnectActivityRuleVO ruleVO) {
        Date now = DateUtil.getNow();
        if (NullUtil.isNotNull((Object)ruleVO.getBeginTime()) && ruleVO.getBeginTime().compareTo(now) <= 0) {
            ruleVO.setEnable(1);
        }
        if (NullUtil.isNull((Object)ruleVO.getId())) {
            ruleVO.setCreateTime(now);
            return this.createConnectActiveRule(ruleVO);
        }
        return this.updateConnectActiveRule(ruleVO);
    }

    @Override
    @Transactional
    public boolean enableDisableConnectActivityRule(Long ruleId, Integer enableOrDisable) {
        WhWmsConnectActivityRuleVO ruleVO = new WhWmsConnectActivityRuleVO();
        ruleVO.setId(ruleId);
        ruleVO.setEnable(enableOrDisable);
        this.whWmsConnectActivityRuleMapper.updateByPrimaryKeySelective(ruleVO);
        return true;
    }

    private boolean createConnectActiveRule(WhWmsConnectActivityRuleVO ruleVO) {
        this.whWmsConnectActivityRuleMapper.insert(ruleVO);
        this.createConnectActiveRuleDetail(ruleVO);
        return true;
    }

    private boolean updateConnectActiveRule(WhWmsConnectActivityRuleVO ruleVO) {
        this.whWmsConnectActivityRuleMapper.updateByPrimaryKeySelective(ruleVO);
        this.deleteConnectActiveRuleDetail(ruleVO.getId());
        this.createConnectActiveRuleDetail(ruleVO);
        return true;
    }

    private void createConnectActiveRuleDetail(WhWmsConnectActivityRuleVO ruleVO) {
        if (EmptyUtil.isNotEmpty(ruleVO.getDetails())) {
            for (WhWmsConnectActivityRuleDetailVO detailVO : ruleVO.getDetails()) {
                detailVO.setActivityRuleId(ruleVO.getId());
                this.whWmsConnectActivityRuleDetailMapper.insert(detailVO);
            }
        }
    }

    private void deleteConnectActiveRuleDetail(Long ruleId) {
        WhWmsConnectActivityRuleDetailExample example = new WhWmsConnectActivityRuleDetailExample();
        example.createCriteria().andActivityRuleIdEqualTo(ruleId);
        this.whWmsConnectActivityRuleDetailMapper.deleteByExample(example);
    }

    private void fullCascade(List<WhWmsConnectActivityRuleVO> ruleList) {
        ArrayList<Long> ruleIds = new ArrayList<Long>();
        for (WhWmsConnectActivityRuleVO ruleVO : ruleList) {
            ruleIds.add(ruleVO.getId());
        }
        HashMap<Long, ArrayList<WhWmsConnectActivityRuleDetailVO>> detailMap = new HashMap<Long, ArrayList<WhWmsConnectActivityRuleDetailVO>>();
        List<WhWmsConnectActivityRuleDetailVO> detailList = this.whWmsConnectActivityRuleDetailMapper.findByRuleId(ruleIds);
        if (EmptyUtil.isNotEmpty(detailList)) {
            for (WhWmsConnectActivityRuleDetailVO detailVO : detailList) {
                ArrayList<WhWmsConnectActivityRuleDetailVO> tmpList = (ArrayList<WhWmsConnectActivityRuleDetailVO>)detailMap.get(detailVO.getActivityRuleId());
                if (NullUtil.isNull((Object)tmpList)) {
                    tmpList = new ArrayList<WhWmsConnectActivityRuleDetailVO>();
                    detailMap.put(detailVO.getActivityRuleId(), tmpList);
                }
                tmpList.add(detailVO);
            }
            for (WhWmsConnectActivityRuleVO ruleVO : ruleList) {
                ruleVO.setDetails((List)detailMap.get(ruleVO.getId()));
            }
        }
    }
}

