/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsCommandPreOccupyCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsCommandPreOccupyIdxMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsCommandPreOccupyMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsCommandPreOccupy;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsCommandPreOccupyExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandPreOccupyService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandPreOccupyVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whWmsCommandPreOccupyService")
public class WhWmsCommandPreOccupyServiceImpl
implements WhWmsCommandPreOccupyService {
    @Autowired
    private WhWmsCommandPreOccupyMapper whWmsCommandPreOccupyMapper;
    @Autowired
    private WhWmsCommandPreOccupyIdxMapper whWmsCommandPreOccupyIdxMapper;

    @Override
    @Transactional
    public boolean createPreOccupy(WhWmsCommandPreOccupyVO vo) {
        return this.createPreOccupy(Collections.singletonList(vo));
    }

    @Override
    @Transactional
    public boolean createPreOccupy(List<WhWmsCommandPreOccupyVO> voList) {
        if (EmptyUtil.isEmpty(voList)) {
            return false;
        }
        HashSet<String> commandCodes = new HashSet<String>();
        for (WhWmsCommandPreOccupyVO preOccupyVO : voList) {
            commandCodes.add(preOccupyVO.getCommandCode());
        }
        this.whWmsCommandPreOccupyMapper.batchCreate(voList);
        try {
            this.whWmsCommandPreOccupyIdxMapper.batchCreate(Arrays.asList(commandCodes.toArray(new String[commandCodes.size()])));
        }
        catch (DuplicateKeyException e) {
            throw new WarehouseException("WH0001", "\u6307\u4ee4\u5df2\u9884\u5360\u7528,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return true;
    }

    @Override
    public List<WhWmsCommandPreOccupyVO> findByCond(WhWmsCommandPreOccupyCond cond) {
        return this.whWmsCommandPreOccupyMapper.findByCond(cond);
    }

    @Override
    @Transactional
    public boolean releasePreOccupy(WhWmsCommandPreOccupyCond cond) {
        List<WhWmsCommandPreOccupyVO> list = this.findByCond(cond);
        if (EmptyUtil.isEmpty(list)) {
            return true;
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        ArrayList<String> commandCodes = new ArrayList<String>();
        for (WhWmsCommandPreOccupyVO preOccupyVO : list) {
            idList.add(preOccupyVO.getId());
        }
        this.whWmsCommandPreOccupyMapper.releasePreOccupy(idList);
        this.whWmsCommandPreOccupyIdxMapper.batchDelete(commandCodes);
        return true;
    }

    @Override
    @Transactional
    public boolean releasePreOccupy(String physicalWarehouseCode) {
        this.whWmsCommandPreOccupyIdxMapper.batchDeletePhyWhCode(physicalWarehouseCode);
        this.whWmsCommandPreOccupyMapper.releasePreOccupyByPhysicalWarehouseCode(physicalWarehouseCode);
        return true;
    }

    @Override
    @Transactional
    public boolean releasePreOccupy(List<String> commandCodes) {
        if (EmptyUtil.isEmpty(commandCodes)) {
            return true;
        }
        WhWmsCommandPreOccupyExample example = new WhWmsCommandPreOccupyExample();
        example.createCriteria().andCommandCodeIn((List)commandCodes).andStatusEqualTo(1);
        List<WhWmsCommandPreOccupy> list = this.whWmsCommandPreOccupyMapper.selectByExample(example);
        if (EmptyUtil.isEmpty(list)) {
            return true;
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        for (WhWmsCommandPreOccupy preOccupy : list) {
            idList.add(preOccupy.getId());
        }
        this.whWmsCommandPreOccupyMapper.releasePreOccupy(idList);
        this.whWmsCommandPreOccupyIdxMapper.batchDelete(commandCodes);
        return true;
    }

    @Override
    @Transactional
    public boolean releasePreOccupyForConnectStart(List<String> commandCodes) {
        if (EmptyUtil.isEmpty(commandCodes)) {
            return true;
        }
        WhWmsCommandPreOccupyExample example = new WhWmsCommandPreOccupyExample();
        example.createCriteria().andCommandCodeIn((List)commandCodes).andStatusEqualTo(1);
        List<WhWmsCommandPreOccupy> list = this.whWmsCommandPreOccupyMapper.selectByExample(example);
        if (EmptyUtil.isEmpty(list)) {
            return true;
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        for (WhWmsCommandPreOccupy preOccupy : list) {
            idList.add(preOccupy.getId());
        }
        this.whWmsCommandPreOccupyMapper.releasePreOccupy(idList);
        return true;
    }
}

