/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhCommandMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhCommandOutFinishMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsSubmitHandRecordMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandOutFinish;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandOutFinishExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSubmitHandRecord;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandCheckService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandHandoverService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandCheckVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whWmsCommandHandoverService")
public class WhWmsCommandHandoverServiceImpl
implements WhWmsCommandHandoverService {
    private final Logger log = LoggerFactory.getLogger(WhWmsCommandHandoverServiceImpl.class);
    @Autowired
    private WhCommandMapper whCommandMapper;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhWmsCommandCheckService whWmsCommandCheckService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhCommandOutFinishMapper whCommandOutFinishMapper;
    @Autowired
    private WhWmsSubmitHandRecordMapper whWmsSubmitHandRecordMapper;

    @Override
    @Transactional
    public boolean commandHandover(WhCommand cmd) {
        boolean success;
        boolean bl = success = this.whCommandMapper.updateCommandForHandover(cmd) == 1;
        if (!success) {
            throw new WarehouseException("WH0001", String.format("\u5305\u88f9:[%s][%s]\u72b6\u6001\u5f02\u5e38\uff01", cmd.getReferenceCode(), cmd.getExpressNo()));
        }
        WhCommandOutFinish whCommandOutFinish = new WhCommandOutFinish();
        whCommandOutFinish.setCommandCode(cmd.getCode());
        whCommandOutFinish.setExpressNo(cmd.getExpressNo());
        whCommandOutFinish.setStatus(0);
        whCommandOutFinish.setWhStatus(0);
        whCommandOutFinish.setWeight(cmd.getWeight());
        whCommandOutFinish.setWeightDate(cmd.getWeightDate());
        whCommandOutFinish.setWeightUserId(cmd.getWeightUserId());
        this.whCommandService.insertWhCommandOutFinish(whCommandOutFinish);
        return true;
    }

    @Override
    @Transactional
    public void processSubmitCommandHandover(WhCommand whCommand) {
        if (NullUtil.isNull((Object)whCommand.getExpressNo())) {
            throw new WarehouseException("WH0002");
        }
        if (NullUtil.isNull((Object)whCommand.getWeight())) {
            whCommand.setWeight(Float.valueOf(0.0f));
        }
        if (NullUtil.isNull((Object)whCommand.getWeightUserId())) {
            whCommand.setWeightUserId(1L);
        }
        if (!whCommand.getCommandStatus().equals(WhCommand.STATUS_HANDOVER) && !whCommand.getCommandStatus().equals(WhCommand.STATUS_DELIVERYCOMPLETION)) {
            throw new WarehouseException("WH0001", "\u4ed3\u5e93\u6307\u4ee4\u72b6\u6001\u5fc5\u987b\u662f\u5f85\u4ea4\u63a5," + whCommand.getCode());
        }
        whCommand.setCommandStatus(WhCommand.STATUS_DELIVERYCOMPLETION);
        this.whCommandMapper.updateByPrimaryKeySelective(whCommand);
        WhPhysicalWarehouse physicalWarehouse = this.whInfoService.findPhysicalWarehouseByCode(whCommand.getPhysicalWarehouseCode());
        if (physicalWarehouse == null) {
            throw new WarehouseException("WMS0001", "\u6ca1\u6709\u5408\u9002\u7684\u7269\u7406\u4ed3");
        }
        WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
        whWmsHouseShelvesCond.setPhysicalWarehouseCode(physicalWarehouse.getCode());
        whWmsHouseShelvesCond.setHouseType("HOUSE_TYPE_HANDOVER");
        List<WhWmsHouseShelvesVO> hs = this.whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if (CollectionUtils.isEmpty(hs) || hs.size() > 1) {
            throw new WarehouseException("WMS0001", "\u6ca1\u6709\u5408\u9002\u7684\u76ee\u6807\u5e93\u4f4d,\u4ea4\u63a5\u533a");
        }
        WhWmsHouseShelvesVO targetShelvesVO = hs.get(0);
        WhWmsCommandCheckVO cond = new WhWmsCommandCheckVO();
        cond.setCommandCode(whCommand.getCode());
        cond.setCancelFlag(0);
        cond.setIsMaterial(null);
        List<WhWmsCommandCheckVO> commandCheckVOs = this.whWmsCommandCheckService.findByCond(cond);
        for (WhWmsCommandCheckVO commandCheckVO : commandCheckVOs) {
            WhWmsSubmitHandRecord record = new WhWmsSubmitHandRecord(0 - commandCheckVO.getCheckAmount(), targetShelvesVO.getPhysicalWarehouseCode(), targetShelvesVO.getHouseType(), commandCheckVO.getBarCode(), targetShelvesVO.getCode(), commandCheckVO.getSkuCode(), commandCheckVO.getSkuStatus(), whCommand.getInOutType(), whCommand.getCode(), whCommand.getWeightUserId() == null ? 1 : whCommand.getWeightUserId().intValue(), null, 1, 0);
            this.whWmsSubmitHandRecordMapper.insertSelective(record);
        }
        boolean success = this.updateCommandOutFinishDone(whCommand.getCode());
        if (!success) {
            throw new WarehouseException("WMS0001", "\u6307\u4ee4" + whCommand.getCode() + "\u5df2\u7ecf\u5904\u7406");
        }
    }

    private boolean updateCommandOutFinishDone(String commandCode) {
        WhCommandOutFinish updateInfo = new WhCommandOutFinish();
        updateInfo.setStatus(1);
        updateInfo.setFinishDate(DateUtil.getNow());
        WhCommandOutFinishExample example = new WhCommandOutFinishExample();
        example.createCriteria().andCommandCodeEqualTo(commandCode).andStatusEqualTo(0);
        return this.whCommandOutFinishMapper.updateByExampleSelective(updateInfo, example) == 1;
    }
}

