/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsCommandConnectCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsCommandConnectMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsCommandConnect;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsCommandConnectExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuBarcode;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandConnectService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsOccupyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuBarcodeService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWarehouseAreaService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCountVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandConnectVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsOccupyVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuPickStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service(value="whWmsCommandConnectService")
public class WhWmsCommandConnectServiceImpl
implements WhWmsCommandConnectService {
    private static Logger log = LoggerFactory.getLogger(WhWmsCommandConnectServiceImpl.class);
    @Autowired
    private WhWmsCommandConnectMapper mapper;
    @Autowired
    private WhWmsConnectInfoService whWmsConnectInfoService;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhWmsOccupyService whWmsOccupyService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhWmsSkuBarcodeService whWmsSkuBarcodeService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;
    @Autowired
    private WhWmsWarehouseAreaService whWmsWarehouseAreaService;
    @Autowired
    private RedisDistributLock redisDistributLock;

    @Transactional
    private WhWmsCommandConnectVO create(WhWmsCommandConnectVO vo) {
        this.validateBeforeCreate(vo);
        vo.setCancelFlag(0);
        WhWmsCommandConnect whWmsCommandConnect = (WhWmsCommandConnect)BeanUtil.buildFrom((Object)vo, WhWmsCommandConnect.class);
        this.mapper.insert(whWmsCommandConnect);
        vo.setId(whWmsCommandConnect.getId());
        WhCommand cmd = this.whCommandService.findCommandByCode(vo.getCommandCode(), false);
        cmd.setCommandStatus(WhCommand.STATUS_PICKING);
        WhCommand oldCmd = this.whCommandService.updateCommandV2(cmd);
        if (!WhCommand.STATUS_IN_PROCESSING.equals(oldCmd.getCommandStatus())) {
            throw new WarehouseException("WH0001", String.format("\u5f53\u524d\u6307\u4ee4\u72b6\u6001[%s]", oldCmd.getCommandStatusStr()));
        }
        return vo;
    }

    @Override
    public List<WhWmsCommandConnectVO> create(WhWmsConnectInfoVO connect) {
        ArrayList<WhWmsCommandConnectVO> vos = new ArrayList<WhWmsCommandConnectVO>();
        FilterStragetyContext context = new FilterStragetyContext(connect);
        context.filter();
        if (CollectionUtils.isEmpty(connect.getWhCommandsCodes())) {
            this.whWmsConnectInfoService.deleteById(connect.getId());
            return Collections.emptyList();
        }
        context.occupy();
        for (int i = 0; i < connect.getWhCommandsCodes().size(); ++i) {
            WhWmsCommandConnectVO whWmsCommandConnectVO = this.create(new WhWmsCommandConnectVO(connect.getWhCommandsCodes().get(i), connect.getId(), connect.getSkuCode()));
            if (whWmsCommandConnectVO == null) continue;
            vos.add(whWmsCommandConnectVO);
        }
        if (CollectionUtils.isEmpty(vos)) {
            return Collections.emptyList();
        }
        return vos;
    }

    @Override
    public boolean create(List<WhWmsCommandConnectVO> voList) {
        if (EmptyUtil.isEmpty(voList)) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u6307\u4ee4\u521b\u5efa\u5931\u8d25");
        }
        this.mapper.batchCreate(voList);
        return true;
    }

    @Override
    @Transactional
    public List<WhWmsCommandConnectVO> createConnectInfoAlt(WhWmsConnectInfoVO connect) {
        ArrayList<WhWmsCommandConnectVO> vos = new ArrayList<WhWmsCommandConnectVO>();
        FilterStragetyContextAlt context = new FilterStragetyContextAlt(connect);
        context.filter();
        if (CollectionUtils.isEmpty(connect.getWhCommandsCodes())) {
            this.whWmsConnectInfoService.deleteById(connect.getId());
            return Collections.emptyList();
        }
        context.occupy();
        for (int i = 0; i < connect.getWhCommandsCodes().size(); ++i) {
            WhWmsCommandConnectVO whWmsCommandConnectVO = this.create(new WhWmsCommandConnectVO(connect.getWhCommandsCodes().get(i), connect.getId(), connect.getSkuCode()));
            if (whWmsCommandConnectVO == null) continue;
            vos.add(whWmsCommandConnectVO);
        }
        if (CollectionUtils.isEmpty(vos)) {
            return Collections.emptyList();
        }
        return vos;
    }

    @Override
    public List<WhWmsCommandConnectVO> createConnectInfoPcsRtn(WhWmsConnectInfoVO connect) {
        ArrayList<WhWmsCommandConnectVO> vos = new ArrayList<WhWmsCommandConnectVO>();
        FilterStragetyContextPcsRtn context = new FilterStragetyContextPcsRtn(connect);
        context.filter();
        if (CollectionUtils.isEmpty(connect.getWhCommandsCodes())) {
            this.whWmsConnectInfoService.deleteById(connect.getId());
            return Collections.emptyList();
        }
        context.occupy();
        for (int i = 0; i < connect.getWhCommandsCodes().size(); ++i) {
            WhWmsCommandConnectVO whWmsCommandConnectVO = this.create(new WhWmsCommandConnectVO(connect.getWhCommandsCodes().get(i), connect.getId(), connect.getSkuCode()));
            if (whWmsCommandConnectVO == null) continue;
            vos.add(whWmsCommandConnectVO);
        }
        if (CollectionUtils.isEmpty(vos)) {
            return Collections.emptyList();
        }
        return vos;
    }

    @Override
    public List<WhWmsCommandConnectVO> createConnectInfoRecWaste(WhWmsConnectInfoVO vo) {
        ArrayList<WhWmsCommandConnectVO> vos = new ArrayList<WhWmsCommandConnectVO>();
        FilterStragetyContextRecWaste context = new FilterStragetyContextRecWaste(vo);
        context.filter();
        if (CollectionUtils.isEmpty(vo.getWhCommandsCodes())) {
            this.whWmsConnectInfoService.deleteById(vo.getId());
            return Collections.emptyList();
        }
        context.occupy();
        for (int i = 0; i < vo.getWhCommandsCodes().size(); ++i) {
            WhWmsCommandConnectVO whWmsCommandConnectVO = this.create(new WhWmsCommandConnectVO(vo.getWhCommandsCodes().get(i), vo.getId(), vo.getSkuCode()));
            if (whWmsCommandConnectVO == null) continue;
            vos.add(whWmsCommandConnectVO);
        }
        return vos;
    }

    @Override
    public List<WhWmsSkuPickStockVO> generalPickSkuStockStragety(List<WhWmsSkuPickStockVO> pickStockList, Integer skuStatus, String physicalWarehouseCode) {
        HashMap<String, SkuQtt> skus = new HashMap<String, SkuQtt>();
        for (WhWmsSkuPickStockVO pickStockVO : pickStockList) {
            SkuQtt quanlity = (SkuQtt)skus.get(pickStockVO.getSkuCode());
            if (NullUtil.isNull((Object)quanlity)) {
                quanlity = new SkuQtt(pickStockVO.getSkuCode());
                skus.put(pickStockVO.getSkuCode(), quanlity);
            }
            SkuQtt skuQtt = quanlity;
            skuQtt.planedQuantity = skuQtt.planedQuantity + pickStockVO.getNeedQuanlity();
        }
        Map<String, List<String>> skuBarcodeMap = this.findBarcodesForAltOrPcsRtnConnect(Arrays.asList(skus.keySet().toArray(new String[skus.size()])), false);
        for (String skuCode : skus.keySet()) {
            List<String> barCodesBySku = skuBarcodeMap.get(skuCode);
            if (CollectionUtils.isEmpty(barCodesBySku)) continue;
            SkuQtt skuQtt = (SkuQtt)skus.get(skuCode);
            for (String barCode : barCodesBySku) {
                BarcodeQtt barcodeQtt = new BarcodeQtt(barCode);
                skuQtt.barcodes.add(barcodeQtt);
                WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
                cond.setBarCode(barCode);
                cond.setSkuCode(skuCode);
                cond.setSkuStatus(skuStatus);
                cond.setPhysicalWarehouseCode(physicalWarehouseCode);
                cond.setHouseTypes(this.whWmsWarehouseAreaService.getHouseTypesByType("NORMAL"));
                List<WhWmsSkuStockVO> wmsSkuAvailableAccount = this.whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                WarehouseArea area = new WarehouseArea("NORMAL");
                barcodeQtt.areas.add(area);
                area.stocks.addAll(wmsSkuAvailableAccount);
            }
        }
        block3: for (String skuCode : skus.keySet()) {
            SkuQtt skuQtt = (SkuQtt)skus.get(skuCode);
            int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
            for (BarcodeQtt b : skuQtt.barcodes) {
                WarehouseArea areaNormal = null;
                for (WarehouseArea area : b.areas) {
                    if (!area.type.equals("NORMAL")) continue;
                    areaNormal = area;
                    break;
                }
                ArrayList<WhWmsSkuStockVO> pickingStocks = new ArrayList<WhWmsSkuStockVO>();
                ArrayList<WhWmsSkuStockVO> holdingStocks = new ArrayList<WhWmsSkuStockVO>();
                for (WhWmsSkuStockVO stock : areaNormal.stocks) {
                    WhWmsHouseShelvesVO hs = this.whWmsHouseShelvesService.getHouseShelvesByCode(stock.getShelvesCode());
                    stock.setShelvesSortOrder(hs.getSortOrder());
                    if (hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING)) {
                        pickingStocks.add(stock);
                        continue;
                    }
                    if (!hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING)) continue;
                    holdingStocks.add(stock);
                }
                this.sortSkuStock(pickingStocks);
                this.sortSkuStock(holdingStocks);
                ArrayList<WhWmsSkuStockVO> stockList = new ArrayList<WhWmsSkuStockVO>();
                stockList.addAll(pickingStocks);
                stockList.addAll(holdingStocks);
                for (WhWmsSkuStockVO stock : stockList) {
                    if (occupyQuantity > 0) {
                        int availableOccupyQuantity;
                        int n = availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount() ? occupyQuantity : stock.getAvailableAccount();
                        if (availableOccupyQuantity <= 0) continue;
                        WhWmsSkuStockVO pickStock = (WhWmsSkuStockVO)BeanUtil.buildFrom((Object)stock, WhWmsSkuStockVO.class);
                        pickStock.setAmount(availableOccupyQuantity);
                        skuQtt.addPickStock(pickStock);
                        SkuQtt skuQtt2 = skuQtt;
                        skuQtt2.disposeQuantity = skuQtt2.disposeQuantity + availableOccupyQuantity;
                        occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                    }
                    if (occupyQuantity != 0) continue;
                    break;
                }
                if (occupyQuantity != 0) continue;
                continue block3;
            }
        }
        for (WhWmsSkuPickStockVO pickStockVO : pickStockList) {
            SkuQtt quanlity = (SkuQtt)skus.get(pickStockVO.getSkuCode());
            if (!NullUtil.isNotNull((Object)quanlity)) continue;
            pickStockVO.setPickedStock(quanlity.getPickedStock());
            pickStockVO.setDisposeQuantity(quanlity.disposeQuantity);
        }
        return pickStockList;
    }

    private void _setSkuQttMap(Map<String, SkuQtt> skus, WhCommand whCommand) {
        for (WhCommandSku cmdSku : whCommand.getWhCommandSkuList()) {
            if (!skus.containsKey(cmdSku.getSkuCode())) {
                skus.put(cmdSku.getSkuCode(), new SkuQtt(cmdSku.getSkuCode()));
            }
            SkuQtt skuQtt = skus.get(cmdSku.getSkuCode());
            skuQtt.planedQuantity = skuQtt.planedQuantity + cmdSku.getPlanedQuantity();
        }
    }

    private void _filterConnectCommand(Map<String, SkuQtt> skus, WhWmsConnectInfoVO connect) {
        if (!connect.getWhCommands().get(0).getInOutType().equals(WhCommand.TYPE_ALLOT_OUT)) {
            for (String skuCode : skus.keySet()) {
                SkuQtt skuQtt = skus.get(skuCode);
                while (skuQtt.planedQuantity > skuQtt.getAvailableQuantity() && skuQtt.planedQuantity > 0) {
                    for (int i = connect.getWhCommands().size() - 1; i >= 0; --i) {
                        WhCommand whCommand = connect.getWhCommands().get(i);
                        boolean isEquals = false;
                        for (WhCommandSku cmdSku : whCommand.getWhCommandSkuList()) {
                            if (!cmdSku.getSkuCode().equals(skuQtt.skuCode)) continue;
                            isEquals = true;
                            break;
                        }
                        if (!isEquals) continue;
                        for (WhCommandSku cmdSku : whCommand.getWhCommandSkuList()) {
                            int diff = skus.get(cmdSku.getSkuCode()).planedQuantity - skus.get(cmdSku.getSkuCode()).getAvailableQuantity();
                            if (diff > 0) {
                                int shortAmount = 0;
                                shortAmount = diff >= cmdSku.getPlanedQuantity() ? cmdSku.getPlanedQuantity() : diff;
                                this.whCommandService.recordCommandShortSku(whCommand.getCode(), cmdSku.getSkuCode(), shortAmount);
                                connect.getFailureShortageCommandCodes().add("\u51fa\u5e93\u6307\u4ee4\uff1a" + whCommand.getCode() + " \u7f3a\u8d27SKU:" + cmdSku.getSkuCode() + " \u7f3a\u8d27\u6570\u91cf\uff1a" + shortAmount);
                            }
                            SkuQtt skuQtt2 = skus.get(cmdSku.getSkuCode());
                            skuQtt2.planedQuantity = skuQtt2.planedQuantity - cmdSku.getPlanedQuantity();
                        }
                        this.whCommandService.failureStartConnect(whCommand.getCode());
                        connect.getWhCommands().remove(i);
                        connect.getWhCommandsCodes().remove(i);
                    }
                }
            }
        }
    }

    private Map<String, List<String>> findBarcodesForAltOrPcsRtnConnect(List<String> skuCodes, boolean allowExpire) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        List<WhWmsSkuBarcode> barcodeList = this.whWmsSkuBarcodeService.findBarcodesForAltOrPcsRtnConnect(skuCodes, allowExpire);
        if (EmptyUtil.isNotEmpty(barcodeList)) {
            for (WhWmsSkuBarcode barcode : barcodeList) {
                ArrayList<String> tmpList = (ArrayList<String>)map.get(barcode.getSkuCode());
                if (NullUtil.isNull((Object)tmpList)) {
                    tmpList = new ArrayList<String>();
                    map.put(barcode.getSkuCode(), tmpList);
                }
                tmpList.add(barcode.getBarCode());
            }
        }
        return map;
    }

    @Override
    public void sortSkuStock(List<WhWmsSkuStockVO> stocks) {
        if (EmptyUtil.isEmpty(stocks)) {
            return;
        }
        Collections.sort(stocks, new Comparator<WhWmsSkuStockVO>(){

            @Override
            public int compare(WhWmsSkuStockVO o1, WhWmsSkuStockVO o2) {
                return WhWmsCommandConnectServiceImpl.this.compareStock(o1, o2);
            }
        });
    }

    private int compareStock(WhWmsSkuStockVO o1, WhWmsSkuStockVO o2) {
        int result;
        Integer o1Account = o1.getAvailableAccount();
        Integer o2Account = o2.getAvailableAccount();
        if (NullUtil.isNull((Object)o1Account)) {
            o1Account = new Integer(0);
        }
        if (NullUtil.isNull((Object)o2Account)) {
            o2Account = new Integer(0);
        }
        if ((result = o1Account.compareTo(o2Account)) == 0 && (result = this.compareShelveSortOrder(o1.getShelvesSortOrder(), o2.getShelvesSortOrder())) == 0) {
            result = o1.getShelvesCode().compareTo(o2.getShelvesCode());
        }
        return result;
    }

    private int compareShelveSortOrder(Integer so1, Integer so2) {
        if (NullUtil.isNull((Object)so1)) {
            so1 = 9999999;
        }
        if (NullUtil.isNull((Object)so2)) {
            so2 = 9999999;
        }
        return so1.compareTo(so2);
    }

    @Override
    public Boolean update(WhWmsCommandConnectVO vo) {
        return this.mapper.updateByPrimaryKeySelective((WhWmsCommandConnect)BeanUtil.buildFrom((Object)vo, WhWmsCommandConnect.class)) != 0;
    }

    @Override
    public Boolean batchUpdate(WhWmsCommandConnect record, WhWmsCommandConnectCond cond) {
        WhWmsCommandConnectExample example = new WhWmsCommandConnectExample();
        WhWmsCommandConnectExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(cond.getIds())) {
            criteria.andIdIn((List)cond.getIds());
        }
        return this.mapper.updateByExampleSelective(record, example) > 0;
    }

    @Override
    @Transactional
    public Boolean batchCancel(List<String> commandCodes, Long connectId) {
        if (EmptyUtil.isEmpty(commandCodes)) {
            return false;
        }
        WhWmsCommandConnectExample example = new WhWmsCommandConnectExample();
        WhWmsCommandConnectExample.Criteria criteria = example.createCriteria();
        criteria.andCommandCodeIn((List)commandCodes).andConnectIdEqualTo(connectId).andCancelFlagEqualTo(0);
        WhWmsCommandConnect update = new WhWmsCommandConnect();
        update.setCancelFlag(1);
        this.mapper.updateByExampleSelective(update, example);
        return true;
    }

    @Override
    public Boolean batchCancelByConnectId(List<Long> connectIds) {
        if (EmptyUtil.isEmpty(connectIds)) {
            return false;
        }
        WhWmsCommandConnectExample example = new WhWmsCommandConnectExample();
        WhWmsCommandConnectExample.Criteria criteria = example.createCriteria();
        criteria.andConnectIdIn((List)connectIds).andCancelFlagEqualTo(0);
        WhWmsCommandConnect update = new WhWmsCommandConnect();
        update.setCancelFlag(1);
        this.mapper.updateByExampleSelective(update, example);
        return true;
    }

    @Override
    public WhWmsCommandConnectVO findById(Long id) {
        WhWmsCommandConnect whWmsCommandConnect = this.mapper.selectByPrimaryKey(id);
        if (whWmsCommandConnect != null) {
            return (WhWmsCommandConnectVO)BeanUtil.buildFrom((Object)whWmsCommandConnect, WhWmsCommandConnectVO.class);
        }
        return null;
    }

    @Override
    public WhWmsCommandConnectVO findNotCanceledByWhCommandCode(String whCommandCode) {
        WhWmsCommandConnectCond cond = new WhWmsCommandConnectCond();
        cond.setCommandCode(whCommandCode);
        cond.setCancelFlag(0);
        List<WhWmsCommandConnectVO> vos = this.findByCond(cond);
        if (CollectionUtils.isEmpty(vos)) {
            return null;
        }
        return vos.get(0);
    }

    @Override
    public WhWmsCommandConnectVO findByWhCommandCode(String whCommandCode, boolean isCanceled) {
        List<WhWmsCommandConnectVO> vos;
        WhWmsCommandConnectCond cond = new WhWmsCommandConnectCond();
        cond.setCommandCode(whCommandCode);
        if (isCanceled) {
            cond.setCancelFlag(0);
        }
        if (CollectionUtils.isEmpty(vos = this.findByCond(cond))) {
            return null;
        }
        return vos.get(0);
    }

    @Override
    public List<WhWmsCommandConnectVO> findNotCanceledByConnectId(Long connectId) {
        WhWmsCommandConnectCond cond = new WhWmsCommandConnectCond();
        cond.setConnectId(connectId);
        cond.setCancelFlag(0);
        List<WhWmsCommandConnectVO> vos = this.findByCond(cond);
        if (CollectionUtils.isEmpty(vos)) {
            return null;
        }
        return vos;
    }

    @Override
    public Integer findCountByConnectId(Long connectId) {
        WhWmsCommandConnectExample example = new WhWmsCommandConnectExample();
        example.createCriteria().andConnectIdEqualTo(connectId);
        Integer count = this.mapper.countByExample(example);
        return count;
    }

    @Override
    public List<WhCountVO> countConnectCommandByConnectId(List<Long> connectIds) {
        return this.mapper.countConnectCommandByConnectId(connectIds);
    }

    @Override
    public List<WhWmsCommandConnectVO> findByCond(WhWmsCommandConnectCond cond) {
        WhWmsCommandConnectExample example = new WhWmsCommandConnectExample();
        WhWmsCommandConnectExample.Criteria criteria = example.createCriteria();
        if (!StringUtils.isEmpty((Object)cond.getCommandCode())) {
            criteria.andCommandCodeEqualTo(cond.getCommandCode());
        } else if (CollectionUtils.isNotEmpty(cond.getCommandCodes())) {
            criteria.andCommandCodeIn((List)cond.getCommandCodes());
        }
        if (!NumberUtil.isNullOrZero((Number)cond.getConnectId())) {
            criteria.andConnectIdEqualTo(cond.getConnectId());
        }
        if (EmptyUtil.isNotEmpty(cond.getConnectIds())) {
            criteria.andConnectIdIn((List)cond.getConnectIds());
        }
        if (cond.getCancelFlag() != null) {
            criteria.andCancelFlagEqualTo(cond.getCancelFlag());
        }
        if (cond.getCommandCodeList() != null && cond.getCommandCodeList().size() > 0) {
            criteria.andCommandCodeIn((List)cond.getCommandCodeList());
        }
        example.setOrderByClause(" ID " + cond.getCriteriaStr());
        List<WhWmsCommandConnect> whWmsCommandConnects = this.mapper.selectByExample(example);
        if (CollectionUtils.isEmpty(whWmsCommandConnects)) {
            return Collections.emptyList();
        }
        ArrayList<WhWmsCommandConnectVO> vos = new ArrayList<WhWmsCommandConnectVO>(whWmsCommandConnects.size());
        for (WhWmsCommandConnect whWmsCommandConnect : whWmsCommandConnects) {
            vos.add((WhWmsCommandConnectVO)BeanUtil.buildFrom((Object)whWmsCommandConnect, WhWmsCommandConnectVO.class));
        }
        return vos;
    }

    private void validateBeforeCreate(WhWmsCommandConnectVO vo) {
        if (vo.getConnectId() == null) {
            throw new WarehouseException("WH0002", "connectId\u4e3a\u7a7a");
        }
        WhWmsConnectInfoVO whWmsConnectInfoVO = this.whWmsConnectInfoService.findById(vo.getConnectId());
        if (whWmsConnectInfoVO == null) {
            throw new WarehouseException("WH0002", "connect[" + vo.getConnectId() + "] \u5b9e\u4f53\u4e3a\u7a7a");
        }
    }

    private class FilterStragetyPcsRtn
    extends AbstractFilterStragetyPcsRtn {
        private Integer skuStatus;

        public FilterStragetyPcsRtn(Integer skuStatus) {
            this.skuStatus = skuStatus;
        }

        @Override
        public void filter(FilterStragetyContextPcsRtn context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            HashMap skus = new HashMap();
            context.skus = skus;
            for (int i = 0; i < connect.getWhCommandsCodes().size(); ++i) {
                WhCommand whCommand = connect.getWhCommands().get(i);
                WhWmsCommandConnectServiceImpl.this._setSkuQttMap(skus, whCommand);
            }
            Map skuBarcodeMap = WhWmsCommandConnectServiceImpl.this.findBarcodesForAltOrPcsRtnConnect(Arrays.asList(skus.keySet().toArray(new String[skus.size()])), true);
            for (String skuCode : skus.keySet()) {
                List barCodesBySku = (List)skuBarcodeMap.get(skuCode);
                if (CollectionUtils.isEmpty((Collection)barCodesBySku)) continue;
                SkuQtt skuQtt = (SkuQtt)skus.get(skuCode);
                for (String barCode : barCodesBySku) {
                    BarcodeQtt barcodeQtt = new BarcodeQtt(barCode);
                    skuQtt.barcodes.add(barcodeQtt);
                    WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
                    cond.setBarCode(barCode);
                    cond.setSkuCode(skuCode);
                    cond.setSkuStatus(this.skuStatus);
                    cond.setPhysicalWarehouseCode(connect.getPhysicalWarehouseCode());
                    List<WhWmsSkuStockVO> wmsSkuAvailableAccount = null;
                    WarehouseArea area = null;
                    cond.setHouseTypes(WhWmsCommandConnectServiceImpl.this.whWmsWarehouseAreaService.getHouseTypesByType("NORMAL"));
                    wmsSkuAvailableAccount = WhWmsCommandConnectServiceImpl.this.whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                    area = new WarehouseArea("NORMAL");
                    barcodeQtt.areas.add(area);
                    area.stocks.addAll(wmsSkuAvailableAccount);
                }
            }
        }

        @Override
        public void occupy(FilterStragetyContextPcsRtn context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            Map skus = context.skus;
            block4: for (String skuCode : skus.keySet()) {
                SkuQtt skuQtt = (SkuQtt)skus.get(skuCode);
                int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                for (BarcodeQtt b : skuQtt.barcodes) {
                    SkuQtt skuQtt2;
                    WhWmsOccupyVO occupyVO2;
                    WarehouseArea areaNormal = null;
                    for (WarehouseArea area : b.areas) {
                        if (!area.type.equals("NORMAL")) continue;
                        areaNormal = area;
                    }
                    ArrayList<WhWmsSkuStockVO> pickingStocks = new ArrayList<WhWmsSkuStockVO>();
                    ArrayList<WhWmsSkuStockVO> holdingStocks = new ArrayList<WhWmsSkuStockVO>();
                    for (WhWmsSkuStockVO stock : areaNormal.stocks) {
                        WhWmsHouseShelvesVO hs = WhWmsCommandConnectServiceImpl.this.whWmsHouseShelvesService.getHouseShelvesByCode(stock.getShelvesCode());
                        stock.setShelvesSortOrder(hs.getSortOrder());
                        if (hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING)) {
                            pickingStocks.add(stock);
                            continue;
                        }
                        if (!hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING)) continue;
                        holdingStocks.add(stock);
                    }
                    WhWmsCommandConnectServiceImpl.this.sortSkuStock(pickingStocks);
                    for (WhWmsSkuStockVO stock : pickingStocks) {
                        int availableOccupyQuantity;
                        if (occupyQuantity <= 0) continue;
                        int n = availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount() ? occupyQuantity : stock.getAvailableAccount();
                        if (availableOccupyQuantity <= 0) continue;
                        try {
                            occupyVO2 = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                            occupyVO2.setAmount(0 - availableOccupyQuantity);
                            occupyVO2.setReceiptsNo(connect.getId().toString());
                            occupyVO2.setType(WhWmsOccupyVO.TYPE_CONNECT);
                            WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO2);
                            skuQtt2 = skuQtt;
                            skuQtt2.disposeQuantity = skuQtt2.disposeQuantity + availableOccupyQuantity;
                            occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                        }
                        catch (Exception occupyVO2) {}
                    }
                    if (occupyQuantity == 0) continue block4;
                    WhWmsCommandConnectServiceImpl.this.sortSkuStock(holdingStocks);
                    for (WhWmsSkuStockVO stock : holdingStocks) {
                        int availableOccupyQuantity;
                        if (occupyQuantity <= 0) continue;
                        int n = availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount() ? occupyQuantity : stock.getAvailableAccount();
                        if (availableOccupyQuantity <= 0) continue;
                        try {
                            occupyVO2 = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                            occupyVO2.setAmount(0 - availableOccupyQuantity);
                            occupyVO2.setReceiptsNo(connect.getId().toString());
                            occupyVO2.setType(WhWmsOccupyVO.TYPE_CONNECT);
                            WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO2);
                            skuQtt2 = skuQtt;
                            skuQtt2.disposeQuantity = skuQtt2.disposeQuantity + availableOccupyQuantity;
                            occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                        }
                        catch (Exception exception) {}
                    }
                    if (occupyQuantity != 0) continue;
                    continue block4;
                }
            }
        }
    }

    private class FilterStragetyRecWaste
    extends AbstractFilterStragetyRecWaste {
        private Integer skuStatus;

        public FilterStragetyRecWaste(Integer skuStatus) {
            this.skuStatus = skuStatus;
        }

        @Override
        public void filter(FilterStragetyContextRecWaste context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            HashMap skus = new HashMap();
            context.skus = skus;
            for (int i = 0; i < connect.getWhCommandsCodes().size(); ++i) {
                WhCommand whCommand = connect.getWhCommands().get(i);
                WhWmsCommandConnectServiceImpl.this._setSkuQttMap(skus, whCommand);
            }
            Map skuBarcodeMap = WhWmsCommandConnectServiceImpl.this.findBarcodesForAltOrPcsRtnConnect(Arrays.asList(skus.keySet().toArray(new String[skus.size()])), true);
            for (String skuCode : skus.keySet()) {
                List barCodesBySku = (List)skuBarcodeMap.get(skuCode);
                if (CollectionUtils.isEmpty((Collection)barCodesBySku)) continue;
                SkuQtt skuQtt = (SkuQtt)skus.get(skuCode);
                for (String barCode : barCodesBySku) {
                    BarcodeQtt barcodeQtt = new BarcodeQtt(barCode);
                    skuQtt.barcodes.add(barcodeQtt);
                    WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
                    cond.setBarCode(barCode);
                    cond.setSkuCode(skuCode);
                    cond.setSkuStatus(this.skuStatus);
                    cond.setPhysicalWarehouseCode(connect.getPhysicalWarehouseCode());
                    List<WhWmsSkuStockVO> wmsSkuAvailableAccount = null;
                    WarehouseArea area = null;
                    cond.setHouseTypes(WhWmsCommandConnectServiceImpl.this.whWmsWarehouseAreaService.getHouseTypesByType("NORMAL"));
                    wmsSkuAvailableAccount = WhWmsCommandConnectServiceImpl.this.whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                    area = new WarehouseArea("NORMAL");
                    barcodeQtt.areas.add(area);
                    area.stocks.addAll(wmsSkuAvailableAccount);
                }
            }
            WhWmsCommandConnectServiceImpl.this._filterConnectCommand(skus, connect);
        }

        @Override
        public void occupy(FilterStragetyContextRecWaste context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            Map skus = context.skus;
            block4: for (String skuCode : skus.keySet()) {
                SkuQtt skuQtt = (SkuQtt)skus.get(skuCode);
                int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                for (BarcodeQtt b : skuQtt.barcodes) {
                    SkuQtt skuQtt2;
                    WhWmsOccupyVO occupyVO2;
                    WarehouseArea areaNormal = null;
                    for (WarehouseArea area : b.areas) {
                        if (!area.type.equals("NORMAL")) continue;
                        areaNormal = area;
                    }
                    ArrayList<WhWmsSkuStockVO> pickingStocks = new ArrayList<WhWmsSkuStockVO>();
                    ArrayList<WhWmsSkuStockVO> holdingStocks = new ArrayList<WhWmsSkuStockVO>();
                    for (WhWmsSkuStockVO stock : areaNormal.stocks) {
                        WhWmsHouseShelvesVO hs = WhWmsCommandConnectServiceImpl.this.whWmsHouseShelvesService.getHouseShelvesByCode(stock.getShelvesCode());
                        if (NullUtil.isNull((Object)hs)) continue;
                        stock.setShelvesSortOrder(hs.getSortOrder());
                        if (hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING)) {
                            pickingStocks.add(stock);
                            continue;
                        }
                        if (!hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING)) continue;
                        holdingStocks.add(stock);
                    }
                    WhWmsCommandConnectServiceImpl.this.sortSkuStock(pickingStocks);
                    for (WhWmsSkuStockVO stock : pickingStocks) {
                        int availableOccupyQuantity;
                        if (occupyQuantity <= 0) continue;
                        int n = availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount() ? occupyQuantity : stock.getAvailableAccount();
                        if (availableOccupyQuantity <= 0) continue;
                        try {
                            occupyVO2 = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                            occupyVO2.setAmount(0 - availableOccupyQuantity);
                            occupyVO2.setReceiptsNo(connect.getId().toString());
                            occupyVO2.setType(WhWmsOccupyVO.TYPE_CONNECT);
                            WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO2);
                            skuQtt2 = skuQtt;
                            skuQtt2.disposeQuantity = skuQtt2.disposeQuantity + availableOccupyQuantity;
                            occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                        }
                        catch (Exception occupyVO2) {}
                    }
                    if (occupyQuantity == 0) continue block4;
                    WhWmsCommandConnectServiceImpl.this.sortSkuStock(holdingStocks);
                    for (WhWmsSkuStockVO stock : holdingStocks) {
                        int availableOccupyQuantity;
                        if (occupyQuantity <= 0) continue;
                        int n = availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount() ? occupyQuantity : stock.getAvailableAccount();
                        if (availableOccupyQuantity <= 0) continue;
                        try {
                            occupyVO2 = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                            occupyVO2.setAmount(0 - availableOccupyQuantity);
                            occupyVO2.setReceiptsNo(connect.getId().toString());
                            occupyVO2.setType(WhWmsOccupyVO.TYPE_CONNECT);
                            WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO2);
                            skuQtt2 = skuQtt;
                            skuQtt2.disposeQuantity = skuQtt2.disposeQuantity + availableOccupyQuantity;
                            occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                        }
                        catch (Exception exception) {}
                    }
                    if (occupyQuantity != 0) continue;
                    continue block4;
                }
            }
        }
    }

    private class FilterStragetyAlt
    extends AbstractFilterStragetyAlt {
        private Integer skuStatus;

        public FilterStragetyAlt(Integer skuStatus) {
            this.skuStatus = skuStatus;
        }

        @Override
        public void filter(FilterStragetyContextAlt context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            HashMap skus = new HashMap();
            context.skus = skus;
            for (int i = 0; i < connect.getWhCommandsCodes().size(); ++i) {
                WhCommand whCommand = connect.getWhCommands().get(i);
                WhWmsCommandConnectServiceImpl.this._setSkuQttMap(skus, whCommand);
            }
            boolean allowExpire = false;
            if (EmptyUtil.isNotEmpty((Object)this.skuStatus) && !WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(this.skuStatus)) {
                allowExpire = true;
            }
            Map skuBarcodeMap = WhWmsCommandConnectServiceImpl.this.findBarcodesForAltOrPcsRtnConnect(Arrays.asList(skus.keySet().toArray(new String[skus.size()])), allowExpire);
            for (String skuCode : skus.keySet()) {
                List barCodesBySku = (List)skuBarcodeMap.get(skuCode);
                if (CollectionUtils.isEmpty((Collection)barCodesBySku)) continue;
                SkuQtt skuQtt = (SkuQtt)skus.get(skuCode);
                for (String barCode : barCodesBySku) {
                    BarcodeQtt barcodeQtt = new BarcodeQtt(barCode);
                    skuQtt.barcodes.add(barcodeQtt);
                    WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
                    cond.setBarCode(barCode);
                    cond.setSkuCode(skuCode);
                    cond.setSkuStatus(this.skuStatus);
                    cond.setPhysicalWarehouseCode(connect.getPhysicalWarehouseCode());
                    List<WhWmsSkuStockVO> wmsSkuAvailableAccount = null;
                    WarehouseArea area = null;
                    cond.setHouseTypes(WhWmsCommandConnectServiceImpl.this.whWmsWarehouseAreaService.getHouseTypesByType("NORMAL"));
                    wmsSkuAvailableAccount = WhWmsCommandConnectServiceImpl.this.whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                    area = new WarehouseArea("NORMAL");
                    barcodeQtt.areas.add(area);
                    area.stocks.addAll(wmsSkuAvailableAccount);
                }
            }
        }

        @Override
        public void occupy(FilterStragetyContextAlt context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            Map skus = context.skus;
            block4: for (String skuCode : skus.keySet()) {
                SkuQtt skuQtt = (SkuQtt)skus.get(skuCode);
                int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                for (BarcodeQtt b : skuQtt.barcodes) {
                    SkuQtt skuQtt2;
                    WhWmsOccupyVO occupyVO2;
                    WarehouseArea areaNormal = null;
                    for (WarehouseArea area : b.areas) {
                        if (!area.type.equals("NORMAL")) continue;
                        areaNormal = area;
                    }
                    ArrayList<WhWmsSkuStockVO> pickingStocks = new ArrayList<WhWmsSkuStockVO>();
                    ArrayList<WhWmsSkuStockVO> holdingStocks = new ArrayList<WhWmsSkuStockVO>();
                    for (WhWmsSkuStockVO stock : areaNormal.stocks) {
                        WhWmsHouseShelvesVO hs = WhWmsCommandConnectServiceImpl.this.whWmsHouseShelvesService.getHouseShelvesByCode(stock.getShelvesCode());
                        stock.setShelvesSortOrder(hs.getSortOrder());
                        if (hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING)) {
                            pickingStocks.add(stock);
                            continue;
                        }
                        if (!hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING)) continue;
                        holdingStocks.add(stock);
                    }
                    WhWmsCommandConnectServiceImpl.this.sortSkuStock(pickingStocks);
                    for (WhWmsSkuStockVO stock : pickingStocks) {
                        int availableOccupyQuantity;
                        if (occupyQuantity <= 0) continue;
                        int n = availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount() ? occupyQuantity : stock.getAvailableAccount();
                        if (availableOccupyQuantity <= 0) continue;
                        try {
                            occupyVO2 = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                            occupyVO2.setAmount(0 - availableOccupyQuantity);
                            occupyVO2.setReceiptsNo(connect.getId().toString());
                            occupyVO2.setType(WhWmsOccupyVO.TYPE_CONNECT);
                            WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO2);
                            skuQtt2 = skuQtt;
                            skuQtt2.disposeQuantity = skuQtt2.disposeQuantity + availableOccupyQuantity;
                            occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                        }
                        catch (Exception occupyVO2) {}
                    }
                    if (occupyQuantity == 0) continue block4;
                    WhWmsCommandConnectServiceImpl.this.sortSkuStock(holdingStocks);
                    for (WhWmsSkuStockVO stock : holdingStocks) {
                        int availableOccupyQuantity;
                        if (occupyQuantity <= 0) continue;
                        int n = availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount() ? occupyQuantity : stock.getAvailableAccount();
                        if (availableOccupyQuantity <= 0) continue;
                        try {
                            occupyVO2 = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                            occupyVO2.setAmount(0 - availableOccupyQuantity);
                            occupyVO2.setReceiptsNo(connect.getId().toString());
                            occupyVO2.setType(WhWmsOccupyVO.TYPE_CONNECT);
                            WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO2);
                            skuQtt2 = skuQtt;
                            skuQtt2.disposeQuantity = skuQtt2.disposeQuantity + availableOccupyQuantity;
                            occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                        }
                        catch (Exception exception) {}
                    }
                    if (occupyQuantity != 0) continue;
                    continue block4;
                }
            }
        }
    }

    private class FilterStragetyD
    extends AbstractFilterStragety {
        private FilterStragetyD() {
        }

        @Override
        public void filter(FilterStragetyContext context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            HashMap skus = new HashMap();
            context.skus = skus;
            for (int i = 0; i < connect.getWhCommandsCodes().size(); ++i) {
                WhCommand whCommand = connect.getWhCommands().get(i);
                WhWmsCommandConnectServiceImpl.this._setSkuQttMap(skus, whCommand);
            }
            for (String skuCode : skus.keySet()) {
                ArrayList<String> barCodesBySku = new ArrayList<String>(WhWmsCommandConnectServiceImpl.this.whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndUnexpiredSortByExpiredAsc(skuCode));
                ArrayList<String> _barCodesBySku = new ArrayList<String>(WhWmsCommandConnectServiceImpl.this.whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndNullExpired(skuCode));
                barCodesBySku.addAll(_barCodesBySku);
                if (CollectionUtils.isEmpty(barCodesBySku)) continue;
                SkuQtt skuQtt = (SkuQtt)skus.get(skuCode);
                for (String barCode : barCodesBySku) {
                    BarcodeQtt barcodeQtt = new BarcodeQtt(barCode);
                    skuQtt.barcodes.add(barcodeQtt);
                    WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
                    cond.setBarCode(barCode);
                    cond.setSkuCode(skuCode);
                    cond.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE);
                    cond.setPhysicalWarehouseCode(connect.getPhysicalWarehouseCode());
                    List<WhWmsSkuStockVO> wmsSkuAvailableAccount = null;
                    WarehouseArea area = null;
                    cond.setHouseTypes(WhWmsCommandConnectServiceImpl.this.whWmsWarehouseAreaService.getHouseTypesByType("NORMAL"));
                    wmsSkuAvailableAccount = WhWmsCommandConnectServiceImpl.this.whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                    area = new WarehouseArea("NORMAL");
                    barcodeQtt.areas.add(area);
                    area.stocks.addAll(wmsSkuAvailableAccount);
                }
            }
            WhWmsCommandConnectServiceImpl.this._filterConnectCommand(skus, connect);
        }

        @Override
        public void occupy(FilterStragetyContext context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            if (connect.getWhCommands().get(0).getInOutType().equals(WhCommand.TYPE_ALLOT_OUT)) {
                Map skus = context.skus;
                block2: for (String skuCode : skus.keySet()) {
                    SkuQtt skuQtt = (SkuQtt)skus.get(skuCode);
                    int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                    for (BarcodeQtt b : skuQtt.barcodes) {
                        WarehouseArea areaSample = null;
                        for (WarehouseArea area : b.areas) {
                            if (!area.type.equals("HOUSE_TYPE_SAMPLE")) continue;
                            areaSample = area;
                        }
                        for (WhWmsSkuStockVO stock : areaSample.stocks) {
                            int availableOccupyQuantity;
                            if (occupyQuantity <= 0) continue;
                            int n = availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount() ? occupyQuantity : stock.getAvailableAccount();
                            if (availableOccupyQuantity <= 0) continue;
                            try {
                                WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO.setAmount(0 - availableOccupyQuantity);
                                occupyVO.setReceiptsNo(connect.getId().toString());
                                occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO);
                                SkuQtt skuQtt2 = skuQtt;
                                skuQtt2.disposeQuantity = skuQtt2.disposeQuantity + availableOccupyQuantity;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }
                            catch (Exception occupyVO) {}
                        }
                        if (occupyQuantity != 0) continue;
                        continue block2;
                    }
                }
            } else {
                Map skus = context.skus;
                for (String skuCode : skus.keySet()) {
                    SkuQtt skuQtt = (SkuQtt)skus.get(skuCode);
                    int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                    for (BarcodeQtt b : skuQtt.barcodes) {
                        WarehouseArea areaSample = null;
                        for (WarehouseArea area : b.areas) {
                            if (!area.type.equals("HOUSE_TYPE_SAMPLE")) continue;
                            areaSample = area;
                        }
                        for (WhWmsSkuStockVO stock : areaSample.stocks) {
                            int availableOccupyQuantity;
                            if (occupyQuantity <= 0) continue;
                            int n = availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount() ? occupyQuantity : stock.getAvailableAccount();
                            if (availableOccupyQuantity <= 0) continue;
                            WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                            occupyVO.setAmount(0 - availableOccupyQuantity);
                            occupyVO.setReceiptsNo(connect.getId().toString());
                            occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                            WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO);
                            SkuQtt skuQtt3 = skuQtt;
                            skuQtt3.disposeQuantity = skuQtt3.disposeQuantity + availableOccupyQuantity;
                            occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                        }
                        if (occupyQuantity != 0) continue;
                        break;
                    }
                    if (occupyQuantity <= 0) continue;
                    throw new WarehouseException("WMS0002", "\u5e93\u5b58\u5360\u7528\u5931\u8d25");
                }
            }
        }
    }

    private class FilterStragetyC
    extends AbstractFilterStragety {
        private FilterStragetyC() {
        }

        @Override
        public void filter(FilterStragetyContext context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            HashMap skus = new HashMap();
            context.skus = skus;
            for (int i = 0; i < connect.getWhCommandsCodes().size(); ++i) {
                WhCommand whCommand = connect.getWhCommands().get(i);
                WhWmsCommandConnectServiceImpl.this._setSkuQttMap(skus, whCommand);
            }
            for (String skuCode : skus.keySet()) {
                ArrayList<String> barCodesBySku = new ArrayList<String>(WhWmsCommandConnectServiceImpl.this.whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndUnexpiredSortByExpiredAsc(skuCode));
                ArrayList<String> _barCodesBySku = new ArrayList<String>(WhWmsCommandConnectServiceImpl.this.whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndNullExpired(skuCode));
                barCodesBySku.addAll(_barCodesBySku);
                if (CollectionUtils.isEmpty(barCodesBySku)) continue;
                SkuQtt skuQtt = (SkuQtt)skus.get(skuCode);
                for (String barCode : barCodesBySku) {
                    BarcodeQtt barcodeQtt = new BarcodeQtt(barCode);
                    skuQtt.barcodes.add(barcodeQtt);
                    WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
                    cond.setBarCode(barCode);
                    cond.setSkuCode(skuCode);
                    cond.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
                    cond.setPhysicalWarehouseCode(connect.getPhysicalWarehouseCode());
                    List<WhWmsSkuStockVO> wmsSkuAvailableAccount = null;
                    WarehouseArea area = null;
                    cond.setHouseTypes(WhWmsCommandConnectServiceImpl.this.whWmsWarehouseAreaService.getHouseTypesByType("NORMAL"));
                    wmsSkuAvailableAccount = WhWmsCommandConnectServiceImpl.this.whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                    area = new WarehouseArea("NORMAL");
                    barcodeQtt.areas.add(area);
                    area.stocks.addAll(wmsSkuAvailableAccount);
                }
            }
            WhWmsCommandConnectServiceImpl.this._filterConnectCommand(skus, connect);
        }

        @Override
        public void occupy(FilterStragetyContext context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            if (connect.getWhCommands().get(0).getInOutType().equals(WhCommand.TYPE_ALLOT_OUT)) {
                Map skus = context.skus;
                block2: for (String skuCode : skus.keySet()) {
                    SkuQtt skuQtt = (SkuQtt)skus.get(skuCode);
                    int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                    for (BarcodeQtt b : skuQtt.barcodes) {
                        WarehouseArea areaDefective = null;
                        for (WarehouseArea area : b.areas) {
                            if (!area.type.equals("HOUSE_TYPE_DEFECTIVE")) continue;
                            areaDefective = area;
                        }
                        for (WhWmsSkuStockVO stock : areaDefective.stocks) {
                            int availableOccupyQuantity;
                            if (occupyQuantity <= 0) continue;
                            int n = availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount() ? occupyQuantity : stock.getAvailableAccount();
                            if (availableOccupyQuantity <= 0) continue;
                            try {
                                WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO.setAmount(0 - availableOccupyQuantity);
                                occupyVO.setReceiptsNo(connect.getId().toString());
                                occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO);
                                SkuQtt skuQtt2 = skuQtt;
                                skuQtt2.disposeQuantity = skuQtt2.disposeQuantity + availableOccupyQuantity;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }
                            catch (Exception occupyVO) {}
                        }
                        if (occupyQuantity != 0) continue;
                        continue block2;
                    }
                }
            } else {
                Map skus = context.skus;
                for (String skuCode : skus.keySet()) {
                    SkuQtt skuQtt = (SkuQtt)skus.get(skuCode);
                    int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                    for (BarcodeQtt b : skuQtt.barcodes) {
                        WarehouseArea areaDefective = null;
                        for (WarehouseArea area : b.areas) {
                            if (!area.type.equals("HOUSE_TYPE_DEFECTIVE")) continue;
                            areaDefective = area;
                        }
                        for (WhWmsSkuStockVO stock : areaDefective.stocks) {
                            int availableOccupyQuantity;
                            if (occupyQuantity <= 0) continue;
                            int n = availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount() ? occupyQuantity : stock.getAvailableAccount();
                            if (availableOccupyQuantity <= 0) continue;
                            WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                            occupyVO.setAmount(0 - availableOccupyQuantity);
                            occupyVO.setReceiptsNo(connect.getId().toString());
                            occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                            WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO);
                            SkuQtt skuQtt3 = skuQtt;
                            skuQtt3.disposeQuantity = skuQtt3.disposeQuantity + availableOccupyQuantity;
                            occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                        }
                        if (occupyQuantity != 0) continue;
                        break;
                    }
                    if (occupyQuantity <= 0) continue;
                    throw new WarehouseException("WMS0002", "\u5e93\u5b58\u5360\u7528\u5931\u8d25");
                }
            }
        }
    }

    private class FilterStragetyB
    extends AbstractFilterStragety {
        private Integer skuStatus;

        public FilterStragetyB(Integer skuStatus) {
            this.skuStatus = skuStatus;
        }

        @Override
        public void filter(FilterStragetyContext context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            HashMap skus = new HashMap();
            context.skus = skus;
            for (int i = 0; i < connect.getWhCommandsCodes().size(); ++i) {
                WhCommand whCommand = connect.getWhCommands().get(i);
                WhWmsCommandConnectServiceImpl.this._setSkuQttMap(skus, whCommand);
            }
            HashMap<String, List<String>> houseTypeMap = new HashMap<String, List<String>>();
            for (String skuCode : skus.keySet()) {
                ArrayList<String> barCodesBySku = new ArrayList<String>(WhWmsCommandConnectServiceImpl.this.whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndUnexpiredSortByExpiredAsc(skuCode));
                ArrayList<String> _barCodesBySku = new ArrayList<String>(WhWmsCommandConnectServiceImpl.this.whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndNullExpired(skuCode));
                barCodesBySku.addAll(_barCodesBySku);
                if (CollectionUtils.isEmpty(barCodesBySku)) continue;
                SkuQtt skuQtt = (SkuQtt)skus.get(skuCode);
                for (String barCode : barCodesBySku) {
                    BarcodeQtt barcodeQtt = new BarcodeQtt(barCode);
                    skuQtt.barcodes.add(barcodeQtt);
                    WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
                    cond.setBarCode(barCode);
                    cond.setSkuCode(skuCode);
                    cond.setSkuStatus(this.skuStatus);
                    cond.setPhysicalWarehouseCode(connect.getPhysicalWarehouseCode());
                    List<WhWmsSkuStockVO> wmsSkuAvailableAccount = null;
                    WarehouseArea area = null;
                    List<String> houseTypes = (List<String>)houseTypeMap.get("NORMAL");
                    if (NullUtil.isNull((Object)houseTypes) && EmptyUtil.isNotEmpty(houseTypes = WhWmsCommandConnectServiceImpl.this.whWmsWarehouseAreaService.getHouseTypesByType("NORMAL"))) {
                        houseTypeMap.put("NORMAL", houseTypes);
                    }
                    cond.setHouseTypes(houseTypes);
                    wmsSkuAvailableAccount = WhWmsCommandConnectServiceImpl.this.whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                    area = new WarehouseArea("NORMAL");
                    barcodeQtt.areas.add(area);
                    area.stocks.addAll(wmsSkuAvailableAccount);
                    houseTypes = (List<String>)houseTypeMap.get("ACTIVE");
                    if (NullUtil.isNull((Object)houseTypes) && EmptyUtil.isNotEmpty(houseTypes = WhWmsCommandConnectServiceImpl.this.whWmsWarehouseAreaService.getHouseTypesByType("ACTIVE"))) {
                        houseTypeMap.put("ACTIVE", houseTypes);
                    }
                    cond.setHouseTypes(houseTypes);
                    wmsSkuAvailableAccount = WhWmsCommandConnectServiceImpl.this.whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                    area = new WarehouseArea("ACTIVE");
                    barcodeQtt.areas.add(area);
                    area.stocks.addAll(wmsSkuAvailableAccount);
                }
            }
            WhWmsCommandConnectServiceImpl.this._filterConnectCommand(skus, connect);
        }

        @Override
        public void occupy(FilterStragetyContext context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            if (connect.getWhCommands().get(0).getInOutType().equals(WhCommand.TYPE_ALLOT_OUT)) {
                Map skus = context.skus;
                block6: for (String skuCode : skus.keySet()) {
                    SkuQtt skuQtt = (SkuQtt)skus.get(skuCode);
                    int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                    for (BarcodeQtt b : skuQtt.barcodes) {
                        SkuQtt skuQtt2;
                        WhWmsOccupyVO occupyVO2;
                        WarehouseArea areaNormal = null;
                        for (WarehouseArea area : b.areas) {
                            if (!"NORMAL".equals(area.type)) continue;
                            areaNormal = area;
                        }
                        ArrayList<WhWmsSkuStockVO> pickingStocks = new ArrayList<WhWmsSkuStockVO>();
                        ArrayList<WhWmsSkuStockVO> holdingStocks = new ArrayList<WhWmsSkuStockVO>();
                        for (WhWmsSkuStockVO stock : areaNormal.stocks) {
                            WhWmsHouseShelvesVO hs = WhWmsCommandConnectServiceImpl.this.whWmsHouseShelvesService.getHouseShelvesByCode(stock.getShelvesCode());
                            stock.setShelvesSortOrder(hs.getSortOrder());
                            if (hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING)) {
                                pickingStocks.add(stock);
                                continue;
                            }
                            if (!hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING)) continue;
                            holdingStocks.add(stock);
                        }
                        if (occupyQuantity == 0) continue block6;
                        WhWmsCommandConnectServiceImpl.this.sortSkuStock(pickingStocks);
                        for (WhWmsSkuStockVO stock : pickingStocks) {
                            int availableOccupyQuantity;
                            if (occupyQuantity <= 0) continue;
                            int n = availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount() ? occupyQuantity : stock.getAvailableAccount();
                            if (availableOccupyQuantity <= 0) continue;
                            try {
                                occupyVO2 = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO2.setAmount(0 - availableOccupyQuantity);
                                occupyVO2.setReceiptsNo(connect.getId().toString());
                                occupyVO2.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO2);
                                skuQtt2 = skuQtt;
                                skuQtt2.disposeQuantity = skuQtt2.disposeQuantity + availableOccupyQuantity;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }
                            catch (Exception occupyVO2) {}
                        }
                        if (occupyQuantity == 0) continue block6;
                        WhWmsCommandConnectServiceImpl.this.sortSkuStock(holdingStocks);
                        for (WhWmsSkuStockVO stock : holdingStocks) {
                            int availableOccupyQuantity;
                            if (occupyQuantity <= 0) continue;
                            int n = availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount() ? occupyQuantity : stock.getAvailableAccount();
                            if (availableOccupyQuantity <= 0) continue;
                            try {
                                occupyVO2 = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO2.setAmount(0 - availableOccupyQuantity);
                                occupyVO2.setReceiptsNo(connect.getId().toString());
                                occupyVO2.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO2);
                                skuQtt2 = skuQtt;
                                skuQtt2.disposeQuantity = skuQtt2.disposeQuantity + availableOccupyQuantity;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }
                            catch (Exception occupyVO3) {}
                        }
                        if (occupyQuantity != 0) continue;
                        continue block6;
                    }
                }
            } else {
                Map skus = context.skus;
                for (String skuCode : skus.keySet()) {
                    SkuQtt skuQtt = (SkuQtt)skus.get(skuCode);
                    int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                    for (BarcodeQtt b : skuQtt.barcodes) {
                        Object stock2;
                        Object area2;
                        Iterator areaActive = null;
                        for (Object area2 : b.areas) {
                            if (!"ACTIVE".equals(((WarehouseArea)area2).type)) continue;
                            areaActive = area2;
                        }
                        ArrayList<WhWmsSkuStockVO> activeStocks = new ArrayList<WhWmsSkuStockVO>();
                        for (Object stock2 : ((WarehouseArea)areaActive).stocks) {
                            WhWmsHouseShelvesVO hs = WhWmsCommandConnectServiceImpl.this.whWmsHouseShelvesService.getHouseShelvesByCode(((WhWmsSkuStockVO)stock2).getShelvesCode());
                            ((WhWmsSkuStockVO)stock2).setShelvesSortOrder(hs.getSortOrder());
                            if (!"HOUSE_TYPE_ACTIVE".equals(hs.getHouseType())) continue;
                            activeStocks.add((WhWmsSkuStockVO)stock2);
                        }
                        WhWmsCommandConnectServiceImpl.this.sortSkuStock(activeStocks);
                        area2 = activeStocks.iterator();
                        while (area2.hasNext()) {
                            int availableOccupyQuantity;
                            stock2 = (WhWmsSkuStockVO)area2.next();
                            if (occupyQuantity <= 0) continue;
                            int n = availableOccupyQuantity = occupyQuantity <= ((WhWmsSkuStockVO)stock2).getAvailableAccount() ? occupyQuantity : ((WhWmsSkuStockVO)stock2).getAvailableAccount();
                            if (availableOccupyQuantity <= 0) continue;
                            try {
                                WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock((WhWmsSkuStockVO)stock2);
                                occupyVO.setAmount(0 - availableOccupyQuantity);
                                occupyVO.setReceiptsNo(connect.getId().toString());
                                occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO);
                                SkuQtt occupyVO3 = skuQtt;
                                occupyVO3.disposeQuantity = occupyVO3.disposeQuantity + availableOccupyQuantity;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }
                            catch (Exception exception) {}
                        }
                        if (occupyQuantity == 0) break;
                        WarehouseArea areaNormal = null;
                        stock2 = b.areas.iterator();
                        while (stock2.hasNext()) {
                            WarehouseArea area3 = (WarehouseArea)stock2.next();
                            if (!area3.type.equals("NORMAL")) continue;
                            areaNormal = area3;
                        }
                        ArrayList<WhWmsSkuStockVO> pickingStocks = new ArrayList<WhWmsSkuStockVO>();
                        ArrayList<WhWmsSkuStockVO> holdingStocks = new ArrayList<WhWmsSkuStockVO>();
                        for (WhWmsSkuStockVO stock3 : areaNormal.stocks) {
                            WhWmsHouseShelvesVO hs = WhWmsCommandConnectServiceImpl.this.whWmsHouseShelvesService.getHouseShelvesByCode(stock3.getShelvesCode());
                            stock3.setShelvesSortOrder(hs.getSortOrder());
                            if (hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING)) {
                                pickingStocks.add(stock3);
                                continue;
                            }
                            if (!hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING)) continue;
                            holdingStocks.add(stock3);
                        }
                        WhWmsCommandConnectServiceImpl.this.sortSkuStock(pickingStocks);
                        for (WhWmsSkuStockVO stock3 : pickingStocks) {
                            int availableOccupyQuantity;
                            if (occupyQuantity <= 0) continue;
                            int n = availableOccupyQuantity = occupyQuantity <= stock3.getAvailableAccount() ? occupyQuantity : stock3.getAvailableAccount();
                            if (availableOccupyQuantity <= 0) continue;
                            WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock3);
                            occupyVO.setAmount(0 - availableOccupyQuantity);
                            occupyVO.setReceiptsNo(connect.getId().toString());
                            occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                            WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO);
                            SkuQtt skuQtt3 = skuQtt;
                            skuQtt3.disposeQuantity = skuQtt3.disposeQuantity + availableOccupyQuantity;
                            occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                        }
                        if (occupyQuantity == 0) break;
                        WhWmsCommandConnectServiceImpl.this.sortSkuStock(holdingStocks);
                        for (WhWmsSkuStockVO stock3 : holdingStocks) {
                            int availableOccupyQuantity;
                            if (occupyQuantity <= 0) continue;
                            int n = availableOccupyQuantity = occupyQuantity <= stock3.getAvailableAccount() ? occupyQuantity : stock3.getAvailableAccount();
                            if (availableOccupyQuantity <= 0) continue;
                            WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
                            whWmsHouseShelvesCond.setPhysicalWarehouseCode(stock3.getPhysicalWarehouseCode());
                            whWmsHouseShelvesCond.setType("NORMAL");
                            whWmsHouseShelvesCond.setShelvesUsableStatus(WhWmsHouseShelvesVO.SHELVES_USABLE_SUATUS_AVAILABLE);
                            whWmsHouseShelvesCond.setSkuCode(stock3.getSkuCode());
                            whWmsHouseShelvesCond.setShelvesType(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING);
                            List<WhWmsHouseShelvesVO> hs = WhWmsCommandConnectServiceImpl.this.whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
                            if (CollectionUtils.isEmpty(hs)) {
                                WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock3);
                                occupyVO.setAmount(0 - availableOccupyQuantity);
                                occupyVO.setReceiptsNo(connect.getId().toString());
                                occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO);
                            } else {
                                WhWmsHouseShelvesVO targetShelvesVO = hs.get(0);
                                WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
                                moveStockVO.setPhysicalWarehouseCode(stock3.getPhysicalWarehouseCode());
                                moveStockVO.setCreateUserId(connect.getConnectUserId());
                                moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_SUPPLEMENT);
                                ArrayList<WhWmsMoveSkuVO> moveStockList = new ArrayList<WhWmsMoveSkuVO>();
                                WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                                moveSkuVO.setPhysicalWarehouseCode(stock3.getPhysicalWarehouseCode());
                                moveSkuVO.setSkuCode(stock3.getSkuCode());
                                moveSkuVO.setSkuStatus(stock3.getSkuStatus());
                                moveSkuVO.setBarCode(stock3.getBarCode());
                                moveSkuVO.setOriginalHouseType(stock3.getHouseType());
                                moveSkuVO.setOriginalShelvesCode(stock3.getShelvesCode());
                                moveSkuVO.setTargetHouseType(targetShelvesVO.getHouseType());
                                moveSkuVO.setTargetShelvesCode(targetShelvesVO.getCode());
                                moveSkuVO.setAmount(availableOccupyQuantity);
                                moveStockList.add(moveSkuVO);
                                moveStockVO.setMoveSkuList(moveStockList);
                                WhWmsCommandConnectServiceImpl.this.whWmsMoveStockService.newMoveStock(moveStockVO);
                                WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock3);
                                occupyVO.setAmount(0 - availableOccupyQuantity);
                                occupyVO.setReceiptsNo(connect.getId().toString());
                                occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                occupyVO.setHouseType(targetShelvesVO.getHouseType());
                                occupyVO.setOriShelvesCode(targetShelvesVO.getCode());
                                WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO);
                            }
                            SkuQtt skuQtt4 = skuQtt;
                            skuQtt4.disposeQuantity = skuQtt4.disposeQuantity + availableOccupyQuantity;
                            occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                        }
                        if (occupyQuantity != 0) continue;
                        break;
                    }
                    if (occupyQuantity <= 0) continue;
                    throw new WarehouseException("WMS0002", "\u5e93\u5b58\u5360\u7528\u5931\u8d25");
                }
            }
        }
    }

    private class FilterStragetyA
    extends AbstractFilterStragety {
        private FilterStragetyA() {
        }

        @Override
        public void filter(FilterStragetyContext context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            HashMap skus = new HashMap();
            context.skus = skus;
            for (int i = 0; i < connect.getWhCommandsCodes().size(); ++i) {
                WhCommand whCommand = connect.getWhCommands().get(i);
                WhWmsCommandConnectServiceImpl.this._setSkuQttMap(skus, whCommand);
            }
            for (String skuCode : skus.keySet()) {
                ArrayList<String> barCodesBySku = new ArrayList<String>(WhWmsCommandConnectServiceImpl.this.whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndUnexpiredSortByExpiredAsc(skuCode));
                ArrayList<String> _barCodesBySku = new ArrayList<String>(WhWmsCommandConnectServiceImpl.this.whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndNullExpired(skuCode));
                barCodesBySku.addAll(_barCodesBySku);
                if (CollectionUtils.isEmpty(barCodesBySku)) continue;
                SkuQtt skuQtt = (SkuQtt)skus.get(skuCode);
                for (String barCode : barCodesBySku) {
                    BarcodeQtt barcodeQtt = new BarcodeQtt(barCode);
                    skuQtt.barcodes.add(barcodeQtt);
                    WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
                    cond.setBarCode(barCode);
                    cond.setSkuCode(skuCode);
                    cond.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
                    cond.setPhysicalWarehouseCode(connect.getPhysicalWarehouseCode());
                    List<WhWmsSkuStockVO> wmsSkuAvailableAccount = null;
                    WarehouseArea area = null;
                    cond.setHouseTypes(WhWmsCommandConnectServiceImpl.this.whWmsWarehouseAreaService.getHouseTypesByType("ACTIVE"));
                    wmsSkuAvailableAccount = WhWmsCommandConnectServiceImpl.this.whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                    area = new WarehouseArea("ACTIVE");
                    barcodeQtt.areas.add(area);
                    area.stocks.addAll(wmsSkuAvailableAccount);
                    cond.setHouseTypes(WhWmsCommandConnectServiceImpl.this.whWmsWarehouseAreaService.getHouseTypesByType("NORMAL"));
                    wmsSkuAvailableAccount = WhWmsCommandConnectServiceImpl.this.whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                    area = new WarehouseArea("NORMAL");
                    barcodeQtt.areas.add(area);
                    area.stocks.addAll(wmsSkuAvailableAccount);
                }
            }
            WhWmsCommandConnectServiceImpl.this._filterConnectCommand(skus, connect);
        }

        @Override
        public void occupy(FilterStragetyContext context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            if (connect.getWhCommands().get(0).getInOutType().equals(WhCommand.TYPE_ALLOT_OUT)) {
                Map skus = context.skus;
                block6: for (String skuCode : skus.keySet()) {
                    SkuQtt skuQtt = (SkuQtt)skus.get(skuCode);
                    int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                    for (BarcodeQtt b : skuQtt.barcodes) {
                        SkuQtt skuQtt2;
                        WhWmsOccupyVO occupyVO3;
                        WarehouseArea areaActive = null;
                        WarehouseArea areaNormal = null;
                        for (WarehouseArea area : b.areas) {
                            if (area.type.equals("ACTIVE")) {
                                areaActive = area;
                            }
                            if (!area.type.equals("NORMAL")) continue;
                            areaNormal = area;
                        }
                        for (WhWmsSkuStockVO stock : areaActive.stocks) {
                            int availableOccupyQuantity;
                            if (occupyQuantity <= 0) continue;
                            int n = availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount() ? occupyQuantity : stock.getAvailableAccount();
                            if (availableOccupyQuantity <= 0) continue;
                            try {
                                WhWmsOccupyVO occupyVO2 = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO2.setAmount(0 - availableOccupyQuantity);
                                occupyVO2.setReceiptsNo(connect.getId().toString());
                                occupyVO2.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO2);
                                SkuQtt skuQtt3 = skuQtt;
                                skuQtt3.disposeQuantity = skuQtt3.disposeQuantity + availableOccupyQuantity;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }
                            catch (Exception occupyVO2) {}
                        }
                        if (occupyQuantity == 0) continue block6;
                        ArrayList<WhWmsSkuStockVO> pickingStocks = new ArrayList<WhWmsSkuStockVO>();
                        ArrayList<WhWmsSkuStockVO> holdingStocks = new ArrayList<WhWmsSkuStockVO>();
                        for (WhWmsSkuStockVO stock : areaNormal.stocks) {
                            WhWmsHouseShelvesVO hs = WhWmsCommandConnectServiceImpl.this.whWmsHouseShelvesService.getHouseShelvesByCode(stock.getShelvesCode());
                            if (hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING)) {
                                pickingStocks.add(stock);
                                continue;
                            }
                            if (!hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING)) continue;
                            holdingStocks.add(stock);
                        }
                        for (WhWmsSkuStockVO stock : holdingStocks) {
                            int availableOccupyQuantity;
                            if (occupyQuantity <= 0) continue;
                            int n = availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount() ? occupyQuantity : stock.getAvailableAccount();
                            if (availableOccupyQuantity <= 0) continue;
                            try {
                                occupyVO3 = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO3.setAmount(0 - availableOccupyQuantity);
                                occupyVO3.setReceiptsNo(connect.getId().toString());
                                occupyVO3.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO3);
                                skuQtt2 = skuQtt;
                                skuQtt2.disposeQuantity = skuQtt2.disposeQuantity + availableOccupyQuantity;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }
                            catch (Exception occupyVO3) {}
                        }
                        if (occupyQuantity == 0) continue block6;
                        for (WhWmsSkuStockVO stock : pickingStocks) {
                            int availableOccupyQuantity2;
                            if (occupyQuantity <= 0) continue;
                            int n = availableOccupyQuantity2 = occupyQuantity <= stock.getAvailableAccount() ? occupyQuantity : stock.getAvailableAccount();
                            if (availableOccupyQuantity2 <= 0) continue;
                            try {
                                occupyVO3 = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO3.setAmount(0 - availableOccupyQuantity2);
                                occupyVO3.setReceiptsNo(connect.getId().toString());
                                occupyVO3.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO3);
                                skuQtt2 = skuQtt;
                                skuQtt2.disposeQuantity = skuQtt2.disposeQuantity + availableOccupyQuantity2;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }
                            catch (Exception occupyVO4) {}
                        }
                        if (occupyQuantity != 0) continue;
                        continue block6;
                    }
                }
            } else {
                Map skus = context.skus;
                for (String skuCode : skus.keySet()) {
                    SkuQtt skuQtt = (SkuQtt)skus.get(skuCode);
                    int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                    for (BarcodeQtt b : skuQtt.barcodes) {
                        WhWmsOccupyVO occupyVO;
                        WhWmsMoveSkuVO moveSkuVO;
                        ArrayList<WhWmsMoveSkuVO> moveStockList;
                        WhWmsMoveStockVO moveStockVO;
                        Object targetShelvesVO;
                        WhWmsOccupyVO occupyVO5;
                        List<WhWmsHouseShelvesVO> hs;
                        WhWmsHouseShelvesCond whWmsHouseShelvesCond;
                        WarehouseArea areaActive = null;
                        WarehouseArea areaNormal = null;
                        for (WarehouseArea area : b.areas) {
                            if (area.type.equals("ACTIVE")) {
                                areaActive = area;
                            }
                            if (!area.type.equals("NORMAL")) continue;
                            areaNormal = area;
                        }
                        for (WhWmsSkuStockVO stock : areaActive.stocks) {
                            int availableOccupyQuantity;
                            if (occupyQuantity <= 0) continue;
                            int n = availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount() ? occupyQuantity : stock.getAvailableAccount();
                            if (availableOccupyQuantity <= 0) continue;
                            WhWmsOccupyVO occupyVO6 = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                            occupyVO6.setAmount(0 - availableOccupyQuantity);
                            occupyVO6.setReceiptsNo(connect.getId().toString());
                            occupyVO6.setType(WhWmsOccupyVO.TYPE_CONNECT);
                            WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO6);
                            SkuQtt availableOccupyQuantity2 = skuQtt;
                            availableOccupyQuantity2.disposeQuantity = availableOccupyQuantity2.disposeQuantity + availableOccupyQuantity;
                            occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                        }
                        if (occupyQuantity == 0) break;
                        ArrayList pickingStocks = new ArrayList();
                        ArrayList<WhWmsSkuStockVO> holdingStocks = new ArrayList<WhWmsSkuStockVO>();
                        for (WhWmsSkuStockVO stock : areaNormal.stocks) {
                            WhWmsHouseShelvesVO hs2 = WhWmsCommandConnectServiceImpl.this.whWmsHouseShelvesService.getHouseShelvesByCode(stock.getShelvesCode());
                            if (hs2.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING)) {
                                pickingStocks.add(stock);
                                continue;
                            }
                            if (!hs2.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING)) continue;
                            holdingStocks.add(stock);
                        }
                        for (WhWmsSkuStockVO stock : holdingStocks) {
                            int availableOccupyQuantity;
                            if (occupyQuantity <= 0) continue;
                            int n = availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount() ? occupyQuantity : stock.getAvailableAccount();
                            if (availableOccupyQuantity <= 0) continue;
                            whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
                            whWmsHouseShelvesCond.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
                            whWmsHouseShelvesCond.setType("ACTIVE");
                            whWmsHouseShelvesCond.setShelvesUsableStatus(WhWmsHouseShelvesVO.SHELVES_USABLE_SUATUS_AVAILABLE);
                            whWmsHouseShelvesCond.setSkuCode(stock.getSkuCode());
                            hs = WhWmsCommandConnectServiceImpl.this.whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
                            if (CollectionUtils.isEmpty(hs)) {
                                occupyVO5 = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO5.setAmount(0 - availableOccupyQuantity);
                                occupyVO5.setReceiptsNo(connect.getId().toString());
                                occupyVO5.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO5);
                            } else {
                                targetShelvesVO = hs.get(0);
                                moveStockVO = new WhWmsMoveStockVO();
                                moveStockVO.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
                                moveStockVO.setCreateUserId(connect.getConnectUserId());
                                moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_SUPPLEMENT);
                                moveStockList = new ArrayList<WhWmsMoveSkuVO>();
                                moveSkuVO = new WhWmsMoveSkuVO();
                                moveSkuVO.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
                                moveSkuVO.setSkuCode(stock.getSkuCode());
                                moveSkuVO.setSkuStatus(stock.getSkuStatus());
                                moveSkuVO.setBarCode(stock.getBarCode());
                                moveSkuVO.setOriginalHouseType(stock.getHouseType());
                                moveSkuVO.setOriginalShelvesCode(stock.getShelvesCode());
                                moveSkuVO.setTargetHouseType(((WhWmsHouseShelvesVO)targetShelvesVO).getHouseType());
                                moveSkuVO.setTargetShelvesCode(((WhWmsHouseShelvesVO)targetShelvesVO).getCode());
                                moveSkuVO.setAmount(availableOccupyQuantity);
                                moveStockList.add(moveSkuVO);
                                moveStockVO.setMoveSkuList(moveStockList);
                                WhWmsCommandConnectServiceImpl.this.whWmsMoveStockService.newMoveStock(moveStockVO);
                                occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO.setAmount(0 - availableOccupyQuantity);
                                occupyVO.setReceiptsNo(connect.getId().toString());
                                occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                occupyVO.setHouseType(((WhWmsHouseShelvesVO)targetShelvesVO).getHouseType());
                                occupyVO.setOriShelvesCode(((WhWmsHouseShelvesVO)targetShelvesVO).getCode());
                                WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO);
                            }
                            targetShelvesVO = skuQtt;
                            ((SkuQtt)targetShelvesVO).disposeQuantity = ((SkuQtt)targetShelvesVO).disposeQuantity + availableOccupyQuantity;
                            occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                        }
                        if (occupyQuantity == 0) break;
                        Iterator iterator = pickingStocks.iterator();
                        while (iterator.hasNext()) {
                            int availableOccupyQuantity;
                            WhWmsSkuStockVO stock;
                            stock = (WhWmsSkuStockVO)iterator.next();
                            if (occupyQuantity <= 0) continue;
                            int n = availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount() ? occupyQuantity : stock.getAvailableAccount();
                            if (availableOccupyQuantity <= 0) continue;
                            whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
                            whWmsHouseShelvesCond.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
                            whWmsHouseShelvesCond.setType("ACTIVE");
                            whWmsHouseShelvesCond.setShelvesUsableStatus(WhWmsHouseShelvesVO.SHELVES_USABLE_SUATUS_AVAILABLE);
                            whWmsHouseShelvesCond.setSkuCode(stock.getSkuCode());
                            hs = WhWmsCommandConnectServiceImpl.this.whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
                            if (CollectionUtils.isEmpty(hs)) {
                                occupyVO5 = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO5.setAmount(0 - availableOccupyQuantity);
                                occupyVO5.setReceiptsNo(connect.getId().toString());
                                occupyVO5.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO5);
                            } else {
                                targetShelvesVO = hs.get(0);
                                moveStockVO = new WhWmsMoveStockVO();
                                moveStockVO.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
                                moveStockVO.setCreateUserId(connect.getConnectUserId());
                                moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_SUPPLEMENT);
                                moveStockList = new ArrayList();
                                moveSkuVO = new WhWmsMoveSkuVO();
                                moveSkuVO.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
                                moveSkuVO.setSkuCode(stock.getSkuCode());
                                moveSkuVO.setSkuStatus(stock.getSkuStatus());
                                moveSkuVO.setBarCode(stock.getBarCode());
                                moveSkuVO.setOriginalHouseType(stock.getHouseType());
                                moveSkuVO.setOriginalShelvesCode(stock.getShelvesCode());
                                moveSkuVO.setTargetHouseType(((WhWmsHouseShelvesVO)targetShelvesVO).getHouseType());
                                moveSkuVO.setTargetShelvesCode(((WhWmsHouseShelvesVO)targetShelvesVO).getCode());
                                moveSkuVO.setAmount(availableOccupyQuantity);
                                moveStockList.add(moveSkuVO);
                                moveStockVO.setMoveSkuList(moveStockList);
                                WhWmsCommandConnectServiceImpl.this.whWmsMoveStockService.newMoveStock(moveStockVO);
                                occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO.setAmount(0 - availableOccupyQuantity);
                                occupyVO.setReceiptsNo(connect.getId().toString());
                                occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                occupyVO.setHouseType(((WhWmsHouseShelvesVO)targetShelvesVO).getHouseType());
                                occupyVO.setOriShelvesCode(((WhWmsHouseShelvesVO)targetShelvesVO).getCode());
                                WhWmsCommandConnectServiceImpl.this.whWmsOccupyService.wmsOccupy(occupyVO);
                            }
                            SkuQtt skuQtt4 = skuQtt;
                            skuQtt4.disposeQuantity = skuQtt4.disposeQuantity + availableOccupyQuantity;
                            occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                        }
                        if (occupyQuantity != 0) continue;
                        break;
                    }
                    if (occupyQuantity <= 0) continue;
                    throw new WarehouseException("WMS0002", "\u5e93\u5b58\u5360\u7528\u5931\u8d25");
                }
            }
        }
    }

    private abstract class AbstractFilterStragetyRecWaste {
        private AbstractFilterStragetyRecWaste() {
        }

        public abstract void filter(FilterStragetyContextRecWaste var1);

        public abstract void occupy(FilterStragetyContextRecWaste var1);
    }

    private abstract class AbstractFilterStragetyAlt {
        private AbstractFilterStragetyAlt() {
        }

        public abstract void filter(FilterStragetyContextAlt var1);

        public abstract void occupy(FilterStragetyContextAlt var1);
    }

    private abstract class AbstractFilterStragety {
        private AbstractFilterStragety() {
        }

        public abstract void filter(FilterStragetyContext var1);

        public abstract void occupy(FilterStragetyContext var1);
    }

    private abstract class AbstractFilterStragetyPcsRtn {
        private AbstractFilterStragetyPcsRtn() {
        }

        public abstract void filter(FilterStragetyContextPcsRtn var1);

        public abstract void occupy(FilterStragetyContextPcsRtn var1);
    }

    private class FilterStragetyContextRecWaste {
        private WhWmsConnectInfoVO whWmsConnectInfoVO;
        private AbstractFilterStragetyRecWaste strategy;
        private Map<String, SkuQtt> skus;

        public FilterStragetyContextRecWaste(WhWmsConnectInfoVO whWmsConnectInfoVO) {
            this.whWmsConnectInfoVO = whWmsConnectInfoVO;
            this.strategy = new FilterStragetyRecWaste(whWmsConnectInfoVO.getSkuStatus());
        }

        public void filter() {
            this.strategy.filter(this);
        }

        public void occupy() {
            this.strategy.occupy(this);
        }
    }

    private class FilterStragetyContextAlt {
        private WhWmsConnectInfoVO whWmsConnectInfoVO;
        private AbstractFilterStragetyAlt strategy;
        private Map<String, SkuQtt> skus;

        public FilterStragetyContextAlt(WhWmsConnectInfoVO whWmsConnectInfoVO) {
            this.whWmsConnectInfoVO = whWmsConnectInfoVO;
            if (WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.keySet().contains(whWmsConnectInfoVO.getSkuStatus())) {
                this.strategy = new FilterStragetyAlt(whWmsConnectInfoVO.getSkuStatus());
            } else if (whWmsConnectInfoVO.getConnectType().equals("multi_product_multi_piece")) {
                this.strategy = new FilterStragetyAlt(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
            } else {
                throw new WarehouseException("WH0002", "\u8c03\u62e8\u6ce2\u6b21\u542f\u52a8\u51fa\u9519");
            }
        }

        public void filter() {
            this.strategy.filter(this);
        }

        public void occupy() {
            this.strategy.occupy(this);
        }
    }

    private class FilterStragetyContextPcsRtn {
        private WhWmsConnectInfoVO whWmsConnectInfoVO;
        private AbstractFilterStragetyPcsRtn strategy;
        private Map<String, SkuQtt> skus;

        public FilterStragetyContextPcsRtn(WhWmsConnectInfoVO whWmsConnectInfoVO) {
            this.whWmsConnectInfoVO = whWmsConnectInfoVO;
            if (WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.keySet().contains(whWmsConnectInfoVO.getSkuStatus())) {
                this.strategy = new FilterStragetyPcsRtn(whWmsConnectInfoVO.getSkuStatus());
            } else if (whWmsConnectInfoVO.getConnectType().equals("multi_product_multi_piece")) {
                this.strategy = new FilterStragetyPcsRtn(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
            } else {
                throw new WarehouseException("WH0002", "\u91c7\u9000\u6ce2\u6b21\u542f\u52a8\u51fa\u9519");
            }
        }

        public void filter() {
            this.strategy.filter(this);
        }

        public void occupy() {
            this.strategy.occupy(this);
        }
    }

    private class FilterStragetyContext {
        private WhWmsConnectInfoVO whWmsConnectInfoVO;
        private AbstractFilterStragety strategy;
        private Map<String, SkuQtt> skus;

        public FilterStragetyContext(WhWmsConnectInfoVO whWmsConnectInfoVO) {
            this.whWmsConnectInfoVO = whWmsConnectInfoVO;
            if (whWmsConnectInfoVO.getSkuStatus().equals(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED)) {
                this.strategy = new FilterStragetyB(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
            } else if (whWmsConnectInfoVO.getSkuStatus().equals(WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED)) {
                this.strategy = new FilterStragetyB(WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED);
            } else if (whWmsConnectInfoVO.getSkuStatus().equals(WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED)) {
                this.strategy = new FilterStragetyB(WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED);
            } else if (whWmsConnectInfoVO.getSkuStatus().equals(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE)) {
                this.strategy = new FilterStragetyB(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE);
            } else if (whWmsConnectInfoVO.getConnectType().equals("single_product_single_piece")) {
                this.strategy = new FilterStragetyB(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
            } else if (whWmsConnectInfoVO.getConnectType().equals("multi_product_single_piece")) {
                this.strategy = new FilterStragetyB(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
            } else if (whWmsConnectInfoVO.getConnectType().equals("multi_product_multi_piece")) {
                this.strategy = new FilterStragetyB(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
            } else {
                throw new WarehouseException("WH0002", "not found strategy");
            }
        }

        public void filter() {
            this.strategy.filter(this);
        }

        public void occupy() {
            this.strategy.occupy(this);
        }
    }

    private static class SkuQtt {
        private String skuCode;
        private int planedQuantity = 0;
        private int disposeQuantity = 0;
        private List<WhWmsSkuStockVO> pickedStock = new ArrayList<WhWmsSkuStockVO>();
        private List<BarcodeQtt> barcodes = new ArrayList<BarcodeQtt>();

        public SkuQtt(String skuCode) {
            this.skuCode = skuCode;
        }

        public int getAvailableQuantity() {
            int sum = 0;
            for (BarcodeQtt b : this.barcodes) {
                sum += b.getAvailableQuantity();
            }
            return sum;
        }

        public List<WhWmsSkuStockVO> getPickedStock() {
            return this.pickedStock;
        }

        public void addPickStock(WhWmsSkuStockVO skuStockVO) {
            this.pickedStock.add(skuStockVO);
        }
    }

    private static class BarcodeQtt {
        private String barcode;
        private List<WarehouseArea> areas = new ArrayList<WarehouseArea>();

        public BarcodeQtt(String barcode) {
            this.barcode = barcode;
        }

        public int getAvailableQuantity() {
            int sum = 0;
            for (WarehouseArea area : this.areas) {
                sum += area.getAvailableQuantity();
            }
            return sum;
        }
    }

    private static class WarehouseArea {
        private String type;
        private List<WhWmsSkuStockVO> stocks = new ArrayList<WhWmsSkuStockVO>();

        public WarehouseArea(String type) {
            this.type = type;
        }

        public int getAvailableQuantity() {
            int sum = 0;
            for (WhWmsSkuStockVO stock : this.stocks) {
                sum += stock.getAvailableAccount();
            }
            return sum;
        }
    }
}

