/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.integration.express.ExpressUtil;
import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.cond.WhCommandCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsCommandConnectCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsConnectPickSkuCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsCheckGiftCardMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsCommandCheckMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsCommandPreOccupyIdxMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsCheckGiftCard;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsCheckGiftCardExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsCommandCheck;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsCommandCheckExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandAssociateExpressService;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandCheckService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandConnectService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectDistributionService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectPickSkuService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsOperationRcdService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCheckGiftCardVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandCheckBatch;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandCheckInfo;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandCheckPara;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandCheckVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandConnectVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectCheckVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectDistributionVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectPickSkuSubmitDataVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectPickSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsOperationRcdVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsStartPutawayVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsWarehouseAreaVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whWmsCommandCheckService")
public class WhWmsCommandCheckServiceImpl
implements WhWmsCommandCheckService {
    @Autowired
    private WhWmsCommandCheckMapper mapper;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhWmsCommandConnectService whWmsCommandConnectService;
    @Autowired
    private WhWmsConnectInfoService whWmsConnectInfoService;
    @Autowired
    private WhWmsConnectDistributionService whWmsConnectDistributionService;
    @Autowired
    private WhWmsConnectPickSkuService whWmsConnectPickSkuService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;
    @Autowired
    private WhCommandAssociateExpressService whCommandAssociateExpressService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhWmsCommandPreOccupyIdxMapper whWmsCommandPreOccupyIdxMapper;
    @Autowired
    private WhWmsOperationRcdService whWmsOperationRcdService;
    @Autowired
    private WhWmsCheckGiftCardMapper whWmsCheckGiftCardMapper;

    @Override
    public WhWmsConnectPickSkuSubmitDataVO preCheckCommandCheck(List<WhWmsCommandCheckVO> vos, Long operatorId) {
        WhWmsConnectPickSkuSubmitDataVO whWmsConnectPickSkuSubmitDataVO = new WhWmsConnectPickSkuSubmitDataVO();
        if (CollectionUtils.isEmpty(vos)) {
            throw new WarehouseException("WH0002");
        }
        HashSet<String> commandCodes = new HashSet<String>();
        for (WhWmsCommandCheckVO vo : vos) {
            commandCodes.add(vo.getCommandCode());
        }
        if (CollectionUtils.isEmpty(commandCodes) || commandCodes.size() > 1) {
            throw new WarehouseException("WH0002");
        }
        WhCommand whCommand = this.whCommandService.findCommandByCode(vos.get(0).getCommandCode(), true);
        whWmsConnectPickSkuSubmitDataVO.setCommandList(Arrays.asList(whCommand));
        if (!whCommand.getCommandStatus().equals(WhCommand.STATUS_PACKING)) {
            throw new WarehouseException("WH0001", "\u51fa\u5e93\u6307\u4ee4\u5fc5\u987b\u662f\u5f85\u5305\u88c5\u72b6\u6001");
        }
        WhWmsCommandConnectVO commandConnectVO = this.whWmsCommandConnectService.findNotCanceledByWhCommandCode(whCommand.getCode());
        if (commandConnectVO == null) {
            throw new WarehouseException("WH0001", "\u8be5\u51fa\u5e93\u6307\u4ee4\u6ca1\u6709\u5173\u8054\u6ce2\u6b21");
        }
        WhWmsConnectInfoVO connectVO = this.whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
        if (!connectVO.getConnectStatus().equals(WMSConstants.ConnectStatus.FINISHED)) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u5fc5\u987b\u662f\u5df2\u5b8c\u6210\u72b6\u6001");
        }
        whWmsConnectPickSkuSubmitDataVO.setConnectVO(connectVO);
        if (whCommand.getCancelFlag().equals(1)) {
            throw new WarehouseException("WH0001", "\u8be5\u51fa\u5e93\u6307\u4ee4\u65e0\u6cd5\u51fa\u5e93\u5df2\u88ab\u53d6\u6d88");
        }
        this.preCheckAndBuildMoveSktock(vos, whWmsConnectPickSkuSubmitDataVO, connectVO, operatorId);
        return whWmsConnectPickSkuSubmitDataVO;
    }

    @Override
    public WhWmsConnectPickSkuSubmitDataVO preBatchCheckCommandCheck(List<WhWmsCommandCheckVO> vos, Long operatorId, List<WhCommand> whCommands) {
        WhWmsConnectPickSkuSubmitDataVO whWmsConnectPickSkuSubmitDataVO = new WhWmsConnectPickSkuSubmitDataVO();
        if (CollectionUtils.isEmpty(vos)) {
            throw new WarehouseException("WH0002");
        }
        WhWmsCommandConnectVO commandConnectVO = this.whWmsCommandConnectService.findNotCanceledByWhCommandCode(whCommands.get(0).getCode());
        if (commandConnectVO == null) {
            throw new WarehouseException("WH0001", "\u8be5\u51fa\u5e93\u6307\u4ee4\u6ca1\u6709\u5173\u8054\u6ce2\u6b21");
        }
        WhWmsConnectInfoVO connectVO = this.whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
        if (!connectVO.getConnectStatus().equals(WMSConstants.ConnectStatus.FINISHED)) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u5fc5\u987b\u662f\u5df2\u5b8c\u6210\u72b6\u6001");
        }
        whWmsConnectPickSkuSubmitDataVO.setCommandList(whCommands);
        for (WhCommand whCommand : whCommands) {
            if (!whCommand.getCommandStatus().equals(WhCommand.STATUS_PACKING)) {
                throw new WarehouseException("WH0001", "\u51fa\u5e93\u6307\u4ee4\u5fc5\u987b\u662f\u5f85\u5305\u88c5\u72b6\u6001");
            }
            if (!whCommand.getCancelFlag().equals(1)) continue;
            throw new WarehouseException("WH0001", "\u8be5\u51fa\u5e93\u6307\u4ee4\u65e0\u6cd5\u51fa\u5e93\u5df2\u88ab\u53d6\u6d88");
        }
        whWmsConnectPickSkuSubmitDataVO.setConnectVO(connectVO);
        this.preCheckAndBuildMoveSktock(vos, whWmsConnectPickSkuSubmitDataVO, connectVO, operatorId);
        return whWmsConnectPickSkuSubmitDataVO;
    }

    public void preCheckAndBuildMoveSktock(List<WhWmsCommandCheckVO> vos, WhWmsConnectPickSkuSubmitDataVO whWmsConnectPickSkuSubmitDataVO, WhWmsConnectInfoVO connectVO, Long operatorId) {
        List<WhWmsHouseShelvesVO> hsPacking;
        WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
        whWmsHouseShelvesCond.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
        whWmsHouseShelvesCond.setHouseType("HOUSE_TYPE_HANDOVER");
        List<WhWmsHouseShelvesVO> hs = this.whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if (CollectionUtils.isEmpty(hs) || hs.size() > 1) {
            throw new WarehouseException("WMS0001", "\u6ca1\u6709\u5408\u9002\u7684\u76ee\u6807\u5e93\u4f4d,\u4ea4\u63a5\u533a");
        }
        WhWmsHouseShelvesVO targetShelvesVO = hs.get(0);
        whWmsHouseShelvesCond.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
        whWmsHouseShelvesCond.setHouseType("HOUSE_TYPE_PACKING");
        if (connectVO.getConnectType().equals("multi_product_single_piece")) {
            whWmsHouseShelvesCond.setHouseType("HOUSE_TYPE_PACKING");
        }
        if (CollectionUtils.isEmpty(hsPacking = this.whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond)) || hsPacking.size() > 1) {
            throw new WarehouseException("WMS0001", "\u6ca1\u6709\u5408\u9002\u7684\u76ee\u6807\u5e93\u4f4d,\u5206\u62e8\u5305\u88c5\u533a");
        }
        WhWmsHouseShelvesVO sourceShelvesVO = hsPacking.get(0);
        for (WhWmsCommandCheckVO vo : vos) {
            if (vo.getIsMaterial().equals(1)) {
                vo.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
                continue;
            }
            vo.setSkuStatus(connectVO.getSkuStatus());
        }
        WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
        moveStockVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
        moveStockVO.setCreateUserId(operatorId);
        moveStockVO.setOperatorId(operatorId);
        moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_COMMON);
        ArrayList<WhWmsMoveSkuVO> moveStockSkuList = new ArrayList<WhWmsMoveSkuVO>();
        moveStockVO.setMoveSkuList(moveStockSkuList);
        for (WhWmsCommandCheckVO vo : vos) {
            WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
            moveSkuVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
            moveSkuVO.setSkuCode(vo.getSkuCode());
            moveSkuVO.setSkuStatus(vo.getSkuStatus());
            moveSkuVO.setBarCode(vo.getBarCode());
            moveSkuVO.setOriginalHouseType(sourceShelvesVO.getHouseType());
            moveSkuVO.setOriginalShelvesCode(sourceShelvesVO.getCode());
            moveSkuVO.setTargetHouseType(targetShelvesVO.getHouseType());
            moveSkuVO.setTargetShelvesCode(targetShelvesVO.getCode());
            moveSkuVO.setAmount(vo.getCheckAmount());
            moveStockSkuList.add(moveSkuVO);
        }
        this.whWmsMoveStockService.rebuildMoveStock(moveStockVO);
        this.whWmsMoveStockService.moveStockCheck(moveStockVO);
        whWmsConnectPickSkuSubmitDataVO.setMoveStockVO(moveStockVO);
    }

    @Override
    @Transactional
    public boolean submitConnectCheck(WhWmsConnectCheckVO connectCheck) {
        if (EmptyUtil.isNotEmpty(connectCheck.getOutCommandList())) {
            ArrayList<WhWmsCommandCheckVO> commandCheckList = new ArrayList<WhWmsCommandCheckVO>();
            Map<String, Integer> barcodeMap = connectCheck.getCheckBarCodeMap();
            Map<String, Integer> groupSkuMap = connectCheck.getGroupSkuMap();
            ArrayList<String> outCommandCodes = new ArrayList<String>();
            for (WhCommand cmd : connectCheck.getOutCommandList()) {
                outCommandCodes.add(cmd.getCode());
                for (String barCode : barcodeMap.keySet()) {
                    WhWmsCommandCheckVO cmdCheck = new WhWmsCommandCheckVO();
                    String skuCode = barCode.split("_")[0];
                    Integer singleGroupAmount = groupSkuMap.get(skuCode);
                    cmdCheck.setCommandCode(cmd.getCode());
                    cmdCheck.setBarCode(barCode);
                    cmdCheck.setSkuCode(skuCode);
                    cmdCheck.setAmount(singleGroupAmount);
                    cmdCheck.setCheckAmount(singleGroupAmount);
                    cmdCheck.setIsMaterial(0);
                    cmdCheck.setCancelFlag(0);
                    cmdCheck.setSkuStatus(connectCheck.getSkuStatus());
                    commandCheckList.add(cmdCheck);
                }
            }
            this.whCommandService.batchCommandInPackingToHandover(outCommandCodes);
            this.mapper.batchInsert(commandCheckList);
        }
        ArrayList<String> connectCommandCancelList = new ArrayList<String>();
        if (EmptyUtil.isNotEmpty(connectCheck.getCancelCommandCodes())) {
            connectCommandCancelList.addAll(connectCheck.getCancelCommandCodes());
            this.whCommandService.cancelCommandforShortage(connectCheck.getCancelCommandCodes(), WhCommand.STATUS_PACKING);
        }
        if (EmptyUtil.isNotEmpty(connectCheck.getShortageCommandCodes())) {
            connectCommandCancelList.addAll(connectCheck.getShortageCommandCodes());
            this.whCommandService.failureStartConnect(connectCheck.getShortageCommandCodes());
            this.whCommandService.batchUpdateCommandStatus(connectCheck.getShortageCommandCodes(), WhCommand.STATUS_IN_PROCESSING, WhCommand.STATUS_PACKING);
            this.whWmsCommandPreOccupyIdxMapper.batchDelete(connectCheck.getShortageCommandCodes());
        }
        if (EmptyUtil.isNotEmpty(connectCommandCancelList)) {
            this.whWmsCommandConnectService.batchCancel(connectCommandCancelList, connectCheck.getConnectId());
        }
        if (EmptyUtil.isNotEmpty(connectCheck.getMoveStockList())) {
            for (WhWmsMoveStockVO moveStock : connectCheck.getMoveStockList()) {
                if (NullUtil.isNull((Object)moveStock)) continue;
                if (moveStock.isAutoFinish()) {
                    this.whWmsMoveStockService.executeMoveStock(moveStock);
                } else {
                    this.whWmsMoveStockService.createMoveStock(moveStock);
                }
                if (!WhWmsMoveStockVO.MOVE_TYPE_CANCEL_MAKE.equals(moveStock.getMoveType())) continue;
                connectCheck.setToCancelMoveCode(moveStock.getCode());
            }
        }
        this.whWmsConnectPickSkuService.deleteConnectBox(connectCheck.getConnectId());
        return true;
    }

    public Boolean cancelBatchCheck(List<String> commandCodes, Long operatorId, List<WhWmsCommandCheckVO> vos, Integer stockoutCount, WhWmsCommandCheckPara whWmsCommandCheckPara) {
        if (EmptyUtil.isEmpty(commandCodes)) {
            throw new WarehouseException("WH0002");
        }
        WhCommandCond cond = new WhCommandCond();
        cond.setCodeList(commandCodes);
        List<WhCommand> whCommandList = this.whCommandService.findCommandByCond(cond);
        if (whCommandList != null && whCommandList.size() > 0) {
            for (WhCommand whCommand : whCommandList) {
                if (whCommand.getCommandStatus().equals(WhCommand.STATUS_PACKING)) continue;
                throw new WarehouseException("WH0001", "\u51fa\u5e93\u6307\u4ee4\u5fc5\u987b\u662f\u5f85\u5305\u88c5\u72b6\u6001");
            }
        } else {
            throw new WarehouseException("WH0001", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u51fa\u5e93\u6307\u4ee4");
        }
        if (commandCodes.size() != whCommandList.size()) {
            throw new WarehouseException("WH0001", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u51fa\u5e93\u6307\u4ee4");
        }
        WhWmsCommandConnectCond whWmsCommandConnectCond = new WhWmsCommandConnectCond();
        whWmsCommandConnectCond.setConnectId(whWmsCommandCheckPara.getConnectId());
        whWmsCommandConnectCond.setCancelFlag(0);
        List<WhWmsCommandConnectVO> commandConnectVOList = this.whWmsCommandConnectService.findByCond(whWmsCommandConnectCond);
        if (CollectionUtils.isEmpty(commandConnectVOList)) {
            throw new WarehouseException("WH0001", "\u8be5\u51fa\u5e93\u6307\u4ee4\u6ca1\u6709\u5173\u8054\u6ce2\u6b21");
        }
        WhWmsConnectInfoVO connectInfoVO = this.whWmsConnectInfoService.findById(whWmsCommandCheckPara.getConnectId());
        if (connectInfoVO == null || !connectInfoVO.getConnectStatus().equals(WMSConstants.ConnectStatus.FINISHED)) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u5fc5\u987b\u662f\u5df2\u5b8c\u6210\u72b6\u6001");
        }
        for (WhWmsCommandConnectVO vo : commandConnectVOList) {
            vo.setCancelFlag(1);
        }
        whWmsCommandCheckPara.setOutStockCommandConncectVOList(commandConnectVOList);
        whWmsCommandCheckPara.setOutStockConnectInfo(connectInfoVO);
        for (WhCommand whCommand : whCommandList) {
            if (whCommand.getCancelFlag() == 1) {
                whCommand.setCommandStatus(WhCommand.STATUS_SHORTAGES);
            } else {
                whCommand.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
            }
            whCommand.setFailureStartConnect(whCommand.getFailureStartConnect() + 1);
        }
        whWmsCommandCheckPara.setOutStockCommandList(whCommandList);
        WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
        whWmsHouseShelvesCond.setPhysicalWarehouseCode(connectInfoVO.getPhysicalWarehouseCode());
        whWmsHouseShelvesCond.setHouseType("HOUSE_TYPE_PACKING");
        List<WhWmsHouseShelvesVO> hsPacking = this.whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if (CollectionUtils.isEmpty(hsPacking) || hsPacking.size() > 1) {
            throw new WarehouseException("WMS0001", "\u6ca1\u6709\u5408\u9002\u7684\u76ee\u6807\u5e93\u4f4d,\u6d3b\u52a8\u533a");
        }
        WhWmsHouseShelvesVO sourceShelvesVO = hsPacking.get(0);
        whWmsHouseShelvesCond.setPhysicalWarehouseCode(connectInfoVO.getPhysicalWarehouseCode());
        whWmsHouseShelvesCond.setHouseType("HOUSE_TYPE_DIFF");
        List<WhWmsHouseShelvesVO> diffShelves = this.whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if (CollectionUtils.isEmpty(diffShelves) || diffShelves.size() > 1) {
            throw new WarehouseException("WMS0001", "\u6ca1\u6709\u5408\u9002\u7684\u76ee\u6807\u5e93\u4f4d,\u5dee\u5f02\u533a");
        }
        WhWmsHouseShelvesVO tarShelves = diffShelves.get(0);
        WhWmsConnectPickSkuCond pickSkuCond = new WhWmsConnectPickSkuCond();
        pickSkuCond.setConnectId(connectInfoVO.getId());
        List<WhWmsConnectPickSkuVO> connectPickSkuVOs = this.whWmsConnectPickSkuService.findConnectPickSkuByCond(pickSkuCond);
        Map<String, Map<String, Integer>> diffSkuMap = this.computePickSkuDiffStock(connectPickSkuVOs, vos);
        if (diffSkuMap != null && diffSkuMap.size() > 0) {
            WhWmsMoveStockVO whWmsMoveStockVO = this.moveDiffStockThenFinish(connectInfoVO, whCommandList.get(0), operatorId, sourceShelvesVO, tarShelves, diffSkuMap);
            this.whWmsMoveStockService.rebuildMoveStock(whWmsMoveStockVO);
            this.whWmsMoveStockService.moveStockCheck(whWmsMoveStockVO);
            ArrayList<WhWmsMoveStockVO> moveStockVOList = new ArrayList<WhWmsMoveStockVO>();
            moveStockVOList.add(whWmsMoveStockVO);
            whWmsCommandCheckPara.setStockoutMoveStockList(moveStockVOList);
        }
        return true;
    }

    public String cancelMakeCommandOnCheckOut(WhWmsMoveStockVO move, WhCommand command) {
        String commandCode = command.getCode();
        WhWmsCommandConnectVO commandConnectVO = this.whWmsCommandConnectService.findNotCanceledByWhCommandCode(commandCode);
        WhWmsConnectInfoVO connect = this.whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
        if (NullUtil.isNull((Object)connect)) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u4e0d\u5b58\u5728");
        }
        this.whWmsConnectDistributionService.deleteConnectDistribution(connect.getId(), commandCode);
        this.whCommandService.commandStatusToShortages(commandCode);
        if (!EmptyUtil.isNotEmpty((Object)command.isNoCreateMoveStock()) || !command.isNoCreateMoveStock()) {
            this.whWmsMoveStockService.newMoveStock(move);
            return move.getCode();
        }
        return null;
    }

    public boolean cancelMakeCommandOnCheckOut(WhWmsCommandCheckPara whWmsCommandCheckPara) {
        WhWmsMoveStockVO move = whWmsCommandCheckPara.getCancelMoveStockVO();
        List<WhCommand> commands = whWmsCommandCheckPara.getCancelCommands();
        if (CollectionUtils.isEmpty(commands)) {
            return false;
        }
        ArrayList<String> cancelCommands = new ArrayList<String>();
        for (WhCommand whCommand : commands) {
            cancelCommands.add(whCommand.getCode());
        }
        String commandCode = (String)cancelCommands.get(0);
        WhWmsCommandConnectCond commandConnectCond = new WhWmsCommandConnectCond();
        commandConnectCond.setCommandCodes(cancelCommands);
        commandConnectCond.setCancelFlag(0);
        List<WhWmsCommandConnectVO> commandConnectVOs = this.whWmsCommandConnectService.findByCond(commandConnectCond);
        if (CollectionUtils.isEmpty(commandConnectVOs)) {
            throw new WarehouseException("WH0001", "\u8be5\u51fa\u5e93\u6307\u4ee4\u6ca1\u6709\u5173\u8054\u6ce2\u6b21");
        }
        WhWmsConnectInfoVO connect = this.whWmsConnectInfoService.findById(commandConnectVOs.get(0).getConnectId());
        if (NullUtil.isNull((Object)connect)) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u4e0d\u5b58\u5728");
        }
        whWmsCommandCheckPara.setConnectId(connect.getId());
        whWmsCommandCheckPara.setCancelCommandCodes(cancelCommands);
        whWmsCommandCheckPara.setCancelCommandCode(commandCode);
        if (!EmptyUtil.isNotEmpty((Object)whWmsCommandCheckPara.isNoCreateMoveStock()) || !whWmsCommandCheckPara.isNoCreateMoveStock()) {
            if (EmptyUtil.isNotEmpty((Object)move) && this.whWmsMoveStockService.buildMoveStock(move)) {
                whWmsCommandCheckPara.setCancelMoveStockVO(move);
            } else {
                whWmsCommandCheckPara.setCancelMoveStockVO(null);
            }
        }
        return true;
    }

    @Override
    public List<WhWmsCommandCheckVO> create(List<WhWmsCommandCheckVO> vos, WhWmsConnectPickSkuSubmitDataVO whWmsConnectPickSkuSubmitDataVO, Long operatorId) {
        WhWmsConnectInfoVO whWmsConnectInfoVO = whWmsConnectPickSkuSubmitDataVO.getConnectVO();
        ArrayList<String> newCommandCodes = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(whWmsConnectPickSkuSubmitDataVO.getCommandList())) {
            List<WhCommand> whCommands = whWmsConnectPickSkuSubmitDataVO.getCommandList();
            ArrayList<WhCommand> commandAssociateExpresss = new ArrayList<WhCommand>();
            for (WhCommand whCommand : whCommands) {
                if (whCommand != null && WhCommand.STATUS_PACKING.equals(whCommand.getCommandStatus())) {
                    newCommandCodes.add(whCommand.getCode());
                }
                if (!WMSConstants.ExpressType.SELF.equals(whCommand.getExpressType()) && !WMSConstants.ExpressType.SHOP.equals(whCommand.getExpressType())) continue;
                commandAssociateExpresss.add(whCommand);
            }
            if (CollectionUtils.isNotEmpty(newCommandCodes)) {
                this.whCommandService.batchCommandInPackingToHandover(newCommandCodes);
            }
            if ("single_product_single_piece".equals(whWmsConnectInfoVO.getConnectType()) || "multi_piece_activity".equals(whWmsConnectInfoVO.getConnectType()) || "bulk_order".equals(whWmsConnectInfoVO.getConnectType()) || "large_sized_package".equals(whWmsConnectInfoVO.getConnectType())) {
                this.whWmsConnectPickSkuService.deleteConnectBox(whWmsConnectInfoVO.getId());
            } else if ("multi_product_single_piece".equals(whWmsConnectInfoVO.getConnectType())) {
                List<WhCommand> restCommandList = this.whCommandService.findCommandByConnectIdAndBarCode(null, whWmsConnectInfoVO.getId());
                if (EmptyUtil.isEmpty((List)restCommandList)) {
                    this.whWmsConnectPickSkuService.deleteConnectBox(whWmsConnectInfoVO.getId());
                }
            } else {
                this.whWmsConnectDistributionService.deleteConnectDistribution(whWmsConnectInfoVO.getId(), whCommands.get(0).getCode());
            }
            for (WhWmsCommandCheckVO vo : vos) {
                if (vo.getIsMaterial().equals(1)) {
                    vo.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
                } else {
                    vo.setSkuStatus(whWmsConnectInfoVO.getSkuStatus());
                }
                this.create(vo);
            }
            this.buildOperationRcdThenBatchInsert(vos, whWmsConnectInfoVO, operatorId);
            this.batchInserCheckGiftCard(whWmsConnectPickSkuSubmitDataVO.getCheckGiftCardList());
            WhWmsMoveStockVO moveStockVO = whWmsConnectPickSkuSubmitDataVO.getMoveStockVO();
            if (moveStockVO != null) {
                this.whWmsMoveStockService.executeMoveStock(moveStockVO);
            }
            if (CollectionUtils.isNotEmpty(commandAssociateExpresss)) {
                this.whCommandAssociateExpressService.batchCommandAssociateExpress(commandAssociateExpresss);
            }
        }
        return vos;
    }

    @Override
    @Transactional
    public boolean createCustomization(WhWmsCommandCheckInfo checkInfo) {
        HashSet<String> commandCodes = new HashSet<String>();
        for (WhWmsCommandCheckVO vo : checkInfo.getCommandCheckDetailList()) {
            commandCodes.add(vo.getCommandCode());
        }
        if (CollectionUtils.isEmpty(commandCodes) || commandCodes.size() > 1) {
            throw new WarehouseException("WH0002");
        }
        WhCommand whCommand = this.whCommandService.findCommandByCode(checkInfo.getCommandCode(), true);
        if (!WhCommand.STATUS_IN_PROCESSING.equals(whCommand.getCommandStatus())) {
            throw new WarehouseException("WH0001", "\u51fa\u5e93\u6307\u4ee4\u5fc5\u987b\u662f\u521d\u59cb\u72b6\u6001\uff01");
        }
        if (NullUtil.isNotNull((Object)whCommand.getCancelFlag()) && whCommand.getCancelFlag().equals(1)) {
            throw new WarehouseException("WH0001", "\u8be5\u51fa\u5e93\u6307\u4ee4\u65e0\u6cd5\u51fa\u5e93\u5df2\u88ab\u53d6\u6d88");
        }
        WhPhysicalWarehouse whPhysicalWarehouse = this.whInfoService.findPhysicalWarehouseByCode(whCommand.getPhysicalWarehouseCode());
        WhWmsHouseShelvesVO handOverShelvesVO = this.getOnlyOneHouseShelves(whPhysicalWarehouse.getCode(), "HOUSE_TYPE_HANDOVER");
        List<WhWmsHouseShelvesVO> customizationAreaShelves = this.getHouseShelves(whPhysicalWarehouse.getCode(), "HOUSE_TYPE_CUSTOMIZATION");
        WhWmsHouseShelvesVO customizationShelvesVO = customizationAreaShelves.get(0);
        this.checkWmsSkuStock(checkInfo.getCommandCheckDetailList(), customizationShelvesVO);
        this.whCommandService.commandInProcessingToHandover(whCommand.getCode());
        this.doMoveStockThenFinish(checkInfo.getCommandCheckDetailList(), customizationShelvesVO, handOverShelvesVO, checkInfo.getOperatorId());
        for (WhWmsCommandCheckVO vo : checkInfo.getCommandCheckDetailList()) {
            vo.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
            this.create(vo);
        }
        this.batchInserCheckGiftCard(checkInfo.getCheckGiftCardList());
        WhWmsConnectInfoVO whWmsConnectInfoVO = this.whCommandService.findWhWmsConnectInfoVOByCommandCode(whCommand.getCode());
        this.buildOperationRcdThenInsert(checkInfo.getCommandCheckDetailList().get(0), whWmsConnectInfoVO, checkInfo.getOperatorId());
        return true;
    }

    private void checkWmsSkuStock(List<WhWmsCommandCheckVO> vos, WhWmsHouseShelvesVO customizationShelvesVO) {
        HashMap<String, Integer> customizationSkuMap = new HashMap<String, Integer>();
        HashMap<String, Integer> normalSkuMap = new HashMap<String, Integer>();
        String key = null;
        for (WhWmsCommandCheckVO commandCheckVO : vos) {
            Integer amount;
            key = commandCheckVO.getSkuCode() + "|" + commandCheckVO.getBarCode();
            if (commandCheckVO.isCustomization()) {
                amount = (Integer)customizationSkuMap.get(key);
                if (NullUtil.isNull((Object)amount)) {
                    customizationSkuMap.put(key, commandCheckVO.getAmount());
                    continue;
                }
                customizationSkuMap.put(key, commandCheckVO.getAmount() + amount);
                continue;
            }
            amount = (Integer)normalSkuMap.get(key);
            if (NullUtil.isNull((Object)amount)) {
                normalSkuMap.put(key, commandCheckVO.getAmount());
                continue;
            }
            normalSkuMap.put(key, commandCheckVO.getAmount() + amount);
        }
        WhWmsSkuStockVO stockCond = new WhWmsSkuStockVO();
        stockCond.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        stockCond.setShelvesCode(customizationShelvesVO.getCode());
        List<WhWmsSkuStockVO> custShelveStockList = this.whWmsSkuStockService.getWmsSkuStocksByShelvesCond(stockCond);
        if (EmptyUtil.isEmpty(custShelveStockList)) {
            throw new WarehouseException("WH0001", "\u5b9a\u5236\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff01");
        }
        HashMap<String, Integer> custStockMap = new HashMap<String, Integer>();
        for (WhWmsSkuStockVO whWmsSkuStockVO : custShelveStockList) {
            if (whWmsSkuStockVO.getAvailableAmount() <= 0) continue;
            key = whWmsSkuStockVO.getSkuCode() + "|" + whWmsSkuStockVO.getBarCode();
            Integer amount = (Integer)custStockMap.get(key);
            if (NullUtil.isNull((Object)amount)) {
                custStockMap.put(key, whWmsSkuStockVO.getAvailableAmount());
                continue;
            }
            custStockMap.put(key, amount + whWmsSkuStockVO.getAvailableAmount());
        }
        for (Map.Entry entry : customizationSkuMap.entrySet()) {
            key = (String)entry.getKey();
            Integer needAmount = (Integer)entry.getValue();
            Integer totalAmount = (Integer)custStockMap.get(key);
            if (NullUtil.isNull((Object)totalAmount)) {
                totalAmount = 0;
            }
            if (needAmount <= totalAmount) continue;
            throw new WarehouseException("WH0001", String.format("[%s]\u5b9a\u5236\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3[%s<%s]\uff01", key, totalAmount, needAmount));
        }
        for (Map.Entry entry : normalSkuMap.entrySet()) {
            String skuCode = (String)entry.getKey();
            Integer needAmount = (Integer)entry.getValue();
            Integer totalAmount = (Integer)custStockMap.get(skuCode);
            if (NullUtil.isNull((Object)totalAmount)) {
                totalAmount = 0;
            }
            if (needAmount <= totalAmount) continue;
            throw new WarehouseException("WH0001", String.format("[%s]\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3[%s<%s]\uff01", skuCode, totalAmount, needAmount));
        }
    }

    private WhWmsHouseShelvesVO getOnlyOneHouseShelves(String physicalWarehouseCode, String sourceArea) {
        List<WhWmsHouseShelvesVO> list = this.getHouseShelves(physicalWarehouseCode, sourceArea);
        if (list.size() > 1) {
            throw new WarehouseException("WMS0001", "\u6ca1\u6709\u5408\u9002\u7684\u76ee\u6807\u5e93\u4f4d," + WhWmsWarehouseAreaVO.getHouseAreaName(sourceArea));
        }
        return list.get(0);
    }

    private List<WhWmsHouseShelvesVO> getHouseShelves(String physicalWarehouseCode, String sourceArea) {
        WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
        whWmsHouseShelvesCond.setPhysicalWarehouseCode(physicalWarehouseCode);
        whWmsHouseShelvesCond.setHouseType(sourceArea);
        List<WhWmsHouseShelvesVO> list = this.whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if (CollectionUtils.isEmpty(list)) {
            throw new WarehouseException("WMS0001", "\u6ca1\u6709\u5408\u9002\u7684\u76ee\u6807\u5e93\u4f4d," + WhWmsWarehouseAreaVO.getHouseAreaName(sourceArea));
        }
        return list;
    }

    private void doMoveStockThenFinish(List<WhWmsCommandCheckVO> vos, WhWmsHouseShelvesVO sourceShelvesVO, WhWmsHouseShelvesVO targetShelvesVO, Long operatorId) {
        ArrayList<WhWmsMoveSkuVO> moveStockSkuList = new ArrayList<WhWmsMoveSkuVO>();
        for (WhWmsCommandCheckVO vo : vos) {
            WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
            moveSkuVO.setPhysicalWarehouseCode(sourceShelvesVO.getPhysicalWarehouseCode());
            moveSkuVO.setSkuCode(vo.getSkuCode());
            moveSkuVO.setSkuStatus(vo.getSkuStatus());
            moveSkuVO.setBarCode(vo.getBarCode());
            moveSkuVO.setOriginalHouseType(sourceShelvesVO.getHouseType());
            moveSkuVO.setOriginalShelvesCode(sourceShelvesVO.getCode());
            moveSkuVO.setTargetHouseType(targetShelvesVO.getHouseType());
            moveSkuVO.setTargetShelvesCode(targetShelvesVO.getCode());
            moveSkuVO.setAmount(vo.getCheckAmount());
            moveStockSkuList.add(moveSkuVO);
        }
        if (EmptyUtil.isEmpty(moveStockSkuList)) {
            return;
        }
        WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
        moveStockVO.setPhysicalWarehouseCode(sourceShelvesVO.getPhysicalWarehouseCode());
        moveStockVO.setCreateUserId(operatorId);
        moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_COMMON);
        moveStockVO.setMoveSkuList(moveStockSkuList);
        this.whWmsMoveStockService.newMoveStock(moveStockVO);
        this.whWmsMoveStockService.doMoveStockAndReleaseOccupyAndFinish(moveStockVO.getCode(), operatorId);
    }

    private void buildOperationRcdThenInsert(WhWmsCommandCheckVO vo, WhWmsConnectInfoVO whWmsConnectInfoVO, Long operatorId) {
        try {
            WhWmsOperationRcdVO rcd = new WhWmsOperationRcdVO();
            rcd.setReferenceCode(vo.getId().toString());
            rcd.setOperateType(WhWmsOperationRcdVO.OPERATOR_TYPE_CHECKOUT);
            rcd.setCommandCode(vo.getCommandCode());
            rcd.setOperatorId(operatorId);
            rcd.setOperateTime(DateUtil.getNow());
            rcd.setOperationDesc(whWmsConnectInfoVO.getId() + "");
            this.whWmsOperationRcdService.insert(rcd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buildOperationRcdThenBatchInsert(List<WhWmsCommandCheckVO> vos, WhWmsConnectInfoVO whWmsConnectInfoVO, Long operatorId) {
        ArrayList<WhWmsOperationRcdVO> rcds = new ArrayList<WhWmsOperationRcdVO>();
        for (WhWmsCommandCheckVO vo : vos) {
            WhWmsOperationRcdVO rcd = new WhWmsOperationRcdVO();
            rcd.setOperatorId(operatorId);
            rcd.setOperateType(WhWmsOperationRcdVO.OPERATOR_TYPE_CHECKOUT);
            rcd.setReferenceCode(vo.getId().toString());
            rcd.setOperateTime(DateUtil.getNow());
            rcd.setCommandCode(vo.getCommandCode());
            rcd.setOperationDesc(whWmsConnectInfoVO.getId() + "");
            rcds.add(rcd);
        }
        this.whWmsOperationRcdService.batchInsert(rcds);
    }

    private void checkSkuAmount(WhCommand whCommand, List<WhWmsCommandCheckVO> vos) {
        List<WhCommandSku> cmdSkus = whCommand.getWhCommandSkuList();
        if (EmptyUtil.isNotEmpty(cmdSkus)) {
            for (WhCommandSku cmdSku : cmdSkus) {
                cmdSku.setQuantity(0);
                cmdSku.setDamagedQuantity(0);
            }
        }
    }

    @Override
    public Boolean create(Long connectId, List<WhWmsCommandCheckBatch> batchList, List<PackageInfo> fedList, List<PackageInfo> sfList) {
        this.whWmsConnectPickSkuService.deleteConnectBox(connectId);
        if (CollectionUtils.isNotEmpty(fedList) && this.isEbillMode(WMSConstants.ExpressType.FEDEX).booleanValue()) {
            ExpressUtil.orderFedExpressInfo(fedList, (Boolean)false);
        }
        if (CollectionUtils.isNotEmpty(sfList) && this.isEbillMode(WMSConstants.ExpressType.SF_LAND).booleanValue()) {
            ExpressUtil.genSFDeliveryCode(sfList);
        }
        this.batchCreate(connectId, batchList);
        return true;
    }

    private void batchCreate(Long connectId, List<WhWmsCommandCheckBatch> batchList) {
        for (WhWmsCommandCheckBatch batch : batchList) {
            WhCommand whCommand = this.whCommandService.findCommandByCode(batch.getWhWmsCommandCheckVOList().get(0).getCommandCode(), false);
            if (!whCommand.getCommandStatus().equals(WhCommand.STATUS_DISTRIBUTION)) {
                throw new WarehouseException("WH0001", "\u51fa\u5e93\u6307\u4ee4\u5fc5\u987b\u662f\u5f85\u5206\u62e8\u72b6\u6001");
            }
            WhWmsCommandConnectVO commandConnectVO = this.whWmsCommandConnectService.findNotCanceledByWhCommandCode(whCommand.getCode());
            if (commandConnectVO == null) {
                throw new WarehouseException("WH0001", "\u8be5\u51fa\u5e93\u6307\u4ee4\u6ca1\u6709\u5173\u8054\u6ce2\u6b21");
            }
            WhWmsConnectInfoVO connectVO = this.whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
            if (!connectVO.getConnectStatus().equals(WMSConstants.ConnectStatus.DISTRIBUTION)) {
                throw new WarehouseException("WH0001", "\u6ce2\u6b21\u5fc5\u987b\u662f\u5206\u62e8\u72b6\u6001");
            }
            if (whCommand.getCancelFlag().equals(1)) {
                throw new WarehouseException("WH0001", "\u8be5\u51fa\u5e93\u6307\u4ee4\u65e0\u6cd5\u51fa\u5e93\u5df2\u88ab\u53d6\u6d88");
            }
            this.whCommandService.commandInDistributionToPacking(commandConnectVO.getCommandCode());
            this.whCommandService.commandInPackingToHandover(commandConnectVO.getCommandCode());
            WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
            whWmsHouseShelvesCond.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
            whWmsHouseShelvesCond.setHouseType("HOUSE_TYPE_HANDOVER");
            List<WhWmsHouseShelvesVO> hs = this.whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
            if (CollectionUtils.isEmpty(hs) || hs.size() > 1) {
                throw new WarehouseException("WMS0001", "\u6ca1\u6709\u5408\u9002\u7684\u76ee\u6807\u5e93\u4f4d,\u4ea4\u63a5\u533a");
            }
            WhWmsHouseShelvesVO targetShelvesVO = hs.get(0);
            whWmsHouseShelvesCond.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
            whWmsHouseShelvesCond.setHouseType("HOUSE_TYPE_PACKING");
            List<WhWmsHouseShelvesVO> hsPacking = this.whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
            if (CollectionUtils.isEmpty(hsPacking) || hsPacking.size() > 1) {
                throw new WarehouseException("WMS0001", "\u6ca1\u6709\u5408\u9002\u7684\u76ee\u6807\u5e93\u4f4d,\u5206\u62e8\u5305\u88c5\u533a");
            }
            WhWmsHouseShelvesVO sourceShelvesVO = hsPacking.get(0);
            WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
            moveStockVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
            moveStockVO.setCreateUserId(batch.getOperatorId());
            moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_COMMON);
            ArrayList<WhWmsMoveSkuVO> moveStockSkuList = new ArrayList<WhWmsMoveSkuVO>();
            moveStockVO.setMoveSkuList(moveStockSkuList);
            for (WhWmsCommandCheckVO vo : batch.getWhWmsCommandCheckVOList()) {
                if (vo.getIsMaterial().equals(1)) {
                    vo.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
                } else {
                    vo.setSkuStatus(connectVO.getSkuStatus());
                }
                vo.setCancelFlag(0);
                this.create(vo);
            }
            for (WhWmsCommandCheckVO vo : batch.getWhWmsCommandCheckVOList()) {
                WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                moveSkuVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
                moveSkuVO.setSkuCode(vo.getSkuCode());
                moveSkuVO.setSkuStatus(vo.getSkuStatus());
                moveSkuVO.setBarCode(vo.getBarCode());
                moveSkuVO.setOriginalHouseType(sourceShelvesVO.getHouseType());
                moveSkuVO.setOriginalShelvesCode(sourceShelvesVO.getCode());
                moveSkuVO.setTargetHouseType(targetShelvesVO.getHouseType());
                moveSkuVO.setTargetShelvesCode(targetShelvesVO.getCode());
                moveSkuVO.setAmount(vo.getCheckAmount());
                moveStockSkuList.add(moveSkuVO);
            }
            this.whWmsMoveStockService.newMoveStock(moveStockVO);
            this.whWmsMoveStockService.doMoveStockAndReleaseOccupyAndFinish(moveStockVO.getCode(), batch.getOperatorId());
            if (batch.getPi() == null) continue;
            if (whCommand.getExpressType().equals(WMSConstants.ExpressType.FEDEX)) {
                if (batch.getPi().getDeliveryCode() == null || batch.getPi().getExpressOrderNo() == null) continue;
                this.whCommandAssociateExpressService.commandAssociateExpress(whCommand.getCode(), batch.getPi().getDeliveryCode());
                continue;
            }
            if (!whCommand.getExpressType().equals(WMSConstants.ExpressType.SF_LAND) && !whCommand.getExpressType().equals(WMSConstants.ExpressType.SF_AIR) && !whCommand.getExpressType().equals(WMSConstants.ExpressType.SF_COLD_CHAIN) || batch.getPi().getDeliveryCode() == null || batch.getPi().getExpressOrderNo() == null || batch.getPi().getOriginCode() == null || batch.getPi().getDestCode() == null) continue;
            this.whCommandAssociateExpressService.commandAssociateExpress(whCommand.getCode(), batch.getPi().getDeliveryCode());
        }
        WhWmsConnectInfoVO connectVO = this.whWmsConnectInfoService.findById(connectId);
        connectVO.setConnectStatus(WMSConstants.ConnectStatus.FINISHED);
        this.whWmsConnectInfoService.update(connectVO);
    }

    @Override
    public Boolean cancel(String commandCode, Long operatorId) {
        if (EmptyUtil.isEmpty((String)commandCode)) {
            throw new WarehouseException("WH0002");
        }
        WhCommand whCommand = this.whCommandService.findCommandByCode(commandCode, true);
        if (!whCommand.getCommandStatus().equals(WhCommand.STATUS_PACKING)) {
            throw new WarehouseException("WH0001", "\u51fa\u5e93\u6307\u4ee4\u5fc5\u987b\u662f\u5f85\u5305\u88c5\u72b6\u6001");
        }
        WhWmsCommandConnectVO commandConnectVO = this.whWmsCommandConnectService.findNotCanceledByWhCommandCode(whCommand.getCode());
        if (commandConnectVO == null) {
            throw new WarehouseException("WH0001", "\u8be5\u51fa\u5e93\u6307\u4ee4\u6ca1\u6709\u5173\u8054\u6ce2\u6b21");
        }
        WhWmsConnectInfoVO connectVO = this.whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
        if (!connectVO.getConnectStatus().equals(WMSConstants.ConnectStatus.FINISHED)) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u5fc5\u987b\u662f\u5df2\u5b8c\u6210\u72b6\u6001");
        }
        commandConnectVO.setCancelFlag(1);
        this.whWmsCommandConnectService.update(commandConnectVO);
        if (whCommand.getCancelFlag() == 1) {
            whCommand.setCommandStatus(WhCommand.STATUS_SHORTAGES);
        } else {
            whCommand.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
            this.whWmsCommandPreOccupyIdxMapper.batchDelete(Collections.singletonList(whCommand.getCode()));
        }
        whCommand.setFailureStartConnect(whCommand.getFailureStartConnect() + 1);
        this.whCommandService.updateCommand(whCommand);
        WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
        whWmsHouseShelvesCond.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
        whWmsHouseShelvesCond.setHouseType("HOUSE_TYPE_PACKING");
        List<WhWmsHouseShelvesVO> hsPacking = this.whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if (CollectionUtils.isEmpty(hsPacking) || hsPacking.size() > 1) {
            throw new WarehouseException("WMS0001", "\u6ca1\u6709\u5408\u9002\u7684\u76ee\u6807\u5e93\u4f4d,\u5206\u62e8\u5305\u88c5\u533a[" + whWmsHouseShelvesCond.getHouseType() + "],\u7269\u7406\u4ed3[" + connectVO.getPhysicalWarehouseCode() + "]");
        }
        whWmsHouseShelvesCond.setHouseType("HOUSE_TYPE_DIFF");
        List<WhWmsHouseShelvesVO> diffShelves = this.whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if (CollectionUtils.isEmpty(diffShelves) || diffShelves.size() > 1) {
            throw new WarehouseException("WMS0001", "\u6ca1\u6709\u5408\u9002\u7684\u76ee\u6807\u5e93\u4f4d,\u5dee\u5f02\u533a[" + whWmsHouseShelvesCond.getHouseType() + "],\u7269\u7406\u4ed3[" + connectVO.getPhysicalWarehouseCode() + "]");
        }
        WhWmsHouseShelvesVO sourceShelvesVO = hsPacking.get(0);
        WhWmsHouseShelvesVO tarShelves = diffShelves.get(0);
        WhWmsSkuStockVO whWmsSkuStockVO = new WhWmsSkuStockVO();
        whWmsSkuStockVO.setHouseType("HOUSE_TYPE_ACTIVE");
        whWmsSkuStockVO.setSkuCode(whCommand.getWhCommandSkuList().get(0).getSkuCode());
        whWmsSkuStockVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
        whWmsSkuStockVO.setShelvesCode(sourceShelvesVO.getCode());
        List<WhWmsSkuStockVO> whWmsSkuStockVOList = this.whWmsSkuStockService.getWmsSkuStockByCond(whWmsSkuStockVO);
        if (whWmsSkuStockVOList != null && whWmsSkuStockVOList.size() > 0) {
            for (WhWmsSkuStockVO vo : whWmsSkuStockVOList) {
                if (vo.getAmount() <= 0) continue;
                WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
                moveStockVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
                moveStockVO.setCreateUserId(operatorId);
                moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_COMMON);
                moveStockVO.setReferenceCode(whCommand.getReferenceCode());
                WhWmsMoveSkuVO whWmsMoveSkuVO = new WhWmsMoveSkuVO();
                whWmsMoveSkuVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
                whWmsMoveSkuVO.setSkuCode(vo.getSkuCode());
                whWmsMoveSkuVO.setCreateTime(Calendar.getInstance().getTime());
                whWmsMoveSkuVO.setCreateUserId(operatorId.toString());
                whWmsMoveSkuVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_COMMON);
                whWmsMoveSkuVO.setAmount(1);
                whWmsMoveSkuVO.setBarCode(vo.getBarCode());
                whWmsMoveSkuVO.setOriginalHouseType("HOUSE_TYPE_ACTIVE");
                whWmsMoveSkuVO.setOriginalShelvesCode(sourceShelvesVO.getCode());
                whWmsMoveSkuVO.setTargetHouseType("HOUSE_TYPE_DIFF");
                whWmsMoveSkuVO.setTargetShelvesCode(tarShelves.getCode());
                whWmsMoveSkuVO.setSkuStatus(vo.getSkuStatus());
                ArrayList<WhWmsMoveSkuVO> moveSkuList = new ArrayList<WhWmsMoveSkuVO>();
                moveSkuList.add(whWmsMoveSkuVO);
                moveStockVO.setMoveSkuList(moveSkuList);
                this.whWmsMoveStockService.newMoveStock(moveStockVO);
                this.whWmsMoveStockService.doMoveStockAndReleaseOccupyAndFinish(moveStockVO.getCode(), operatorId);
                break;
            }
        }
        return true;
    }

    @Override
    public Boolean cancel(String commandCode, Long operatorId, List<WhWmsCommandCheckVO> vos) {
        if (EmptyUtil.isEmpty((String)commandCode)) {
            throw new WarehouseException("WH0002");
        }
        WhCommand whCommand = this.whCommandService.findCommandByCode(commandCode, false);
        if (!whCommand.getCommandStatus().equals(WhCommand.STATUS_PACKING)) {
            throw new WarehouseException("WH0001", "\u51fa\u5e93\u6307\u4ee4\u5fc5\u987b\u662f\u5f85\u5305\u88c5\u72b6\u6001");
        }
        WhWmsCommandConnectVO commandConnectVO = this.whWmsCommandConnectService.findNotCanceledByWhCommandCode(whCommand.getCode());
        if (commandConnectVO == null) {
            throw new WarehouseException("WH0001", "\u8be5\u51fa\u5e93\u6307\u4ee4\u6ca1\u6709\u5173\u8054\u6ce2\u6b21");
        }
        WhWmsConnectInfoVO connectVO = this.whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
        if (!connectVO.getConnectStatus().equals(WMSConstants.ConnectStatus.FINISHED)) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u5fc5\u987b\u662f\u5df2\u5b8c\u6210\u72b6\u6001");
        }
        commandConnectVO.setCancelFlag(1);
        this.whWmsCommandConnectService.update(commandConnectVO);
        WhWmsConnectDistributionVO cond = new WhWmsConnectDistributionVO();
        cond.setConnectId(commandConnectVO.getConnectId());
        cond.setCommandCode(commandCode);
        List<WhWmsConnectDistributionVO> connectDistributionVOList = this.whWmsConnectDistributionService.findByCond(cond);
        whCommand.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
        whCommand.setFailureStartConnect(whCommand.getFailureStartConnect() + 1);
        this.whCommandService.updateCommand(whCommand);
        this.whWmsCommandPreOccupyIdxMapper.batchDelete(Collections.singletonList(whCommand.getCode()));
        this.whWmsConnectDistributionService.deleteConnectDistribution(commandConnectVO.getConnectId(), commandConnectVO.getCommandCode());
        WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
        whWmsHouseShelvesCond.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
        whWmsHouseShelvesCond.setHouseType("HOUSE_TYPE_PACKING");
        List<WhWmsHouseShelvesVO> hsPacking = this.whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if (CollectionUtils.isEmpty(hsPacking) || hsPacking.size() > 1) {
            throw new WarehouseException("WMS0001", "\u6ca1\u6709\u5408\u9002\u7684\u76ee\u6807\u5e93\u4f4d,\u5206\u62e8\u5305\u88c5\u533a[" + whWmsHouseShelvesCond.getHouseType() + "],\u7269\u7406\u4ed3[" + connectVO.getPhysicalWarehouseCode() + "]");
        }
        WhWmsHouseShelvesVO sourceShelvesVO = hsPacking.get(0);
        whWmsHouseShelvesCond.setHouseType("HOUSE_TYPE_ACTIVE");
        List<WhWmsHouseShelvesVO> targetActiveHouseShelves = this.whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if (CollectionUtils.isEmpty(targetActiveHouseShelves) || targetActiveHouseShelves.size() > 1) {
            throw new WarehouseException("WMS0001", "\u6ca1\u6709\u5408\u9002\u7684\u76ee\u6807\u5e93\u4f4d,\u6d3b\u52a8\u533a[" + whWmsHouseShelvesCond.getHouseType() + "],\u7269\u7406\u4ed3[" + connectVO.getPhysicalWarehouseCode() + "]");
        }
        WhWmsHouseShelvesVO targetShelvesVO = targetActiveHouseShelves.get(0);
        List<WhWmsMoveSkuVO> moveStockSkuList = this.buildMoveStockSkuByCommandCheck(sourceShelvesVO, targetShelvesVO, vos, connectVO);
        if (CollectionUtils.isNotEmpty(moveStockSkuList)) {
            WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
            moveStockVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
            moveStockVO.setCreateUserId(operatorId);
            moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_COMMON);
            moveStockVO.setReferenceCode(whCommand.getReferenceCode());
            moveStockVO.setMoveSkuList(moveStockSkuList);
            this.whWmsMoveStockService.newMoveStock(moveStockVO);
        }
        whWmsHouseShelvesCond.setHouseType("HOUSE_TYPE_DIFF");
        List<WhWmsHouseShelvesVO> diffShelves = this.whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if (CollectionUtils.isEmpty(diffShelves) || diffShelves.size() > 1) {
            throw new WarehouseException("WMS0001", "\u6ca1\u6709\u5408\u9002\u7684\u76ee\u6807\u5e93\u4f4d,\u5dee\u5f02\u533a");
        }
        WhWmsHouseShelvesVO diffShelve = diffShelves.get(0);
        Map<String, Map<String, Integer>> diffSkuMap = this.computeDiffStock(connectDistributionVOList, vos);
        WhWmsMoveStockVO whWmsMoveStockVO = this.moveDiffStockThenFinish(connectVO, whCommand, operatorId, sourceShelvesVO, diffShelve, diffSkuMap);
        this.whWmsMoveStockService.createMoveStockThenFinish(whWmsMoveStockVO);
        return true;
    }

    private WhWmsMoveStockVO moveDiffStockThenFinish(WhWmsConnectInfoVO connectVO, WhCommand whCommand, Long operatorId, WhWmsHouseShelvesVO sourceShelvesVO, WhWmsHouseShelvesVO diffShelve, Map<String, Map<String, Integer>> diffSkuMap) {
        if (EmptyUtil.isEmpty(diffSkuMap)) {
            return null;
        }
        ArrayList<WhWmsMoveSkuVO> moveStockSkuList = new ArrayList<WhWmsMoveSkuVO>();
        for (Map.Entry<String, Map<String, Integer>> entry : diffSkuMap.entrySet()) {
            String skuCode = entry.getKey();
            for (Map.Entry<String, Integer> barcodeEntry : entry.getValue().entrySet()) {
                String barCode = barcodeEntry.getKey();
                WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                moveSkuVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
                moveSkuVO.setSkuCode(skuCode);
                moveSkuVO.setSkuStatus(connectVO.getSkuStatus());
                moveSkuVO.setBarCode(barCode);
                moveSkuVO.setOriginalHouseType(sourceShelvesVO.getHouseType());
                moveSkuVO.setOriginalShelvesCode(sourceShelvesVO.getCode());
                moveSkuVO.setTargetHouseType(diffShelve.getHouseType());
                moveSkuVO.setTargetShelvesCode(diffShelve.getCode());
                moveSkuVO.setAmount(barcodeEntry.getValue());
                moveStockSkuList.add(moveSkuVO);
            }
        }
        if (EmptyUtil.isNotEmpty(moveStockSkuList)) {
            WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
            moveStockVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
            moveStockVO.setCreateUserId(operatorId);
            moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_COMMON);
            moveStockVO.setReferenceCode(whCommand.getReferenceCode());
            moveStockVO.setMoveSkuList(moveStockSkuList);
            return moveStockVO;
        }
        return null;
    }

    private Map<String, Map<String, Integer>> computePickSkuDiffStock(List<WhWmsConnectPickSkuVO> connectPickSkuVOs, List<WhWmsCommandCheckVO> commandCheckVOList) {
        String skuCode;
        Integer pickSkuAmount;
        HashMap<String, Map<String, Integer>> diffStockMap = new HashMap<String, Map<String, Integer>>();
        if (EmptyUtil.isEmpty(connectPickSkuVOs)) {
            return diffStockMap;
        }
        HashMap<String, Integer> pickSkuMap = new HashMap<String, Integer>();
        HashMap<String, TreeSet<String>> skuBarCodeMap = new HashMap<String, TreeSet<String>>();
        for (WhWmsConnectPickSkuVO whWmsConnectPickSkuVO : connectPickSkuVOs) {
            if (EmptyUtil.isEmpty((String)whWmsConnectPickSkuVO.getBarCode())) {
                whWmsConnectPickSkuVO.setBarCode(whWmsConnectPickSkuVO.getSkuCode() + "_0001");
            }
            String key = whWmsConnectPickSkuVO.getBarCode();
            TreeSet<String> barCodeSets = (TreeSet<String>)skuBarCodeMap.get(whWmsConnectPickSkuVO.getSkuCode());
            if (NullUtil.isNull((Object)barCodeSets)) {
                barCodeSets = new TreeSet<String>();
                skuBarCodeMap.put(whWmsConnectPickSkuVO.getSkuCode(), barCodeSets);
            }
            barCodeSets.add(whWmsConnectPickSkuVO.getBarCode());
            pickSkuAmount = (Integer)pickSkuMap.get(key);
            if (NullUtil.isNull((Object)pickSkuAmount)) {
                pickSkuAmount = 0;
            }
            pickSkuMap.put(key, pickSkuAmount + whWmsConnectPickSkuVO.getNeedAmount());
        }
        if (EmptyUtil.isNotEmpty(commandCheckVOList)) {
            for (WhWmsCommandCheckVO whWmsCommandCheckVO : commandCheckVOList) {
                skuCode = whWmsCommandCheckVO.getSkuCode();
                Set barCodes = (Set)skuBarCodeMap.get(skuCode);
                if (EmptyUtil.isEmpty((Object)barCodes)) {
                    throw new WarehouseException("WMS0001", String.format("[%s]\u65e0\u62e3\u8d27\u6570\u636e", skuCode));
                }
                pickSkuAmount = (Integer)pickSkuMap.get(whWmsCommandCheckVO.getBarCode());
                Integer checkAmount = whWmsCommandCheckVO.getCheckAmount();
                if (NullUtil.isNull((Object)pickSkuAmount)) {
                    pickSkuAmount = 0;
                }
                if (pickSkuAmount >= checkAmount) {
                    pickSkuMap.put(whWmsCommandCheckVO.getBarCode(), pickSkuAmount - checkAmount);
                    checkAmount = 0;
                } else if (pickSkuAmount > 0) {
                    pickSkuMap.put(whWmsCommandCheckVO.getBarCode(), 0);
                    checkAmount = checkAmount - pickSkuAmount;
                }
                if (checkAmount <= 0) continue;
                for (String barCode : barCodes) {
                    pickSkuAmount = (Integer)pickSkuMap.get(barCode);
                    if (pickSkuAmount >= checkAmount) {
                        pickSkuMap.put(barCode, pickSkuAmount - checkAmount);
                        checkAmount = 0;
                        break;
                    }
                    checkAmount = checkAmount - pickSkuAmount;
                    pickSkuMap.put(barCode, 0);
                }
                if (checkAmount <= 0) continue;
                throw new WarehouseException("WMS0001", String.format("[%s]\u9a8c\u8d27\u6570\u91cf\u6709\u8bef", skuCode));
            }
        }
        for (Map.Entry entry : skuBarCodeMap.entrySet()) {
            skuCode = (String)entry.getKey();
            for (String barCode : (Set)entry.getValue()) {
                Integer diffAmount = (Integer)pickSkuMap.get(barCode);
                if (NumberUtil.isNullOrZero((Number)diffAmount)) continue;
                HashMap<String, Integer> barCodeMap = (HashMap<String, Integer>)diffStockMap.get(skuCode);
                if (NullUtil.isNull((Object)barCodeMap)) {
                    barCodeMap = new HashMap<String, Integer>();
                    diffStockMap.put(skuCode, barCodeMap);
                }
                barCodeMap.put(barCode, diffAmount);
            }
        }
        return diffStockMap;
    }

    private Map<String, Map<String, Integer>> computeDiffStock(List<WhWmsConnectDistributionVO> commandDistributionVOList, List<WhWmsCommandCheckVO> commandCheckVOList) {
        String skuCode;
        Integer distributeAmount;
        HashMap<String, Map<String, Integer>> diffStockMap = new HashMap<String, Map<String, Integer>>();
        if (EmptyUtil.isEmpty(commandDistributionVOList)) {
            return diffStockMap;
        }
        HashMap<String, Integer> distributeSkuMap = new HashMap<String, Integer>();
        HashMap<String, TreeSet<String>> skuBarCodeMap = new HashMap<String, TreeSet<String>>();
        for (WhWmsConnectDistributionVO whWmsConnectDistributionVO : commandDistributionVOList) {
            if (EmptyUtil.isEmpty((String)whWmsConnectDistributionVO.getBarCode())) {
                whWmsConnectDistributionVO.setBarCode(whWmsConnectDistributionVO.getSkuCode() + "_0001");
            }
            String key = whWmsConnectDistributionVO.getBarCode();
            TreeSet<String> barCodeSets = (TreeSet<String>)skuBarCodeMap.get(whWmsConnectDistributionVO.getSkuCode());
            if (NullUtil.isNull((Object)barCodeSets)) {
                barCodeSets = new TreeSet<String>();
                skuBarCodeMap.put(whWmsConnectDistributionVO.getSkuCode(), barCodeSets);
            }
            barCodeSets.add(whWmsConnectDistributionVO.getBarCode());
            distributeAmount = (Integer)distributeSkuMap.get(key);
            if (NullUtil.isNull((Object)distributeAmount)) {
                distributeAmount = 0;
            }
            distributeSkuMap.put(key, distributeAmount + whWmsConnectDistributionVO.getDistributAmount());
        }
        if (EmptyUtil.isNotEmpty(commandCheckVOList)) {
            for (WhWmsCommandCheckVO whWmsCommandCheckVO : commandCheckVOList) {
                skuCode = whWmsCommandCheckVO.getSkuCode();
                Set barCodes = (Set)skuBarCodeMap.get(skuCode);
                if (EmptyUtil.isEmpty((Object)barCodes)) {
                    throw new WarehouseException("WMS0001", String.format("[%s]\u65e0\u5206\u62e8\u6570\u636e", skuCode));
                }
                distributeAmount = (Integer)distributeSkuMap.get(whWmsCommandCheckVO.getBarCode());
                Integer checkAmount = whWmsCommandCheckVO.getCheckAmount();
                if (NullUtil.isNull((Object)distributeAmount)) {
                    distributeAmount = 0;
                }
                if (distributeAmount >= checkAmount) {
                    distributeSkuMap.put(whWmsCommandCheckVO.getBarCode(), distributeAmount - checkAmount);
                    checkAmount = 0;
                } else if (distributeAmount > 0) {
                    distributeSkuMap.put(whWmsCommandCheckVO.getBarCode(), 0);
                    checkAmount = checkAmount - distributeAmount;
                }
                if (checkAmount <= 0) continue;
                for (String barCode : barCodes) {
                    distributeAmount = (Integer)distributeSkuMap.get(barCode);
                    if (distributeAmount >= checkAmount) {
                        distributeSkuMap.put(barCode, distributeAmount - checkAmount);
                        checkAmount = 0;
                        break;
                    }
                    checkAmount = checkAmount - distributeAmount;
                    distributeSkuMap.put(barCode, 0);
                }
                if (checkAmount <= 0) continue;
                throw new WarehouseException("WMS0001", String.format("[%s]\u9a8c\u8d27\u6570\u91cf\u6709\u8bef", skuCode));
            }
        }
        for (Map.Entry entry : skuBarCodeMap.entrySet()) {
            skuCode = (String)entry.getKey();
            for (String barCode : (Set)entry.getValue()) {
                Integer diffAmount = (Integer)distributeSkuMap.get(barCode);
                if (NumberUtil.isNullOrZero((Number)diffAmount)) continue;
                HashMap<String, Integer> barCodeMap = (HashMap<String, Integer>)diffStockMap.get(skuCode);
                if (NullUtil.isNull((Object)barCodeMap)) {
                    barCodeMap = new HashMap<String, Integer>();
                    diffStockMap.put(skuCode, barCodeMap);
                }
                barCodeMap.put(barCode, diffAmount);
            }
        }
        return diffStockMap;
    }

    private List<WhWmsStartPutawayVO> buildPutawayVOs(List<WhWmsCommandCheckVO> vos, WhWmsConnectInfoVO connectVO, WhWmsHouseShelvesVO sourceShelvesVO) {
        ArrayList<WhWmsStartPutawayVO> pvoList = new ArrayList<WhWmsStartPutawayVO>();
        if (EmptyUtil.isNotEmpty(vos)) {
            for (WhWmsCommandCheckVO checkVO : vos) {
                WhWmsStartPutawayVO pt = new WhWmsStartPutawayVO();
                pt.setSourceShelvesVO(sourceShelvesVO);
                pt.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
                pt.setPutawayAmount(checkVO.getCheckAmount());
                pt.setSkuCode(checkVO.getSkuCode());
                pt.setBarCode(checkVO.getBarCode());
                pt.setSkuStatus(connectVO.getSkuStatus());
                pt.setReceiveAmount(checkVO.getCheckAmount());
                pt.setStorageType(checkVO.getStorageType());
                pvoList.add(pt);
            }
        }
        return pvoList;
    }

    private List<WhWmsMoveSkuVO> buildMoveStockSkuByCommandCheck(WhWmsHouseShelvesVO oriShelves, WhWmsHouseShelvesVO tarShelves, List<WhWmsCommandCheckVO> vos, WhWmsConnectInfoVO connectVO) {
        ArrayList<WhWmsMoveSkuVO> moveSkuList = new ArrayList<WhWmsMoveSkuVO>();
        if (EmptyUtil.isNotEmpty(vos)) {
            for (WhWmsCommandCheckVO commandCheckVO : vos) {
                WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                moveSkuVO.setSkuCode(commandCheckVO.getSkuCode());
                moveSkuVO.setSkuStatus(connectVO.getSkuStatus());
                moveSkuVO.setBarCode(commandCheckVO.getBarCode());
                moveSkuVO.setPhysicalWarehouseCode(oriShelves.getPhysicalWarehouseCode());
                moveSkuVO.setOriginalShelvesCode(oriShelves.getCode());
                moveSkuVO.setOriginalHouseType(oriShelves.getHouseType());
                moveSkuVO.setTargetShelvesCode(tarShelves.getCode());
                moveSkuVO.setTargetHouseType(tarShelves.getHouseType());
                moveSkuVO.setAmount(commandCheckVO.getCheckAmount());
                moveSkuList.add(moveSkuVO);
            }
        }
        if (EmptyUtil.isNotEmpty(moveSkuList)) {
            return moveSkuList;
        }
        return null;
    }

    @Override
    public Boolean reject(String commandCode, Long operatorId) {
        if (this.cancel(commandCode, operatorId, null).booleanValue()) {
            return true;
        }
        return false;
    }

    private WhWmsCommandCheckVO create(WhWmsCommandCheckVO vo) {
        WhWmsCommandCheck whWmsCommandCheck = (WhWmsCommandCheck)BeanUtil.buildFrom((Object)vo, WhWmsCommandCheck.class);
        this.mapper.insert(whWmsCommandCheck);
        vo.setId(whWmsCommandCheck.getId());
        return vo;
    }

    private void batchCreateCommandCheck(List<WhWmsCommandCheckVO> vos) {
        boolean result;
        if (EmptyUtil.isEmpty(vos)) {
            throw new WarehouseException("WH0001", "\u9a8c\u8d27\u6570\u636e\u5f02\u5e38");
        }
        int size = vos.size();
        boolean bl = result = this.mapper.batchInsert(vos) == size;
        if (!result) {
            throw new WarehouseException("WH0001", "\u9a8c\u8d27\u6570\u636e\u63d2\u5165\u5f02\u5e38");
        }
    }

    @Override
    public Boolean update(WhWmsCommandCheckVO vo) {
        return this.mapper.updateByPrimaryKeySelective((WhWmsCommandCheck)BeanUtil.buildFrom((Object)vo, WhWmsCommandCheck.class)) != 0;
    }

    @Override
    public boolean deleteById(Long id) {
        return this.mapper.deleteByPrimaryKey(id) != 0;
    }

    @Override
    public WhWmsCommandCheckVO findById(Long id) {
        WhWmsCommandCheck whWmsConnectDistribution = this.mapper.selectByPrimaryKey(id);
        if (whWmsConnectDistribution != null) {
            return (WhWmsCommandCheckVO)BeanUtil.buildFrom((Object)whWmsConnectDistribution, WhWmsCommandCheckVO.class);
        }
        return null;
    }

    @Override
    public List<WhWmsCommandCheckVO> findByCond(WhWmsCommandCheckVO cond) {
        List<WhWmsCommandCheck> whWmsCommandChecks;
        WhWmsCommandCheckExample example = new WhWmsCommandCheckExample();
        WhWmsCommandCheckExample.Criteria criteria = example.createCriteria();
        if (cond.getCommandCode() != null) {
            criteria.andCommandCodeEqualTo(cond.getCommandCode());
        }
        if (cond.getSkuStatus() != null) {
            criteria.andSkuStatusEqualTo(cond.getSkuStatus());
        }
        if (cond.getSkuCode() != null) {
            criteria.andSkuCodeEqualTo(cond.getSkuCode());
        }
        if (cond.getBarCode() != null) {
            criteria.andBarCodeEqualTo(cond.getBarCode());
        }
        if (cond.getIsMaterial() != null) {
            criteria.andIsMaterialEqualTo(cond.getIsMaterial());
        }
        if (cond.getCancelFlag() != null) {
            criteria.andCancelFlagEqualTo(cond.getCancelFlag());
        }
        if (CollectionUtils.isEmpty(whWmsCommandChecks = this.mapper.selectByExample(example))) {
            return Collections.emptyList();
        }
        ArrayList<WhWmsCommandCheckVO> vos = new ArrayList<WhWmsCommandCheckVO>(whWmsCommandChecks.size());
        for (WhWmsCommandCheck whWmsCommandCheck : whWmsCommandChecks) {
            WhWmsCommandCheckVO whWmsCommandCheckVO = (WhWmsCommandCheckVO)BeanUtil.buildFrom((Object)whWmsCommandCheck, WhWmsCommandCheckVO.class);
            vos.add(whWmsCommandCheckVO);
        }
        return vos;
    }

    @Override
    public boolean checkGiftCardCanBindByCardNo(String cardNo) {
        WhWmsCheckGiftCardExample example = new WhWmsCheckGiftCardExample();
        example.createCriteria().andCardNoEqualTo(cardNo).andStatusEqualTo(WhWmsCheckGiftCardVO.STATUS_BOUND);
        List<WhWmsCheckGiftCard> boundGiftCardList = this.whWmsCheckGiftCardMapper.selectByExample(example);
        return EmptyUtil.isEmpty(boundGiftCardList);
    }

    @Override
    @Transactional
    public boolean unBoundCheckGiftCard(String packageCode) {
        WhWmsCheckGiftCard update = new WhWmsCheckGiftCard();
        update.setStatus(WhWmsCheckGiftCardVO.STATUS_UNBOUND);
        WhWmsCheckGiftCardExample example = new WhWmsCheckGiftCardExample();
        example.createCriteria().andPackageCodeEqualTo(packageCode).andStatusEqualTo(WhWmsCheckGiftCardVO.STATUS_BOUND);
        this.whWmsCheckGiftCardMapper.updateByExampleSelective(update, example);
        return true;
    }

    private boolean batchInserCheckGiftCard(List<WhWmsCheckGiftCardVO> checkGiftCardList) {
        if (EmptyUtil.isNotEmpty(checkGiftCardList)) {
            this.whWmsCheckGiftCardMapper.batchInsert(checkGiftCardList);
        }
        return true;
    }

    private Boolean isEbillMode(Integer expressType) {
        if (expressType.equals(WMSConstants.ExpressType.SF_LAND) || expressType.equals(WMSConstants.ExpressType.SF_AIR) || expressType.equals(WMSConstants.ExpressType.SF_COLD_CHAIN)) {
            CommGlobalConfig config = PegasusUtilFacade.getInstance().findConfigByKey("system.express.sf.isEBill");
            return config != null && config.getConfigValue().equals("1");
        }
        if (expressType.equals(WMSConstants.ExpressType.FEDEX)) {
            CommGlobalConfig config = PegasusUtilFacade.getInstance().findConfigByKey("system.express.fed.isEBill");
            return config != null && config.getConfigValue().equals("1");
        }
        return false;
    }
}

