/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWarehouseGroupCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhPhysicalWarehouseRelateWarehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWarehouseGroupMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouseRelateWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouseRelateWarehouseExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouseGroupExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWarehouseGroupService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPhysicalWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseGroupVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Service(value="whWarehouseGroupService")
public class WhWarehouseGroupServiceImpl
implements WhWarehouseGroupService {
    @Autowired
    private WhWarehouseGroupMapper whWarehouseGroupMapper;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhPhysicalWarehouseRelateWarehouseMapper whPhysicalWarehouseRelateWarehouseMapper;

    @Override
    public List<WhWarehouseGroupVO> findByCond(WhWarehouseGroupCond cond, boolean cascade) {
        List<WhWarehouseGroupVO> groupList = this.whWarehouseGroupMapper.findByCond(cond);
        if (cascade) {
            this.fullWarehouseGroup(groupList);
        }
        return groupList;
    }

    @Override
    public WhWarehouseGroupVO findWarehouseGroupByWhCode(String warehouseCode, boolean cascade) {
        if (EmptyUtil.isNotEmpty((String)warehouseCode)) {
            WhWarehouseGroupCond cond = new WhWarehouseGroupCond();
            cond.setRelateWhCodes(Collections.singletonList(warehouseCode));
            List<WhWarehouseGroupVO> list = this.findByCond(cond, cascade);
            if (EmptyUtil.isNotEmpty(list)) {
                return list.get(0);
            }
        }
        return null;
    }

    @Override
    public WhWarehouseGroupVO findWarehouseGroupByPhyWhCode(String phyWhCode, boolean cascade) {
        if (EmptyUtil.isNotEmpty((String)phyWhCode)) {
            WhWarehouseGroupCond cond = new WhWarehouseGroupCond();
            cond.setRelatePhyWhCodes(Collections.singletonList(phyWhCode));
            List<WhWarehouseGroupVO> list = this.findByCond(cond, cascade);
            if (EmptyUtil.isNotEmpty(list)) {
                return list.get(0);
            }
        }
        return null;
    }

    @Override
    public List<WhWarehouseGroupVO> findWarehouseGroupByWhCodes(WhWarehouseGroupCond cond) {
        return this.whWarehouseGroupMapper.findWarehouseGroupByWhCodes(cond);
    }

    @Override
    public List<WhWarehouseGroupVO> findByCodeOrName(String codeOrName) {
        return this.whWarehouseGroupMapper.findByCodeOrName(codeOrName);
    }

    @Override
    public Pagination<WhWarehouseGroupVO> findByCondPage(WhWarehouseGroupCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int count = this.whWarehouseGroupMapper.countByCond(cond);
        page.setRecord(Integer.valueOf(count));
        if (!NumberUtil.isNullOrZero((Number)count)) {
            List<WhWarehouseGroupVO> groupList = this.findByCond(cond, false);
            page.setResultList(groupList);
        }
        return page;
    }

    @Override
    public Map<Long, WhWarehouseGroupVO> findAllMap(boolean cascade) {
        HashMap<Long, WhWarehouseGroupVO> map = new HashMap<Long, WhWarehouseGroupVO>();
        List<WhWarehouseGroupVO> list = this.findAll(cascade);
        if (EmptyUtil.isNotEmpty(list)) {
            for (WhWarehouseGroupVO group : list) {
                map.put(group.getId(), group);
            }
        }
        return map;
    }

    @Override
    public Map<String, WhWarehouseGroupVO> findWhGroupMap(List<String> relateWarehouseCodes) {
        HashMap<String, WhWarehouseGroupVO> whGroupMap = new HashMap<String, WhWarehouseGroupVO>();
        if (EmptyUtil.isEmpty(relateWarehouseCodes)) {
            return whGroupMap;
        }
        WhWarehouseGroupCond cond = new WhWarehouseGroupCond();
        cond.setRelateWhCodes(relateWarehouseCodes);
        List<WhWarehouseGroupVO> groupList = this.findByCond(cond, true);
        if (EmptyUtil.isNotEmpty(groupList)) {
            for (WhWarehouseGroupVO group : groupList) {
                if (!EmptyUtil.isNotEmpty(group.getRelateWarehouses())) continue;
                for (WhWarehouseVO wh : group.getRelateWarehouses()) {
                    whGroupMap.put(wh.getCode(), group);
                }
            }
        }
        return whGroupMap;
    }

    @Override
    public List<WhWarehouseGroupVO> findAll(boolean cascade) {
        WhWarehouseGroupCond cond = new WhWarehouseGroupCond();
        return this.findByCond(cond, cascade);
    }

    @Override
    public WhWarehouseGroupVO findById(Long id, boolean cascade) {
        WhWarehouseGroupVO group = this.whWarehouseGroupMapper.findById(id);
        if (NullUtil.isNotNull((Object)group) && cascade) {
            this.fullWarehouseGroup(Collections.singletonList(group));
        }
        return group;
    }

    @Override
    public List<WhWarehouseGroupVO> findByIds(List<Long> ids) {
        WhWarehouseGroupExample example = new WhWarehouseGroupExample();
        example.createCriteria().andIdIn((List)ids);
        return BeanUtil.buildListFrom(this.whWarehouseGroupMapper.selectByExample(example), WhWarehouseGroupVO.class);
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(WhWarehouseGroupVO groupVO) {
        this.warehouseGroupRebuildeAndCheck(groupVO);
        if (NullUtil.isNotNull((Object)groupVO.getId())) {
            return this.update(groupVO);
        }
        return this.save(groupVO);
    }

    private boolean save(WhWarehouseGroupVO group) {
        group.setCreateTime(DateUtil.getNow());
        this.whWarehouseGroupMapper.insert(group);
        group.setCode(this.buildWarehouseGoupCode(group.getId()));
        this.whWarehouseGroupMapper.updateByPrimaryKeySelective(group);
        this.warehouseRelateWarehouseGroup(group);
        this.physicalWarehouseRelateWarehouseGroup(group);
        this.phyWhRelateInOutWh(group.getRelatePhysicalWarehouses());
        return true;
    }

    private String buildWarehouseGoupCode(Long id) {
        String code = id.toString();
        for (int i = code.length(); i <= 3; ++i) {
            code = "0" + code;
        }
        return "WG" + code;
    }

    private boolean update(WhWarehouseGroupVO group) {
        List<WhPhysicalWarehouseVO> oldPhyWhList = this.whInfoService.findPhysicalWarehouseByGroupId(Collections.singletonList(group.getId()));
        ArrayList<String> oldPhyWhCodes = new ArrayList<String>();
        for (WhPhysicalWarehouseVO phyWh : oldPhyWhList) {
            oldPhyWhCodes.add(phyWh.getCode());
        }
        this.phyWhRelieveInOutWh(oldPhyWhCodes);
        this.whInfoService.physicalWarehouseRelieveWarehouseGroup(group.getId());
        this.whWarehouseGroupMapper.updateByPrimaryKeySelective(group);
        this.whInfoService.warehouseRelieveWarehouseGroup(group.getId());
        this.whInfoService.physicalWarehouseRelieveWarehouseGroup(group.getId());
        this.warehouseRelateWarehouseGroup(group);
        this.physicalWarehouseRelateWarehouseGroup(group);
        this.phyWhRelateInOutWh(group.getRelatePhysicalWarehouses());
        return true;
    }

    private boolean phyWhRelateInOutWh(List<WhPhysicalWarehouseVO> physicalWarehouses) {
        ArrayList<WhPhysicalWarehouseRelateWarehouse> relateList = new ArrayList<WhPhysicalWarehouseRelateWarehouse>();
        for (WhPhysicalWarehouseVO physicalWarehouse : physicalWarehouses) {
            for (WhWarehouseVO relateWh : physicalWarehouse.getRelateInOutWarehouses()) {
                WhPhysicalWarehouseRelateWarehouse relate = new WhPhysicalWarehouseRelateWarehouse();
                relate.setSkuStatus(relateWh.getRelateInOutSkuStatus());
                relate.setType(relateWh.getRelateInOrOut());
                relate.setPhysicalWarehouseCode(physicalWarehouse.getCode());
                relate.setWarehouseCode(relateWh.getCode());
                relateList.add(relate);
            }
        }
        this.whPhysicalWarehouseRelateWarehouseMapper.batchInsert(relateList);
        return true;
    }

    private boolean phyWhRelieveInOutWh(List<String> phyWhCodes) {
        WhPhysicalWarehouseRelateWarehouseExample example = new WhPhysicalWarehouseRelateWarehouseExample();
        example.createCriteria().andPhysicalWarehouseCodeIn((List)phyWhCodes);
        this.whPhysicalWarehouseRelateWarehouseMapper.deleteByExample(example);
        return true;
    }

    private void warehouseRelateWarehouseGroup(WhWarehouseGroupVO group) {
        if (EmptyUtil.isNotEmpty(group.getRelateWarehouses())) {
            ArrayList<String> warehouseCodes = new ArrayList<String>();
            for (WhWarehouseVO warehouse : group.getRelateWarehouses()) {
                warehouseCodes.add(warehouse.getCode());
            }
            boolean relateReslut = this.whInfoService.warehouseRelateWarehouseGroup(warehouseCodes, group.getId());
            if (!relateReslut) {
                throw new WarehouseException("WH0001", "\u5b58\u5728\u903b\u8f91\u4ed3\u5df2\u5173\u8054\u5176\u5b83\u903b\u8f91\u4ed3\u5206\u7ec4");
            }
        }
    }

    private void physicalWarehouseRelateWarehouseGroup(WhWarehouseGroupVO group) {
        if (EmptyUtil.isNotEmpty(group.getRelatePhysicalWarehouses())) {
            ArrayList<String> physicalWarehouseCodes = new ArrayList<String>();
            for (WhPhysicalWarehouseVO physicalWarehouse : group.getRelatePhysicalWarehouses()) {
                physicalWarehouseCodes.add(physicalWarehouse.getCode());
            }
            boolean relateReslut = this.whInfoService.physicalWarehouseRelateWarehouseGroup(physicalWarehouseCodes, group.getId());
            if (!relateReslut) {
                throw new WarehouseException("WH0001", "\u5b58\u5728\u7269\u7406\u4ed3\u5df2\u5173\u8054\u5176\u5b83\u903b\u8f91\u4ed3\u5206\u7ec4");
            }
        }
    }

    private void warehouseGroupRebuildeAndCheck(WhWarehouseGroupVO group) {
        if (EmptyUtil.isEmpty(group.getRelatePhysicalWarehouses())) {
            throw new WarehouseException("WH0001", "\u903b\u8f91\u4ed3\u7ec4\u5fc5\u987b\u81f3\u5c11\u5173\u8054\u4e00\u4e2a\u7269\u7406\u4ed3");
        }
        if (EmptyUtil.isEmpty(group.getRelateWarehouses())) {
            throw new WarehouseException("WH0001", "\u903b\u8f91\u4ed3\u7ec4\u5fc5\u987b\u81f3\u5c11\u5305\u542b\u4e00\u4e2a\u903b\u8f91");
        }
        ArrayList<String> relateWhCodes = new ArrayList<String>();
        for (WhWarehouseVO whWarehouse : group.getRelateWarehouses()) {
            relateWhCodes.add(whWarehouse.getCode());
        }
        List<WhWarehouse> whList = this.whInfoService.findWarehouseByCodes(relateWhCodes);
        HashSet<Integer> whCommodityStatusSet = new HashSet<Integer>();
        for (WhWarehouse whWarehouse : whList) {
            whCommodityStatusSet.add(whWarehouse.getCommodityStatus());
        }
        if (!whCommodityStatusSet.contains(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE)) {
            throw new WarehouseException("WH0001", "\u7f3a\u5c11\u826f\u54c1\u903b\u8f91\u4ed3");
        }
        if (!(whCommodityStatusSet.contains(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED) || whCommodityStatusSet.contains(WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED) || whCommodityStatusSet.contains(WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED))) {
            throw new WarehouseException("WH0001", "\u7f3a\u5c11\u6b8b\u6b21\u903b\u8f91\u4ed3");
        }
        ArrayList<String> relateWarehouseCodes = new ArrayList<String>();
        for (WhWarehouseVO warehouse : group.getRelateWarehouses()) {
            relateWarehouseCodes.add(warehouse.getCode());
        }
        Object var6_8 = null;
        WhWarehouseVO reWh = null;
        for (WhPhysicalWarehouseVO phyWh : group.getRelatePhysicalWarehouses()) {
            WhWarehouseVO whWarehouseVO;
            WhWarehouseVO whWarehouseVO2;
            List<WhWarehouseVO> relateWh = phyWh.getRelateInOutWarehouses();
            if (EmptyUtil.isEmpty(phyWh.getRelateInOutWarehouses())) {
                throw new WarehouseException("WH0001", String.format("[%s\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u51fa\u5165\u5e93\u903b\u8f91\u4ed3]", phyWh.getCode()));
            }
            HashMap<String, WhWarehouseVO> inOutWarehouseMap = new HashMap<String, WhWarehouseVO>();
            String key = null;
            String keyOut = null;
            for (WhWarehouseVO relateWarehouse : phyWh.getRelateInOutWarehouses()) {
                if (!relateWarehouseCodes.contains(relateWarehouse.getCode())) {
                    throw new WarehouseException("WH0001", String.format("\u5f53\u524d\u903b\u8f91\u4ed3\u5206\u7ec4\u65e0\u903b\u8f91\u4ed3[%s]", relateWarehouse.getCode()));
                }
                key = this.buildRelateWarehouseKey(relateWarehouse.getRelateInOutSkuStatus(), relateWarehouse.getRelateInOrOut());
                inOutWarehouseMap.put(key, relateWarehouse);
            }
            key = this.buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE, WhWarehouseVO.RELATE_IN);
            if (NullUtil.isNull(inOutWarehouseMap.get(key))) {
                throw new WarehouseException("WH0001", String.format("[%s\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u826f\u54c1\u5165\u5e93\u903b\u8f91\u4ed3]", phyWh.getCode()));
            }
            key = this.buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE, WhWarehouseVO.RELATE_OUT);
            if (NullUtil.isNull(inOutWarehouseMap.get(key))) {
                throw new WarehouseException("WH0001", String.format("[%s\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u826f\u54c1\u51fa\u5e93\u903b\u8f91\u4ed3]", phyWh.getCode()));
            }
            key = this.buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED, WhWarehouseVO.RELATE_IN);
            WhWarehouseVO whWarehouseVO3 = (WhWarehouseVO)inOutWarehouseMap.get(key);
            if (NullUtil.isNull((Object)whWarehouseVO3)) {
                throw new WarehouseException("WH0001", String.format("[%s\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u8f7b\u6b8b\u54c1\u5165\u5e93\u903b\u8f91\u4ed3]", phyWh.getCode()));
            }
            keyOut = this.buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED, WhWarehouseVO.RELATE_OUT);
            if (NullUtil.isNull(inOutWarehouseMap.get(keyOut))) {
                reWh = (WhWarehouseVO)BeanUtil.buildFrom((Object)whWarehouseVO3, WhWarehouseVO.class);
                reWh.setRelateInOrOut(WhWarehouseVO.RELATE_OUT);
                relateWh.add(reWh);
            }
            if (NullUtil.isNull((Object)(whWarehouseVO2 = (WhWarehouseVO)inOutWarehouseMap.get(key = this.buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED, WhWarehouseVO.RELATE_IN))))) {
                throw new WarehouseException("WH0001", String.format("[%s\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u4e2d\u6b8b\u54c1\u5165\u5e93\u903b\u8f91\u4ed3]", phyWh.getCode()));
            }
            keyOut = this.buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED, WhWarehouseVO.RELATE_OUT);
            if (NullUtil.isNull(inOutWarehouseMap.get(keyOut))) {
                reWh = (WhWarehouseVO)BeanUtil.buildFrom((Object)whWarehouseVO2, WhWarehouseVO.class);
                reWh.setRelateInOrOut(WhWarehouseVO.RELATE_OUT);
                relateWh.add(reWh);
            }
            if (NullUtil.isNull((Object)(whWarehouseVO = (WhWarehouseVO)inOutWarehouseMap.get(key = this.buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED, WhWarehouseVO.RELATE_IN))))) {
                throw new WarehouseException("WH0001", String.format("[%s\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u91cd\u6b8b\u54c1\u5165\u5e93\u903b\u8f91\u4ed3]", phyWh.getCode()));
            }
            keyOut = this.buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED, WhWarehouseVO.RELATE_OUT);
            if (NullUtil.isNull(inOutWarehouseMap.get(keyOut))) {
                reWh = (WhWarehouseVO)BeanUtil.buildFrom((Object)whWarehouseVO, WhWarehouseVO.class);
                reWh.setRelateInOrOut(WhWarehouseVO.RELATE_OUT);
                relateWh.add(reWh);
            }
            key = this.buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE, WhWarehouseVO.RELATE_IN);
            WhWarehouseVO whWarehouseVO4 = (WhWarehouseVO)inOutWarehouseMap.get(key);
            keyOut = this.buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE, WhWarehouseVO.RELATE_OUT);
            if (NullUtil.isNull(inOutWarehouseMap.get(keyOut)) && NullUtil.isNotNull((Object)(reWh = (WhWarehouseVO)BeanUtil.buildFrom((Object)whWarehouseVO4, WhWarehouseVO.class)))) {
                reWh.setRelateInOrOut(WhWarehouseVO.RELATE_OUT);
                relateWh.add(reWh);
            }
            key = this.buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY, WhWarehouseVO.RELATE_IN);
            WhWarehouseVO whWarehouseVO5 = (WhWarehouseVO)inOutWarehouseMap.get(key);
            keyOut = this.buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY, WhWarehouseVO.RELATE_OUT);
            if (NullUtil.isNull(inOutWarehouseMap.get(keyOut)) && NullUtil.isNotNull((Object)(reWh = (WhWarehouseVO)BeanUtil.buildFrom((Object)whWarehouseVO5, WhWarehouseVO.class)))) {
                reWh.setRelateInOrOut(WhWarehouseVO.RELATE_OUT);
                relateWh.add(reWh);
            }
            key = this.buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_PROP, WhWarehouseVO.RELATE_IN);
            WhWarehouseVO whWarehouseVO6 = (WhWarehouseVO)inOutWarehouseMap.get(key);
            keyOut = this.buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_PROP, WhWarehouseVO.RELATE_OUT);
            if (NullUtil.isNull(inOutWarehouseMap.get(keyOut)) && NullUtil.isNotNull((Object)(reWh = (WhWarehouseVO)BeanUtil.buildFrom((Object)whWarehouseVO6, WhWarehouseVO.class)))) {
                reWh.setRelateInOrOut(WhWarehouseVO.RELATE_OUT);
                relateWh.add(reWh);
            }
            key = this.buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED, WhWarehouseVO.RELATE_IN);
            WhWarehouseVO whWarehouseVO7 = (WhWarehouseVO)inOutWarehouseMap.get(key);
            keyOut = this.buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED, WhWarehouseVO.RELATE_OUT);
            if (NullUtil.isNull(inOutWarehouseMap.get(keyOut)) && NullUtil.isNotNull((Object)(reWh = (WhWarehouseVO)BeanUtil.buildFrom((Object)whWarehouseVO7, WhWarehouseVO.class)))) {
                reWh.setRelateInOrOut(WhWarehouseVO.RELATE_OUT);
                relateWh.add(reWh);
            }
            key = this.buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING, WhWarehouseVO.RELATE_IN);
            WhWarehouseVO whWarehouseVO8 = (WhWarehouseVO)inOutWarehouseMap.get(key);
            keyOut = this.buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING, WhWarehouseVO.RELATE_OUT);
            if (!NullUtil.isNull(inOutWarehouseMap.get(keyOut)) || !NullUtil.isNotNull((Object)(reWh = (WhWarehouseVO)BeanUtil.buildFrom((Object)whWarehouseVO8, WhWarehouseVO.class)))) continue;
            reWh.setRelateInOrOut(WhWarehouseVO.RELATE_OUT);
            relateWh.add(reWh);
        }
    }

    private String buildRelateWarehouseKey(Integer skuStatus, Integer inOrOut) {
        return skuStatus + "_" + inOrOut;
    }

    private void fullWarehouseGroup(List<WhWarehouseGroupVO> groupList) {
        if (EmptyUtil.isEmpty(groupList)) {
            return;
        }
        ArrayList<Long> groupIdList = new ArrayList<Long>();
        for (WhWarehouseGroupVO group : groupList) {
            groupIdList.add(group.getId());
        }
        ArrayList<String> physicalWarehouseCodes = new ArrayList<String>();
        Map<Long, List<WhPhysicalWarehouseVO>> physicalWarehouseMap = this.whInfoService.findPhysicalWarehouseMapByGroupId(groupIdList);
        for (List<WhPhysicalWarehouseVO> list : physicalWarehouseMap.values()) {
            for (WhPhysicalWarehouseVO whPhysicalWarehouseVO : list) {
                physicalWarehouseCodes.add(whPhysicalWarehouseVO.getCode());
            }
        }
        HashMap<String, WhWarehouseVO> whMap = new HashMap<String, WhWarehouseVO>();
        Map<Long, List<WhWarehouseVO>> warehouseMap = this.whInfoService.findWarehouseMapByGroupId(groupIdList);
        for (List list : warehouseMap.values()) {
            for (WhWarehouseVO item : list) {
                whMap.put(item.getCode(), item);
            }
        }
        Map<String, List<WhPhysicalWarehouseRelateWarehouse>> phyWhRelateWhMap = this.findPhyWhRelateWarehouseMap(physicalWarehouseCodes);
        for (WhWarehouseGroupVO group : groupList) {
            if (physicalWarehouseMap.get(group.getId()) == null) continue;
            List<WhPhysicalWarehouseVO> groupPhyWhList = physicalWarehouseMap.get(group.getId());
            for (WhPhysicalWarehouseVO item : groupPhyWhList) {
                ArrayList<WhWarehouseVO> relateWhList = new ArrayList<WhWarehouseVO>();
                List<WhPhysicalWarehouseRelateWarehouse> phyWhRelateWhList = phyWhRelateWhMap.get(item.getCode());
                if (EmptyUtil.isNotEmpty(phyWhRelateWhList)) {
                    for (WhPhysicalWarehouseRelateWarehouse phyWhRelateWh : phyWhRelateWhList) {
                        WhWarehouseVO whWarehouse = (WhWarehouseVO)BeanUtil.buildFrom(whMap.get(phyWhRelateWh.getWarehouseCode()), WhWarehouseVO.class);
                        if (!NullUtil.isNotNull((Object)whWarehouse)) continue;
                        whWarehouse.setRelateInOrOut(phyWhRelateWh.getType());
                        whWarehouse.setRelateInOutSkuStatus(phyWhRelateWh.getSkuStatus());
                        relateWhList.add(whWarehouse);
                    }
                }
                item.setRelateInOutWarehouses(relateWhList);
            }
            List<WhWarehouseVO> groupWhList = warehouseMap.get(group.getId());
            group.setRelatePhysicalWarehouses(groupPhyWhList);
            group.setRelateWarehouses(groupWhList);
        }
    }

    private Map<String, List<WhPhysicalWarehouseRelateWarehouse>> findPhyWhRelateWarehouseMap(List<String> phyWhCodes) {
        WhPhysicalWarehouseRelateWarehouseExample example = new WhPhysicalWarehouseRelateWarehouseExample();
        example.createCriteria().andPhysicalWarehouseCodeIn((List)phyWhCodes);
        List<WhPhysicalWarehouseRelateWarehouse> list = this.whPhysicalWarehouseRelateWarehouseMapper.selectByExample(example);
        HashMap<String, List<WhPhysicalWarehouseRelateWarehouse>> map = new HashMap<String, List<WhPhysicalWarehouseRelateWarehouse>>();
        if (EmptyUtil.isNotEmpty(list)) {
            for (WhPhysicalWarehouseRelateWarehouse phyWhRelateWh : list) {
                ArrayList<WhPhysicalWarehouseRelateWarehouse> tmpList = (ArrayList<WhPhysicalWarehouseRelateWarehouse>)map.get(phyWhRelateWh.getPhysicalWarehouseCode());
                if (NullUtil.isNull((Object)tmpList)) {
                    tmpList = new ArrayList<WhPhysicalWarehouseRelateWarehouse>();
                    map.put(phyWhRelateWh.getPhysicalWarehouseCode(), tmpList);
                }
                tmpList.add(phyWhRelateWh);
            }
        }
        return map;
    }
}

