/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.common.exception.BusinessException;
import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.merchandise.service.McPcsBrandService;
import com.thebeastshop.pegasus.merchandise.vo.PcsBrandVO;
import com.thebeastshop.pegasus.service.warehouse.cond.WhTlBuyerApplyCondVO;
import com.thebeastshop.pegasus.service.warehouse.dao.WhTlBuyerApplyMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhTlBuyerPackageLineMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhTlBuyerPackageMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcdSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvOccupy;
import com.thebeastshop.pegasus.service.warehouse.model.WhTlBuyerApply;
import com.thebeastshop.pegasus.service.warehouse.model.WhTlBuyerApplyLine;
import com.thebeastshop.pegasus.service.warehouse.model.WhTlBuyerPackage;
import com.thebeastshop.pegasus.service.warehouse.model.WhTlBuyerPackageLine;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.service.WhAllotService;
import com.thebeastshop.pegasus.service.warehouse.service.WhBondedWarehouseAllotApplyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInvService;
import com.thebeastshop.pegasus.service.warehouse.service.WhTlBuyerPackageService;
import com.thebeastshop.pegasus.service.warehouse.vo.BondedWarehouseAllotPackageVO;
import com.thebeastshop.pegasus.service.warehouse.vo.PackingListExcelItemVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhReleaseOccupationVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhTlBuyerApplyVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhTlBuyerPackageOrderVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseSkuInvVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Service(value="whTlBuyerPackageService")
public class WhTlBuyerPackageServiceImpl
implements WhTlBuyerPackageService {
    @Autowired
    private WhBondedWarehouseAllotApplyService whBondedWarehouseAllotApplyService;
    @Autowired
    private WhTlBuyerPackageMapper whTlBuyerPackageMapper;
    @Autowired
    private WhTlBuyerPackageLineMapper whTlBuyerPackageLineMapper;
    @Autowired
    private WhTlBuyerApplyMapper whTlBuyerApplyMapper;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhAllotService whAllotService;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhInvService whInvService;
    @Autowired
    private McPcsBrandService brandService;

    @Override
    @Transactional
    public Integer batchCreatePackageOrder(List<Integer> applyIds, String name, Long operatorId) throws Exception {
        HashMap<String, WhTlBuyerPackageLine> skuWhTlBuyerPackageLineHashMap = new HashMap<String, WhTlBuyerPackageLine>();
        List<WhTlBuyerApplyVO> list = this.whBondedWarehouseAllotApplyService.findByIds(applyIds);
        WhTlBuyerPackage whTlBuyerPackage = new WhTlBuyerPackage();
        whTlBuyerPackage.setName(name);
        whTlBuyerPackage.setStatus(WhTlBuyerPackage.STATUS_WAITING_DELIVERY);
        whTlBuyerPackage.setCreateOperatorId(operatorId.intValue());
        whTlBuyerPackage.setCreateTime(new Date());
        this.whTlBuyerPackageMapper.insert(whTlBuyerPackage);
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("createTime", DateUtil.getNow());
        params.put("id", whTlBuyerPackage.getId());
        String code = CodeGenerator.getInstance().generate("WH_BONDED_WAREHOUSE_PACKAGE_CODE", params);
        ArrayList allApplyLineList = Lists.newArrayList();
        for (WhTlBuyerApplyVO whTlBuyerApplyVO : list) {
            for (WhTlBuyerApplyLine applyLine : whTlBuyerApplyVO.getWhTlBuyerApplyLines()) {
                WhTlBuyerPackageLine whTlBuyerPackageLine;
                if (null == skuWhTlBuyerPackageLineHashMap.get(applyLine.getSkuCode())) {
                    whTlBuyerPackageLine = new WhTlBuyerPackageLine();
                    whTlBuyerPackageLine.setBuyerPackageId(whTlBuyerPackage.getId());
                    whTlBuyerPackageLine.setSkuCode(applyLine.getSkuCode());
                    whTlBuyerPackageLine.setSkuName(applyLine.getSkuName());
                    whTlBuyerPackageLine.setBrandId(applyLine.getBrandId());
                    whTlBuyerPackageLine.setEbayItemCode(applyLine.getItemNumber());
                    whTlBuyerPackageLine.setBarcode(applyLine.getSupplierBarCode());
                    whTlBuyerPackageLine.setQuality(applyLine.getApprovedQuality());
                    PcsBrandVO pcsBrandVO = this.brandService.findById((long)applyLine.getBrandId().intValue());
                    whTlBuyerPackageLine.setBrandName(pcsBrandVO.getNameCn());
                    skuWhTlBuyerPackageLineHashMap.put(whTlBuyerPackageLine.getSkuCode(), whTlBuyerPackageLine);
                    continue;
                }
                whTlBuyerPackageLine = (WhTlBuyerPackageLine)skuWhTlBuyerPackageLineHashMap.get(applyLine.getSkuCode());
                whTlBuyerPackageLine.setQuality(whTlBuyerPackageLine.getQuality() + applyLine.getApprovedQuality());
                skuWhTlBuyerPackageLineHashMap.put(applyLine.getSkuCode(), whTlBuyerPackageLine);
            }
        }
        for (Map.Entry entry : skuWhTlBuyerPackageLineHashMap.entrySet()) {
            allApplyLineList.add(entry.getValue());
        }
        this.whTlBuyerPackageLineMapper.batchInsertRecord(allApplyLineList);
        List<WhReleaseOccupationVO> releaseOccupationVOList = this.buildReleaseOccupyVOList(list);
        this.whInvService.releaseOccupation(releaseOccupationVOList);
        Map<String, Map<String, Integer>> map = this.buildAllotMap(allApplyLineList);
        String allotCodes = this.createAllots(map, code, operatorId, list.get(0).getTargetWarehouseCode());
        whTlBuyerPackage.setCode(code);
        whTlBuyerPackage.setReferenceCode(allotCodes);
        this.whTlBuyerPackageMapper.updateByPrimaryKeySelective(whTlBuyerPackage);
        for (WhTlBuyerApplyVO whTlBuyerApplyVO : list) {
            WhTlBuyerApply whTlBuyerApply = new WhTlBuyerApply();
            whTlBuyerApply.setId(whTlBuyerApplyVO.getId());
            whTlBuyerApply.setStatus(WhTlBuyerApply.STATUS_WAITING_IN_WAREHOUSE);
            this.whBondedWarehouseAllotApplyService.updateApply(whTlBuyerApply);
        }
        this.whBondedWarehouseAllotApplyService.batchUpdate(applyIds, whTlBuyerPackage.getId());
        this.sendEmail(allApplyLineList, 0);
        return whTlBuyerPackage.getId();
    }

    private Map<String, Map<String, Integer>> buildAllotMap(List<WhTlBuyerPackageLine> allApplyLineList) {
        LinkedHashMap<String, Map<String, Integer>> warehouseSkuQtyMap = new LinkedHashMap<String, Map<String, Integer>>();
        warehouseSkuQtyMap.put("WH020600010096", new HashMap());
        warehouseSkuQtyMap.put("WH020600010102", new HashMap());
        HashMap<String, Integer> skuQtyMap = new HashMap<String, Integer>();
        for (WhTlBuyerPackageLine whTlBuyerPackageLine : allApplyLineList) {
            if (null == skuQtyMap.get(whTlBuyerPackageLine.getSkuCode())) {
                skuQtyMap.put(whTlBuyerPackageLine.getSkuCode(), whTlBuyerPackageLine.getQuality());
                continue;
            }
            skuQtyMap.put(whTlBuyerPackageLine.getSkuCode(), (Integer)skuQtyMap.get(whTlBuyerPackageLine.getSkuCode()) + whTlBuyerPackageLine.getQuality());
        }
        for (Map.Entry entry : skuQtyMap.entrySet()) {
            ArrayList warehouseCodeList = Lists.newArrayList();
            warehouseCodeList.add("WH020600010096");
            warehouseCodeList.add("WH020600010102");
            Integer availiableQty = 0;
            Integer warehouse_wh020600010096InvQty = 0;
            Integer warehouse_wh020600010102InvQty = 0;
            List<WhWarehouseSkuInvVO> whWarehouseSkuInvVOList = this.whInvService.findWarehousesSkuInvByCond(warehouseCodeList, (String)entry.getKey());
            for (WhWarehouseSkuInvVO whWarehouseSkuInvVO : whWarehouseSkuInvVOList) {
                availiableQty = availiableQty + whWarehouseSkuInvVO.getCanUseInv();
                if (whWarehouseSkuInvVO.getWarehouseCode().equals("WH020600010096")) {
                    warehouse_wh020600010096InvQty = whWarehouseSkuInvVO.getCanUseInv();
                    continue;
                }
                warehouse_wh020600010102InvQty = whWarehouseSkuInvVO.getCanUseInv();
            }
            if ((Integer)entry.getValue() > availiableQty) {
                throw new WarehouseException("CO0001", "SKU\u3010" + (String)entry.getKey() + "\u3011\u5e93\u5b58\u4e0d\u8db3");
            }
            if ((Integer)entry.getValue() >= warehouse_wh020600010096InvQty) {
                ((Map)warehouseSkuQtyMap.get("WH020600010096")).put(entry.getKey(), warehouse_wh020600010096InvQty);
                ((Map)warehouseSkuQtyMap.get("WH020600010102")).put(entry.getKey(), (Integer)entry.getValue() - warehouse_wh020600010096InvQty);
                continue;
            }
            ((Map)warehouseSkuQtyMap.get("WH020600010096")).put(entry.getKey(), entry.getValue());
        }
        return warehouseSkuQtyMap;
    }

    private List<WhReleaseOccupationVO> buildReleaseOccupyVOList(List<WhTlBuyerApplyVO> list) {
        ArrayList occupationVOS = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(list)) {
            for (WhTlBuyerApplyVO whTlBuyerApplyVO : list) {
                String applyCode = whTlBuyerApplyVO.getCode();
                List<WhInvOccupy> whInvOccupyList = this.whInvService.findOccupyQttByReferenceCodeLike(applyCode);
                if (!CollectionUtils.isNotEmpty(whInvOccupyList)) continue;
                for (WhInvOccupy whInvOccupy : whInvOccupyList) {
                    WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
                    whReleaseOccupationVO.setReferenceCode(whInvOccupy.getReferenceCode());
                    whReleaseOccupationVO.setOccupyType(whInvOccupy.getOccupyType());
                    occupationVOS.add(whReleaseOccupationVO);
                }
            }
        }
        return occupationVOS;
    }

    @Override
    public Pagination<WhTlBuyerPackageOrderVO> findByCond(WhTlBuyerApplyCondVO whTlBuyerApplyCondVO) {
        Pagination page = new Pagination(whTlBuyerApplyCondVO.getCurrpage(), whTlBuyerApplyCondVO.getPagenum());
        Integer count = this.whTlBuyerPackageMapper.countByCond(whTlBuyerApplyCondVO);
        page.setRecord(count);
        if (NumberUtil.isNullOrZero((Number)count)) {
            return null;
        }
        page.setResultList(this.whTlBuyerPackageMapper.findByCond(whTlBuyerApplyCondVO));
        return page;
    }

    @Override
    public WhTlBuyerPackageOrderVO findById(Integer id) {
        WhTlBuyerPackageOrderVO vo = this.whTlBuyerPackageMapper.findById(id);
        List<WhTlBuyerPackageLine> whTlBuyerPackageLines = this.whTlBuyerPackageLineMapper.findByPackageOrderId(id);
        vo.setWhTlBuyerPackageLines(whTlBuyerPackageLines);
        return vo;
    }

    @Override
    public List<WhTlBuyerPackageOrderVO> findByIds(List<Integer> ids) {
        return this.whTlBuyerPackageMapper.findByIds(ids);
    }

    @Override
    @Transactional
    public Integer packageOrderInOrOutBond(BondedWarehouseAllotPackageVO saveVO) throws Exception {
        List<WhTlBuyerApplyVO> applyVOS;
        Object whTlBuyerPackageLine1;
        Object updateRecord;
        ArrayList allotRcds = Lists.newArrayList();
        String allotCodes = saveVO.getWhTlBuyerPackage().getReferenceCode();
        String[] allotCodesArray = allotCodes.split(",");
        for (String allotCode : allotCodesArray) {
            WhAllotRcd whAllotRcd = this.whAllotService.findAllotRcdByCode(allotCode, false);
            allotRcds.add(whAllotRcd);
        }
        if (1 == saveVO.getType()) {
            for (WhAllotRcd whAllotRcd : allotRcds) {
                if (whAllotRcd.getAllotStatus() == WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND) continue;
                throw new BusinessException("SM1001", "\u8be5\u88c5\u7bb1\u5355\u5173\u8054\u7684\u8c03\u62e8\u5355\uff0c\u5b58\u5728\u72b6\u6001\u4e0d\u4e3a\u5f85\u51fa\u5e93\u7684\u8c03\u62e8\u5355\uff01");
            }
            this.outBound(saveVO);
            updateRecord = new WhTlBuyerPackage();
            ((WhTlBuyerPackage)updateRecord).setId(saveVO.getWhTlBuyerPackage().getId());
            ((WhTlBuyerPackage)updateRecord).setStatus(WhTlBuyerPackage.STATUS_DRIVER_GETED);
            Integer res = this.whTlBuyerPackageMapper.updateByPrimaryKeySelective((WhTlBuyerPackage)updateRecord);
            for (WhTlBuyerPackageLine whTlBuyerPackageLine : saveVO.getWhTlBuyerPackageLines()) {
                whTlBuyerPackageLine1 = new WhTlBuyerPackageLine();
                ((WhTlBuyerPackageLine)whTlBuyerPackageLine1).setId(whTlBuyerPackageLine.getId());
                ((WhTlBuyerPackageLine)whTlBuyerPackageLine1).setActualOutBoundQty(whTlBuyerPackageLine.getActualOutBoundQty());
                this.whTlBuyerPackageLineMapper.updateByPrimaryKeySelective((WhTlBuyerPackageLine)whTlBuyerPackageLine1);
            }
            WhTlBuyerApplyCondVO whTlBuyerApplyCondVO = new WhTlBuyerApplyCondVO();
            whTlBuyerApplyCondVO.setBuyerPackageId(saveVO.getWhTlBuyerPackage().getId());
            applyVOS = this.whTlBuyerApplyMapper.findByCond(whTlBuyerApplyCondVO);
            if (CollectionUtils.isNotEmpty(applyVOS)) {
                for (WhTlBuyerApplyVO applyVO : applyVOS) {
                    WhTlBuyerApply updateApplyRecord = new WhTlBuyerApply();
                    updateApplyRecord.setId(applyVO.getId());
                    updateApplyRecord.setStatus(WhTlBuyerApply.STATUS_WAITING_IN_WAREHOUSE);
                    this.whTlBuyerApplyMapper.updateByPrimaryKeySelective(updateApplyRecord);
                }
            }
            return res;
        }
        for (WhAllotRcd whAllotRcd : allotRcds) {
            if (whAllotRcd.getAllotStatus() == WhAllotRcd.STATUS_WAIT_FOR_INBOUND) continue;
            throw new BusinessException("SM1001", "\u8be5\u88c5\u7bb1\u5355\u5173\u8054\u7684\u8c03\u62e8\u5355\uff0c\u5b58\u5728\u72b6\u6001\u4e0d\u4e3a\u5f85\u5165\u5e93\u7684\u8c03\u62e8\u5355\uff01");
        }
        this.inBound(saveVO);
        updateRecord = new WhTlBuyerPackage();
        ((WhTlBuyerPackage)updateRecord).setId(saveVO.getWhTlBuyerPackage().getId());
        ((WhTlBuyerPackage)updateRecord).setStatus(WhTlBuyerPackage.STATUS_WAREHOUSE_IN);
        Integer res = this.whTlBuyerPackageMapper.updateByPrimaryKeySelective((WhTlBuyerPackage)updateRecord);
        for (WhTlBuyerPackageLine whTlBuyerPackageLine : saveVO.getWhTlBuyerPackageLines()) {
            whTlBuyerPackageLine1 = new WhTlBuyerPackageLine();
            ((WhTlBuyerPackageLine)whTlBuyerPackageLine1).setId(whTlBuyerPackageLine.getId());
            ((WhTlBuyerPackageLine)whTlBuyerPackageLine1).setReceiveGoodQty(whTlBuyerPackageLine.getReceiveGoodQty());
            ((WhTlBuyerPackageLine)whTlBuyerPackageLine1).setReceiveBadQty(whTlBuyerPackageLine.getReceiveBadQty());
            this.whTlBuyerPackageLineMapper.updateByPrimaryKeySelective((WhTlBuyerPackageLine)whTlBuyerPackageLine1);
        }
        WhTlBuyerApplyCondVO whTlBuyerApplyCondVO = new WhTlBuyerApplyCondVO();
        whTlBuyerApplyCondVO.setBuyerPackageId(saveVO.getWhTlBuyerPackage().getId());
        applyVOS = this.whTlBuyerApplyMapper.findByCond(whTlBuyerApplyCondVO);
        if (CollectionUtils.isNotEmpty(applyVOS)) {
            for (WhTlBuyerApplyVO applyVO : applyVOS) {
                WhTlBuyerApply updateApplyRecord = new WhTlBuyerApply();
                updateApplyRecord.setId(applyVO.getId());
                updateApplyRecord.setStatus(WhTlBuyerApply.STATUS_FINISH);
                this.whTlBuyerApplyMapper.updateByPrimaryKeySelective(updateApplyRecord);
            }
        }
        this.sendEmail(saveVO.getWhTlBuyerPackageLines(), 1);
        return res;
    }

    @Override
    public WhTlBuyerPackage findBuyerPackageDetailByIdForExceal(Integer buyerPackageId) {
        WhTlBuyerPackage whTlBuyerPackage = this.whTlBuyerPackageMapper.selectByPrimaryKey(buyerPackageId);
        List<PackingListExcelItemVO> listExcelItemVOS = this.whTlBuyerPackageLineMapper.findPackageOrderDetailByIdForExcel(buyerPackageId);
        whTlBuyerPackage.setPackingListExcelItemVOS(listExcelItemVOS);
        return whTlBuyerPackage;
    }

    private Boolean outBound(BondedWarehouseAllotPackageVO saveVO) throws Exception {
        List<String> allotCodes = Arrays.asList(saveVO.getWhTlBuyerPackage().getReferenceCode().split(","));
        for (String allotCode : allotCodes) {
            WhCommand whCommand = this.whCommandService.findCommandByReferenceCode(allotCode);
            if (whCommand == null || !whCommand.isOut()) {
                throw new BusinessException("SM1001", "\u6307\u4ee4\u4e0d\u5b58\u5728\uff01");
            }
            HashMap<String, Integer> commandSkuMap = new HashMap<String, Integer>();
            for (WhTlBuyerPackageLine packageLine : saveVO.getWhTlBuyerPackageLines()) {
                commandSkuMap.put(packageLine.getSkuCode(), packageLine.getActualOutBoundQty());
            }
            for (WhCommandSku whCommandSku : whCommand.getWhCommandSkuList()) {
                String commandSkuCode = whCommandSku.getSkuCode();
                Integer qtt = 0;
                qtt = (Integer)commandSkuMap.get(commandSkuCode) >= whCommandSku.getPlanedQuantity() ? whCommandSku.getPlanedQuantity() : (Integer)commandSkuMap.get(commandSkuCode);
                if (qtt == null) {
                    throw new BusinessException("sm1002", "command sku not match");
                }
                whCommandSku.setQuantity(qtt);
                whCommandSku.setDamagedQuantity(0);
            }
            whCommand.setOperatorId(saveVO.getOperatorId());
            boolean bl = this.whCommandService.finishCommand(whCommand);
        }
        return true;
    }

    private Boolean inBound(BondedWarehouseAllotPackageVO saveVO) throws Exception {
        List<String> allotCodes = Arrays.asList(saveVO.getWhTlBuyerPackage().getReferenceCode().split(","));
        HashMap<String, Integer> saveVOReceiveGoodSkuQty = new HashMap<String, Integer>();
        HashMap<String, Integer> saveVOReceiveBadSkuQty = new HashMap<String, Integer>();
        for (WhTlBuyerPackageLine packageLine : saveVO.getWhTlBuyerPackageLines()) {
            saveVOReceiveGoodSkuQty.put(packageLine.getSkuCode(), packageLine.getReceiveGoodQty());
            saveVOReceiveBadSkuQty.put(packageLine.getSkuCode(), packageLine.getReceiveBadQty());
        }
        for (String allotCode : allotCodes) {
            WhCommand whInCommand;
            WhCommand whCommand = this.whCommandService.findCommandByTypeAndReferenceCode(10, allotCode, true);
            if (whCommand == null || whCommand.isOut()) {
                throw new BusinessException("SM1001", "\u6307\u4ee4\u4e0d\u5b58\u5728\uff01");
            }
            for (WhCommandSku whCommandSku : whCommand.getWhCommandSkuList()) {
                Integer qtt = 0;
                String commandSkuCode = whCommandSku.getSkuCode();
                if (whCommandSku.getPlanedQuantity() <= (Integer)saveVOReceiveGoodSkuQty.get(commandSkuCode)) {
                    qtt = whCommandSku.getPlanedQuantity();
                    saveVOReceiveGoodSkuQty.put(commandSkuCode, (Integer)saveVOReceiveGoodSkuQty.get(commandSkuCode) - whCommandSku.getPlanedQuantity());
                    whCommandSku.setDamagedQuantity(0);
                } else {
                    qtt = (Integer)saveVOReceiveGoodSkuQty.get(commandSkuCode);
                    Integer damagedQty = 0;
                    damagedQty = (Integer)saveVOReceiveBadSkuQty.get(commandSkuCode) + (Integer)saveVOReceiveGoodSkuQty.get(commandSkuCode) > whCommandSku.getPlanedQuantity() ? Integer.valueOf(whCommandSku.getPlanedQuantity() - qtt) : (Integer)saveVOReceiveBadSkuQty.get(commandSkuCode);
                    saveVOReceiveGoodSkuQty.put(commandSkuCode, (Integer)saveVOReceiveGoodSkuQty.get(commandSkuCode) - qtt);
                    whCommandSku.setDamagedQuantity(damagedQty);
                    saveVOReceiveBadSkuQty.put(commandSkuCode, (Integer)saveVOReceiveBadSkuQty.get(commandSkuCode) - damagedQty);
                }
                whCommandSku.setQuantity(qtt);
            }
            whCommand.setOperatorId(saveVO.getOperatorId());
            boolean tf = this.whCommandService.finishCommand(whCommand);
            if (!whCommand.getInOutType().equals(WhCommand.TYPE_ALLOT_IN) || !CollectionUtils.isNotEmpty((whInCommand = this.bulidWhCommandForQc(whCommand)).getWhCommandSkuList())) continue;
            this.whCommandService.createCommandThenFinish(whInCommand);
        }
        return true;
    }

    private WhCommand bulidWhCommandForQc(WhCommand vo) throws Exception {
        WhCommand whCommand = new WhCommand();
        WhAllotRcd allotRcd = this.whAllotService.findAllotRcdByCode(vo.getReferenceCode(), false);
        if (NullUtil.isNull((Object)allotRcd)) {
            throw new WarehouseException("SM1004", String.format("[%s]\u8c03\u62e8\u5355\u4e0d\u5b58\u5728", vo.getReferenceCode()));
        }
        WhWarehouse whWarehouse = this.whInfoService.findWarehouseByCode(allotRcd.getSourceWarehouseCode());
        if (whWarehouse != null) {
            Integer commodityStatus = whWarehouse.getCommodityStatus();
            whCommand.setWarehouseCode(WhWarehouseVO.fetchDiffWarehouseByCommodityStatus(commodityStatus));
            whCommand.setPhysicalWarehouseCode("WH02060036");
            whCommand.setReferenceCode(vo.getReferenceCode() + "_1");
            whCommand.setInOutType(WhCommand.TYPE_ALLOT_IN);
            ArrayList<WhCommandSku> returnWhCommandSkuList = new ArrayList<WhCommandSku>();
            for (WhCommandSku sku : vo.getWhCommandSkuList()) {
                Integer planedQuantity = sku.getPlanedQuantity() - sku.getQuantity() - sku.getDamagedQuantity();
                if (planedQuantity <= 0) continue;
                WhCommandSku whCommandSku = new WhCommandSku();
                whCommandSku.setSkuCode(sku.getSkuCode());
                whCommandSku.setPlanedQuantity(planedQuantity);
                returnWhCommandSkuList.add(whCommandSku);
            }
            whCommand.setWhCommandSkuList(returnWhCommandSkuList);
        }
        return whCommand;
    }

    private String createAllots(Map<String, Map<String, Integer>> map, String packageOrderCode, Long operatorId, String applyTargetPhysicalWarehouseCode) throws Exception {
        StringBuilder allotCodes = new StringBuilder("");
        for (Map.Entry<String, Map<String, Integer>> entry : map.entrySet()) {
            WhWarehouse relateWarehouseVO;
            WhAllotRcd whAllotRcd = new WhAllotRcd();
            whAllotRcd.setAllotType(WhAllotRcd.TYPE_CROSS_BORDER_ALLOT);
            whAllotRcd.setSourceWarehouseCode(entry.getKey());
            HashSet<String> warehouseCodeSet = new HashSet<String>();
            warehouseCodeSet.add(entry.getKey());
            whAllotRcd.setSourcePhysicalWarehouseCode("WH20250047");
            whAllotRcd.setTargetPhysicalWarehouseCode(applyTargetPhysicalWarehouseCode);
            if (EmptyUtil.isNotEmpty((String)applyTargetPhysicalWarehouseCode) && NullUtil.isNotNull((Object)(relateWarehouseVO = this.whInfoService.findDefaultInNondefectiveWarehouseByPhyWhCode(applyTargetPhysicalWarehouseCode)))) {
                whAllotRcd.setTargetWarehouseCode(relateWarehouseVO.getCode());
            }
            whAllotRcd.setAllotStatus(WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND);
            whAllotRcd.setReferenceCode(packageOrderCode);
            whAllotRcd.setRemark("\u6d77\u6dd8\u8c03\u62e8");
            whAllotRcd.setCreateUserId(operatorId == null ? 1 : operatorId.intValue());
            ArrayList<WhAllotRcdSku> allotRcdSkus = new ArrayList<WhAllotRcdSku>();
            for (Map.Entry<String, Integer> skuEntry : entry.getValue().entrySet()) {
                if (skuEntry.getValue() <= 0) continue;
                WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
                whAllotRcdSku.setSkuCode(skuEntry.getKey());
                whAllotRcdSku.setQuantity(skuEntry.getValue());
                allotRcdSkus.add(whAllotRcdSku);
            }
            if (CollectionUtils.isEmpty(allotRcdSkus)) continue;
            whAllotRcd.setWhAllotRcdSkuList(allotRcdSkus);
            String allotCode = this.whAllotService.createAllotRcd(whAllotRcd);
            allotCodes.append(allotCode + ",");
        }
        return allotCodes.toString().substring(0, allotCodes.length() - 1);
    }

    public Boolean sendEmail(List<WhTlBuyerPackageLine> whTlBuyerPackageLines, Integer type) {
        StringBuffer emailContent = new StringBuffer();
        emailContent.append("<html><style>#table-5 thead th {background-color: rgb(156, 186, 95);color: #fff;border-bottom-width: 0;}");
        emailContent.append("#table-5 td {color: #000;}");
        emailContent.append("#table-5 tr, #table-5 th {border-width: 1px;border-style: solid;border-color: rgb(156, 186, 95);}");
        emailContent.append("#table-5 td, #table-5 th {padding: 5px 10px;font-size: 12px;font-family: Verdana;font-weight: bold;}</style>");
        if (EmptyUtil.isNotEmpty(whTlBuyerPackageLines)) {
            String title = "";
            title = type == 0 ? "<th>SKU</th><th>SKU\u540d</th><th>\u4f9b\u5e94\u5546\u6761\u7801</th><th>\u54c1\u724c</th><th>\u6570\u91cf</th>" : "<th>SKU</th><th>SKU\u540d</th><th>\u4f9b\u5e94\u5546\u6761\u7801</th><th>\u5546\u54c1\u8d27\u53f7</th><th>\u7533\u8bf7\u6570\u91cf</th><th>\u5ba1\u6279\u901a\u8fc7\u6570\u91cf</th><th>\u5b9e\u9645\u51fa\u5e93\u6570\u91cf</th><th>\u5b9e\u9645\u5165\u5e93\u826f\u54c1</th><th>\u5b9e\u9645\u5165\u5e93\u6b8b\u6b21</th>";
            emailContent.append("</br></br><table id='table-5'><thead>" + title + "</thead>");
            emailContent.append("<tbody>");
            for (WhTlBuyerPackageLine whTlBuyerPackageLine : whTlBuyerPackageLines) {
                emailContent.append("<tr>");
                if (type == 0) {
                    emailContent.append("<td>" + whTlBuyerPackageLine.getSkuCode() + "</td>");
                    emailContent.append("<td>" + whTlBuyerPackageLine.getSkuName() + "</td>");
                    emailContent.append("<td>" + whTlBuyerPackageLine.getBarcode() + "</td>");
                    emailContent.append("<td>" + whTlBuyerPackageLine.getBrandName() + "</td>");
                    emailContent.append("<td>" + whTlBuyerPackageLine.getQuality() + "</td>");
                    continue;
                }
                emailContent.append("<td>" + whTlBuyerPackageLine.getSkuCode() + "</td>");
                emailContent.append("<td>" + whTlBuyerPackageLine.getSkuName() + "</td>");
                emailContent.append("<td>" + whTlBuyerPackageLine.getBarcode() + "</td>");
                emailContent.append("<td>" + whTlBuyerPackageLine.getEbayItemCode() + "</td>");
                emailContent.append("<td>" + whTlBuyerPackageLine.getQuality() + "</td>");
                emailContent.append("<td>" + whTlBuyerPackageLine.getQuality() + "</td>");
                emailContent.append("<td>" + whTlBuyerPackageLine.getActualOutBoundQty() + "</td>");
                emailContent.append("<td>" + whTlBuyerPackageLine.getReceiveGoodQty() + "</td>");
                emailContent.append("<td>" + whTlBuyerPackageLine.getReceiveBadQty() + "</td>");
            }
            emailContent.append("</tr>");
        }
        emailContent.append("</tbody></table>");
        List<Object> toAddressList = new ArrayList();
        CommGlobalConfig commGlobalConfig = new CommGlobalConfig();
        commGlobalConfig = type == 0 ? PegasusUtilFacade.getInstance().findConfigByKey("whtl.packageOrder.addresses") : PegasusUtilFacade.getInstance().findConfigByKey("whtl.packageInOrOutBound.addresses");
        String[] toUser = commGlobalConfig.getConfigValue().split(",");
        toAddressList = Arrays.asList(toUser);
        EmailVO emailVO = new EmailVO();
        emailVO.setToAddressList(toAddressList);
        String subject = "";
        subject = type == 0 ? "\u6e2f\u4ed3\u6253\u5305\u901a\u77e5" : "\u6df1\u5733\u4ed3\u8c03\u62e8\u5165\u5e93\u901a\u77e5";
        emailVO.setSubject(subject);
        emailVO.setContent(emailContent.toString());
        if (CollectionUtils.isNotEmpty((Collection)emailVO.getToAddressList())) {
            EmailUtil.getInstance().send(emailVO);
        }
        return null;
    }
}

