/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.dao.TmallStockLogMapper;
import com.thebeastshop.pegasus.service.warehouse.model.TmallStockLog;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhThirdPartyService;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.vo.ThirdpartyGoodsQuantityRequest;
import com.thebeastshop.pegasus.util.vo.ThirdpartyGoodsQuantityResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import vipapis.delivery.Package;
import vipapis.delivery.PackageProduct;
import vipapis.delivery.PrintTemplateResponse;
import vipapis.delivery.Ship;

@Service(value="whThirdPartyService")
public class WhThirdPartyServiceImpl
implements WhThirdPartyService {
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private TmallStockLogMapper tmallStockLogMapper;
    private PegasusUtilFacade pegasusUtilFacade = PegasusUtilFacade.getInstance();

    @Override
    public boolean vipShip(WhCommand whCommand) {
        List<WhCommandSku> skuList = this.whCommandService.findCommandSkuByCommandCode(whCommand.getCode());
        ArrayList<Ship> shipList = new ArrayList<Ship>();
        Ship ship = new Ship();
        ship.setOrder_id(whCommand.getOuterOrderCode());
        ship.setPackage_type("1");
        ship.setCarrier_code("1000000458");
        ship.setCarrier_name("\u987a\u4e30\u901f\u8fd0(\u76f4\u53d1)");
        System.out.println("\u552f\u54c1\u4f1a\u53d1\u8d27\uff1a" + whCommand.getOuterOrderCode());
        ArrayList<Package> packages = new ArrayList<Package>();
        Package packagePojo = new Package();
        ArrayList<PackageProduct> productList = new ArrayList<PackageProduct>();
        for (WhCommandSku whCommandSku : skuList) {
            PackageProduct packageProduct = new PackageProduct();
            packageProduct.setBarcode(whCommandSku.getSkuCode());
            packageProduct.setAmount(whCommandSku.getQuantity());
            productList.add(packageProduct);
        }
        packagePojo.setPackage_product_list(productList);
        packagePojo.setTransport_no(whCommand.getExpressNo());
        packages.add(packagePojo);
        ship.setPackages(packages);
        shipList.add(ship);
        this.pegasusUtilFacade.vipShip(shipList);
        return true;
    }

    @Override
    public PrintTemplateResponse getPrintTemplate(String outerOrderCode) {
        return this.pegasusUtilFacade.getPrintTemplate(outerOrderCode);
    }

    @Override
    public ThirdpartyGoodsQuantityResponse syncCommodityStocks(ThirdpartyGoodsQuantityRequest goodsQuantitySyncVO) throws Exception {
        ThirdpartyGoodsQuantityResponse response = this.pegasusUtilFacade.syncThirdpartyGoodsStocks(goodsQuantitySyncVO);
        this.saveStockUpdateLog(goodsQuantitySyncVO, response);
        return response;
    }

    private void saveStockUpdateLog(ThirdpartyGoodsQuantityRequest request, ThirdpartyGoodsQuantityResponse response) {
        TmallStockLog tmallStockLog = new TmallStockLog();
        tmallStockLog.setGoodsId(request.getGoodsId());
        tmallStockLog.setQuantity(request.getQuantity());
        tmallStockLog.setSkuCode(request.getSkuCode());
        tmallStockLog.setReferenceCode(request.getReferenceCode());
        tmallStockLog.setSyncType(request.getReferenceType());
        tmallStockLog.setCreateTime(new Date());
        tmallStockLog.setChannelCode(request.getChannelCode());
        tmallStockLog.setSyncStatus(response.isUpdateSuccess() ? (short)1 : 0);
        tmallStockLog.setRemark(response.getMsg());
        this.tmallStockLogMapper.insertSelective(tmallStockLog);
    }
}

