/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageRowBounds;
import com.thebeastshop.common.validation.Validation;
import com.thebeastshop.pegasus.service.warehouse.cond.WhTakeStockCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhAllotRcdSkuMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhTakeStockMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhTakeStockRcdMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhAllotDiffDetailCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcdSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhTakeStock;
import com.thebeastshop.pegasus.service.warehouse.model.WhTakeStockRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStockRecord;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInvService;
import com.thebeastshop.pegasus.service.warehouse.service.WhTakeStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotDiffDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPhysicalWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhTakeStockRcdVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseGroupVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.Constants;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.model.CommSku;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whTakeStockService")
public class WhTakeStockServiceImpl
implements WhTakeStockService {
    private final Logger log = LoggerFactory.getLogger(WhTakeStockServiceImpl.class);
    @Autowired
    private WhTakeStockMapper whTakeStockMapper;
    @Autowired
    private WhTakeStockRcdMapper whTakeStockRcdMapper;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhInvService whInvService;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhAllotRcdSkuMapper whAllotRcdSkuMapper;
    @Autowired
    private WhAllotDiffDetailCustomMapper whAllotDiffDetailCustomMapper;
    private PegasusUtilFacade pegasusUtilFacade = PegasusUtilFacade.getInstance();

    @Override
    @Transactional
    public Long createTakeStock(WhTakeStock whTakeStock) throws Exception {
        List<WhTakeStockRcd> whTakeStockRcdList;
        if (NullUtil.isNull((Object)whTakeStock.getType())) {
            whTakeStock.setType(WhTakeStock.TYPE_SCM);
        }
        if (whTakeStock.getBatchNumber() == null) {
            whTakeStock.setBatchNumber(this.findMaxBatchNumber());
        }
        if ((whTakeStockRcdList = whTakeStock.getWhTakeStockRcdList()) == null || whTakeStockRcdList.isEmpty()) {
            throw new WarehouseException("CO0001", "\u76d8\u70b9\u884c\u4e3a\u7a7a");
        }
        WhWarehouseVO whWarehouseVO = this.whInfoService.findWarehouseAndGroupByWarehouseCode(whTakeStock.getWarehouseCode());
        if (EmptyUtil.isEmpty((Object)whWarehouseVO)) {
            throw new WarehouseException("WH0103", "\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728!");
        }
        Integer skuStatus = null;
        WhWmsHouseShelvesVO shelvesVO = null;
        boolean needUpdateWmsSkuStock = false;
        WhPhysicalWarehouse physicalWarehouse = null;
        if (!WhWarehouseGroupVO.WAREHOUSE_YES.equals(whWarehouseVO.getWarehouseGroupType())) {
            if (whTakeStock.isUpdatePhyWhStock()) {
                physicalWarehouse = EmptyUtil.isEmpty((String)whTakeStock.getPhysicalWarehouseCode()) ? this.findPhysicalByWarehouseCode(whTakeStock.getWarehouseCode()) : this.whInfoService.findPhysicalWarehouseByCode(whTakeStock.getPhysicalWarehouseCode());
                if (EmptyUtil.isEmpty((Object)physicalWarehouse)) {
                    throw new WarehouseException("WH0103", "\u7269\u7406\u4ed3\u4e0d\u5b58\u5728!");
                }
                skuStatus = this.whCommandService.getSkuStatusByWarehouseType(whWarehouseVO.getCommodityStatus());
                shelvesVO = this.getWhWmsHouseShelves(physicalWarehouse.getCode(), skuStatus);
                needUpdateWmsSkuStock = true;
            }
        } else if (!whTakeStock.isFromWms()) {
            skuStatus = this.whCommandService.getSkuStatusByWarehouseType(whWarehouseVO.getCommodityStatus());
            shelvesVO = this.getWhWmsHouseShelves("WH20250047", skuStatus);
        }
        whTakeStock.setCreateTime(DateUtil.getNow());
        this.whTakeStockMapper.insert(whTakeStock);
        Long whTakeStockId = whTakeStock.getId();
        ArrayList<WhAllotDiffDetailVO> allotDiffDetailVOs = new ArrayList<WhAllotDiffDetailVO>();
        for (WhTakeStockRcd whTakeStockRcd : whTakeStockRcdList) {
            Integer quantity = whTakeStockRcd.getQuantity();
            if (quantity == 0) continue;
            whTakeStockRcd.setTakeStockId(whTakeStockId);
            whTakeStockRcd.setResultType(quantity > 0 ? WhTakeStockRcd.TYPE_PROFIT : WhTakeStockRcd.TYPE_LOSS);
            this.whTakeStockRcdMapper.insert(whTakeStockRcd);
            if (whTakeStock.isUpdatePhyWhStock()) {
                if (needUpdateWmsSkuStock) {
                    this.updatePhyWhSkuStock(whTakeStockRcd, shelvesVO, skuStatus, whTakeStock.getCreateUserId());
                } else if (NullUtil.isNotNull((Object)whTakeStockRcd.getCrossBorderFlag()) && whTakeStockRcd.getCrossBorderFlag() == 1 && whTakeStock.getSyncSeaPhyWarehouse().booleanValue()) {
                    this.updatePhyWhSkuStock(whTakeStockRcd, shelvesVO, skuStatus, whTakeStock.getCreateUserId());
                }
            }
            WhInvRcd whInvRcd = new WhInvRcd();
            whInvRcd.setWmsTakeStockRcdId(whTakeStockRcd.getWmsTakeStockRcdId());
            whInvRcd.setTakeStockRcdId(whTakeStockRcd.getId().intValue());
            whInvRcd.setWarehouseCode(whTakeStock.getWarehouseCode());
            whInvRcd.setInOutType(WhTakeStockRcd.TYPE_PROFIT.equals(whTakeStockRcd.getResultType()) ? WhInvRcd.TYPE_PROFIT_IN : WhInvRcd.TYPE_LOSS_OUT);
            whInvRcd.setSkuCode(whTakeStockRcd.getSkuCode());
            whInvRcd.setQuantity(whTakeStockRcd.getQuantity());
            whInvRcd.setMemo(whTakeStockRcd.getMemo());
            whInvRcd.setSubmitTime(DateUtil.getNow());
            whInvRcd.setSubmitUserId(whTakeStock.getCreateUserId());
            this.whInvService.record(whInvRcd);
            if (!whTakeStock.isAllotDiffProcess()) continue;
            if (EmptyUtil.isNotEmpty((Object)whTakeStockRcd.getNeedUpdateAllotSkuId())) {
                WhAllotRcdSku record = new WhAllotRcdSku();
                record.setId(whTakeStockRcd.getNeedUpdateAllotSkuId());
                record.setProcessedQuantity(Math.abs(whTakeStockRcd.getQuantity()));
                this.whAllotRcdSkuMapper.updateProcessedQuantityByPrimaryKey(record);
            }
            this.buildAllotDiffDetailVOs(whTakeStock, whTakeStockRcd, allotDiffDetailVOs);
        }
        if (CollectionUtils.isNotEmpty(allotDiffDetailVOs)) {
            this.whAllotDiffDetailCustomMapper.batchInsert(allotDiffDetailVOs);
        }
        if (whTakeStock.isSyncThirdpartStock()) {
            String warehouseCode = whTakeStock.getWarehouseCode();
            if (Constants.warehouseMap.containsKey(warehouseCode)) {
                this.syncTmallStock(this.getSyncSkuList(whTakeStockRcdList), (String)Constants.warehouseMap.get(warehouseCode), whTakeStockId, whTakeStock.getCreateUserId());
            }
            this.trySyncJdStock(whTakeStock);
        }
        return whTakeStockId;
    }

    private void trySyncJdStock(WhTakeStock whTakeStock) {
        if (!this.pegasusUtilFacade.needSyncJdStock(whTakeStock.getWarehouseCode())) {
            return;
        }
        List<CommSku> skuList = this.getSyncSkuList(whTakeStock.getWhTakeStockRcdList());
        if (EmptyUtil.isNotEmpty(skuList)) {
            HashMap<String, Integer> skuQuantityMap = new HashMap<String, Integer>();
            for (CommSku commSku : skuList) {
                Integer total = (Integer)skuQuantityMap.get(commSku.getCode());
                if (NullUtil.isNull((Object)total)) {
                    total = 0;
                }
                skuQuantityMap.put(commSku.getCode(), total + commSku.getQuantity());
            }
            LinkedList<String> referenceCodes = new LinkedList<String>();
            referenceCodes.add(whTakeStock.getId().toString());
            this.whCommandService.syncJdSkuStock(whTakeStock.getWarehouseCode(), skuQuantityMap, Constants.STOCK_SYNC_TYPE_INVENTORY, referenceCodes, whTakeStock.getCreateUserId(), true);
        }
    }

    private boolean updatePhyWhSkuStock(WhTakeStockRcd whTakeStockRcd, WhWmsHouseShelvesVO shelvesVO, Integer skuStatus, Long operaterId) {
        Integer quantity = whTakeStockRcd.getQuantity();
        if (quantity > 0) {
            return this.updatePhyWhSkuStockIn(whTakeStockRcd, shelvesVO, skuStatus, operaterId);
        }
        if (quantity < 0) {
            return this.updatePhyWhSkuStockOut(whTakeStockRcd, shelvesVO, skuStatus, operaterId);
        }
        return true;
    }

    private boolean updatePhyWhSkuStockIn(WhTakeStockRcd whTakeStockRcd, WhWmsHouseShelvesVO shelvesVO, Integer skuStatus, Long operaterId) {
        WhWmsSkuStockRecord skuStockRecord = this.buildPhyWhSkuStockRcd(whTakeStockRcd, shelvesVO, skuStatus, operaterId);
        this.updatePhyWhSkuStock(Collections.singletonList(skuStockRecord));
        return true;
    }

    private boolean updatePhyWhSkuStockOut(WhTakeStockRcd whTakeStockRcd, WhWmsHouseShelvesVO shelvesVO, Integer skuStatus, Long operaterId) {
        this.whCommandService.updatePhyWhSkuStockOut(shelvesVO.getPhysicalWarehouseCode(), whTakeStockRcd.getSkuCode(), skuStatus, whTakeStockRcd.getQuantity(), this.buildPhyWhInOutType(whTakeStockRcd), whTakeStockRcd.getId().toString(), NullUtil.isNull((Object)operaterId) ? 1L : operaterId, whTakeStockRcd.getMemo());
        return true;
    }

    @Override
    @Transactional
    public List<Long> batchCreateTakeStock(List<WhTakeStock> whTakeStockList) throws Exception {
        ArrayList<Long> ids = new ArrayList<Long>();
        Long batchNumber = this.findMaxBatchNumber();
        for (WhTakeStock whTakeStock : whTakeStockList) {
            whTakeStock.setBatchNumber(batchNumber);
            ids.add(this.createTakeStock(whTakeStock));
        }
        return ids;
    }

    @Override
    public WhPhysicalWarehouseVO findPhysicalByWarehouseCode(String warehouseCode) {
        Validation.paramNotNull((Object)warehouseCode, (String)"\u903b\u8f91\u4ed3\u7f16\u7801\u4e3a\u7a7a");
        List<WhPhysicalWarehouseVO> physicalWarehouseVOs = this.whInfoService.findPhysicalWarehouseByWarehouseCode(warehouseCode);
        if (CollectionUtils.isEmpty(physicalWarehouseVOs)) {
            throw new WarehouseException("WH0103", "\u903b\u8f91\u4ed3[" + warehouseCode + "]\u5728\u903b\u8f91\u4ed3\u5206\u7ec4\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u7406\u4ed3\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        if (physicalWarehouseVOs.size() > 1) {
            throw new WarehouseException("WH0001", "\u903b\u8f91\u4ed3[" + warehouseCode + "]\u5bf9\u5e94\u7684\u7269\u7406\u4ed3\u6709\u591a\u4e2a\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        return physicalWarehouseVOs.get(0);
    }

    private void updatePhyWhSkuStock(List<WhWmsSkuStockRecord> skuStockRecordList) {
        if (EmptyUtil.isNotEmpty(skuStockRecordList)) {
            for (WhWmsSkuStockRecord skuStockRecord : skuStockRecordList) {
                this.whWmsSkuStockService.updateStockByCond(skuStockRecord.getQuantity(), skuStockRecord.getPhysicalWarehouseCode(), skuStockRecord.getHouseType(), skuStockRecord.getBarCode(), skuStockRecord.getShelvesCode(), skuStockRecord.getSkuCode(), skuStockRecord.getSkuStatus(), skuStockRecord.getInOutType(), skuStockRecord.getReceiptNo(), skuStockRecord.getCreateUserId(), skuStockRecord.getMemo(), 2);
            }
        }
    }

    private WhWmsSkuStockRecord buildPhyWhSkuStockRcd(WhTakeStockRcd whTakeStockRcd, WhWmsHouseShelvesVO shelvesVO, Integer skuStatus, Long operaterId) {
        WhWmsSkuStockRecord skuStockRecord = new WhWmsSkuStockRecord();
        skuStockRecord.setPhysicalWarehouseCode(shelvesVO.getPhysicalWarehouseCode());
        skuStockRecord.setSkuStatus(skuStatus);
        skuStockRecord.setQuantity(whTakeStockRcd.getQuantity());
        skuStockRecord.setSkuCode(whTakeStockRcd.getSkuCode());
        skuStockRecord.setBarCode(skuStockRecord.getSkuCode() + "_0000");
        skuStockRecord.setShelvesCode(shelvesVO.getCode());
        skuStockRecord.setHouseType(shelvesVO.getHouseType());
        skuStockRecord.setMemo(whTakeStockRcd.getMemo());
        skuStockRecord.setInOutType(this.buildPhyWhInOutType(whTakeStockRcd));
        skuStockRecord.setReceiptNo(whTakeStockRcd.getId().toString());
        skuStockRecord.setCreateTime(DateUtil.getNow());
        skuStockRecord.setCreateUserId(NullUtil.isNull((Object)operaterId) ? 1L : operaterId);
        return skuStockRecord;
    }

    private Integer buildPhyWhInOutType(WhTakeStockRcd whTakeStockRcd) {
        return WhTakeStockRcd.TYPE_PROFIT.equals(whTakeStockRcd.getResultType()) ? WhCommand.TYPE_INVENTROY_PROFIT_IN : WhCommand.TYPE_INVENTROY_LOSS_OUT;
    }

    private WhWmsHouseShelvesVO getWhWmsHouseShelves(String physicalWarehouseCode, Integer skuStatus) {
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setSkuStatus(skuStatus);
        List<WhWmsHouseShelvesVO> whWmsHouseShelvesList = this.whWmsHouseShelvesService.getHouseShelvesByCond(cond);
        if (CollectionUtils.isEmpty(whWmsHouseShelvesList)) {
            throw new WarehouseException("WH0001", "\u7269\u7406\u4ed3[" + cond.getPhysicalWarehouseCode() + "],SKU\u72b6\u6001[" + WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus()) + "],\u5e93\u4f4d\u4e0d\u5b58\u5728!");
        }
        if (whWmsHouseShelvesList.size() > 1) {
            throw new WarehouseException("WH0001", "\u7269\u7406\u4ed3[" + cond.getPhysicalWarehouseCode() + "],SKU\u72b6\u6001[" + WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus()) + "],\u67e5\u8be2\u6709\u591a\u4e2a\u5e93\u4f4d!");
        }
        return whWmsHouseShelvesList.get(0);
    }

    private void buildAllotDiffDetailVOs(WhTakeStock whTakeStock, WhTakeStockRcd whTakeStockRcd, List<WhAllotDiffDetailVO> allotDiffDetailVOs) {
        WhAllotDiffDetailVO whAllotDiffDetailVO = new WhAllotDiffDetailVO();
        whAllotDiffDetailVO.setCreateTime(DateUtil.getNow());
        whAllotDiffDetailVO.setOperatorId(EmptyUtil.isNotEmpty((Object)whTakeStock.getCreateUserId()) ? whTakeStock.getCreateUserId().intValue() : 1);
        whAllotDiffDetailVO.setSkuCode(whTakeStockRcd.getSkuCode());
        whAllotDiffDetailVO.setQuantity(whTakeStockRcd.getQuantity());
        whAllotDiffDetailVO.setProcessType(WhAllotDiffDetailVO.PROCESS_TYPE_INVENTORY);
        whAllotDiffDetailVO.setWarehouseCode(whTakeStock.getWarehouseCode());
        whAllotDiffDetailVO.setRefId(whTakeStock.getRefAllotId());
        allotDiffDetailVOs.add(whAllotDiffDetailVO);
    }

    @Override
    @Transactional
    public void recordScmStock(WhTakeStock whTakeStock) throws Exception {
        List<WhTakeStockRcd> whTakeStockRcdList = whTakeStock.getWhTakeStockRcdList();
        if (whTakeStockRcdList == null || whTakeStockRcdList.isEmpty()) {
            throw new WarehouseException("CO0001", "whTakeStockRcdList can not be empty.");
        }
        for (WhTakeStockRcd whTakeStockRcd : whTakeStockRcdList) {
            Integer quantity = whTakeStockRcd.getQuantity();
            if (quantity == 0) continue;
            whTakeStockRcd.setResultType(quantity > 0 ? WhTakeStockRcd.TYPE_PROFIT : WhTakeStockRcd.TYPE_LOSS);
            WhInvRcd whInvRcd = new WhInvRcd();
            whInvRcd.setWmsTakeStockRcdId(whTakeStockRcd.getWmsTakeStockRcdId());
            if (WhTakeStockRcd.TYPE_PROFIT.equals(whTakeStockRcd.getResultType()) && EmptyUtil.isEmpty((Object)whTakeStock.getInWhWarehouse())) {
                throw new WarehouseException("CO0001", whTakeStock.getNotExicstInWhWarehouseMsg());
            }
            if (WhTakeStockRcd.TYPE_LOSS.equals(whTakeStockRcd.getResultType()) && EmptyUtil.isEmpty((Object)whTakeStock.getOutWhWarehouse())) {
                throw new WarehouseException("CO0001", whTakeStock.getNotExicstOutWhWarehouseMsg());
            }
            whInvRcd.setWarehouseCode(WhTakeStockRcd.TYPE_PROFIT.equals(whTakeStockRcd.getResultType()) ? whTakeStock.getInWhWarehouse().getCode() : whTakeStock.getOutWhWarehouse().getCode());
            whInvRcd.setInOutType(WhTakeStockRcd.TYPE_PROFIT.equals(whTakeStockRcd.getResultType()) ? WhInvRcd.TYPE_PROFIT_IN : WhInvRcd.TYPE_LOSS_OUT);
            whInvRcd.setSkuCode(whTakeStockRcd.getSkuCode());
            whInvRcd.setQuantity(whTakeStockRcd.getQuantity());
            whInvRcd.setMemo(whTakeStockRcd.getMemo());
            whInvRcd.setSubmitUserId(whTakeStock.getCreateUserId());
            this.whInvService.record(whInvRcd);
        }
    }

    public void syncTmallStock(List<CommSku> skuList, String sessionKey, Long whTakeStockId, Long operatorId) throws Exception {
        if (EmptyUtil.isNotEmpty(skuList)) {
            for (CommSku pcsSkuVO : skuList) {
                this.whCommandService.synCommodityStocks(this.pegasusUtilFacade.getSkuNumIid(pcsSkuVO.getCode(), sessionKey), pcsSkuVO.getCode(), pcsSkuVO.getQuantity(), sessionKey, 2, whTakeStockId + "", operatorId);
            }
        }
    }

    private List<CommSku> getSyncSkuList(List<WhTakeStockRcd> whTakeStockRcdList) {
        ArrayList<CommSku> skuList = new ArrayList<CommSku>();
        if (EmptyUtil.isNotEmpty(whTakeStockRcdList)) {
            for (WhTakeStockRcd sku : whTakeStockRcdList) {
                if (!EmptyUtil.isEmpty((String)sku.getMemo()) && sku.getMemo().indexOf("\u9884\u552e") != -1) continue;
                CommSku pcsSku = new CommSku();
                pcsSku.setCode(sku.getSkuCode());
                pcsSku.setQuantity(sku.getQuantity().intValue());
                skuList.add(pcsSku);
            }
        }
        return skuList;
    }

    @Override
    public List<WhTakeStockRcdVO> findTakeStockByWarehouseCode(String warehouseCode, boolean fetchRcd) {
        WhTakeStockCond cond = new WhTakeStockCond();
        cond.setWarehouseCode(warehouseCode);
        cond.setFetchRcd(fetchRcd);
        return this.findTakeStockByCond(cond).getList();
    }

    @Override
    public PageInfo<WhTakeStockRcdVO> findTakeStockByCond(WhTakeStockCond cond) {
        int offset = cond.getCurrpage() * cond.getPagenum();
        PageRowBounds pageRowBounds = new PageRowBounds(offset, cond.getPagenum().intValue());
        PageInfo ageInfo = new PageInfo(this.whTakeStockMapper.findTakeStockByCond(cond, pageRowBounds));
        ageInfo.setTotal(pageRowBounds.getTotal().longValue());
        return ageInfo;
    }

    @Override
    public Long findMaxBatchNumber() {
        String dateStr = DateUtil.format((Date)new Date(), (String)"yyyyMMdd");
        Long maxBatchNumber = this.whTakeStockMapper.selectMaxBatchNumber(dateStr);
        if (maxBatchNumber == null) {
            return Long.valueOf(dateStr + "001");
        }
        return maxBatchNumber + 1L;
    }
}

