/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.utils.BeanUtil;
import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.common.utils.NullUtil;
import com.thebeastshop.pegasus.service.warehouse.dao.WhJitPackageSkuReferenceMapper;
import com.thebeastshop.pegasus.service.warehouse.model.WhJitPackageSkuReference;
import com.thebeastshop.pegasus.service.warehouse.model.WhJitPackageSkuReferenceExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhJitPackageSkuReferenceService;
import com.thebeastshop.pegasus.service.warehouse.vo.AssociatedInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhJitPackageSkuReferenceVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whJitPackageSkuReferenceService")
public class WhJitPackageSkuReferenceServiceImpl
implements WhJitPackageSkuReferenceService {
    @Autowired
    private WhJitPackageSkuReferenceMapper whJitPackageSkuReferenceMapper;

    @Override
    @Transactional
    public boolean createWhJitPackageSkuReference(WhJitPackageSkuReferenceVO vo) {
        vo.setStatus(WhJitPackageSkuReferenceVO.STATUS_PROCESSING);
        vo.setCreateTime(DateUtil.getNow());
        WhJitPackageSkuReference record = this.buildModelFromVo(vo);
        this.whJitPackageSkuReferenceMapper.insert(record);
        return true;
    }

    @Override
    @Transactional
    public boolean updateByPrimaryKeySelective(WhJitPackageSkuReference record) {
        return this.whJitPackageSkuReferenceMapper.updateByPrimaryKeySelective(record) != 0;
    }

    @Override
    @Transactional
    public boolean createWhJitPackageSkuReference(List<WhJitPackageSkuReferenceVO> voList) {
        if (EmptyUtil.isEmpty(voList)) {
            return false;
        }
        for (WhJitPackageSkuReferenceVO vo : voList) {
            this.createWhJitPackageSkuReference(vo);
        }
        return true;
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findByReferenceCode(String referenceCode) {
        return this.findByReferenceCode(Collections.singletonList(referenceCode));
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findBySkuCode(String skuCode) {
        return this.findBySkuCode(Collections.singletonList(skuCode));
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findByPackageCode(String packageCode) {
        return this.findByPackageCode(Collections.singletonList(packageCode));
    }

    @Override
    public int findUndistributedNumberByreferenceCode(String referenceCode) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("referenceCode", referenceCode);
        return this.whJitPackageSkuReferenceMapper.findUndistributedNumberByreferenceCode(params);
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findByReferenceCode(List<String> referenceCodeList) {
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_PROCESSING);
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_FINISHED);
        WhJitPackageSkuReferenceExample example = new WhJitPackageSkuReferenceExample();
        example.createCriteria().andReferenceCodeIn((List)referenceCodeList).andStatusIn(statusList);
        return BeanUtil.buildListFrom(this.whJitPackageSkuReferenceMapper.selectByExample(example), WhJitPackageSkuReferenceVO.class);
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findBySkuCode(List<String> skuCodeList) {
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_PROCESSING);
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_FINISHED);
        WhJitPackageSkuReferenceExample example = new WhJitPackageSkuReferenceExample();
        example.createCriteria().andSkuCodeIn((List)skuCodeList).andStatusIn(statusList);
        return BeanUtil.buildListFrom(this.whJitPackageSkuReferenceMapper.selectByExample(example), WhJitPackageSkuReferenceVO.class);
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findByPackageCode(List<String> packageCodeList) {
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_PROCESSING);
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_FINISHED);
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        typeList.add(2);
        typeList.add(4);
        WhJitPackageSkuReferenceExample example = new WhJitPackageSkuReferenceExample();
        example.createCriteria().andPackageCodeIn((List)packageCodeList).andStatusIn(statusList).andTypeIn(typeList);
        return BeanUtil.buildListFrom(this.whJitPackageSkuReferenceMapper.selectByExample(example), WhJitPackageSkuReferenceVO.class);
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findJitPackageRefByPackageCode(String packageCode, Integer type) {
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_PROCESSING);
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_FINISHED);
        WhJitPackageSkuReferenceExample example = new WhJitPackageSkuReferenceExample();
        example.createCriteria().andPackageCodeEqualTo(packageCode).andStatusIn(statusList).andTypeEqualTo(type);
        return BeanUtil.buildListFrom(this.whJitPackageSkuReferenceMapper.selectByExample(example), WhJitPackageSkuReferenceVO.class);
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findNeedAllotPackageByReferenceCode(String referenceCode, Integer type) {
        return BeanUtil.buildListFrom(this.whJitPackageSkuReferenceMapper.findNeedAllotPackageByReferenceCode(referenceCode, type), WhJitPackageSkuReferenceVO.class);
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findOpJitPackageReferenceListByTypeAndReferenceCode(String referenceCode, Integer type) {
        WhJitPackageSkuReferenceExample example = new WhJitPackageSkuReferenceExample();
        WhJitPackageSkuReferenceExample.Criteria criteria = example.createCriteria();
        criteria.andTypeEqualTo(type);
        criteria.andReferenceCodeEqualTo(referenceCode);
        return BeanUtil.buildListFrom(this.whJitPackageSkuReferenceMapper.selectByExample(example), WhJitPackageSkuReferenceVO.class);
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findOpJitPackageReferenceByTypeAndReferenceCode(List<String> referenceCodes, Integer type) {
        if (EmptyUtil.isEmpty(referenceCodes)) {
            return new ArrayList<WhJitPackageSkuReferenceVO>();
        }
        WhJitPackageSkuReferenceExample example = new WhJitPackageSkuReferenceExample();
        WhJitPackageSkuReferenceExample.Criteria criteria = example.createCriteria();
        criteria.andTypeEqualTo(type);
        criteria.andReferenceCodeIn((List)referenceCodes);
        return BeanUtil.buildListFrom(this.whJitPackageSkuReferenceMapper.selectByExample(example), WhJitPackageSkuReferenceVO.class);
    }

    @Override
    public WhJitPackageSkuReferenceVO findLastUsableJitPackageReferenceByTypeAndReferenceCode(String referenceCode, Integer type) {
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_PROCESSING);
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_FINISHED);
        WhJitPackageSkuReferenceExample example = new WhJitPackageSkuReferenceExample();
        WhJitPackageSkuReferenceExample.Criteria criteria = example.createCriteria();
        criteria.andTypeEqualTo(type);
        criteria.andReferenceCodeEqualTo(referenceCode);
        criteria.andStatusIn(statusList);
        example.setOrderByClause("id desc");
        List<WhJitPackageSkuReference> list = this.whJitPackageSkuReferenceMapper.selectByExample(example);
        if (EmptyUtil.isNotEmpty(list)) {
            return (WhJitPackageSkuReferenceVO)BeanUtil.buildFrom((Object)list.get(0), WhJitPackageSkuReferenceVO.class);
        }
        return null;
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findNeedAllotByReferenceCode(String packageCode, String skuCode) {
        return this.whJitPackageSkuReferenceMapper.findNeedAllotByReferenceCode(packageCode, skuCode);
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findNeedAllotByPackageCodeAndSkuCode(String packageCode, String skuCode, Integer referenceType) {
        return this.whJitPackageSkuReferenceMapper.findNeedAllotByPackageCodeAndSkuCode(packageCode, skuCode, referenceType);
    }

    @Override
    public int countAssigndNumber(String packageCode, String skuCode) {
        WhJitPackageSkuReferenceExample example = new WhJitPackageSkuReferenceExample();
        example.createCriteria().andPackageCodeEqualTo(packageCode).andSkuCodeEqualTo(skuCode);
        return this.whJitPackageSkuReferenceMapper.countAssigndNumber(example);
    }

    @Override
    public WhJitPackageSkuReferenceVO findPopWarehouseByReferenceCode(String referenceCode) {
        return this.whJitPackageSkuReferenceMapper.findPopWarehouseByReferenceCode(referenceCode);
    }

    @Override
    public WhJitPackageSkuReferenceVO findPjWarehouseByReferenceCode(String referenceCode) {
        return this.whJitPackageSkuReferenceMapper.findPjWarehouseByReferenceCode(referenceCode);
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findByPackageCode(List<String> packageCodeList, Integer referenceType) {
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_PROCESSING);
        statusList.add(WhJitPackageSkuReferenceVO.STATUS_FINISHED);
        WhJitPackageSkuReferenceExample example = new WhJitPackageSkuReferenceExample();
        example.createCriteria().andPackageCodeIn((List)packageCodeList).andStatusIn(statusList).andTypeEqualTo(referenceType);
        return BeanUtil.buildListFrom(this.whJitPackageSkuReferenceMapper.selectByExample(example), WhJitPackageSkuReferenceVO.class);
    }

    @Override
    public Map<String, List<WhJitPackageSkuReferenceVO>> findByReferenceCodeGroup(List<String> referenceCodeList) {
        return this.groupByReferenceCode(this.findByReferenceCode(referenceCodeList));
    }

    private Map<String, List<WhJitPackageSkuReferenceVO>> groupByReferenceCode(List<WhJitPackageSkuReferenceVO> list) {
        HashMap<String, List<WhJitPackageSkuReferenceVO>> map = new HashMap<String, List<WhJitPackageSkuReferenceVO>>();
        if (EmptyUtil.isNotEmpty(list)) {
            for (WhJitPackageSkuReferenceVO vo : list) {
                ArrayList<WhJitPackageSkuReferenceVO> tmpList = (ArrayList<WhJitPackageSkuReferenceVO>)map.get(vo.getReferenceCode());
                if (NullUtil.isNull((Object)tmpList)) {
                    tmpList = new ArrayList<WhJitPackageSkuReferenceVO>();
                    map.put(vo.getReferenceCode(), tmpList);
                }
                tmpList.add(vo);
            }
        }
        return map;
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotSendMailAfterJobCancel() {
        return this.whJitPackageSkuReferenceMapper.findJitPackageSkuNotSendMailAfterJobCancel();
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotSendMailAfterJobFinishException() {
        return this.whJitPackageSkuReferenceMapper.findJitPackageSkuNotSendMailAfterJobFinishException();
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotCreatePrdcJobAfterAltFinished() {
        return this.whJitPackageSkuReferenceMapper.findJitPackageSkuNotCreatePrdcJobAfterAltFinished();
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotSendMailAfterAltFinished(WhJitPackageSkuReferenceVO vo) {
        return this.whJitPackageSkuReferenceMapper.findJitPackageSkuNotSendMailAfterAltFinished(vo);
    }

    @Override
    public Map<String, List<WhJitPackageSkuReferenceVO>> findJitPackageSkuNotCreatePrdcJobAfterAltFinishedGroup() {
        return this.groupByReferenceCode(this.findJitPackageSkuNotCreatePrdcJobAfterAltFinished());
    }

    @Override
    public Map<String, List<WhJitPackageSkuReferenceVO>> findJitPackageSkuNotSendMailAfterAltFinishedGroup(WhJitPackageSkuReferenceVO vo) {
        return this.groupByReferenceCode(this.findJitPackageSkuNotSendMailAfterAltFinished(vo));
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotAltAfterPrdcJobFinished() {
        return this.whJitPackageSkuReferenceMapper.findJitPackageSkuNotAltAfterPrdcJobFinished();
    }

    @Override
    public Map<String, List<WhJitPackageSkuReferenceVO>> findJitPackageSkuNotAltAfterPrdcJobFinishedGroup() {
        return this.groupByReferenceCode(this.findJitPackageSkuNotAltAfterPrdcJobFinished());
    }

    @Override
    public Map<String, List<WhJitPackageSkuReferenceVO>> findJitPackageSkuOrderCancelGroup() {
        List<WhJitPackageSkuReferenceVO> list = this.whJitPackageSkuReferenceMapper.findJitPackageSkuOrderCancel();
        return this.groupByReferenceCode(list);
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuNotSendMailAfterOrderCancel() {
        return this.whJitPackageSkuReferenceMapper.findJitPackageSkuNotSendMailAfterOrderCancel();
    }

    @Override
    public Map<String, List<WhJitPackageSkuReferenceVO>> findJitPackageSkuNotProcessAfterOrderPaidGroup() {
        List<WhJitPackageSkuReferenceVO> list = this.whJitPackageSkuReferenceMapper.findJitPackageSkuNotProcessAfterOrderPaid();
        return this.groupByReferenceCode(list);
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findJitPackageSkuByPackageCode(List<String> packageCodes) {
        return this.whJitPackageSkuReferenceMapper.findJitPackageSkuByPackageCode(packageCodes);
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findReferenceCodeByPackageCode(List<String> packageCodes) {
        return this.whJitPackageSkuReferenceMapper.findReferenceCodeByPackageCode(packageCodes);
    }

    @Override
    public List<AssociatedInfoVO> findAssociatedInfoByreferenceCode(String referenceCode) {
        return this.whJitPackageSkuReferenceMapper.findAssociatedInfoByreferenceCode(referenceCode);
    }

    @Override
    public List<AssociatedInfoVO> findJobAssociatedInfoByreferenceCode(String referenceCode) {
        return this.whJitPackageSkuReferenceMapper.findJobAssociatedInfoByreferenceCode(referenceCode);
    }

    @Override
    public List<WhJitPackageSkuReferenceVO> findNonCustomByPackageCode(Long orderId) {
        return this.whJitPackageSkuReferenceMapper.findNonCustomByPackageCode(orderId);
    }

    @Override
    @Transactional
    public boolean deleteByReferenceCode(String referenceCode) {
        this.whJitPackageSkuReferenceMapper.deleteByReferenceCode(referenceCode);
        return true;
    }

    @Override
    @Transactional
    public boolean finishByReferenceCode(String referenceCode) {
        this.whJitPackageSkuReferenceMapper.finishByReferenceCode(referenceCode);
        return true;
    }

    private WhJitPackageSkuReference buildModelFromVo(WhJitPackageSkuReferenceVO vo) {
        return (WhJitPackageSkuReference)BeanUtil.buildFrom((Object)vo, WhJitPackageSkuReference.class);
    }
}

