/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.PhyWhStockCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhInventoryCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhInventoryDetailCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhInventoryConfigMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhInventoryDetailMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhInventoryEmailMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhInventoryMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhInventoryReasionDicMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhInventorySkuCategoryMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhInventory;
import com.thebeastshop.pegasus.service.warehouse.model.WhInventoryConfig;
import com.thebeastshop.pegasus.service.warehouse.model.WhInventoryConfigExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhInventoryDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhInventoryDetailExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhInventoryEmail;
import com.thebeastshop.pegasus.service.warehouse.model.WhInventoryEmailExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhInventoryExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhInventoryReasionDic;
import com.thebeastshop.pegasus.service.warehouse.model.WhInventoryReasionDicExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhInventorySkuCategory;
import com.thebeastshop.pegasus.service.warehouse.model.WhInventorySkuCategoryExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhTakeStock;
import com.thebeastshop.pegasus.service.warehouse.model.WhTakeStockRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInvService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInventoryService;
import com.thebeastshop.pegasus.service.warehouse.service.WhTakeStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.vo.PhyWhStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCountVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvRcdVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInventoryAuditVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInventoryConfigVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInventoryCountInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInventoryCreateVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInventoryDetailAuditVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInventoryDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInventoryEmailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInventoryReasionDicVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInventoryVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPhysicalWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Service(value="whInventoryService")
public class WhInventoryServiceImpl
implements WhInventoryService {
    @Autowired
    private WhInventoryMapper whInventoryMapper;
    @Autowired
    private WhInventoryDetailMapper whInventoryDetailMapper;
    @Autowired
    private WhInventorySkuCategoryMapper whInventorySkuCategoryMapper;
    @Autowired
    private WhInventoryReasionDicMapper whInventoryReasionDicMapper;
    @Autowired
    private WhInventoryConfigMapper whInventoryConfigMapper;
    @Autowired
    private WhInventoryEmailMapper whInventoryEmailMapper;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhWmsSkuStockService wmsSkuStockService;
    @Autowired
    private WhInvService whInvService;
    @Autowired
    private WhTakeStockService whTakeStockService;

    @Override
    @Transactional
    public boolean createWhInventory(WhInventoryCreateVO inventoryInfo) {
        this.preCheckCreateInfo(inventoryInfo);
        Date time = DateUtil.getNow();
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String physicalWarehouseCode : inventoryInfo.getPhysicalWarehouseCodeList()) {
            WhInventoryVO inventory = (WhInventoryVO)BeanUtil.buildFrom((Object)inventoryInfo, WhInventoryVO.class);
            inventory.setPhysicalWarehouseCode(physicalWarehouseCode);
            inventory.setCreateTime(time);
            inventory.setStatus(WhInventoryVO.STATUS_INIT);
            inventory.setSkuCategoryIdList(inventoryInfo.getSkuCategoryList());
            this.createWhInventory(inventory);
            idList.add(inventory.getId());
        }
        inventoryInfo.setInventoryIdList(idList);
        return true;
    }

    private void preCheckCreateInfo(WhInventoryCreateVO inventoryInfo) {
        if (EmptyUtil.isEmpty(inventoryInfo.getPhysicalWarehouseCodeList())) {
            throw new WarehouseException("WH0001", "\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u9700\u8981\u76d8\u70b9\u7684\u7269\u7406\u4ed3");
        }
        if (EmptyUtil.isEmpty(inventoryInfo.getSkuCategoryList())) {
            throw new WarehouseException("WH0001", "\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u9700\u8981\u76d8\u70b9\u7684\u54c1\u7c7b");
        }
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(WhInventoryVO.STATUS_INIT);
        statusList.add(WhInventoryVO.STATUS_PROCESSING);
        statusList.add(WhInventoryVO.STATUS_WAIT_AUDIT_FINANCE);
        statusList.add(WhInventoryVO.STATUS_WAIT_AUDIT_MANAGER);
        WhInventoryCond cond = new WhInventoryCond();
        cond.setPhyWhCodeList(inventoryInfo.getPhysicalWarehouseCodeList());
        cond.setStatusList(statusList);
        List<WhInventoryVO> inventoryList = this.findWhInventoryByCond(cond);
        if (EmptyUtil.isNotEmpty(inventoryList)) {
            Map<String, WhPhysicalWarehouseVO> phyWhMap = this.whInfoService.findAllPhysicalWarehouseMap();
            StringBuilder buff = new StringBuilder();
            for (WhInventoryVO inventory : inventoryList) {
                WhPhysicalWarehouseVO phyWh = phyWhMap.get(inventory.getPhysicalWarehouseCode());
                buff.append(String.format("[%s]%s\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u4efb\u52a1,\u7ed3\u675f\u540e\u624d\u80fd\u521b\u5efa\u65b0\u7684\u4efb\u52a1<br/>", phyWh.getCode(), phyWh.getName()));
            }
            throw new WarehouseException("WH0001", buff.toString());
        }
    }

    private boolean createWhInventory(WhInventoryVO inventory) {
        this.whInventoryMapper.insert(inventory);
        ArrayList<WhInventorySkuCategory> skuCategoryList = new ArrayList<WhInventorySkuCategory>();
        for (Long skuCategoryId : inventory.getSkuCategoryIdList()) {
            WhInventorySkuCategory skuCategory = new WhInventorySkuCategory();
            skuCategory.setInventoryId(inventory.getId());
            skuCategory.setSkuCategoryId(skuCategoryId);
            skuCategoryList.add(skuCategory);
        }
        this.whInventorySkuCategoryMapper.batchInsert(skuCategoryList);
        this.saveInventoryConfig(inventory);
        return true;
    }

    private void saveInventoryConfig(WhInventoryVO inventory) {
        WhInventoryConfig config;
        ArrayList<WhInventoryConfig> configList = new ArrayList<WhInventoryConfig>();
        if (EmptyUtil.isNotEmpty(inventory.getSkuStatusList())) {
            for (Integer skuStatus : inventory.getSkuStatusList()) {
                config = new WhInventoryConfig();
                config.setInventoryId(inventory.getId());
                config.setAttrValue(skuStatus.toString());
                config.setAttrType(WhInventoryConfigVO.TYPE_SKU_STATUS);
                configList.add(config);
            }
        }
        if (EmptyUtil.isNotEmpty(inventory.getSkuTypeList())) {
            for (Integer skuType : inventory.getSkuTypeList()) {
                config = new WhInventoryConfig();
                config.setInventoryId(inventory.getId());
                config.setAttrValue(skuType.toString());
                config.setAttrType(WhInventoryConfigVO.TYPE_SKU_TYPE);
                configList.add(config);
            }
        }
        if (EmptyUtil.isNotEmpty(configList)) {
            this.whInventoryConfigMapper.batchInsert(configList);
        }
    }

    @Override
    public WhInventoryVO findWhInventory(Long id) {
        return this.whInventoryMapper.findInventoryById(id);
    }

    @Override
    public WhInventoryVO findWhInventory(Long invenoryId, boolean cascade) {
        WhInventoryVO inventory = this.findWhInventory(invenoryId);
        if (NullUtil.isNotNull((Object)inventory) && cascade) {
            inventory.setSkuCategoryIdList(this.findInventorySkuCategoryIdList(invenoryId));
            this.fullInventoryConfig(inventory);
        }
        return inventory;
    }

    private void fullInventoryConfig(WhInventoryVO inventory) {
        List<WhInventoryConfig> configList = this.findInventoryConfig(inventory.getId());
        inventory.setSkuStatusList(this.getInventorySkuStatus(configList));
        inventory.setSkuTypeList(this.getInventorySkuType(configList));
    }

    private List<Integer> getInventorySkuType(List<WhInventoryConfig> configList) {
        ArrayList<Integer> skuTypeList = new ArrayList<Integer>();
        if (EmptyUtil.isNotEmpty(configList)) {
            for (WhInventoryConfig config : configList) {
                if (!WhInventoryConfigVO.TYPE_SKU_TYPE.equals(config.getAttrType())) continue;
                skuTypeList.add(Integer.parseInt(config.getAttrValue()));
            }
        }
        return skuTypeList;
    }

    private List<Integer> getInventorySkuStatus(List<WhInventoryConfig> configList) {
        ArrayList<Integer> skuStatusList = new ArrayList<Integer>();
        if (EmptyUtil.isNotEmpty(configList)) {
            for (WhInventoryConfig config : configList) {
                if (!WhInventoryConfigVO.TYPE_SKU_STATUS.equals(config.getAttrType())) continue;
                skuStatusList.add(Integer.parseInt(config.getAttrValue()));
            }
        }
        return skuStatusList;
    }

    private List<WhInventoryConfig> findInventoryConfig(Long inventoryId) {
        WhInventoryConfigExample example = new WhInventoryConfigExample();
        example.createCriteria().andInventoryIdEqualTo(inventoryId);
        return this.whInventoryConfigMapper.selectByExample(example);
    }

    private List<Long> findInventorySkuCategoryIdList(Long inventoryId) {
        ArrayList<Long> skuCategoryIdList = new ArrayList<Long>();
        WhInventorySkuCategoryExample example = new WhInventorySkuCategoryExample();
        example.createCriteria().andInventoryIdEqualTo(inventoryId);
        List<WhInventorySkuCategory> list = this.whInventorySkuCategoryMapper.selectByExample(example);
        if (EmptyUtil.isNotEmpty(list)) {
            for (WhInventorySkuCategory skuCategory : list) {
                skuCategoryIdList.add(skuCategory.getSkuCategoryId());
            }
        }
        return skuCategoryIdList;
    }

    @Override
    public List<WhInventoryVO> findWhInventoryByCond(WhInventoryCond cond) {
        return this.whInventoryMapper.findInventoryByCond(cond);
    }

    @Override
    public Pagination<WhInventoryVO> findWhInventoryByCondPage(WhInventoryCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        Integer total = this.whInventoryMapper.countInventory(cond);
        page.setRecord(total);
        if (!NumberUtil.isNullOrZero((Number)total)) {
            List<WhInventoryVO> inventoryList = this.findWhInventoryByCond(cond);
            page.setResultList(inventoryList);
        }
        return page;
    }

    @Override
    @Transactional
    public boolean initWhInventory(Long invenotryId) {
        boolean success;
        WhInventoryVO inventory = this.findWhInventory(invenotryId);
        if (NullUtil.isNull((Object)inventory)) {
            throw new WarehouseException("WH0001", "\u521d\u59cb\u5316\u5931\u8d25");
        }
        if (!WhInventoryVO.STATUS_INIT.equals(inventory.getStatus())) {
            throw new WarehouseException("WH0001", String.format("\u76d8\u70b9\u4efb\u52a1\u5f53\u524d\u72b6\u6001[%s]", inventory.getStatusName()));
        }
        List<WhInventoryDetail> detailList = this.buildInitWhInventoryDetail(inventory);
        if (EmptyUtil.isNotEmpty(detailList)) {
            this.whInventoryDetailMapper.batchInsert(detailList);
        }
        if (!(success = this.updateWhInventoryStatus(inventory.getId(), WhInventoryVO.STATUS_INIT, WhInventoryVO.STATUS_PROCESSING))) {
            throw new WarehouseException("WH0001", String.format("\u5f53\u524d\u72b6\u6001[%s],\u521d\u59cb\u5316\u5931\u8d25!", inventory.getStatusName()));
        }
        return true;
    }

    private List<WhInventoryDetail> buildInitWhInventoryDetail(WhInventoryVO inventory) {
        ArrayList<WhInventoryDetail> detailList = new ArrayList<WhInventoryDetail>();
        List<PhyWhStockVO> phyWhStockList = this.findPhyWhSkuStock(inventory.getPhysicalWarehouseCode(), null, null);
        if (EmptyUtil.isNotEmpty(phyWhStockList)) {
            for (PhyWhStockVO phyWhStock : phyWhStockList) {
                WhInventoryDetailVO inventoryDetail = (WhInventoryDetailVO)BeanUtil.buildFrom((Object)phyWhStock, WhInventoryDetailVO.class);
                inventoryDetail.setStatus(WhInventoryDetailVO.STATUS_NONE);
                inventoryDetail.setCreateTime(DateUtil.getNow());
                inventoryDetail.setCreateUserId(1L);
                inventoryDetail.setInventoryId(inventory.getId());
                inventoryDetail.setOriAmount(phyWhStock.getQuantityTotal());
                inventoryDetail.setRealAmount(0);
                inventoryDetail.setDiffAmount(-phyWhStock.getQuantityTotal());
                inventoryDetail.setAuditStatus(WhInventoryDetailVO.AUDIT_STATUS_INIT);
                detailList.add(inventoryDetail);
            }
        }
        return detailList;
    }

    @Override
    @Transactional
    public boolean cancelWhInventory(Long inventoryId) {
        boolean success;
        WhInventoryVO inventory = this.findWhInventory(inventoryId);
        if ((WhInventoryVO.STATUS_INIT.equals(inventory.getStatus()) || WhInventoryVO.STATUS_PROCESSING.equals(inventory.getStatus())) && !(success = this.updateWhInventoryStatus(inventory.getId(), inventory.getStatus(), WhInventoryVO.STATUS_CANCEL))) {
            throw new WarehouseException("WH0001", String.format("\u5f53\u524d\u72b6\u6001[%s],\u65e0\u6cd5\u53d6\u6d88", inventory.getStatusName()));
        }
        return true;
    }

    @Override
    public boolean whInventoryExistDiff(Long inventoryId) {
        List<WhInventoryDetailVO> inventoryDetailList = this.findWhInventoryDetailByInventoryId(inventoryId);
        return this.isExistDiff(inventoryDetailList);
    }

    @Override
    @Transactional
    public boolean submitInventoryForManagerAudit(Long inventoryId) {
        WhInventoryVO inventory = this.findWhInventory(inventoryId, true);
        if (!WhInventoryVO.STATUS_PROCESSING.equals(inventory.getStatus())) {
            throw new WarehouseException("WH0001", String.format("\u5f53\u524d\u4efb\u52a1\u72b6\u6001[%s]", inventory.getStatusName()));
        }
        this.checkPhyWhStockForLossout(inventory);
        boolean success = this.updateWhInventoryStatus(inventoryId, WhInventoryVO.STATUS_PROCESSING, WhInventoryVO.STATUS_WAIT_AUDIT_MANAGER);
        if (!success) {
            throw new WarehouseException("WH0001", "\u64cd\u4f5c\u5931\u8d25\u8bf7\u91cd\u8bd5!");
        }
        ArrayList<Integer> currentAuditStatusList = new ArrayList<Integer>();
        currentAuditStatusList.add(WhInventoryDetailVO.AUDIT_STATUS_INIT);
        currentAuditStatusList.add(WhInventoryDetailVO.AUDIT_STATUS_REJECT);
        this.updateWhInventoryDetailAuditStatus(inventoryId, currentAuditStatusList, WhInventoryDetailVO.AUDIT_STATUS_WAIT_AUDIT_MANAGER);
        return true;
    }

    private void checkPhyWhStockForLossout(WhInventoryVO inventory) {
        List<PhyWhStockVO> phyWhStockList = this.findPhyWhSkuStock(inventory.getPhysicalWarehouseCode(), null, null);
        HashMap<String, Integer> stockMap = new HashMap<String, Integer>();
        if (NullUtil.isNotNull(phyWhStockList)) {
            for (PhyWhStockVO whSkuStock : phyWhStockList) {
                stockMap.put(whSkuStock.getSkuCode() + ":" + whSkuStock.getSkuStatus(), whSkuStock.getQuantityTotal());
            }
        }
        List<WhInventoryDetailVO> inventoryDetailList = this.findWhInventoryDetailByInventoryId(inventory.getId());
        StringBuilder buff = new StringBuilder();
        for (WhInventoryDetailVO inventoryDetail : inventoryDetailList) {
            int diffQuantity = inventoryDetail.getRealAmount() - inventoryDetail.getOriAmount();
            if (diffQuantity >= 0 || !WhInventoryDetailVO.STATUS_DONE.equals(inventoryDetail.getStatus())) continue;
            Integer phyWhSkuStock = (Integer)stockMap.get(inventoryDetail.getSkuCode() + ":" + inventoryDetail.getSkuStatus());
            if (NullUtil.isNull((Object)phyWhSkuStock)) {
                phyWhSkuStock = 0;
            }
            if (-diffQuantity <= phyWhSkuStock) continue;
            buff.append(String.format("[%s][%s]\u5e93\u5b58\u53d1\u751f\u53d8\u5316\uff0c\u5f53\u524d\u5e93\u5b58\u5c0f\u4e8e\u76d8\u4e8f\u6570\u91cf,\u8bf7\u91cd\u65b0\u76d8\u70b9\u8be5\u6761\u8bb0\u5f55", inventoryDetail.getSkuCode(), inventoryDetail.getSkuStatusName()));
        }
        String warningMsg = buff.toString();
        if (EmptyUtil.isNotEmpty((String)warningMsg)) {
            throw new WarehouseException("WH0001", warningMsg);
        }
    }

    private boolean updateWhInventoryStatus(Long inventoryId, Integer currentStatus, Integer nextStatus) {
        WhInventory updateRecord = new WhInventory();
        updateRecord.setStatus(nextStatus);
        WhInventoryExample example = new WhInventoryExample();
        example.createCriteria().andIdEqualTo(inventoryId).andStatusEqualTo(currentStatus);
        return this.whInventoryMapper.updateByExampleSelective(updateRecord, example) == 1;
    }

    private boolean updateWhInventoryDetailAuditStatus(Long inventoryId, List<Integer> currentAuditStatusList, Integer nextAuditStatus) {
        WhInventoryDetail update = new WhInventoryDetail();
        update.setAuditStatus(nextAuditStatus);
        WhInventoryDetailExample example = new WhInventoryDetailExample();
        example.createCriteria().andInventoryIdEqualTo(inventoryId).andAuditStatusIn((List)currentAuditStatusList);
        this.whInventoryDetailMapper.updateByExampleSelective(update, example);
        return true;
    }

    private List<PhyWhStockVO> findPhyWhSkuStock(String physicalWarehouseCode, String skuCode, Integer skuStatus) {
        PhyWhStockCond cond = new PhyWhStockCond();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setGtZero(true);
        cond.setSkuCode(skuCode);
        cond.setSkuStatus(skuStatus);
        ArrayList<Integer> skuStatusList = new ArrayList<Integer>();
        skuStatusList.add(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        skuStatusList.add(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
        skuStatusList.add(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE);
        skuStatusList.add(WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY);
        cond.setSkuStatusList(skuStatusList);
        return this.wmsSkuStockService.findPhyWhSkuTotalQuantityByCond(cond);
    }

    @Override
    public WhInventoryDetailVO findWhInventoryDetail(Long detailId) {
        WhInventoryDetailCond detailCond = new WhInventoryDetailCond();
        detailCond.setId(detailId);
        List<WhInventoryDetailVO> list = this.findWhInventoryDetailByCond(detailCond);
        if (EmptyUtil.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<WhInventoryDetailVO> findWhInventoryDetailByCond(WhInventoryDetailCond detailCond) {
        List<WhInventoryDetailVO> detailList = this.whInventoryDetailMapper.findWhInventoryDetailByCond(detailCond);
        if (EmptyUtil.isNotEmpty(detailList)) {
            detailList.forEach(detail -> detail.setDiffAmount(detail.getRealAmount() - detail.getOriAmount()));
        }
        return detailList;
    }

    List<WhInventoryDetailVO> findWhInventoryDetailByInventoryId(Long inventoryId) {
        WhInventoryDetailCond detailCond = new WhInventoryDetailCond();
        detailCond.setInventoryId(inventoryId);
        return this.findWhInventoryDetailByCond(detailCond);
    }

    @Override
    public Pagination<WhInventoryDetailVO> findWhInventoryDetailByCondPage(WhInventoryDetailCond detailCond) {
        Pagination page = new Pagination(detailCond.getCurrpage(), detailCond.getPagenum());
        Integer total = this.whInventoryDetailMapper.countWhInventoryDetail(detailCond);
        page.setRecord(total);
        if (!NumberUtil.isNullOrZero((Number)total)) {
            List<WhInventoryDetailVO> list = this.findWhInventoryDetailByCond(detailCond);
            page.setResultList(list);
        }
        return page;
    }

    @Override
    public List<WhInventoryReasionDicVO> findAllWhInventoryReasionDic() {
        WhInventoryReasionDicExample example = new WhInventoryReasionDicExample();
        example.createCriteria();
        List<WhInventoryReasionDic> list = this.whInventoryReasionDicMapper.selectByExample(example);
        return BeanUtil.buildListFrom(list, WhInventoryReasionDicVO.class);
    }

    @Override
    @Transactional
    public boolean submitWhInventoryDetail(WhInventoryDetailVO inventoryDetail) {
        this.processingWhInventoryDetailCheck(inventoryDetail.getId());
        WhInventoryDetailVO currentDetail = this.findWhInventoryDetail(inventoryDetail.getId());
        if (NullUtil.isNull((Object)currentDetail)) {
            throw new WarehouseException("WH0001", "\u76d8\u70b9\u8bb0\u5f55\u4e0d\u5b58\u5728!");
        }
        WhInventoryVO inventory = this.findWhInventory(currentDetail.getInventoryId());
        if (!WhInventoryVO.STATUS_PROCESSING.equals(inventory.getStatus())) {
            throw new WarehouseException("WH0001", String.format("\u5f53\u524d\u76d8\u70b9\u4efb\u52a1\u72b6\u6001[%s]", inventory.getStatusName()));
        }
        if (currentDetail.getOriAmount().equals(currentDetail.getRealAmount())) {
            currentDetail.setDiffReasionType(null);
            currentDetail.setMark(null);
        }
        inventoryDetail.setStatus(WhInventoryDetailVO.STATUS_DONE);
        this.whInventoryDetailMapper.submitWhInventory(inventoryDetail);
        return true;
    }

    @Override
    @Transactional
    public boolean reInitInventoryDetail(Long inventoryDetailId) {
        boolean success;
        WhInventoryDetailVO currentDetail = this.findWhInventoryDetail(inventoryDetailId);
        if (NullUtil.isNull((Object)currentDetail)) {
            throw new WarehouseException("WH0001", "\u76d8\u70b9\u8bb0\u5f55\u4e0d\u5b58\u5728!");
        }
        WhInventoryVO inventory = this.findWhInventory(currentDetail.getInventoryId());
        if (!WhInventoryVO.STATUS_PROCESSING.equals(inventory.getStatus())) {
            throw new WarehouseException("WH0001", String.format("\u5f53\u524d\u76d8\u70b9\u4efb\u52a1\u72b6\u6001[%s]", inventory.getStatusName()));
        }
        int oriAmount = this.findPhyWhSkuTotalQuantity(inventory.getPhysicalWarehouseCode(), currentDetail.getSkuCode(), currentDetail.getSkuStatus());
        currentDetail.setOriAmount(oriAmount);
        currentDetail.setRealAmount(0);
        currentDetail.setDiffAmount(0 - currentDetail.getOriAmount());
        currentDetail.setDiffReasionType(null);
        currentDetail.setMark(null);
        currentDetail.setStatus(WhInventoryDetailVO.STATUS_NONE);
        currentDetail.setAuditStatus(WhInventoryDetailVO.AUDIT_STATUS_INIT);
        WhInventoryDetailExample example = new WhInventoryDetailExample();
        example.createCriteria().andIdEqualTo(inventoryDetailId);
        boolean bl = success = this.whInventoryDetailMapper.updateByExample(currentDetail, example) == 1;
        if (!success) {
            throw new WarehouseException("WH0001", "\u64cd\u4f5c\u5931\u8d25,\u8bf7\u91cd\u8bd5\uff01");
        }
        return true;
    }

    @Override
    @Transactional
    public boolean addWhInventoryDetail(WhInventoryDetailVO inventoryDetail) {
        if (EmptyUtil.isEmpty((String)inventoryDetail.getSkuCode()) || NullUtil.isNull((Object)inventoryDetail.getSkuStatus()) || NullUtil.isNull((Object)inventoryDetail.getSkuStatus())) {
            throw new WarehouseException("WH0001", "\u64cd\u4f5c\u5931\u8d25,\u53c2\u6570\u5f02\u5e38!");
        }
        WhInventoryVO inventory = this.findWhInventory(inventoryDetail.getInventoryId());
        if (WhInventoryVO.STATUS_CANCEL.equals(inventory.getStatus())) {
            throw new WarehouseException("WH0001", "\u64cd\u4f5c\u5931\u8d25,\u76d8\u70b9\u4efb\u52a1\u5df2\u53d6\u6d88!");
        }
        WhInventoryDetailCond detailCond = new WhInventoryDetailCond();
        detailCond.setSkuStatus(inventoryDetail.getSkuStatus());
        detailCond.setSkuCode(inventoryDetail.getSkuCode());
        detailCond.setInventoryId(inventoryDetail.getInventoryId());
        List<WhInventoryDetailVO> detailList = this.findWhInventoryDetailByCond(detailCond);
        if (EmptyUtil.isNotEmpty(detailList)) {
            throw new WarehouseException("WH0001", String.format("\u5df2\u7ecf\u5b58\u5728[%s][%s]\u7684\u8bb0\u5f55,\u65e0\u6cd5\u518d\u6b21\u6dfb\u52a0", inventoryDetail.getSkuCode(), inventoryDetail.getSkuStatusName()));
        }
        int oriAmount = this.findPhyWhSkuTotalQuantity(inventory.getPhysicalWarehouseCode(), inventoryDetail.getSkuCode(), inventoryDetail.getSkuStatus());
        inventoryDetail.setOriAmount(oriAmount);
        inventoryDetail.setRealAmount(0);
        inventoryDetail.setDiffAmount(0 - inventoryDetail.getOriAmount());
        inventoryDetail.setStatus(WhInventoryDetailVO.STATUS_NONE);
        inventoryDetail.setAuditStatus(WhInventoryDetailVO.AUDIT_STATUS_INIT);
        inventoryDetail.setCreateTime(DateUtil.getNow());
        this.whInventoryDetailMapper.insert(inventoryDetail);
        return true;
    }

    private int findPhyWhSkuTotalQuantity(String physicalWarehouseCode, String skuCode, Integer skuStatus) {
        List<PhyWhStockVO> phyWhStockList = this.findPhyWhSkuStock(physicalWarehouseCode, skuCode, skuStatus);
        if (EmptyUtil.isNotEmpty(phyWhStockList)) {
            return phyWhStockList.get(0).getQuantityTotal();
        }
        return 0;
    }

    @Override
    @Transactional
    public boolean inventoryDetailManagerAudit(WhInventoryDetailAuditVO auditInfo) {
        WhInventoryDetailVO detail = this.findWhInventoryDetail(auditInfo.getInventoryDetailId());
        if (!WhInventoryVO.STATUS_WAIT_AUDIT_MANAGER.equals(detail.getInventoryStatus())) {
            throw new WarehouseException("WH0001", String.format("\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u76d8\u70b9\u4efb\u52a1\u72b6\u6001[%s]", WhInventoryVO.getStatusName(detail.getInventoryStatus())));
        }
        if (!WhInventoryDetailVO.AUDIT_STATUS_WAIT_AUDIT_MANAGER.equals(detail.getAuditStatus()) && !WhInventoryDetailVO.AUDIT_STATUS_WAIT_AUDIT_FINANCE.equals(detail.getAuditStatus())) {
            throw new WarehouseException("WH0001", String.format("\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u76d8\u70b9\u8bb0\u5f55\u72b6\u6001[%s]", detail.getAuditStatusName()));
        }
        Integer nextAuditStatus = auditInfo.isAuditPass() ? WhInventoryDetailVO.AUDIT_STATUS_WAIT_AUDIT_FINANCE : WhInventoryDetailVO.AUDIT_STATUS_REJECT;
        boolean success = this.updateInventoryDetailForAudit(auditInfo.getInventoryDetailId(), detail.getAuditStatus(), nextAuditStatus, auditInfo.getHandlingSuggestion());
        if (!success) {
            throw new WarehouseException("WH0001", "\u64cd\u4f5c\u51fa\u9519,\u8bf7\u91cd\u8bd5!");
        }
        return true;
    }

    @Override
    @Transactional
    public boolean inventoryDetailManagerBatchAudit(WhInventoryDetailAuditVO auditInfo) {
        if (EmptyUtil.isEmpty(auditInfo.getInventoryDetailIdList())) {
            throw new WarehouseException("WH0001", "\u64cd\u4f5c\u5931\u8d25\uff0c\u65e0\u9a73\u56de\u884c\u6570\u636e");
        }
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(WhInventoryDetailVO.AUDIT_STATUS_WAIT_AUDIT_FINANCE);
        statusList.add(WhInventoryDetailVO.AUDIT_STATUS_WAIT_AUDIT_MANAGER);
        Integer nextAuditStatus = auditInfo.isAuditPass() ? WhInventoryDetailVO.AUDIT_STATUS_WAIT_AUDIT_FINANCE : WhInventoryDetailVO.AUDIT_STATUS_REJECT;
        WhInventoryDetail update = new WhInventoryDetail();
        update.setAuditStatus(nextAuditStatus);
        if (EmptyUtil.isNotEmpty((String)auditInfo.getHandlingSuggestion())) {
            update.setHandlingSuggestion(auditInfo.getHandlingSuggestion());
        }
        WhInventoryDetailExample example = new WhInventoryDetailExample();
        example.createCriteria().andIdIn((List)auditInfo.getInventoryDetailIdList()).andAuditStatusIn(statusList);
        this.whInventoryDetailMapper.updateByExampleSelective(update, example);
        return true;
    }

    @Override
    @Transactional
    public boolean inventoryFinishForManager(WhInventoryAuditVO auditInfo) {
        WhInventoryVO inventory = this.findWhInventory(auditInfo.getInventoryId());
        if (!WhInventoryVO.STATUS_WAIT_AUDIT_MANAGER.equals(inventory.getStatus())) {
            throw new WarehouseException("WH0001", String.format("\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u76d8\u70b9\u4efb\u52a1\u72b6\u6001[%s]", inventory.getStatusName()));
        }
        this.updateWhInventoryDetailAuditStatus(inventory.getId(), Collections.singletonList(WhInventoryDetailVO.AUDIT_STATUS_WAIT_AUDIT_MANAGER), WhInventoryDetailVO.AUDIT_STATUS_WAIT_AUDIT_FINANCE);
        List<WhInventoryDetailVO> inventoryDetailList = this.findWhInventoryDetailByInventoryId(inventory.getId());
        if (this.isExistReject(inventoryDetailList)) {
            auditInfo.setAlertMsg("\u7531\u4e8e\u5b58\u5728\u9a73\u56de\u7684\u8bb0\u5f55\uff0c\u8be5\u76d8\u70b9\u9700\u8981\u91cd\u65b0\u786e\u8ba4!");
            auditInfo.setPass(false);
            boolean success = this.updateWhInventoryStatus(inventory.getId(), WhInventoryVO.STATUS_WAIT_AUDIT_MANAGER, WhInventoryVO.STATUS_PROCESSING);
            if (!success) {
                throw new WarehouseException("WH0001", "\u64cd\u4f5c\u51fa\u9519,\u8bf7\u91cd\u8bd5!");
            }
            return true;
        }
        boolean existDiff = this.isExistDiff(inventoryDetailList);
        boolean existNotDone = this.isExistNotDone(inventoryDetailList);
        auditInfo.setAlertMsg("\u5ba1\u6279\u6210\u529f\uff0c\u5df2\u8fdb\u5165\u8d22\u52a1\u5ba1\u6279\u9636\u6bb5!");
        this.updateWhInventoryAuditManager(auditInfo);
        boolean success = this.updateWhInventoryStatus(inventory.getId(), WhInventoryVO.STATUS_WAIT_AUDIT_MANAGER, WhInventoryVO.STATUS_WAIT_AUDIT_FINANCE);
        if (!success) {
            throw new WarehouseException("WH0001", "\u64cd\u4f5c\u51fa\u9519,\u8bf7\u91cd\u8bd5!");
        }
        if (!existDiff && !existNotDone) {
            return this.inventoryFinishForFinance(auditInfo);
        }
        return true;
    }

    private boolean updateWhInventoryAuditManager(WhInventoryAuditVO auditInfo) {
        WhInventory updateRecord = new WhInventory();
        updateRecord.setManageAuditId(auditInfo.getAuditOperaterId());
        updateRecord.setManageAuditTime(DateUtil.getNow());
        WhInventoryExample example = new WhInventoryExample();
        example.createCriteria().andIdEqualTo(auditInfo.getInventoryId());
        this.whInventoryMapper.updateByExampleSelective(updateRecord, example);
        return true;
    }

    @Override
    @Transactional
    public boolean inventoryDetailFinanceAudit(WhInventoryDetailAuditVO auditInfo) {
        WhInventoryDetailVO detail = this.findWhInventoryDetail(auditInfo.getInventoryDetailId());
        if (!WhInventoryVO.STATUS_WAIT_AUDIT_FINANCE.equals(detail.getInventoryStatus())) {
            throw new WarehouseException("WH0001", String.format("\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u76d8\u70b9\u4efb\u52a1\u72b6\u6001[%s]", WhInventoryVO.getStatusName(detail.getInventoryStatus())));
        }
        if (!WhInventoryDetailVO.AUDIT_STATUS_WAIT_AUDIT_FINANCE.equals(detail.getAuditStatus()) && !WhInventoryDetailVO.AUDIT_STATUS_FINISH.equals(detail.getAuditStatus())) {
            throw new WarehouseException("WH0001", String.format("\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u76d8\u70b9\u8bb0\u5f55\u5ba1\u6838\u72b6\u6001[%s]", detail.getAuditStatusName()));
        }
        Integer nextAuditStatus = auditInfo.isAuditPass() ? WhInventoryDetailVO.AUDIT_STATUS_FINISH : WhInventoryDetailVO.AUDIT_STATUS_REJECT;
        boolean success = this.updateInventoryDetailForFinanceAudit(auditInfo.getInventoryDetailId(), detail.getAuditStatus(), nextAuditStatus, auditInfo.getHandlingSuggestion());
        if (!success) {
            throw new WarehouseException("WH0001", "\u64cd\u4f5c\u51fa\u9519,\u8bf7\u91cd\u8bd5!");
        }
        return true;
    }

    @Override
    @Transactional
    public boolean inventoryDetailFinanceBatchAudit(WhInventoryDetailAuditVO auditInfo) {
        if (EmptyUtil.isEmpty(auditInfo.getInventoryDetailIdList())) {
            throw new WarehouseException("WH0001", "\u64cd\u4f5c\u5931\u8d25\uff0c\u65e0\u9a73\u56de\u884c\u6570\u636e");
        }
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(WhInventoryDetailVO.AUDIT_STATUS_WAIT_AUDIT_FINANCE);
        statusList.add(WhInventoryDetailVO.AUDIT_STATUS_FINISH);
        Integer nextAuditStatus = auditInfo.isAuditPass() ? WhInventoryDetailVO.AUDIT_STATUS_FINISH : WhInventoryDetailVO.AUDIT_STATUS_REJECT;
        WhInventoryDetail update = new WhInventoryDetail();
        update.setAuditStatus(nextAuditStatus);
        if (EmptyUtil.isNotEmpty((String)auditInfo.getHandlingSuggestion())) {
            update.setFinanceHandlingSuggestion(auditInfo.getHandlingSuggestion());
        }
        WhInventoryDetailExample example = new WhInventoryDetailExample();
        example.createCriteria().andIdIn((List)auditInfo.getInventoryDetailIdList()).andAuditStatusIn(statusList);
        this.whInventoryDetailMapper.updateByExampleSelective(update, example);
        return true;
    }

    @Override
    @Transactional
    public boolean inventoryFinishForFinance(WhInventoryAuditVO auditInfo) {
        WhInventoryVO inventory = this.findWhInventory(auditInfo.getInventoryId());
        if (!WhInventoryVO.STATUS_WAIT_AUDIT_FINANCE.equals(inventory.getStatus())) {
            throw new WarehouseException("WH0001", String.format("\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u76d8\u70b9\u4efb\u52a1\u72b6\u6001[%s]", inventory.getStatusName()));
        }
        this.updateWhInventoryDetailAuditStatus(inventory.getId(), Collections.singletonList(WhInventoryDetailVO.AUDIT_STATUS_WAIT_AUDIT_FINANCE), WhInventoryDetailVO.AUDIT_STATUS_FINISH);
        List<WhInventoryDetailVO> inventoryDetailList = this.findWhInventoryDetailByInventoryId(inventory.getId());
        if (this.isExistReject(inventoryDetailList)) {
            auditInfo.setAlertMsg("\u7531\u4e8e\u5b58\u5728\u9a73\u56de\u7684\u8bb0\u5f55\uff0c\u8be5\u76d8\u70b9\u9700\u8981\u91cd\u65b0\u786e\u8ba4!");
            auditInfo.setPass(false);
            boolean success = this.updateWhInventoryStatus(inventory.getId(), WhInventoryVO.STATUS_WAIT_AUDIT_FINANCE, WhInventoryVO.STATUS_PROCESSING);
            if (!success) {
                throw new WarehouseException("WH0001", "\u64cd\u4f5c\u51fa\u9519,\u8bf7\u91cd\u8bd5!");
            }
            return true;
        }
        auditInfo.setAlertMsg("\u5ba1\u6279\u6210\u529f\uff0c\u8be5\u76d8\u70b9\u4efb\u52a1\u5df2\u5b8c\u6210!");
        this.updateWhInventoryAuditFinance(auditInfo);
        boolean success = this.updateWhInventoryStatus(inventory.getId(), WhInventoryVO.STATUS_WAIT_AUDIT_FINANCE, WhInventoryVO.STATUS_FINISH);
        if (!success) {
            throw new WarehouseException("WH0001", "\u64cd\u4f5c\u51fa\u9519,\u8bf7\u91cd\u8bd5!");
        }
        inventory.setInventoryDetailList(inventoryDetailList);
        inventory.setAuditOperaterId(auditInfo.getAuditOperaterId());
        this.processInventorySkuStock(inventory);
        return true;
    }

    private boolean updateWhInventoryAuditFinance(WhInventoryAuditVO auditInfo) {
        WhInventory updateRecord = new WhInventory();
        updateRecord.setFinanceAuditId(auditInfo.getAuditOperaterId());
        updateRecord.setFinanceAuditTime(DateUtil.getNow());
        WhInventoryExample example = new WhInventoryExample();
        example.createCriteria().andIdEqualTo(auditInfo.getInventoryId());
        this.whInventoryMapper.updateByExampleSelective(updateRecord, example);
        return true;
    }

    private void processInventorySkuStock(WhInventoryVO inventory) {
        List<WhInventoryDetailVO> inventoryDetailList = inventory.getInventoryDetailList();
        if (EmptyUtil.isEmpty(inventoryDetailList)) {
            return;
        }
        this.processWhWmsSkuStock(inventory);
        this.processWhSkuStock(inventory);
    }

    private void processWhWmsSkuStock(WhInventoryVO inventory) {
        List<WhInventoryDetailVO> inventoryDetailList = inventory.getInventoryDetailList();
        if (EmptyUtil.isEmpty(inventoryDetailList)) {
            return;
        }
        for (WhInventoryDetailVO inventoryDetail : inventoryDetailList) {
            if (!WhInventoryDetailVO.STATUS_DONE.equals(inventoryDetail.getStatus()) || inventoryDetail.getOriAmount().equals(inventoryDetail.getRealAmount())) continue;
            int diffQuantity = inventoryDetail.getRealAmount() - inventoryDetail.getOriAmount();
            this.wmsSkuStockService.updatePhyWhSkuStock(inventory.getPhysicalWarehouseCode(), inventoryDetail.getSkuCode(), inventoryDetail.getSkuStatus(), inventoryDetail.getRealAmount() - inventoryDetail.getOriAmount(), diffQuantity > 0 ? WhCommand.TYPE_INVENTROY_PROFIT_IN : WhCommand.TYPE_INVENTROY_LOSS_OUT, inventory.getId().toString(), inventory.getAuditOperaterId(), inventoryDetail.getMark());
        }
    }

    private void processWhSkuStock(WhInventoryVO inventory) {
        List<WhInventoryDetailVO> inventoryDetailList = inventory.getInventoryDetailList();
        if (EmptyUtil.isEmpty(inventoryDetailList)) {
            return;
        }
        Map<Integer, List<WhWarehouse>> whMap = this.whInfoService.findGroupWarehouseSortedMap(inventory.getPhysicalWarehouseCode(), null);
        ArrayList<WhInvRcd> invRcdList = new ArrayList<WhInvRcd>();
        List<WhInvRcd> profitInInvRcdList = this.buildProfitInSkuStock(inventory, whMap);
        List<WhInvRcd> lossOutInvRcdList = this.buildLossOutSkuStock(inventory, whMap);
        invRcdList.addAll(profitInInvRcdList);
        invRcdList.addAll(lossOutInvRcdList);
        List<WhTakeStock> takeStockList = this.buildWhTakeStock(invRcdList, inventory);
        try {
            this.whTakeStockService.batchCreateTakeStock(takeStockList);
        }
        catch (Exception e) {
            throw new WarehouseException("WH0001", "\u540c\u6b65SCM\u5e93\u5b58\u5f02\u5e38:" + e.getMessage());
        }
    }

    private List<WhTakeStock> buildWhTakeStock(List<WhInvRcd> invRcdList, WhInventoryVO inventory) {
        HashMap<String, ArrayList<WhInvRcd>> whGroup = new HashMap<String, ArrayList<WhInvRcd>>();
        for (WhInvRcd invRcd : invRcdList) {
            ArrayList<WhInvRcd> list = (ArrayList<WhInvRcd>)whGroup.get(invRcd.getWarehouseCode());
            if (NullUtil.isNull((Object)list)) {
                list = new ArrayList<WhInvRcd>();
                whGroup.put(invRcd.getWarehouseCode(), list);
            }
            list.add(invRcd);
        }
        ArrayList<WhTakeStock> takeStockList = new ArrayList<WhTakeStock>();
        for (Map.Entry entry : whGroup.entrySet()) {
            WhTakeStock whTakeStock = new WhTakeStock();
            whTakeStock.setUpdatePhyWhStock(false);
            whTakeStock.setWarehouseCode((String)entry.getKey());
            whTakeStock.setType(WhTakeStock.TYPE_STORE);
            whTakeStock.setReferenceId(inventory.getId());
            whTakeStock.setReferenceMemo(inventory.getName());
            whTakeStock.setSyncThirdpartStock(false);
            whTakeStock.setCreateUserId(inventory.getFinanceAuditId());
            ArrayList<WhTakeStockRcd> takeStockRcdList = new ArrayList<WhTakeStockRcd>();
            for (WhInvRcd invRcd : (List)entry.getValue()) {
                WhTakeStockRcd takeStockRcd = (WhTakeStockRcd)BeanUtil.buildFrom((Object)invRcd, WhTakeStockRcd.class);
                takeStockRcd.setResultType(invRcd.getQuantity() > 0 ? WhTakeStockRcd.TYPE_PROFIT : WhTakeStockRcd.TYPE_LOSS);
                takeStockRcd.setReferenceDetailId(invRcd.getTakeStockRcdId().longValue());
                takeStockRcdList.add(takeStockRcd);
            }
            whTakeStock.setWhTakeStockRcdList(takeStockRcdList);
            takeStockList.add(whTakeStock);
        }
        return takeStockList;
    }

    private List<WhInvRcd> buildLossOutSkuStock(WhInventoryVO inventory, Map<Integer, List<WhWarehouse>> whMap) {
        ArrayList<WhInvRcd> rcdList = new ArrayList<WhInvRcd>();
        List<WhInventoryDetailVO> inventoryDetailList = inventory.getInventoryDetailList();
        if (EmptyUtil.isEmpty(inventoryDetailList)) {
            return rcdList;
        }
        Map<String, Map<String, WhInvVO>> whSkuStockMap = this.getLossOutCanUseWhSkuStockMap(inventory, whMap);
        StringBuilder buff = new StringBuilder();
        for (WhInventoryDetailVO inventoryDetail : inventoryDetailList) {
            WhInvRcdVO invRcd;
            int canUse;
            WhInvVO whSkuInv;
            if (!WhInventoryDetailVO.STATUS_DONE.equals(inventoryDetail.getStatus()) || inventoryDetail.getOriAmount().equals(inventoryDetail.getRealAmount())) continue;
            List<WhWarehouse> whListSorted = whMap.get(inventoryDetail.getSkuStatus());
            if (EmptyUtil.isEmpty(whListSorted)) {
                throw new WarehouseException("WH0001", String.format("[%s]\u4e0d\u5b58\u5728[%s]\u903b\u8f91\u4ed3!", inventory.getPhysicalWarehouseCode(), WhWarehouseVO.getSkuStatusName(inventoryDetail.getSkuStatus())));
            }
            int diffQuantity = inventoryDetail.getRealAmount() - inventoryDetail.getOriAmount();
            if (diffQuantity >= 0) continue;
            int needQuantity = -diffQuantity;
            for (WhWarehouse wh : whListSorted) {
                whSkuInv = this.findWhSkuInv(inventoryDetail.getSkuCode(), wh.getCode(), whSkuStockMap);
                if (NullUtil.isNotNull((Object)whSkuInv) && whSkuInv.getCanUseInv() > 0) {
                    canUse = Math.min(needQuantity, whSkuInv.getCanUseInv());
                    needQuantity -= canUse;
                    whSkuInv.setQuantityInRcd(whSkuInv.getQuantityInRcd() - canUse);
                    invRcd = this.buildWhInvRcd(inventoryDetail, wh, -canUse, inventory.getAuditOperaterId());
                    rcdList.add(invRcd);
                }
                if (needQuantity != 0) continue;
                break;
            }
            if (needQuantity != 0) {
                for (WhWarehouse wh : whListSorted) {
                    whSkuInv = this.findWhSkuInv(inventoryDetail.getSkuCode(), wh.getCode(), whSkuStockMap);
                    if (NullUtil.isNotNull((Object)whSkuInv) && whSkuInv.getQuantityInRcd() > 0) {
                        canUse = Math.min(needQuantity, whSkuInv.getQuantityInRcd());
                        needQuantity -= canUse;
                        whSkuInv.setQuantityInRcd(whSkuInv.getQuantityInRcd() - canUse);
                        invRcd = this.buildWhInvRcd(inventoryDetail, wh, -canUse, inventory.getAuditOperaterId());
                        rcdList.add(invRcd);
                    }
                    if (needQuantity != 0) continue;
                    break;
                }
            }
            if (needQuantity == 0) continue;
            buff.append(String.format("[%s]\u5e93\u5b58\u4e0d\u8db3<br/>", inventoryDetail.getSkuCode()));
        }
        String msg = buff.toString();
        if (EmptyUtil.isNotEmpty((String)msg)) {
            throw new WarehouseException("WH0001", msg);
        }
        return rcdList;
    }

    private List<WhInvRcd> buildProfitInSkuStock(WhInventoryVO inventory, Map<Integer, List<WhWarehouse>> whMap) {
        ArrayList<WhInvRcd> rcdList = new ArrayList<WhInvRcd>();
        List<WhInventoryDetailVO> inventoryDetailList = inventory.getInventoryDetailList();
        if (EmptyUtil.isEmpty(inventoryDetailList)) {
            return rcdList;
        }
        for (WhInventoryDetailVO inventoryDetail : inventoryDetailList) {
            if (!WhInventoryDetailVO.STATUS_DONE.equals(inventoryDetail.getStatus()) || inventoryDetail.getOriAmount().equals(inventoryDetail.getRealAmount())) continue;
            List<WhWarehouse> whListSorted = whMap.get(inventoryDetail.getSkuStatus());
            if (EmptyUtil.isEmpty(whListSorted)) {
                throw new WarehouseException("WH0001", String.format("[%s]\u4e0d\u5b58\u5728[%s]\u903b\u8f91\u4ed3!", inventory.getPhysicalWarehouseCode(), WhWarehouseVO.getSkuStatusName(inventoryDetail.getSkuStatus())));
            }
            int diffQuantity = inventoryDetail.getRealAmount() - inventoryDetail.getOriAmount();
            if (diffQuantity <= 0) continue;
            WhInvRcdVO invRcd = this.buildWhInvRcd(inventoryDetail, whListSorted.get(0), diffQuantity, inventory.getAuditOperaterId());
            rcdList.add(invRcd);
        }
        return rcdList;
    }

    private Map<String, Map<String, WhInvVO>> getLossOutCanUseWhSkuStockMap(WhInventoryVO inventory, Map<Integer, List<WhWarehouse>> whMap) {
        List<String> lossOutSkuCodes = this.buildLossOutSkuCodes(inventory.getInventoryDetailList());
        List<String> lossOutWhCodes = this.buildLossOutWhCodes(inventory.getInventoryDetailList(), whMap);
        return this.whInvService.findSkuStocks(lossOutSkuCodes, lossOutWhCodes);
    }

    private int getWhSkuQuantity(String skuCode, String warehouseCode, Map<String, Map<String, WhInvVO>> whSkuStockMap) {
        WhInvVO skuInv;
        Map<String, WhInvVO> skuStockMap = whSkuStockMap.get(warehouseCode);
        if (NullUtil.isNotNull(skuStockMap) && NullUtil.isNotNull((Object)(skuInv = skuStockMap.get(skuCode)))) {
            return skuInv.getCanUseInv();
        }
        return 0;
    }

    private WhInvVO findWhSkuInv(String skuCode, String warehouseCode, Map<String, Map<String, WhInvVO>> whSkuStockMap) {
        Map<String, WhInvVO> skuStockMap = whSkuStockMap.get(warehouseCode);
        if (NullUtil.isNotNull(skuStockMap)) {
            WhInvVO skuInv = skuStockMap.get(skuCode);
            return skuInv;
        }
        return null;
    }

    private WhInvRcdVO buildWhInvRcd(WhInventoryDetailVO inventoryDetail, WhWarehouse warehouse, Integer quantity, Long operaterId) {
        WhInvRcdVO invRcd = new WhInvRcdVO();
        invRcd.setWarehouseCode(warehouse.getCode());
        invRcd.setSkuCode(inventoryDetail.getSkuCode());
        invRcd.setQuantity(quantity);
        invRcd.setCommandCode(inventoryDetail.getInventoryId().toString());
        invRcd.setMemo(inventoryDetail.getMark());
        invRcd.setSubmitUserId(operaterId);
        invRcd.setTakeStockRcdId(inventoryDetail.getId().intValue());
        invRcd.setInOutType(quantity > 0 ? WhCommand.TYPE_INVENTROY_PROFIT_IN : WhCommand.TYPE_INVENTROY_LOSS_OUT);
        return invRcd;
    }

    private List<String> buildLossOutSkuCodes(List<WhInventoryDetailVO> inventoryDetailList) {
        HashSet<String> skuCodes = new HashSet<String>();
        for (WhInventoryDetailVO inventoryDetail : inventoryDetailList) {
            int diffQuantity;
            if (!WhInventoryDetailVO.STATUS_DONE.equals(inventoryDetail.getStatus()) || inventoryDetail.getOriAmount().equals(inventoryDetail.getRealAmount()) || (diffQuantity = inventoryDetail.getRealAmount() - inventoryDetail.getOriAmount()) >= 0) continue;
            skuCodes.add(inventoryDetail.getSkuCode());
        }
        return Arrays.asList(skuCodes.toArray(new String[skuCodes.size()]));
    }

    private List<String> buildLossOutWhCodes(List<WhInventoryDetailVO> inventoryDetailList, Map<Integer, List<WhWarehouse>> whMap) {
        HashSet<String> codes = new HashSet<String>();
        for (WhInventoryDetailVO inventoryDetail : inventoryDetailList) {
            List<WhWarehouse> whList;
            int diffQuantity;
            if (!WhInventoryDetailVO.STATUS_DONE.equals(inventoryDetail.getStatus()) || inventoryDetail.getOriAmount().equals(inventoryDetail.getRealAmount()) || (diffQuantity = inventoryDetail.getRealAmount() - inventoryDetail.getOriAmount()) >= 0 || !EmptyUtil.isNotEmpty(whList = whMap.get(inventoryDetail.getSkuStatus()))) continue;
            for (WhWarehouse wh : whList) {
                codes.add(wh.getCode());
            }
        }
        return Arrays.asList(codes.toArray(new String[codes.size()]));
    }

    private boolean updateInventoryDetailForAudit(Long inventoryDetailId, Integer currentAuditStatus, Integer nextAuditStatus, String handlingSuggestion) {
        WhInventoryDetail update = new WhInventoryDetail();
        update.setAuditStatus(nextAuditStatus);
        if (EmptyUtil.isNotEmpty((String)handlingSuggestion)) {
            update.setHandlingSuggestion(handlingSuggestion);
        }
        WhInventoryDetailExample example = new WhInventoryDetailExample();
        example.createCriteria().andIdEqualTo(inventoryDetailId).andAuditStatusEqualTo(currentAuditStatus);
        return this.whInventoryDetailMapper.updateByExampleSelective(update, example) == 1;
    }

    private boolean updateInventoryDetailForFinanceAudit(Long inventoryDetailId, Integer currentAuditStatus, Integer nextAuditStatus, String handlingSuggestion) {
        WhInventoryDetail update = new WhInventoryDetail();
        update.setAuditStatus(nextAuditStatus);
        if (EmptyUtil.isNotEmpty((String)handlingSuggestion)) {
            update.setFinanceHandlingSuggestion(handlingSuggestion);
        }
        WhInventoryDetailExample example = new WhInventoryDetailExample();
        example.createCriteria().andIdEqualTo(inventoryDetailId).andAuditStatusEqualTo(currentAuditStatus);
        return this.whInventoryDetailMapper.updateByExampleSelective(update, example) == 1;
    }

    private boolean isExistReject(List<WhInventoryDetailVO> inventoryDetailList) {
        if (EmptyUtil.isNotEmpty(inventoryDetailList)) {
            for (WhInventoryDetailVO detail : inventoryDetailList) {
                if (!WhInventoryDetailVO.AUDIT_STATUS_REJECT.equals(detail.getAuditStatus())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isExistDiff(List<WhInventoryDetailVO> inventoryDetailList) {
        if (EmptyUtil.isNotEmpty(inventoryDetailList)) {
            for (WhInventoryDetailVO detail : inventoryDetailList) {
                if (detail.getOriAmount().equals(detail.getRealAmount())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isExistNotDone(List<WhInventoryDetailVO> inventoryDetailList) {
        if (EmptyUtil.isNotEmpty(inventoryDetailList)) {
            for (WhInventoryDetailVO detail : inventoryDetailList) {
                if (!WhInventoryDetailVO.STATUS_NONE.equals(detail.getStatus())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public WhInventoryCountInfoVO countProcessingWhInventory(String physicalWarehouseCode) {
        WhInventoryCountInfoVO countInfo = new WhInventoryCountInfoVO();
        countInfo.setPhysicalWarehouseCode(physicalWarehouseCode);
        List<WhCountVO> countList = this.whInventoryDetailMapper.countProcessingInventoryDetail(physicalWarehouseCode);
        HashMap<Integer, Integer> countMap = new HashMap<Integer, Integer>();
        if (EmptyUtil.isNotEmpty(countList)) {
            for (WhCountVO count : countList) {
                countMap.put(Integer.valueOf(count.getCode()), count.getAmount());
            }
        }
        ArrayList<Integer> skuStatusList = new ArrayList<Integer>();
        skuStatusList.add(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        skuStatusList.add(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
        skuStatusList.add(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE);
        skuStatusList.add(6);
        ArrayList<WhCountVO> resultCountList = new ArrayList<WhCountVO>();
        for (Integer skuStatus : skuStatusList) {
            WhCountVO count = new WhCountVO();
            count.setCode(skuStatus.toString());
            count.setName(WhWarehouseVO.getSkuStatusName(skuStatus));
            count.setAmount(0);
            Integer amount = (Integer)countMap.get(skuStatus);
            if (NullUtil.isNotNull((Object)amount)) {
                count.setAmount(amount);
            }
            resultCountList.add(count);
        }
        countInfo.setCountList(resultCountList);
        return countInfo;
    }

    @Override
    public boolean processingWhInventoryDetailInSingle(WhInventoryDetailVO inventoryDetail) {
        this.processingWhInventoryDetailCheck(inventoryDetail.getId());
        if (NullUtil.isNull((Object)inventoryDetail.getRealAmount())) {
            throw new WarehouseException("WH0001", "\u5e94\u6709\u6570\u91cf\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (inventoryDetail.getRealAmount() < 0) {
            throw new WarehouseException("WH0001", "\u5e94\u6709\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\uff01");
        }
        this.whInventoryDetailMapper.processingWhInventoryDetailInSingle(inventoryDetail);
        return true;
    }

    @Override
    public boolean processingWhInventoryDetailInContinue(WhInventoryDetailVO inventoryDetail) {
        this.processingWhInventoryDetailCheck(inventoryDetail.getId());
        this.whInventoryDetailMapper.processingWhInventoryDetailInContinue(inventoryDetail);
        return true;
    }

    private void processingWhInventoryDetailCheck(Long inventoryDetailId) {
        WhInventoryDetailVO detail = this.findWhInventoryDetail(inventoryDetailId);
        if (NullUtil.isNull((Object)detail)) {
            throw new WarehouseException("WH0001", "\u8be5\u76d8\u70b9\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        if (!WhInventoryVO.STATUS_PROCESSING.equals(detail.getInventoryStatus())) {
            throw new WarehouseException("WH0001", String.format("\u5f53\u524d\u76d8\u70b9\u4efb\u52a1\u72b6\u6001[%s]", WhInventoryVO.getStatusName(detail.getInventoryStatus())));
        }
        if (WhInventoryDetailVO.AUDIT_STATUS_WAIT_AUDIT_FINANCE.equals(detail.getAuditStatus()) || WhInventoryDetailVO.AUDIT_STATUS_FINISH.equals(detail.getAuditStatus())) {
            throw new WarehouseException("WH0300", "\u8be5\u4efb\u52a1\u5df2\u63d0\u4ea4,\u5982\u9700\u91cd\u65b0\u76d8\u70b9,\u8bf7\u70b9\u51fb\u91cd\u76d8!");
        }
        if (!WhInventoryDetailVO.AUDIT_STATUS_INIT.equals(detail.getAuditStatus()) && !WhInventoryDetailVO.AUDIT_STATUS_REJECT.equals(detail.getAuditStatus())) {
            throw new WarehouseException("WH0001", String.format("\u8be5\u4efb\u52a1\u5f53\u524d\u72b6\u6001[%s]\uff01", detail.getAuditStatusName()));
        }
    }

    @Override
    public List<WhInventoryEmailVO> findAllWhInventoryEmail() {
        WhInventoryEmailExample example = new WhInventoryEmailExample();
        example.createCriteria();
        List<WhInventoryEmail> list = this.whInventoryEmailMapper.selectByExample(example);
        return BeanUtil.buildListFrom(list, WhInventoryEmailVO.class);
    }

    @Override
    public List<WhInventoryEmailVO> findWhInventoryEmail(String physicalWarehouseCode) {
        if (EmptyUtil.isEmpty((String)physicalWarehouseCode)) {
            return Collections.emptyList();
        }
        WhInventoryEmailExample example = new WhInventoryEmailExample();
        example.createCriteria().andPhysicalWarehouseCodeEqualTo(physicalWarehouseCode);
        List<WhInventoryEmail> list = this.whInventoryEmailMapper.selectByExample(example);
        return BeanUtil.buildListFrom(list, WhInventoryEmailVO.class);
    }

    @Override
    @Transactional
    public boolean saveWhInventoryEmail(List<WhInventoryEmailVO> emailList) {
        WhInventoryEmailExample example = new WhInventoryEmailExample();
        example.createCriteria();
        this.whInventoryEmailMapper.deleteByExample(example);
        if (EmptyUtil.isNotEmpty(emailList)) {
            this.whInventoryEmailMapper.batchInsert(emailList);
        }
        return true;
    }
}

