/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.commdata.service.ChannelQueryService;
import com.thebeastshop.commdata.vo.ChannelWarehouseVO;
import com.thebeastshop.common.PageCond;
import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuDTO;
import com.thebeastshop.pegasus.service.warehouse.cond.WhInvRcdCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWarehouseCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhCommandMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhInvRcdExtendMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhInvRcdMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWarehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvOccupy;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvRcdExtend;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvRcdExtendExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInvService;
import com.thebeastshop.pegasus.service.warehouse.service.WhJitPackageSkuReferenceService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvQttVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvRcdVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhJitPackageSkuReferenceVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhReleaseOccupationVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhSkuInvQttVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseInvQttVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseSkuInvVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.stock.dto.SStockOccupyDTO;
import com.thebeastshop.stock.dto.SStockRecordConditionDTO;
import com.thebeastshop.stock.dto.SStockReleaseDTO;
import com.thebeastshop.stock.enums.SStockInOutTypeEnum;
import com.thebeastshop.stock.enums.SStockOccupyTypeEnum;
import com.thebeastshop.stock.enums.SStockOperationTypeEnum;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SOccupyResultVO;
import com.thebeastshop.stock.vo.SSkuStockQuantityVO;
import com.thebeastshop.stock.vo.SSkuStockVO;
import com.thebeastshop.stock.vo.SStockOccupyRecordVO;
import com.thebeastshop.stock.vo.SStockRecordVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whInvService")
public class WhInvServiceImpl
implements WhInvService {
    private final Logger log = LoggerFactory.getLogger(WhInvServiceImpl.class);
    @Autowired
    private WhCommandMapper whCommandMapper;
    @Autowired
    private WhWarehouseMapper whWarehouseMapper;
    @Autowired
    private WhInvRcdExtendMapper whInvRcdExtendMapper;
    @Autowired
    private WhJitPackageSkuReferenceService whJitPackageSkuReferenceService;
    @Autowired
    private SStockService sStockService;
    @Autowired
    private McOpChannelService mcOpChannelService;
    @Autowired
    private McPcsSkuService mcPcsSkuService;
    @Autowired
    private WhInvRcdMapper whInvRcdMapper;
    @Autowired
    private ChannelQueryService channelQueryService;
    @Autowired
    private WhInfoService whInfoService;
    private static final int PAGE_NUM = 500;

    @Override
    @Transactional
    public Boolean record(WhInvRcd whInvRcd) {
        SStockRecordVO sStockRecordVO = new SStockRecordVO();
        BeanUtils.copyProperties((Object)whInvRcd, (Object)sStockRecordVO);
        if (NullUtil.isNotNull((Object)whInvRcd.getTakeStockRcdId())) {
            sStockRecordVO.setTakeStockRcdId(whInvRcd.getTakeStockRcdId());
        }
        if (NullUtil.isNotNull((Object)whInvRcd.getSubmitUserId())) {
            sStockRecordVO.setSubmitUserId(Integer.valueOf(whInvRcd.getSubmitUserId().intValue()));
        }
        ArrayList<SStockRecordVO> rollbackRecordList = new ArrayList<SStockRecordVO>();
        ServiceResp serviceResp = this.sStockService.record(sStockRecordVO);
        if (!serviceResp.isSuccess()) {
            throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
        rollbackRecordList.add((SStockRecordVO)serviceResp.getBean());
        whInvRcd.setRollbackRecordList(rollbackRecordList);
        return serviceResp.isSuccess();
    }

    @Override
    public Boolean batchRecord(List<WhInvRcd> whInvRcdList) {
        ArrayList sStockRecordVOArrayList = Lists.newArrayList();
        for (WhInvRcd whInvRcd : whInvRcdList) {
            SStockRecordVO sStockRecordVO = new SStockRecordVO();
            BeanUtils.copyProperties((Object)whInvRcd, (Object)sStockRecordVO);
            if (NullUtil.isNotNull((Object)whInvRcd.getTakeStockRcdId())) {
                sStockRecordVO.setTakeStockRcdId(whInvRcd.getTakeStockRcdId());
            }
            if (NullUtil.isNotNull((Object)whInvRcd.getSubmitUserId())) {
                sStockRecordVO.setSubmitUserId(Integer.valueOf(whInvRcd.getSubmitUserId().intValue()));
            }
            sStockRecordVOArrayList.add(sStockRecordVO);
        }
        ArrayList rollbackRecordList = new ArrayList();
        ServiceResp serviceResp = this.sStockService.batchRecord((List)sStockRecordVOArrayList);
        if (!serviceResp.isSuccess()) {
            throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
        rollbackRecordList.addAll((Collection)serviceResp.getBean());
        return serviceResp.isSuccess();
    }

    @Override
    @Transactional
    public Long occupy(WhInvOccupy whInvOccupy) {
        ServiceResp resp = this.sStockService.occupy(this.convertWhInvOccupy2DTO(whInvOccupy));
        if (!resp.isSuccess()) {
            throw new WarehouseException(resp.getRespCode(), resp.getRespMsg());
        }
        SOccupyResultVO resultVO = (SOccupyResultVO)resp.getBean();
        return resultVO.getId();
    }

    @Override
    @Transactional
    public boolean batchRecords(List<WhInvRcd> whInvRcdList) {
        if (EmptyUtil.isEmpty(whInvRcdList)) {
            return true;
        }
        ArrayList rollbackRecordList = new ArrayList();
        ArrayList<SStockRecordVO> stockRcdList = new ArrayList<SStockRecordVO>();
        for (WhInvRcd invRcd : whInvRcdList) {
            stockRcdList.add(this.convertWhInv2DTO(invRcd));
        }
        ServiceResp serviceResp = this.sStockService.batchRecord(stockRcdList);
        if (!serviceResp.isSuccess()) {
            throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
        rollbackRecordList.addAll((Collection)serviceResp.getBean());
        return true;
    }

    private SStockRecordVO convertWhInv2DTO(WhInvRcd whInvRcd) {
        SStockRecordVO sStockRecordVO = new SStockRecordVO();
        BeanUtils.copyProperties((Object)whInvRcd, (Object)sStockRecordVO);
        if (NullUtil.isNotNull((Object)whInvRcd.getTakeStockRcdId())) {
            sStockRecordVO.setTakeStockRcdId(whInvRcd.getTakeStockRcdId());
        }
        if (NullUtil.isNotNull((Object)whInvRcd.getSubmitUserId())) {
            sStockRecordVO.setSubmitUserId(Integer.valueOf(whInvRcd.getSubmitUserId().intValue()));
        }
        return sStockRecordVO;
    }

    @Override
    @Transactional
    public List<Long> occupy(List<WhInvOccupy> whInvOccupyList) {
        ArrayList<Long> result = new ArrayList<Long>();
        ServiceResp serviceResp = this.sStockService.occupy(this.convertWhInvOccupy2DTO(whInvOccupyList));
        if (!serviceResp.isSuccess()) {
            throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
        List occupyResultVOs = (List)serviceResp.getBean();
        if (EmptyUtil.isNotEmpty((List)occupyResultVOs)) {
            for (SOccupyResultVO occupyResultVO : occupyResultVOs) {
                result.add(occupyResultVO.getId());
            }
        }
        return result;
    }

    @Override
    public List<Long> occupyAndNoNeedCheckStock(List<WhInvOccupy> whInvOccupyList, boolean noNeedCheckStock) {
        ArrayList<Long> result = new ArrayList<Long>();
        List<SStockOccupyDTO> stockOccupyDTOs = this.convertWhInvOccupy2DTO(whInvOccupyList);
        for (SStockOccupyDTO occupyDTO : stockOccupyDTOs) {
            occupyDTO.setNeedToCheckStock(!noNeedCheckStock);
        }
        ServiceResp serviceResp = this.sStockService.occupy(stockOccupyDTOs);
        if (!serviceResp.isSuccess()) {
            throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
        List occupyResultVOs = (List)serviceResp.getBean();
        if (EmptyUtil.isNotEmpty((List)occupyResultVOs)) {
            for (SOccupyResultVO occupyResultVO : occupyResultVOs) {
                result.add(occupyResultVO.getId());
            }
        }
        return result;
    }

    @Override
    @Transactional
    public List<Long> occupy(List<WhInvOccupy> whInvOccupyList, List<WhJitPackageSkuReferenceVO> whJitPackageSkuReferenceVOList) {
        this.createWhJitPackageSkuReference(whJitPackageSkuReferenceVOList);
        return this.occupy(whInvOccupyList);
    }

    @Override
    @Transactional
    public List<Long> occupy(List<WhInvOccupy> whInvOccupyList, List<WhJitPackageSkuReferenceVO> whJitPackageSkuReferenceVOList, String allotCode) {
        this.whJitPackageSkuReferenceService.finishByReferenceCode(allotCode);
        return this.occupy(whInvOccupyList, whJitPackageSkuReferenceVOList);
    }

    private void createWhJitPackageSkuReference(List<WhJitPackageSkuReferenceVO> whJitPackageSkuReferenceVOList) {
        if (EmptyUtil.isNotEmpty(whJitPackageSkuReferenceVOList)) {
            this.whJitPackageSkuReferenceService.createWhJitPackageSkuReference(whJitPackageSkuReferenceVOList);
        }
    }

    private static List<String> lockSkuCodes() {
        ArrayList<String> skuCodes = new ArrayList<String>();
        skuCodes.add("781161392");
        skuCodes.add("605161182");
        skuCodes.add("692160022");
        return skuCodes;
    }

    @Override
    @Transactional
    public Map<String, List<Long>> interestOccupy(Map<String, List<WhInvOccupy>> params) {
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>();
        Set<String> interestIds = params.keySet();
        if (CollectionUtils.isNotEmpty(interestIds)) {
            for (String interestId : interestIds) {
                List<WhInvOccupy> whInvOccupies = params.get(interestId);
                if (!CollectionUtils.isNotEmpty(whInvOccupies)) continue;
                for (WhInvOccupy whInvOccupy : whInvOccupies) {
                    Integer quantity;
                    String skuCode = whInvOccupy.getSkuCode();
                    Boolean releaseResult = this.releaseInterestOccupy(interestId, skuCode, quantity = whInvOccupy.getQuantity());
                    if (releaseResult.booleanValue()) continue;
                    throw new WarehouseException("\u5e93\u5b58\u4e0d\u8db3");
                }
                List<Long> occupyIds = this.occupy(whInvOccupies);
                result.put(interestId, occupyIds);
            }
        }
        return result;
    }

    @Override
    @Transactional
    public Map<String, List<Long>> campaignOccupy(Map<String, List<WhInvOccupy>> params) {
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>();
        Set<String> campaignCodes = params.keySet();
        if (CollectionUtils.isNotEmpty(campaignCodes)) {
            for (String campaignCode : campaignCodes) {
                List<WhInvOccupy> whInvOccupies = params.get(campaignCode);
                if (!CollectionUtils.isNotEmpty(whInvOccupies)) continue;
                for (WhInvOccupy whInvOccupy : whInvOccupies) {
                    Integer quantity;
                    String skuCode = whInvOccupy.getSkuCode();
                    Boolean releaseResult = this.releaseCampaignOccupy(campaignCode, skuCode, quantity = whInvOccupy.getQuantity());
                    if (releaseResult.booleanValue()) continue;
                    throw new WarehouseException("\u5e93\u5b58\u4e0d\u8db3");
                }
                List<Long> occupyIds = this.occupy(whInvOccupies);
                result.put(campaignCode, occupyIds);
            }
        }
        return result;
    }

    @Override
    @Transactional
    public List<Long> occupyAfterRelease(List<WhInvOccupy> whInvOccupyList, List<WhReleaseOccupationVO> whReleaseOccupationVOList) {
        List<Long> result;
        ServiceResp serviceResp = this.sStockService.release(this.convertWhRelease2DTO(whReleaseOccupationVOList));
        if (!serviceResp.isSuccess()) {
            throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
        try {
            result = this.occupy(whInvOccupyList);
        }
        catch (Exception e) {
            this.log.info("\u8c03\u7528\u91ca\u653e\u5e93\u5b58\u56de\u6eda\u63a5\u53e3");
            this.sStockService.rollbackRelease(serviceResp);
            throw e;
        }
        return result;
    }

    @Override
    @Transactional
    public List<Long> occupyAfterRelease(List<WhInvOccupy> whInvOccupyList, List<WhReleaseOccupationVO> whReleaseOccupationVOList, String referenceCode, List<WhJitPackageSkuReferenceVO> whJitPackageSkuReferenceVOList) {
        this.whJitPackageSkuReferenceService.deleteByReferenceCode(referenceCode);
        this.createWhJitPackageSkuReference(whJitPackageSkuReferenceVOList);
        return this.occupyAfterRelease(whInvOccupyList, whReleaseOccupationVOList);
    }

    @Override
    @Transactional
    public void releaseJitPackageOccupy(String packageCode) {
        SStockReleaseDTO stockReleaseDTO = new SStockReleaseDTO();
        stockReleaseDTO.setPackageCode(packageCode);
        stockReleaseDTO.setOperationType(SStockOperationTypeEnum.JIT);
        ServiceResp serviceResp = this.sStockService.release(stockReleaseDTO);
        if (serviceResp.isFailure()) {
            throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
    }

    @Override
    @Transactional
    public void releaseOccupationById(Long id) {
        ServiceResp serviceResp = this.sStockService.releaseById(id);
        if (!serviceResp.isSuccess()) {
            throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
    }

    @Override
    @Transactional
    public void releaseOccupation(WhReleaseOccupationVO whReleaseOccupationVO) {
        ServiceResp serviceResp = this.sStockService.release(this.convertWhRelease2DTO(whReleaseOccupationVO));
        if (!serviceResp.isSuccess()) {
            throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
    }

    @Override
    @Transactional
    public void releaseOccupation(List<WhReleaseOccupationVO> whReleaseOccupationVOList) {
        ServiceResp serviceResp = this.sStockService.release(this.convertWhRelease2DTO(whReleaseOccupationVOList));
        if (!serviceResp.isSuccess()) {
            throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
    }

    @Override
    @Transactional
    public void releaseOccupation(List<WhReleaseOccupationVO> whReleaseOccupationVOList, List<WhJitPackageSkuReferenceVO> whJitPackageSkuReferenceVOList) {
        if (EmptyUtil.isNotEmpty(whJitPackageSkuReferenceVOList)) {
            HashSet<String> referenceCodes = new HashSet<String>();
            for (WhJitPackageSkuReferenceVO referenceVO : whJitPackageSkuReferenceVOList) {
                referenceCodes.add(referenceVO.getReferenceCode());
            }
            for (String referenceCode : referenceCodes) {
                this.whJitPackageSkuReferenceService.finishByReferenceCode(referenceCode);
            }
        }
        this.releaseOccupation(whReleaseOccupationVOList);
    }

    @Override
    public List<WhInvOccupy> getWhInvOccupy(List<String> referenceCodes) {
        return BeanUtil.buildListFrom((Collection)this.sStockService.getOccupyRecordsByReferenceCodes(referenceCodes), WhInvOccupy.class);
    }

    @Override
    public List<WhWarehouseInvQttVO> findInvQttBySkuCode(String skuCode) {
        Map whStockMap = this.sStockService.getSkuStocksInAllWarehouses(skuCode);
        ArrayList<WhWarehouseInvQttVO> whWarehouseInvQttVOs = new ArrayList<WhWarehouseInvQttVO>();
        for (Map.Entry entry : whStockMap.entrySet()) {
            WhWarehouseInvQttVO whWarehouseInvQttVO = new WhWarehouseInvQttVO();
            BeanUtils.copyProperties(entry.getValue(), (Object)whWarehouseInvQttVO);
            whWarehouseInvQttVOs.add(whWarehouseInvQttVO);
        }
        return whWarehouseInvQttVOs;
    }

    @Override
    public List<WhWarehouseInvQttVO> findWillInQttBySkuCode(String skuCode) {
        return this.whCommandMapper.findWillInQttBySkuCode(skuCode);
    }

    @Override
    public List<WhWarehouseInvQttVO> findNewWillInQttBySkuCode(String skuCode) {
        return this.whCommandMapper.findNewWillInQttBySkuCode(skuCode);
    }

    @Override
    public int findInvQttBySkuCodeAndWarehouseCode(String skuCode, String warehouseCode) {
        ArrayList<String> skuCodeList = new ArrayList<String>();
        skuCodeList.add(skuCode);
        Map map = this.sStockService.getSkuRealStocks(skuCodeList, warehouseCode);
        if (EmptyUtil.isEmpty((Map)map)) {
            return 0;
        }
        return ((SSkuStockQuantityVO)map.get(skuCode)).getQuantity();
    }

    @Override
    public int findQttBySkuCode(String skuCode) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("skuCode", skuCode);
        return this.whInvRcdMapper.findQttBySkuCode(params);
    }

    @Override
    public List<WhSkuInvQttVO> findInvQttBySkuCodesAndWarehouseCode(List<String> skuCodes, String warehouseCode) {
        Map map = this.sStockService.getSkuRealStocks(skuCodes, warehouseCode);
        ArrayList<WhSkuInvQttVO> resultList = new ArrayList<WhSkuInvQttVO>();
        for (Map.Entry entry : map.entrySet()) {
            resultList.add((WhSkuInvQttVO)BeanUtil.buildFrom(entry.getValue(), WhSkuInvQttVO.class));
        }
        return resultList;
    }

    @Override
    public List<WhSkuInvQttVO> findSkuInvQttByWarehouseCode(String warehouseCode) {
        List<SSkuStockVO> skuStockVOList = this.getSkuStockInAllWarehouses(warehouseCode);
        Map<String, PcsSkuDTO> skuNameMap = this.getSkuNameMap(skuStockVOList);
        ArrayList<WhSkuInvQttVO> whSkuInvQttVOList = new ArrayList<WhSkuInvQttVO>();
        if (skuStockVOList != null) {
            WhWarehouse whWarehouse = this.whWarehouseMapper.findWarehouseByCode(warehouseCode);
            for (SSkuStockVO sSkuStockVO : skuStockVOList) {
                WhSkuInvQttVO whSkuInvQttVO = new WhSkuInvQttVO();
                whSkuInvQttVO.setSkuCode(sSkuStockVO.getSkuCode());
                whSkuInvQttVO.setWarehouseName(whWarehouse != null ? whWarehouse.getName() : "");
                whSkuInvQttVO.setQuantity(sSkuStockVO.getRealQuantity());
                PcsSkuDTO pcsSkuDTO = skuNameMap.get(sSkuStockVO.getSkuCode());
                if (pcsSkuDTO == null) {
                    System.out.print(11);
                }
                whSkuInvQttVO.setNameCn(pcsSkuDTO == null ? "" : pcsSkuDTO.getNameCn());
                whSkuInvQttVOList.add(whSkuInvQttVO);
            }
        }
        return whSkuInvQttVOList;
    }

    @Override
    public List<WhSkuInvQttVO> findSkuInvQttByPhysicalWarehouseCode(String physicalWarehouseCode) {
        List<WhWarehouse> whWarehouseList = this.whWarehouseMapper.findWarehouseByPhysicalCodeAndStatus(physicalWarehouseCode, null, null);
        ArrayList<WhSkuInvQttVO> whSkuInvQttVOList = new ArrayList<WhSkuInvQttVO>();
        if (EmptyUtil.isNotEmpty(whWarehouseList)) {
            for (WhWarehouse whWarehouse : whWarehouseList) {
                whSkuInvQttVOList.addAll(this.findSkuInvQttByWarehouseCode(whWarehouse.getCode()));
            }
        }
        return whSkuInvQttVOList;
    }

    @Override
    public List<WhSkuInvQttVO> findSkuInvQttByWarehouseCodes(List<String> warehouseCodeList) {
        ArrayList<WhSkuInvQttVO> whSkuInvQttVOList = new ArrayList<WhSkuInvQttVO>();
        if (EmptyUtil.isNotEmpty(warehouseCodeList)) {
            for (String warehouseCode : warehouseCodeList) {
                whSkuInvQttVOList.addAll(this.findSkuInvQttByWarehouseCode(warehouseCode));
            }
        }
        return whSkuInvQttVOList;
    }

    @Override
    public List<WhSkuInvQttVO> findOccupyQttByWarehouseCode(String warehouseCode) {
        List<SSkuStockVO> skuStockVOList = this.getSkuStockInAllWarehouses(warehouseCode);
        ArrayList<WhSkuInvQttVO> whSkuInvQttVOList = new ArrayList<WhSkuInvQttVO>();
        if (skuStockVOList != null) {
            WhWarehouse whWarehouse = this.whWarehouseMapper.findWarehouseByCode(warehouseCode);
            for (SSkuStockVO sSkuStockVO : skuStockVOList) {
                WhSkuInvQttVO whSkuInvQttVO = new WhSkuInvQttVO();
                whSkuInvQttVO.setSkuCode(sSkuStockVO.getSkuCode());
                whSkuInvQttVO.setWarehouseName(whWarehouse != null ? whWarehouse.getName() : "");
                whSkuInvQttVO.setQuantity(sSkuStockVO.getOccupyQuantity());
                whSkuInvQttVOList.add(whSkuInvQttVO);
            }
        }
        return whSkuInvQttVOList;
    }

    @Override
    public List<WhSkuInvQttVO> findWillInQttByWarehouseCode(String warehouseCode) {
        return this.whCommandMapper.findWillInQttByWarehouseCode(warehouseCode);
    }

    @Override
    public List<WhWarehouseInvQttVO> findOccupyQttBySkuCode(String skuCode) {
        Map map = this.sStockService.getSkuOccupyStocksInAllWarehouses(skuCode);
        ArrayList<WhWarehouseInvQttVO> resultList = new ArrayList<WhWarehouseInvQttVO>();
        if (EmptyUtil.isEmpty((Map)map)) {
            return resultList;
        }
        for (Map.Entry entry : map.entrySet()) {
            resultList.add((WhWarehouseInvQttVO)BeanUtil.buildFrom(entry.getValue(), WhWarehouseInvQttVO.class));
        }
        return resultList;
    }

    @Override
    public int findOccupyQttBySkuCodeAndWarehouseCode(String skuCode, String warehouseCode) {
        ArrayList<String> skuCodeList = new ArrayList<String>();
        skuCodeList.add(skuCode);
        Map map = this.sStockService.getSkuOccupyStocks(skuCodeList, warehouseCode);
        if (EmptyUtil.isEmpty((Map)map)) {
            return 0;
        }
        SSkuStockQuantityVO skuStockQuantityVO = (SSkuStockQuantityVO)map.get(skuCode);
        return skuStockQuantityVO == null ? 0 : skuStockQuantityVO.getQuantity();
    }

    @Override
    public List<WhSkuInvQttVO> findOccupyQttBySkuCodesAndWarehouseCode(List<String> skuCodes, String warehouseCode) {
        if (EmptyUtil.isEmpty(skuCodes)) {
            return new ArrayList<WhSkuInvQttVO>();
        }
        ArrayList<WhSkuInvQttVO> resultList = new ArrayList<WhSkuInvQttVO>();
        Map map = this.sStockService.getSkuOccupyStocks(skuCodes, warehouseCode);
        if (EmptyUtil.isEmpty((Map)map)) {
            return resultList;
        }
        for (Map.Entry entry : map.entrySet()) {
            resultList.add((WhSkuInvQttVO)BeanUtil.buildFrom(entry.getValue(), WhSkuInvQttVO.class));
        }
        return resultList;
    }

    @Override
    public Map<String, WhInvVO> findCanUseQttBySkuCode(String skuCode) {
        HashMap<String, WhInvVO> resultMap = new HashMap<String, WhInvVO>();
        Map map = this.sStockService.getSkuStocksInAllWarehouses(skuCode);
        List<WhSkuInvQttVO> quantityAllotWillIn = this.whCommandMapper.findAllotWillInQttBySkuCode(skuCode);
        if (EmptyUtil.isNotEmpty((Map)map)) {
            for (Map.Entry entry : map.entrySet()) {
                resultMap.put((String)entry.getKey(), this.convertSkuStockVO2WhInvVO((SSkuStockVO)entry.getValue()));
            }
        }
        List<WhWarehouseInvQttVO> quantityWillIn = this.findNewWillInQttBySkuCode(skuCode);
        for (WhWarehouseInvQttVO whWarehouseInvQttVO : quantityWillIn) {
            String warehouseCode = whWarehouseInvQttVO.getWarehouseCode();
            Integer quantity = whWarehouseInvQttVO.getQuantity();
            WhInvVO whInvVO = (WhInvVO)resultMap.get(warehouseCode);
            if (whInvVO == null) {
                whInvVO = new WhInvVO();
                whInvVO.setSkuCode(skuCode);
                whInvVO.setWarehouseCode(warehouseCode);
                whInvVO.setQuantityInRcd(0);
                whInvVO.setQuantityInOccupy(0);
                whInvVO.setQuantityAllotWillIn(0);
                resultMap.put(warehouseCode, whInvVO);
            }
            whInvVO.setQuantityWillIn(quantity == null ? 0 : quantity);
        }
        for (WhSkuInvQttVO whSkuInvQttVO : quantityAllotWillIn) {
            WhInvVO whInvVO = (WhInvVO)resultMap.get(whSkuInvQttVO.getWarehouseCode());
            if (whInvVO == null) {
                whInvVO = new WhInvVO();
                whInvVO.setSkuCode(skuCode);
                whInvVO.setWarehouseCode(whSkuInvQttVO.getWarehouseCode());
                whInvVO.setQuantityInRcd(0);
                whInvVO.setQuantityInOccupy(0);
                whInvVO.setQuantityAllotWillIn(0);
                resultMap.put(whSkuInvQttVO.getWarehouseCode(), whInvVO);
            }
            whInvVO.setQuantityAllotWillIn(whSkuInvQttVO.getQuantity());
        }
        return resultMap;
    }

    @Override
    public List<WhWarehouseSkuInvVO> findWarehousesSkuInvByCond(List<String> warehouseCodeList, String skuCode) {
        Map<String, WhWarehouse> warehouseMap = this.getWarehouseMap(warehouseCodeList);
        Map<String, WhInvVO> skuInvMap = this.findCanUseQttBySkuCode(skuCode);
        ArrayList<WhWarehouseSkuInvVO> whWarehouseSkuInvVOList = new ArrayList<WhWarehouseSkuInvVO>();
        for (Map.Entry<String, WhInvVO> whSkuInvEntry : skuInvMap.entrySet()) {
            String warehouseCode = whSkuInvEntry.getKey();
            if (!warehouseCodeList.contains(warehouseCode)) continue;
            WhWarehouseSkuInvVO whWarehouseSkuInvVO = new WhWarehouseSkuInvVO();
            BeanUtils.copyProperties((Object)whSkuInvEntry.getValue(), (Object)whWarehouseSkuInvVO);
            whWarehouseSkuInvVO.setWarehouseCode(warehouseCode);
            whWarehouseSkuInvVOList.add(whWarehouseSkuInvVO);
            WhWarehouse warehouse = warehouseMap.get(warehouseCode);
            if (!NullUtil.isNotNull((Object)warehouse)) continue;
            whWarehouseSkuInvVO.setWarehouseName(warehouse.getName());
        }
        return whWarehouseSkuInvVOList;
    }

    @Override
    public Map<String, Map<String, WhInvVO>> findSkuStocks(List<String> skuCodes, List<String> warhouseCodes) {
        HashMap<String, Map<String, WhInvVO>> map = new HashMap<String, Map<String, WhInvVO>>();
        if (EmptyUtil.isEmpty(warhouseCodes)) {
            return map;
        }
        Map whStockMap = this.sStockService.getSkuStocks(skuCodes, warhouseCodes);
        if (NullUtil.isNull((Object)whStockMap) || whStockMap.isEmpty()) {
            return map;
        }
        for (Map.Entry whEntry : whStockMap.entrySet()) {
            HashMap whSkuStockMap = new HashMap();
            map.put((String)whEntry.getKey(), whSkuStockMap);
            for (Map.Entry stockEntry : ((Map)whEntry.getValue()).entrySet()) {
                whSkuStockMap.put(stockEntry.getKey(), this.convertSkuStockVO2WhInvVO((SSkuStockVO)stockEntry.getValue()));
            }
        }
        return map;
    }

    @Override
    public Map<String, WhWarehouse> getWarehouseMap(List<String> warehouseCodeList) {
        HashMap<String, WhWarehouse> warehouseMap = new HashMap<String, WhWarehouse>();
        for (WhWarehouse warehouse : this.whInfoService.findWarehouseByCodes(warehouseCodeList)) {
            warehouseMap.put(warehouse.getCode(), warehouse);
        }
        return warehouseMap;
    }

    @Override
    public Map<String, WhInvVO> findCanUseQttByWarehouseCode(String warehouseCode) {
        PcsSkuDTO pcsSkuDTO;
        List<WhSkuInvQttVO> quantityWillIn = this.findWillInQttByWarehouseCode(warehouseCode);
        List<WhSkuInvQttVO> quantityAllotWillIn = this.findAllotWillInQttByWarehouseCode(warehouseCode);
        List<SSkuStockVO> skuStockVOList = this.getSkuStockInAllWarehouses(warehouseCode);
        List<Object> whInvVOList = new ArrayList();
        if (skuStockVOList != null) {
            whInvVOList = this.convertSkuStockVO2WhInvVO(skuStockVOList);
        }
        HashMap<String, WhInvVO> result = new HashMap<String, WhInvVO>();
        WhWarehouse whWarehouse = this.whWarehouseMapper.findWarehouseByCode(warehouseCode);
        String warehouseName = whWarehouse != null ? whWarehouse.getName() : "";
        HashSet<String> skuCodes = new HashSet<String>();
        if (EmptyUtil.isNotEmpty(skuStockVOList)) {
            for (SSkuStockVO sSkuStockVO : skuStockVOList) {
                skuCodes.add(sSkuStockVO.getSkuCode());
            }
        }
        for (WhSkuInvQttVO e : quantityWillIn) {
            skuCodes.add(e.getSkuCode());
        }
        Map<String, PcsSkuDTO> skuNameMap = this.getSkuNameMapBySkuCodes(skuCodes);
        for (WhInvVO whInvVO : whInvVOList) {
            whInvVO.setWarehouseCode(warehouseCode);
            whInvVO.setWarehouseName(warehouseName);
            if (EmptyUtil.isNotEmpty(skuNameMap) && EmptyUtil.isNotEmpty((Object)whInvVO) && EmptyUtil.isNotEmpty((Object)(pcsSkuDTO = skuNameMap.get(whInvVO.getSkuCode())))) {
                whInvVO.setSkuNameCn(pcsSkuDTO.getNameCn());
                whInvVO.setSkuTypeStr(pcsSkuDTO.getSkuTypeStr());
                whInvVO.setNameCn(pcsSkuDTO.getNameCn());
            }
            result.put(whInvVO.getSkuCode(), whInvVO);
        }
        for (WhSkuInvQttVO whSkuInvQttVO : quantityWillIn) {
            String skuCode = whSkuInvQttVO.getSkuCode();
            Integer quantity = whSkuInvQttVO.getQuantity();
            pcsSkuDTO = skuNameMap.get(skuCode);
            WhInvVO whInvVO = (WhInvVO)result.get(skuCode);
            if (whInvVO == null) {
                whInvVO = new WhInvVO();
                whInvVO.setSkuCode(skuCode);
                whInvVO.setWarehouseCode(warehouseCode);
                whInvVO.setWarehouseName(warehouseName);
                whInvVO.setQuantityInRcd(0);
                whInvVO.setQuantityInOccupy(0);
                whInvVO.setSkuName(pcsSkuDTO.getNameCn());
                whInvVO.setSkuTypeStr(pcsSkuDTO.getSkuTypeStr());
                whInvVO.setSkuNameCn(whSkuInvQttVO.getNameCn());
                whInvVO.setNameCn(whSkuInvQttVO.getNameCn());
                result.put(skuCode, whInvVO);
            }
            whInvVO.setQuantityWillIn(quantity);
        }
        for (WhSkuInvQttVO whSkuInvQttVO : quantityAllotWillIn) {
            WhInvVO whInvVO = (WhInvVO)result.get(whSkuInvQttVO.getSkuCode());
            whInvVO.setQuantityAllotWillIn(whSkuInvQttVO.getQuantity());
        }
        return result;
    }

    @Override
    public WhInvVO findCanUseQttBySkuCodeAndWarehouseCode(String skuCode, String warehouseCode) {
        SSkuStockVO sSkuStockVO = this.sStockService.getSkuStock(skuCode, warehouseCode);
        sSkuStockVO.setWarehouseCode(warehouseCode);
        return this.convertSkuStockVO2WhInvVO(sSkuStockVO);
    }

    @Override
    public Map<String, WhInvVO> findCanUseQttBySkuCodesAndWarehouseCode(List<String> skuCodes, String warehouseCode) {
        HashMap<String, WhInvVO> result = new HashMap<String, WhInvVO>();
        Map map = this.sStockService.getSkuStocks(skuCodes, warehouseCode);
        if (EmptyUtil.isNotEmpty((Map)map)) {
            for (Map.Entry entry : map.entrySet()) {
                result.put((String)entry.getKey(), this.convertSkuStockVO2WhInvVO((SSkuStockVO)entry.getValue()));
            }
        }
        return result;
    }

    @Override
    public List<WhInvVO> calCanUseQtt() {
        List<WhWarehouse> whWarehouseList = this.whWarehouseMapper.findWarehouseByCond(new WhWarehouseCond());
        ArrayList<WhInvVO> resultList = new ArrayList<WhInvVO>();
        if (resultList != null) {
            for (WhWarehouse whWarehouse : whWarehouseList) {
                Map<String, WhInvVO> map = this.findCanUseQttByWarehouseCode(whWarehouse.getCode());
                if (map == null) continue;
                for (Map.Entry<String, WhInvVO> entry : map.entrySet()) {
                    resultList.add(entry.getValue());
                }
            }
        }
        return resultList;
    }

    @Override
    public List<WhInvRcdVO> getInvRcdByCond(WhInvRcdCond cond) {
        cond.setCurrpage(cond.getCurrpage() == null ? 1 : cond.getCurrpage());
        SStockRecordConditionDTO sStockRecordConditionDTO = (SStockRecordConditionDTO)BeanUtil.buildFrom((Object)cond, SStockRecordConditionDTO.class);
        sStockRecordConditionDTO.setInOutType(SStockInOutTypeEnum.getEnumByCode((Integer)cond.getInOutType()));
        sStockRecordConditionDTO.setSubmitTimeStart(EmptyUtil.isNotEmpty((String)cond.getSubmitTimeStart()) ? DateUtil.dayStart((Date)DateUtil.parse((String)cond.getSubmitTimeStart(), (String)"yyyy-MM-dd")) : null);
        sStockRecordConditionDTO.setSubmitTimeEnd(EmptyUtil.isNotEmpty((String)cond.getSubmitTimeEnd()) ? DateUtil.dayEnd((Date)DateUtil.parse((String)cond.getSubmitTimeEnd(), (String)"yyyy-MM-dd")) : null);
        List recordVOList = this.sStockService.findStockRecordByCond(sStockRecordConditionDTO);
        ArrayList<WhInvRcdVO> rcdList = new ArrayList<WhInvRcdVO>();
        if (EmptyUtil.isNotEmpty((List)recordVOList)) {
            for (SStockRecordVO sStockRecord : recordVOList) {
                WhInvRcdVO rcd = (WhInvRcdVO)BeanUtil.buildFrom((Object)sStockRecord, WhInvRcdVO.class);
                if (NullUtil.isNotNull((Object)rcd) && NullUtil.isNotNull((Object)sStockRecord.getSubmitUserId())) {
                    rcd.setSubmitUserId(sStockRecord.getSubmitUserId().longValue());
                }
                rcdList.add(rcd);
            }
        }
        return rcdList;
    }

    @Override
    public List<WhInvRcdExtend> findWhInvRcdExtendListByIdList(List<Long> idList) {
        WhInvRcdExtendExample extendExample = new WhInvRcdExtendExample();
        extendExample.createCriteria().andRcdIdIn((List)idList);
        return this.whInvRcdExtendMapper.selectByExample(extendExample);
    }

    @Override
    public List<WhInvOccupy> getInvOccupyByCond(WhInvRcdCond cond) {
        cond.setCurrpage(cond.getCurrpage() == null ? 1 : cond.getCurrpage());
        SStockOccupyDTO sStockOccupyDTO = (SStockOccupyDTO)BeanUtil.buildFrom((Object)cond, SStockOccupyDTO.class);
        sStockOccupyDTO.setSkuCode(cond.getSkuCode());
        if (EmptyUtil.isNotEmpty((String)cond.getWarehouseCode())) {
            sStockOccupyDTO.setWarehouseCode(cond.getWarehouseCode());
        } else if (CollectionUtils.isNotEmpty(cond.getWarehouseCodes())) {
            sStockOccupyDTO.setWarehouseCodes(cond.getWarehouseCodes());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getInOutType())) {
            sStockOccupyDTO.setOccupyType(SStockOccupyTypeEnum.getEnumByCode((Integer)cond.getInOutType()));
        } else if (CollectionUtils.isNotEmpty(cond.getInOutTypes())) {
            sStockOccupyDTO.setOccupyTypes(cond.getInOutTypes());
        }
        sStockOccupyDTO.setOccupyTimeStart(EmptyUtil.isNotEmpty((String)cond.getSubmitTimeStart()) ? DateUtil.dayStart((Date)DateUtil.parse((String)cond.getSubmitTimeStart(), (String)"yyyy-MM-dd")) : null);
        sStockOccupyDTO.setOccupyTimeEnd(EmptyUtil.isNotEmpty((String)cond.getSubmitTimeEnd()) ? DateUtil.dayEnd((Date)DateUtil.parse((String)cond.getSubmitTimeEnd(), (String)"yyyy-MM-dd")) : null);
        List recordVOList = this.sStockService.findStockRecordInvOccupyByCond(sStockOccupyDTO);
        ArrayList<WhInvOccupy> occupyList = new ArrayList<WhInvOccupy>();
        if (EmptyUtil.isNotEmpty((List)recordVOList)) {
            for (SStockOccupyRecordVO sStockOccupyRecordVO : recordVOList) {
                WhInvOccupy rcd = (WhInvOccupy)BeanUtil.buildFrom((Object)sStockOccupyRecordVO, WhInvOccupy.class);
                occupyList.add(rcd);
            }
        }
        return occupyList;
    }

    @Override
    public WhInvOccupy getCountInvRcdWillInByCond(WhInvRcdCond cond) {
        cond.setCurrpage(cond.getCurrpage() == null ? 1 : cond.getCurrpage());
        SStockOccupyDTO sStockOccupyDTO = (SStockOccupyDTO)BeanUtil.buildFrom((Object)cond, SStockOccupyDTO.class);
        sStockOccupyDTO.setSkuCode(cond.getSkuCode());
        sStockOccupyDTO.setWarehouseCode(cond.getWarehouseCode());
        if (EmptyUtil.isNotEmpty((Object)cond.getInOutType())) {
            sStockOccupyDTO.setInvOccupyType(cond.getInOutType());
        }
        sStockOccupyDTO.setWillInTimeStart(EmptyUtil.isNotEmpty((String)cond.getSubmitTimeStart()) ? cond.getSubmitTimeStart().replace("-", "") : null);
        sStockOccupyDTO.setWillInTimeEnd(EmptyUtil.isNotEmpty((String)cond.getSubmitTimeEnd()) ? cond.getSubmitTimeEnd().replace("-", "") : null);
        SStockOccupyRecordVO recordVO = this.sStockService.findCountStockRecordInvRcdWillInByCond(sStockOccupyDTO);
        WhInvOccupy rcd = (WhInvOccupy)BeanUtil.buildFrom((Object)recordVO, WhInvOccupy.class);
        return rcd;
    }

    @Override
    public List<WhInvOccupy> getInvRcdWillInByCond(WhInvRcdCond cond) {
        cond.setCurrpage(cond.getCurrpage() == null ? 1 : cond.getCurrpage());
        SStockOccupyDTO sStockOccupyDTO = (SStockOccupyDTO)BeanUtil.buildFrom((Object)cond, SStockOccupyDTO.class);
        sStockOccupyDTO.setSkuCode(cond.getSkuCode());
        sStockOccupyDTO.setWarehouseCode(cond.getWarehouseCode());
        if (EmptyUtil.isNotEmpty((Object)cond.getInOutType())) {
            sStockOccupyDTO.setInvOccupyType(cond.getInOutType());
        }
        sStockOccupyDTO.setWillInTimeStart(EmptyUtil.isNotEmpty((String)cond.getSubmitTimeStart()) ? cond.getSubmitTimeStart().replace("-", "") : null);
        sStockOccupyDTO.setWillInTimeEnd(EmptyUtil.isNotEmpty((String)cond.getSubmitTimeEnd()) ? cond.getSubmitTimeEnd().replace("-", "") : null);
        List recordVOList = this.sStockService.findStockRecordInvRcdWillInByCond(sStockOccupyDTO);
        ArrayList<WhInvOccupy> occupyList = new ArrayList<WhInvOccupy>();
        if (EmptyUtil.isNotEmpty((List)recordVOList)) {
            for (SStockOccupyRecordVO sStockOccupyRecordVO : recordVOList) {
                WhInvOccupy rcd = (WhInvOccupy)BeanUtil.buildFrom((Object)sStockOccupyRecordVO, WhInvOccupy.class);
                occupyList.add(rcd);
            }
        }
        return occupyList;
    }

    @Override
    public WhInvOccupy findOccupyQttByReferenceCode(String referenceCode) {
        return (WhInvOccupy)BeanUtil.buildFrom((Object)this.sStockService.getOccupyRecordsByReferenceCode(referenceCode), WhInvOccupy.class);
    }

    @Override
    public List<WhInvOccupy> findOccupyQttByReferenceCodeLike(String referenceCode) {
        return BeanUtil.buildListFrom((Collection)this.sStockService.getOccupyRecordsByReferenceCodeLike(referenceCode), WhInvOccupy.class);
    }

    @Override
    public List<WhInvQttVO> findInvQttBySkuCode_IPOS(String channelCode, String skuCode) {
        SSkuStockVO sSkuStockVO;
        ArrayList list = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)channelCode) || StringUtils.isEmpty((CharSequence)skuCode)) {
            return list;
        }
        List channelVOs = this.mcOpChannelService.getIPOSChannels();
        if (CollectionUtils.isEmpty((Collection)channelVOs)) {
            return list;
        }
        Map stockMap = this.sStockService.getSkuStocksInAllWarehouses(skuCode);
        if (MapUtils.isEmpty((Map)stockMap)) {
            return list;
        }
        List channelWarehouseList = this.channelQueryService.getWarehouseByCode(channelCode);
        for (ChannelWarehouseVO warehouse : channelWarehouseList) {
            sSkuStockVO = (SSkuStockVO)stockMap.get(warehouse.getCode());
            if (sSkuStockVO == null) continue;
            WhWarehouse whWarehouse = this.whWarehouseMapper.findWarehouseByCode(warehouse.getCode());
            WhInvQttVO whInvQttVO = new WhInvQttVO();
            whInvQttVO.setChannelCode(channelCode);
            whInvQttVO.setQuantity(sSkuStockVO.getCanUseQuantity());
            whInvQttVO.setSkuCode(skuCode);
            whInvQttVO.setName(whWarehouse.getName());
            list.add(whInvQttVO);
        }
        for (OpChannelVO opChannelVO : channelVOs) {
            sSkuStockVO = (SSkuStockVO)stockMap.get(opChannelVO.getWarehouseForSales());
            if (sSkuStockVO == null) continue;
            WhInvQttVO whInvQttVO = new WhInvQttVO();
            whInvQttVO.setChannelCode(opChannelVO.getCode());
            whInvQttVO.setQuantity(sSkuStockVO.getCanUseQuantity());
            whInvQttVO.setSkuCode(skuCode);
            whInvQttVO.setName(opChannelVO.getName());
            if (opChannelVO.getCode().equals(channelCode)) {
                list.add(0, whInvQttVO);
                continue;
            }
            list.add(whInvQttVO);
        }
        return list;
    }

    @Override
    public int updateOccupyType(WhInvOccupy record) {
        this.log.warn("-------------record.getReferenceCode():" + record.getReferenceCode() + ";record.getOccupyType():" + record.getOccupyType());
        ServiceResp serviceResp = this.sStockService.updateOccupyType(record.getReferenceCode(), record.getOccupyType());
        boolean resultStatus = (Boolean)serviceResp.getBean();
        return resultStatus ? 1 : 0;
    }

    @Override
    public Boolean releaseInterestOccupy(String interestId, String skuCode, Integer quantity) {
        SStockReleaseDTO stockReleaseDTO = new SStockReleaseDTO();
        stockReleaseDTO.setOccupyType(SStockOccupyTypeEnum.getEnumByCode((Integer)SStockOccupyTypeEnum.INTEREST.getCode()));
        stockReleaseDTO.setPreparedSkuCode(skuCode);
        stockReleaseDTO.setReferenceCode(interestId);
        stockReleaseDTO.setPreparedReleaseQuantity(quantity);
        ServiceResp serviceResp = this.sStockService.release(stockReleaseDTO);
        if (!serviceResp.isSuccess()) {
            throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
        return serviceResp.isSuccess();
    }

    @Override
    public Boolean releaseCampaignOccupy(String campaignCode, String skuCode, Integer quantity) {
        SStockReleaseDTO stockReleaseDTO = new SStockReleaseDTO();
        stockReleaseDTO.setOccupyType(SStockOccupyTypeEnum.getEnumByCode((Integer)SStockOccupyTypeEnum.CAMPAIGN_OUT.getCode()));
        stockReleaseDTO.setPreparedSkuCode(skuCode);
        stockReleaseDTO.setBusinessCode(campaignCode);
        stockReleaseDTO.setPreparedReleaseQuantity(quantity);
        ServiceResp serviceResp = this.sStockService.release(stockReleaseDTO);
        if (!serviceResp.isSuccess()) {
            throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
        return serviceResp.isSuccess();
    }

    @Override
    public Integer findOccupyByCampaignCodeAndSkuCode(String warehouseCode, String campaignCode, String skuCode) {
        return 0;
    }

    @Override
    public void deleteCampaignOccupation(List<WhReleaseOccupationVO> releaseList) {
    }

    @Override
    @Transactional
    public int releaseOccupy(List<WhInvOccupy> whInvOccupyList) {
        ServiceResp serviceResp = this.sStockService.release(BeanUtil.buildListFrom(whInvOccupyList, SStockReleaseDTO.class));
        if (!serviceResp.isSuccess()) {
            throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
        boolean resultStatus = serviceResp.isSuccess();
        return resultStatus ? 1 : 0;
    }

    @Override
    public int updateReferenceCode(String oldReferenceCode, String newReferenceCode) {
        ServiceResp serviceResp = this.sStockService.updateReferenceCode(oldReferenceCode, newReferenceCode);
        if (!serviceResp.isSuccess()) {
            throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
        boolean resultStatus = (Boolean)serviceResp.getBean();
        return resultStatus ? 1 : 0;
    }

    private WhInvVO convertSkuStockVO2WhInvVO(SSkuStockVO sSkuStockVO) {
        WhInvVO whInvVO = new WhInvVO();
        whInvVO.setSkuCode(sSkuStockVO.getSkuCode());
        whInvVO.setQuantityInOccupy(sSkuStockVO.getOccupyQuantity());
        whInvVO.setQuantityInRcd(sSkuStockVO.getRealQuantity());
        whInvVO.setWarehouseCode(sSkuStockVO.getWarehouseCode());
        return whInvVO;
    }

    private List<WhInvVO> convertSkuStockVO2WhInvVO(List<SSkuStockVO> sSkuStockVOList) {
        ArrayList<WhInvVO> whInvVOList = new ArrayList<WhInvVO>();
        if (whInvVOList != null) {
            for (SSkuStockVO sSkuStockVO : sSkuStockVOList) {
                whInvVOList.add(this.convertSkuStockVO2WhInvVO(sSkuStockVO));
            }
        }
        return whInvVOList;
    }

    private SStockOccupyDTO convertWhInvOccupy2DTO(WhInvOccupy whInvOccupy) {
        SStockOccupyDTO sStockOccupyDTO = new SStockOccupyDTO();
        BeanUtils.copyProperties((Object)whInvOccupy, (Object)sStockOccupyDTO);
        sStockOccupyDTO.setOccupyTime(new Date());
        sStockOccupyDTO.setOccupyType(SStockOccupyTypeEnum.getEnumByCode((Integer)whInvOccupy.getOccupyType()));
        return sStockOccupyDTO;
    }

    private List<SStockOccupyDTO> convertWhInvOccupy2DTO(List<WhInvOccupy> whInvOccupyList) {
        ArrayList<SStockOccupyDTO> dtoList = new ArrayList<SStockOccupyDTO>();
        if (EmptyUtil.isNotEmpty(whInvOccupyList)) {
            for (WhInvOccupy whInvOccupy : whInvOccupyList) {
                dtoList.add(this.convertWhInvOccupy2DTO(whInvOccupy));
            }
        }
        return dtoList;
    }

    @Override
    public List<SStockReleaseDTO> convertWhRelease2DTO(List<WhReleaseOccupationVO> whReleaseOccupationVOList) {
        ArrayList<SStockReleaseDTO> dtoList = new ArrayList<SStockReleaseDTO>();
        if (EmptyUtil.isNotEmpty(whReleaseOccupationVOList)) {
            for (WhReleaseOccupationVO whReleaseOccupationVO : whReleaseOccupationVOList) {
                SStockReleaseDTO dto = new SStockReleaseDTO();
                BeanUtils.copyProperties((Object)whReleaseOccupationVO, (Object)dto);
                dto.setOperationType(SStockOperationTypeEnum.DEFAULT);
                dto.setOccupyType(SStockOccupyTypeEnum.getEnumByCode((Integer)whReleaseOccupationVO.getOccupyType()));
                dto.setBackToPrepared(Boolean.valueOf(false));
                dtoList.add(dto);
            }
        }
        return dtoList;
    }

    @Override
    public List<SStockRecordVO> convertWhInv2DTO(List<WhInvRcd> whInvRcdList) {
        ArrayList<SStockRecordVO> dtoList = new ArrayList<SStockRecordVO>();
        if (EmptyUtil.isNotEmpty(whInvRcdList)) {
            for (WhInvRcd invRcd : whInvRcdList) {
                dtoList.add(this.convertWhInv2DTO(invRcd));
            }
        }
        return dtoList;
    }

    @Override
    public List<WhSkuInvQttVO> findAllotWillInQttByWarehouseCode(String warehouseCode) {
        return this.whCommandMapper.findAllotWillInQttByWarehouseCode(warehouseCode);
    }

    private SStockReleaseDTO convertWhRelease2DTO(WhReleaseOccupationVO whReleaseOccupationVO) {
        SStockReleaseDTO dto = new SStockReleaseDTO();
        BeanUtils.copyProperties((Object)whReleaseOccupationVO, (Object)dto);
        dto.setOperationType(SStockOperationTypeEnum.DEFAULT);
        dto.setOccupyType(SStockOccupyTypeEnum.getEnumByCode((Integer)whReleaseOccupationVO.getOccupyType()));
        return dto;
    }

    private List<WhSkuInvQttVO> convertDTO2WhSkuInvQttVO(List<SSkuStockVO> sSkuStockVOList) {
        ArrayList whSkuInvQttVOList = new ArrayList();
        if (sSkuStockVOList != null) {
            for (SSkuStockVO sSkuStockVO : sSkuStockVOList) {
            }
        }
        return null;
    }

    public List<SSkuStockVO> getSkuStockInAllWarehouses(String warehouseCode) {
        PageCond page = new PageCond();
        int currentPage = 1;
        page.setPagenum(Integer.valueOf(500));
        int currentPageNum = 500;
        ArrayList<SSkuStockVO> resultList = new ArrayList<SSkuStockVO>();
        while (currentPageNum == 500) {
            page.setCurrpage(Integer.valueOf(currentPage));
            PageQueryResp pageQueryResp = this.sStockService.getAllSkuStocksInWarehouse(warehouseCode, page);
            if (EmptyUtil.isNotEmpty((String)warehouseCode)) {
                pageQueryResp = this.sStockService.getAllSkuStocksInWarehouse(warehouseCode, page);
            }
            List skuStockVOList = pageQueryResp.getBeanList();
            resultList.addAll(skuStockVOList);
            currentPageNum = skuStockVOList.size();
            ++currentPage;
        }
        return resultList;
    }

    private Map<String, PcsSkuDTO> getSkuNameMap(List<SSkuStockVO> skuStockVOList) {
        HashSet<String> skuCodes = new HashSet<String>();
        if (EmptyUtil.isNotEmpty(skuStockVOList)) {
            for (SSkuStockVO sSkuStockVO : skuStockVOList) {
                skuCodes.add(sSkuStockVO.getSkuCode());
            }
        }
        return this.getSkuNameMapBySkuCodes(skuCodes);
    }

    private Map<String, PcsSkuDTO> getSkuNameMapBySkuCodes(Set<String> skuCodes) {
        ArrayList<String> skuCodeList = new ArrayList<String>();
        skuCodeList.addAll(skuCodes);
        int skuCodeNum = skuCodeList.size();
        int maxSearchNum = 500;
        HashMap<String, PcsSkuDTO> resultMap = new HashMap<String, PcsSkuDTO>();
        if (maxSearchNum < skuCodeNum) {
            for (int index = 0; index < skuCodeNum; index += maxSearchNum) {
                List subList = skuCodeList.subList(index, index + maxSearchNum < skuCodeNum ? index + maxSearchNum : skuCodeNum);
                HashSet subSkuCodes = new HashSet();
                subSkuCodes.addAll(subList);
                resultMap.putAll(this.mcPcsSkuService.getSkuNameByCodes(subSkuCodes));
            }
        } else {
            return this.mcPcsSkuService.getSkuNameByCodes(skuCodes);
        }
        return resultMap;
    }

    public static void main(String[] args) {
        int skuCodeNum = 501;
        int maxSearchNum = 500;
        int totalPage = skuCodeNum / maxSearchNum;
        ArrayList<String> skuCodeList = new ArrayList<String>();
        skuCodeList.add("1");
        skuCodeList.add("2");
        skuCodeList.add("3");
        skuCodeList.add("4");
        skuCodeList.add("5");
        List test = skuCodeList.subList(1, 4);
        System.out.print(totalPage);
    }
}

