/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.validation.Validation;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWarehouseCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhAllotRcdMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhApplicatParaMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhApplicatParaSkuMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhDistrictPhysicalWarehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhPhysicalWarehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhPhysicalWarehouseRelateWarehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWarehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsExpressInfoMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhDistrictPhysicalWarehouseCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhPhysicalWarehouseRelateWarehouseCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhApplicatPara;
import com.thebeastshop.pegasus.service.warehouse.model.WhApplicatParaExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhApplicatParaSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhApplicatParaSkuExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhDistrictPhysicalWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhDistrictPhysicalWarehouseExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouseExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouseExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsExpressInfo;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsExpressInfoExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsHouseShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWarehouseArea;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWarehouseAreaService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhDistrictPhysicalWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPhysicalWarehouseRelateWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPhysicalWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whInfoService")
public class WhInfoServiceImpl
implements WhInfoService {
    private final Logger log = LoggerFactory.getLogger(WhInfoServiceImpl.class);
    @Autowired
    private WhPhysicalWarehouseMapper whPhysicalWarehouseMapper;
    @Autowired
    private WhWarehouseMapper whWarehouseMapper;
    @Autowired
    private WhWmsExpressInfoMapper whWmsExpressInfoMapper;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsWarehouseAreaService whWmsWarehouseAreaService;
    @Autowired
    private WhDistrictPhysicalWarehouseMapper whDistrictPhysicalWarehouseMapper;
    @Autowired
    private WhDistrictPhysicalWarehouseCustomMapper whDistrictPhysicalWarehouseCustomMapper;
    @Autowired
    private WhPhysicalWarehouseRelateWarehouseMapper whPhysicalWarehouseRelateWarehouseMapper;
    @Autowired
    private WhPhysicalWarehouseRelateWarehouseCustomMapper whPhysicalWarehouseRelateWarehouseCustomMapper;
    @Autowired
    private WhAllotRcdMapper whAllotRcdMapper;
    @Autowired
    private WhApplicatParaMapper whApplicatParaMapper;
    @Autowired
    private WhApplicatParaSkuMapper whApplicatParaSkuMapper;

    @Override
    @Transactional
    public String createPhysicalWarehouse(WhPhysicalWarehouse whPhysicalWarehouse) {
        whPhysicalWarehouse.setCreateTime(new Date());
        whPhysicalWarehouse.setWarehouseStatus(0);
        this.whPhysicalWarehouseMapper.insert(whPhysicalWarehouse);
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("cityId", whPhysicalWarehouse.getCityId());
        params.put("id", whPhysicalWarehouse.getId());
        String code = CodeGenerator.getInstance().generate("WH_PHYSICAL_WAREHOUSE", params);
        whPhysicalWarehouse.setCode(code);
        whPhysicalWarehouse.setHouseNo(this.buildHouseNo(whPhysicalWarehouse.getId()));
        this.whPhysicalWarehouseMapper.updateByPrimaryKeySelective(whPhysicalWarehouse);
        if (!WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(whPhysicalWarehouse.getWarehouseType())) {
            this.createDefaultShelves(whPhysicalWarehouse);
        }
        return code;
    }

    private String buildHouseNo(Long phyWarehouseId) {
        Long tmepId = phyWarehouseId + 20L;
        return tmepId.toString();
    }

    private void createDefaultShelves(WhPhysicalWarehouse phyWarehouse) {
        WhWmsHouseShelves houseShelves = this.buildEmptyShelves();
        WhWmsWarehouseArea area = this.whWmsWarehouseAreaService.getAreaByHouseType("HOUSE_TYPE_PUSH_KEEP");
        houseShelves.setHouseType(area.getHouseType());
        houseShelves.setPhysicalWarehouseCode(phyWarehouse.getCode());
        houseShelves.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        houseShelves.setShelves(this.getDefaultShelves(houseShelves.getSkuStatus()));
        houseShelves.setCode(phyWarehouse.getHouseNo() + "-" + area.getCode() + "-" + houseShelves.getShelves());
        this.whWmsHouseShelvesService.newHouseShelves(houseShelves);
        houseShelves.setId(null);
        houseShelves.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE);
        houseShelves.setShelves(this.getDefaultShelves(houseShelves.getSkuStatus()));
        houseShelves.setCode(phyWarehouse.getHouseNo() + "-" + area.getCode() + "-" + houseShelves.getShelves());
        this.whWmsHouseShelvesService.newHouseShelves(houseShelves);
        houseShelves.setId(null);
        houseShelves.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY);
        houseShelves.setShelves(this.getDefaultShelves(houseShelves.getSkuStatus()));
        houseShelves.setCode(phyWarehouse.getHouseNo() + "-" + area.getCode() + "-" + houseShelves.getShelves());
        this.whWmsHouseShelvesService.newHouseShelves(houseShelves);
        houseShelves.setId(null);
        houseShelves.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_PROP);
        houseShelves.setShelves(this.getDefaultShelves(houseShelves.getSkuStatus()));
        houseShelves.setCode(phyWarehouse.getHouseNo() + "-" + area.getCode() + "-" + houseShelves.getShelves());
        this.whWmsHouseShelvesService.newHouseShelves(houseShelves);
        houseShelves.setId(null);
        houseShelves.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
        houseShelves.setShelves(this.getDefaultShelves(houseShelves.getSkuStatus()));
        houseShelves.setCode(phyWarehouse.getHouseNo() + "-" + area.getCode() + "-" + houseShelves.getShelves());
        this.whWmsHouseShelvesService.newHouseShelves(houseShelves);
        houseShelves.setId(null);
        houseShelves.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED);
        houseShelves.setShelves(this.getDefaultShelves(houseShelves.getSkuStatus()));
        houseShelves.setCode(phyWarehouse.getHouseNo() + "-" + area.getCode() + "-" + houseShelves.getShelves());
        this.whWmsHouseShelvesService.newHouseShelves(houseShelves);
        houseShelves.setId(null);
        houseShelves.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED);
        houseShelves.setShelves(this.getDefaultShelves(houseShelves.getSkuStatus()));
        houseShelves.setCode(phyWarehouse.getHouseNo() + "-" + area.getCode() + "-" + houseShelves.getShelves());
        this.whWmsHouseShelvesService.newHouseShelves(houseShelves);
        houseShelves.setId(null);
        houseShelves.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED);
        houseShelves.setShelves(this.getDefaultShelves(houseShelves.getSkuStatus()));
        houseShelves.setCode(phyWarehouse.getHouseNo() + "-" + area.getCode() + "-" + houseShelves.getShelves());
        this.whWmsHouseShelvesService.newHouseShelves(houseShelves);
    }

    private WhWmsHouseShelves buildEmptyShelves() {
        WhWmsHouseShelves houseShelves = new WhWmsHouseShelves();
        houseShelves.setMixedType(WhWmsHouseShelvesVO.MIXED_TYPE_UNLIMIT);
        houseShelves.setShelvesStatus(WhWmsHouseShelvesVO.SHELVES_STATUS_UNOCCUPY);
        houseShelves.setShelvesUsableStatus(WhWmsHouseShelvesVO.SHELVES_USABLE_SUATUS_AVAILABLE);
        houseShelves.setCreateTime(DateUtil.getNow());
        houseShelves.setShelvesType(WhWmsHouseShelvesVO.SHELVES_TYPE_NORMAL);
        houseShelves.setStorageType(WhWmsHouseShelvesVO.STORAGE_TYPE_NORMAL_TEMPERATURE);
        houseShelves.setShelvesStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        houseShelves.setSortOrder(null);
        houseShelves.setCreateUserId(null);
        return houseShelves;
    }

    private String getDefaultShelves(Integer skuStatus) {
        return WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(skuStatus) ? "01-01-01-01" : (WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE.equals(skuStatus) ? "01-01-01-02" : (WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED.equals(skuStatus) ? "01-01-01-03" : (WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED.equals(skuStatus) ? "01-01-01-04" : (WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED.equals(skuStatus) ? "01-01-01-05" : (WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED.equals(skuStatus) ? "01-01-01-06" : (WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY.equals(skuStatus) ? "01-01-01-07" : (WhWarehouseVO.COMMODITY_STATUS_FOR_PROP.equals(skuStatus) ? "01-01-01-08" : "")))))));
    }

    @Override
    public boolean updatePhysicalWarehouse(WhPhysicalWarehouse whPhysicalWarehouse) {
        return this.whPhysicalWarehouseMapper.updateByPrimaryKeySelective(whPhysicalWarehouse) != 0;
    }

    @Override
    public void saveOrUpdateApplicationPara(String bu, boolean autoAudit) {
        WhApplicatParaExample example = new WhApplicatParaExample();
        example.createCriteria().andBuEqualTo(bu);
        List<WhApplicatPara> whApplicatParaList = this.whApplicatParaMapper.selectByExample(example);
        if (whApplicatParaList != null && whApplicatParaList.size() > 0) {
            WhApplicatPara whApplicatPara = whApplicatParaList.get(0);
            whApplicatPara.setBu(bu);
            whApplicatPara.setAutoAudit(autoAudit ? 1 : 0);
            this.whApplicatParaMapper.updateByPrimaryKeySelective(whApplicatPara);
        } else {
            WhApplicatPara whApplicatPara = new WhApplicatPara();
            whApplicatPara.setBu(bu);
            whApplicatPara.setAutoAudit(autoAudit ? 1 : 0);
            this.whApplicatParaMapper.insertSelective(whApplicatPara);
        }
    }

    @Override
    public WhApplicatPara findWhApplicationParaByBu(String bu) {
        WhApplicatParaExample example = new WhApplicatParaExample();
        example.createCriteria().andBuEqualTo(bu);
        List<WhApplicatPara> list = this.whApplicatParaMapper.selectByExample(example);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<WhApplicatPara> findAllWhApplicationPara() {
        return this.whApplicatParaMapper.selectByExample(new WhApplicatParaExample());
    }

    @Override
    public List<WhApplicatParaSku> findWhApplicationParaSkuBySkuCode(String skuCode) {
        WhApplicatParaSkuExample example = new WhApplicatParaSkuExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode);
        return this.whApplicatParaSkuMapper.selectByExample(example);
    }

    @Override
    public List<WhWmsExpressInfo> findAllExpressInfo() {
        WhWmsExpressInfoExample expressInfoExample = new WhWmsExpressInfoExample();
        expressInfoExample.createCriteria().andCancelFlagEqualTo(0);
        expressInfoExample.setOrderByClause("id");
        return this.whWmsExpressInfoMapper.selectByExample(expressInfoExample);
    }

    @Override
    public boolean updatePhysicalWarehouseByCode(String code, WhPhysicalWarehouse whPhysicalWarehouse) {
        WhPhysicalWarehouseExample example = new WhPhysicalWarehouseExample();
        example.createCriteria().andCodeEqualTo(code);
        return this.whPhysicalWarehouseMapper.updateByExampleSelective(whPhysicalWarehouse, example) != 0;
    }

    @Override
    public WhWmsExpressInfo findExpressInfoById(Long id) {
        return this.whWmsExpressInfoMapper.selectByPrimaryKey(id);
    }

    @Override
    public boolean deletePhysicalWarehouse(WhPhysicalWarehouse whPhysicalWarehouse) {
        return this.whPhysicalWarehouseMapper.deleteByPrimaryKey(whPhysicalWarehouse.getId()) != 0;
    }

    @Override
    public WhPhysicalWarehouse findPhysicalWarehouseByCode(String code) {
        WhPhysicalWarehouseExample example = new WhPhysicalWarehouseExample();
        example.createCriteria().andCodeEqualTo(code);
        example.setOrderByClause("id");
        List<WhPhysicalWarehouse> whPhysicalWarehouseList = this.whPhysicalWarehouseMapper.selectByExample(example);
        return whPhysicalWarehouseList != null && !whPhysicalWarehouseList.isEmpty() ? whPhysicalWarehouseList.get(0) : null;
    }

    @Override
    public WhPhysicalWarehouseVO findPhysicalWarehouseVOAndWarehouseGroupByPhyCode(String code) {
        List<WhPhysicalWarehouseVO> whPhysicalWarehouseList = this.whPhysicalWarehouseMapper.findPhysicalWarehouseVOAndWarehouseGroupByPhyCode(code);
        return whPhysicalWarehouseList != null && !whPhysicalWarehouseList.isEmpty() ? whPhysicalWarehouseList.get(0) : null;
    }

    @Override
    public WhPhysicalWarehouse findPhysicalWarehouseById(Long id) {
        return this.whPhysicalWarehouseMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<WhPhysicalWarehouseVO> findPhysicalWarehouseByGroupId(List<Long> warehouseGroupIds) {
        if (EmptyUtil.isEmpty(warehouseGroupIds)) {
            return Collections.emptyList();
        }
        WhPhysicalWarehouseExample example = new WhPhysicalWarehouseExample();
        example.createCriteria().andWarehouseGroupIdIn((List)warehouseGroupIds);
        List<WhPhysicalWarehouse> whPhysicalWarehouseList = this.whPhysicalWarehouseMapper.selectByExample(example);
        return BeanUtil.buildListFrom(whPhysicalWarehouseList, WhPhysicalWarehouseVO.class);
    }

    @Override
    public Map<Long, List<WhPhysicalWarehouseVO>> findPhysicalWarehouseMapByGroupId(List<Long> warehouseGroupIds) {
        List<WhPhysicalWarehouseVO> physicalWarehouseList = this.findPhysicalWarehouseByGroupId(warehouseGroupIds);
        HashMap<Long, List<WhPhysicalWarehouseVO>> map = new HashMap<Long, List<WhPhysicalWarehouseVO>>();
        if (EmptyUtil.isNotEmpty(physicalWarehouseList)) {
            for (WhPhysicalWarehouseVO phyWh : physicalWarehouseList) {
                ArrayList<WhPhysicalWarehouseVO> groupList = (ArrayList<WhPhysicalWarehouseVO>)map.get(phyWh.getWarehouseGroupId());
                if (NullUtil.isNull((Object)groupList)) {
                    groupList = new ArrayList<WhPhysicalWarehouseVO>();
                    map.put(phyWh.getWarehouseGroupId(), groupList);
                }
                groupList.add(phyWh);
            }
        }
        return map;
    }

    @Override
    public List<WhPhysicalWarehouse> findPhysicalWarehouseByNameCode(String nameOrCode) {
        return this.whPhysicalWarehouseMapper.findPhysicalWarehouseByNameCode(SQLUtils.allLike((String)nameOrCode));
    }

    @Override
    public List<WhPhysicalWarehouse> findNewPhysicalWarehouseByNameOrCode(String nameOrCode) {
        return this.whPhysicalWarehouseMapper.findNewPhysicalWarehouseByNameOrCode(SQLUtils.allLike((String)nameOrCode));
    }

    @Override
    public List<WhPhysicalWarehouse> listPhysicalWarehouseByIds(List<Long> ids) {
        WhPhysicalWarehouseExample example = new WhPhysicalWarehouseExample();
        example.createCriteria().andIdIn((List)ids);
        return this.whPhysicalWarehouseMapper.selectByExample(example);
    }

    @Override
    public List<WhPhysicalWarehouse> findPhysicalWarehouseByDistrict(List<Long> districtIds) {
        WhPhysicalWarehouseExample example = new WhPhysicalWarehouseExample();
        example.createCriteria().andCityIdIn((List)districtIds);
        return this.whPhysicalWarehouseMapper.selectByExample(example);
    }

    @Override
    public List<WhPhysicalWarehouse> findAllPhysicalWarehouse() {
        WhPhysicalWarehouseExample example = new WhPhysicalWarehouseExample();
        example.setOrderByClause("id");
        return this.whPhysicalWarehouseMapper.selectByExample(example);
    }

    @Override
    public Map<String, WhPhysicalWarehouseVO> findAllPhysicalWarehouseMap() {
        HashMap<String, WhPhysicalWarehouseVO> map = new HashMap<String, WhPhysicalWarehouseVO>();
        List<WhPhysicalWarehouse> list = this.findAllPhysicalWarehouse();
        if (EmptyUtil.isNotEmpty(list)) {
            for (WhPhysicalWarehouse phyWh : list) {
                map.put(phyWh.getCode(), (WhPhysicalWarehouseVO)BeanUtil.buildFrom((Object)phyWh, WhPhysicalWarehouseVO.class));
            }
        }
        return map;
    }

    @Override
    public List<WhPhysicalWarehouse> findPhysicalWarehouseByCond(WhPhysicalWarehouseVO whPhysicalWarehouseVO) {
        WhPhysicalWarehouseExample example = new WhPhysicalWarehouseExample();
        WhPhysicalWarehouseExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((String)whPhysicalWarehouseVO.getCode())) {
            criteria.andCodeEqualTo(whPhysicalWarehouseVO.getCode());
        }
        if (EmptyUtil.isNotEmpty((String)whPhysicalWarehouseVO.getName())) {
            criteria.andNameLike(SQLUtils.allLike((String)whPhysicalWarehouseVO.getName()));
        }
        if (EmptyUtil.isNotEmpty((Object)whPhysicalWarehouseVO.getWarehouseType())) {
            criteria.andWarehouseTypeEqualTo(whPhysicalWarehouseVO.getWarehouseType());
        }
        if (CollectionUtils.isNotEmpty(whPhysicalWarehouseVO.getWarehouseCodes())) {
            criteria.andCodeIn((List)whPhysicalWarehouseVO.getWarehouseCodes());
        }
        if (CollectionUtils.isNotEmpty(whPhysicalWarehouseVO.getWarehouseTypeList())) {
            criteria.andWarehouseTypeIn((List)whPhysicalWarehouseVO.getWarehouseTypeList());
        }
        example.setOrderByClause("id");
        return this.whPhysicalWarehouseMapper.selectByExample(example);
    }

    @Override
    public List<WhPhysicalWarehouseVO> listOffLinePhysicalWarehouse(WhPhysicalWarehouseVO whPhysicalWarehouseVO) {
        return this.whPhysicalWarehouseMapper.listOffLinePhysicalWarehouse(whPhysicalWarehouseVO);
    }

    @Override
    public List<WhDistrictPhysicalWarehouseVO> findDistrictPyWarehouseByExample(WhDistrictPhysicalWarehouseVO whDistrictPhysicalWarehouseVO) {
        WhDistrictPhysicalWarehouseExample example = new WhDistrictPhysicalWarehouseExample();
        WhDistrictPhysicalWarehouseExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)whDistrictPhysicalWarehouseVO.getDistrictId())) {
            criteria.andDistrictIdEqualTo(whDistrictPhysicalWarehouseVO.getDistrictId());
        }
        if (EmptyUtil.isNotEmpty((String)whDistrictPhysicalWarehouseVO.getPhysicalWarehouseCode())) {
            criteria.andPhysicalWarehouseCodeEqualTo(whDistrictPhysicalWarehouseVO.getPhysicalWarehouseCode());
        }
        if (EmptyUtil.isNotEmpty((Object)whDistrictPhysicalWarehouseVO.getOperatorId())) {
            criteria.andOperatorIdEqualTo(whDistrictPhysicalWarehouseVO.getOperatorId());
        }
        example.setOrderByClause("id");
        List<WhDistrictPhysicalWarehouse> whDistrictPhysicalWarehouses = this.whDistrictPhysicalWarehouseMapper.selectByExample(example);
        return BeanUtil.buildListFrom(whDistrictPhysicalWarehouses, WhDistrictPhysicalWarehouseVO.class);
    }

    @Override
    public List<WhDistrictPhysicalWarehouseVO> findDistrictPyWarehouseByCodeAndDistrictId(List<String> codes, Long districtId) {
        WhDistrictPhysicalWarehouseExample example = new WhDistrictPhysicalWarehouseExample();
        WhDistrictPhysicalWarehouseExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)districtId)) {
            criteria.andDistrictIdEqualTo(districtId);
        }
        if (EmptyUtil.isNotEmpty(codes)) {
            criteria.andPhysicalWarehouseCodeIn((List)codes);
        }
        example.setOrderByClause("sort");
        List<WhDistrictPhysicalWarehouse> whDistrictPhysicalWarehouses = this.whDistrictPhysicalWarehouseMapper.selectByExample(example);
        return BeanUtil.buildListFrom(whDistrictPhysicalWarehouses, WhDistrictPhysicalWarehouseVO.class);
    }

    @Override
    public List<WhDistrictPhysicalWarehouseVO> listDistrictPyWarehouseByCond(WhDistrictPhysicalWarehouseVO whDistrictPhysicalWarehouseVO) {
        return this.whDistrictPhysicalWarehouseCustomMapper.listWhDistrictPhysicalWarehouseByCond(whDistrictPhysicalWarehouseVO);
    }

    @Override
    @Transactional
    public int batchInsertDistrictPyWarehouse(List<WhDistrictPhysicalWarehouseVO> whDistrictPhysicalWarehouseVOs) {
        return this.whDistrictPhysicalWarehouseCustomMapper.batchInsert(whDistrictPhysicalWarehouseVOs);
    }

    @Override
    @Transactional
    public int deleteDistrictPyWarehouseByExample(WhDistrictPhysicalWarehouseVO whDistrictPhysicalWarehouseVO) {
        WhDistrictPhysicalWarehouseExample example = new WhDistrictPhysicalWarehouseExample();
        WhDistrictPhysicalWarehouseExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)whDistrictPhysicalWarehouseVO.getDistrictId())) {
            criteria.andDistrictIdEqualTo(whDistrictPhysicalWarehouseVO.getDistrictId());
        }
        if (EmptyUtil.isNotEmpty((String)whDistrictPhysicalWarehouseVO.getPhysicalWarehouseCode())) {
            criteria.andPhysicalWarehouseCodeEqualTo(whDistrictPhysicalWarehouseVO.getPhysicalWarehouseCode());
        }
        return this.whDistrictPhysicalWarehouseMapper.deleteByExample(example);
    }

    @Override
    public void insertApplicationParaSku(WhApplicatParaSku whApplicatParaSku) {
        this.whApplicatParaSkuMapper.insertSelective(whApplicatParaSku);
    }

    @Override
    public void deleteApplicationParaSku(String skuCode) {
        WhApplicatParaSkuExample example = new WhApplicatParaSkuExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode);
        this.whApplicatParaSkuMapper.deleteByExample(example);
    }

    @Override
    public List<WhApplicatParaSku> findAllWhApplicationParaSku() {
        WhApplicatParaSkuExample example = new WhApplicatParaSkuExample();
        return this.whApplicatParaSkuMapper.selectByExample(example);
    }

    @Override
    public List<WhPhysicalWarehouse> findPhysicalWarehouse() {
        WhPhysicalWarehouseExample example = new WhPhysicalWarehouseExample();
        example.createCriteria().andWarehouseStatusEqualTo(1);
        example.setOrderByClause("id");
        return this.whPhysicalWarehouseMapper.selectByExample(example);
    }

    @Override
    @Deprecated
    public WhPhysicalWarehouse findPhysicalWarehouseByWarehouse(String warehouseCode) {
        return this.whPhysicalWarehouseMapper.findPhysicalWarehouseByWarehouse(warehouseCode);
    }

    @Override
    public List<WhPhysicalWarehouse> findPhysicalWarehouseByWarehouseCodes(Set<String> warehouseCodeSet) {
        return this.whPhysicalWarehouseMapper.findPhysicalWarehouseByWarehouseCodes(warehouseCodeSet);
    }

    @Override
    public List<WhPhysicalWarehouse> findPhysicalWarehouseByWarehouseCodesNew(Set<String> warehouseCodeSet) {
        return this.whPhysicalWarehouseMapper.findPhysicalWarehouseByWarehouseCodesNew(warehouseCodeSet);
    }

    @Override
    @Transactional
    public String createWarehouse(WhPhysicalWarehouse whPhysicalWarehouse, WhWarehouse whWarehouse) {
        whWarehouse.setPhysicalWarehouseId(0L);
        whWarehouse.setWarehouseStatus(0);
        this.whWarehouseMapper.insert(whWarehouse);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("physicalWarehouseCode", this.generateParamCode(whWarehouse));
        params.put("id", whWarehouse.getId());
        String code = CodeGenerator.getInstance().generate("WAREHOUSE", params);
        whWarehouse.setCode(code);
        this.whWarehouseMapper.updateByPrimaryKeySelective(whWarehouse);
        return code;
    }

    private String generateParamCode(WhWarehouse whWarehouse) {
        Long id = whWarehouse.getId();
        StringBuffer idStr = new StringBuffer(id.toString());
        int idLength = idStr.length();
        if (idLength < 3) {
            while (3 - idLength > 0) {
                idStr.insert(0, "0");
                ++idLength;
            }
        }
        return "WH000" + idStr.toString() + whWarehouse.getWarehouseType().toString() + whWarehouse.getCommodityStatus();
    }

    @Override
    public boolean updateWarehouse(WhWarehouse whWarehouse) {
        WhWarehouse old = this.findWarehouseByCode(whWarehouse.getCode());
        whWarehouse.setId(old.getId());
        return this.whWarehouseMapper.updateByPrimaryKeySelective(whWarehouse) != 0;
    }

    @Override
    public boolean updateWarehouseByCode(String code, WhWarehouse whWarehouse) {
        WhWarehouse old = this.findWarehouseByCode(whWarehouse.getCode());
        whWarehouse.setId(old.getId());
        WhWarehouseExample example = new WhWarehouseExample();
        example.createCriteria().andCodeEqualTo(code);
        return this.whWarehouseMapper.updateByExampleSelective(whWarehouse, example) != 0;
    }

    @Override
    public boolean deleteWarehouse(WhWarehouse whWarehouse) {
        return this.whWarehouseMapper.deleteByPrimaryKey(whWarehouse.getId()) != 0;
    }

    @Override
    public WhWarehouse findWarehouseByCode(String code) {
        WhWarehouseExample example = new WhWarehouseExample();
        example.createCriteria().andCodeEqualTo(code);
        example.setOrderByClause("id");
        List<WhWarehouse> whWarehouseList = this.whWarehouseMapper.selectByExample(example);
        return whWarehouseList != null && !whWarehouseList.isEmpty() ? whWarehouseList.get(0) : null;
    }

    @Override
    public WhWarehouseVO findWarehouseAndGroupByWarehouseCode(String code) {
        List<WhWarehouseVO> whWarehouseList = this.whWarehouseMapper.findWarehouseAndGroupByWarehouseCode(code);
        return whWarehouseList != null && !whWarehouseList.isEmpty() ? whWarehouseList.get(0) : null;
    }

    @Override
    public List<WhWarehouseVO> findWarehouseAndGroupByWarehouseCodes(List<String> warehouseCode) {
        List<WhWarehouseVO> whWarehouseList = this.whWarehouseMapper.findWarehouseAndGroupByWarehouseCodes(warehouseCode);
        return whWarehouseList != null && !whWarehouseList.isEmpty() ? whWarehouseList : null;
    }

    @Override
    public List<WhWarehouse> findWarehouseByCodes(List<String> codes) {
        if (EmptyUtil.isEmpty(codes)) {
            return new ArrayList<WhWarehouse>();
        }
        WhWarehouseExample example = new WhWarehouseExample();
        example.createCriteria().andCodeIn((List)codes);
        example.setOrderByClause("CODE,ID");
        List<WhWarehouse> whWarehouseList = this.whWarehouseMapper.selectByExample(example);
        return whWarehouseList;
    }

    @Override
    public Map<String, WhWarehouseVO> findWarehouseMapByCodes(List<String> codes) {
        HashMap<String, WhWarehouseVO> map = new HashMap<String, WhWarehouseVO>();
        List<WhWarehouse> list = this.findWarehouseByCodes(codes);
        if (EmptyUtil.isNotEmpty(list)) {
            for (WhWarehouse warehouse : list) {
                map.put(warehouse.getCode(), (WhWarehouseVO)BeanUtil.buildFrom((Object)warehouse, WhWarehouseVO.class));
            }
        }
        return map;
    }

    @Override
    public List<WhWarehouseVO> findWarehouseByGroupId(List<Long> warehouseGroupIds) {
        if (EmptyUtil.isEmpty(warehouseGroupIds)) {
            return Collections.emptyList();
        }
        WhWarehouseExample example = new WhWarehouseExample();
        example.createCriteria().andWarehouseGroupIdIn((List)warehouseGroupIds);
        List<WhWarehouse> whWarehouseList = this.whWarehouseMapper.selectByExample(example);
        return BeanUtil.buildListFrom(whWarehouseList, WhWarehouseVO.class);
    }

    @Override
    public Map<Long, List<WhWarehouseVO>> findWarehouseMapByGroupId(List<Long> warehouseGroupIds) {
        List<WhWarehouseVO> warehouseList = this.findWarehouseByGroupId(warehouseGroupIds);
        HashMap<Long, List<WhWarehouseVO>> map = new HashMap<Long, List<WhWarehouseVO>>();
        if (EmptyUtil.isNotEmpty(warehouseList)) {
            for (WhWarehouseVO whWarehouse : warehouseList) {
                ArrayList<WhWarehouseVO> groupList = (ArrayList<WhWarehouseVO>)map.get(whWarehouse.getWarehouseGroupId());
                if (NullUtil.isNull((Object)groupList)) {
                    groupList = new ArrayList<WhWarehouseVO>();
                    map.put(whWarehouse.getWarehouseGroupId(), groupList);
                }
                groupList.add(whWarehouse);
            }
        }
        return map;
    }

    @Override
    public List<WhWarehouse> findGroupWarehouseSorted(String phyWhCode, Integer skuStatus) {
        return this.whWarehouseMapper.findGroupWarehouseSorted(phyWhCode, skuStatus);
    }

    @Override
    public Map<Integer, List<WhWarehouse>> findGroupWarehouseSortedMap(String phyWhCode, Integer skuStatus) {
        HashMap<Integer, List<WhWarehouse>> map = new HashMap<Integer, List<WhWarehouse>>();
        List<WhWarehouse> whList = this.findGroupWarehouseSorted(phyWhCode, skuStatus);
        if (EmptyUtil.isNotEmpty(whList)) {
            for (WhWarehouse wh : whList) {
                ArrayList<WhWarehouse> statusList = (ArrayList<WhWarehouse>)map.get(wh.getCommodityStatus());
                if (NullUtil.isNull((Object)statusList)) {
                    statusList = new ArrayList<WhWarehouse>();
                    map.put(wh.getCommodityStatus(), statusList);
                }
                statusList.add(wh);
            }
        }
        return map;
    }

    @Override
    public List<WhWarehouse> findWarehouseByCond(WhWarehouseCond cond) {
        return this.whWarehouseMapper.findWarehouseByCond(cond);
    }

    @Override
    public List<WhWarehouse> findWarehouseByNameCode(String nameOrCode) {
        nameOrCode = SQLUtils.allLike((String)nameOrCode);
        return this.whWarehouseMapper.findWarehouseByNameCode(nameOrCode);
    }

    @Override
    public List<WhWarehouse> findGroupWarehouseByNameCode(String nameOrCode, String physicalWarehouseCode, Boolean noPage) {
        if (EmptyUtil.isEmpty((String)physicalWarehouseCode)) {
            return Collections.emptyList();
        }
        if (EmptyUtil.isNotEmpty((String)nameOrCode)) {
            nameOrCode = SQLUtils.allLike((String)nameOrCode);
        }
        return this.whWarehouseMapper.findGroupWarehouseByNameCode(nameOrCode, physicalWarehouseCode, noPage);
    }

    @Override
    public List<WhWarehouse> findWarehouseByNameCodeAndType(String nameOrCode, Integer warehouseType) {
        nameOrCode = SQLUtils.allLike((String)nameOrCode);
        return this.whWarehouseMapper.findWarehouseByNameCodeAndType(nameOrCode, warehouseType);
    }

    @Override
    @Deprecated
    public List<WhWarehouse> findWarehouseByNameAndWaitForDispatchingFilter(String nameOrCode, Integer filterRuleType) {
        nameOrCode = SQLUtils.allLike((String)nameOrCode);
        return this.whWarehouseMapper.findWarehouseByNameCodeAndTypeFilter(nameOrCode, filterRuleType);
    }

    @Override
    @Deprecated
    public WhWarehouse findUniqWaitForDispatchingWarehouse(String warehouseCode) {
        return this.findUniqWarehouseByType(warehouseCode, WhWarehouseVO.TYPE_WAIT_FOR_DISPATCHING);
    }

    @Override
    @Deprecated
    public WhWarehouse findUniqDamagedWarehouse(String warehouseCode) {
        return this.findUniqWarehouseByType(warehouseCode, WhWarehouseVO.TYPE_DAMAGED);
    }

    @Override
    @Deprecated
    public WhWarehouse findUniqWastedWarehouse(String warehouseCode) {
        return this.findUniqWarehouseByType(warehouseCode, WhWarehouseVO.TYPE_WASTED);
    }

    @Override
    @Deprecated
    public WhWarehouse findUniqProducingWarehouse(String warehouseCode) {
        return this.findUniqWarehouseByType(warehouseCode, WhWarehouseVO.TYPE_PRODUCING);
    }

    @Override
    public boolean isInSamePhysicalWarehouse(String warehouseCode1, String warehouseCode2) {
        WhWarehouse warehouse1 = this.findWarehouseByCode(warehouseCode1);
        if (warehouse1 == null) {
            return false;
        }
        WhWarehouse warehouse2 = this.findWarehouseByCode(warehouseCode2);
        if (warehouse2 == null) {
            return false;
        }
        return warehouse1.getWarehouseGroupId().equals(warehouse2.getWarehouseGroupId());
    }

    @Override
    @Deprecated
    public boolean isWarehouseMove(String warehouseCode1, String warehouseCode2) {
        WhWarehouse warehouse1 = this.findWarehouseByCode(warehouseCode1);
        if (warehouse1 == null) {
            return false;
        }
        WhWarehouse warehouse2 = this.findWarehouseByCode(warehouseCode2);
        if (warehouse2 == null) {
            return false;
        }
        if (!warehouse1.getPhysicalWarehouseId().equals(warehouse2.getPhysicalWarehouseId())) {
            return false;
        }
        Integer warehouseType1 = warehouse1.getWarehouseType();
        Integer warehouseType2 = warehouse2.getWarehouseType();
        return !WhWarehouseVO.TYPE_DAMAGED.equals(warehouseType1) && !WhWarehouseVO.TYPE_DAMAGED.equals(warehouseType2) && !WhWarehouseVO.TYPE_WASTED.equals(warehouseType1) && !WhWarehouseVO.TYPE_WASTED.equals(warehouseType2) && !WhWarehouseVO.TYPE_PRODUCING.equals(warehouseType1) && !WhWarehouseVO.TYPE_PRODUCING.equals(warehouseType2);
    }

    @Override
    public boolean isWarehouseInSameWarehouseGroup(String warehouseCode1, String warehouseCode2) {
        WhWarehouse warehouse1 = this.findWarehouseByCode(warehouseCode1);
        WhWarehouse warehouse2 = this.findWarehouseByCode(warehouseCode2);
        return NullUtil.isNotNull((Object)warehouse1) && NullUtil.isNotNull((Object)warehouse2) && NullUtil.isNotNull((Object)warehouse1.getWarehouseGroupId()) && warehouse1.getWarehouseGroupId().equals(warehouse2.getWarehouseGroupId());
    }

    @Override
    public WhPhysicalWarehouse findPhysicalWarehouseByNo(String no) {
        WhPhysicalWarehouseExample example = new WhPhysicalWarehouseExample();
        example.createCriteria().andHouseNoEqualTo(no);
        List<WhPhysicalWarehouse> physicalHouse = this.whPhysicalWarehouseMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(physicalHouse)) {
            return null;
        }
        return physicalHouse.get(0);
    }

    @Override
    public List<WhPhysicalWarehouseVO> findNotRelatePhysicalWarehouses() {
        WhPhysicalWarehouseExample example = new WhPhysicalWarehouseExample();
        example.createCriteria().andWarehouseGroupIdIsNull();
        List<WhPhysicalWarehouse> physicalHouseList = this.whPhysicalWarehouseMapper.selectByExample(example);
        return BeanUtil.buildListFrom(physicalHouseList, WhPhysicalWarehouseVO.class);
    }

    @Override
    public List<WhWarehouseVO> findNotRelateWarehouses() {
        WhWarehouseExample example = new WhWarehouseExample();
        WhWarehouseExample.Criteria criteria = example.createCriteria();
        criteria.andWarehouseGroupIdIsNull();
        criteria.andWarehouseStatusEqualTo(1);
        List<WhWarehouse> list = this.whWarehouseMapper.selectByExample(example);
        return BeanUtil.buildListFrom(list, WhWarehouseVO.class);
    }

    @Override
    @Transactional
    public boolean physicalWarehouseRelateWarehouseGroup(List<String> physicalWarehouseCodes, Long warehouseGroupId) {
        HashSet<String> codes = new HashSet<String>();
        codes.addAll(physicalWarehouseCodes);
        int count = this.whPhysicalWarehouseMapper.physicalWarehouseRelateWarehouseGroup(codes, warehouseGroupId);
        return count == codes.size();
    }

    @Override
    @Transactional
    public boolean physicalWarehouseRelieveWarehouseGroup(Long warehouseGroupId) {
        this.whPhysicalWarehouseMapper.physicalWarehouseRelieveWarehouseGroup(warehouseGroupId);
        return true;
    }

    @Override
    @Transactional
    public boolean warehouseRelateWarehouseGroup(List<String> warehouseCodes, Long warehouseGroupId) {
        HashSet<String> codes = new HashSet<String>();
        codes.addAll(warehouseCodes);
        int count = this.whWarehouseMapper.warehouseRelateWarehouseGroup(codes, warehouseGroupId);
        return count == codes.size();
    }

    @Override
    @Transactional
    public boolean warehouseRelieveWarehouseGroup(Long warehouseGroupId) {
        this.whWarehouseMapper.warehouseRelieveWarehouseGroup(warehouseGroupId);
        return true;
    }

    @Override
    public boolean updateWhPhysicalWarehouseDeliveryNotice(Long whPhysicalWarehouseId, Integer needDeliveryNotice) {
        if (NullUtil.isNull((Object)whPhysicalWarehouseId)) {
            throw new WarehouseException("WH0002", "\u7269\u7406\u4ed3\u4e3a\u7a7a");
        }
        WhPhysicalWarehouse update = new WhPhysicalWarehouse();
        update.setId(whPhysicalWarehouseId);
        update.setDeliveryNotice(needDeliveryNotice);
        return this.whPhysicalWarehouseMapper.updateByPrimaryKeySelective(update) != 0;
    }

    @Override
    public List<WhWarehouse> findWarehouseByPhysicalCodeAndStatus(String physicWarehouseCode, Integer commodityStatus) {
        this.log.info("\u67e5\u8be2\u903b\u8f91\u4ed3\u7684\u53c2\u6570  pyhialCode={},commodityStatus={}", (Object)physicWarehouseCode, (Object)commodityStatus);
        List<WhWarehouse> whWarehouses = this.whWarehouseMapper.findWarehouseByPhysicalCodeAndStatus(physicWarehouseCode, commodityStatus, null);
        if (CollectionUtils.isEmpty(whWarehouses)) {
            throw new WarehouseException("WH0103", "\u7269\u7406\u4ed3[" + physicWarehouseCode + "],\u5546\u54c1\u72b6\u6001[" + WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(commodityStatus) + "],\u901a\u8fc7\u5206\u7ec4\u627e\u4e0d\u5230\u903b\u8f91\u4ed3\uff0c\u65e0\u6cd5\u521b\u5efa");
        }
        if (whWarehouses.size() > 2) {
            throw new WarehouseException("WH0001", "\u7269\u7406\u4ed3[" + physicWarehouseCode + "],\u5546\u54c1\u72b6\u6001[" + WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(commodityStatus) + "],\u901a\u8fc7\u5206\u7ec4\u627e\u5230\u591a\u4e2a\u903b\u8f91\u4ed3\uff0c\u65e0\u6cd5\u521b\u5efa");
        }
        return whWarehouses;
    }

    @Override
    public List<WhWarehouse> findAllWarehousesByPhyCodeAndStatus(String physicWarehouseCode, Integer commodityStatus, Integer relateType) {
        this.log.info("\u67e5\u8be2\u903b\u8f91\u4ed3\u7684\u53c2\u6570  pyhialCode={},commodityStatus={}", (Object)physicWarehouseCode, (Object)commodityStatus);
        List<WhWarehouse> whWarehouses = this.whWarehouseMapper.findWarehouseByPhysicalCodeAndStatus(physicWarehouseCode, commodityStatus, relateType);
        if (CollectionUtils.isEmpty(whWarehouses)) {
            throw new WarehouseException("WH0103", "\u7269\u7406\u4ed3[" + physicWarehouseCode + "],\u5546\u54c1\u72b6\u6001[" + WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(commodityStatus) + "],\u901a\u8fc7\u5206\u7ec4\u627e\u4e0d\u5230\u903b\u8f91\u4ed3\uff0c\u65e0\u6cd5\u521b\u5efa");
        }
        return whWarehouses;
    }

    @Override
    public List<WhWarehouse> listWarehousesByPhyCodeAndStatusFromGroup(String physicWarehouseCode, Integer commodityStatus) {
        this.log.info("\u67e5\u8be2\u903b\u8f91\u4ed3\u7684\u53c2\u6570  pyhialCode={},commodityStatus={}", (Object)physicWarehouseCode, (Object)commodityStatus);
        List<WhWarehouse> whWarehouses = this.whWarehouseMapper.listWarehousesByPhyCodeAndStatusFromGroup(physicWarehouseCode, commodityStatus);
        if (CollectionUtils.isEmpty(whWarehouses)) {
            throw new WarehouseException("WH0103", "\u7269\u7406\u4ed3[" + physicWarehouseCode + "],\u5546\u54c1\u72b6\u6001[" + WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(commodityStatus) + "],\u901a\u8fc7\u5206\u7ec4\u627e\u4e0d\u5230\u903b\u8f91\u4ed3\uff0c\u65e0\u6cd5\u521b\u5efa");
        }
        return whWarehouses;
    }

    @Override
    @Deprecated
    public List<String> findGoodWarehouseCode() {
        return this.whWarehouseMapper.findGoodWarehouseCode();
    }

    private WhWarehouse findUniqWarehouseByType(String warehouseCode, Integer warehouseType) {
        WhPhysicalWarehouse whPhysicalWarehouse = this.findPhysicalWarehouseByWarehouse(warehouseCode);
        if (whPhysicalWarehouse == null) {
            return null;
        }
        WhWarehouseCond cond = new WhWarehouseCond();
        cond.setPhysicalWarehouseCode(whPhysicalWarehouse.getCode());
        cond.setWarehouseType(warehouseType);
        List<WhWarehouse> whWarehouseList = this.findWarehouseByCond(cond);
        if (EmptyUtil.isEmpty(whWarehouseList)) {
            return null;
        }
        if (whWarehouseList.size() > 1) {
            throw new WarehouseException("WH0100", "\u540c\u7269\u7406\u4ed3\u53ea\u80fd\u6709\u4e00\u4e2a\u5f53\u524d\u7c7b\u578b\u7684\u903b\u8f91\u4ed3");
        }
        return whWarehouseList.get(0);
    }

    private WhPhysicalWarehouseRelateWarehouseVO buildWarehouseRelateCond(String physicalWarehouseCode, Integer type, Integer skuStatus) {
        Validation.paramNotNull((Object)physicalWarehouseCode, (String)"\u7269\u7406\u4ed3\u7f16\u7801\u4e3a\u7a7a");
        Validation.paramNotNull((Object)type, (String)"\u51fa\u5165\u5e93\u7c7b\u578b\u4e3a\u7a7a");
        Validation.paramNotNull((Object)skuStatus, (String)"SKU\u72b6\u6001\u4e3a\u7a7a");
        WhPhysicalWarehouseRelateWarehouseVO cond = new WhPhysicalWarehouseRelateWarehouseVO();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setType(type);
        cond.setSkuStatus(skuStatus);
        return cond;
    }

    @Override
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultOutNondefectiveWarehouseByPyCode(String physicalWarehouseCode) {
        WhPhysicalWarehouseRelateWarehouseVO cond = this.buildWarehouseRelateCond(physicalWarehouseCode, WhWarehouseVO.RELATE_OUT, WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        List<WhPhysicalWarehouseRelateWarehouseVO> vos = this.findPhysicalWarehouseRelateWarehouseByCond(cond);
        if (CollectionUtils.isEmpty(vos)) {
            return null;
        }
        return vos.get(0);
    }

    @Override
    public WhWarehouse findDefaultInNondefectiveWarehouseByPhyWhCode(String physicalWarehouseCode) {
        return this.findDefaultInOrOutWarehouseByPhyWhCode(physicalWarehouseCode, WhWarehouseVO.RELATE_IN, WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
    }

    @Override
    public WhWarehouse findDefaultInDefectiveWarehouseByPhyWhCode(String physicalWarehouseCode) {
        return this.findDefaultInOrOutWarehouseByPhyWhCode(physicalWarehouseCode, WhWarehouseVO.RELATE_IN, WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
    }

    @Override
    public WhWarehouse findDefaultInWarehouseByPhyWhCodeAndCommodityStatus(String physicalWarehouseCode, Integer commodityStatus) {
        return this.findDefaultInOrOutWarehouseByPhyWhCode(physicalWarehouseCode, WhWarehouseVO.RELATE_IN, commodityStatus);
    }

    @Override
    public WhWarehouse findDefaultOutWarehouseByPhyWhCodeAndCommodityStatus(String physicalWarehouseCode, Integer commodityStatus) {
        return this.findDefaultInOrOutWarehouseByPhyWhCode(physicalWarehouseCode, WhWarehouseVO.RELATE_OUT, commodityStatus);
    }

    @Override
    public WhWarehouse findDefaultOutNondefectiveWarehouseByPhyWhCode(String physicalWarehouseCode) {
        return this.findDefaultInOrOutWarehouseByPhyWhCode(physicalWarehouseCode, WhWarehouseVO.RELATE_OUT, WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
    }

    @Override
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultOutDefectiveWarehouseByPyCode(String physicalWarehouseCode) {
        WhPhysicalWarehouseRelateWarehouseVO cond = this.buildWarehouseRelateCond(physicalWarehouseCode, WhWarehouseVO.RELATE_OUT, WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
        List<WhPhysicalWarehouseRelateWarehouseVO> vos = this.findPhysicalWarehouseRelateWarehouseByCond(cond);
        if (CollectionUtils.isEmpty(vos)) {
            return null;
        }
        return vos.get(0);
    }

    @Override
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultOutSampleWarehouseByPyCode(String physicalWarehouseCode) {
        WhPhysicalWarehouseRelateWarehouseVO cond = this.buildWarehouseRelateCond(physicalWarehouseCode, WhWarehouseVO.RELATE_OUT, WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE);
        List<WhPhysicalWarehouseRelateWarehouseVO> vos = this.findPhysicalWarehouseRelateWarehouseByCond(cond);
        if (CollectionUtils.isEmpty(vos)) {
            return null;
        }
        return vos.get(0);
    }

    @Override
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultOutWasteWarehouseByPyCode(String physicalWarehouseCode) {
        WhPhysicalWarehouseRelateWarehouseVO cond = this.buildWarehouseRelateCond(physicalWarehouseCode, WhWarehouseVO.RELATE_OUT, WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED);
        List<WhPhysicalWarehouseRelateWarehouseVO> vos = this.findPhysicalWarehouseRelateWarehouseByCond(cond);
        if (CollectionUtils.isEmpty(vos)) {
            return null;
        }
        return vos.get(0);
    }

    @Override
    public WhWarehouse findDefaultInOrOutWarehouseByPhyWhCode(String physicalWarehouseCode, Integer inOrOut, Integer skuStatus) {
        return this.whWarehouseMapper.findDefaultInOrOutWarehouseByPhyWhCode(physicalWarehouseCode, inOrOut, skuStatus);
    }

    @Override
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInNondefectiveWarehouseByPyCode(String physicalWarehouseCode) {
        WhPhysicalWarehouseRelateWarehouseVO cond = this.buildWarehouseRelateCond(physicalWarehouseCode, WhWarehouseVO.RELATE_IN, WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        List<WhPhysicalWarehouseRelateWarehouseVO> vos = this.findPhysicalWarehouseRelateWarehouseByCond(cond);
        if (CollectionUtils.isEmpty(vos)) {
            return null;
        }
        return vos.get(0);
    }

    @Override
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInDefectiveWarehouseByPyCode(String physicalWarehouseCode) {
        WhPhysicalWarehouseRelateWarehouseVO cond = this.buildWarehouseRelateCond(physicalWarehouseCode, WhWarehouseVO.RELATE_IN, WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
        List<WhPhysicalWarehouseRelateWarehouseVO> vos = this.findPhysicalWarehouseRelateWarehouseByCond(cond);
        if (CollectionUtils.isEmpty(vos)) {
            return null;
        }
        return vos.get(0);
    }

    @Override
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInSampleWarehouseByPyCode(String physicalWarehouseCode) {
        WhPhysicalWarehouseRelateWarehouseVO cond = this.buildWarehouseRelateCond(physicalWarehouseCode, WhWarehouseVO.RELATE_IN, WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE);
        List<WhPhysicalWarehouseRelateWarehouseVO> vos = this.findPhysicalWarehouseRelateWarehouseByCond(cond);
        if (CollectionUtils.isEmpty(vos)) {
            return null;
        }
        return vos.get(0);
    }

    @Override
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInWasteWarehouseByPyCode(String physicalWarehouseCode) {
        WhPhysicalWarehouseRelateWarehouseVO cond = this.buildWarehouseRelateCond(physicalWarehouseCode, WhWarehouseVO.RELATE_IN, WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED);
        List<WhPhysicalWarehouseRelateWarehouseVO> vos = this.findPhysicalWarehouseRelateWarehouseByCond(cond);
        if (CollectionUtils.isEmpty(vos)) {
            return null;
        }
        return vos.get(0);
    }

    @Override
    public WhPhysicalWarehouseRelateWarehouseVO findDefaultInDisplayWarehouseByPyCode(String physicalWarehouseCode) {
        WhPhysicalWarehouseRelateWarehouseVO cond = this.buildWarehouseRelateCond(physicalWarehouseCode, WhWarehouseVO.RELATE_IN, WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY);
        List<WhPhysicalWarehouseRelateWarehouseVO> vos = this.findPhysicalWarehouseRelateWarehouseByCond(cond);
        if (CollectionUtils.isEmpty(vos)) {
            return null;
        }
        return vos.get(0);
    }

    @Override
    public List<WhPhysicalWarehouseRelateWarehouseVO> findPhysicalWarehouseRelateWarehouseByCond(WhPhysicalWarehouseRelateWarehouseVO cond) {
        return this.whPhysicalWarehouseRelateWarehouseCustomMapper.findPhysicalWarehouseRelateByCond(cond);
    }

    @Override
    public WhPhysicalWarehouse findPhysicalWarehouseByWarehouseGroupCond(String warehouseCode, Integer relateInOrOut) {
        WhWarehouse targetWhWarehouse = this.findWarehouseByCode(warehouseCode);
        Validation.paramNotNull((Object)targetWhWarehouse, (String)"\u903b\u8f91\u4ed3\u4e3a\u7a7a");
        WhPhysicalWarehouseRelateWarehouseVO cond = new WhPhysicalWarehouseRelateWarehouseVO();
        cond.setWarehouseCode(warehouseCode);
        cond.setSkuStatus(WhWarehouseVO.convertSkuStatusByCommodityStatus(targetWhWarehouse.getCommodityStatus()));
        cond.setType(relateInOrOut);
        List<WhPhysicalWarehouseRelateWarehouseVO> warehouseRelateWarehouseVos = this.findPhysicalWarehouseRelateWarehouseByCond(cond);
        if (CollectionUtils.isEmpty(warehouseRelateWarehouseVos)) {
            throw new WarehouseException("WH0103", "\u903b\u8f91\u4ed3[" + cond.getWarehouseCode() + "],SKU\u72b6\u6001[" + WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus()) + "],\u7c7b\u578b[" + WhWarehouseVO.RELATE_MAP.get(cond.getType()) + "] \u627e\u4e0d\u5230\u7269\u7406\u4ed3\uff0c\u65e0\u6cd5\u521b\u5efa");
        }
        if (warehouseRelateWarehouseVos.size() > 1) {
            throw new WarehouseException("WH0001", "\u903b\u8f91\u4ed3[" + cond.getWarehouseCode() + "],SKU\u72b6\u6001[" + WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus()) + "],\u7c7b\u578b[" + WhWarehouseVO.RELATE_MAP.get(cond.getType()) + "] \u5b58\u5728\u591a\u4e2a\u7269\u7406\u4ed3\uff0c\u65e0\u6cd5\u521b\u5efa");
        }
        WhPhysicalWarehouse physicalWarehouse = this.findPhysicalWarehouseByCode(warehouseRelateWarehouseVos.get(0).getPhysicalWarehouseCode());
        Validation.paramNotNull((Object)physicalWarehouse, (String)"\u7269\u7406\u4ed3\u4e0d\u5b58\u5728");
        return physicalWarehouse;
    }

    @Override
    public List<WhPhysicalWarehouse> findPhysicalWarehouseByType(List<Integer> warehouseTypeList) {
        return this.whPhysicalWarehouseMapper.findPhysicalWarehouseByType(warehouseTypeList);
    }

    @Override
    public Map<String, WhPhysicalWarehouse> findPhyWhMapByWarehouseCodes(List<String> warehouseCodeList) {
        HashMap<String, WhPhysicalWarehouse> whPhysicalWarehouseMap = new HashMap<String, WhPhysicalWarehouse>();
        List<WhPhysicalWarehouse> physicalWarehouseList = this.whPhysicalWarehouseMapper.findPhysicalWhByWarehouseCodes(warehouseCodeList);
        if (EmptyUtil.isNotEmpty(warehouseCodeList)) {
            this.checkRepeatPhysicalWh(physicalWarehouseList, this.findWarehouseByCodes(warehouseCodeList));
            int listSize = warehouseCodeList.size();
            for (int i = 0; i < listSize; ++i) {
                whPhysicalWarehouseMap.put(warehouseCodeList.get(i).toString(), physicalWarehouseList.get(i));
            }
        }
        return whPhysicalWarehouseMap;
    }

    private void checkRepeatPhysicalWh(List<WhPhysicalWarehouse> physicalWarehouseList, List<WhWarehouse> whWarehouseList) {
        int listSize = whWarehouseList.size();
        int physicalWhSize = physicalWarehouseList.size();
        int j = 0;
        for (int i = 0; i < listSize; ++i) {
            WhWarehouse whWarehouse = whWarehouseList.get(i);
            Long groupId = whWarehouse.getWarehouseGroupId();
            int physicalWhCnt = 0;
            while (j < physicalWhSize) {
                if (groupId.equals(physicalWarehouseList.get(j).getWarehouseGroupId())) {
                    ++physicalWhCnt;
                }
                if (physicalWhCnt > 1) {
                    throw new WarehouseException("WH0002", "[" + whWarehouse.getCode() + "]" + whWarehouse.getName() + ", \u5b58\u5728\u591a\u4e2a\u7269\u7406\u4ed3");
                }
                ++j;
            }
        }
    }

    @Override
    public List<WhWarehouseVO> findWarehouseByGroupId(Long warehouseGroupId) {
        if (EmptyUtil.isEmpty((Object)warehouseGroupId)) {
            return Collections.emptyList();
        }
        WhWarehouseExample example = new WhWarehouseExample();
        example.createCriteria().andWarehouseGroupIdEqualTo(warehouseGroupId);
        List<WhWarehouse> whWarehouseList = this.whWarehouseMapper.selectByExample(example);
        return BeanUtil.buildListFrom(whWarehouseList, WhWarehouseVO.class);
    }

    @Override
    public List<WhPhysicalWarehouseVO> findPhysicalWarehouseByWarehouseCode(String warehouseCode) {
        return this.whPhysicalWarehouseMapper.findPhysicalWarehouseByWarehouseCode(warehouseCode);
    }

    @Override
    public List<WhPhysicalWarehouseVO> findRelatePhysicalWarehouseByWarehouseCode(String warehouseCode, Integer inOrOut, Integer skuStatus) {
        return this.whPhysicalWarehouseMapper.findRelatePhysicalWarehouseByWarehousCode(warehouseCode, inOrOut, skuStatus);
    }

    private void checkWarehouseArchiveToPhysicalWarehouse(WhPhysicalWarehouse whPhysicalWarehouse, WhWarehouse whWarehouse) {
        Integer warehouseType;
        boolean check = false;
        if (check && (WhWarehouseVO.TYPE_WAIT_FOR_DISPATCHING.equals(warehouseType = whWarehouse.getWarehouseType()) || WhWarehouseVO.TYPE_DAMAGED.equals(warehouseType) || WhWarehouseVO.TYPE_WASTED.equals(warehouseType) || WhWarehouseVO.TYPE_PRODUCING.equals(warehouseType))) {
            WhWarehouseExample example = new WhWarehouseExample();
            WhWarehouseExample.Criteria criteria = example.createCriteria().andPhysicalWarehouseIdEqualTo(whPhysicalWarehouse.getId()).andWarehouseTypeEqualTo(warehouseType);
            if (whWarehouse.getId() != null) {
                criteria.andIdNotEqualTo(whWarehouse.getId());
            }
            if (EmptyUtil.isNotEmpty(this.whWarehouseMapper.selectByExample(example))) {
                throw new WarehouseException("WH0100", "\u540c\u7269\u7406\u4ed3\u53ea\u80fd\u6709\u4e00\u4e2a\u5f53\u524d\u7c7b\u578b\u7684\u903b\u8f91\u4ed3");
            }
        }
    }
}

