/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.service.warehouse.cond.WhGradeAffectInfoCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhGradeOfQualityCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhGradeOfQualityDetailCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWarehouseGroupCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhGradeAffectInfoMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhGradeOfQualityDetailMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhGradeOfQualityMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhGradeOfQualityCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhGradeAffectInfo;
import com.thebeastshop.pegasus.service.warehouse.model.WhGradeAffectInfoExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhGradeOfQuality;
import com.thebeastshop.pegasus.service.warehouse.model.WhGradeOfQualityDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhGradeOfQualityDetailExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhGradeOfQualityExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvOccupy;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvRcd;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhGradeOfQualityService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInvService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWarehouseGroupService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsGradeOfQualityService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhGradeAffectInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhGradeOfQualityDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhGradeOfQualityVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhGradeTmallInfo;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhReleaseOccupationVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseGroupVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsGradeOfQualityVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.Constants;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import com.thebeastshop.stock.dto.SStockOccupyDTO;
import com.thebeastshop.stock.enums.SStockOccupyTypeEnum;
import com.thebeastshop.stock.enums.SStockOperationTypeEnum;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SOccupyResultVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Service(value="whGradeOfQualityService")
public class WhGradeOfQualityServiceImpl
implements WhGradeOfQualityService {
    private static final Logger log = LoggerFactory.getLogger(WhGradeOfQualityServiceImpl.class);
    @Autowired
    private WhGradeOfQualityMapper whGradeOfQualityMapper;
    @Autowired
    private WhGradeOfQualityDetailMapper whGradeOfQualityDetailMapper;
    @Autowired
    private WhGradeAffectInfoMapper whGradeAffectInfoMapper;
    @Autowired
    private WhGradeOfQualityCustomMapper whGradeOfQualityCustomMapper;
    @Autowired
    private SStockService sStockService;
    @Autowired
    private WhInvService whInvService;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhWmsGradeOfQualityService whWmsGradeOfQualityService;
    @Autowired
    private TaskExecutor gradeAdjustScheduler;
    @Autowired
    private WhWarehouseGroupService whWarehouseGroupService;

    @Override
    public Pagination<WhGradeOfQualityVO> pageWhGradeOfQualityVOByCond(WhGradeOfQualityCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int count = this.countWhGradeOfQuality(cond);
        page.setRecord(Integer.valueOf(count));
        if (NumberUtil.isNullOrZero((Number)count)) {
            return page;
        }
        List<WhGradeOfQualityVO> gradeOfQualityVOs = this.whGradeOfQualityCustomMapper.listWhGradeOfQualityVOByCond(cond);
        page.setResultList(gradeOfQualityVOs);
        return page;
    }

    private int countWhGradeOfQuality(WhGradeOfQualityCond cond) {
        return this.whGradeOfQualityCustomMapper.countWhGradeOfQualityByCond(cond);
    }

    @Override
    public WhGradeOfQualityVO findWhGradeOfQualityVOById(Long id, WhGradeOfQualityCond cond) {
        WhGradeOfQualityVO vo = this.whGradeOfQualityCustomMapper.findVOById(id);
        if (EmptyUtil.isNotEmpty((Object)vo)) {
            this.fetchGradeDetailVO(vo, cond.isFetchGradeDetail());
            this.fetchGradeAppectInfo(vo, cond.isFetchGradeAppectInfo());
        }
        return vo;
    }

    public WhGradeOfQualityVO findWhGradeOfQualityVOById(Long id, boolean fetchDetail, boolean fetchAffect) {
        WhGradeOfQualityVO vo = this.whGradeOfQualityCustomMapper.findVOById(id);
        if (EmptyUtil.isNotEmpty((Object)vo)) {
            if (fetchDetail) {
                WhGradeOfQualityDetailCond cond = new WhGradeOfQualityDetailCond();
                cond.setRefId(id);
                vo.setWhGradeDetails(this.listWhGradeOfQualityDetailByCond(cond));
            }
            if (fetchAffect) {
                vo.setWhGradeAffectInfos(this.listWhGradeAffectInfoByWhGradeId(id));
            }
        }
        return vo;
    }

    @Override
    public List<WhGradeAffectInfo> listWhGradeAffectInfoByWhGradeId(Long whGradeId) {
        WhGradeAffectInfoCond cond = new WhGradeAffectInfoCond();
        cond.setWhGradeId(whGradeId);
        return this.listWhGradeAffectInfoByCond(cond);
    }

    @Override
    public List<WhGradeOfQualityDetail> listWhGradeOfQualityDetailByCond(WhGradeOfQualityDetailCond cond) {
        WhGradeOfQualityDetailExample example = this.buildWhGradeOfQualityDetailExampleByCond(cond);
        return this.whGradeOfQualityDetailMapper.selectByExample(example);
    }

    @Override
    public List<WhGradeAffectInfo> listWhGradeAffectInfoByCond(WhGradeAffectInfoCond cond) {
        WhGradeAffectInfoExample example = this.buildWhGradeAffectInfoExampleByCond(cond);
        return this.whGradeAffectInfoMapper.selectByExample(example);
    }

    @Override
    public List<WhGradeAffectInfoVO> listWhGradeAffectInfoVOByCond(WhGradeAffectInfoCond cond) {
        return this.whGradeOfQualityCustomMapper.listWhGradeAffectInfoVOByCond(cond);
    }

    private void fetchGradeDetailVO(WhGradeOfQualityVO vo, boolean fetchGradeDetail) {
        if (fetchGradeDetail) {
            WhGradeOfQualityDetailCond detailCond = new WhGradeOfQualityDetailCond();
            detailCond.setRefId(vo.getId());
            List<WhGradeOfQualityDetailVO> gradeDetailVOs = this.whGradeOfQualityCustomMapper.listWhGradeOfQualityDetailVOByCond(detailCond);
            vo.setWhGradeDetailVOs(gradeDetailVOs);
        }
    }

    @Override
    public boolean updateWhGradeAffectInfo(WhGradeAffectInfo affectInfo) {
        return this.whGradeAffectInfoMapper.updateByPrimaryKeySelective(affectInfo) > 0;
    }

    @Override
    public boolean updateWhGradeAffectInfoOptFlag(List<Long> ids, Integer newOptFlag, Integer oldOptFlag) {
        return this.whGradeOfQualityCustomMapper.updateWhGradeAffectInfoOptFlag(ids, newOptFlag, oldOptFlag);
    }

    @Override
    public boolean updateWhGradeAffectInfoSendMailFlag(List<Long> affectIds, Integer newSendMailFlag, Integer oldSendMailFlag) {
        WhGradeAffectInfo affectInfo = new WhGradeAffectInfo();
        affectInfo.setSendMailFlag(newSendMailFlag);
        WhGradeAffectInfoCond affectCond = new WhGradeAffectInfoCond();
        affectCond.setIds(affectIds);
        affectCond.setSendMailFlag(oldSendMailFlag);
        return this.updateWhGradeAffectInfoByExampleSelective(affectInfo, affectCond);
    }

    @Override
    public boolean updateWhGradeAffectInfoByExampleSelective(WhGradeAffectInfo affectInfo, WhGradeAffectInfoCond affectCond) {
        WhGradeAffectInfoExample example = this.buildWhGradeAffectInfoExampleByCond(affectCond);
        return this.whGradeAffectInfoMapper.updateByExampleSelective(affectInfo, example) > 0;
    }

    public boolean updateWhGradeAffectInfoByExample(WhGradeAffectInfo affectInfo, WhGradeAffectInfoExample example) {
        return this.whGradeAffectInfoMapper.updateByExample(affectInfo, example) > 0;
    }

    private void fetchGradeAppectInfo(WhGradeOfQualityVO vo, boolean fetchGradeAppectInfo) {
        if (fetchGradeAppectInfo) {
            WhGradeAffectInfoCond cond = new WhGradeAffectInfoCond();
            cond.setWhGradeId(vo.getId());
            WhGradeAffectInfoExample example = this.buildWhGradeAffectInfoExampleByCond(cond);
            List<WhGradeAffectInfo> whGradeAffectInfos = this.whGradeAffectInfoMapper.selectByExample(example);
            vo.setWhGradeAffectInfos(whGradeAffectInfos);
        }
    }

    @Override
    public WhGradeOfQualityVO findWhGradeOfQualityVOByCond(WhGradeOfQualityCond cond) {
        WhGradeOfQualityExample example = this.buildWhGradeOfQualityExampleByCond(cond);
        List<WhGradeOfQuality> gradeOfQualities = this.whGradeOfQualityMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(gradeOfQualities)) {
            WhGradeOfQualityVO vo = (WhGradeOfQualityVO)BeanUtil.buildFrom((Object)gradeOfQualities.get(0), WhGradeOfQualityVO.class);
            this.fetchGradeDetailVO(vo, cond.isFetchGradeDetail());
            this.fetchGradeAppectInfo(vo, cond.isFetchGradeAppectInfo());
            return vo;
        }
        return null;
    }

    @Override
    public List<WhGradeOfQualityVO> listWhGradeOfQualityVOByCond(WhGradeOfQualityCond cond) {
        WhGradeOfQualityExample example = this.buildWhGradeOfQualityExampleByCond(cond);
        List<WhGradeOfQuality> gradeOfQualities = this.whGradeOfQualityMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(gradeOfQualities)) {
            ArrayList<WhGradeOfQualityVO> whGradeOfQualityVOs = new ArrayList<WhGradeOfQualityVO>();
            for (WhGradeOfQuality whGrade : gradeOfQualities) {
                WhGradeOfQualityVO vo = (WhGradeOfQualityVO)BeanUtil.buildFrom((Object)whGrade, WhGradeOfQualityVO.class);
                this.fetchGradeDetailVO(vo, cond.isFetchGradeDetail());
                this.fetchGradeAppectInfo(vo, cond.isFetchGradeAppectInfo());
                whGradeOfQualityVOs.add(vo);
            }
            return whGradeOfQualityVOs;
        }
        return Collections.emptyList();
    }

    @Override
    public List<WhGradeOfQualityVO> listWhGradeOfQualityVOsByCond(WhGradeOfQualityCond cond) {
        return this.whGradeOfQualityCustomMapper.listWhGradeOfQualityVOByCond(cond);
    }

    private WhGradeOfQualityExample buildWhGradeOfQualityExampleByCond(WhGradeOfQualityCond cond) {
        WhGradeOfQualityExample example = new WhGradeOfQualityExample();
        WhGradeOfQualityExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)cond.getId())) {
            criteria.andIdEqualTo(cond.getId());
        } else if (CollectionUtils.isNotEmpty(cond.getIds())) {
            criteria.andIdIn((List)cond.getIds());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getRefId())) {
            criteria.andRefIdEqualTo(cond.getRefId());
        } else if (CollectionUtils.isNotEmpty(cond.getRefIds())) {
            criteria.andRefIdIn((List)cond.getRefIds());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getRefCode())) {
            criteria.andRefCodeEqualTo(cond.getRefCode());
        } else if (CollectionUtils.isNotEmpty(cond.getRefCodes())) {
            criteria.andRefCodeIn((List)cond.getRefCodes());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getSkuCode())) {
            criteria.andSkuCodeEqualTo(cond.getSkuCode());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getSourceGrade())) {
            criteria.andSourceGradeEqualTo(cond.getSourceGrade());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getTargetGrade())) {
            criteria.andTargetGradeEqualTo(cond.getTargetGrade());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getPhysicalWarehouseCode())) {
            criteria.andPhysicalWarehouseCodeEqualTo(cond.getPhysicalWarehouseCode());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getApproveStatus())) {
            criteria.andApproveStatusEqualTo(cond.getApproveStatus());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getCreateTimeStart())) {
            criteria.andCreateTimeGreaterThanOrEqualTo(DateUtil.parse((String)cond.getCreateTimeStart(), (String)"yyyy-MM-dd"));
        }
        if (EmptyUtil.isNotEmpty((String)cond.getCreateTimeEnd())) {
            criteria.andCreateTimeLessThanOrEqualTo(DateUtil.parse((String)cond.getCreateTimeEnd(), (String)"yyyy-MM-dd"));
        }
        if (EmptyUtil.isNotEmpty((String)cond.getApproveTimeStart())) {
            criteria.andApproveTimeGreaterThanOrEqualTo(DateUtil.parse((String)cond.getApproveTimeStart(), (String)"yyyy-MM-dd"));
        }
        if (EmptyUtil.isNotEmpty((String)cond.getApproveTimeEnd())) {
            criteria.andApproveTimeLessThanOrEqualTo(DateUtil.parse((String)cond.getApproveTimeEnd(), (String)"yyyy-MM-dd"));
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getCreateUserId())) {
            criteria.andCreateUserIdEqualTo(cond.getCreateUserId());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getApproveUserId())) {
            criteria.andApproveUserIdEqualTo(cond.getApproveUserId());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getOriginType())) {
            criteria.andOriginTypeEqualTo(cond.getOriginType());
        }
        return example;
    }

    private WhGradeOfQualityDetailExample buildWhGradeOfQualityDetailExampleByCond(WhGradeOfQualityDetailCond cond) {
        WhGradeOfQualityDetailExample example = new WhGradeOfQualityDetailExample();
        WhGradeOfQualityDetailExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)cond.getId())) {
            criteria.andIdEqualTo(cond.getId());
        } else if (CollectionUtils.isNotEmpty(cond.getIds())) {
            criteria.andIdIn((List)cond.getIds());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getRefId())) {
            criteria.andRefIdEqualTo(cond.getRefId());
        } else if (CollectionUtils.isNotEmpty(cond.getRefIds())) {
            criteria.andRefIdIn((List)cond.getRefIds());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getWmsGradeId())) {
            criteria.andWmsGradeIdEqualTo(cond.getWmsGradeId());
        } else if (CollectionUtils.isNotEmpty(cond.getWmsGradeIds())) {
            criteria.andWmsGradeIdIn((List)cond.getWmsGradeIds());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getWmsGradeSkuId())) {
            criteria.andWmsGradeSkuIdEqualTo(cond.getWmsGradeSkuId());
        } else if (CollectionUtils.isNotEmpty(cond.getWmsGradeSkuIds())) {
            criteria.andWmsGradeSkuIdIn((List)cond.getWmsGradeSkuIds());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getSkuCode())) {
            criteria.andSkuCodeEqualTo(cond.getSkuCode());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getApproveStatus())) {
            criteria.andApproveStatusEqualTo(cond.getApproveStatus());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getSourceWarehouseCode())) {
            criteria.andSourceWarehouseCodeEqualTo(cond.getSourceWarehouseCode());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getTargetWarehouseCode())) {
            criteria.andTargetWarehouseCodeEqualTo(cond.getTargetWarehouseCode());
        }
        return example;
    }

    private WhGradeAffectInfoExample buildWhGradeAffectInfoExampleByCond(WhGradeAffectInfoCond cond) {
        WhGradeAffectInfoExample example = new WhGradeAffectInfoExample();
        WhGradeAffectInfoExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)cond.getId())) {
            criteria.andIdEqualTo(cond.getId());
        } else if (CollectionUtils.isNotEmpty(cond.getIds())) {
            criteria.andIdIn((List)cond.getIds());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getWhGradeId())) {
            criteria.andWhGradeIdEqualTo(cond.getWhGradeId());
        } else if (CollectionUtils.isNotEmpty(cond.getWhGradeIds())) {
            criteria.andWhGradeIdIn((List)cond.getWhGradeIds());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getType())) {
            criteria.andTypeEqualTo(cond.getType());
        } else if (CollectionUtils.isNotEmpty(cond.getTypes())) {
            criteria.andTypeIn((List)cond.getTypes());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getAffectCode())) {
            criteria.andAffectCodeEqualTo(cond.getAffectCode());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getWarehouseCode())) {
            criteria.andWarehouseCodeEqualTo(cond.getWarehouseCode());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getOptFlag())) {
            criteria.andOptFlagEqualTo(cond.getOptFlag());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getWhGradeStatus())) {
            criteria.andWhGradeStatusEqualTo(cond.getWhGradeStatus());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getSendMailFlag())) {
            criteria.andSendMailFlagEqualTo(cond.getSendMailFlag());
        }
        return example;
    }

    @Override
    public List<WhGradeOfQuality> listWhGradeOfQualityByCond(WhGradeOfQualityCond cond) {
        WhGradeOfQualityExample example = this.buildWhGradeOfQualityExampleByCond(cond);
        return this.whGradeOfQualityMapper.selectByExample(example);
    }

    @Override
    @Transactional
    public boolean create(WhGradeOfQualityVO vo) throws Exception {
        WhGradeOfQuality gradeOfQuality = (WhGradeOfQuality)BeanUtil.buildFrom((Object)vo, WhGradeOfQuality.class);
        gradeOfQuality.setCreateTime(DateUtil.getNow());
        int result = this.whGradeOfQualityMapper.insert(gradeOfQuality);
        vo.setId(gradeOfQuality.getId());
        if (result > 0) {
            this.insertGradeDetails(vo);
            HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
            params.put("createTime", gradeOfQuality.getCreateTime());
            params.put("sourceGrade", gradeOfQuality.getSourceGrade());
            params.put("id", gradeOfQuality.getId());
            String code = CodeGenerator.getInstance().generate("GA_CODE", params);
            gradeOfQuality.setCode(code);
            this.whGradeOfQualityMapper.updateByPrimaryKeySelective(gradeOfQuality);
            vo.setCode(code);
        }
        return result > 0;
    }

    @Override
    public boolean batchCreateWhGradeAndFetch(List<WhGradeOfQualityVO> vos) throws Exception {
        boolean result = false;
        for (WhGradeOfQualityVO vo : vos) {
            result = this.createOrUpdate(vo);
        }
        return result;
    }

    @Override
    @Transactional
    public boolean createOrUpdate(WhGradeOfQualityVO vo) throws Exception {
        boolean result = false;
        result = EmptyUtil.isNotEmpty((Object)vo.getId()) && EmptyUtil.isNotEmpty((Object)this.whGradeOfQualityMapper.selectByPrimaryKey(vo.getId())) ? this.update(vo) : this.create(vo);
        if (result && 1 == vo.getApproveStatus()) {
            this.scmOccupy(vo);
            this.insertGradeAffectInfos(vo);
        }
        return result;
    }

    @Override
    @Transactional
    public boolean auditWhGradeOfQuality(WhGradeOfQualityVO vo) throws Exception {
        WhGradeOfQuality whGradeOfQuality = this.whGradeOfQualityMapper.selectByPrimaryKey(vo.getId());
        if (EmptyUtil.isEmpty((Object)whGradeOfQuality)) {
            throw new WarehouseException("WH0001", "\u54c1\u7ea7\u8c03\u6574\u5355\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u5904\u7406!");
        }
        if (1 != whGradeOfQuality.getApproveStatus()) {
            throw new WarehouseException("WH0001", "\u54c1\u7ea7\u8c03\u6574\u72b6\u6001\u4e0d\u662f[\u5f85\u5ba1\u6279],\u8bf7\u786e\u8ba4\u72b6\u6001\u540e\u91cd\u65b0\u5904\u7406!");
        }
        WhWmsGradeOfQualityVO whWmsGradeOfQualityVO = this.whWmsGradeOfQualityService.findWhWmsGradeOfQualityVOById(whGradeOfQuality.getRefId(), false, false);
        boolean optPass = vo.getOptPass();
        WhGradeOfQualityVO whGradeVo = this.findWhGradeOfQualityVOById(vo.getId(), true, false);
        if (EmptyUtil.isEmpty((Object)whGradeVo.getApproveUserId())) {
            whGradeVo.setApproveUserId(vo.getApproveUserId());
        }
        whGradeVo.setMemo(vo.getMemo());
        whGradeVo.setRejectReason(vo.getRejectReason());
        whGradeVo.setApproveTime(DateUtil.getNow());
        if (optPass) {
            this.updateScmStock(whGradeVo);
            this.scmReleaseOccupy(whGradeVo);
            whGradeVo.setApproveStatus(2);
            for (WhGradeOfQualityDetail whGradeDetail : whGradeVo.getWhGradeDetails()) {
                whGradeDetail.setApproveStatus(1);
            }
            whGradeVo.setWhGradeAffectInfos(this.listWhGradeAffectInfoByWhGradeId(vo.getId()));
            for (WhGradeAffectInfo whGradeAffectInfo : whGradeVo.getWhGradeAffectInfos()) {
                whGradeAffectInfo.setWhGradeStatus(2);
            }
            this.modifyAndFetch(whGradeVo);
            whWmsGradeOfQualityVO.setSubmitUserId(whGradeVo.getApproveUserId());
            this.whWmsGradeOfQualityService.passWmsGradeOfQuality(whWmsGradeOfQualityVO, whGradeVo.getWmsGradeSkuId());
        } else {
            this.scmReleaseOccupy(whGradeVo);
            whGradeVo.setApproveStatus(-1);
            for (WhGradeOfQualityDetail whGradeDetail : whGradeVo.getWhGradeDetails()) {
                whGradeDetail.setApproveStatus(-1);
            }
            whGradeVo.setWhGradeAffectInfos(this.listWhGradeAffectInfoByWhGradeId(vo.getId()));
            for (WhGradeAffectInfo affectInfo : whGradeVo.getWhGradeAffectInfos()) {
                affectInfo.setOptFlag(-1);
            }
            this.modifyAndFetch(whGradeVo);
            this.whWmsGradeOfQualityService.rejectWmsGradeOfQuality(whWmsGradeOfQualityVO, whGradeVo.getWmsGradeSkuId());
        }
        return true;
    }

    @Override
    @Transactional
    public List<Long> batchAuditWhGradeOfQuality(List<WhGradeOfQualityVO> gradeOfQualityVOs, Long approveUserId) throws Exception {
        boolean result = false;
        ArrayList<Long> whGradeIds = new ArrayList<Long>();
        for (WhGradeOfQualityVO whGradeVO : gradeOfQualityVOs) {
            whGradeVO.setRejectReason("\u5ba1\u6279\u5355\u6279\u91cf\u5ba1\u6838");
            whGradeVO.setMemo(whGradeVO.getRejectReason());
            whGradeVO.setOptPass(true);
            whGradeVO.setApproveUserId(approveUserId);
            result = this.auditWhGradeOfQuality(whGradeVO);
            if (!result) {
                throw new WarehouseException("WH0001", "\u6279\u91cf\u54c1\u7ea7\u8c03\u6574\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u5904\u7406!");
            }
            whGradeIds.add(whGradeVO.getId());
        }
        return whGradeIds;
    }

    public boolean updateScmStock(WhGradeOfQualityVO vo) {
        boolean result = false;
        ArrayList<WhGradeTmallInfo> tmallInfos = new ArrayList<WhGradeTmallInfo>();
        if (CollectionUtils.isNotEmpty(vo.getWhGradeDetails())) {
            for (WhGradeOfQualityDetail gradeDetail : vo.getWhGradeDetails()) {
                WhInvRcd whInvRcd = new WhInvRcd();
                whInvRcd.setCommandCode(vo.getCode());
                whInvRcd.setWarehouseCode(gradeDetail.getSourceWarehouseCode());
                whInvRcd.setInOutType(WhInvRcd.TYPE_GRADE_ADJUST_OUT);
                whInvRcd.setSkuCode(gradeDetail.getSkuCode());
                whInvRcd.setQuantity(-gradeDetail.getAdjustAmount().intValue());
                whInvRcd.setSubmitUserId(vo.getApproveUserId());
                whInvRcd.setMemo(vo.getAdjustReason() + vo.getMemo());
                whInvRcd.setSubmitTime(Calendar.getInstance().getTime());
                this.whInvService.record(whInvRcd);
                if (!WhGradeOfQualityVO.WAREHOUSE_CHANNEL_TMALL_MAP.containsKey(gradeDetail.getSourceWarehouseCode())) continue;
                WhGradeTmallInfo tmallInfo = new WhGradeTmallInfo();
                tmallInfo.setSkuCode(gradeDetail.getSkuCode());
                tmallInfo.setChannelCode(WhGradeOfQualityVO.WAREHOUSE_CHANNEL_TMALL_MAP.get(gradeDetail.getSourceWarehouseCode()));
                tmallInfo.setRefCode(vo.getCode());
                tmallInfo.setQuality(-gradeDetail.getAdjustAmount().intValue());
                tmallInfo.setWarehoseCode(gradeDetail.getSourceWarehouseCode());
                tmallInfos.add(tmallInfo);
            }
            WhInvRcd whInvRcd = new WhInvRcd();
            whInvRcd.setCommandCode(vo.getCode());
            whInvRcd.setWarehouseCode(vo.getWhGradeDetails().get(0).getTargetWarehouseCode());
            whInvRcd.setInOutType(WhInvRcd.TYPE_GRADE_ADJUST_IN);
            whInvRcd.setSkuCode(vo.getSkuCode());
            whInvRcd.setQuantity(vo.getAdjustAmount());
            whInvRcd.setSubmitUserId(vo.getApproveUserId());
            whInvRcd.setMemo(vo.getAdjustReason() + vo.getMemo());
            whInvRcd.setSubmitTime(Calendar.getInstance().getTime());
            result = this.whInvService.record(whInvRcd);
            if (WhGradeOfQualityVO.WAREHOUSE_CHANNEL_TMALL_MAP.containsKey(whInvRcd.getWarehouseCode())) {
                WhGradeTmallInfo tmallInfo = new WhGradeTmallInfo();
                tmallInfo.setSkuCode(whInvRcd.getSkuCode());
                tmallInfo.setChannelCode(WhGradeOfQualityVO.WAREHOUSE_CHANNEL_TMALL_MAP.get(whInvRcd.getWarehouseCode()));
                tmallInfo.setRefCode(vo.getCode());
                tmallInfo.setQuality(whInvRcd.getQuantity());
                tmallInfo.setWarehoseCode(whInvRcd.getWarehouseCode());
                this.syncTmallStocks(Collections.singletonList(tmallInfo), null, vo.getApproveUserId());
            }
            if (CollectionUtils.isNotEmpty(tmallInfos)) {
                this.syncTmallStocks(tmallInfos, vo.getId(), vo.getApproveUserId());
            }
            this.trySyncJdStock(vo);
        }
        return result;
    }

    private void trySyncJdStock(WhGradeOfQualityVO vo) {
        ArrayList<WhGradeTmallInfo> tmallInfos = new ArrayList<WhGradeTmallInfo>();
        PegasusUtilFacade utilFacade = PegasusUtilFacade.getInstance();
        if (EmptyUtil.isNotEmpty(vo.getWhGradeDetails())) {
            for (WhGradeOfQualityDetail gradeDetail : vo.getWhGradeDetails()) {
                if (!utilFacade.needSyncJdStock(gradeDetail.getSourceWarehouseCode())) continue;
                WhGradeTmallInfo whGradeTmallInfo = new WhGradeTmallInfo();
                whGradeTmallInfo.setSkuCode(gradeDetail.getSkuCode());
                whGradeTmallInfo.setRefCode(vo.getCode());
                whGradeTmallInfo.setQuality(-gradeDetail.getAdjustAmount().intValue());
                whGradeTmallInfo.setWarehoseCode(gradeDetail.getSourceWarehouseCode());
                tmallInfos.add(whGradeTmallInfo);
            }
            if (utilFacade.needSyncJdStock(vo.getWhGradeDetails().get(0).getTargetWarehouseCode())) {
                WhGradeTmallInfo tmallInfo = new WhGradeTmallInfo();
                tmallInfo.setSkuCode(vo.getSkuCode());
                tmallInfo.setRefCode(vo.getCode());
                tmallInfo.setQuality(vo.getAdjustAmount());
                tmallInfo.setWarehoseCode(vo.getWhGradeDetails().get(0).getTargetWarehouseCode());
                tmallInfos.add(tmallInfo);
            }
        }
        if (EmptyUtil.isEmpty(tmallInfos)) {
            return;
        }
        HashMap whSkuQuantityMap = new HashMap();
        for (WhGradeTmallInfo whGradeTmallInfo : tmallInfos) {
            Integer total;
            HashMap<String, Integer> skuQuantityMap = (HashMap<String, Integer>)whSkuQuantityMap.get(whGradeTmallInfo.getWarehoseCode());
            if (NullUtil.isNull((Object)skuQuantityMap)) {
                skuQuantityMap = new HashMap<String, Integer>();
                whSkuQuantityMap.put(whGradeTmallInfo.getWarehoseCode(), skuQuantityMap);
            }
            if (NullUtil.isNull((Object)(total = (Integer)skuQuantityMap.get(whGradeTmallInfo.getSkuCode())))) {
                total = 0;
            }
            total = total + whGradeTmallInfo.getQuality();
            skuQuantityMap.put(whGradeTmallInfo.getSkuCode(), total);
        }
        for (Map.Entry entry : whSkuQuantityMap.entrySet()) {
            LinkedList<String> referenceCodes = new LinkedList<String>();
            referenceCodes.add(vo.getCode());
            this.whCommandService.syncJdSkuStock((String)entry.getKey(), (Map)entry.getValue(), Constants.STOCK_SYNC_TYPE_GRADE, referenceCodes, vo.getApproveUserId());
        }
    }

    private void scmReleaseOccupy(WhGradeOfQualityVO vo) {
        if (CollectionUtils.isEmpty(vo.getWhGradeDetails())) {
            vo = this.findWhGradeOfQualityVOById(vo.getId(), true, false);
        }
        for (WhGradeOfQualityDetail gradeDetail : vo.getWhGradeDetails()) {
            WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
            whReleaseOccupationVO.setOccupyType(WhInvOccupy.TYPE_GRADE_ADJUST_OCCUPY);
            whReleaseOccupationVO.setReferenceCode(vo.getCode() + "_" + gradeDetail.getId());
            this.whInvService.releaseOccupation(whReleaseOccupationVO);
        }
    }

    private void scmOccupy(WhGradeOfQualityVO vo) {
        ArrayList<SOccupyResultVO> rollbackOccupyList = new ArrayList<SOccupyResultVO>();
        for (WhGradeOfQualityDetail gradeDetail : vo.getWhGradeDetails()) {
            SStockOccupyDTO occupyDTO = new SStockOccupyDTO();
            occupyDTO.setWarehouseCode(gradeDetail.getSourceWarehouseCode());
            occupyDTO.setOccupyType(SStockOccupyTypeEnum.getEnumByCode((Integer)SStockOccupyTypeEnum.GRADE_ADJUST_OUT.getCode()));
            occupyDTO.setOperationType(SStockOperationTypeEnum.DEFAULT);
            occupyDTO.setReferenceCode(vo.getCode() + "_" + gradeDetail.getId());
            occupyDTO.setSkuCode(gradeDetail.getSkuCode());
            occupyDTO.setQuantity(gradeDetail.getAdjustAmount());
            occupyDTO.setNeedToCheckStock(false);
            ServiceResp serviceResp = this.sStockService.occupy(occupyDTO);
            if (serviceResp.isSuccess()) {
                rollbackOccupyList.add((SOccupyResultVO)serviceResp.getBean());
                continue;
            }
            throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
        vo.setRollbackOccupyList(rollbackOccupyList);
    }

    @Override
    @Transactional
    public boolean update(WhGradeOfQualityVO vo) {
        WhGradeOfQuality gradeOfQuality = (WhGradeOfQuality)BeanUtil.buildFrom((Object)vo, WhGradeOfQuality.class);
        int result = this.whGradeOfQualityMapper.updateByPrimaryKeySelective(gradeOfQuality);
        if (result > 0 && this.deleteGradeDetails(vo.getId())) {
            this.insertGradeDetails(vo);
        }
        return result > 0;
    }

    @Override
    @Transactional
    public boolean modifyAndFetch(WhGradeOfQualityVO vo) {
        WhGradeOfQuality gradeOfQuality = (WhGradeOfQuality)BeanUtil.buildFrom((Object)vo, WhGradeOfQuality.class);
        int result = this.whGradeOfQualityMapper.updateByPrimaryKeySelective(gradeOfQuality);
        if (result > 0) {
            if (CollectionUtils.isNotEmpty(vo.getWhGradeDetails())) {
                for (WhGradeOfQualityDetail whGradeDetail : vo.getWhGradeDetails()) {
                    this.whGradeOfQualityDetailMapper.updateByPrimaryKeySelective(whGradeDetail);
                }
            }
            if (CollectionUtils.isNotEmpty(vo.getWhGradeAffectInfos())) {
                for (WhGradeAffectInfo affectInfo : vo.getWhGradeAffectInfos()) {
                    this.whGradeAffectInfoMapper.updateByPrimaryKeySelective(affectInfo);
                }
            }
        }
        return result > 0;
    }

    public boolean deleteGradeDetails(Long gradeId) {
        WhGradeOfQualityDetailCond detailCond = new WhGradeOfQualityDetailCond();
        detailCond.setRefId(gradeId);
        return this.deleteGradeDetail(detailCond);
    }

    public boolean deleteGradeDetail(WhGradeOfQualityDetailCond detailCond) {
        WhGradeOfQualityDetailExample example = this.buildWhGradeOfQualityDetailExampleByCond(detailCond);
        return this.whGradeOfQualityDetailMapper.deleteByExample(example) > 0;
    }

    private void insertGradeDetails(WhGradeOfQualityVO vo) {
        if (CollectionUtils.isNotEmpty(vo.getWhGradeDetails())) {
            for (WhGradeOfQualityDetail gradeDetail : vo.getWhGradeDetails()) {
                gradeDetail.setRefId(vo.getId());
                this.whGradeOfQualityDetailMapper.insert(gradeDetail);
            }
        }
    }

    private void insertGradeAffectInfos(WhGradeOfQualityVO vo) {
        if (CollectionUtils.isNotEmpty(vo.getWhGradeAffectInfos())) {
            for (WhGradeAffectInfo affectInfo : vo.getWhGradeAffectInfos()) {
                affectInfo.setWhGradeId(vo.getId());
                this.whGradeAffectInfoMapper.insert(affectInfo);
            }
        }
    }

    @Override
    @Transactional
    public boolean updateWhGradeOfQualityDetail(WhGradeOfQualityDetail whGradeDetail) {
        return this.whGradeOfQualityDetailMapper.updateByPrimaryKeySelective(whGradeDetail) > 0;
    }

    @Override
    @Transactional
    public boolean batchCreateWhGradeOfQuality(List<WhGradeOfQuality> gradeOfQualitys) {
        return this.whGradeOfQualityCustomMapper.batchInsertWhGradeOfQuality(gradeOfQualitys) > 0;
    }

    @Override
    @Transactional
    public boolean batchCreateWhGradeOfQualityDetail(List<WhGradeOfQualityDetail> gradeOfQualityDetails) {
        return this.whGradeOfQualityCustomMapper.batchInsertWhGradeOfQualityDetail(gradeOfQualityDetails) > 0;
    }

    @Override
    public boolean batchDeleteWhGradeOfQualityDetailByCond(WhGradeOfQualityDetailCond cond) {
        return this.deleteGradeDetail(cond);
    }

    public void syncTmallStocks(List<WhGradeTmallInfo> tmallInfos, Long whGradeId, Long operatorId) {
        String result = "";
        for (WhGradeTmallInfo tmallInfo : tmallInfos) {
            try {
                Long skuNumId = PegasusUtilFacade.getInstance().getSkuNumIid(tmallInfo.getSkuCode(), tmallInfo.getChannelCode());
                result = this.whCommandService.synCommodityStocks(skuNumId, tmallInfo.getSkuCode(), tmallInfo.getQuality().intValue(), tmallInfo.getChannelCode(), 8, tmallInfo.getRefCode(), operatorId);
                if (!NullUtil.isNotNull((Object)whGradeId)) continue;
                this.updateWhGradeAffectInfoAfterSyncTmall(EmptyUtil.isNotEmpty((String)result), whGradeId, tmallInfo.getWarehoseCode());
            }
            catch (Exception e) {
                if (NullUtil.isNotNull((Object)whGradeId)) {
                    this.updateWhGradeAffectInfoAfterSyncTmall(false, whGradeId, tmallInfo.getWarehoseCode());
                }
                e.printStackTrace();
                log.error(e.getMessage());
            }
        }
    }

    private void updateWhGradeAffectInfoAfterSyncTmall(boolean success, Long whGradeId, String warehouseCode) {
        WhGradeAffectInfo affectInfo = new WhGradeAffectInfo();
        if (success) {
            affectInfo.setSyncResult(1);
        } else {
            affectInfo.setSyncResult(-1);
        }
        WhGradeAffectInfoCond affectCond = new WhGradeAffectInfoCond();
        affectCond.setWhGradeId(whGradeId);
        affectCond.setWarehouseCode(warehouseCode);
        affectCond.setSyncResult(0);
        boolean result = this.updateWhGradeAffectInfoByExampleSelective(affectInfo, affectCond);
        log.info("\u66f4\u65b0\u7ed3\u679c:" + result);
    }

    @Override
    public void gradeAdjustApplySendMail(final List<WhGradeOfQualityVO> whGradeVOs) {
        this.gradeAdjustScheduler.execute(new Runnable(){

            @Override
            public void run() {
                WhGradeOfQualityServiceImpl.this.sendMailGradeAdjustApply(whGradeVOs);
            }
        });
    }

    private void sendMailGradeAdjustApply(List<WhGradeOfQualityVO> whGradeVOs) {
        if (EmptyUtil.isEmpty(whGradeVOs)) {
            return;
        }
        CommGlobalConfig config = PegasusUtilFacade.getInstance().findConfigByKey("grade.sendMailGradeAdjustApply");
        if (EmptyUtil.isEmpty((Object)config) || EmptyUtil.isEmpty((String)config.getConfigValue())) {
            return;
        }
        String configValue = config.getConfigValue();
        StringBuffer emailContent = new StringBuffer();
        emailContent.append("<html><style>#table-5 thead th {background-color: rgb(156, 186, 95);color: #fff;border-bottom-width: 0;}");
        emailContent.append("#table-5 td {color: #000;}");
        emailContent.append("#table-5 tr, #table-5 th {border-width: 1px;border-style: solid;border-color: rgb(156, 186, 95);}");
        emailContent.append("#table-5 td, #table-5 th {padding: 5px 10px;font-size: 12px;font-family: Verdana;font-weight: bold;}</style>");
        emailContent.append("<table id='table-5'><thead><th>\u54c1\u7ea7\u8c03\u6574CODE</th><th>\u6e90\u54c1\u7ea7</th><th>\u76ee\u6807\u54c1\u7ea7</th><th>SKU</th><th>\u8c03\u6574\u6570\u91cf</th><th>\u8c03\u6574\u539f\u56e0</th></thead>");
        emailContent.append("<tbody>");
        for (WhGradeOfQualityVO whGradeVO : whGradeVOs) {
            emailContent.append("<tr>");
            emailContent.append("<td>" + whGradeVO.getCode() + "</td>");
            emailContent.append("<td>" + whGradeVO.getSourceGradeStr() + "</td>");
            emailContent.append("<td>" + whGradeVO.getTargetGradeStr() + "</td>");
            emailContent.append("<td>[" + whGradeVO.getSkuCode() + "]" + whGradeVO.getSkuName() + "</td>");
            emailContent.append("<td>" + whGradeVO.getAdjustAmount() + "</td>");
            emailContent.append("<td>" + whGradeVO.getAdjustReason() + "</td>");
            emailContent.append("</tr>");
        }
        emailContent.append("</tbody></table></html>");
        EmailVO emailVO = new EmailVO();
        emailVO.setToAddressList(Arrays.asList(configValue.split(",")));
        emailVO.setSubject("\u5546\u54c1\u54c1\u7ea7\u8c03\u6574\u7533\u8bf7");
        emailVO.setContent(emailContent.toString());
        if (CollectionUtils.isNotEmpty((Collection)emailVO.getToAddressList())) {
            EmailUtil.getInstance().send(emailVO);
        }
    }

    @Override
    public void stockOutByGradeAdjustSendMail(final WhGradeOfQualityVO whGradeVO, final List<WhGradeAffectInfoVO> affectInfoVOs) {
        log.info("stockOutByGradeAdjustSendMail Thread=" + Thread.currentThread().getName() + "  whGradeId=" + whGradeVO.getId());
        this.gradeAdjustScheduler.execute(new Runnable(){

            @Override
            public void run() {
                WhGradeOfQualityServiceImpl.this.sendMailStockOutByGradeAdjust(whGradeVO, affectInfoVOs, null);
            }
        });
    }

    @Override
    public void sendMailStockOutByGradeAdjust(WhGradeOfQualityVO whGradeVO, List<WhGradeAffectInfoVO> affectInfoVOs, Map<String, WhGradeAffectInfoVO> waitSendEmailMap) {
        block11: {
            if (EmptyUtil.isEmpty((Object)whGradeVO) || CollectionUtils.isEmpty(affectInfoVOs)) {
                return;
            }
            CommGlobalConfig config = PegasusUtilFacade.getInstance().findConfigByKey("grade.sendMailStockOutByGradeAdjust");
            StringBuilder emailContent = new StringBuilder();
            emailContent.append("<html><style>#table-5 thead th {background-color: rgb(156, 186, 95);color: #fff;border-bottom-width: 0;}");
            emailContent.append("#table-5 td {color: #000;}");
            emailContent.append("#table-5 tr, #table-5 th {border-width: 1px;border-style: solid;border-color: rgb(156, 186, 95);}");
            emailContent.append("#table-5 td, #table-5 th {padding: 5px 10px;font-size: 12px;font-family: Verdana;font-weight: bold;}</style>");
            emailContent.append("<table id='table-5'><thead><th>\u8ba2\u5355\u53f7</th><th>\u5305\u88f9\u53f7</th><th>SKU</th><th>\u91c7\u8d2d\u5458</th><th>\u7f3a\u8d27\u6570\u91cf</th><th>\u53d8\u52a8\u539f\u56e0</th><th>\u7701\u5e02\u533a</th><th>\u903b\u8f91\u4ed3\u6240\u5c5e\u5206\u7ec4\u540d</th></thead>");
            emailContent.append("<tbody>");
            ArrayList<Long> gradeAffectIds = new ArrayList<Long>();
            StringBuffer allEmailContent = new StringBuffer();
            HashMap<String, List<WhGradeAffectInfoVO>> gradeAffectMap = new HashMap<String, List<WhGradeAffectInfoVO>>();
            Map<String, String> skuWhGroupName = this.buildAvailableStockWarehouseGroupBySku(whGradeVO.getSkuCode());
            this.buildStockOutGradeAdjust(allEmailContent, affectInfoVOs, gradeAffectIds, gradeAffectMap, whGradeVO, skuWhGroupName);
            HashMap channelEmailContentMap = new HashMap();
            if (gradeAffectMap.size() > 0) {
                for (Map.Entry entry : gradeAffectMap.entrySet()) {
                    StringBuffer channelEmailContent = (StringBuffer)channelEmailContentMap.get(entry.getKey());
                    if (EmptyUtil.isEmpty((Object)channelEmailContent)) {
                        channelEmailContent = new StringBuffer();
                        channelEmailContentMap.put(entry.getKey(), channelEmailContent);
                    }
                    this.buildStockOutGradeAdjust(channelEmailContent, (List)entry.getValue(), null, null, whGradeVO, skuWhGroupName);
                }
            }
            String tableBottom = "</tbody></table></html>";
            if (EmptyUtil.isNotEmpty((Object)config) && EmptyUtil.isNotEmpty((String)config.getConfigValue())) {
                List<String> toAddressList = Arrays.asList(config.getConfigValue().split(","));
                if (whGradeVO.isSystemGradeEmail() && waitSendEmailMap != null) {
                    this.buildWaitSendGradeEmailObj(waitSendEmailMap, "SEND_EMAIL_ALL", toAddressList, config.getConfigValue(), emailContent.toString(), allEmailContent.toString(), gradeAffectIds);
                } else {
                    allEmailContent.append(tableBottom);
                    log.info("All Thread=" + Thread.currentThread().getName() + "  gradeAffectIds=" + ((Object)gradeAffectIds).toString());
                    this.sendStockOutEmailForGradeAdjust(toAddressList, emailContent.toString() + allEmailContent.toString(), null);
                }
            }
            if (channelEmailContentMap.size() <= 0) break block11;
            if (whGradeVO.isSystemGradeEmail() && waitSendEmailMap != null) {
                for (Map.Entry entry : channelEmailContentMap.entrySet()) {
                    this.buildWaitSendGradeEmailObj(waitSendEmailMap, "SEND_EMAIL_CHANNEL-" + (String)entry.getKey(), Arrays.asList(((String)entry.getKey()).split(",")), (String)entry.getKey(), emailContent.toString(), ((StringBuffer)entry.getValue()).toString(), null);
                }
            } else {
                for (Map.Entry entry : channelEmailContentMap.entrySet()) {
                    ((StringBuffer)entry.getValue()).append(tableBottom);
                    log.info("Channel Thread=" + Thread.currentThread().getName() + "  emailAddressList=" + ((String)entry.getKey()).toString());
                    this.sendStockOutEmailForGradeAdjust(Arrays.asList(((String)entry.getKey()).split(",")), emailContent.toString() + ((StringBuffer)entry.getValue()).toString(), null);
                }
            }
        }
    }

    private void buildWaitSendGradeEmailObj(Map<String, WhGradeAffectInfoVO> waitSendEmailMap, String keyFlag, List<String> toAddressList, String emailAddressKey, String emailHead, String emailContent, List<Long> affectIds) {
        WhGradeAffectInfoVO emailObj = waitSendEmailMap.get(keyFlag);
        if (EmptyUtil.isNotEmpty((Object)emailObj)) {
            emailObj.setWaitSendContent(emailObj.getWaitSendContent().append(emailContent));
        } else {
            emailObj = new WhGradeAffectInfoVO();
            emailObj.setToAddressList(toAddressList);
            emailObj.setEmailAddressKey(emailAddressKey);
            emailObj.setWaitSendHead(emailHead);
            emailObj.setWaitSendContent(new StringBuilder(emailContent));
            emailObj.setWaitSendBottom("</tbody></table></html>");
            emailObj.setWaitUpdateAffectIds(affectIds);
            waitSendEmailMap.put(keyFlag, emailObj);
        }
    }

    @Override
    public void sendStockOutEmailForGradeAdjust(List<String> toAddressList, String emailContent, List<Long> affectIds) {
        EmailVO emailVO = new EmailVO();
        emailVO.setToAddressList(toAddressList);
        emailVO.setSubject("\u5546\u54c1\u54c1\u7ea7\u8c03\u6574\u5bfc\u81f4\u8ba2\u5355\u7f3a\u8d27");
        emailVO.setContent(emailContent);
        if (CollectionUtils.isNotEmpty((Collection)emailVO.getToAddressList())) {
            try {
                log.info("\u5f00\u59cb\u53d1\u9001 \u5546\u54c1\u54c1\u7ea7\u8c03\u6574\u5bfc\u81f4\u8ba2\u5355\u7f3a\u8d27 \u90ae\u4ef6\uff1a" + emailVO.getToAddressList());
                EmailUtil.getInstance().send(emailVO);
                log.info("\u6210\u529f\u53d1\u9001 \u5546\u54c1\u54c1\u7ea7\u8c03\u6574\u5bfc\u81f4\u8ba2\u5355\u7f3a\u8d27 \u90ae\u4ef6\uff1a" + emailVO.getToAddressList());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void buildStockOutGradeAdjust(StringBuffer emailContent, List<WhGradeAffectInfoVO> affectInfoVOs, List<Long> affectIds, Map<String, List<WhGradeAffectInfoVO>> gradeAffectMap, WhGradeOfQualityVO whGradeVO, Map<String, String> skuWhGroupName) {
        for (WhGradeAffectInfoVO affectInfoVO : affectInfoVOs) {
            emailContent.append("<tr>");
            emailContent.append("<td>" + affectInfoVO.getSalesOrderCode() + "</td>");
            emailContent.append("<td>" + affectInfoVO.getAffectCode() + "</td>");
            emailContent.append("<td>[" + whGradeVO.getSkuCode() + "]" + whGradeVO.getSkuName() + "</td>");
            emailContent.append("<td>" + whGradeVO.getBuyerName() + "</td>");
            emailContent.append("<td>" + affectInfoVO.getAmount() + "</td>");
            emailContent.append("<td>" + whGradeVO.getAdjustReason() + "</td>");
            emailContent.append("<td>" + this.removeEmpty(affectInfoVO.getFullAddress()) + "</td>");
            emailContent.append("<td>" + this.removeEmpty(skuWhGroupName.get(whGradeVO.getSkuCode())) + "</td>");
            emailContent.append("</tr>");
            if (affectIds != null) {
                affectIds.add(affectInfoVO.getId());
            }
            if (gradeAffectMap == null || !EmptyUtil.isNotEmpty((String)affectInfoVO.getChannelNoticeEmails())) continue;
            List<WhGradeAffectInfoVO> gradeAffectVOList = gradeAffectMap.get(affectInfoVO.getChannelNoticeEmails());
            if (CollectionUtils.isEmpty(gradeAffectVOList)) {
                gradeAffectVOList = new ArrayList<WhGradeAffectInfoVO>();
                gradeAffectMap.put(affectInfoVO.getChannelNoticeEmails(), gradeAffectVOList);
            }
            gradeAffectVOList.add(affectInfoVO);
        }
    }

    private String removeEmpty(String value) {
        if (EmptyUtil.isNotEmpty((String)value)) {
            return value;
        }
        return "";
    }

    private Map<String, String> buildAvailableStockWarehouseGroupBySku(String skuCode) {
        HashMap<String, String> skuWarehouseGroupNameMap = new HashMap<String, String>();
        Map<String, WhInvVO> skuInvMap = this.whInvService.findCanUseQttBySkuCode(skuCode);
        if (EmptyUtil.isNotEmpty(skuInvMap)) {
            HashSet<String> warehouseSet = new HashSet<String>();
            for (Map.Entry<String, WhInvVO> whSkuInvEntry : skuInvMap.entrySet()) {
                if (whSkuInvEntry.getValue().getCanUseInv() <= 0) continue;
                warehouseSet.add(whSkuInvEntry.getKey());
            }
            WhWarehouseGroupCond groupCond = new WhWarehouseGroupCond();
            groupCond.setRelateWhCodes(new ArrayList<String>(warehouseSet));
            groupCond.setNotType(WhWarehouseGroupVO.WAREHOUSE_YES);
            groupCond.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
            List<WhWarehouseGroupVO> groupVOs = this.whWarehouseGroupService.findWarehouseGroupByWhCodes(groupCond);
            if (CollectionUtils.isNotEmpty(groupVOs)) {
                String groupName = "";
                for (WhWarehouseGroupVO groupVO : groupVOs) {
                    groupName = groupName + groupVO.getName() + ",";
                }
                groupName = groupName.substring(0, groupName.lastIndexOf(","));
                skuWarehouseGroupNameMap.put(skuCode, groupName);
            }
        }
        return skuWarehouseGroupNameMap;
    }

    private List<Map<String, WhInvVO>> getSkuWhInvBySkuCodes(List<String> skuCodes) {
        ArrayList<Map<String, WhInvVO>> invMapList = new ArrayList<Map<String, WhInvVO>>();
        for (String skuCode : skuCodes) {
            Map<String, WhInvVO> skuInvMap = this.whInvService.findCanUseQttBySkuCode(skuCode);
            if (!EmptyUtil.isNotEmpty(skuInvMap)) continue;
            invMapList.add(skuInvMap);
        }
        return invMapList;
    }

    @Override
    public void orderExceptionByGradeAdjustSendMail(final WhGradeOfQualityVO whGradeVO, final List<WhGradeAffectInfoVO> affectInfoVOs) {
        this.gradeAdjustScheduler.execute(new Runnable(){

            @Override
            public void run() {
                WhGradeOfQualityServiceImpl.this.sendMailOrderExceptionByGradeAdjust(whGradeVO, affectInfoVOs, null);
            }
        });
    }

    @Override
    public void sendMailOrderExceptionByGradeAdjust(WhGradeOfQualityVO whGradeVO, List<WhGradeAffectInfoVO> affectInfoVOs, Map<String, WhGradeAffectInfoVO> waitSendEmailMap) {
        if (EmptyUtil.isEmpty((Object)whGradeVO) || CollectionUtils.isEmpty(affectInfoVOs)) {
            return;
        }
        CommGlobalConfig config = PegasusUtilFacade.getInstance().findConfigByKey("grade.sendMailOrderExceptionByGradeAdjust");
        if (EmptyUtil.isEmpty((Object)config) || EmptyUtil.isEmpty((String)config.getConfigValue())) {
            return;
        }
        String configValue = config.getConfigValue();
        StringBuffer emailContent = new StringBuffer();
        emailContent.append("<html><style>#table-5 thead th {background-color: rgb(156, 186, 95);color: #fff;border-bottom-width: 0;}");
        emailContent.append("#table-5 td {color: #000;}");
        emailContent.append("#table-5 tr, #table-5 th {border-width: 1px;border-style: solid;border-color: rgb(156, 186, 95);}");
        emailContent.append("#table-5 td, #table-5 th {padding: 5px 10px;font-size: 12px;font-family: Verdana;font-weight: bold;}</style>");
        emailContent.append("<table id='table-5'><thead><th>\u5355\u636e\u53f7</th><th>SKU</th><th>\u91c7\u8d2d\u5458</th><th>\u7f3a\u8d27\u6570\u91cf</th></thead>");
        emailContent.append("<tbody>");
        StringBuffer allEmailContent = new StringBuffer();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (WhGradeAffectInfoVO affectInfoVO : affectInfoVOs) {
            allEmailContent.append("<tr>");
            allEmailContent.append("<td>" + affectInfoVO.getAffectCode() + "</td>");
            allEmailContent.append("<td>[" + whGradeVO.getSkuCode() + "]" + whGradeVO.getSkuName() + "</td>");
            allEmailContent.append("<td>" + whGradeVO.getBuyerName() + "</td>");
            allEmailContent.append("<td>" + affectInfoVO.getAmount() + "</td>");
            allEmailContent.append("</tr>");
            ids.add(affectInfoVO.getId());
        }
        if (whGradeVO.isSystemGradeEmail() && waitSendEmailMap != null) {
            this.buildWaitSendGradeEmailObj(waitSendEmailMap, "SEND_EMAIL_ALL", Arrays.asList(configValue.split(",")), configValue, emailContent.toString(), allEmailContent.toString(), ids);
        } else {
            allEmailContent.append("</tbody></table></html>");
            this.sendOrderExceptionEmailForGradeAdjust(Arrays.asList(configValue.split(",")), emailContent.toString() + allEmailContent.toString(), null);
        }
    }

    @Override
    public void sendOrderExceptionEmailForGradeAdjust(List<String> toAddressList, String emailContent, List<Long> affectIds) {
        boolean result;
        EmailVO emailVO = new EmailVO();
        emailVO.setToAddressList(toAddressList);
        emailVO.setSubject("\u5546\u54c1\u54c1\u7ea7\u8c03\u6574\u5bfc\u81f4\u5355\u636e\u5f02\u5e38");
        emailVO.setContent(emailContent);
        if (!CollectionUtils.isNotEmpty((Collection)emailVO.getToAddressList()) || !(result = EmailUtil.getInstance().send(emailVO)) || CollectionUtils.isNotEmpty(affectIds)) {
            // empty if block
        }
    }

    @Override
    public void stockChangeByGradeAdjustSendMail(final WhGradeOfQualityVO whGradeVO, final List<WhGradeAffectInfoVO> affectInfoVOs) {
        this.gradeAdjustScheduler.execute(new Runnable(){

            @Override
            public void run() {
                WhGradeOfQualityServiceImpl.this.sendMailStockChangeByGradeAdjust(whGradeVO, affectInfoVOs, null);
            }
        });
    }

    @Override
    public void sendMailStockChangeByGradeAdjust(WhGradeOfQualityVO whGradeVO, List<WhGradeAffectInfoVO> affectInfoVOs, Map<String, WhGradeAffectInfoVO> waitSendEmailMap) {
        block11: {
            if (EmptyUtil.isEmpty((Object)whGradeVO) || CollectionUtils.isEmpty(affectInfoVOs)) {
                return;
            }
            CommGlobalConfig config = PegasusUtilFacade.getInstance().findConfigByKey("grade.sendMailStockChangeByGradeAdjust");
            StringBuilder emailContent = new StringBuilder();
            emailContent.append("<html><style>#table-5 thead th {background-color: rgb(156, 186, 95);color: #fff;border-bottom-width: 0;}");
            emailContent.append("#table-5 td {color: #000;}");
            emailContent.append("#table-5 tr, #table-5 th {border-width: 1px;border-style: solid;border-color: rgb(156, 186, 95);}");
            emailContent.append("#table-5 td, #table-5 th {padding: 5px 10px;font-size: 12px;font-family: Verdana;font-weight: bold;}</style>");
            emailContent.append("<table id='table-5'><thead><th>\u903b\u8f91\u4ed3</th><th>SKU</th><th>\u53d8\u52a8\u6570\u91cf</th><th>\u53d8\u52a8\u539f\u56e0</th><th>\u5929\u732b\u5e93\u5b58\u540c\u6b65\u7ed3\u679c</th></thead>");
            emailContent.append("<tbody>");
            StringBuffer allEmailContent = new StringBuffer();
            HashMap<String, List<WhGradeAffectInfoVO>> gradeAffectMap = new HashMap<String, List<WhGradeAffectInfoVO>>();
            List<Long> affectIds = whGradeVO.getWhAffectGradeIds();
            this.buildStockChangeGradeAdjust(allEmailContent, affectInfoVOs, gradeAffectMap, whGradeVO);
            HashMap warehouseEmailContentMap = new HashMap();
            if (gradeAffectMap.size() > 0) {
                for (Map.Entry entry : gradeAffectMap.entrySet()) {
                    StringBuffer warehouseEmailContent = (StringBuffer)warehouseEmailContentMap.get(entry.getKey());
                    if (EmptyUtil.isEmpty((Object)warehouseEmailContent)) {
                        warehouseEmailContent = new StringBuffer();
                        warehouseEmailContentMap.put(entry.getKey(), warehouseEmailContent);
                    }
                    this.buildStockChangeGradeAdjust(warehouseEmailContent, (List)entry.getValue(), null, whGradeVO);
                }
            }
            String tableBottom = "</tbody></table></html>";
            if (EmptyUtil.isNotEmpty((Object)config) && EmptyUtil.isNotEmpty((String)config.getConfigValue())) {
                List<String> toAddressList = Arrays.asList(config.getConfigValue().split(","));
                if (whGradeVO.isSystemGradeEmail() && waitSendEmailMap != null) {
                    this.buildWaitSendGradeEmailObj(waitSendEmailMap, "SEND_EMAIL_ALL", toAddressList, config.getConfigValue(), emailContent.toString(), allEmailContent.toString(), affectIds);
                } else {
                    allEmailContent.append(tableBottom);
                    this.sendStockChangeEmailForGradeAdjust(toAddressList, emailContent.toString() + allEmailContent.toString(), null);
                }
            }
            if (warehouseEmailContentMap.size() <= 0) break block11;
            if (whGradeVO.isSystemGradeEmail() && waitSendEmailMap != null) {
                for (Map.Entry entry : warehouseEmailContentMap.entrySet()) {
                    this.buildWaitSendGradeEmailObj(waitSendEmailMap, "SEND_EMAIL_WAREHOUSE-" + (String)entry.getKey(), Arrays.asList(((String)entry.getKey()).split(",")), (String)entry.getKey(), emailContent.toString(), ((StringBuffer)entry.getValue()).toString(), null);
                }
            } else {
                for (Map.Entry entry : warehouseEmailContentMap.entrySet()) {
                    ((StringBuffer)entry.getValue()).append(tableBottom);
                    this.sendStockChangeEmailForGradeAdjust(Arrays.asList(((String)entry.getKey()).split(",")), emailContent.toString() + ((StringBuffer)entry.getValue()).toString(), null);
                }
            }
        }
    }

    @Override
    public void sendStockChangeEmailForGradeAdjust(List<String> toAddressList, String emailContent, List<Long> affectIds) {
        EmailVO emailVO = new EmailVO();
        emailVO.setToAddressList(toAddressList);
        emailVO.setSubject("\u5546\u54c1\u54c1\u7ea7\u8c03\u6574\u5bfc\u81f4\u5e93\u5b58\u53d8\u5316");
        emailVO.setContent(emailContent);
        if (CollectionUtils.isNotEmpty((Collection)emailVO.getToAddressList())) {
            try {
                log.info("\u5f00\u59cb\u53d1\u9001 \u5546\u54c1\u54c1\u7ea7\u8c03\u6574\u5bfc\u81f4\u5e93\u5b58\u53d8\u5316 \u90ae\u4ef6\uff1a" + emailVO.getToAddressList());
                boolean result = EmailUtil.getInstance().send(emailVO);
                if (result && CollectionUtils.isNotEmpty(affectIds)) {
                    this.updateWhGradeAffectInfoSendMailFlag(affectIds, 1, 0);
                }
                log.info("\u6210\u529f\u53d1\u9001 \u5546\u54c1\u54c1\u7ea7\u8c03\u6574\u5bfc\u81f4\u5e93\u5b58\u53d8\u5316 \u90ae\u4ef6\uff1a" + emailVO.getToAddressList());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void buildStockChangeGradeAdjust(StringBuffer emailContent, List<WhGradeAffectInfoVO> affectInfoVOs, Map<String, List<WhGradeAffectInfoVO>> gradeAffectMap, WhGradeOfQualityVO whGradeVO) {
        if (EmptyUtil.isNotEmpty(gradeAffectMap)) {
            Collections.sort(affectInfoVOs, new Comparator<WhGradeAffectInfoVO>(){

                @Override
                public int compare(WhGradeAffectInfoVO vo1, WhGradeAffectInfoVO vo2) {
                    return vo1.getWarehouseCode().compareTo(vo2.getWarehouseCode());
                }
            });
        }
        for (WhGradeAffectInfoVO affectInfoVO : affectInfoVOs) {
            emailContent.append("<tr>");
            emailContent.append("<td>[" + affectInfoVO.getWarehouseCode() + "]" + affectInfoVO.getWarehouseName() + "</td>");
            emailContent.append("<td>[" + whGradeVO.getSkuCode() + "]" + whGradeVO.getSkuName() + "</td>");
            emailContent.append("<td>" + affectInfoVO.getAmount() + "</td>");
            emailContent.append("<td>" + whGradeVO.getAdjustReason() + "</td>");
            emailContent.append("<td>" + affectInfoVO.getSyncResultStr() + "</td>");
            emailContent.append("</tr>");
            if (gradeAffectMap == null || !EmptyUtil.isNotEmpty((String)affectInfoVO.getWarehouseContactEmails())) continue;
            List<WhGradeAffectInfoVO> gradeAffectVOList = gradeAffectMap.get(affectInfoVO.getWarehouseContactEmails());
            if (CollectionUtils.isEmpty(gradeAffectVOList)) {
                gradeAffectVOList = new ArrayList<WhGradeAffectInfoVO>();
                gradeAffectMap.put(affectInfoVO.getWarehouseContactEmails(), gradeAffectVOList);
            }
            gradeAffectVOList.add(affectInfoVO);
        }
    }
}

