/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhExpressWaybillCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhExpressWaybillMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhExpressWaybillCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.model.WhExpressWaybill;
import com.thebeastshop.pegasus.service.warehouse.model.WhExpressWaybillExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhExpressWaybillService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhExpressWaybillVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import page.Pagination;

@Service(value="whExpressWaybillService")
public class WhExpressWaybillServiceImpl
implements WhExpressWaybillService {
    @Autowired
    private WhExpressWaybillMapper whExpressWaybillMapper;
    @Autowired
    private WhExpressWaybillCustomMapper whExpressWaybillCustomMapper;

    @Override
    public boolean insert(WhExpressWaybill whExpressWaybill) {
        return this.whExpressWaybillMapper.insert(whExpressWaybill) > 0;
    }

    @Override
    public boolean deleteById(Long id) {
        return this.whExpressWaybillMapper.deleteByPrimaryKey(id) > 0;
    }

    @Override
    public boolean deleteByCond(WhExpressWaybillCond cond) {
        if (EmptyUtil.isNotEmpty((Object)cond.getId())) {
            return this.deleteById(cond.getId());
        }
        WhExpressWaybillExample example = this.buildConditionExampleByCond(cond);
        return this.whExpressWaybillMapper.deleteByExample(example) > 0;
    }

    @Override
    public boolean updateByCond(WhExpressWaybill whExpressWaybill, WhExpressWaybillCond cond) {
        WhExpressWaybillExample example = this.buildConditionExampleByCond(cond);
        return this.whExpressWaybillMapper.updateByExampleSelective(whExpressWaybill, example) > 0;
    }

    @Override
    public boolean updateById(WhExpressWaybill whExpressWaybill) {
        return this.whExpressWaybillMapper.updateByPrimaryKeySelective(whExpressWaybill) > 0;
    }

    @Override
    public WhExpressWaybill findById(Long id) {
        return this.whExpressWaybillMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<WhExpressWaybill> findWhExpressWaybillByCond(WhExpressWaybillCond cond) {
        WhExpressWaybillExample example = this.buildConditionExampleByCond(cond);
        return this.whExpressWaybillMapper.selectByExample(example);
    }

    @Override
    public List<WhExpressWaybillVO> listWhExpressWaybillByCond(WhExpressWaybillCond cond) {
        return this.whExpressWaybillCustomMapper.listWhExpressWaybillByCond(cond);
    }

    @Override
    public Pagination<WhExpressWaybillVO> listWhExpressWaybillByCondPage(WhExpressWaybillCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int count = this.whExpressWaybillCustomMapper.getCountByCond(cond);
        page.setRecord(Integer.valueOf(count));
        if (NumberUtil.isNullOrZero((Number)count)) {
            return null;
        }
        page.setResultList(this.whExpressWaybillCustomMapper.listWhExpressWaybillByCond(cond));
        if (NumberUtil.isNullOrZero((Number)count)) {
            return null;
        }
        return page;
    }

    @Override
    public boolean batchCreate(List<WhExpressWaybillVO> whExpressWaybillVOs) {
        if (CollectionUtils.isEmpty(whExpressWaybillVOs)) {
            return false;
        }
        return this.whExpressWaybillCustomMapper.batchInsert(whExpressWaybillVOs) > 0;
    }

    private WhExpressWaybillExample buildConditionExampleByCond(WhExpressWaybillCond cond) {
        WhExpressWaybillExample example = new WhExpressWaybillExample();
        WhExpressWaybillExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty(cond.getCommandCodes())) {
            criteria.andCommandCodeIn((List)cond.getCommandCodes());
        } else if (EmptyUtil.isNotEmpty((String)cond.getCommandCode())) {
            criteria.andCommandCodeEqualTo(cond.getCommandCode());
        } else if (EmptyUtil.isNotEmpty((String)cond.getCommandCodeLike())) {
            criteria.andCommandCodeLike(SQLUtils.allLike((String)cond.getCommandCodeLike()));
        }
        if (EmptyUtil.isNotEmpty((String)cond.getReferenceCode())) {
            criteria.andReferenceCodeEqualTo(cond.getReferenceCode());
        } else if (EmptyUtil.isNotEmpty((String)cond.getReferenceCodeLike())) {
            criteria.andReferenceCodeLike(SQLUtils.allLike((String)cond.getReferenceCodeLike()));
        }
        if (EmptyUtil.isNotEmpty((String)cond.getExpressNo())) {
            criteria.andExpressNoEqualTo(cond.getExpressNo());
        } else if (EmptyUtil.isNotEmpty((String)cond.getExpressNoLike())) {
            criteria.andExpressNoLike(SQLUtils.allLike((String)cond.getExpressNoLike()));
        } else if (CollectionUtils.isNotEmpty(cond.getExpressNos())) {
            criteria.andExpressNoIn((List)cond.getExpressNos());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getExpressType())) {
            criteria.andExpressTypeEqualTo(cond.getExpressType());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getProcessStatus())) {
            criteria.andProcessStatusEqualTo(cond.getProcessStatus());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getCreateTimeBegin())) {
            criteria.andCreateTimeGreaterThanOrEqualTo(cond.getCreateTimeBegin());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getCreateTimeEnd())) {
            criteria.andCreateTimeLessThanOrEqualTo(cond.getCreateTimeEnd());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getRoutingInfo())) {
            criteria.andRoutingInfoEqualTo(cond.getRoutingInfo());
        }
        return example;
    }
}

