/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhDamagedRcdCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhDamagedRcdMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWastedRcdMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcdSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhDamagedRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWastedRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhWastedRcdExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhAllotService;
import com.thebeastshop.pegasus.service.warehouse.service.WhDamageWasteService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whDamageWasteService")
public class WhDamageWasteServiceImpl
implements WhDamageWasteService {
    private final Logger log = LoggerFactory.getLogger(WhDamageWasteServiceImpl.class);
    @Autowired
    private WhDamagedRcdMapper whDamagedRcdMapper;
    @Autowired
    private WhWastedRcdMapper whWastedRcdMapper;
    @Autowired
    private WhAllotService whAllotService;
    @Autowired
    private WhInfoService whInfoService;

    @Override
    @Transactional
    public Long recordDamage(WhDamagedRcd whDamagedRcd) throws Exception {
        String skuCode = whDamagedRcd.getSkuCode();
        Integer quantity = whDamagedRcd.getQuantity();
        if (EmptyUtil.isEmpty((String)whDamagedRcd.getTargetWarehouseCode())) {
            WhWarehouse targetWarehouse = this.whInfoService.findUniqDamagedWarehouse(whDamagedRcd.getSourceWarehouseCode());
            if (targetWarehouse == null) {
                throw new WarehouseException("WH0103", "\u627e\u4e0d\u5230\u76ee\u6807\u4ed3\u5e93");
            }
            whDamagedRcd.setTargetWarehouseCode(targetWarehouse.getCode());
        }
        whDamagedRcd.setCreateTime(new Date());
        this.whDamagedRcdMapper.insert(whDamagedRcd);
        WhAllotRcd whAllotRcd = new WhAllotRcd();
        whAllotRcd.setAllotType(WhAllotRcd.TYPE_DAMAGED);
        whAllotRcd.setReferenceCode(whDamagedRcd.getId() + "");
        whAllotRcd.setSourceWarehouseCode(whDamagedRcd.getSourceWarehouseCode());
        whAllotRcd.setTargetWarehouseCode(whDamagedRcd.getTargetWarehouseCode());
        ArrayList<WhAllotRcdSku> whAllotRcdSkuList = new ArrayList<WhAllotRcdSku>();
        WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
        whAllotRcdSku.setSkuCode(skuCode);
        whAllotRcdSku.setQuantity(quantity);
        whAllotRcdSkuList.add(whAllotRcdSku);
        whAllotRcd.setWhAllotRcdSkuList(whAllotRcdSkuList);
        this.whAllotService.createAllotRcd(whAllotRcd);
        return whDamagedRcd.getId();
    }

    @Override
    @Transactional
    public Long recordWaste(WhWastedRcd whWastedRcd) throws Exception {
        whWastedRcd.setCreateTime(new Date());
        this.whWastedRcdMapper.insert(whWastedRcd);
        WhAllotRcd whAllotRcd = new WhAllotRcd();
        whAllotRcd.setAllotType(WhAllotRcd.TYPE_WASTED);
        whAllotRcd.setReferenceCode(whWastedRcd.getId() + "");
        whAllotRcd.setSourceWarehouseCode(whWastedRcd.getSourceWarehouseCode());
        whAllotRcd.setTargetWarehouseCode(whWastedRcd.getTargetWarehouseCode());
        ArrayList<WhAllotRcdSku> whAllotRcdSkuList = new ArrayList<WhAllotRcdSku>();
        WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
        whAllotRcdSku.setSkuCode(whWastedRcd.getSkuCode());
        whAllotRcdSku.setQuantity(whWastedRcd.getQuantity());
        whAllotRcd.setWhAllotRcdSkuList(whAllotRcdSkuList);
        this.whAllotService.createAllotRcd(whAllotRcd);
        return whWastedRcd.getId();
    }

    @Override
    public Map<String, List<WhDamagedRcd>> findDamagedRcdBySkuCode(String skuCode) {
        WhDamagedRcdCond cond = new WhDamagedRcdCond();
        cond.setIncludeSkuCode(skuCode);
        List<WhDamagedRcd> whDamagedRcdList = this.findDamagedRcdByCond(cond);
        HashMap<String, List<WhDamagedRcd>> result = new HashMap<String, List<WhDamagedRcd>>();
        for (WhDamagedRcd whDamagedRcd : whDamagedRcdList) {
            String sourceWarehouseCode = whDamagedRcd.getSourceWarehouseCode();
            ArrayList<WhDamagedRcd> whDamagedRcdListInMap = (ArrayList<WhDamagedRcd>)result.get(sourceWarehouseCode);
            if (whDamagedRcdListInMap == null) {
                whDamagedRcdListInMap = new ArrayList<WhDamagedRcd>();
                result.put(sourceWarehouseCode, whDamagedRcdListInMap);
            }
            whDamagedRcdListInMap.add(whDamagedRcd);
        }
        return result;
    }

    @Override
    public List<WhDamagedRcd> findDamagedRcdBySkuCodeAndWarehouseCode(String skuCode, String sourceWarehouseCode) {
        WhDamagedRcdCond cond = new WhDamagedRcdCond();
        cond.setIncludeSkuCode(skuCode);
        cond.setSourceWarehouseCode(sourceWarehouseCode);
        return this.findDamagedRcdByCond(cond);
    }

    @Override
    public List<WhDamagedRcd> findDamagedRcdByCond(WhDamagedRcdCond cond) {
        return this.whDamagedRcdMapper.findDamagedRcdByCond(cond);
    }

    @Override
    public Map<String, List<WhWastedRcd>> findWastedRcdBySkuCode(String skuCode) {
        WhWastedRcdExample example = new WhWastedRcdExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode);
        example.setOrderByClause("id");
        List<WhWastedRcd> whWastedRcdList = this.whWastedRcdMapper.selectByExample(example);
        HashMap<String, List<WhWastedRcd>> result = new HashMap<String, List<WhWastedRcd>>();
        for (WhWastedRcd whWastedRcd : whWastedRcdList) {
            String sourceWarehouseCode = whWastedRcd.getSourceWarehouseCode();
            ArrayList<WhWastedRcd> whWastedRcdListInMap = (ArrayList<WhWastedRcd>)result.get(sourceWarehouseCode);
            if (whWastedRcdListInMap == null) {
                whWastedRcdListInMap = new ArrayList<WhWastedRcd>();
                result.put(sourceWarehouseCode, whWastedRcdListInMap);
            }
            whWastedRcdListInMap.add(whWastedRcd);
        }
        return result;
    }

    @Override
    public List<WhWastedRcd> findWastedRcdBySkuCodeAndWarehouseCode(String skuCode, String sourceWarehouseCode) {
        WhWastedRcdExample example = new WhWastedRcdExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode).andSourceWarehouseCodeEqualTo(sourceWarehouseCode);
        example.setOrderByClause("id");
        return this.whWastedRcdMapper.selectByExample(example);
    }

    @Override
    public boolean dealDamaged(String warehouseCode, String skuCode, Integer quantity, String type) throws Exception {
        WhWarehouse targetWarehouse;
        if (EmptyUtil.isEmpty((String)warehouseCode) || EmptyUtil.isEmpty((String)skuCode) || EmptyUtil.isEmpty((Object)quantity) || !"waste".equals(type) && !"fix".equals(type)) {
            throw new WarehouseException("CO0001", "\u53c2\u6570\u5f02\u5e38");
        }
        WhWarehouse whWarehouse = this.whInfoService.findWarehouseByCode(warehouseCode);
        if (!WhWarehouseVO.TYPE_DAMAGED.equals(whWarehouse.getWarehouseType())) {
            throw new WarehouseException("WH0104", "\u4ed3\u5e93\u7c7b\u578b\u9519\u8bef\uff0c\u5fc5\u987b\u662f\u6b8b\u6b21\u4ed3");
        }
        boolean isWaste = "waste".equals(type);
        WhWarehouse whWarehouse2 = targetWarehouse = isWaste ? this.whInfoService.findUniqWastedWarehouse(warehouseCode) : this.whInfoService.findUniqWaitForDispatchingWarehouse(warehouseCode);
        if (targetWarehouse == null) {
            throw new WarehouseException("WH0103", "\u76ee\u6807\u4ed3\u4e0d\u5b58\u5728");
        }
        WhAllotRcd whAllotRcd = new WhAllotRcd();
        whAllotRcd.setAllotType(isWaste ? WhAllotRcd.TYPE_WASTED : WhAllotRcd.TYPE_FIXED);
        whAllotRcd.setSourceWarehouseCode(whWarehouse.getCode());
        whAllotRcd.setTargetWarehouseCode(targetWarehouse.getCode());
        ArrayList<WhAllotRcdSku> whAllotRcdSkuList = new ArrayList<WhAllotRcdSku>();
        WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
        whAllotRcdSku.setSkuCode(skuCode);
        whAllotRcdSku.setQuantity(quantity);
        whAllotRcdSkuList.add(whAllotRcdSku);
        whAllotRcd.setWhAllotRcdSkuList(whAllotRcdSkuList);
        String allotCode = this.whAllotService.createAllotRcd(whAllotRcd);
        return EmptyUtil.isNotEmpty((String)allotCode);
    }
}

