/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.common.validation.Validation;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhCrossGoodsMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCrossGoods;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhCrossGoodsService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInvService;
import com.thebeastshop.pegasus.service.warehouse.service.WhTakeStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCrossGoodsCondVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCrossGoodsVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPhysicalWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Service
public class WhCrossGoodsServiceImpl
implements WhCrossGoodsService {
    @Autowired
    private WhCrossGoodsMapper whCrossGoodsMapper;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhInvService whInvService;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhTakeStockService whTakeStockService;

    @Override
    public Boolean addOrEditCrossGoodsApply(WhCrossGoods whCrossGoods) {
        if (null == whCrossGoods.getId()) {
            return this.whCrossGoodsMapper.insert(whCrossGoods) > 0;
        }
        return this.whCrossGoodsMapper.updateByPrimaryKeySelective(whCrossGoods) > 0;
    }

    @Override
    @Transactional
    public Boolean approveCrossGoodsApply(WhCrossGoods whCrossGoods) throws Exception {
        Boolean addOrEditFlag = this.addOrEditCrossGoodsApply(whCrossGoods);
        if (addOrEditFlag.booleanValue() && !whCrossGoods.getStatus().equals(3)) {
            WhCrossGoodsVO whCrossGoodsVO = this.detailCrossGoods(whCrossGoods.getId().longValue());
            Integer approveOpId = whCrossGoods.getApproveOperatorId();
            BeanUtils.copyProperties((Object)whCrossGoodsVO, (Object)whCrossGoods);
            whCrossGoods.setApproveOperatorId(approveOpId);
            WhInvVO whInvVO = this.whInvService.findCanUseQttBySkuCodeAndWarehouseCode(whCrossGoodsVO.getSourceSkuCode(), whCrossGoodsVO.getWarehouseCode());
            if (whInvVO.getCanUseInv() < whCrossGoodsVO.getAmount()) {
                throw new WarehouseException("CO0001", "\u903b\u8f91\u4ed3[" + whCrossGoodsVO.getWarehouseName() + "]\u4e2d SKU[" + whCrossGoodsVO.getSourceSkuCode() + "]\u6570\u91cf\u4e0d\u8db3," + whInvVO.getCanUseInv() + "<" + whCrossGoodsVO.getAmount());
            }
            WhInvRcd outWhInvRcd = new WhInvRcd();
            outWhInvRcd.setWarehouseCode(whCrossGoods.getWarehouseCode());
            outWhInvRcd.setQuantity(0 - whCrossGoods.getAmount());
            outWhInvRcd.setInOutType(WhCommand.TYPE_CROSSGOODS_OUT);
            outWhInvRcd.setCommandCode("CROSSGOODS_ID_" + whCrossGoods.getId().toString());
            outWhInvRcd.setSkuCode(whCrossGoods.getSourceSkuCode());
            outWhInvRcd.setSubmitTime(DateUtil.getNow());
            outWhInvRcd.setMemo(whCrossGoodsVO.getApplyRemark());
            outWhInvRcd.setSubmitUserId(whCrossGoods.getApproveOperatorId().longValue());
            WhInvRcd inWhInvRcd = new WhInvRcd();
            inWhInvRcd.setWarehouseCode(whCrossGoods.getWarehouseCode());
            inWhInvRcd.setQuantity(whCrossGoods.getAmount());
            inWhInvRcd.setInOutType(WhCommand.TYPE_CROSSGOODS_IN);
            inWhInvRcd.setCommandCode("CROSSGOODS_ID_" + whCrossGoods.getId().toString());
            inWhInvRcd.setSkuCode(whCrossGoods.getTargetSkuCode());
            inWhInvRcd.setSubmitTime(DateUtil.getNow());
            inWhInvRcd.setMemo(whCrossGoodsVO.getApplyRemark());
            inWhInvRcd.setSubmitUserId(whCrossGoods.getApproveOperatorId().longValue());
            ArrayList lists = Lists.newArrayList();
            lists.add(outWhInvRcd);
            lists.add(inWhInvRcd);
            this.whInvService.batchRecord(lists);
            HashMap<String, WhWarehouse> whMap = new HashMap<String, WhWarehouse>();
            WhWarehouse whWarehouse = this.whInfoService.findWarehouseByCode(whCrossGoods.getWarehouseCode());
            whMap.put(whCrossGoods.getWarehouseCode(), whWarehouse);
            WhPhysicalWarehouseVO physicalWarehouse = this.findPhysicalByWarehouseCode(whCrossGoods.getWarehouseCode());
            for (WhInvRcd invRcd : lists) {
                WhWarehouse wh = (WhWarehouse)whMap.get(invRcd.getWarehouseCode());
                Integer skuStatus = this.whCommandService.getSkuStatusByWarehouseType(wh.getCommodityStatus());
                this.whWmsSkuStockService.updatePhyWhSkuStock(physicalWarehouse.getCode(), invRcd.getSkuCode(), skuStatus, invRcd.getQuantity(), invRcd.getInOutType(), whCrossGoodsVO.getId().toString(), invRcd.getSubmitUserId(), invRcd.getMemo());
            }
        }
        return addOrEditFlag;
    }

    @Override
    public Pagination<WhCrossGoodsVO> listCrossGoods(WhCrossGoodsCondVO cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int count = this.whCrossGoodsMapper.countByCond(cond);
        page.setRecord(Integer.valueOf(count));
        if (NumberUtil.isNullOrZero((Number)count)) {
            return null;
        }
        List<WhCrossGoodsVO> applyVOList = this.whCrossGoodsMapper.selectByCond(cond);
        if (CollectionUtils.isEmpty(applyVOList)) {
            return null;
        }
        page.setResultList(applyVOList);
        return page;
    }

    @Override
    public WhCrossGoodsVO detailCrossGoods(Long id) {
        WhCrossGoodsCondVO crossGoodsCondVO = new WhCrossGoodsCondVO();
        crossGoodsCondVO.setId(id);
        return this.whCrossGoodsMapper.selectByCond(crossGoodsCondVO).get(0);
    }

    @Override
    @Transactional
    public Integer batchUpdate(List<Long> ids, Integer status, Long operatorId, String approveRemark) throws Exception {
        Integer res = 0;
        for (Long id : ids) {
            WhCrossGoods whCrossGoods = new WhCrossGoods();
            whCrossGoods.setId(id.intValue());
            whCrossGoods.setStatus(status);
            whCrossGoods.setApproveRemark(approveRemark);
            whCrossGoods.setApproveOperatorId(operatorId.intValue());
            if (!this.approveCrossGoodsApply(whCrossGoods).booleanValue()) continue;
            Integer n = res;
            Integer n2 = res = Integer.valueOf(res + 1);
        }
        return res;
    }

    private WhWmsHouseShelvesVO getWhWmsHouseShelves(String physicalWarehouseCode, Integer skuStatus) {
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setSkuStatus(skuStatus);
        List<WhWmsHouseShelvesVO> whWmsHouseShelvesList = this.whWmsHouseShelvesService.getHouseShelvesByCond(cond);
        if (CollectionUtils.isEmpty(whWmsHouseShelvesList)) {
            throw new WarehouseException("WH0001", "\u7269\u7406\u4ed3[" + cond.getPhysicalWarehouseCode() + "],SKU[" + cond.getSkuCode() + "],SKU\u72b6\u6001[" + WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus()) + "],\u5e93\u4f4d\u4e0d\u5b58\u5728!");
        }
        if (whWmsHouseShelvesList.size() > 1) {
            throw new WarehouseException("WH0001", "\u7269\u7406\u4ed3[" + cond.getPhysicalWarehouseCode() + "],SKU[" + cond.getSkuCode() + "],SKU\u72b6\u6001[" + WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus()) + "],\u67e5\u8be2\u6709\u591a\u4e2a\u5e93\u4f4d!");
        }
        return whWmsHouseShelvesList.get(0);
    }

    private WhPhysicalWarehouseVO findPhysicalByWarehouseCode(String warehouseCode) {
        Validation.paramNotNull((Object)warehouseCode, (String)"\u903b\u8f91\u4ed3\u7f16\u7801\u4e3a\u7a7a");
        List<WhPhysicalWarehouseVO> physicalWarehouseVOs = this.whInfoService.findPhysicalWarehouseByWarehouseCode(warehouseCode);
        Iterator<WhPhysicalWarehouseVO> iter = physicalWarehouseVOs.iterator();
        while (iter.hasNext()) {
            WhPhysicalWarehouseVO whPhysicalWarehouseVO = iter.next();
            if (!whPhysicalWarehouseVO.getWarehouseType().equals(WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS)) continue;
            iter.remove();
        }
        if (CollectionUtils.isEmpty(physicalWarehouseVOs)) {
            throw new WarehouseException("WH0103", "\u903b\u8f91\u4ed3[" + warehouseCode + "]\u5728\u903b\u8f91\u4ed3\u5206\u7ec4\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u7406\u4ed3\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        if (physicalWarehouseVOs.size() > 1) {
            throw new WarehouseException("WH0001", "\u903b\u8f91\u4ed3[" + warehouseCode + "]\u5bf9\u5e94\u7684\u7269\u7406\u4ed3\u6709\u591a\u4e2a\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        return physicalWarehouseVOs.get(0);
    }
}

