/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.taobao.api.response.ItemQuantityUpdateResponse;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.integration.express.zt.ZTOrderSubmitKeys;
import com.thebeastshop.pegasus.integration.express.zt.ZTOrderSubmitResponse;
import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.cond.WhCommandCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhConnectAltPackageCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhSalesReturnExceptionCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhSalesReturnExceptionSkuCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsCommandInfoCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsReceiveShelvesDetailCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsSkuBarcodeCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsWaitOutStockCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsWaitOutStockCondAlt;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsWaitOutStockCondPcsRtn;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsWaitOutStockCondRecWaste;
import com.thebeastshop.pegasus.service.warehouse.dao.TmallStockLogMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhCommandMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhCommandOutFinishMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhCommandSkuMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhPhysicalWarehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhSalesReturnExceptionMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhSalesReturnExceptionSkuMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWarehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsCommandShortRecordMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsHouseShelvesMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsShelvesSkuInfoMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsSkuStockMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsSkuStockRecordMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsSubmitHandRecordMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhSalesReturnExceptionCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhSalesReturnExceptionSkuCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.TmallStockLog;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandOutFinish;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandOutFinishExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSkuExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvOccupy;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhSalesReturnException;
import com.thebeastshop.pegasus.service.warehouse.model.WhSalesReturnExceptionExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhSalesReturnExceptionSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhSalesReturnExceptionSkuExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsCommandShortRecord;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsCommandShortRecordExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsPrdcJobTaskDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsReceiveShelvesDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsShelvesSkuInfo;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuBarcode;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStock;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStockRecord;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSubmitHandRecord;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSubmitHandRecordExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWaitPutaway;
import com.thebeastshop.pegasus.service.warehouse.model.WmsPurchaseReturn;
import com.thebeastshop.pegasus.service.warehouse.model.WmsPurchaseReturnSku;
import com.thebeastshop.pegasus.service.warehouse.service.WhAllotService;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhDamageWasteService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInvService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWarehouseGroupService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandPreOccupyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectAllotPackageService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsPrdcJobTaskDetailService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsPrdcJobTaskService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsReceiveShelvesDetailService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsShelvesSkuInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuBarcodeService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockRecordService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWaitPutawayService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotPackageInBoundSkuDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotPackageInBoundVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCommandAssoExpressVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCommandCountVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPackageInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPhysicalWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhQualityControlVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhReceiveShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhReleaseOccupationVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhSalesReturnExceptionSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhSalesReturnExceptionVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhSkuInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectAllotPackageDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectAllotPackageVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPrdcJobTaskVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsReceiveShelvesDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuBarcodeVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockRecordVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsWaitOutStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsWaitPutawayVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import com.thebeastshop.pegasus.util.model.CommFileRef;
import com.thebeastshop.pegasus.util.model.CommFileRefExample;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import com.thebeastshop.pegasus.util.vo.JdStockSyncResult;
import com.thebeastshop.stock.dto.SStockOccupyDTO;
import com.thebeastshop.stock.dto.SStockReleaseDTO;
import com.thebeastshop.stock.enums.SStockOccupyTypeEnum;
import com.thebeastshop.stock.enums.SStockOperationTypeEnum;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.service.SWhCommandService;
import com.thebeastshop.stock.vo.SStockRecordVO;
import com.thebeastshop.stock.vo.SWhCommandSkuVO;
import com.thebeastshop.stock.vo.SWhCommandVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Service(value="whCommandService")
public class WhCommandServiceImpl
implements WhCommandService {
    private final Logger log = LoggerFactory.getLogger(WhCommandServiceImpl.class);
    @Autowired
    private WhCommandMapper whCommandMapper;
    @Autowired
    private WhCommandSkuMapper whCommandSkuMapper;
    @Autowired
    private WhPhysicalWarehouseMapper whPhysicalWarehouseMapper;
    @Autowired
    private WhInvService whInvService;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhAllotService whAllotService;
    @Autowired
    private WhWmsConnectAllotPackageService whWmsConnectAllotPackageService;
    @Autowired
    private WhDamageWasteService whDamageWasteService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhWmsSkuStockRecordService whWmsSkuStockRecordService;
    @Autowired
    private WhWmsWaitPutawayService whWmsWaitPutawayService;
    @Autowired
    private WhWmsSkuBarcodeService whWmsSkuBarcodeService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsCommandShortRecordMapper whWmsCommandShortRecordMapper;
    @Autowired
    private WhCommandOutFinishMapper whCommandOutFinishMapper;
    @Autowired
    private TmallStockLogMapper tmallStockLogMapper;
    @Autowired
    private WhWarehouseMapper whWarehouseMapper;
    private PegasusUtilFacade pegasusUtilFacade = PegasusUtilFacade.getInstance();
    @Autowired
    private TaskExecutor myScheduler;
    @Autowired
    private WhWmsSubmitHandRecordMapper whWmsSubmitHandRecordMapper;
    @Autowired
    private WhWmsSkuStockRecordMapper whWmsSkuStockRecordMapper;
    @Autowired
    private WhWmsSkuStockMapper whWmsSkuStockMapper;
    @Autowired
    private WhWmsHouseShelvesMapper whWmsHouseShelvesMapper;
    @Autowired
    private SStockService sStockService;
    @Autowired
    private SWhCommandService sWhCommandService;
    @Autowired
    private WhWmsCommandPreOccupyService whWmsCommandPreOccupyService;
    @Autowired
    private WhSalesReturnExceptionMapper whSalesReturnExceptionMapper;
    @Autowired
    private WhSalesReturnExceptionCustomMapper whSalesReturnExceptionCustomMapper;
    @Autowired
    private WhSalesReturnExceptionSkuMapper whSalesReturnExceptionSkuMapper;
    @Autowired
    private WhSalesReturnExceptionSkuCustomMapper whSalesReturnExceptionSkuCustomMapper;
    @Autowired
    private WhWarehouseGroupService whWarehouseGroupService;
    @Autowired
    private WhWmsReceiveShelvesDetailService whWmsReceiveShelvesDetailService;
    @Autowired
    private WhWmsPrdcJobTaskDetailService whWmsPrdcJobTaskDetailService;
    @Autowired
    private WhWmsPrdcJobTaskService whWmsPrdcJobTaskService;
    @Autowired
    private WhWmsShelvesSkuInfoMapper whWmsShelvesSkuInfoMapper;
    @Autowired
    private WhWmsShelvesSkuInfoService whWmsShelvesSkuInfoService;

    @Override
    @Transactional
    public String createCommand(WhCommand whCommand) {
        this.buildAndCreateCommandWithOccupy(whCommand);
        return whCommand.getCode();
    }

    @Override
    @Transactional
    public boolean recordCommand(List<WhCommand> cmdList) {
        List sCmdList = cmdList.stream().map(whCommand -> {
            Integer commandStatus = whCommand.getCommandStatus();
            SWhCommandVO sWhCommand = this.buildCommandForCreate((WhCommand)whCommand);
            sWhCommand.setCommandStatus(commandStatus);
            return sWhCommand;
        }).collect(Collectors.toList());
        this.sWhCommandService.recordWhCommand(sCmdList);
        return true;
    }

    private boolean buildAndCreateCommandWithOccupy(WhCommand whCommand) {
        SWhCommandVO sWhCommand = this.buildCommandForCreate(whCommand);
        SWhCommandVO createdCmdDto = this.sWhCommandService.createWhCommandWithOccupy(sWhCommand);
        this.copyWhCommandProps(createdCmdDto, whCommand);
        return true;
    }

    private boolean buildAndCreateCommand(WhCommand whCommand) {
        SWhCommandVO sWhCommand = this.buildCommandForCreate(whCommand);
        SWhCommandVO createdCmdDto = this.sWhCommandService.createWhCommand(sWhCommand);
        this.copyWhCommandProps(createdCmdDto, whCommand);
        return true;
    }

    private SWhCommandVO buildCommandForCreate(WhCommand whCommand) {
        List<WhCommandSku> whCommandSkuList;
        if (NullUtil.isNull((Object)whCommand.getCommodityStatus())) {
            if (EmptyUtil.isEmpty((String)whCommand.getWarehouseCode())) {
                throw new WarehouseException("CO0001", "\u6307\u4ee4\u884c\u5546\u54c1\u72b6\u6001\u5f02\u5e38");
            }
            WhWarehouse warehouse = this.whInfoService.findWarehouseByCode(whCommand.getWarehouseCode());
            whCommand.setCommodityStatus(warehouse.getCommodityStatus());
        }
        if (EmptyUtil.isEmpty((Object)(whCommandSkuList = whCommand.getWhCommandSkuList()).isEmpty())) {
            throw new WarehouseException("CO0001", "\u6307\u4ee4\u884c\u4e0d\u53ef\u4e3a\u7a7a");
        }
        for (WhCommandSku whCommandSku : whCommandSkuList) {
            if (EmptyUtil.isEmpty((String)whCommandSku.getSkuCode())) {
                throw new WarehouseException("CO0001", "SKU\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!NumberUtil.isNullOrZero((Number)whCommandSku.getPlanedQuantity())) continue;
            throw new WarehouseException("CO0001", "SKU\u7684\u8ba1\u5212\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Date now = DateUtil.getNow();
        whCommand.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
        whCommand.setCreateTime(now);
        if (whCommand.getExpressType() == null) {
            whCommand.setExpressType(WMSConstants.ExpressType.DEFAULT);
        }
        whCommand.setCancelFlag(0);
        whCommand.setFailureStartConnect(0);
        SWhCommandVO sWhCommandVO = (SWhCommandVO)BeanUtil.buildFrom((Object)whCommand, SWhCommandVO.class);
        List sWhCommandSkuList = BeanUtil.buildListFrom(whCommand.getWhCommandSkuList(), SWhCommandSkuVO.class);
        sWhCommandVO.setCommandSkuList(sWhCommandSkuList);
        return sWhCommandVO;
    }

    private void copyWhCommandProps(SWhCommandVO createdCmdDto, WhCommand whCommand) {
        if (NullUtil.isNull((Object)createdCmdDto)) {
            return;
        }
        BeanUtils.copyProperties((Object)createdCmdDto, (Object)whCommand);
        whCommand.setRollbackOccupyList(null);
        if (EmptyUtil.isNotEmpty((List)createdCmdDto.getCommandSkuList())) {
            ArrayList<WhCommandSku> whCommandSkuList = new ArrayList<WhCommandSku>();
            for (SWhCommandSkuVO sWhCommandSkuVO : createdCmdDto.getCommandSkuList()) {
                WhCommandSku commandSku = new WhCommandSku();
                BeanUtils.copyProperties((Object)sWhCommandSkuVO, (Object)commandSku);
                whCommandSkuList.add(commandSku);
            }
            whCommand.setWhCommandSkuList(whCommandSkuList);
        }
    }

    @Override
    @Transactional
    public String createCommandWithoutOccupy(WhCommand whCommand) {
        this.buildAndCreateCommand(whCommand);
        return whCommand.getCode();
    }

    @Deprecated
    @Transactional
    public void buildAndCreateCommand_old(WhCommand whCommand) {
        List<WhCommandSku> whCommandSkuList = whCommand.getWhCommandSkuList();
        if (whCommandSkuList == null && whCommandSkuList.isEmpty()) {
            throw new WarehouseException("CO0001", "whCommandSkuList can not be empty.");
        }
        for (WhCommandSku whCommandSku : whCommandSkuList) {
            if (whCommandSku.getPlanedQuantity() != null && whCommandSku.getPlanedQuantity() != 0) continue;
            throw new WarehouseException("CO0001", "SKU\u7684\u8ba1\u5212\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Date current = new Date();
        whCommand.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
        whCommand.setCreateTime(current);
        if (whCommand.getExpressType() == null) {
            whCommand.setExpressType(WMSConstants.ExpressType.DEFAULT);
        }
        whCommand.setCancelFlag(0);
        whCommand.setFailureStartConnect(0);
        SWhCommandVO sWhCommandVO = this.sWhCommandService.insertCommand((SWhCommandVO)BeanUtil.buildFrom((Object)whCommand, SWhCommandVO.class));
        whCommand.setId(sWhCommandVO.getId());
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("createTime", current);
        params.put("inOutType", whCommand.getInOutType());
        params.put("id", whCommand.getId());
        String code = CodeGenerator.getInstance().generate("WH_COMMAND", params);
        whCommand.setCode(code);
        this.sWhCommandService.updateWhCommandByKey((SWhCommandVO)BeanUtil.buildFrom((Object)whCommand, SWhCommandVO.class));
        for (WhCommandSku whCommandSku : whCommandSkuList) {
            if (EmptyUtil.isEmpty((String)whCommandSku.getSkuCode())) {
                throw new WarehouseException("CO0001", "skuCode can not be empty.");
            }
            whCommandSku.setCommandId(whCommand.getId());
            whCommandSku.setCode(null);
            SWhCommandSkuVO sWhCommandSkuVO = this.sWhCommandService.insertCommandSku((SWhCommandSkuVO)BeanUtil.buildFrom((Object)whCommandSku, SWhCommandSkuVO.class));
            whCommandSku.setId(sWhCommandSkuVO.getId());
            HashMap<String, Object> skuParams = new HashMap<String, Object>();
            skuParams.put("whCommandCode", whCommand.getCode());
            skuParams.put("id", whCommandSku.getId());
            whCommandSku.setCode(CodeGenerator.getInstance().generate("WH_COMMAND_SKU", skuParams));
            this.sWhCommandService.updateWhCommandSkuByKey((SWhCommandSkuVO)BeanUtil.buildFrom((Object)whCommandSku, SWhCommandSkuVO.class));
        }
    }

    @Override
    @Transactional
    @Deprecated
    public String createCommand(WhCommand whCommand, List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        ServiceResp serviceResp;
        this.buildAndCreateCommand(whCommand);
        ArrayList<SStockOccupyDTO> occupyDTOList = new ArrayList<SStockOccupyDTO>();
        if (!whCommand.isIn()) {
            for (WhCommandSku whCommandSku : whCommand.getWhCommandSkuList()) {
                SStockOccupyDTO occupyDTO = new SStockOccupyDTO();
                occupyDTO.setWarehouseCode(whCommand.getWarehouseCode());
                occupyDTO.setOccupyType(SStockOccupyTypeEnum.getEnumByCode((Integer)whCommand.getInOutType()));
                occupyDTO.setOperationType(SStockOperationTypeEnum.DEFAULT);
                occupyDTO.setReferenceCode(whCommandSku.getCode());
                occupyDTO.setSkuCode(whCommandSku.getSkuCode());
                occupyDTO.setQuantity(whCommandSku.getPlanedQuantity());
                occupyDTOList.add(occupyDTO);
            }
        }
        if (EmptyUtil.isEmpty(occupyDTOList) && EmptyUtil.isNotEmpty(whReleaseOccupationVOList) && (serviceResp = this.sStockService.release(this.whInvService.convertWhRelease2DTO(whReleaseOccupationVOList))).isFailure()) {
            throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
        if (EmptyUtil.isNotEmpty(occupyDTOList) && EmptyUtil.isEmpty(whReleaseOccupationVOList) && (serviceResp = this.sStockService.occupy(occupyDTOList)).isFailure()) {
            throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
        if (EmptyUtil.isNotEmpty(occupyDTOList) && EmptyUtil.isNotEmpty(whReleaseOccupationVOList) && (serviceResp = this.sStockService.occupyAfterRelease(occupyDTOList, this.whInvService.convertWhRelease2DTO(whReleaseOccupationVOList))).isFailure()) {
            throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
        return whCommand.getCode();
    }

    @Override
    @Transactional
    public String createCommandAfterReleasePreOccupy(WhCommand whCommand, List<SStockReleaseDTO> releaseList) throws Exception {
        SWhCommandVO sWhCommandVO = this.buildCommandForCreate(whCommand);
        sWhCommandVO = this.sWhCommandService.createWhCommand(sWhCommandVO);
        ArrayList<SStockOccupyDTO> occupyList = new ArrayList<SStockOccupyDTO>();
        for (SWhCommandSkuVO whCommandSku : sWhCommandVO.getCommandSkuList()) {
            SStockOccupyDTO occupyDTO = new SStockOccupyDTO();
            occupyDTO.setWarehouseCode(whCommand.getWarehouseCode());
            occupyDTO.setOccupyType(SStockOccupyTypeEnum.getEnumByCode((Integer)whCommand.getInOutType()));
            occupyDTO.setOperationType(SStockOperationTypeEnum.DEFAULT);
            occupyDTO.setReferenceCode(whCommandSku.getCode());
            occupyDTO.setSkuCode(whCommandSku.getSkuCode());
            occupyDTO.setQuantity(whCommandSku.getPlanedQuantity());
            occupyList.add(occupyDTO);
        }
        ServiceResp resp = this.sStockService.occupyAfterRelease(occupyList, releaseList);
        if (resp.isFailure()) {
            throw new WarehouseException(resp.getRespMsg());
        }
        return sWhCommandVO.getCode();
    }

    @Override
    @Transactional
    public String createCommandThenFinish(WhCommand whCommand) throws Exception {
        String commandCode = this.createCommand(whCommand);
        whCommand.setCode(commandCode);
        this.finishCommandByCode(whCommand);
        return commandCode;
    }

    @Override
    @Transactional
    public List<String> createCommandsThenFinish(List<WhCommand> whCommands) throws Exception {
        ArrayList<String> cmdCodes = new ArrayList<String>();
        for (WhCommand whCommand : whCommands) {
            String commandCode = this.createCommandThenFinish(whCommand);
            cmdCodes.add(commandCode);
        }
        return cmdCodes;
    }

    @Override
    @Transactional
    public String createCommandAfterRelease(WhCommand whCommand, List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        String commandCode = this.createCommand(whCommand, whReleaseOccupationVOList);
        return commandCode;
    }

    @Override
    @Transactional
    public String createCommandAfterOccupy(WhCommand whCommand, List<WhInvOccupy> whInvOccupyList) {
        this.whInvService.occupy(whInvOccupyList);
        String commandCode = this.createCommand(whCommand);
        return commandCode;
    }

    @Override
    @Transactional
    public String createCommandAfterReleaseThenFinish(WhCommand whCommand, List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        String commandCode = this.createCommandAfterRelease(whCommand, whReleaseOccupationVOList);
        whCommand.setCode(commandCode);
        this.finishCommandByCode(whCommand);
        return commandCode;
    }

    @Override
    @Transactional
    public String createCommandThenFinishWithoutOccupy(WhCommand whCommand, List<WhReleaseOccupationVO> releaseList) {
        String comandCode = this.createCommandWithoutOccupy(whCommand);
        WhCommand tmpCmd = this.findCommandByCode(comandCode, true);
        this.finishCommandWithoutOccupy(tmpCmd, releaseList);
        return comandCode;
    }

    @Override
    @Transactional
    public String createCommandThenFinishForSales(WhCommand rcd, List<WhReleaseOccupationVO> releaseList, List<WhInvRcd> invRcdList, String uniqueCode) {
        SWhCommandVO currentCommand;
        boolean phyWhStockUpdateResult;
        String comandCode = this.createCommandWithoutOccupy(rcd);
        if (EmptyUtil.isNotEmpty(invRcdList)) {
            for (WhInvRcd invRcd : invRcdList) {
                invRcd.setCommandCode(rcd.getCode());
            }
        }
        this.recordCommandOutFinishDone(comandCode);
        rcd.setCommandStatus(WhCommand.STATUS_FINISHED);
        if (EmptyUtil.isEmpty(rcd.getWhCommandSkuList())) {
            rcd.setWhCommandSkuList(this.findCommandSkuByCommandCode(rcd.getCode()));
        }
        if (!(phyWhStockUpdateResult = this.updatePhyWhSkuStockOut(invRcdList, rcd))) {
            throw new WarehouseException("WH0001", "\u66f4\u65b0\u7269\u7406\u4ed3\u5e93\u5b58\u5931\u8d25!");
        }
        SWhCommandVO sWhCommand = this.convertCommandToDto(rcd);
        sWhCommand.setStockRecordList(this.convertInvRcdToDto(invRcdList));
        if (EmptyUtil.isNotEmpty(releaseList)) {
            List<SStockReleaseDTO> stockReleaseList = this.whInvService.convertWhRelease2DTO(releaseList);
            sWhCommand.setStockReleaseList(stockReleaseList);
        }
        if (!WhCommand.STATUS_IN_PROCESSING.equals((currentCommand = this.sWhCommandService.finishWhCommand(sWhCommand)).getCommandStatus())) {
            throw new WarehouseException("WH0001", String.format("[%s]\u6307\u4ee4\u72b6\u6001[%s]!", rcd.getCode(), WhCommand.getCommandStatusStr(currentCommand.getCommandStatus())));
        }
        return comandCode;
    }

    private void recordCommandOutFinishDone(String unionCode) {
        if (EmptyUtil.isEmpty((String)unionCode)) {
            WhCommandOutFinish outFinish = new WhCommandOutFinish();
            outFinish.setCommandCode(unionCode);
            outFinish.setStatus(1);
            outFinish.setWhStatus(1);
            outFinish.setFinishDate(DateUtil.getNow());
            this.whCommandOutFinishMapper.insert(outFinish);
        }
    }

    @Override
    @Transactional
    public boolean finishOutCommandForSales(WhCommand rcd, List<WhReleaseOccupationVO> releaseList, List<WhInvRcd> invRcdList) {
        SWhCommandVO currentCommand;
        boolean phyWhStockUpdateResult;
        if (EmptyUtil.isNotEmpty(invRcdList)) {
            for (WhInvRcd invRcd : invRcdList) {
                invRcd.setCommandCode(rcd.getCode());
            }
        }
        this.recordCommandOutFinishDone(rcd.getCode());
        rcd.setCommandStatus(WhCommand.STATUS_FINISHED);
        if (EmptyUtil.isEmpty(rcd.getWhCommandSkuList())) {
            rcd.setWhCommandSkuList(this.findCommandSkuByCommandCode(rcd.getCode()));
        }
        if (!(phyWhStockUpdateResult = this.updatePhyWhSkuStockOut(invRcdList, rcd))) {
            throw new WarehouseException("WH0001", "\u66f4\u65b0\u7269\u7406\u4ed3\u5e93\u5b58\u5931\u8d25!");
        }
        SWhCommandVO sWhCommand = this.convertCommandToDto(rcd);
        sWhCommand.setStockRecordList(this.convertInvRcdToDto(invRcdList));
        if (EmptyUtil.isNotEmpty(releaseList)) {
            List<SStockReleaseDTO> stockReleaseList = this.whInvService.convertWhRelease2DTO(releaseList);
            sWhCommand.setStockReleaseList(stockReleaseList);
        }
        if (!WhCommand.STATUS_IN_PROCESSING.equals((currentCommand = this.sWhCommandService.finishWhCommand(sWhCommand)).getCommandStatus())) {
            throw new WarehouseException("WH0001", String.format("[%s]\u6307\u4ee4\u72b6\u6001[%s]!", rcd.getCode(), WhCommand.getCommandStatusStr(currentCommand.getCommandStatus())));
        }
        return true;
    }

    @Override
    @Transactional
    public List<String> createCommandsAfterReleaseThenFinish(List<WhCommand> whCommands, List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        ArrayList<String> commandCodes = new ArrayList<String>();
        this.whInvService.releaseOccupation(whReleaseOccupationVOList);
        for (WhCommand whCommand : whCommands) {
            String commandCode = this.createCommand(whCommand);
            commandCodes.add(commandCode);
            this.finishCommand(whCommand);
        }
        return commandCodes;
    }

    @Override
    @Transactional
    public List<String> createCommandsAfterReleaseThenFinishForPrdc(List<WhCommand> whCommands, List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        ArrayList<String> commandCodes = new ArrayList<String>();
        this.whInvService.releaseOccupation(whReleaseOccupationVOList);
        for (WhCommand whCommand : whCommands) {
            String commandCode = this.createCommand(whCommand);
            commandCodes.add(commandCode);
            this.finishCommandForPrdc(whCommand);
        }
        return commandCodes;
    }

    @Override
    @Transactional
    public List<String> createCommandsAfterReleaseThenFinishThenOccupy(List<WhCommand> whCommands, List<WhReleaseOccupationVO> whReleaseOccupationVOList, List<WhInvOccupy> whInvOccupyList) throws Exception {
        ArrayList<String> commandCodes = new ArrayList<String>();
        if (whInvOccupyList != null && whInvOccupyList.isEmpty()) {
            this.whInvService.releaseOccupation(whReleaseOccupationVOList);
        } else {
            this.whInvService.occupyAfterRelease(whInvOccupyList, whReleaseOccupationVOList);
        }
        for (WhCommand whCommand : whCommands) {
            String commandCode = this.createCommand(whCommand);
            commandCodes.add(commandCode);
            this.finishCommand(whCommand);
        }
        return commandCodes;
    }

    @Override
    @Transactional
    public String createCommandAfterOccupyThenFinish(WhCommand whCommand, List<WhInvOccupy> whInvOccupyList) throws Exception {
        String commandCode = this.createCommandAfterOccupy(whCommand, whInvOccupyList);
        whCommand.setCode(commandCode);
        this.finishCommandByCode(whCommand);
        return commandCode;
    }

    @Override
    public List<WhCommand> findCommandByCodes(List<String> codeList, boolean fetch) {
        if (EmptyUtil.isEmpty(codeList)) {
            return new ArrayList<WhCommand>();
        }
        WhCommandCond cond = new WhCommandCond();
        cond.setCodeList(codeList);
        cond.setFetch(fetch);
        return this.findCommandByCond(cond);
    }

    @Override
    public List<WhCommandSku> findCommandSkuByCommandCodes(List<String> commandCodeList) {
        return this.whCommandSkuMapper.findCommandSkuByCommandCodes(commandCodeList);
    }

    @Override
    public List<WhCommandSku> findCommandSkuByCommandSkuCodes(List<String> commandSkuCodeList) {
        return this.whCommandSkuMapper.findCommandSkuByCommandSkuCodes(commandSkuCodeList);
    }

    @Override
    public List<WhCommand> findInProcessCommandByWarehouseAndAndCodes(List<String> warehouseCodeList, List<String> codeList) {
        if (EmptyUtil.isEmpty(warehouseCodeList) || EmptyUtil.isEmpty(codeList)) {
            return new ArrayList<WhCommand>();
        }
        WhCommandExample example = new WhCommandExample();
        example.createCriteria().andCommandStatusEqualTo(WhCommand.STATUS_IN_PROCESSING).andWarehouseCodeIn((List)warehouseCodeList).andCodeIn((List)codeList);
        List<WhCommand> result = this.whCommandMapper.selectByExample(example);
        this.fillCommandSku(result);
        return result;
    }

    @Override
    public WhCommand findCommandByCode(String code, boolean fetch) {
        WhCommandCond cond = new WhCommandCond();
        cond.setCode(code);
        cond.setFetch(fetch);
        List<WhCommand> whCommandList = this.findCommandByCond(cond);
        return whCommandList != null && !whCommandList.isEmpty() ? whCommandList.get(0) : null;
    }

    @Override
    public WhCommand findNewCommandByCode(String code, boolean fetch) {
        WhCommandCond cond = new WhCommandCond();
        cond.setCode(code);
        cond.setFetch(fetch);
        List<WhCommand> whCommandList = this.findNewCommandByCond(cond);
        return whCommandList != null && !whCommandList.isEmpty() ? whCommandList.get(0) : null;
    }

    @Override
    public WhCommand findCommandById(Integer id, boolean fetch) {
        WhCommandCond cond = new WhCommandCond();
        cond.setId(id);
        cond.setFetch(fetch);
        List<WhCommand> whCommandList = this.findCommandByCond(cond);
        return whCommandList != null && !whCommandList.isEmpty() ? whCommandList.get(0) : null;
    }

    @Override
    public List<WhCommand> findInProcessCommandByIncrement(List<String> warehouseCodeList, Date incrementTime) {
        if (EmptyUtil.isEmpty(warehouseCodeList) || EmptyUtil.isEmpty((Object)incrementTime)) {
            return new ArrayList<WhCommand>();
        }
        WhCommandExample example = new WhCommandExample();
        example.createCriteria().andCommandStatusEqualTo(WhCommand.STATUS_IN_PROCESSING).andWarehouseCodeIn((List)warehouseCodeList).andCreateTimeGreaterThanOrEqualTo(incrementTime);
        List<WhCommand> result = this.whCommandMapper.selectByExample(example);
        this.fillCommandSku(result);
        return result;
    }

    @Override
    public WhCommand findCommandByTypeAndReferenceCode(Integer type, String referenceCode, boolean fetch) {
        WhCommandCond cond = new WhCommandCond();
        ArrayList<Integer> inOutTypeList = new ArrayList<Integer>();
        inOutTypeList.add(type);
        cond.setInOutTypeList(inOutTypeList);
        cond.setReferenceCode(referenceCode);
        cond.setFetch(fetch);
        List<WhCommand> whCommandList = this.findCommandByCond(cond);
        if (whCommandList.size() == 0) {
            return null;
        }
        if (whCommandList.size() != 1) {
            throw new WarehouseException("CO0004", "\u76f8\u540c\u7c7b\u578b+\u76f8\u5173\u5355\u636e\u53f7\u53ea\u80fd\u6709\u4e00\u6761\u8bb0\u5f55");
        }
        return whCommandList.get(0);
    }

    @Override
    public List<WhCommand> findCommandByCond(WhCommandCond cond) {
        if (EmptyUtil.isEmpty(cond.getWarehouseCodeList())) {
            cond.setWarehouseCodeList(null);
        }
        if (EmptyUtil.isEmpty(cond.getInOutTypeList())) {
            cond.setInOutTypeList(null);
        }
        List<WhCommand> result = this.whCommandMapper.findCommandByCond(cond);
        if (cond.isFetch() && EmptyUtil.isNotEmpty(result)) {
            ArrayList<Long> whCommandIdList = new ArrayList<Long>();
            for (WhCommand whCommand : result) {
                whCommandIdList.add(whCommand.getId());
            }
            List<WhCommandSku> whCommandSkuList = this.findCommandSkuByCommandIds(whCommandIdList);
            HashMap<Long, ArrayList<WhCommandSku>> map = new HashMap<Long, ArrayList<WhCommandSku>>();
            for (WhCommandSku whCommandSku : whCommandSkuList) {
                Long commandId = whCommandSku.getCommandId();
                ArrayList<WhCommandSku> listInMap = (ArrayList<WhCommandSku>)map.get(commandId);
                if (listInMap == null) {
                    listInMap = new ArrayList<WhCommandSku>();
                    map.put(commandId, listInMap);
                }
                listInMap.add(whCommandSku);
            }
            for (WhCommand whCommand : result) {
                List listInMap = (List)map.get(whCommand.getId());
                whCommand.setWhCommandSkuList(listInMap);
            }
        }
        return result;
    }

    @Override
    public List<WhCommand> findNewCommandByCond(WhCommandCond cond) {
        if (EmptyUtil.isEmpty(cond.getWarehouseCodeList())) {
            cond.setWarehouseCodeList(null);
        }
        if (EmptyUtil.isEmpty(cond.getInOutTypeList())) {
            cond.setInOutTypeList(null);
        }
        List<WhCommand> result = this.whCommandMapper.findNewCommandByCond(cond);
        if (cond.isFetch() && EmptyUtil.isNotEmpty(result)) {
            ArrayList<Long> whCommandIdList = new ArrayList<Long>();
            for (WhCommand whCommand : result) {
                whCommandIdList.add(whCommand.getId());
            }
            List<WhCommandSku> whCommandSkuList = this.findCommandSkuByCommandIds(whCommandIdList);
            HashMap<Long, ArrayList<WhCommandSku>> map = new HashMap<Long, ArrayList<WhCommandSku>>();
            for (WhCommandSku whCommandSku : whCommandSkuList) {
                Long commandId = whCommandSku.getCommandId();
                ArrayList<WhCommandSku> listInMap = (ArrayList<WhCommandSku>)map.get(commandId);
                if (listInMap == null) {
                    listInMap = new ArrayList<WhCommandSku>();
                    map.put(commandId, listInMap);
                }
                listInMap.add(whCommandSku);
            }
            for (WhCommand whCommand : result) {
                List listInMap = (List)map.get(whCommand.getId());
                whCommand.setWhCommandSkuList(listInMap);
            }
        }
        return result;
    }

    @Override
    public List<WhCommand> findUnDeliveryGoodsAndNoSendMailByCond(WhCommandCond cond) {
        return this.whCommandMapper.findUnDeliveryGoodsAndNoSendMailByCond(cond);
    }

    @Override
    public List<WhCommand> findInProcessCommandByWarehouseAndTimeRange(List<String> warehouseCodeList, Date startTime, Date endTime) {
        WhCommandExample example = new WhCommandExample();
        example.createCriteria().andCommandStatusEqualTo(WhCommand.STATUS_IN_PROCESSING).andWarehouseCodeIn((List)warehouseCodeList).andCreateTimeBetween(startTime, endTime);
        return this.whCommandMapper.selectByExample(example);
    }

    @Override
    public WhCommandSku findCommandSkuByCode(String code) {
        WhCommandSkuExample example = new WhCommandSkuExample();
        example.createCriteria().andCodeEqualTo(code);
        List<WhCommandSku> whCommandSkuList = this.whCommandSkuMapper.selectByExample(example);
        return whCommandSkuList != null && !whCommandSkuList.isEmpty() ? whCommandSkuList.get(0) : null;
    }

    @Override
    public List<WhCommandSku> findCommandSkuByCommandCode(String commandCode) {
        WhCommand whCommand = this.findCommandByCode(commandCode, false);
        if (whCommand == null) {
            return new ArrayList<WhCommandSku>();
        }
        WhCommandSkuExample example = new WhCommandSkuExample();
        example.createCriteria().andCommandIdEqualTo(whCommand.getId());
        example.setOrderByClause("id");
        return this.whCommandSkuMapper.selectByExample(example);
    }

    @Override
    public List<WhCommandSku> findCommandSkuByCommandId(Long commandId) {
        WhCommandSkuExample example = new WhCommandSkuExample();
        example.createCriteria().andCommandIdEqualTo(commandId);
        example.setOrderByClause("id");
        return this.whCommandSkuMapper.selectByExample(example);
    }

    @Override
    public boolean cancelCommandById(Long id) {
        WhCommand rcd = this.whCommandMapper.selectByPrimaryKey(id);
        return rcd != null ? this.cancelCommand(rcd) : false;
    }

    @Override
    @Transactional
    public boolean cancelCommandByCode(String code) {
        WhCommand rcd = this.findCommandByCode(code, false);
        return rcd != null ? this.cancelCommand(rcd) : false;
    }

    @Override
    @Transactional
    public boolean cancelCommandByCodeWithoutOccupy(String code) {
        WhCommand rcd = this.findCommandByCode(code, false);
        return this.cancelCommandWithoutOccupy(rcd);
    }

    @Override
    @Transactional
    public boolean cancelCommandByTypeAndReferenceCode(Integer type, String referenceCode) {
        WhCommand rcd = this.findCommandByTypeAndReferenceCode(type, referenceCode, false);
        return rcd != null ? this.cancelCommand(rcd) : false;
    }

    @Override
    @Transactional
    public boolean cancelCommandByTypeAndReferenceCodeBeforeOccupy(Integer type, String referenceCode, List<WhInvOccupy> whInvOccupyList) {
        WhCommand rcd = this.findCommandByTypeAndReferenceCode(type, referenceCode, false);
        if (NullUtil.isNotNull((Object)rcd) && (WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus()) || WhCommand.STATUS_SHORTAGES.equals(rcd.getCommandStatus()))) {
            boolean success;
            rcd.setReferenceCode(rcd.getReferenceCode() + "_" + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
            rcd.setCommandStatus(WhCommand.STATUS_CANCELED);
            rcd.setProcessTime(new Date());
            this.whCommandMapper.updateByPrimaryKey(rcd);
            WhCommandExample commandExample = new WhCommandExample();
            commandExample.createCriteria().andIdEqualTo(rcd.getId()).andCommandStatusEqualTo(rcd.getCommandStatus());
            boolean bl = success = this.whCommandMapper.updateByExampleSelective(rcd, commandExample) == 1;
            if (!success) {
                throw new WarehouseException("WH0001", "\u6307\u4ee4\u53d6\u6d88\u5931\u8d25,\u8bf7\u91cd\u8bd5");
            }
        } else {
            throw new WarehouseException("CO0002", "\u6307\u4ee4\u5f53\u524d\u4e0d\u53ef\u53d6\u6d88");
        }
        this.releaseWhCommandOccupy(rcd);
        this.whWmsCommandPreOccupyService.releasePreOccupy(Collections.singletonList(rcd.getCode()));
        this.whInvService.occupyAndNoNeedCheckStock(whInvOccupyList, true);
        return true;
    }

    @Override
    @Transactional
    public boolean cancelCommandByTypeAndReferenceCodeWithoutOccupy(Integer type, String referenceCode) {
        WhCommand rcd = this.findCommandByTypeAndReferenceCode(type, referenceCode, false);
        if (NullUtil.isNotNull((Object)rcd) && (WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus()) || WhCommand.STATUS_SHORTAGES.equals(rcd.getCommandStatus()))) {
            boolean success;
            Integer oldCommandStatus = rcd.getCommandStatus();
            rcd.setReferenceCode(rcd.getReferenceCode() + "_" + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
            rcd.setCommandStatus(WhCommand.STATUS_CANCELED);
            rcd.setProcessTime(new Date());
            WhCommandExample commandExample = new WhCommandExample();
            commandExample.createCriteria().andIdEqualTo(rcd.getId()).andCommandStatusEqualTo(oldCommandStatus);
            boolean bl = success = this.whCommandMapper.updateByExampleSelective(rcd, commandExample) == 1;
            if (!success) {
                throw new WarehouseException("WH0001", "\u6307\u4ee4\u53d6\u6d88\u5931\u8d25,\u8bf7\u91cd\u8bd5");
            }
        } else {
            throw new WarehouseException("CO0002", "\u6307\u4ee4\u5f53\u524d\u4e0d\u53ef\u53d6\u6d88");
        }
        this.whWmsCommandPreOccupyService.releasePreOccupy(Collections.singletonList(rcd.getCode()));
        return true;
    }

    @Override
    @Transactional
    public boolean cancelCommandByTypeAndReferenceCodeAfterRelease(Integer type, String referenceCode, List<WhReleaseOccupationVO> whReleaseOccupationVOList) {
        this.whInvService.releaseOccupation(whReleaseOccupationVOList);
        WhCommand rcd = this.findCommandByTypeAndReferenceCode(type, referenceCode, false);
        return rcd != null ? this.cancelCommand(rcd) : false;
    }

    @Override
    public void resetCommandReferenceCodeByTypeAndReferenceCode(Integer type, String referenceCode) {
        WhCommand rcd = this.findCommandByTypeAndReferenceCode(type, referenceCode, false);
        rcd.setReferenceCode(rcd.getReferenceCode() + "_" + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        this.whCommandMapper.updateByPrimaryKeySelective(rcd);
    }

    @Override
    @Transactional
    public void resetCommandReferenceCodeByTypeAndReferenceCodeBeforeOccupy(Integer type, String referenceCode, List<WhInvOccupy> whInvOccupyList) {
        this.whInvService.occupy(whInvOccupyList);
        this.resetCommandReferenceCodeByTypeAndReferenceCode(type, referenceCode);
    }

    @Override
    public boolean finishCommandById(Long id) throws Exception {
        WhCommand rcd = this.whCommandMapper.selectByPrimaryKey(id);
        return this.finishCommand(rcd);
    }

    @Override
    @Transactional
    public boolean finishCommandByCode(String code) throws Exception {
        WhCommand rcd = this.findCommandByCode(code, false);
        return this.finishCommand(rcd);
    }

    @Override
    @Transactional
    @Deprecated
    public boolean finishCommandWithoutOccupy(String code) {
        WhCommand rcd = this.findCommandByCode(code, false);
        return this.finishCommandWithoutOccupy(rcd);
    }

    private List<WhReleaseOccupationVO> findPackageOccupyRelease(WhCommand cmd) {
        return this.whCommandMapper.findPackageOccupyReleaseByPackageCode(cmd.getReferenceCode());
    }

    public boolean finishCommandByCode(WhCommand whCommand) throws Exception {
        WhCommand rcd = this.findCommandByCode(whCommand.getCode(), false);
        if (EmptyUtil.isNotEmpty((Object)whCommand.getOperatorId())) {
            rcd.setOperatorId(whCommand.getOperatorId());
        }
        return this.finishCommand(rcd);
    }

    @Override
    public boolean finishCommandByTypeAndReferenceCode(Integer type, String referenceCode) throws Exception {
        WhCommand rcd = this.findCommandByTypeAndReferenceCode(type, referenceCode, false);
        return this.finishCommand(rcd);
    }

    private List<WhCommandSku> findCommandSkuByCommandIds(List<Long> whCommandIdList) {
        WhCommandSkuExample example = new WhCommandSkuExample();
        example.createCriteria().andCommandIdIn((List)whCommandIdList);
        return this.whCommandSkuMapper.selectByExample(example);
    }

    @Override
    @Transactional
    public boolean cancelCommand(WhCommand rcd) {
        if (rcd != null && (WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus()) || WhCommand.STATUS_SHORTAGES.equals(rcd.getCommandStatus()))) {
            boolean success;
            rcd.setReferenceCode(rcd.getReferenceCode() + "_" + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
            rcd.setProcessTime(new Date());
            WhCommandExample example = new WhCommandExample();
            example.createCriteria().andIdEqualTo(rcd.getId()).andCommandStatusEqualTo(rcd.getCommandStatus());
            rcd.setCommandStatus(WhCommand.STATUS_CANCELED);
            boolean bl = success = this.whCommandMapper.updateByExampleSelective(rcd, example) == 1;
            if (!success) {
                throw new WarehouseException("CO0002", "\u6307\u4ee4\u53d6\u6d88\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            this.releaseWhCommandOccupy(rcd);
            return true;
        }
        throw new WarehouseException("CO0002", "cancelCommand failed,current status is not STATUS_IN_PROCESSING or STATUS_SHORTAGES.");
    }

    @Override
    @Transactional
    public boolean cancelCommandWithoutOccupy(WhCommand rcd) {
        if (rcd != null && (WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus()) || WhCommand.STATUS_SHORTAGES.equals(rcd.getCommandStatus()))) {
            boolean success;
            rcd.setReferenceCode(rcd.getReferenceCode() + "_" + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
            rcd.setProcessTime(new Date());
            WhCommandExample example = new WhCommandExample();
            example.createCriteria().andIdEqualTo(rcd.getId()).andCommandStatusEqualTo(rcd.getCommandStatus());
            if (EmptyUtil.isNotEmpty((String)rcd.getReferenceCode()) && !rcd.getReferenceCode().contains("_")) {
                rcd.setReferenceCode(rcd.getReferenceCode() + "_" + DateUtil.getNowFormat((String)"yyyyMMddHHmmss"));
            }
            rcd.setCommandStatus(WhCommand.STATUS_CANCELED);
            boolean bl = success = this.whCommandMapper.updateByExampleSelective(rcd, example) == 1;
            if (!success) {
                throw new WarehouseException("CO0002", "\u6307\u4ee4\u53d6\u6d88\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            this.whWmsCommandPreOccupyService.releasePreOccupy(Collections.singletonList(rcd.getCode()));
            return true;
        }
        throw new WarehouseException("CO0002", "cancelCommand failed,current status is not STATUS_IN_PROCESSING or STATUS_SHORTAGES.");
    }

    @Override
    @Transactional
    public boolean cancelCommandforShortage(String commandCode) {
        WhCommand rcd = this.findCommandByCode(commandCode, false);
        return this.cancelCommandforShortage(rcd);
    }

    @Override
    @Transactional
    public boolean cancelCommandforShortage(List<String> whCommandCodes, Integer oldStatus) {
        if (EmptyUtil.isEmpty(whCommandCodes)) {
            return true;
        }
        List<WhCommand> cmdList = this.findCommandByCodes(whCommandCodes, false);
        for (WhCommand rcd : cmdList) {
            WhCommandExample example = new WhCommandExample();
            example.createCriteria().andIdEqualTo(rcd.getId()).andCommandStatusEqualTo(oldStatus);
            WhCommand update = new WhCommand();
            update.setCommandStatus(WhCommand.STATUS_CANCELED);
            if (EmptyUtil.isNotEmpty((String)rcd.getReferenceCode()) && !rcd.getReferenceCode().contains("_")) {
                rcd.setReferenceCode(rcd.getReferenceCode() + "_" + DateUtil.getNowFormat((String)"yyyyMMddHHmmss"));
            }
            update.setCancelFlag(1);
            update.setProcessTime(DateUtil.getNow());
            boolean success = this.whCommandMapper.updateByExampleSelective(update, example) == 1;
            if (success) continue;
            throw new WarehouseException("CO0002", String.format("[%s]\u53d6\u6d88\u6307\u4ee4\u53d6\u6d88\u5931\u8d25", rcd.getCode()));
        }
        return true;
    }

    @Override
    @Transactional
    public boolean cancelCommandforShortage(WhCommand rcd) {
        boolean success;
        if (NullUtil.isNull((Object)rcd)) {
            throw new WarehouseException("CO0002", "\u6307\u4ee4\u4e0d\u5b58\u5728");
        }
        if (WhCommand.STATUS_CANCELED.equals((rcd = this.findCommandByCode(rcd.getCode(), false)).getCommandStatus())) {
            throw new WarehouseException("CO0002", "\u6307\u4ee4\u5df2\u53d6\u6d88");
        }
        WhCommandExample example = new WhCommandExample();
        example.createCriteria().andIdEqualTo(rcd.getId()).andCommandStatusEqualTo(rcd.getCommandStatus());
        WhCommand update = new WhCommand();
        update.setCommandStatus(WhCommand.STATUS_CANCELED);
        if (EmptyUtil.isNotEmpty((String)rcd.getReferenceCode()) && !rcd.getReferenceCode().contains("_")) {
            update.setReferenceCode(rcd.getReferenceCode() + "_" + DateUtil.getNowFormat((String)"yyyyMMddHHmmss"));
        }
        update.setCancelFlag(1);
        update.setProcessTime(DateUtil.getNow());
        boolean bl = success = this.whCommandMapper.updateByExampleSelective(update, example) == 1;
        if (!success) {
            throw new WarehouseException("CO0002", String.format("[%s]\u53d6\u6d88\u6307\u4ee4\u53d6\u6d88\u5931\u8d25", rcd.getCode()));
        }
        return true;
    }

    @Transactional
    @Deprecated
    public boolean cancelCommandForSalesOrder_old(List<WhCommand> whCommands, List<SStockReleaseDTO> releaseList) {
        ServiceResp serviceResp;
        if (EmptyUtil.isNotEmpty(whCommands)) {
            ArrayList<String> commandCodes = new ArrayList<String>();
            for (WhCommand command : whCommands) {
                boolean success;
                WhCommandExample commandExample;
                if (WhWmsCommandInfoVO.STATUS_DELIVERYCOMPLETION.equals(command.getCommandStatus())) {
                    throw new WarehouseException("WH0001", "\u51fa\u5e93\u547d\u4ee4\u5df2\u5b8c\u6210");
                }
                commandCodes.add(command.getCode());
                if (NullUtil.isNotNull((Object)command.getCancelFlag()) && 1 == command.getCancelFlag()) {
                    commandExample = new WhCommandExample();
                    commandExample.createCriteria().andIdEqualTo(command.getId()).andCancelFlagEqualTo(0);
                    boolean bl = success = this.whCommandMapper.updateByExampleSelective(command, commandExample) == 1;
                    if (!success) {
                        throw new WarehouseException("WH0001", "\u8ba2\u5355\u53d6\u6d88\u5931\u8d25,\u8bf7\u91cd\u8bd5");
                    }
                } else {
                    command.setReferenceCode(command.getReferenceCode() + "_" + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
                    command.setCommandStatus(WhCommand.STATUS_CANCELED);
                    command.setProcessTime(new Date());
                    commandExample = new WhCommandExample();
                    commandExample.createCriteria().andIdEqualTo(command.getId()).andCommandStatusEqualTo(WhCommand.STATUS_IN_PROCESSING);
                    boolean bl = success = this.whCommandMapper.updateByExampleSelective(command, commandExample) == 1;
                    if (!success) {
                        throw new WarehouseException("WH0001", "\u8ba2\u5355\u53d6\u6d88\u5931\u8d25,\u8bf7\u91cd\u8bd5");
                    }
                    this.releaseWhCommandOccupy(command);
                }
                this.whWmsCommandPreOccupyService.releasePreOccupy(commandCodes);
            }
        }
        if (EmptyUtil.isNotEmpty(releaseList) && (serviceResp = this.sStockService.release(releaseList)).isFailure()) {
            throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
        return true;
    }

    @Override
    @Transactional
    public boolean cancelCommandForSalesOrder(List<WhCommand> whCommands, List<SStockReleaseDTO> releaseList) {
        ServiceResp serviceResp;
        if (EmptyUtil.isNotEmpty(whCommands)) {
            ArrayList<String> commandCodes = new ArrayList<String>();
            for (WhCommand command : whCommands) {
                commandCodes.add(command.getCode());
            }
            List<WhCommand> list = this.findCommandByCodes(commandCodes, false);
            for (WhCommand command : list) {
                boolean success;
                WhCommandExample commandExample;
                if (WhWmsCommandInfoVO.STATUS_DELIVERYCOMPLETION.equals(command.getCommandStatus())) {
                    throw new WarehouseException("WH0001", "\u51fa\u5e93\u547d\u4ee4\u5df2\u5b8c\u6210");
                }
                if (WhCommand.STATUS_IN_PROCESSING.equals(command.getCommandStatus())) {
                    command.setReferenceCode(command.getReferenceCode() + "_" + DateUtil.getNowFormat((String)"yyyyMMddHHmmss"));
                    command.setCommandStatus(WhCommand.STATUS_CANCELED);
                    command.setProcessTime(new Date());
                    commandExample = new WhCommandExample();
                    commandExample.createCriteria().andIdEqualTo(command.getId()).andCommandStatusEqualTo(WhCommand.STATUS_IN_PROCESSING);
                    success = this.whCommandMapper.updateByExampleSelective(command, commandExample) == 1;
                    if (success) continue;
                    throw new WarehouseException("WH0001", "\u6307\u4ee4\u53d6\u6d88\u5931\u8d25,\u8bf7\u91cd\u8bd5");
                }
                commandExample = new WhCommandExample();
                commandExample.createCriteria().andIdEqualTo(command.getId()).andCancelFlagEqualTo(0);
                command.setCancelFlag(1);
                command.setReferenceCode(command.getReferenceCode() + "_" + DateUtil.getNowFormat((String)"yyyyMMddHHmmss"));
                success = this.whCommandMapper.updateByExampleSelective(command, commandExample) == 1;
                if (success) continue;
                throw new WarehouseException("WH0001", "\u8ba2\u5355\u53d6\u6d88\u5931\u8d25,\u8bf7\u91cd\u8bd5");
            }
            this.whWmsCommandPreOccupyService.releasePreOccupy(commandCodes);
        }
        if (EmptyUtil.isNotEmpty(releaseList) && (serviceResp = this.sStockService.release(releaseList)).isFailure()) {
            throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
        return true;
    }

    @Override
    @Transactional
    public void releaseWhCommandOccupy(WhCommand rcd) {
        if (rcd.isOut()) {
            if (EmptyUtil.isEmpty((rcd = this.findCommandByCode(rcd.getCode(), true)).getWhCommandSkuList())) {
                rcd.setWhCommandSkuList(this.findCommandSkuByCommandCode(rcd.getCode()));
            }
            ArrayList<WhReleaseOccupationVO> whReleaseOccupationVOList = new ArrayList<WhReleaseOccupationVO>();
            for (WhCommandSku whCommandSku : rcd.getWhCommandSkuList()) {
                WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
                whReleaseOccupationVO.setOccupyType(rcd.getInOutType());
                whReleaseOccupationVO.setReferenceCode(whCommandSku.getCode());
                whReleaseOccupationVOList.add(whReleaseOccupationVO);
            }
            if (whReleaseOccupationVOList != null && whReleaseOccupationVOList.size() > 0) {
                this.whInvService.releaseOccupation(whReleaseOccupationVOList);
            }
        }
    }

    private SWhCommandVO convertCommandToDto(WhCommand cmd) {
        if (NullUtil.isNull((Object)cmd)) {
            return null;
        }
        SWhCommandVO dto = (SWhCommandVO)BeanUtil.buildFrom((Object)cmd, SWhCommandVO.class);
        if (EmptyUtil.isNotEmpty(cmd.getWhCommandSkuList())) {
            List commandSkuList = BeanUtil.buildListFrom(cmd.getWhCommandSkuList(), SWhCommandSkuVO.class);
            dto.setCommandSkuList(commandSkuList);
        }
        return dto;
    }

    private WhCommand convertDtoToCommand(SWhCommandVO sWhCommandVO) {
        if (NullUtil.isNull((Object)sWhCommandVO)) {
            return null;
        }
        WhCommand cmd = (WhCommand)BeanUtil.buildFrom((Object)sWhCommandVO, WhCommand.class);
        if (EmptyUtil.isNotEmpty((List)sWhCommandVO.getCommandSkuList())) {
            List commandSkuList = BeanUtil.buildListFrom((Collection)sWhCommandVO.getCommandSkuList(), WhCommandSku.class);
            cmd.setWhCommandSkuList(commandSkuList);
        }
        return cmd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    @Transactional
    public boolean finishCommand_old(WhCommand rcd) throws Exception {
        ServiceResp releaseServiceResp;
        if (rcd == null || !WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus())) throw new WarehouseException("CO0002", "finishCommand failed,current status is not STATUS_IN_PROCESSING.");
        rcd.setCommandStatus(WhCommand.STATUS_FINISHED);
        rcd.setProcessTime(rcd.getProcessTime() == null ? new Date() : rcd.getProcessTime());
        this.sWhCommandService.updateWhCommandByKey((SWhCommandVO)BeanUtil.buildFrom((Object)rcd, SWhCommandVO.class));
        if (EmptyUtil.isEmpty(rcd.getWhCommandSkuList())) {
            rcd.setWhCommandSkuList(this.findCommandSkuByCommandCode(rcd.getCode()));
        }
        ArrayList<SStockReleaseDTO> releaseDTOS = new ArrayList<SStockReleaseDTO>();
        for (WhCommandSku whCommandSku : rcd.getWhCommandSkuList()) {
            ServiceResp serviceResp;
            if (whCommandSku.getQuantity() == null) {
                whCommandSku.setQuantity(whCommandSku.getPlanedQuantity());
            }
            if (whCommandSku.getDamagedQuantity() == null) {
                whCommandSku.setDamagedQuantity(0);
            }
            this.sWhCommandService.updateWhCommandSkuByKey((SWhCommandSkuVO)BeanUtil.buildFrom((Object)whCommandSku, SWhCommandSkuVO.class));
            ArrayList<SStockRecordVO> rollbackRecordList = new ArrayList<SStockRecordVO>();
            if (rcd.isIn()) {
                boolean phyWhStockUpdateResult;
                ArrayList<SStockRecordVO> stockRcdList = new ArrayList<SStockRecordVO>();
                if (whCommandSku.getQuantity() > 0) {
                    SStockRecordVO stockRecordVO = new SStockRecordVO();
                    stockRecordVO.setCommandCode(rcd.getCode());
                    stockRecordVO.setWarehouseCode(rcd.getWarehouseCode());
                    stockRecordVO.setInOutType(rcd.getInOutType());
                    stockRecordVO.setSkuCode(whCommandSku.getSkuCode());
                    stockRecordVO.setQuantity(whCommandSku.getQuantity());
                    stockRecordVO.setSubmitTime(DateUtil.getNow());
                    stockRecordVO.setSubmitUserId(Integer.valueOf(EmptyUtil.isNotEmpty((Object)rcd.getOperatorId()) ? Integer.parseInt(rcd.getOperatorId() + "") : 1));
                    stockRcdList.add(stockRecordVO);
                }
                if (whCommandSku.getDamagedQuantity() > 0) {
                    if (EmptyUtil.isEmpty((String)rcd.getPhysicalWarehouseCode())) {
                        throw new WarehouseException("WH0001", "\u5b58\u5728\u6b8b\u6b21\u54c1\u5165\u5e93\u7269\u7406\u4ed3\u5fc5\u586b");
                    }
                    WhWarehouse damagedWh = this.whInfoService.findDefaultInDefectiveWarehouseByPhyWhCode(rcd.getPhysicalWarehouseCode());
                    if (NullUtil.isNull((Object)damagedWh)) {
                        throw new WarehouseException("WH0001", String.format("[%s]\u9ed8\u8ba4\u6b8b\u6b21\u54c1\u5165\u5e93\u4ed3\u672a\u8bbe\u7f6e", rcd.getPhysicalWarehouseCode()));
                    }
                    SStockRecordVO stockRecordVO = new SStockRecordVO();
                    stockRecordVO.setCommandCode(rcd.getCode());
                    stockRecordVO.setWarehouseCode(damagedWh.getCode());
                    stockRecordVO.setInOutType(rcd.getInOutType());
                    stockRecordVO.setSkuCode(whCommandSku.getSkuCode());
                    stockRecordVO.setQuantity(whCommandSku.getDamagedQuantity());
                    stockRecordVO.setSubmitTime(DateUtil.getNow());
                    stockRecordVO.setSubmitUserId(Integer.valueOf(EmptyUtil.isNotEmpty((Object)rcd.getOperatorId()) ? Integer.parseInt(rcd.getOperatorId() + "") : 1));
                    stockRcdList.add(stockRecordVO);
                }
                if (!(phyWhStockUpdateResult = this.updatePhysicalStockByCond(stockRcdList, rcd))) throw new WarehouseException("WH0001", "\u66f4\u65b0\u7269\u7406\u4ed3\u5e93\u5b58\u5931\u8d25!");
                if (EmptyUtil.isNotEmpty(stockRcdList)) {
                    serviceResp = this.sStockService.batchRecord(stockRcdList);
                    if (!serviceResp.isSuccess()) throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
                    rollbackRecordList.addAll((Collection)serviceResp.getBean());
                }
            } else if (rcd.isOut()) {
                SStockRecordVO stockRecordVO = new SStockRecordVO();
                stockRecordVO.setCommandCode(rcd.getCode());
                stockRecordVO.setWarehouseCode(rcd.getWarehouseCode());
                stockRecordVO.setInOutType(rcd.getInOutType());
                stockRecordVO.setSkuCode(whCommandSku.getSkuCode());
                stockRecordVO.setQuantity(Integer.valueOf(0 - whCommandSku.getQuantity()));
                stockRecordVO.setSubmitTime(DateUtil.getNow());
                stockRecordVO.setSubmitUserId(Integer.valueOf(EmptyUtil.isNotEmpty((Object)rcd.getOperatorId()) ? Integer.parseInt(rcd.getOperatorId() + "") : 1));
                boolean result = false;
                result = stockRecordVO.getQuantity() == 0 ? true : this.updatePhysicalStockByCond(Collections.singletonList(stockRecordVO), rcd);
                if (!result) throw new WarehouseException("WH0001", "\u66f4\u65b0\u7269\u7406\u4ed3\u5e93\u5b58\u5931\u8d25!");
                serviceResp = this.sStockService.record(stockRecordVO);
                if (!serviceResp.isSuccess()) {
                    throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
                }
                rollbackRecordList.add((SStockRecordVO)serviceResp.getBean());
                SStockReleaseDTO stockReleaseDTO = new SStockReleaseDTO();
                stockReleaseDTO.setReferenceCode(whCommandSku.getCode());
                stockReleaseDTO.setOccupyType(SStockOccupyTypeEnum.getEnumByCode((Integer)rcd.getInOutType()));
                stockReleaseDTO.setOperationType(SStockOperationTypeEnum.DEFAULT);
                releaseDTOS.add(stockReleaseDTO);
            }
            rcd.setRollbackRecordList(rollbackRecordList);
        }
        if (EmptyUtil.isNotEmpty(releaseDTOS) && (releaseServiceResp = this.sStockService.release(releaseDTOS)).isFailure()) {
            throw new WarehouseException(releaseServiceResp.getRespCode(), releaseServiceResp.getRespMsg());
        }
        this.processAfterFinishCommand(rcd);
        return true;
    }

    @Override
    @Transactional
    public boolean finishCommand(WhCommand rcd) {
        if (NullUtil.isNull((Object)rcd) || !WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus())) {
            throw new WarehouseException("CO0002", String.format("\u6307\u4ee4\u5f53\u524d\u72b6\u6001[%s]", rcd.getCommandStatusStr()));
        }
        this.prepareWhCommandBeforeFinish(rcd);
        rcd.setCommandStatus(WhCommand.STATUS_FINISHED);
        if (rcd.isIn()) {
            this.finishCommandInWithOccupy(rcd);
        } else if (rcd.isOut()) {
            this.finishCommandOutWithOccupy(rcd);
        } else {
            throw new WarehouseException("CO0002", "\u6307\u4ee4\u51fa\u5165\u5e93\u7c7b\u578b\u5f02\u5e38");
        }
        this.processAfterFinishCommand(rcd);
        return true;
    }

    private void prepareWhCommandBeforeFinish(WhCommand rcd) {
        if (NullUtil.isNull((Object)rcd.getProcessTime())) {
            rcd.setProcessTime(DateUtil.getNow());
        }
        if (EmptyUtil.isEmpty(rcd.getWhCommandSkuList())) {
            rcd.setWhCommandSkuList(this.findCommandSkuByCommandCode(rcd.getCode()));
        }
        for (WhCommandSku cmdSku : rcd.getWhCommandSkuList()) {
            if (NullUtil.isNull((Object)cmdSku.getQuantity())) {
                cmdSku.setQuantity(cmdSku.getPlanedQuantity());
            }
            if (!NullUtil.isNull((Object)cmdSku.getDamagedQuantity())) continue;
            cmdSku.setDamagedQuantity(0);
        }
    }

    private boolean finishCommandInWithOccupy(WhCommand rcd) {
        List<WhInvRcd> invRcdList = this.buildWhCommandInInvRcd(rcd);
        List<SStockRecordVO> stockRcdList = this.convertInvRcdToDto(invRcdList);
        boolean phyWhStockUpdateResult = this.updatePhysicalStockByCond(stockRcdList, rcd);
        if (!phyWhStockUpdateResult) {
            throw new WarehouseException("WH0001", "\u66f4\u65b0\u7269\u7406\u4ed3\u5e93\u5b58\u5931\u8d25!");
        }
        SWhCommandVO sWhCommand = this.convertCommandToDto(rcd);
        sWhCommand.setStockRecordList(this.convertInvRcdToDto(invRcdList));
        this.sWhCommandService.finishWhCommand(sWhCommand);
        return true;
    }

    private boolean finishCommandOutWithOccupy(WhCommand rcd) {
        List<WhInvRcd> invRcdList = this.buildWhCommandOutInvRcd(rcd);
        boolean result = false;
        for (WhInvRcd invRcd : invRcdList) {
            if (invRcd.getQuantity() == 0) {
                result = true;
                continue;
            }
            List<SStockRecordVO> singleList = this.convertInvRcdToDto(Collections.singletonList(invRcd));
            result = this.updatePhysicalStockByCond(singleList, rcd);
            if (result) continue;
            throw new WarehouseException("WH0001", "\u66f4\u65b0\u7269\u7406\u4ed3\u5e93\u5b58\u5931\u8d25!");
        }
        SWhCommandVO sWhCommand = this.convertCommandToDto(rcd);
        sWhCommand.setStockRecordList(this.convertInvRcdToDto(invRcdList));
        ArrayList<SStockReleaseDTO> stockReleaseList = new ArrayList<SStockReleaseDTO>();
        for (WhCommandSku whCommandSku : rcd.getWhCommandSkuList()) {
            SStockReleaseDTO stockReleaseDTO = new SStockReleaseDTO();
            stockReleaseDTO.setReferenceCode(whCommandSku.getCode());
            stockReleaseDTO.setOccupyType(SStockOccupyTypeEnum.getEnumByCode((Integer)rcd.getInOutType()));
            stockReleaseDTO.setOperationType(SStockOperationTypeEnum.DEFAULT);
            stockReleaseList.add(stockReleaseDTO);
        }
        sWhCommand.setStockReleaseList(stockReleaseList);
        this.sWhCommandService.finishWhCommand(sWhCommand);
        return true;
    }

    @Override
    @Transactional
    public boolean finishCommandWithoutOccupy(WhCommand rcd) {
        if (NullUtil.isNull((Object)rcd)) {
            throw new WarehouseException("CO0002", "\u6307\u4ee4\u4e0d\u5b58\u5728");
        }
        if (!WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus())) {
            throw new WarehouseException("CO0002", String.format("\u6307\u4ee4\u72b6\u6001\u5f02\u5e38[%s]", rcd.getCommandStatusStr()));
        }
        if (rcd.isIn()) {
            this.finishCommandInWithoutOccupy(rcd);
        } else if (rcd.isOut()) {
            List<WhReleaseOccupationVO> releaseList = this.findPackageOccupyRelease(rcd);
            if (EmptyUtil.isEmpty(releaseList)) {
                throw new WarehouseException("WH0001", "\u5305\u88f9\u672a\u5360\u7528\u6216\u5360\u7528\u5df2\u91ca\u653e");
            }
            this.finishCommandOutWithoutOccupy(rcd, releaseList);
        } else {
            throw new WarehouseException("CO0002", "\u6307\u4ee4\u51fa\u5165\u5e93\u7c7b\u578b\u5f02\u5e38");
        }
        this.processAfterFinishCommand(rcd);
        return true;
    }

    @Override
    @Transactional
    public boolean processCommandOutFinish(WhCommand command, List<WhInvRcd> invRcdList, List<WhReleaseOccupationVO> releaseList) {
        this.prepareWhCommandBeforeFinish(command);
        if (!command.isOut()) {
            throw new WarehouseException("WH0001", "\u6307\u4ee4\u51fa\u5e93\u7c7b\u578b\u5f02\u5e38");
        }
        boolean success = this.updateCommandOutFinishWhDone(command.getCode());
        if (!success) {
            throw new WarehouseException("WH0401", String.format("%s\u6307\u4ee4\u5df2\u5904\u7406", command.getCode()));
        }
        SWhCommandVO sWhCommand = this.convertCommandToDto(command);
        sWhCommand.setStockRecordList(this.convertInvRcdToDto(invRcdList));
        if (EmptyUtil.isNotEmpty(releaseList)) {
            List<SStockReleaseDTO> stockReleaseList = this.whInvService.convertWhRelease2DTO(releaseList);
            sWhCommand.setStockReleaseList(stockReleaseList);
        }
        this.sWhCommandService.processCommandFinish(sWhCommand);
        return true;
    }

    private boolean updateCommandOutFinishWhDone(String commandCode) {
        WhCommandOutFinish updateInfo = new WhCommandOutFinish();
        updateInfo.setWhStatus(1);
        updateInfo.setFinishDate(DateUtil.getNow());
        WhCommandOutFinishExample example = new WhCommandOutFinishExample();
        example.createCriteria().andCommandCodeEqualTo(commandCode).andWhStatusEqualTo(0);
        return this.whCommandOutFinishMapper.updateByExampleSelective(updateInfo, example) == 1;
    }

    @Override
    @Transactional
    public boolean finishCommandWithoutOccupy(WhCommand rcd, List<WhReleaseOccupationVO> releaseList) {
        if (NullUtil.isNull((Object)rcd)) {
            throw new WarehouseException("CO0002", "\u6307\u4ee4\u4e0d\u5b58\u5728");
        }
        if (!WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus())) {
            throw new WarehouseException("CO0002", String.format("\u6307\u4ee4\u72b6\u6001\u5f02\u5e38[%s]", rcd.getCommandStatusStr()));
        }
        rcd.setCommandStatus(WhCommand.STATUS_FINISHED);
        this.prepareWhCommandBeforeFinish(rcd);
        if (rcd.isIn()) {
            this.finishCommandInWithoutOccupy(rcd);
        } else if (rcd.isOut()) {
            this.finishCommandOutWithoutOccupy(rcd, releaseList);
        } else {
            throw new WarehouseException("CO0002", "\u6307\u4ee4\u51fa\u5165\u5e93\u7c7b\u578b\u5f02\u5e38");
        }
        this.processAfterFinishCommand(rcd);
        return true;
    }

    private boolean finishCommandInWithoutOccupy(WhCommand rcd) {
        List<WhInvRcd> invRcdList = this.buildWhCommandInInvRcd(rcd);
        boolean phyWhStockUpdateResult = this.updatePhyWhSkuStockIn(invRcdList, rcd);
        if (!phyWhStockUpdateResult) {
            throw new WarehouseException("WH0001", "\u66f4\u65b0\u7269\u7406\u4ed3\u5e93\u5b58\u5931\u8d25!");
        }
        SWhCommandVO sWhCommand = this.convertCommandToDto(rcd);
        sWhCommand.setStockRecordList(this.convertInvRcdToDto(invRcdList));
        this.sWhCommandService.finishWhCommand(sWhCommand);
        return true;
    }

    private List<SStockRecordVO> convertInvRcdToDto(List<WhInvRcd> whInvRcdList) {
        return this.whInvService.convertWhInv2DTO(whInvRcdList);
    }

    private List<WhInvRcd> buildWhCommandInInvRcd(WhCommand rcd) {
        ArrayList<WhInvRcd> invRcdList = new ArrayList<WhInvRcd>();
        for (WhCommandSku whCommandSku : rcd.getWhCommandSkuList()) {
            if (whCommandSku.getQuantity() == null) {
                whCommandSku.setQuantity(whCommandSku.getPlanedQuantity());
            }
            if (whCommandSku.getDamagedQuantity() == null) {
                whCommandSku.setDamagedQuantity(0);
            }
            if (whCommandSku.getQuantity() > 0) {
                WhInvRcd whInvRcd = new WhInvRcd();
                whInvRcd.setCommandCode(rcd.getCode());
                whInvRcd.setWarehouseCode(rcd.getWarehouseCode());
                whInvRcd.setInOutType(rcd.getInOutType());
                whInvRcd.setSkuCode(whCommandSku.getSkuCode());
                whInvRcd.setQuantity(whCommandSku.getQuantity());
                whInvRcd.setSubmitTime(DateUtil.getNow());
                whInvRcd.setSubmitUserId(1L);
                if (EmptyUtil.isNotEmpty((Object)rcd.getOperatorId())) {
                    whInvRcd.setSubmitUserId(rcd.getOperatorId());
                }
                invRcdList.add(whInvRcd);
            }
            if (whCommandSku.getDamagedQuantity() <= 0) continue;
            if (EmptyUtil.isEmpty((String)rcd.getPhysicalWarehouseCode())) {
                throw new WarehouseException("WH0001", "\u5b58\u5728\u6b8b\u6b21\u54c1\u5165\u5e93\u7269\u7406\u4ed3\u5fc5\u586b");
            }
            WhWarehouse damagedWh = this.whInfoService.findDefaultInDefectiveWarehouseByPhyWhCode(rcd.getPhysicalWarehouseCode());
            if (NullUtil.isNull((Object)damagedWh)) {
                throw new WarehouseException("WH0001", String.format("[%s]\u9ed8\u8ba4\u6b8b\u6b21\u54c1\u5165\u5e93\u4ed3\u672a\u8bbe\u7f6e", rcd.getPhysicalWarehouseCode()));
            }
            WhInvRcd whInvRcd = new WhInvRcd();
            whInvRcd.setCommandCode(rcd.getCode());
            whInvRcd.setWarehouseCode(damagedWh.getCode());
            whInvRcd.setInOutType(rcd.getInOutType());
            whInvRcd.setSkuCode(whCommandSku.getSkuCode());
            whInvRcd.setQuantity(whCommandSku.getDamagedQuantity());
            whInvRcd.setSubmitTime(DateUtil.getNow());
            whInvRcd.setSubmitUserId(1L);
            if (EmptyUtil.isNotEmpty((Object)rcd.getOperatorId())) {
                whInvRcd.setSubmitUserId(rcd.getOperatorId());
            }
            invRcdList.add(whInvRcd);
        }
        return invRcdList;
    }

    @Override
    @Transactional
    public boolean processAllotPackageInBound(WhAllotPackageInBoundVO altPackageInBound) {
        WhCommand inCommand = this.findCommandByCode(altPackageInBound.getInCommandCode(), true);
        if (WhCommand.STATUS_IN_PROCESSING.equals(inCommand.getCommandStatus()) && WhCommand.STATUS_QUALITY_PROCESSING.equals(inCommand.getCommandStatus())) {
            throw new WarehouseException("WH0001", String.format("\u6307\u4ee4\u72b6\u6001[%s]", inCommand.getCommandStatusStr()));
        }
        inCommand.setProcessTime(DateUtil.getNow());
        inCommand.setOperatorId(altPackageInBound.getOperatorId());
        if (altPackageInBound.isLastPackage()) {
            inCommand.setCommandStatus(WhCommand.STATUS_FINISHED);
        } else if (WhCommand.STATUS_IN_PROCESSING.equals(inCommand.getCommandStatus())) {
            inCommand.setCommandStatus(WhCommand.STATUS_QUALITY_PROCESSING);
        }
        List<WhCommandSku> commandSkuList = inCommand.getWhCommandSkuList();
        Map<String, Map<Integer, Integer>> inSkuQtMap = this.buildInBoundSkuQuantityMap(altPackageInBound.getInBoundSkuDetailList());
        ArrayList<WhInvRcd> invRcdList = new ArrayList<WhInvRcd>();
        ArrayList<WhCommandSku> updateCmdSkuList = new ArrayList<WhCommandSku>();
        for (WhCommandSku cmdSku : commandSkuList) {
            Map<Integer, Integer> inSkuStatusQtMap;
            if (NullUtil.isNull((Object)cmdSku.getQuantity())) {
                cmdSku.setQuantity(0);
            }
            if (NullUtil.isNull((Object)cmdSku.getDamagedQuantity())) {
                cmdSku.setDamagedQuantity(0);
            }
            if (NullUtil.isNull(inSkuStatusQtMap = inSkuQtMap.get(cmdSku.getSkuCode()))) {
                updateCmdSkuList.add(cmdSku);
                continue;
            }
            Integer inQuantity = 0;
            Integer inDamagedQuantity = 0;
            if (WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(altPackageInBound.getWhCommodityStatus()) || WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE.equals(altPackageInBound.getWhCommodityStatus())) {
                inQuantity = inSkuStatusQtMap.get(altPackageInBound.getWhCommodityStatus());
                inDamagedQuantity = inSkuStatusQtMap.get(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
            } else {
                inQuantity = inSkuStatusQtMap.get(altPackageInBound.getWhCommodityStatus());
            }
            if (NumberUtil.isNullOrZero((Number)inQuantity) && NumberUtil.isNullOrZero((Number)inDamagedQuantity)) continue;
            if (NullUtil.isNotNull((Object)inQuantity) && inQuantity > 0) {
                cmdSku.setQuantity(cmdSku.getQuantity() + inQuantity);
                WhInvRcd whInvRcd = new WhInvRcd();
                whInvRcd.setCommandCode(inCommand.getCode());
                whInvRcd.setWarehouseCode(inCommand.getWarehouseCode());
                whInvRcd.setInOutType(inCommand.getInOutType());
                whInvRcd.setSkuCode(cmdSku.getSkuCode());
                whInvRcd.setQuantity(inQuantity);
                whInvRcd.setSubmitTime(DateUtil.getNow());
                whInvRcd.setSubmitUserId(1L);
                if (EmptyUtil.isNotEmpty((Object)inCommand.getOperatorId())) {
                    whInvRcd.setSubmitUserId(inCommand.getOperatorId());
                }
                invRcdList.add(whInvRcd);
            }
            if (NullUtil.isNotNull((Object)inDamagedQuantity) && inDamagedQuantity > 0) {
                if (EmptyUtil.isEmpty((String)inCommand.getPhysicalWarehouseCode())) {
                    throw new WarehouseException("WH0001", "\u5b58\u5728\u6b8b\u6b21\u54c1\u5165\u5e93\u7269\u7406\u4ed3\u5fc5\u586b");
                }
                WhWarehouse damagedWh = this.whInfoService.findDefaultInDefectiveWarehouseByPhyWhCode(inCommand.getPhysicalWarehouseCode());
                if (NullUtil.isNull((Object)damagedWh)) {
                    throw new WarehouseException("WH0001", String.format("[%s]\u9ed8\u8ba4\u6b8b\u6b21\u54c1\u5165\u5e93\u4ed3\u672a\u8bbe\u7f6e", inCommand.getPhysicalWarehouseCode()));
                }
                cmdSku.setDamagedQuantity(cmdSku.getDamagedQuantity() + inDamagedQuantity);
                WhInvRcd whInvRcd = new WhInvRcd();
                whInvRcd.setCommandCode(inCommand.getCode());
                whInvRcd.setWarehouseCode(damagedWh.getCode());
                whInvRcd.setInOutType(inCommand.getInOutType());
                whInvRcd.setSkuCode(cmdSku.getSkuCode());
                whInvRcd.setQuantity(inDamagedQuantity);
                whInvRcd.setSubmitTime(DateUtil.getNow());
                whInvRcd.setSubmitUserId(1L);
                if (EmptyUtil.isNotEmpty((Object)inCommand.getOperatorId())) {
                    whInvRcd.setSubmitUserId(inCommand.getOperatorId());
                }
                invRcdList.add(whInvRcd);
            }
            updateCmdSkuList.add(cmdSku);
        }
        boolean phyWhStockUpdateResult = this.updatePhyWhSkuStockAltInBound(altPackageInBound);
        if (!phyWhStockUpdateResult) {
            throw new WarehouseException("WH0001", "\u66f4\u65b0\u7269\u7406\u4ed3\u5e93\u5b58\u5931\u8d25!");
        }
        inCommand.setWhCommandSkuList(updateCmdSkuList);
        SWhCommandVO sWhCommand = this.convertCommandToDto(inCommand);
        sWhCommand.setStockRecordList(this.convertInvRcdToDto(invRcdList));
        this.sWhCommandService.processAllotPackageInBound(sWhCommand);
        if (altPackageInBound.isLastPackage()) {
            try {
                this.whAllotService.updateAllotRcdStatusByCode(inCommand.getReferenceCode(), WhAllotRcd.STATUS_FINISHED);
            }
            catch (Exception e) {
                throw new WarehouseException("WH0001", e.getMessage());
            }
        }
        return true;
    }

    private boolean updatePhyWhSkuStockAltInBound(WhAllotPackageInBoundVO altPackageInBound) {
        if (EmptyUtil.isEmpty(altPackageInBound.getInBoundSkuDetailList())) {
            return true;
        }
        ArrayList<WhWmsSkuStockRecord> skuStockRecordList = new ArrayList<WhWmsSkuStockRecord>();
        for (WhAllotPackageInBoundSkuDetailVO inBoundSkuDetail : altPackageInBound.getInBoundSkuDetailList()) {
            if (inBoundSkuDetail.getQuantity() == 0) continue;
            WhWmsHouseShelvesVO houseShelves = this.findPhyWhShelves(altPackageInBound.getPhysicalWarehouseCode(), inBoundSkuDetail.getSkuStatus());
            WhWmsSkuStockRecord stockRecord = (WhWmsSkuStockRecord)BeanUtil.buildFrom((Object)inBoundSkuDetail, WhWmsSkuStockRecord.class);
            stockRecord.setPhysicalWarehouseCode(houseShelves.getPhysicalWarehouseCode());
            stockRecord.setHouseType(houseShelves.getHouseType());
            stockRecord.setShelvesCode(houseShelves.getCode());
            stockRecord.setInOutType(WhCommand.TYPE_ALLOT_IN);
            stockRecord.setQuantity(inBoundSkuDetail.getQuantity());
            stockRecord.setReceiptNo(altPackageInBound.getAllotCode());
            stockRecord.setMemo(null);
            stockRecord.setIsUpdateScm(2);
            stockRecord.setCreateUserId(altPackageInBound.getOperatorId());
            skuStockRecordList.add(stockRecord);
        }
        this.whWmsSkuStockService.batchUpdateWhSkuStock(skuStockRecordList);
        return true;
    }

    private Map<String, Map<Integer, Integer>> buildInBoundSkuQuantityMap(List<WhAllotPackageInBoundSkuDetailVO> inBoundSkuDetailList) {
        HashMap<String, Map<Integer, Integer>> inSkuQtMap = new HashMap<String, Map<Integer, Integer>>();
        if (EmptyUtil.isNotEmpty(inBoundSkuDetailList)) {
            for (WhAllotPackageInBoundSkuDetailVO inBoundSkuDetail : inBoundSkuDetailList) {
                Integer total;
                if (inBoundSkuDetail.getQuantity() == 0) continue;
                HashMap<Integer, Integer> skuStatusQtMap = (HashMap<Integer, Integer>)inSkuQtMap.get(inBoundSkuDetail.getSkuCode());
                if (NullUtil.isNull((Object)skuStatusQtMap)) {
                    skuStatusQtMap = new HashMap<Integer, Integer>();
                    inSkuQtMap.put(inBoundSkuDetail.getSkuCode(), skuStatusQtMap);
                }
                if (NullUtil.isNull((Object)(total = (Integer)skuStatusQtMap.get(inBoundSkuDetail.getSkuStatus())))) {
                    total = 0;
                }
                skuStatusQtMap.put(inBoundSkuDetail.getSkuStatus(), total + inBoundSkuDetail.getQuantity());
            }
        }
        return inSkuQtMap;
    }

    private boolean finishCommandOutWithoutOccupy(WhCommand rcd, List<WhReleaseOccupationVO> releaseList) {
        List<WhInvRcd> invRcdList;
        boolean phyWhStockUpdateResult;
        if (EmptyUtil.isEmpty(rcd.getWhCommandSkuList())) {
            rcd.setWhCommandSkuList(this.findCommandSkuByCommandCode(rcd.getCode()));
        }
        if (!(phyWhStockUpdateResult = this.updatePhyWhSkuStockOut(invRcdList = this.buildWhCommandOutInvRcd(rcd), rcd))) {
            throw new WarehouseException("WH0001", "\u66f4\u65b0\u7269\u7406\u4ed3\u5e93\u5b58\u5931\u8d25!");
        }
        SWhCommandVO sWhCommand = this.convertCommandToDto(rcd);
        sWhCommand.setStockRecordList(this.convertInvRcdToDto(invRcdList));
        if (EmptyUtil.isNotEmpty(releaseList)) {
            List<SStockReleaseDTO> stockReleaseList = this.whInvService.convertWhRelease2DTO(releaseList);
            sWhCommand.setStockReleaseList(stockReleaseList);
        }
        this.sWhCommandService.finishWhCommand(sWhCommand);
        return true;
    }

    private List<WhInvRcd> buildWhCommandOutInvRcd(WhCommand rcd) {
        ArrayList<WhInvRcd> invRcdList = new ArrayList<WhInvRcd>();
        for (WhCommandSku whCommandSku : rcd.getWhCommandSkuList()) {
            if (whCommandSku.getQuantity() == null) {
                whCommandSku.setQuantity(whCommandSku.getPlanedQuantity());
            }
            if (whCommandSku.getDamagedQuantity() == null) {
                whCommandSku.setDamagedQuantity(0);
            }
            WhInvRcd whInvRcd = new WhInvRcd();
            whInvRcd.setCommandCode(rcd.getCode());
            whInvRcd.setWarehouseCode(rcd.getWarehouseCode());
            whInvRcd.setInOutType(rcd.getInOutType());
            whInvRcd.setSkuCode(whCommandSku.getSkuCode());
            whInvRcd.setSkuCode(whCommandSku.getSkuCode());
            whInvRcd.setQuantity(0 - whCommandSku.getQuantity());
            whInvRcd.setSubmitTime(DateUtil.getNow());
            whInvRcd.setSubmitUserId(1L);
            if (EmptyUtil.isNotEmpty((Object)rcd.getOperatorId())) {
                whInvRcd.setSubmitUserId(rcd.getOperatorId());
            }
            invRcdList.add(whInvRcd);
        }
        return invRcdList;
    }

    private boolean updatePhysicalStockByCond(List<SStockRecordVO> stockRecordList, WhCommand rcd) {
        if (EmptyUtil.isEmpty((String)rcd.getPhysicalWarehouseCode()) || EmptyUtil.isEmpty(stockRecordList)) {
            return true;
        }
        if (rcd.isIn()) {
            return this.updatePhyWhSkuStockInBySStock(stockRecordList, rcd);
        }
        if (rcd.isOut()) {
            return this.updatePhyWhSkuStockOutBySStock(stockRecordList, rcd);
        }
        throw new WarehouseException("WH0001", "\u6307\u4ee4\u51fa\u5165\u5e93\u7c7b\u578b\u5f02\u5e38");
    }

    private boolean updatePhyWhSkuStockInBySStock(List<SStockRecordVO> skuStockRcdList, WhCommand cmd) {
        if (EmptyUtil.isEmpty((String)cmd.getPhysicalWarehouseCode()) || EmptyUtil.isEmpty(skuStockRcdList)) {
            return true;
        }
        ArrayList<WhWmsConnectAllotPackageDetailVO> skuAllotDetailList = new ArrayList<WhWmsConnectAllotPackageDetailVO>();
        if (WhCommand.TYPE_ALLOT_IN.equals(cmd.getInOutType())) {
            WhConnectAltPackageCond cond = new WhConnectAltPackageCond();
            cond.setAllotRcdCode(cmd.getReferenceCode());
            cond.setFetch(true);
            List<WhWmsConnectAllotPackageVO> allotPackageList = this.whWmsConnectAllotPackageService.findConnectAltPackageList(cond);
            if (EmptyUtil.isNotEmpty(allotPackageList)) {
                for (WhWmsConnectAllotPackageVO allotPackage : allotPackageList) {
                    if (!EmptyUtil.isNotEmpty(allotPackage.getDetails())) continue;
                    skuAllotDetailList.addAll(allotPackage.getDetails());
                }
            }
        }
        List<WhWmsSkuStockRecord> phyWhRcdList = this.buildPhyWhRcdInBySStock(skuStockRcdList, cmd, skuAllotDetailList);
        this.updatePhyWhSkuStock(phyWhRcdList);
        return true;
    }

    private boolean updatePhyWhSkuStockIn(List<WhInvRcd> invRcdList, WhCommand cmd) {
        if (EmptyUtil.isEmpty((String)cmd.getPhysicalWarehouseCode()) || EmptyUtil.isEmpty(invRcdList)) {
            return true;
        }
        ArrayList<WhWmsConnectAllotPackageDetailVO> skuAllotDetailList = new ArrayList<WhWmsConnectAllotPackageDetailVO>();
        if (WhCommand.TYPE_ALLOT_IN.equals(cmd.getInOutType())) {
            WhConnectAltPackageCond cond = new WhConnectAltPackageCond();
            cond.setAllotRcdCode(cmd.getReferenceCode());
            cond.setFetch(true);
            List<WhWmsConnectAllotPackageVO> allotPackageList = this.whWmsConnectAllotPackageService.findConnectAltPackageList(cond);
            if (EmptyUtil.isNotEmpty(allotPackageList)) {
                for (WhWmsConnectAllotPackageVO allotPackage : allotPackageList) {
                    if (!EmptyUtil.isNotEmpty(allotPackage.getDetails())) continue;
                    skuAllotDetailList.addAll(allotPackage.getDetails());
                }
            }
        }
        List<WhWmsSkuStockRecord> phyWhRcdList = this.buildPhyWhRcdIn(invRcdList, cmd, skuAllotDetailList);
        this.updatePhyWhSkuStock(phyWhRcdList);
        return true;
    }

    private boolean updatePhyWhSkuStockOut(List<WhInvRcd> invRcdList, WhCommand cmd) {
        if (EmptyUtil.isEmpty((String)cmd.getPhysicalWarehouseCode()) || EmptyUtil.isEmpty(invRcdList)) {
            return true;
        }
        WhPhysicalWarehouse physicalWarehouse = this.whInfoService.findPhysicalWarehouseByCode(cmd.getPhysicalWarehouseCode());
        if (EmptyUtil.isEmpty((Object)physicalWarehouse)) {
            throw new WarehouseException("WH0103", "[" + cmd.getPhysicalWarehouseCode() + "]\u7269\u7406\u4ed3\u4e0d\u5b58\u5728!");
        }
        if (WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(physicalWarehouse.getWarehouseType())) {
            return true;
        }
        for (WhInvRcd skuStockRcd : invRcdList) {
            if (skuStockRcd.getQuantity() == 0) continue;
            WhWarehouse whWarehouse = this.whWarehouseMapper.findWarehouseByCode(skuStockRcd.getWarehouseCode());
            if (EmptyUtil.isEmpty((Object)whWarehouse)) {
                throw new WarehouseException("WH0103", "[" + cmd.getWarehouseCode() + "]\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728!");
            }
            if (NullUtil.isNull((Object)skuStockRcd.getSubmitUserId())) {
                skuStockRcd.setSubmitUserId(1L);
            }
            int skuStatus = this.getSkuStatusByWarehouseType(whWarehouse.getCommodityStatus());
            this.whWmsSkuStockService.updatePhyWhSkuStock(physicalWarehouse.getCode(), skuStockRcd.getSkuCode(), skuStatus, skuStockRcd.getQuantity(), cmd.getInOutType(), cmd.getReferenceCode(), skuStockRcd.getSubmitUserId(), null);
        }
        return true;
    }

    private List<WhWmsSkuStockRecord> buildPhyWhRcdIn(List<WhInvRcd> skuStockRcdList, WhCommand cmd, List<WhWmsConnectAllotPackageDetailVO> skuAllotDetailList) {
        WhPhysicalWarehouse physicalWarehouse = this.whInfoService.findPhysicalWarehouseByCode(cmd.getPhysicalWarehouseCode());
        if (EmptyUtil.isEmpty((Object)physicalWarehouse)) {
            throw new WarehouseException("WH0103", "[" + cmd.getPhysicalWarehouseCode() + "]\u7269\u7406\u4ed3\u4e0d\u5b58\u5728!");
        }
        if (WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(physicalWarehouse.getWarehouseType())) {
            return Collections.emptyList();
        }
        this.sortSkuAllotDetail(skuAllotDetailList);
        Map<String, List<WhWmsConnectAllotPackageDetailVO>> skuAllotMap = this.groupBySku(skuAllotDetailList);
        ArrayList<WhWmsSkuStockRecord> phyWhSkuStockRcdList = new ArrayList<WhWmsSkuStockRecord>();
        block0: for (WhInvRcd skuStockRcd : skuStockRcdList) {
            WhWarehouse whWarehouse = this.whWarehouseMapper.findWarehouseByCode(skuStockRcd.getWarehouseCode());
            if (EmptyUtil.isEmpty((Object)whWarehouse)) {
                throw new WarehouseException("WH0103", "[" + cmd.getWarehouseCode() + "]\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728!");
            }
            int skuStatus = this.getSkuStatusByWarehouseType(whWarehouse.getCommodityStatus());
            WhWmsHouseShelvesVO houseShelves = this.findPhyWhShelves(cmd.getPhysicalWarehouseCode(), skuStatus);
            int needQuantity = skuStockRcd.getQuantity();
            List<WhWmsConnectAllotPackageDetailVO> tmpSkuAllotDetailList = skuAllotMap.get(skuStockRcd.getSkuCode());
            if (EmptyUtil.isNotEmpty(tmpSkuAllotDetailList)) {
                for (WhWmsConnectAllotPackageDetailVO packageDetail : tmpSkuAllotDetailList) {
                    if (packageDetail.getQuantity() == 0) continue;
                    int canuseQuantity = Math.min(needQuantity, packageDetail.getQuantity());
                    packageDetail.setQuantity(packageDetail.getQuantity() - canuseQuantity);
                    WhWmsSkuStockRecordVO record = this.buildWmsSkuStockRecord(houseShelves, skuStockRcd, packageDetail.getBarCode(), (Integer)skuStatus, (Integer)canuseQuantity);
                    phyWhSkuStockRcdList.add(record);
                    if ((needQuantity -= canuseQuantity) != 0) continue;
                    continue block0;
                }
                continue;
            }
            WhWmsSkuStockRecordVO record = this.buildWmsSkuStockRecord(houseShelves, skuStockRcd, skuStockRcd.getSkuCode() + "_0000", (Integer)skuStatus, (Integer)needQuantity);
            phyWhSkuStockRcdList.add(record);
        }
        return phyWhSkuStockRcdList;
    }

    private Map<String, List<WhWmsConnectAllotPackageDetailVO>> groupBySku(List<WhWmsConnectAllotPackageDetailVO> skuAllotDetailList) {
        HashMap<String, List<WhWmsConnectAllotPackageDetailVO>> map = new HashMap<String, List<WhWmsConnectAllotPackageDetailVO>>();
        if (EmptyUtil.isNotEmpty(skuAllotDetailList)) {
            for (WhWmsConnectAllotPackageDetailVO skuPackageDetail : skuAllotDetailList) {
                ArrayList<WhWmsConnectAllotPackageDetailVO> tmpList = (ArrayList<WhWmsConnectAllotPackageDetailVO>)map.get(skuPackageDetail.getSkuCode());
                if (NullUtil.isNull((Object)tmpList)) {
                    tmpList = new ArrayList<WhWmsConnectAllotPackageDetailVO>();
                    map.put(skuPackageDetail.getSkuCode(), tmpList);
                }
                tmpList.add(skuPackageDetail);
            }
        }
        return map;
    }

    private List<WhWmsSkuStockRecord> buildPhyWhRcdInBySStock(List<SStockRecordVO> skuStockRcdList, WhCommand cmd, List<WhWmsConnectAllotPackageDetailVO> skuAllotDetailList) {
        WhPhysicalWarehouse physicalWarehouse = this.whInfoService.findPhysicalWarehouseByCode(cmd.getPhysicalWarehouseCode());
        if (EmptyUtil.isEmpty((Object)physicalWarehouse)) {
            throw new WarehouseException("WH0103", "[" + cmd.getPhysicalWarehouseCode() + "]\u7269\u7406\u4ed3\u4e0d\u5b58\u5728!");
        }
        if (WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(physicalWarehouse.getWarehouseType())) {
            return Collections.emptyList();
        }
        this.sortSkuAllotDetail(skuAllotDetailList);
        Map<String, List<WhWmsConnectAllotPackageDetailVO>> skuAllotMap = this.groupBySku(skuAllotDetailList);
        ArrayList<WhWmsSkuStockRecord> phyWhSkuStockRcdList = new ArrayList<WhWmsSkuStockRecord>();
        for (SStockRecordVO skuStockRcd : skuStockRcdList) {
            WhWarehouse whWarehouse = this.whWarehouseMapper.findWarehouseByCode(skuStockRcd.getWarehouseCode());
            if (EmptyUtil.isEmpty((Object)whWarehouse)) {
                throw new WarehouseException("WH0103", "[" + cmd.getWarehouseCode() + "]\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728!");
            }
            int skuStatus = this.getSkuStatusByWarehouseType(whWarehouse.getCommodityStatus());
            WhWmsHouseShelvesVO houseShelves = this.findPhyWhShelves(cmd.getPhysicalWarehouseCode(), skuStatus);
            int needQuantity = skuStockRcd.getQuantity();
            List<WhWmsConnectAllotPackageDetailVO> skuDetailList = skuAllotMap.get(skuStockRcd.getSkuCode());
            if (EmptyUtil.isNotEmpty(skuDetailList)) {
                for (WhWmsConnectAllotPackageDetailVO packageDetail : skuDetailList) {
                    if (packageDetail.getQuantity() == 0) continue;
                    int canuseQuantity = Math.min(needQuantity, packageDetail.getQuantity());
                    packageDetail.setQuantity(packageDetail.getQuantity() - canuseQuantity);
                    WhWmsSkuStockRecordVO record = this.buildWmsSkuStockRecord(houseShelves, skuStockRcd, packageDetail.getBarCode(), (Integer)skuStatus, (Integer)canuseQuantity);
                    phyWhSkuStockRcdList.add(record);
                    if ((needQuantity -= canuseQuantity) != 0) continue;
                    break;
                }
                if (needQuantity == 0) continue;
                throw new WarehouseException("WH0001", "\u5165\u5e93\u6570\u91cf\u5f02\u5e38");
            }
            WhWmsSkuStockRecordVO record = this.buildWmsSkuStockRecord(houseShelves, skuStockRcd, skuStockRcd.getSkuCode() + "_0000", (Integer)skuStatus, (Integer)needQuantity);
            phyWhSkuStockRcdList.add(record);
        }
        return phyWhSkuStockRcdList;
    }

    private WhWmsSkuStockRecordVO buildWmsSkuStockRecord(WhWmsHouseShelvesVO houseShelves, SStockRecordVO skuStockRcd, String barcode, Integer skuStatus, Integer canUseQuantity) {
        WhWmsSkuStockRecordVO record = new WhWmsSkuStockRecordVO();
        record.setQuantity(canUseQuantity);
        record.setPhysicalWarehouseCode(houseShelves.getPhysicalWarehouseCode());
        record.setHouseType(houseShelves.getHouseType());
        record.setBarCode(barcode);
        record.setShelvesCode(houseShelves.getCode());
        record.setSkuCode(skuStockRcd.getSkuCode());
        record.setSkuStatus(skuStatus);
        record.setReceiptNo(skuStockRcd.getCommandCode());
        record.setInOutType(skuStockRcd.getInOutType());
        record.setMemo("");
        if (NullUtil.isNotNull((Object)skuStockRcd.getSubmitUserId())) {
            record.setCreateUserId(skuStockRcd.getSubmitUserId().longValue());
        } else {
            record.setCreateUserId(1L);
        }
        record.setIsUpdateScm(2);
        return record;
    }

    private WhWmsSkuStockRecordVO buildWmsSkuStockRecord(WhWmsHouseShelvesVO houseShelves, WhInvRcd skuStockRcd, String barcode, Integer skuStatus, Integer canUseQuantity) {
        WhWmsSkuStockRecordVO record = new WhWmsSkuStockRecordVO();
        record.setQuantity(canUseQuantity);
        record.setPhysicalWarehouseCode(houseShelves.getPhysicalWarehouseCode());
        record.setHouseType(houseShelves.getHouseType());
        record.setBarCode(barcode);
        record.setShelvesCode(houseShelves.getCode());
        record.setSkuCode(skuStockRcd.getSkuCode());
        record.setSkuStatus(skuStatus);
        record.setReceiptNo(skuStockRcd.getCommandCode());
        record.setInOutType(skuStockRcd.getInOutType());
        record.setMemo("");
        if (NullUtil.isNotNull((Object)skuStockRcd.getSubmitUserId())) {
            record.setCreateUserId((long)skuStockRcd.getSubmitUserId());
        } else {
            record.setCreateUserId(1L);
        }
        record.setIsUpdateScm(2);
        return record;
    }

    private void sortSkuAllotDetail(List<WhWmsConnectAllotPackageDetailVO> skuAllotDetailList) {
        if (EmptyUtil.isEmpty(skuAllotDetailList)) {
            return;
        }
        ArrayList<String> barcodes = new ArrayList<String>();
        for (WhWmsConnectAllotPackageDetailVO allotPackageDetail : skuAllotDetailList) {
            barcodes.add(allotPackageDetail.getBarCode());
        }
        final Map<String, WhWmsSkuBarcodeVO> barcodeMap = this.getBarcodeMap(barcodes);
        Collections.sort(skuAllotDetailList, new Comparator<WhWmsConnectAllotPackageDetailVO>(){

            @Override
            public int compare(WhWmsConnectAllotPackageDetailVO o1, WhWmsConnectAllotPackageDetailVO o2) {
                WhWmsSkuBarcodeVO bc1 = (WhWmsSkuBarcodeVO)barcodeMap.get(o1.getBarCode());
                WhWmsSkuBarcodeVO bc2 = (WhWmsSkuBarcodeVO)barcodeMap.get(o2.getBarCode());
                return WhCommandServiceImpl.this.whWmsSkuBarcodeService.compareBarCode(bc1, bc2);
            }
        });
    }

    private boolean updatePhyWhSkuStockOutBySStock(List<SStockRecordVO> skuStockRcdList, WhCommand cmd) {
        WhPhysicalWarehouse physicalWarehouse = this.whInfoService.findPhysicalWarehouseByCode(cmd.getPhysicalWarehouseCode());
        if (EmptyUtil.isEmpty((Object)physicalWarehouse)) {
            throw new WarehouseException("WH0103", "[" + cmd.getPhysicalWarehouseCode() + "]\u7269\u7406\u4ed3\u4e0d\u5b58\u5728!");
        }
        if (WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(physicalWarehouse.getWarehouseType())) {
            return true;
        }
        for (SStockRecordVO skuStockRcd : skuStockRcdList) {
            List<WhWmsSkuStock> skuStockList;
            WhWarehouse whWarehouse = this.whWarehouseMapper.findWarehouseByCode(skuStockRcd.getWarehouseCode());
            if (EmptyUtil.isEmpty((Object)whWarehouse)) {
                throw new WarehouseException("WH0103", "[" + cmd.getWarehouseCode() + "]\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728!");
            }
            if (NullUtil.isNull((Object)skuStockRcd.getSubmitUserId())) {
                skuStockRcd.setSubmitUserId(Integer.valueOf(1));
            }
            int skuStatus = this.getSkuStatusByWarehouseType(whWarehouse.getCommodityStatus());
            int needQuantity = -skuStockRcd.getQuantity().intValue();
            int errorCount = 0;
            block3: while (errorCount < 3 && needQuantity != 0 && !EmptyUtil.isEmpty(skuStockList = this.findPhyWhSkuStock(physicalWarehouse.getCode(), skuStockRcd.getSkuCode(), skuStatus))) {
                this.sortPhyWhSkuStock(skuStockList);
                for (WhWmsSkuStock skuStock : skuStockList) {
                    int canUse = Math.min(needQuantity, skuStock.getAmount());
                    try {
                        this.whWmsSkuStockService.updateStockByCond(-canUse, skuStock.getPhysicalWarehouseCode(), skuStock.getHouseType(), skuStock.getBarCode(), skuStock.getShelvesCode(), skuStock.getSkuCode(), skuStock.getSkuStatus(), skuStockRcd.getInOutType(), skuStockRcd.getCommandCode(), skuStockRcd.getSubmitUserId().longValue(), skuStockRcd.getMemo(), 2);
                        skuStock.setAmount(skuStock.getAmount() - (needQuantity -= canUse));
                        if (needQuantity != 0) continue;
                    }
                    catch (WarehouseException whEx) {
                        ++errorCount;
                    }
                    continue block3;
                }
            }
            if (needQuantity == 0) continue;
            throw new WarehouseException("WH0001", String.format("\u7269\u7406\u4ed3[%s][%s][%s]\u5e93\u5b58\u4e0d\u8db3[%s]", physicalWarehouse.getCode(), skuStockRcd.getSkuCode(), WhCommand.getSkuStatusName(skuStatus), -skuStockRcd.getQuantity().intValue()));
        }
        return true;
    }

    @Override
    @Transactional
    public boolean updatePhyWhSkuStockOut(String physicalWarehouseCode, String skuCode, Integer skuStatus, Integer outAmount) {
        List<WhWmsSkuStock> skuStockList;
        WhPhysicalWarehouse physicalWarehouse = this.whInfoService.findPhysicalWarehouseByCode(physicalWarehouseCode);
        if (EmptyUtil.isEmpty((Object)physicalWarehouse)) {
            throw new WarehouseException("WH0103", "[" + physicalWarehouseCode + "]\u7269\u7406\u4ed3\u4e0d\u5b58\u5728!");
        }
        if (WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(physicalWarehouse.getWarehouseType())) {
            return false;
        }
        int needQuantity = -outAmount.intValue();
        int errorCount = 0;
        block2: while (errorCount < 3 && needQuantity != 0 && !EmptyUtil.isEmpty(skuStockList = this.findPhyWhSkuStock(physicalWarehouse.getCode(), skuCode, skuStatus))) {
            this.sortPhyWhSkuStock(skuStockList);
            for (WhWmsSkuStock skuStock : skuStockList) {
                int canUse = Math.min(needQuantity, skuStock.getAmount());
                try {
                    this.whWmsSkuStockService.outSkuStockByCond(-canUse, skuStock.getPhysicalWarehouseCode(), skuStock.getHouseType(), skuStock.getBarCode(), skuStock.getShelvesCode(), skuStock.getSkuCode(), skuStock.getSkuStatus());
                    skuStock.setAmount(skuStock.getAmount() - (needQuantity -= canUse));
                    if (needQuantity != 0) continue;
                }
                catch (WarehouseException whEx) {
                    ++errorCount;
                }
                continue block2;
            }
        }
        if (needQuantity != 0) {
            throw new WarehouseException("WH0001", String.format("\u7269\u7406\u4ed3[%s][%s][%s]\u5e93\u5b58\u4e0d\u8db3[%s]", physicalWarehouse.getCode(), skuCode, WhCommand.getSkuStatusName(skuStatus), -outAmount.intValue()));
        }
        return true;
    }

    @Override
    public boolean updatePhyWhSkuStockOut(String physicalWarehouseCode, String skuCode, Integer skuStatus, Integer quantity, Integer inOutType, String referenceCode, Long operatorId, String memo) {
        List<WhWmsSkuStock> skuStockList;
        if (NullUtil.isNull((Object)operatorId)) {
            operatorId = 1L;
        }
        int needQuantity = -quantity.intValue();
        int errorCount = 0;
        block2: while (errorCount < 3 && needQuantity != 0 && !EmptyUtil.isEmpty(skuStockList = this.findPhyWhSkuStock(physicalWarehouseCode, skuCode, skuStatus))) {
            this.sortPhyWhSkuStock(skuStockList);
            for (WhWmsSkuStock skuStock : skuStockList) {
                int canUse = Math.min(needQuantity, skuStock.getAmount());
                try {
                    this.whWmsSkuStockService.updateStockByCond(-canUse, skuStock.getPhysicalWarehouseCode(), skuStock.getHouseType(), skuStock.getBarCode(), skuStock.getShelvesCode(), skuStock.getSkuCode(), skuStock.getSkuStatus(), inOutType, referenceCode, operatorId, memo, 2);
                    skuStock.setAmount(skuStock.getAmount() - (needQuantity -= canUse));
                    if (needQuantity != 0) continue;
                }
                catch (WarehouseException whEx) {
                    ++errorCount;
                }
                continue block2;
            }
        }
        if (needQuantity != 0) {
            throw new WarehouseException("WH0001", String.format("\u7269\u7406\u4ed3[%s][%s][%s]\u5e93\u5b58\u4e0d\u8db3[%s]", physicalWarehouseCode, skuCode, WhCommand.getSkuStatusName(skuStatus), -quantity.intValue()));
        }
        return true;
    }

    private void sortPhyWhSkuStock(List<WhWmsSkuStock> skuStockList) {
        if (EmptyUtil.isEmpty(skuStockList)) {
            return;
        }
        ArrayList<String> barcodes = new ArrayList<String>();
        for (WhWmsSkuStock skuStock : skuStockList) {
            barcodes.add(skuStock.getBarCode());
        }
        final Map<String, WhWmsSkuBarcodeVO> barcodeMap = this.getBarcodeMap(barcodes);
        Collections.sort(skuStockList, new Comparator<WhWmsSkuStock>(){

            @Override
            public int compare(WhWmsSkuStock o1, WhWmsSkuStock o2) {
                if (o1.getBarCode().endsWith("_0000") && o2.getBarCode().endsWith("_0000")) {
                    return 0;
                }
                if (o1.getBarCode().endsWith("_0000")) {
                    return -1;
                }
                if (o2.getBarCode().endsWith("_0000")) {
                    return 1;
                }
                if (o1.getBarCode().endsWith("_0001") && o2.getBarCode().endsWith("_0001")) {
                    return 0;
                }
                if (o1.getBarCode().endsWith("_0001")) {
                    return -1;
                }
                if (o2.getBarCode().endsWith("_0001")) {
                    return 1;
                }
                WhWmsSkuBarcodeVO bc1 = (WhWmsSkuBarcodeVO)barcodeMap.get(o1.getBarCode());
                WhWmsSkuBarcodeVO bc2 = (WhWmsSkuBarcodeVO)barcodeMap.get(o2.getBarCode());
                return WhCommandServiceImpl.this.whWmsSkuBarcodeService.compareBarCode(bc1, bc2);
            }
        });
    }

    private Map<String, WhWmsSkuBarcodeVO> getBarcodeMap(List<String> barcodes) {
        return this.whWmsSkuBarcodeService.getBarcodeMap(barcodes);
    }

    private List<WhWmsSkuStock> findPhyWhSkuStock(String physicalWarehouseCode, String skuCode, Integer skuStatus) {
        WhWmsSkuStockVO stockCond = new WhWmsSkuStockVO();
        stockCond.setPhysicalWarehouseCode(physicalWarehouseCode);
        stockCond.setSkuCode(skuCode);
        stockCond.setSkuStatus(skuStatus);
        List<WhWmsSkuStock> skuStockList = this.whWmsSkuStockService.getStockByCond(stockCond);
        if (EmptyUtil.isNotEmpty(skuStockList)) {
            Iterator<WhWmsSkuStock> iterator = skuStockList.iterator();
            while (iterator.hasNext()) {
                WhWmsSkuStock skuStock = iterator.next();
                if (skuStock.getAmount() > 0) continue;
                iterator.remove();
            }
        }
        return skuStockList;
    }

    private WhWmsHouseShelvesVO findPhyWhShelves(String physicalWarehouseCode, Integer skuStatus) {
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setSkuStatus(skuStatus);
        List<WhWmsHouseShelvesVO> whWmsHouseShelvesVOs = this.whWmsHouseShelvesService.getHouseShelvesByCond(cond);
        if (CollectionUtils.isEmpty(whWmsHouseShelvesVOs)) {
            throw new WarehouseException("WH0001", "\u7269\u7406\u4ed3[" + cond.getPhysicalWarehouseCode() + "],SKU\u72b6\u6001[" + WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus()) + "],\u5e93\u4f4d\u4e0d\u5b58\u5728!");
        }
        if (whWmsHouseShelvesVOs.size() > 1) {
            throw new WarehouseException("WH0001", "\u7269\u7406\u4ed3[" + cond.getPhysicalWarehouseCode() + "],SKU\u72b6\u6001[" + WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus()) + "],\u67e5\u8be2\u6709\u591a\u4e2a\u5e93\u4f4d!");
        }
        return whWmsHouseShelvesVOs.get(0);
    }

    private boolean _updatePhysicalStockByCond(SStockRecordVO stockRecordVO, WhCommand rcd) {
        if (EmptyUtil.isEmpty((String)rcd.getPhysicalWarehouseCode())) {
            return true;
        }
        WhWmsSkuStockVO record = new WhWmsSkuStockVO();
        record.setWarehouseCode(stockRecordVO.getWarehouseCode());
        record.setSkuCode(stockRecordVO.getSkuCode());
        record.setAmount(stockRecordVO.getQuantity());
        record.setInOutType(stockRecordVO.getInOutType());
        record.setReceiptNo(stockRecordVO.getCommandCode());
        WhWarehouse whWarehouse = this.whWarehouseMapper.findWarehouseByCode(record.getWarehouseCode());
        if (EmptyUtil.isEmpty((Object)whWarehouse)) {
            throw new WarehouseException("WH0103", "[" + record.getWarehouseCode() + "]\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728!");
        }
        WhPhysicalWarehouse physicalWarehouse = this.whInfoService.findPhysicalWarehouseByCode(rcd.getPhysicalWarehouseCode());
        if (EmptyUtil.isEmpty((Object)physicalWarehouse)) {
            throw new WarehouseException("WH0103", "[" + rcd.getPhysicalWarehouseCode() + "]\u7269\u7406\u4ed3\u4e0d\u5b58\u5728!");
        }
        if (!WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(physicalWarehouse.getWarehouseType())) {
            int skuStatus = this.getSkuStatusByWarehouseType(whWarehouse.getCommodityStatus());
            WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
            cond.setPhysicalWarehouseCode(physicalWarehouse.getCode());
            cond.setSkuStatus(skuStatus);
            List<WhWmsHouseShelvesVO> whWmsHouseShelvesVOs = this.whWmsHouseShelvesService.getHouseShelvesByCond(cond);
            if (CollectionUtils.isEmpty(whWmsHouseShelvesVOs)) {
                throw new WarehouseException("WH0001", "\u7269\u7406\u4ed3[" + cond.getPhysicalWarehouseCode() + "],SKU\u72b6\u6001[" + WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus()) + "],\u5e93\u4f4d\u4e0d\u5b58\u5728!");
            }
            if (whWmsHouseShelvesVOs.size() > 1) {
                throw new WarehouseException("WH0001", "\u7269\u7406\u4ed3[" + cond.getPhysicalWarehouseCode() + "],SKU\u72b6\u6001[" + WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus()) + "],\u67e5\u8be2\u6709\u591a\u4e2a\u5e93\u4f4d!");
            }
            String houseType = whWmsHouseShelvesVOs.get(0).getHouseType();
            String barcode = record.getSkuCode() + "_0001";
            String shelvesCode = whWmsHouseShelvesVOs.get(0).getCode();
            String skuCode = record.getSkuCode();
            String memo = "";
            Integer isUpdateScm = 2;
            Long operatorId = 1L;
            if (EmptyUtil.isNotEmpty((Object)rcd.getOperatorId())) {
                operatorId = rcd.getOperatorId();
            }
            return this.whWmsSkuStockService.updateStockByCond(record.getAmount(), physicalWarehouse.getCode(), houseType, barcode, shelvesCode, skuCode, skuStatus, record.getInOutType(), record.getReceiptNo(), operatorId, memo, isUpdateScm);
        }
        return true;
    }

    @Override
    public int getSkuStatusByWarehouseType(Integer commodityStatus) {
        return WhWarehouseVO.convertSkuStatusByCommodityStatus(commodityStatus);
    }

    private boolean finishCommandForPrdc(WhCommand rcd) throws Exception {
        if (rcd != null && WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus())) {
            WhWarehouse whWarehouse;
            rcd.setCommandStatus(WhCommand.STATUS_FINISHED);
            rcd.setProcessTime(rcd.getProcessTime() == null ? new Date() : rcd.getProcessTime());
            this.whCommandMapper.updateByPrimaryKeySelective(rcd);
            if (EmptyUtil.isEmpty(rcd.getWhCommandSkuList())) {
                rcd.setWhCommandSkuList(this.findCommandSkuByCommandCode(rcd.getCode()));
            }
            if (EmptyUtil.isEmpty((Object)(whWarehouse = this.whInfoService.findWarehouseByCode(rcd.getWarehouseCode())))) {
                throw new WarehouseException("WH0103", "\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728!");
            }
            WhPhysicalWarehouse physicalWarehouse = this.whInfoService.findPhysicalWarehouseByCode(rcd.getPhysicalWarehouseCode());
            if (EmptyUtil.isEmpty((Object)physicalWarehouse)) {
                throw new WarehouseException("WH0103", "\u7269\u7406\u4ed3\u4e0d\u5b58\u5728!");
            }
            boolean needUpdateWmsSkuStock = false;
            if (!WhPhysicalWarehouseVO.WAREHOUSE_TYPE_WH_WMS.equals(physicalWarehouse.getWarehouseType())) {
                needUpdateWmsSkuStock = true;
            }
            HashMap<String, WhWarehouse> whMap = new HashMap<String, WhWarehouse>();
            whMap.put(whWarehouse.getCode(), whWarehouse);
            ArrayList<WhWmsSkuStockRecord> skuStockRecordList = new ArrayList<WhWmsSkuStockRecord>();
            for (WhCommandSku whCommandSku : rcd.getWhCommandSkuList()) {
                if (whCommandSku.getQuantity() == null) {
                    whCommandSku.setQuantity(whCommandSku.getPlanedQuantity());
                }
                if (whCommandSku.getDamagedQuantity() == null) {
                    whCommandSku.setDamagedQuantity(0);
                }
                this.whCommandSkuMapper.updateByPrimaryKeySelective(whCommandSku);
                if (rcd.isIn()) {
                    WhInvRcd whInvRcd;
                    String goodWareHouseCode = rcd.getWarehouseCode();
                    String damagedWarehouseCode = "";
                    if (whCommandSku.getDamagedQuantity() > 0) {
                        WhWarehouse damagedWarehouse = this.whInfoService.findDefaultInDefectiveWarehouseByPhyWhCode(rcd.getPhysicalWarehouseCode());
                        if (NullUtil.isNull((Object)damagedWarehouse)) {
                            throw new WarehouseException("CO0002", "\u6b8b\u6b21\u4ed3\u4e0d\u5b58\u5728!");
                        }
                        whMap.put(damagedWarehouse.getCode(), damagedWarehouse);
                        damagedWarehouseCode = damagedWarehouse.getCode();
                        if (damagedWarehouseCode.equals(rcd.getWarehouseCode())) {
                            WhWarehouse waitWarehouse = this.whInfoService.findDefaultInNondefectiveWarehouseByPhyWhCode(rcd.getPhysicalWarehouseCode());
                            if (NullUtil.isNull((Object)waitWarehouse)) {
                                throw new WarehouseException("CO0002", "\u826f\u54c1\u5f85\u5206\u914d\u4ed3\u4e0d\u5b58\u5728!");
                            }
                            goodWareHouseCode = waitWarehouse.getCode();
                            whMap.put(waitWarehouse.getCode(), waitWarehouse);
                        }
                    }
                    if (whCommandSku.getQuantity() > 0) {
                        whInvRcd = new WhInvRcd();
                        whInvRcd.setCommandCode(rcd.getCode());
                        whInvRcd.setWarehouseCode(goodWareHouseCode);
                        whInvRcd.setInOutType(rcd.getInOutType());
                        whInvRcd.setSkuCode(whCommandSku.getSkuCode());
                        whInvRcd.setQuantity(whCommandSku.getQuantity());
                        whInvRcd.setSubmitTime(DateUtil.getNow());
                        whInvRcd.setSubmitUserId(rcd.getOperatorId());
                        this.whInvService.record(whInvRcd);
                        if (needUpdateWmsSkuStock) {
                            skuStockRecordList.add(this.buildPhyWhSkuStockRcd(whInvRcd, whMap, physicalWarehouse));
                        }
                    }
                    if (whCommandSku.getDamagedQuantity() <= 0) continue;
                    whInvRcd = new WhInvRcd();
                    whInvRcd.setCommandCode(rcd.getCode());
                    whInvRcd.setWarehouseCode(damagedWarehouseCode);
                    whInvRcd.setInOutType(rcd.getInOutType());
                    whInvRcd.setSkuCode(whCommandSku.getSkuCode());
                    whInvRcd.setQuantity(whCommandSku.getDamagedQuantity());
                    whInvRcd.setSubmitTime(DateUtil.getNow());
                    whInvRcd.setSubmitUserId(rcd.getOperatorId());
                    this.whInvService.record(whInvRcd);
                    if (!needUpdateWmsSkuStock) continue;
                    skuStockRecordList.add(this.buildPhyWhSkuStockRcd(whInvRcd, whMap, physicalWarehouse));
                    continue;
                }
                if (!rcd.isOut()) continue;
                WhInvRcd whInvRcd = new WhInvRcd();
                whInvRcd.setCommandCode(rcd.getCode());
                whInvRcd.setWarehouseCode(rcd.getWarehouseCode());
                whInvRcd.setInOutType(rcd.getInOutType());
                whInvRcd.setSkuCode(whCommandSku.getSkuCode());
                whInvRcd.setQuantity(0 - whCommandSku.getQuantity());
                whInvRcd.setSubmitTime(DateUtil.getNow());
                whInvRcd.setSubmitUserId(rcd.getOperatorId());
                this.whInvService.record(whInvRcd);
                if (needUpdateWmsSkuStock) {
                    this.updatePhysicalStockForPrdcOut(whInvRcd, rcd);
                }
                WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
                whReleaseOccupationVO.setOccupyType(rcd.getInOutType());
                whReleaseOccupationVO.setReferenceCode(whCommandSku.getCode());
                this.whInvService.releaseOccupation(whReleaseOccupationVO);
            }
            this.updatePhyWhSkuStock(skuStockRecordList);
            this.processAfterFinishCommand(rcd);
            return true;
        }
        throw new WarehouseException("CO0002", "\u6307\u4ee4\u72b6\u6001\u4e0d\u662f\u5f85\u5904\u7406");
    }

    private boolean updatePhysicalStockForPrdcOut(WhInvRcd whInvRcd, WhCommand cmd) {
        SStockRecordVO sStockRecordVO = new SStockRecordVO();
        BeanUtils.copyProperties((Object)whInvRcd, (Object)sStockRecordVO);
        if (NullUtil.isNotNull((Object)whInvRcd.getTakeStockRcdId())) {
            sStockRecordVO.setTakeStockRcdId(whInvRcd.getTakeStockRcdId());
        }
        if (NullUtil.isNotNull((Object)whInvRcd.getSubmitUserId())) {
            sStockRecordVO.setSubmitUserId(Integer.valueOf(whInvRcd.getSubmitUserId().intValue()));
        }
        return this.updatePhysicalStockByCond(Collections.singletonList(sStockRecordVO), cmd);
    }

    private void updatePhyWhSkuStock(List<WhWmsSkuStockRecord> skuStockRecordList) {
        if (EmptyUtil.isNotEmpty(skuStockRecordList)) {
            for (WhWmsSkuStockRecord skuStockRecord : skuStockRecordList) {
                this.whWmsSkuStockService.updateStockByCond(skuStockRecord.getQuantity(), skuStockRecord.getPhysicalWarehouseCode(), skuStockRecord.getHouseType(), skuStockRecord.getBarCode(), skuStockRecord.getShelvesCode(), skuStockRecord.getSkuCode(), skuStockRecord.getSkuStatus(), skuStockRecord.getInOutType(), skuStockRecord.getReceiptNo(), skuStockRecord.getCreateUserId(), skuStockRecord.getMemo(), 2);
            }
        }
    }

    private WhWmsSkuStockRecord buildPhyWhSkuStockRcd(WhInvRcd whInvRcd, Map<String, WhWarehouse> whMap, WhPhysicalWarehouse physicalWarehouse) {
        WhWarehouse wh = whMap.get(whInvRcd.getWarehouseCode());
        Integer skuStatus = this.getSkuStatusByWarehouseType(wh.getCommodityStatus());
        WhWmsHouseShelvesVO shelvesVO = this.getWhWmsHouseShelves(physicalWarehouse.getCode(), skuStatus);
        WhWmsSkuStockRecord skuStockRecord = new WhWmsSkuStockRecord();
        skuStockRecord.setPhysicalWarehouseCode(shelvesVO.getPhysicalWarehouseCode());
        skuStockRecord.setSkuStatus(skuStatus);
        skuStockRecord.setQuantity(whInvRcd.getQuantity());
        skuStockRecord.setSkuCode(whInvRcd.getSkuCode());
        skuStockRecord.setBarCode(skuStockRecord.getSkuCode() + "_0000");
        skuStockRecord.setShelvesCode(shelvesVO.getCode());
        skuStockRecord.setHouseType(shelvesVO.getHouseType());
        skuStockRecord.setMemo("\u52a0\u5de5");
        skuStockRecord.setInOutType(whInvRcd.getInOutType());
        skuStockRecord.setReceiptNo(whInvRcd.getCommandCode());
        skuStockRecord.setCreateTime(DateUtil.getNow());
        skuStockRecord.setCreateUserId(NullUtil.isNull((Object)whInvRcd.getSubmitUserId()) ? 1L : whInvRcd.getSubmitUserId());
        return skuStockRecord;
    }

    private WhWmsHouseShelvesVO getWhWmsHouseShelves(String physicalWarehouseCode, Integer skuStatus) {
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setSkuStatus(skuStatus);
        List<WhWmsHouseShelvesVO> whWmsHouseShelvesList = this.whWmsHouseShelvesService.getHouseShelvesByCond(cond);
        if (CollectionUtils.isEmpty(whWmsHouseShelvesList)) {
            throw new WarehouseException("WH0001", "\u7269\u7406\u4ed3[" + cond.getPhysicalWarehouseCode() + "],SKU[" + cond.getSkuCode() + "],SKU\u72b6\u6001[" + WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus()) + "],\u5e93\u4f4d\u4e0d\u5b58\u5728!");
        }
        if (whWmsHouseShelvesList.size() > 1) {
            throw new WarehouseException("WH0001", "\u7269\u7406\u4ed3[" + cond.getPhysicalWarehouseCode() + "],SKU[" + cond.getSkuCode() + "],SKU\u72b6\u6001[" + WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus()) + "],\u67e5\u8be2\u6709\u591a\u4e2a\u5e93\u4f4d!");
        }
        return whWmsHouseShelvesList.get(0);
    }

    @Override
    public WhCommandSku findCommandSku(String skuCode, Long commandId) {
        WhCommandSkuExample example = new WhCommandSkuExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode).andCommandIdEqualTo(commandId);
        List<WhCommandSku> commandSkuList = this.whCommandSkuMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(commandSkuList)) {
            return null;
        }
        return commandSkuList.get(0);
    }

    @Override
    @Transactional
    public void failureStartConnect(String cmdCode) {
        WhCommand whCommand = this.findCommandByCode(cmdCode, false);
        whCommand.setFailureStartConnect(whCommand.getFailureStartConnect() + 1);
        this.whCommandMapper.updateByPrimaryKey(whCommand);
    }

    @Override
    @Transactional
    public void failureStartConnect(List<String> cmdCodes) {
        this.whCommandMapper.failureStartConnect(cmdCodes);
    }

    @Override
    public WhCommand findCommandByReferenceCode(String referenceCode) {
        WhCommandExample example = new WhCommandExample();
        example.createCriteria().andReferenceCodeEqualTo(referenceCode);
        List<WhCommand> whCommands = this.whCommandMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(whCommands)) {
            if (whCommands.size() > 1) {
                throw new WarehouseException("WH0001", "\u4e00\u4e2a\u76f8\u5173\u5355\u636e\u53f7\u5bf9\u5e94\u591a\u6761\u4ed3\u5e93\u6307\u4ee4");
            }
            whCommands.get(0).setWhCommandSkuList(this.findCommandSkuByCommandId(whCommands.get(0).getId()));
            return whCommands.get(0);
        }
        return null;
    }

    @Override
    @Transactional
    public boolean commandStatusToShortages(String whCommandCode) {
        boolean success;
        WhCommand rcd = this.findCommandByCode(whCommandCode, false);
        if (NullUtil.isNull((Object)rcd)) {
            throw new WarehouseException("CO0002", "\u6307\u4ee4\u4e0d\u5b58\u5728");
        }
        if (WhCommand.STATUS_SHORTAGES.equals(rcd.getCommandStatus())) {
            throw new WarehouseException("CO0002", "\u6307\u4ee4\u5df2\u53d6\u6d88");
        }
        WhCommandExample example = new WhCommandExample();
        example.createCriteria().andIdEqualTo(rcd.getId()).andCommandStatusEqualTo(rcd.getCommandStatus());
        WhCommand update = new WhCommand();
        update.setCommandStatus(WhCommand.STATUS_SHORTAGES);
        boolean bl = success = this.whCommandMapper.updateByExampleSelective(update, example) == 1;
        if (!success) {
            throw new WarehouseException("CO0002", String.format("[%s]\u6307\u4ee4\u72b6\u6001\u53d6\u6d88\u5931\u8d25", whCommandCode));
        }
        return true;
    }

    @Override
    @Transactional
    public boolean commandStatusToShortages(List<String> whCommandCodes) {
        List<WhCommand> rcds = this.findCommandByCodes(whCommandCodes, false);
        if (CollectionUtils.isEmpty(rcds)) {
            throw new WarehouseException("CO0002", "\u6307\u4ee4\u4e0d\u5b58\u5728");
        }
        for (WhCommand rcd : rcds) {
            if (!WhCommand.STATUS_SHORTAGES.equals(rcd.getCommandStatus())) continue;
            throw new WarehouseException("CO0002", "[" + rcd.getCode() + "]\u6307\u4ee4\u5df2\u53d6\u6d88");
        }
        for (WhCommand rcd : rcds) {
            WhCommandExample example = new WhCommandExample();
            example.createCriteria().andIdEqualTo(rcd.getId()).andCommandStatusEqualTo(rcd.getCommandStatus());
            WhCommand update = new WhCommand();
            update.setCommandStatus(WhCommand.STATUS_SHORTAGES);
            boolean success = this.whCommandMapper.updateByExampleSelective(update, example) == 1;
            if (success) continue;
            throw new WarehouseException("CO0002", String.format("[%s]\u6307\u4ee4\u72b6\u6001\u53d6\u6d88\u5931\u8d25", rcd.getCode()));
        }
        return true;
    }

    @Override
    @Transactional
    public boolean commandInProcessingToPicking(String whCommandCode) {
        WhCommand rcd = this.findCommandByCode(whCommandCode, false);
        if (rcd != null && WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus())) {
            boolean reslut;
            boolean bl = reslut = this.whCommandMapper.updateCommandStatus(rcd.getId(), WhCommand.STATUS_IN_PROCESSING, WhCommand.STATUS_PICKING) == 1;
            if (!reslut) {
                throw new WarehouseException("CO0002", String.format("\u6307\u4ee4\u72b6\u6001\u5f02\u5e38", new Object[0]));
            }
            return reslut;
        }
        throw new WarehouseException("CO0002", "failed,current status is not STATUS_IN_PROCESSING.");
    }

    @Override
    @Transactional
    public boolean commandInPickingToDistribution(String whCommandCode) {
        WhCommand rcd = this.findCommandByCode(whCommandCode, false);
        if (rcd != null && WhCommand.STATUS_PICKING.equals(rcd.getCommandStatus())) {
            boolean reslut;
            boolean bl = reslut = this.whCommandMapper.updateCommandStatus(rcd.getId(), WhCommand.STATUS_PICKING, WhCommand.STATUS_DISTRIBUTION) == 1;
            if (!reslut) {
                throw new WarehouseException("CO0002", String.format("\u6307\u4ee4\u72b6\u6001\u5f02\u5e38", new Object[0]));
            }
            return reslut;
        }
        throw new WarehouseException("CO0002", "failed,current status is not STATUS_PICKING.");
    }

    @Override
    @Transactional
    public boolean commandInPickingToHandover(String whCommandCode) {
        WhCommand rcd = this.findCommandByCode(whCommandCode, false);
        if (rcd != null && WhCommand.STATUS_PICKING.equals(rcd.getCommandStatus())) {
            boolean reslut;
            boolean bl = reslut = this.whCommandMapper.updateCommandStatus(rcd.getId(), WhCommand.STATUS_PICKING, WhCommand.STATUS_HANDOVER) == 1;
            if (!reslut) {
                throw new WarehouseException("CO0002", String.format("\u6307\u4ee4\u72b6\u6001\u5f02\u5e38", new Object[0]));
            }
            return reslut;
        }
        throw new WarehouseException("CO0002", "\u5f53\u524d\u72b6\u6001\u4e0d\u662f\u662f\u5f85\u62e3\u8d27");
    }

    @Override
    @Transactional
    public boolean commandInDistributionToPacking(String whCommandCode) {
        WhCommand rcd = this.findCommandByCode(whCommandCode, false);
        if (rcd != null && WhCommand.STATUS_DISTRIBUTION.equals(rcd.getCommandStatus())) {
            boolean reslut;
            boolean bl = reslut = this.whCommandMapper.updateCommandStatus(rcd.getId(), WhCommand.STATUS_DISTRIBUTION, WhCommand.STATUS_PACKING) == 1;
            if (!reslut) {
                throw new WarehouseException("CO0002", String.format("\u6307\u4ee4\u72b6\u6001\u5f02\u5e38", new Object[0]));
            }
            return reslut;
        }
        throw new WarehouseException("CO0002", "failed,current status is not STATUS_DISTRIBUTION.");
    }

    @Override
    @Transactional
    public boolean batchUpdateCommandStatus(List<String> whCommandCodes, Integer newStatus, Integer oldStatus) {
        boolean result;
        if (EmptyUtil.isEmpty(whCommandCodes)) {
            throw new WarehouseException("WH0001", "\u6307\u4ee4\u4e3a\u7a7a");
        }
        HashSet<String> codes = new HashSet<String>();
        for (String code : whCommandCodes) {
            codes.add(code);
        }
        int size = codes.size();
        boolean bl = result = this.whCommandMapper.batchUpdateCommandStatus(Arrays.asList(codes.toArray(new String[size])), newStatus, oldStatus) == size;
        if (!result) {
            throw new WarehouseException("WH0001", "\u6307\u4ee4\u72b6\u6001\u5f02\u5e38");
        }
        return result;
    }

    @Override
    @Transactional
    public boolean batchUpdateCommandStatusAndFailure(List<String> whCommandCodes, Integer newStatus) {
        boolean result;
        if (EmptyUtil.isEmpty(whCommandCodes)) {
            throw new WarehouseException("WH0001", "\u6307\u4ee4\u4e3a\u7a7a");
        }
        HashSet<String> codes = new HashSet<String>();
        for (String code : whCommandCodes) {
            codes.add(code);
        }
        int size = codes.size();
        boolean bl = result = this.whCommandMapper.batchUpdateCommandStatusAndFailure(Arrays.asList(codes.toArray(new String[size])), newStatus) == size;
        if (!result) {
            throw new WarehouseException("WH0001", "\u6307\u4ee4\u72b6\u6001\u5f02\u5e38");
        }
        return result;
    }

    @Override
    @Transactional
    public boolean commandInPackingToHandover(String whCommandCode) {
        WhCommand rcd = this.findCommandByCode(whCommandCode, false);
        if (rcd != null && WhCommand.STATUS_PACKING.equals(rcd.getCommandStatus())) {
            boolean reslut;
            rcd.setCommandStatus(WhCommand.STATUS_HANDOVER);
            boolean bl = reslut = this.whCommandMapper.updateCommandStatus(rcd.getId(), WhCommand.STATUS_PACKING, WhCommand.STATUS_HANDOVER) == 1;
            if (!reslut) {
                throw new WarehouseException("CO0002", String.format("\u6307\u4ee4\u72b6\u6001\u5f02\u5e38", new Object[0]));
            }
            return reslut;
        }
        throw new WarehouseException("CO0002", "failed,current status is not STATUS_PACKING.");
    }

    @Override
    @Transactional
    public boolean batchCommandInPackingToHandover(List<String> whCommandCodes) {
        boolean reslut;
        boolean bl = reslut = this.whCommandMapper.batchUpdateCommandStatus(whCommandCodes, WhCommand.STATUS_HANDOVER, WhCommand.STATUS_PACKING) > 0;
        if (!reslut) {
            throw new WarehouseException("CO0002", String.format("\u6307\u4ee4\u72b6\u6001\u5f02\u5e38", new Object[0]));
        }
        return reslut;
    }

    @Override
    @Transactional
    public boolean commandInProcessingToHandover(String whCommandCode) {
        WhCommand rcd = this.findCommandByCode(whCommandCode, false);
        if (rcd != null && WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus())) {
            boolean reslut;
            boolean bl = reslut = this.whCommandMapper.updateCommandStatus(rcd.getId(), WhCommand.STATUS_IN_PROCESSING, WhCommand.STATUS_HANDOVER) == 1;
            if (!reslut) {
                throw new WarehouseException("CO0002", String.format("\u6307\u4ee4\u72b6\u6001\u5f02\u5e38", new Object[0]));
            }
            return reslut;
        }
        throw new WarehouseException("CO0002", "\u72b6\u6001\u4e0d\u662f\u5f85\u5904\u7406.");
    }

    @Override
    @Transactional
    public boolean commandShortagesToInProcessing(String whCommandCode) {
        WhCommand rcd = this.findCommandByCode(whCommandCode, false);
        if (rcd != null && WhCommand.STATUS_SHORTAGES.equals(rcd.getCommandStatus())) {
            boolean reslut;
            boolean bl = reslut = this.whCommandMapper.updateCommandStatus(rcd.getId(), WhCommand.STATUS_SHORTAGES, WhCommand.STATUS_IN_PROCESSING) == 1;
            if (!reslut) {
                throw new WarehouseException("CO0002", String.format("\u6307\u4ee4\u72b6\u6001\u5f02\u5e38", new Object[0]));
            }
            return reslut;
        }
        throw new WarehouseException("CO0002", "failed,current status is not STATUS_SHORTAGES.");
    }

    @Override
    @Transactional
    public boolean commandInProcessingToShortages(String whCommandCode) {
        WhCommand rcd = this.findCommandByCode(whCommandCode, false);
        if (rcd != null && WhCommand.STATUS_IN_PROCESSING.equals(rcd.getCommandStatus())) {
            boolean reslut;
            boolean bl = reslut = this.whCommandMapper.updateCommandStatus(rcd.getId(), WhCommand.STATUS_IN_PROCESSING, WhCommand.STATUS_SHORTAGES) == 1;
            if (!reslut) {
                throw new WarehouseException("CO0002", String.format("\u6307\u4ee4\u72b6\u6001\u5f02\u5e38", new Object[0]));
            }
            return reslut;
        }
        throw new WarehouseException("CO0002", "failed,current status is not STATUS_IN_PROCESSING.");
    }

    @Override
    @Transactional
    public boolean commandInPackingToShortages(String whCommandCode) {
        WhCommand rcd = this.findCommandByCode(whCommandCode, false);
        if (rcd != null && WhCommand.STATUS_PACKING.equals(rcd.getCommandStatus())) {
            boolean reslut;
            boolean bl = reslut = this.whCommandMapper.updateCommandStatus(rcd.getId(), WhCommand.STATUS_PACKING, WhCommand.STATUS_SHORTAGES) == 1;
            if (!reslut) {
                throw new WarehouseException("CO0002", String.format("\u6307\u4ee4\u72b6\u6001\u5f02\u5e38", new Object[0]));
            }
            return reslut;
        }
        throw new WarehouseException("CO0002", "failed,current status is not STATUS_PACKING.");
    }

    @Override
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandByCond(WhWmsWaitOutStockCond cond) {
        List<WhWmsWaitOutStockVO> result = this.whCommandMapper.findWaitOutStockCommandByCond(cond);
        if (cond.isFetch()) {
            this.fullWhCommandSku(result);
        }
        return result;
    }

    @Override
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandSaleOutByCond(WhWmsWaitOutStockCond cond) {
        List<WhWmsWaitOutStockVO> result = this.whCommandMapper.findWaitOutStockCommandSaleOutByCond(cond);
        if (cond.isFetch()) {
            this.fullWhCommandSku(result);
        }
        return result;
    }

    @Override
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandAltByCond(WhWmsWaitOutStockCondAlt cond) {
        List<WhWmsWaitOutStockVO> result = this.whCommandMapper.findWaitOutStockCommandAltByCond(cond);
        if (cond.isFetch()) {
            this.fullWhCommandSku(result);
        }
        return result;
    }

    @Override
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandPcsRtnByCond(WhWmsWaitOutStockCondPcsRtn cond) {
        List<WhWmsWaitOutStockVO> result = this.whCommandMapper.findWaitOutStockCommandPcsRtnByCond(cond);
        if (cond.isFetch()) {
            this.fullWhCommandSku(result);
        }
        return result;
    }

    @Override
    public Pagination<WhWmsWaitOutStockVO> findWaitOutStockCommandRecWasteByCond(WhWmsWaitOutStockCondRecWaste cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        int total = this.whCommandMapper.countWaitOutStockCommandRecWasteByCond(cond);
        page.setRecord(Integer.valueOf(total));
        if (!NumberUtil.isNullOrZero((Number)total)) {
            List<WhWmsWaitOutStockVO> list = this.whCommandMapper.findWaitOutStockCommandRecWasteByCond(cond);
            if (cond.isFetch()) {
                this.fullWhCommandSku(list);
            }
            this.fullReceiveReason(list);
            page.setResultList(list);
        }
        return page;
    }

    private void fullReceiveReason(List<WhWmsWaitOutStockVO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList<String> refCodes = new ArrayList<String>();
            for (WhWmsWaitOutStockVO stockVO : list) {
                refCodes.add(stockVO.getReferenceCode());
            }
            if (refCodes.size() > 0) {
                WhWmsWaitOutStockCondRecWaste cond = new WhWmsWaitOutStockCondRecWaste();
                cond.setRefCodes(refCodes);
                List<WhWmsWaitOutStockVO> waitOutStockVOs = this.whCommandMapper.listReceiveOrderByCond(cond);
                if (CollectionUtils.isNotEmpty(waitOutStockVOs)) {
                    HashMap<String, String> refCodeReasonMap = new HashMap<String, String>();
                    for (WhWmsWaitOutStockVO waitOutStockVO : waitOutStockVOs) {
                        refCodeReasonMap.put(waitOutStockVO.getReferenceCode(), waitOutStockVO.getReceiveReason());
                    }
                    for (WhWmsWaitOutStockVO stockVO : list) {
                        stockVO.setReceiveReason((String)refCodeReasonMap.get(stockVO.getReferenceCode()));
                    }
                }
            }
        }
    }

    private void fullWhCommandSku(List<WhWmsWaitOutStockVO> list) {
        if (EmptyUtil.isNotEmpty(list)) {
            ArrayList<Long> whCommandIdList = new ArrayList<Long>();
            for (WhCommand whCommand : list) {
                whCommandIdList.add(whCommand.getId());
            }
            List<WhCommandSku> whCommandSkuList = this.findCommandSkuByCommandIds(whCommandIdList);
            HashMap<Long, ArrayList<WhCommandSku>> hashMap = new HashMap<Long, ArrayList<WhCommandSku>>();
            for (WhCommandSku whCommandSku : whCommandSkuList) {
                Long commandId = whCommandSku.getCommandId();
                ArrayList<WhCommandSku> listInMap = (ArrayList<WhCommandSku>)hashMap.get(commandId);
                if (listInMap == null) {
                    listInMap = new ArrayList<WhCommandSku>();
                    hashMap.put(commandId, listInMap);
                }
                listInMap.add(whCommandSku);
            }
            for (WhCommand whCommand : list) {
                List listInMap = (List)hashMap.get(whCommand.getId());
                whCommand.setWhCommandSkuList(listInMap);
            }
        }
    }

    @Override
    public List<WhSkuInfoVO> findWaitOutStockCommandSkuByCond(WhWmsWaitOutStockCond cond) {
        return this.whCommandMapper.findWaitOutStockCommandSkuByCond(cond);
    }

    private void processAfterFinishCommand(WhCommand rcd) {
        if (rcd == null) {
            return;
        }
        Integer inOutType = rcd.getInOutType();
        String referenceCode = rcd.getReferenceCode();
        try {
            if (WhCommand.TYPE_ALLOT_OUT.equals(inOutType)) {
                if (rcd.isNoUpdateAllot()) {
                    return;
                }
                this.whAllotService.updateAllotRcdStatusByCode(referenceCode, WhAllotRcd.STATUS_WAIT_FOR_INBOUND);
            } else if (WhCommand.TYPE_ALLOT_IN.equals(inOutType)) {
                if (rcd.isNoUpdateAllot()) {
                    return;
                }
                this.whAllotService.updateAllotRcdStatusByCode(referenceCode, WhAllotRcd.STATUS_FINISHED);
            } else if (WhCommand.TYPE_PURCHASE_RETURN_OUT.equals(inOutType)) {
                this.finishPurchaseRtnByWhCommand(rcd);
            }
        }
        catch (Exception e) {
            throw new WarehouseException("WH0001", e.getMessage());
        }
    }

    private void fillCommandSku(List<WhCommand> result) {
        if (EmptyUtil.isNotEmpty(result)) {
            ArrayList<Long> whCommandIdList = new ArrayList<Long>();
            for (WhCommand whCommand : result) {
                whCommandIdList.add(whCommand.getId());
            }
            List<WhCommandSku> whCommandSkuList = this.findCommandSkuByCommandIds(whCommandIdList);
            HashMap<Long, ArrayList<WhCommandSku>> map = new HashMap<Long, ArrayList<WhCommandSku>>();
            for (WhCommandSku whCommandSku : whCommandSkuList) {
                Long commandId = whCommandSku.getCommandId();
                ArrayList<WhCommandSku> listInMap = (ArrayList<WhCommandSku>)map.get(commandId);
                if (listInMap == null) {
                    listInMap = new ArrayList<WhCommandSku>();
                    map.put(commandId, listInMap);
                }
                listInMap.add(whCommandSku);
            }
            for (WhCommand whCommand : result) {
                List listInMap = (List)map.get(whCommand.getId());
                whCommand.setWhCommandSkuList(listInMap);
            }
        }
    }

    @Override
    public WhSalesReturnExceptionSkuVO findSalesReturnExceptionSkuByCond(WhSalesReturnExceptionSkuCond cond) {
        List<WhSalesReturnExceptionSkuVO> list = this.listSalesReturnExceptionSkuByCond(cond);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<WhSalesReturnExceptionSkuVO> listSalesReturnExceptionSkuByCond(WhSalesReturnExceptionSkuCond cond) {
        return this.whSalesReturnExceptionSkuCustomMapper.listWhSalesReturnExceptionSkuByCond(cond);
    }

    @Override
    public List<WhSalesReturnExceptionSku> selectSalesReturnExceptionSkuByCond(WhSalesReturnExceptionSkuCond cond) {
        WhSalesReturnExceptionSkuExample example = this.buildSalesReturnExceptionSkuExampleByCond(cond);
        return this.whSalesReturnExceptionSkuMapper.selectByExample(example);
    }

    @Override
    public WhSalesReturnExceptionVO findSalesReturnExceptionByCond(WhSalesReturnExceptionCond cond) {
        List<WhSalesReturnExceptionVO> list = this.listSalesReturnExceptionByCond(cond);
        if (CollectionUtils.isNotEmpty(list)) {
            WhSalesReturnExceptionVO vo = list.get(0);
            if (cond.isFetch()) {
                WhSalesReturnExceptionSkuCond skuCond = new WhSalesReturnExceptionSkuCond();
                skuCond.setRefId(vo.getId());
                vo.setSalesReturnExceptionSkus(this.selectSalesReturnExceptionSkuByCond(skuCond));
            }
            return vo;
        }
        return null;
    }

    @Override
    public List<WhSalesReturnExceptionVO> listSalesReturnExceptionByCond(WhSalesReturnExceptionCond cond) {
        return this.whSalesReturnExceptionCustomMapper.listWhSalesReturnExceptionByCond(cond);
    }

    @Override
    public WhSalesReturnException selectSalesReturnExceptionById(Long id) {
        return this.whSalesReturnExceptionMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<WhSalesReturnException> selectSalesReturnExceptionByCond(WhSalesReturnExceptionCond cond) {
        WhSalesReturnExceptionExample example = this.buildSalesReturnExceptionExampleByCond(cond);
        return this.whSalesReturnExceptionMapper.selectByExample(example);
    }

    @Override
    @Transactional
    public boolean updateSalesReturnException(WhSalesReturnExceptionVO vo) throws Exception {
        boolean result;
        WhSalesReturnException obj = (WhSalesReturnException)BeanUtil.buildFrom((Object)vo, WhSalesReturnException.class);
        WhSalesReturnExceptionExample example = new WhSalesReturnExceptionExample();
        WhSalesReturnExceptionExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)vo.getId())) {
            criteria.andIdEqualTo(vo.getId());
        } else if (CollectionUtils.isNotEmpty(vo.getIds())) {
            criteria.andIdIn((List)vo.getIds());
        }
        Long refId = obj.getId();
        obj.setId(null);
        boolean bl = result = this.whSalesReturnExceptionMapper.updateByExampleSelective(obj, example) > 0;
        if (result && vo.isFetch() && CollectionUtils.isNotEmpty(vo.getSalesReturnExceptionSkus())) {
            if (this.deleteSalesReturnExceptionSkuByRefId(refId)) {
                List<WhSalesReturnExceptionSku> skuList = vo.getSalesReturnExceptionSkus();
                for (WhSalesReturnExceptionSku sku : skuList) {
                    sku.setRefId(refId);
                }
                result = this.whSalesReturnExceptionSkuCustomMapper.batchInsert(skuList) > 0;
            } else {
                throw new WarehouseException("WH0001", "\u5220\u9664sku\u5f02\u5e38");
            }
        }
        return result;
    }

    @Override
    @Transactional
    public boolean updateSalesReturnExceptionById(WhSalesReturnExceptionVO vo) throws Exception {
        boolean result;
        WhSalesReturnException obj = (WhSalesReturnException)BeanUtil.buildFrom((Object)vo, WhSalesReturnException.class);
        boolean bl = result = this.whSalesReturnExceptionMapper.updateByPrimaryKeySelective(obj) > 0;
        if (result && vo.isFetch() && CollectionUtils.isNotEmpty(vo.getSalesReturnExceptionSkus())) {
            for (WhSalesReturnExceptionSku exceptionSku : vo.getSalesReturnExceptionSkus()) {
                this.whSalesReturnExceptionSkuMapper.updateByPrimaryKeySelective(exceptionSku);
            }
        }
        return result;
    }

    @Override
    @Transactional
    public boolean insertSalesReturnException(WhSalesReturnExceptionVO vo) throws Exception {
        boolean result;
        WhSalesReturnException obj = (WhSalesReturnException)BeanUtil.buildFrom((Object)vo, WhSalesReturnException.class);
        obj.setCreateTime(DateUtil.getNow());
        boolean bl = result = this.whSalesReturnExceptionMapper.insert(obj) > 0;
        if (result && vo.isFetch() && CollectionUtils.isNotEmpty(vo.getSalesReturnExceptionSkus())) {
            List<WhSalesReturnExceptionSku> skuList = vo.getSalesReturnExceptionSkus();
            for (WhSalesReturnExceptionSku sku : skuList) {
                sku.setRefId(obj.getId());
            }
            result = this.whSalesReturnExceptionSkuCustomMapper.batchInsert(skuList) > 0;
        }
        vo.setId(obj.getId());
        return result;
    }

    @Transactional
    public boolean deleteSalesReturnExceptionSkuByRefId(Long refId) {
        WhSalesReturnExceptionSkuExample example = new WhSalesReturnExceptionSkuExample();
        WhSalesReturnExceptionSkuExample.Criteria criteria = example.createCriteria();
        criteria.andRefIdEqualTo(refId);
        if (CollectionUtils.isNotEmpty(this.whSalesReturnExceptionSkuMapper.selectByExample(example))) {
            return this.deleteSalesReturnExceptionSkuByExample(example);
        }
        return true;
    }

    @Transactional
    public boolean deleteSalesReturnExceptionSkuByExample(WhSalesReturnExceptionSkuExample example) {
        return this.whSalesReturnExceptionSkuMapper.deleteByExample(example) > 0;
    }

    @Override
    @Transactional
    public boolean updateSalesReturnExceptionSkuById(WhSalesReturnExceptionSku record) {
        return this.whSalesReturnExceptionSkuMapper.updateByPrimaryKeySelective(record) > 0;
    }

    @Override
    public Integer findCountSalesReturnExceptionByCond(WhSalesReturnExceptionCond cond) {
        WhSalesReturnExceptionExample example = this.buildSalesReturnExceptionExampleByCond(cond);
        return this.whSalesReturnExceptionMapper.countByExample(example);
    }

    private WhSalesReturnExceptionSkuExample buildSalesReturnExceptionSkuExampleByCond(WhSalesReturnExceptionSkuCond cond) {
        WhSalesReturnExceptionSkuExample example = new WhSalesReturnExceptionSkuExample();
        WhSalesReturnExceptionSkuExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)cond.getId())) {
            criteria.andIdEqualTo(cond.getId());
        } else if (CollectionUtils.isNotEmpty(cond.getIds())) {
            criteria.andIdIn((List)cond.getIds());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getRefId())) {
            criteria.andRefIdEqualTo(cond.getRefId());
        } else if (CollectionUtils.isNotEmpty(cond.getRefIds())) {
            criteria.andRefIdIn((List)cond.getRefIds());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getSkuCode())) {
            criteria.andSkuCodeEqualTo(cond.getSkuCode());
        }
        return example;
    }

    private WhSalesReturnExceptionExample buildSalesReturnExceptionExampleByCond(WhSalesReturnExceptionCond cond) {
        WhSalesReturnExceptionExample example = new WhSalesReturnExceptionExample();
        WhSalesReturnExceptionExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty((Object)cond.getId())) {
            criteria.andIdEqualTo(cond.getId());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getExpressType())) {
            criteria.andExpressTypeEqualTo(cond.getExpressType());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getExpressNo())) {
            criteria.andExpressNoEqualTo(cond.getExpressNo());
        } else if (EmptyUtil.isNotEmpty((String)cond.getExpressNoLike())) {
            criteria.andExpressNoLike(SQLUtils.allLike((String)cond.getExpressNoLike()));
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getReceiveDateStart())) {
            criteria.andReceiveDateGreaterThanOrEqualTo(cond.getReceiveDateStart());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getReceiveDateEnd())) {
            criteria.andReceiveDateLessThanOrEqualTo(cond.getReceiveDateEnd());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getProcessStatus())) {
            criteria.andProcessStatusEqualTo(cond.getProcessStatus());
        } else if (CollectionUtils.isNotEmpty(cond.getProcessStatusList())) {
            criteria.andProcessStatusIn((List)cond.getProcessStatusList());
        }
        if (EmptyUtil.isNotEmpty((String)cond.getPackageCode())) {
            criteria.andPackageCodeEqualTo(cond.getPackageCode());
        } else if (EmptyUtil.isNotEmpty((String)cond.getPackageCodeLike())) {
            criteria.andPackageCodeLike(SQLUtils.allLike((String)cond.getPackageCodeLike()));
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getCreateTimeStart())) {
            criteria.andCreateTimeGreaterThanOrEqualTo(cond.getCreateTimeStart());
        }
        if (EmptyUtil.isNotEmpty((Object)cond.getCreateTimeEnd())) {
            criteria.andCreateTimeLessThanOrEqualTo(cond.getCreateTimeEnd());
        }
        return example;
    }

    @Override
    public List<WhReceiveShelvesVO> findReceiveShelvesByCon(WhReceiveShelvesVO vo) {
        List<Long> commandIdList = this.whCommandMapper.findCommandIdsReceiveShelvesByCond(vo);
        ArrayList<WhReceiveShelvesVO> rtn = new ArrayList<WhReceiveShelvesVO>();
        if (commandIdList != null && commandIdList.size() > 0) {
            vo.setCommandIdList(commandIdList);
            List<WhReceiveShelvesVO> voList = this.whCommandMapper.findReceiveShelvesByCond(vo);
            HashMap<Integer, String> checkMap = new HashMap<Integer, String>();
            HashMap voMap = new HashMap();
            for (WhReceiveShelvesVO v : voList) {
                Integer key = v.getWhCommandId();
                String temp = "[" + v.getSkuCode() + "]" + v.getSkuName() + "<br/>";
                if (checkMap.containsKey(key)) {
                    String skuInfo = (String)checkMap.get(key) + temp;
                    checkMap.put(key, skuInfo);
                    continue;
                }
                checkMap.put(key, temp);
                rtn.add(v);
            }
            for (WhReceiveShelvesVO v : rtn) {
                String skuDetail = (String)checkMap.get(v.getWhCommandId());
                v.setSkuName(skuDetail);
                v.setSkuCode(skuDetail.lastIndexOf("[") > 1 ? "more" : v.getSkuCode());
            }
        }
        return rtn;
    }

    @Override
    public List<WhReceiveShelvesVO> findWaitClosePopCommandByCond(WhReceiveShelvesVO vo) {
        return this.whCommandMapper.findWaitClosePopCommandByCond(vo);
    }

    @Override
    public Integer findCountReceiveShelvesByCon(WhReceiveShelvesVO vo) {
        return this.whCommandMapper.findCountReceiveShelvesByCond(vo);
    }

    @Override
    public List<WhReceiveShelvesVO> findReceiveShelvesDetail(Integer whInType, Integer whCommandId) {
        List<WhReceiveShelvesVO> voList = this.whCommandMapper.findReceiveShelvesDetail(whInType, whCommandId);
        HashMap<String, Integer> quantityMap = new HashMap<String, Integer>();
        if (voList != null) {
            List<WhWmsWaitPutawayVO> dtList = this.whWmsWaitPutawayService.findWmsWaitPutawayByReceiptsNo(voList.get(0).getWhCmdCode());
            for (WhWmsWaitPutawayVO d : dtList) {
                String key = d.getSkuCode() + d.getSkuStatus();
                if (quantityMap.containsKey(key)) {
                    Integer val = this.parseInteger((Integer)quantityMap.get(key)) + d.getReceiveAmount();
                    quantityMap.put(key, val);
                    continue;
                }
                quantityMap.put(key, d.getReceiveAmount());
            }
            if (WhCommand.TYPE_PURCHASE_IN.equals(whInType)) {
                this.fetchDefectiveDetail(voList, whInType, WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING);
            }
            for (WhReceiveShelvesVO v : voList) {
                int mildDamagedNum = this.parseInteger((Integer)quantityMap.get(v.getSkuCode() + WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED));
                int nondefectiveNum = this.parseInteger((Integer)quantityMap.get(v.getSkuCode() + WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE));
                int sampleNum = this.parseInteger((Integer)quantityMap.get(v.getSkuCode() + WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE));
                int wastedNum = this.parseInteger((Integer)quantityMap.get(v.getSkuCode() + WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED));
                int displayNum = this.parseInteger((Integer)quantityMap.get(v.getSkuCode() + WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY));
                int propNum = this.parseInteger((Integer)quantityMap.get(v.getSkuCode() + WhWarehouseVO.COMMODITY_STATUS_FOR_PROP));
                int holdPendingNum = this.parseInteger((Integer)quantityMap.get(v.getSkuCode() + WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING));
                if (WhCommand.TYPE_PURCHASE_IN.equals(whInType)) {
                    if (holdPendingNum == 0 && mildDamagedNum > 0) {
                        v.setAllDefectiveQuantity(mildDamagedNum);
                    } else {
                        v.setAllDefectiveQuantity(holdPendingNum);
                    }
                } else {
                    v.setAllDefectiveQuantity(mildDamagedNum);
                }
                v.setAllNondefectiveQuantity(nondefectiveNum);
                v.setAllSampleQuantity(sampleNum);
                v.setAllWasteQuantity(wastedNum);
                v.setAllDisplayQuantity(displayNum);
                v.setAllPropQuantity(propNum);
                int allQcNum = v.getAllDefectiveQuantity() + v.getAllNondefectiveQuantity() + v.getAllSampleQuantity() + v.getAllWasteQuantity() + v.getAllDisplayQuantity() + v.getAllPropQuantity();
                v.setQcDetailList(dtList);
                v.setAllQcQuantity(allQcNum);
            }
        }
        return voList;
    }

    private void fetchDefectiveDetail(List<WhReceiveShelvesVO> voList, Integer whInType, Integer skuStatus) {
        WhReceiveShelvesVO receiveShelvesVO = voList.get(0);
        WhWmsReceiveShelvesDetailCond cond = new WhWmsReceiveShelvesDetailCond();
        cond.setRefCode(receiveShelvesVO.getReferenceCode());
        cond.setRefType(whInType);
        cond.setOriginType(1);
        List<WhWmsReceiveShelvesDetailVO> receiveShelvesDetailVOs = this.whWmsReceiveShelvesDetailService.listWhWmsReceiveShelvesDetailVOByCond(cond);
        HashMap<String, ArrayList<WhWmsReceiveShelvesDetailVO>> skuDetailImgMap = new HashMap<String, ArrayList<WhWmsReceiveShelvesDetailVO>>();
        if (CollectionUtils.isNotEmpty(receiveShelvesDetailVOs)) {
            for (WhWmsReceiveShelvesDetailVO detailVO : receiveShelvesDetailVOs) {
                ArrayList<WhWmsReceiveShelvesDetailVO> receiveShelvesDetailVOs1 = (ArrayList<WhWmsReceiveShelvesDetailVO>)skuDetailImgMap.get(detailVO.getSkuCode());
                if (CollectionUtils.isEmpty((Collection)receiveShelvesDetailVOs1)) {
                    receiveShelvesDetailVOs1 = new ArrayList<WhWmsReceiveShelvesDetailVO>();
                    skuDetailImgMap.put(detailVO.getSkuCode(), receiveShelvesDetailVOs1);
                }
                receiveShelvesDetailVOs1.add(detailVO);
            }
            for (WhReceiveShelvesVO shelvesVO : voList) {
                if (!CollectionUtils.isNotEmpty((Collection)((Collection)skuDetailImgMap.get(shelvesVO.getSkuCode())))) continue;
                shelvesVO.setReceiveShelvesDetailVOs((List)skuDetailImgMap.get(shelvesVO.getSkuCode()));
            }
        }
    }

    @Override
    public Long getSupplierIdByPurchaseReturnCode(String purchaseReturnCode) {
        return this.whCommandMapper.getSupplierIdByPurchaseReturnCode(purchaseReturnCode);
    }

    @Override
    public String getOriPhyCodeByPurchaseReturnCode(String purchaseReturnCode) {
        return this.whCommandMapper.getOriPhyCodeByPurchaseReturnCode(purchaseReturnCode);
    }

    @Override
    public void cancelPurchaseRtnByWhCommand(WhCommand command) {
        WmsPurchaseReturn vo = this.whCommandMapper.getPurchaseReturnByCode(command.getReferenceCode());
        if (NullUtil.isNull((Object)vo)) {
            throw new WarehouseException("\u91c7\u9000\u5355\u4e0d\u5b58\u5728");
        }
        WmsPurchaseReturn update = new WmsPurchaseReturn();
        update.setId(vo.getId());
        update.setReturnStatus(WmsPurchaseReturn.PURCHASE_RETURN_STATUS_WHCANCEL);
        update.setFinishTime(DateUtil.getNow());
        this.whCommandMapper.updatePurchaseRtn(update);
        List<WmsPurchaseReturnSku> rtnSkuList = this.whCommandMapper.getPurchaseReturnSku(vo.getId());
        if (EmptyUtil.isEmpty(rtnSkuList)) {
            throw new WarehouseException("\u91c7\u9000\u5355\u65e0\u884c\u8bb0\u5f55");
        }
        for (WmsPurchaseReturnSku rtnSku : rtnSkuList) {
            WmsPurchaseReturnSku updateRtnSku = new WmsPurchaseReturnSku();
            updateRtnSku.setId(rtnSku.getId());
            updateRtnSku.setRealityQuantity(0);
            updateRtnSku.setRefundedGoodQuantity(0);
            updateRtnSku.setRefundedWasteQuantity(0);
            this.whCommandMapper.updatePurchaseRtnSku(updateRtnSku);
        }
    }

    @Override
    public WmsPurchaseReturn getPurchaseReturnByCode(String code, boolean fetch) {
        WmsPurchaseReturn vo = this.whCommandMapper.getPurchaseReturnByCode(code);
        if (NullUtil.isNotNull((Object)vo) && fetch) {
            List<WmsPurchaseReturnSku> rtnSkuList = this.whCommandMapper.getPurchaseReturnSku(vo.getId());
            vo.setReturnSkuList(rtnSkuList);
        }
        return vo;
    }

    @Override
    public void finishPurchaseRtnByWhCommand(WhCommand command) {
        WmsPurchaseReturn vo = this.whCommandMapper.getPurchaseReturnByCode(command.getReferenceCode());
        if (NullUtil.isNull((Object)vo)) {
            throw new WarehouseException("\u91c7\u9000\u5355\u4e0d\u5b58\u5728");
        }
        WmsPurchaseReturn update = new WmsPurchaseReturn();
        update.setId(vo.getId());
        update.setReturnStatus(WmsPurchaseReturn.PURCHASE_RETURN_STATUS_ALREADY_FINISH);
        update.setFinishTime(DateUtil.getNow());
        this.whCommandMapper.updatePurchaseRtn(update);
        List<WmsPurchaseReturnSku> rtnSkuList = this.whCommandMapper.getPurchaseReturnSku(vo.getId());
        if (EmptyUtil.isEmpty(rtnSkuList)) {
            throw new WarehouseException("\u91c7\u9000\u5355\u65e0\u884c\u8bb0\u5f55");
        }
        HashMap<String, WhCommandSku> commandSkuMap = new HashMap<String, WhCommandSku>();
        for (WhCommandSku commandSku : command.getWhCommandSkuList()) {
            commandSkuMap.put(commandSku.getSkuCode(), commandSku);
        }
        WhCommandSku commandSku = null;
        for (WmsPurchaseReturnSku rtnSku : rtnSkuList) {
            commandSku = (WhCommandSku)commandSkuMap.get(rtnSku.getSkuCode());
            if (!EmptyUtil.isNotEmpty((Object)commandSku)) continue;
            WmsPurchaseReturnSku updateRtnSku = new WmsPurchaseReturnSku();
            updateRtnSku.setId(rtnSku.getId());
            updateRtnSku.setRealityQuantity(commandSku.getQuantity() + commandSku.getDamagedQuantity());
            if (WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(rtnSku.getSkuType())) {
                updateRtnSku.setRefundedGoodQuantity(commandSku.getQuantity());
            } else if (WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED.equals(rtnSku.getSkuType())) {
                updateRtnSku.setRefundedWasteQuantity(commandSku.getDamagedQuantity());
            } else {
                updateRtnSku.setRefundedWasteQuantity(commandSku.getQuantity());
            }
            this.whCommandMapper.updatePurchaseRtnSku(updateRtnSku);
        }
    }

    @Override
    public String getBarCode(String skuCode, Date prodDate) {
        return this.getBarCode(skuCode, prodDate, null);
    }

    @Override
    public String getBarCode(String skuCode, Date prodDate, Date expirationDate) {
        WhQualityControlVO qc = new WhQualityControlVO();
        qc.setQcSku(skuCode);
        qc.setQcProdDate(prodDate);
        qc.setQcExpirationDate(expirationDate);
        return this.getBarCode(qc);
    }

    public String getBarCodeByInOutType(WhReceiveShelvesVO vo, WhQualityControlVO qc) {
        if (WhCommand.TYPE_ALLOT_IN.equals(vo.getWhInType()) || WhCommand.TYPE_RETURN_IN.equals(vo.getWhInType())) {
            Integer shelfLife = this.whWmsSkuBarcodeService.findSkuShelfLifeBySkuCode(qc.getQcSku());
            if (EmptyUtil.isEmpty((Object)shelfLife) || shelfLife == 0) {
                if (EmptyUtil.isEmpty((String)qc.getBarCode())) {
                    return this.createBarCodeWhenNotExists(qc.getQcSku(), qc.getQcSku() + "_0001", 1, null);
                }
                WhWmsSkuBarcodeVO barcodeVO = new WhWmsSkuBarcodeVO();
                barcodeVO.setBarCode(qc.getBarCode());
                List<WhWmsSkuBarcodeVO> barcodeVOs = this.whWmsSkuBarcodeService.getWmsSkuBarcodeByCond(barcodeVO);
                if (CollectionUtils.isEmpty(barcodeVOs)) {
                    throw new RuntimeException("\u6279\u6b21\u53f7\u4e0d\u5b58\u5728!");
                }
                return qc.getBarCode();
            }
            if (EmptyUtil.isNotEmpty((String)qc.getBarCode())) {
                String barcode = this.getBarcodeBySkuCrossBorderFlag(qc);
                if (barcode != null) {
                    return barcode;
                }
                WhWmsSkuBarcodeVO barcodeVO = new WhWmsSkuBarcodeVO();
                barcodeVO.setProdDate(qc.getQcProdDate());
                barcodeVO.setExpirationDate(qc.getQcExpirationDate());
                barcodeVO.setBarCode(qc.getBarCode());
                List<WhWmsSkuBarcodeVO> barcodeVOs = this.whWmsSkuBarcodeService.getWmsSkuBarcodeByCond(barcodeVO);
                if (CollectionUtils.isEmpty(barcodeVOs)) {
                    if (WhCommand.TYPE_RETURN_IN.equals(vo.getWhInType())) {
                        throw new RuntimeException("\u626b\u63cf\u7684\u6279\u6b21\u53f7\u4e0d\u5b58\u5728[" + qc.getBarCode() + "]!");
                    }
                    return this.getBarCode(qc);
                }
                return qc.getBarCode();
            }
            return this.getBarCode(qc);
        }
        return this.getBarCode(qc);
    }

    @Override
    public String getPrePrintBarCode(WhQualityControlVO qc) {
        if (WhQualityControlVO.PRINT_TYPE_OTHER.equals(qc.getWhInType())) {
            List<String> barCodes = this.whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndSortByExpiredAsc(qc.getQcSku());
            if (CollectionUtils.isEmpty(barCodes)) {
                return this.createBarCodeWhenNotExists(qc.getQcSku(), qc.getQcSku() + "_0001", 1, DateUtil.getNow());
            }
            if (barCodes.size() == 1) {
                return barCodes.get(0);
            }
            throw new WarehouseException("WH0001", "\u5f53\u524dSKU\u627e\u5230\u591a\u4e2a\u6279\u6b21\uff0c\u4e0d\u80fd\u6253\u5370!");
        }
        return this.getBarCode(qc);
    }

    private String getBarcodeBySkuCrossBorderFlag(WhQualityControlVO qc) {
        if (WhInvRcd.TYPE_RETURN_IN.equals(qc.getWhInType())) {
            WhWmsSkuBarcodeVO wmsSkuBarcodeVO = this.whWmsSkuBarcodeService.findSkuInfoBySkuCode(qc.getQcSku());
            if (EmptyUtil.isEmpty((Object)wmsSkuBarcodeVO)) {
                throw new RuntimeException("[" + qc.getQcSku() + "],\u5f53\u524dSKU\u4e0d\u5b58\u5728!");
            }
            if (this.isExpirySku(wmsSkuBarcodeVO.getShelfLife()) && EmptyUtil.isNotEmpty((Object)wmsSkuBarcodeVO.getCrossBorderFlag()) && wmsSkuBarcodeVO.getCrossBorderFlag() == 1) {
                return this.createBarCodeWhenNotExists(qc.getQcSku(), qc.getQcSku() + "_0001", 1, null);
            }
        }
        return null;
    }

    @Override
    public String getBarCode(WhQualityControlVO qc) {
        Date expirationDate = qc.getQcExpirationDate();
        Date prodDate = qc.getQcProdDate();
        int batchNo = 2;
        Integer shelfLife = 0;
        String barcode = this.getBarcodeBySkuCrossBorderFlag(qc);
        if (barcode != null) {
            return barcode;
        }
        if (prodDate != null && this.isExpirySku(shelfLife = this.whWmsSkuBarcodeService.findSkuShelfLifeBySkuCode(qc.getQcSku())) && !qc.isManualCalculate()) {
            expirationDate = DateUtil.addDay((Date)prodDate, (int)shelfLife);
        }
        qc.setShelfLife(shelfLife);
        WhWmsSkuBarcodeCond cond = this.buildWhWmsSkuBarcodeCond(qc, expirationDate, prodDate);
        WhWmsSkuBarcode skuBarcodeVo = this.whWmsSkuBarcodeService.findMaxBatchNoByCond(cond);
        if (skuBarcodeVo == null) {
            if (WhInvRcd.TYPE_RETURN_IN.equals(qc.getWhInType())) {
                throw new RuntimeException("SKU[" + qc.getQcSku() + "]\u672a\u627e\u5230\u6b64\u751f\u4ea7\u65e5\u671f\u5bf9\u5e94\u7684\u6279\u6b21\u53f7");
            }
            skuBarcodeVo = this.whWmsSkuBarcodeService.findMaxBatchNo(qc.getQcSku(), null, null);
            if (skuBarcodeVo != null) {
                batchNo = skuBarcodeVo.getBatchNo() + 1;
            }
        } else {
            return skuBarcodeVo.getBarCode();
        }
        if (!this.isExpirySku(shelfLife)) {
            expirationDate = null;
            prodDate = null;
        }
        qc.setMakeNewBarcode(true);
        return this.createBarCode(qc, batchNo, expirationDate, prodDate);
    }

    private WhWmsSkuBarcodeCond buildWhWmsSkuBarcodeCond(WhQualityControlVO qc, Date expirationDate, Date prodDate) {
        WhWmsSkuBarcodeCond cond = new WhWmsSkuBarcodeCond();
        cond.setSkuCode(qc.getQcSku());
        if (this.isExpirySku(qc.getShelfLife())) {
            cond.setExpirationDateStr(DateUtil.format((Date)expirationDate, (String)"yyyy-MM-dd"));
            cond.setProdDateStr(DateUtil.format((Date)prodDate, (String)"yyyy-MM-dd"));
        }
        if ((WhCommand.TYPE_PURCHASE_IN.equals(qc.getWhInType()) || WhCommand.TYPE_PRODUCE_IN.equals(qc.getWhInType())) && EmptyUtil.isNotEmpty((String)qc.getReferenceCode())) {
            cond.setRefCode(qc.getReferenceCode().toUpperCase());
        }
        if (qc.isFetchEmptyRefCode()) {
            cond.setFetchEmptyRefCode(qc.isFetchEmptyRefCode());
        }
        return cond;
    }

    private boolean isExpirySku(Integer shelfLife) {
        return EmptyUtil.isNotEmpty((Object)shelfLife) && shelfLife > 0;
    }

    @Override
    public String createBarCodeWhenNotExists(String skuCode, String barcode, int batchNo, Date firstInDate) {
        WhWmsSkuBarcodeCond cond = new WhWmsSkuBarcodeCond();
        cond.setBarCode(barcode);
        List<WhWmsSkuBarcodeVO> skuBarcodeVOs = this.whWmsSkuBarcodeService.findExpiryDateSkuInfo(cond);
        if (CollectionUtils.isEmpty(skuBarcodeVOs)) {
            WhQualityControlVO qc = new WhQualityControlVO();
            qc.setQcSku(skuCode);
            if (EmptyUtil.isNotEmpty((Object)firstInDate)) {
                qc.setFirstInDate(firstInDate);
            } else {
                qc.setFirstInDate(DateUtil.getNow());
            }
            return this.createBarCode(qc, batchNo, null, null);
        }
        return barcode;
    }

    private String createBarCode(WhQualityControlVO qc, int batchNo, Date expirationDate, Date prodDate) {
        WhWmsSkuBarcodeVO bcVO = new WhWmsSkuBarcodeVO();
        bcVO.setSkuCode(qc.getQcSku());
        bcVO.setBatchNo(batchNo);
        bcVO.setExpirationDate(expirationDate);
        bcVO.setProdDate(prodDate);
        if (EmptyUtil.isNotEmpty((String)qc.getReferenceCode())) {
            bcVO.setRefCode(qc.getReferenceCode().toUpperCase());
        }
        bcVO.setInType(qc.getWhInType());
        if (EmptyUtil.isNotEmpty((Object)qc.getFirstInDate())) {
            bcVO.setFirstInDate(qc.getFirstInDate());
        } else {
            bcVO.setFirstInDate(DateUtil.getNow());
        }
        StringBuilder batch = new StringBuilder();
        batch.append(batchNo);
        while (batch.length() < 4) {
            batch.insert(0, "0");
        }
        String barcode = bcVO.getSkuCode() + "_" + batch.toString();
        bcVO.setBarCode(barcode);
        this.whWmsSkuBarcodeService.create(bcVO);
        return barcode;
    }

    private boolean checkNotEmpty(Integer quantity) {
        return quantity != null && quantity > 0;
    }

    @Override
    @Transactional
    public boolean qualityControl(WhReceiveShelvesVO vo) {
        this.updateCommandStatusById(vo.getWhCommandId(), WhCommand.STATUS_QUALITY_PROCESSING);
        List<WhQualityControlVO> qcVoList = vo.getQcList();
        for (WhQualityControlVO qc : qcVoList) {
            WhWmsShelvesSkuInfo whWmsShelvesSkuInfo;
            Integer shelfLife;
            int amount = 0;
            if (this.checkNotEmpty(qc.getNondefectiveQuantity())) {
                amount += qc.getNondefectiveQuantity().intValue();
            }
            if (this.checkNotEmpty(qc.getDefectiveQuantity())) {
                amount += qc.getDefectiveQuantity().intValue();
            }
            if (this.checkNotEmpty(qc.getSampleQuantity())) {
                amount += qc.getSampleQuantity().intValue();
            }
            if (this.checkNotEmpty(qc.getWasteQuantity())) {
                amount += qc.getWasteQuantity().intValue();
            }
            if (this.checkNotEmpty(qc.getDisplayQuantity())) {
                amount += qc.getDisplayQuantity().intValue();
            }
            if (this.checkNotEmpty(qc.getPropQuantity())) {
                amount += qc.getPropQuantity().intValue();
            }
            if (amount <= 0) continue;
            String remark = qc.getRemark();
            qc.setWhInType(vo.getWhInType());
            qc.setWhCmdCode(vo.getWhCmdCode());
            qc.setReferenceCode(vo.getReferenceCode());
            qc.setShelfLife(vo.getShelfLife());
            String barcode = this.getBarCodeByInOutType(vo, qc);
            qc.setBarCode(barcode);
            if (WhCommand.TYPE_PURCHASE_IN.equals(vo.getWhInType()) && EmptyUtil.isNotEmpty((Object)(shelfLife = this.whWmsSkuBarcodeService.findSkuShelfLifeBySkuCode(qc.getQcSku()))) && shelfLife > 0 && !vo.isSpecialReceive()) {
                this.checkExpiryDataForBarcode(qc, vo.isSpecialReceive());
            }
            WhCommand whCommand = this.whCommandMapper.selectByPrimaryKey(Long.parseLong(vo.getWhCommandId().toString()));
            WhPhysicalWarehouse whPhysicalWarehouse = this.whInfoService.findPhysicalWarehouseByCode(whCommand.getPhysicalWarehouseCode());
            vo.setWhCmdCode(whCommand.getCode());
            WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
            cond.setHouseType("HOUSE_TYPE_RECEIVE");
            cond.setPhysicalWarehouseCode(whPhysicalWarehouse.getCode());
            List<WhWmsHouseShelvesVO> shelvesList = this.whWmsHouseShelvesService.getHouseShelvesByCond(cond);
            String shelves = null;
            if (shelvesList == null || shelvesList.size() <= 0) {
                throw new RuntimeException("\u8bf7\u5148\u8bbe\u7f6e\u6536\u8d27\u6682\u5b58\u533a\u5e93\u4f4d");
            }
            shelves = shelvesList.get(0).getCode();
            Long operatorId = Long.parseLong(vo.getOperatorId().toString());
            qc.setPhysicalWarehouseCode(whPhysicalWarehouse.getCode());
            qc.setOperatorId(operatorId);
            qc.setPutawayQc(true);
            qc.setWarehouseCommodityStatus(vo.getCommodityStatus());
            if (qc.getNondefectiveQuantity() != null && qc.getNondefectiveQuantity() > 0) {
                this.recordWaitPutaway(vo, barcode, qc.getNondefectiveQuantity(), WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE, whPhysicalWarehouse.getCode(), qc.getQcSku(), "", qc);
                this.recordSkuStock(qc, barcode, qc.getNondefectiveQuantity(), WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE, whPhysicalWarehouse.getCode(), "HOUSE_TYPE_RECEIVE", shelves, whCommand, operatorId, "", 1);
                qc.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
                qc.setRemark("");
                this.updateScmStock(qc, whCommand, qc.getNondefectiveQuantity());
            }
            if (WhCommand.TYPE_PURCHASE_IN.equals(vo.getWhInType())) {
                if (qc.getDefectiveQuantity() != null && qc.getDefectiveQuantity() > 0) {
                    this.recordWaitPutaway(vo, barcode, qc.getDefectiveQuantity(), WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING, whPhysicalWarehouse.getCode(), qc.getQcSku(), remark, qc);
                    this.recordSkuStock(qc, barcode, qc.getDefectiveQuantity(), WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING, whPhysicalWarehouse.getCode(), "HOUSE_TYPE_RECEIVE", shelves, whCommand, operatorId, remark, 1);
                    qc.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING);
                    qc.setRemark(remark);
                    this.updateScmStock(qc, whCommand, qc.getDefectiveQuantity());
                }
            } else if (qc.getDefectiveQuantity() != null && qc.getDefectiveQuantity() > 0) {
                this.recordWaitPutaway(vo, barcode, qc.getDefectiveQuantity(), WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED, whPhysicalWarehouse.getCode(), qc.getQcSku(), remark, qc);
                this.recordSkuStock(qc, barcode, qc.getDefectiveQuantity(), WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED, whPhysicalWarehouse.getCode(), "HOUSE_TYPE_RECEIVE", shelves, whCommand, operatorId, remark, 1);
                qc.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
                qc.setRemark(remark);
                this.updateScmStock(qc, whCommand, qc.getDefectiveQuantity());
            }
            if (qc.getSampleQuantity() != null && qc.getSampleQuantity() > 0) {
                this.recordWaitPutaway(vo, barcode, qc.getSampleQuantity(), WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE, whPhysicalWarehouse.getCode(), qc.getQcSku(), remark, qc);
                this.recordSkuStock(qc, barcode, qc.getSampleQuantity(), WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE, whPhysicalWarehouse.getCode(), "HOUSE_TYPE_RECEIVE", shelves, whCommand, operatorId, remark, 1);
                qc.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE);
                qc.setRemark(remark);
                this.updateScmStock(qc, whCommand, qc.getSampleQuantity());
            }
            if (qc.getWasteQuantity() != null && qc.getWasteQuantity() > 0) {
                this.recordWaitPutaway(vo, barcode, qc.getWasteQuantity(), WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED, whPhysicalWarehouse.getCode(), qc.getQcSku(), remark, qc);
                this.recordSkuStock(qc, barcode, qc.getWasteQuantity(), WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED, whPhysicalWarehouse.getCode(), "HOUSE_TYPE_RECEIVE", shelves, whCommand, operatorId, remark, 1);
                qc.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED);
                qc.setRemark(remark);
                this.updateScmStock(qc, whCommand, qc.getWasteQuantity());
            }
            if (NullUtil.isNotNull((Object)qc.getDisplayQuantity()) && qc.getDisplayQuantity() > 0) {
                this.recordWaitPutaway(vo, barcode, qc.getDisplayQuantity(), WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY, whPhysicalWarehouse.getCode(), qc.getQcSku(), remark, qc);
                this.recordSkuStock(qc, barcode, qc.getDisplayQuantity(), WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY, whPhysicalWarehouse.getCode(), "HOUSE_TYPE_RECEIVE", shelves, whCommand, operatorId, remark, 1);
                qc.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY);
                qc.setRemark(remark);
                this.updateScmStock(qc, whCommand, qc.getDisplayQuantity());
            }
            if (NullUtil.isNotNull((Object)qc.getPropQuantity()) && qc.getPropQuantity() > 0) {
                this.recordWaitPutaway(vo, barcode, qc.getPropQuantity(), WhWarehouseVO.COMMODITY_STATUS_FOR_PROP, whPhysicalWarehouse.getCode(), qc.getQcSku(), remark, qc);
                this.recordSkuStock(qc, barcode, qc.getPropQuantity(), WhWarehouseVO.COMMODITY_STATUS_FOR_PROP, whPhysicalWarehouse.getCode(), "HOUSE_TYPE_RECEIVE", shelves, whCommand, operatorId, remark, 1);
                qc.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_PROP);
                qc.setRemark(remark);
                this.updateScmStock(qc, whCommand, qc.getPropQuantity());
            }
            if (!EmptyUtil.isNotEmpty((String)qc.getSupplierCode()) || !EmptyUtil.isNotEmpty((Object)(whWmsShelvesSkuInfo = this.whWmsShelvesSkuInfoService.getSkuInfoByCode(qc.getQcSku()))) || !EmptyUtil.isEmpty((String)whWmsShelvesSkuInfo.getSupplierCode())) continue;
            WhWmsShelvesSkuInfo record = new WhWmsShelvesSkuInfo();
            record.setId(whWmsShelvesSkuInfo.getId());
            record.setSupplierCode(qc.getSupplierCode());
            this.whWmsShelvesSkuInfoMapper.updateByPrimaryKeySelective(record);
        }
        return true;
    }

    private void checkExpiryDataForBarcode(WhQualityControlVO qc, boolean specialReceive) {
        WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
        cond.setBarCode(qc.getBarCode());
        cond.setSkuCode(qc.getQcSku());
        List<WhWmsSkuStockVO> skuStockVOs = this.whWmsSkuStockService.listExpiryDateSkuForCheckRule(cond);
        if (CollectionUtils.isNotEmpty(skuStockVOs)) {
            WhWmsSkuStockVO skuStockVO = skuStockVOs.get(0);
            Set<Long> beautySecondCategorySet = this.getGlobalConfigByKey(WhWmsSkuBarcodeVO.GLOBAL_CATEGORY_BEAUTY);
            if (beautySecondCategorySet != null && beautySecondCategorySet.contains(skuStockVO.getSecondLevelCategoryID())) {
                this.checkReceiveRuleByExpiryDate(WhWmsSkuBarcodeVO.CATEGORY_TYPE_BEAUTY, skuStockVO);
            } else {
                Set<Long> candleSecondCategorySet = this.getGlobalConfigByKey(WhWmsSkuBarcodeVO.GLOBAL_CATEGORY_CANDLE);
                if (candleSecondCategorySet != null && candleSecondCategorySet.contains(skuStockVO.getSecondLevelCategoryID())) {
                    this.checkReceiveRuleByExpiryDate(WhWmsSkuBarcodeVO.CATEGORY_TYPE_CANDLE, skuStockVO);
                } else if (!specialReceive) {
                    this.checkReceiveRuleByExpiryDate(WhWmsSkuBarcodeVO.CATEGORY_TYPE_FOODSTUFF, skuStockVO);
                }
            }
        }
    }

    private void checkReceiveRuleByExpiryDate(String categoryType, WhWmsSkuStockVO skuStockVO) {
        boolean isImported;
        String warnMsg = "\u5546\u54c1[%s],\u5269\u4f59\u5929\u6570<[%s]\u5929,\u4e0d\u80fd\u8d28\u68c0\u6536\u8d27!";
        int expiryDateDays = skuStockVO.getShelfLife();
        int surplusDays = skuStockVO.getSurplusDays();
        String skuCode = skuStockVO.getSkuCode();
        boolean bl = isImported = EmptyUtil.isNotEmpty((Object)skuStockVO.getIsImported()) && skuStockVO.getIsImported() == 1;
        if (WhWmsSkuBarcodeVO.CATEGORY_TYPE_BEAUTY.equals(categoryType) || WhWmsSkuBarcodeVO.CATEGORY_TYPE_CANDLE.equals(categoryType)) {
            if (expiryDateDays > 0 && expiryDateDays < 1080 && surplusDays <= 540) {
                throw new WarehouseException("WH0001", String.format(warnMsg, skuCode, "540"));
            }
            if (expiryDateDays >= 1080 && expiryDateDays < 1800 && surplusDays <= 720) {
                throw new WarehouseException("WH0001", String.format(warnMsg, skuCode, "720"));
            }
            if (expiryDateDays >= 1800 && surplusDays <= 1080) {
                throw new WarehouseException("WH0001", String.format(warnMsg, skuCode, "1080"));
            }
        } else if (WhWmsSkuBarcodeVO.CATEGORY_TYPE_FOODSTUFF.equals(categoryType)) {
            if (isImported) {
                int shelfLife = (int)Math.floor((double)expiryDateDays * 0.5);
                if (surplusDays <= shelfLife) {
                    throw new WarehouseException("WH0001", String.format(warnMsg, skuCode, "[" + shelfLife + "]50%"));
                }
            } else {
                int shelfLife = (int)Math.floor((double)expiryDateDays * 0.7);
                if (surplusDays <= shelfLife) {
                    throw new WarehouseException("WH0001", String.format(warnMsg, skuCode, "[" + shelfLife + "]70%"));
                }
            }
        }
    }

    @Override
    public Set<Long> getGlobalConfigByKey(String configKey) {
        CommGlobalConfig config = this.pegasusUtilFacade.findConfigByKey(configKey);
        if (EmptyUtil.isNotEmpty((Object)config) && EmptyUtil.isNotEmpty((String)config.getConfigValue())) {
            String[] configValues = config.getConfigValue().split(",");
            HashSet<Long> secondCategoryIds = new HashSet<Long>();
            for (String configValue : configValues) {
                secondCategoryIds.add(Long.parseLong(configValue));
            }
            return secondCategoryIds;
        }
        return null;
    }

    private void updateScmStock(WhQualityControlVO qualityControlVO, WhCommand whCommand, Integer quantity) {
        WhWarehouse whWarehouse = null;
        if (qualityControlVO.isPutawayQc() && EmptyUtil.isNotEmpty((Object)qualityControlVO.getWarehouseCommodityStatus()) && WhCommand.TYPE_ALLOT_IN.equals(qualityControlVO.getWhInType()) && qualityControlVO.getCommodityStatus().equals(qualityControlVO.getWarehouseCommodityStatus())) {
            whWarehouse = this.whInfoService.findWarehouseByCode(whCommand.getWarehouseCode());
        }
        if (whWarehouse == null) {
            whWarehouse = this.whInfoService.findDefaultInWarehouseByPhyWhCodeAndCommodityStatus(qualityControlVO.getPhysicalWarehouseCode(), qualityControlVO.getCommodityStatus());
        }
        if (!NullUtil.isNotNull(whWarehouse)) {
            throw new RuntimeException("\u4e0a\u67b6\u5931\u8d25\uff0c[" + qualityControlVO.getPhysicalWarehouseCode() + "],[" + WhWarehouseVO.getSkuStatusName(qualityControlVO.getCommodityStatus()) + "]\u627e\u4e0d\u5230\u9ed8\u8ba4\u7684\u5165\u5e93\u903b\u8f91\u4ed3");
        }
        WhInvRcd whInvRcd = new WhInvRcd();
        whInvRcd.setCommandCode(whCommand.getCode());
        whInvRcd.setWarehouseCode(whWarehouse.getCode());
        whInvRcd.setInOutType(whCommand.getInOutType());
        whInvRcd.setSkuCode(qualityControlVO.getQcSku());
        whInvRcd.setQuantity(quantity);
        whInvRcd.setSubmitUserId(qualityControlVO.getOperatorId());
        whInvRcd.setMemo(qualityControlVO.getRemark());
        whInvRcd.setSubmitTime(Calendar.getInstance().getTime());
        this.whInvService.record(whInvRcd);
    }

    @Override
    @Transactional
    public String qualityControl(WhReceiveShelvesVO vo, String targetHouseType) {
        this.updateCommandStatusById(vo.getWhCommandId(), WhCommand.STATUS_QUALITY_PROCESSING);
        List<WhQualityControlVO> qcVoList = vo.getQcList();
        String shelves = null;
        for (WhQualityControlVO qc : qcVoList) {
            String remark = qc.getRemark();
            qc.setWhInType(vo.getWhInType());
            if (EmptyUtil.isEmpty((String)qc.getReferenceCode())) {
                qc.setReferenceCode(vo.getReferenceCode());
            }
            String barcode = "";
            barcode = vo.isExistsBarcode() ? qc.getBarCode() : this.getBarCode(qc);
            WhCommand whCommand = this.whCommandMapper.selectByPrimaryKey(Long.parseLong(vo.getWhCommandId().toString()));
            vo.setWhCmdCode(whCommand.getCode());
            WhPhysicalWarehouse whPhysicalWarehouse = this.whPhysicalWarehouseMapper.findPhysicalWarehouseByCode(whCommand.getPhysicalWarehouseCode());
            WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
            cond.setHouseType(targetHouseType);
            cond.setPhysicalWarehouseCode(whPhysicalWarehouse.getCode());
            List<WhWmsHouseShelvesVO> shelvesList = this.whWmsHouseShelvesService.getHouseShelvesByCond(cond);
            if (shelvesList == null || shelvesList.size() <= 0) {
                throw new RuntimeException("\u8bf7\u5148\u8bbe\u7f6e\u76ee\u6807\u5e93\u4f4d:" + targetHouseType);
            }
            shelves = shelvesList.get(0).getCode();
            Long operatorId = Long.parseLong(vo.getOperatorId().toString());
            qc.setPhysicalWarehouseCode(whPhysicalWarehouse.getCode());
            qc.setOperatorId(operatorId);
            if (qc.getNondefectiveQuantity() != null && qc.getNondefectiveQuantity() > 0) {
                this.recordWaitPutaway(vo, barcode, qc.getNondefectiveQuantity(), WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE, whPhysicalWarehouse.getCode(), qc.getQcSku(), remark, qc);
                this.recordSkuStock(qc, barcode, qc.getNondefectiveQuantity(), WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE, whPhysicalWarehouse.getCode(), targetHouseType, shelves, whCommand, Long.parseLong(vo.getOperatorId().toString()), "", 1);
                qc.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
                qc.setRemark("");
                this.updateScmStock(qc, whCommand, qc.getNondefectiveQuantity());
            }
            if (qc.getDefectiveQuantity() != null && qc.getDefectiveQuantity() > 0) {
                this.recordWaitPutaway(vo, barcode, qc.getDefectiveQuantity(), WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED, whPhysicalWarehouse.getCode(), qc.getQcSku(), remark, qc);
                this.recordSkuStock(qc, barcode, qc.getDefectiveQuantity(), WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED, whPhysicalWarehouse.getCode(), targetHouseType, shelves, whCommand, Long.parseLong(vo.getOperatorId().toString()), remark, 1);
                qc.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
                qc.setRemark(remark);
                this.updateScmStock(qc, whCommand, qc.getDefectiveQuantity());
            }
            if (qc.getSampleQuantity() == null || qc.getSampleQuantity() <= 0) continue;
            this.recordWaitPutaway(vo, barcode, qc.getSampleQuantity(), WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE, whPhysicalWarehouse.getCode(), qc.getQcSku(), remark, qc);
            this.recordSkuStock(qc, barcode, qc.getSampleQuantity(), WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE, whPhysicalWarehouse.getCode(), targetHouseType, shelves, whCommand, Long.parseLong(vo.getOperatorId().toString()), remark, 1);
            qc.setCommodityStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE);
            qc.setRemark(remark);
            this.updateScmStock(qc, whCommand, qc.getSampleQuantity());
        }
        return shelves;
    }

    private void recordWaitPutaway(WhReceiveShelvesVO vo, String barcode, Integer amount, Integer skuStatus, String whPhysicalWarehouseCode, String skuCode, String remark, WhQualityControlVO qc) {
        WhWmsWaitPutawayVO waitputVO = new WhWmsWaitPutawayVO();
        waitputVO.setReceiptsNo(vo.getReferenceCode());
        waitputVO.setBarCode(barcode);
        waitputVO.setCreateTime(new Date());
        waitputVO.setCreateUserId(vo.getOperatorId());
        waitputVO.setReceiveAmount(amount);
        waitputVO.setSkuStatus(skuStatus);
        waitputVO.setPutawayStatus(WhWmsWaitPutaway.STATUS_WAIT_PUTAWAY);
        waitputVO.setCancelFlag(0);
        waitputVO.setCommandCode(vo.getWhCmdCode());
        waitputVO.setPhysicalWarehouseCode(whPhysicalWarehouseCode);
        waitputVO.setRemark(remark);
        waitputVO.setInOutType(vo.getWhInType());
        waitputVO.setProdDate(qc.getQcProdDate());
        waitputVO.setExpirationDate(qc.getQcExpirationDate());
        this.whWmsWaitPutawayService.create(waitputVO);
        WhCommandCond whCommandCond = new WhCommandCond();
        whCommandCond.setCode(vo.getWhCmdCode());
        List<WhCommand> whCommandList = this.whCommandMapper.findCommandByCond(whCommandCond);
        if (whCommandList != null && whCommandList.size() > 0) {
            WhCommandSkuExample example = new WhCommandSkuExample();
            WhCommandSkuExample.Criteria criteria = example.createCriteria();
            criteria.andCommandIdEqualTo(whCommandList.get(0).getId());
            criteria.andSkuCodeEqualTo(skuCode);
            List<WhCommandSku> whCommandSkuList = this.whCommandSkuMapper.selectByExample(example);
            if (whCommandSkuList != null && whCommandSkuList.size() > 0) {
                WhCommandSku whCommandSku = whCommandSkuList.get(0);
                if (WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED.equals(skuStatus) || WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING.equals(skuStatus)) {
                    int damagedQuantity = whCommandSku.getDamagedQuantity() == null ? 0 : whCommandSku.getDamagedQuantity();
                    whCommandSku.setDamagedQuantity(damagedQuantity += amount.intValue());
                    if (whCommandSku.getQuantity() == null) {
                        whCommandSku.setQuantity(0);
                    }
                } else {
                    int quantity = whCommandSku.getQuantity() == null ? 0 : whCommandSku.getQuantity();
                    whCommandSku.setQuantity(quantity += amount.intValue());
                    if (whCommandSku.getDamagedQuantity() == null) {
                        whCommandSku.setDamagedQuantity(0);
                    }
                }
                this.whCommandSkuMapper.updateByPrimaryKey(whCommandSku);
            }
        }
        if (WhCommand.TYPE_PURCHASE_IN.equals(vo.getWhInType()) && WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING.equals(waitputVO.getSkuStatus())) {
            if (CollectionUtils.isNotEmpty(qc.getReceiveShelvesDetails())) {
                for (WhWmsReceiveShelvesDetail shelvesDetail : qc.getReceiveShelvesDetails()) {
                    shelvesDetail.setQcId(waitputVO.getId());
                    shelvesDetail.setCreateUserId(vo.getCreateUserId());
                    shelvesDetail.setCreateTime(new Date());
                    shelvesDetail.setOriginType(1);
                }
                this.whWmsReceiveShelvesDetailService.batchCreate(qc.getReceiveShelvesDetails());
            }
        } else if (CollectionUtils.isNotEmpty(qc.getDefectivePicIds())) {
            CommFileRef record = new CommFileRef();
            CommFileRefExample example = new CommFileRefExample();
            record.setReferenceSecondCode(waitputVO.getId() + "");
            example.createCriteria().andIdIn(qc.getDefectivePicIds());
            PegasusUtilFacade.getInstance().updateByCond(record, example);
        }
    }

    private void recordSkuStock(WhQualityControlVO qc, String barcode, Integer amount, Integer skuStatus, String whPhysicalWarehouseCode, String houseType, String shelvesCode, WhCommand whCommand, Long operationId, String memo, Integer isUpdateScm) {
        boolean isSuccess = this.whWmsSkuStockService.updateStockByCond(amount, whPhysicalWarehouseCode, houseType, barcode, shelvesCode, qc.getQcSku(), skuStatus, whCommand.getInOutType(), whCommand.getCode(), operationId, memo, isUpdateScm);
    }

    private void recordSkuStockRecord(WhQualityControlVO qc, String barcode, Integer amount, Integer skuStatus) {
        WhWmsSkuStockRecordVO recordVO = new WhWmsSkuStockRecordVO();
        recordVO.setSkuCode(qc.getQcSku());
        recordVO.setBarCode(barcode);
        recordVO.setOldQuantity(amount);
        recordVO.setSkuStatus(skuStatus);
        this.whWmsSkuStockRecordService.create(recordVO);
    }

    public Integer parseInteger(Integer i) {
        return i == null ? 0 : i;
    }

    @Override
    @Transactional
    public boolean updateCommandStatusById(Integer id, Integer status) {
        WhCommand cmd = new WhCommand();
        cmd.setId(id.longValue());
        cmd.setCommandStatus(status);
        if (status.equals(WhCommand.STATUS_QUALITY_FINISHED) || status.equals(WhCommand.STATUS_FINISHED)) {
            cmd.setProcessTime(Calendar.getInstance().getTime());
        }
        return this.whCommandMapper.updateByPrimaryKeySelective(cmd) != 0;
    }

    @Override
    public List<WhWmsCommandInfoVO> findCommandInfoByCond(WhWmsCommandInfoCond cond) {
        List<WhWmsCommandInfoVO> commandInfoVOs = this.whCommandMapper.findCommandInfoByCond(cond);
        HashSet<Long> commandIds = new HashSet<Long>();
        if (commandInfoVOs != null && !commandInfoVOs.isEmpty()) {
            for (WhWmsCommandInfoVO commandInfoVO : commandInfoVOs) {
                commandIds.add(commandInfoVO.getId());
            }
        }
        List<WhWmsCommandSkuVO> commandSkuInfos = null;
        if (!commandIds.isEmpty()) {
            commandSkuInfos = this.whCommandMapper.findCommandSkuInfoByCond(commandIds);
        }
        if (commandInfoVOs != null && !commandInfoVOs.isEmpty()) {
            for (WhWmsCommandInfoVO commandInfoVO : commandInfoVOs) {
                List<WhWmsCommandSkuVO> comSkus = this.filterCommandSkuInfoByCommandId(commandSkuInfos, commandInfoVO.getId());
                commandInfoVO.setCommandSkuInfos(comSkus);
            }
        }
        return commandInfoVOs;
    }

    @Override
    public Pagination<WhWmsCommandInfoVO> findPaginationCommandInfoByCond(WhWmsCommandInfoCond cond) {
        Pagination page = new Pagination(cond.getCurrpage(), cond.getPagenum());
        WhPhysicalWarehouse whPhysicalWarehouse = this.whPhysicalWarehouseMapper.selectByPrimaryKey(cond.getPhysicalWarehouseId());
        if (whPhysicalWarehouse != null) {
            cond.setPhysicalWarehouseId(null);
            cond.setPhysicalWarehouseCode(whPhysicalWarehouse.getCode());
        }
        Integer count = this.whCommandMapper.countFindByCond(cond);
        List<WhWmsCommandInfoVO> commandInfoVOs = this.whCommandMapper.findNewCommandInfoByCond(cond);
        HashSet<Long> commandIds = new HashSet<Long>();
        if (commandInfoVOs != null && !commandInfoVOs.isEmpty()) {
            for (WhWmsCommandInfoVO commandInfoVO : commandInfoVOs) {
                commandIds.add(commandInfoVO.getId());
            }
        }
        List<WhWmsCommandSkuVO> commandSkuInfos = null;
        if (!commandIds.isEmpty()) {
            commandSkuInfos = this.whCommandMapper.findCommandSkuInfoByCond(commandIds);
        }
        if (commandInfoVOs != null && !commandInfoVOs.isEmpty()) {
            for (WhWmsCommandInfoVO commandInfoVO : commandInfoVOs) {
                List<WhWmsCommandSkuVO> comSkus = this.filterCommandSkuInfoByCommandId(commandSkuInfos, commandInfoVO.getId());
                commandInfoVO.setCommandSkuInfos(comSkus);
            }
        }
        page.setResultList(commandInfoVOs);
        page.setRecord(count);
        return page;
    }

    @Override
    public List<WhWmsCommandInfoVO> findNewCommandInfoByCond(WhWmsCommandInfoCond cond) {
        List<WhWmsCommandInfoVO> commandInfoVOs = this.whCommandMapper.findNewCommandInfoByCond(cond);
        HashSet<Long> commandIds = new HashSet<Long>();
        if (commandInfoVOs != null && !commandInfoVOs.isEmpty()) {
            for (WhWmsCommandInfoVO commandInfoVO : commandInfoVOs) {
                commandIds.add(commandInfoVO.getId());
            }
        }
        List<WhWmsCommandSkuVO> commandSkuInfos = null;
        if (!commandIds.isEmpty()) {
            commandSkuInfos = this.whCommandMapper.findCommandSkuInfoByCond(commandIds);
        }
        if (commandInfoVOs != null && !commandInfoVOs.isEmpty()) {
            for (WhWmsCommandInfoVO commandInfoVO : commandInfoVOs) {
                List<WhWmsCommandSkuVO> comSkus = this.filterCommandSkuInfoByCommandId(commandSkuInfos, commandInfoVO.getId());
                commandInfoVO.setCommandSkuInfos(comSkus);
            }
        }
        return commandInfoVOs;
    }

    @Override
    public Map<String, Object> countCommandInfoByCond(WhWmsCommandInfoCond cond) {
        WhPhysicalWarehouse whPhysicalWarehouse = this.whPhysicalWarehouseMapper.selectByPrimaryKey(cond.getPhysicalWarehouseId());
        if (whPhysicalWarehouse != null) {
            cond.setPhysicalWarehouseId(null);
            cond.setPhysicalWarehouseCode(whPhysicalWarehouse.getCode());
        }
        return this.whCommandMapper.countCommandInfoByCond(cond);
    }

    @Override
    public List<Map<String, Object>> findAdditionalInfosByCond(WhWmsCommandInfoCond cond) {
        return this.whCommandMapper.findAdditionalInfosByCond(cond);
    }

    private List<WhWmsCommandSkuVO> filterCommandSkuInfoByCommandId(List<WhWmsCommandSkuVO> commandSkuInfos, Long commandId) {
        ArrayList<WhWmsCommandSkuVO> tmp = new ArrayList<WhWmsCommandSkuVO>();
        if (commandSkuInfos != null && !commandSkuInfos.isEmpty()) {
            for (WhWmsCommandSkuVO comSku : commandSkuInfos) {
                if (!commandId.equals(comSku.getCommandId())) continue;
                tmp.add(comSku);
            }
        }
        return tmp;
    }

    @Override
    @Transactional
    public boolean commandAssociateExpress(String commandCode, String expressCode) {
        WhCommand commandByExpressCode = this.findCommandByExpressCode(expressCode);
        if (commandByExpressCode != null && !commandByExpressCode.getCode().equals(commandCode)) {
            throw new WarehouseException("WH0001", "\u8be5\u5feb\u9012\u5355\u53f7\u5df2\u88ab\u7ed1\u5b9a");
        }
        WhCommand cmd = this.findCommandByCode(commandCode, false);
        if (cmd != null) {
            WhCommand update = new WhCommand();
            update.setId(cmd.getId());
            update.setExpressNo(expressCode);
            return this.whCommandMapper.updateByPrimaryKeySelective(update) != 0;
        }
        throw new WarehouseException("WH0002", "\u627e\u4e0d\u5230\u4ed3\u5e93\u6307\u4ee4");
    }

    @Override
    @Transactional
    public boolean commandAssociateExpress(String commandCode, String expressCode, String operationSource) {
        WhCommand commandByExpressCode = this.findCommandByExpressCode(expressCode);
        if (commandByExpressCode != null && !commandByExpressCode.getCode().equals(commandCode)) {
            throw new WarehouseException("WH0001", "\u8be5\u5feb\u9012\u5355\u53f7\u5df2\u88ab\u7ed1\u5b9a");
        }
        WhCommand cmd = this.findCommandByCode(commandCode, false);
        if (cmd != null) {
            WhCommand update = new WhCommand();
            update.setId(cmd.getId());
            update.setExpressNo(expressCode);
            return this.whCommandMapper.updateByPrimaryKeySelective(update) != 0;
        }
        throw new WarehouseException("WH0002", "\u627e\u4e0d\u5230\u4ed3\u5e93\u6307\u4ee4");
    }

    @Override
    @Transactional
    public boolean commandAssociateExpress(WhCommandAssoExpressVO vo) {
        WhCommand commandByExpressCode;
        String expressCode = vo.getExpressCode();
        String commandCode = vo.getCommandCode();
        if (EmptyUtil.isNotEmpty((String)expressCode) && (commandByExpressCode = this.findCommandByExpressCode(expressCode)) != null && !commandByExpressCode.getCode().equals(commandCode)) {
            throw new WarehouseException("WH0001", "\u8be5\u5feb\u9012\u5355\u53f7\u5df2\u88ab\u7ed1\u5b9a");
        }
        WhCommand cmd = this.findCommandByCode(commandCode, false);
        if (cmd != null) {
            if (cmd.getCommandStatus().equals(WhCommand.STATUS_HANDOVER) || cmd.getCommandStatus().equals(WhCommand.STATUS_DELIVERYCOMPLETION)) {
                WhCommand update = new WhCommand();
                update.setId(cmd.getId());
                update.setExpressType(vo.getDeliveryType());
                if (NullUtil.isNotNull((Object)vo.getExpressCode())) {
                    update.setExpressNo(expressCode);
                }
                return this.whCommandMapper.updateByPrimaryKeySelective(update) != 0;
            }
            throw new WarehouseException("WH0001", "\u5fc5\u987b\u662f\u5f85\u4ea4\u63a5\u6216\u53d1\u8d27\u5b8c\u6210\u7684\u6307\u4ee4");
        }
        throw new WarehouseException("WH0002", "\u627e\u4e0d\u5230\u4ed3\u5e93\u6307\u4ee4");
    }

    @Override
    public WhCommand findCommandByExpressCode(String expressCode) {
        WhCommandExample example = new WhCommandExample();
        example.createCriteria().andExpressNoEqualTo(expressCode);
        List<WhCommand> whCommands = this.whCommandMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(whCommands)) {
            if (whCommands.size() > 1) {
                throw new WarehouseException("WH0001", "\u4e00\u4e2a\u5feb\u9012\u5355\u53f7\u5bf9\u5e94\u591a\u6761\u4ed3\u5e93\u6307\u4ee4");
            }
            whCommands.get(0).setWhCommandSkuList(this.findCommandSkuByCommandId(whCommands.get(0).getId()));
            return whCommands.get(0);
        }
        return null;
    }

    @Override
    public List<WhCommand> findCommandByConnectIdAndBarCode(String barCode, Long connectId) {
        return this.whCommandMapper.findCommandByConnectIdAndBarCode(barCode, connectId);
    }

    @Override
    public boolean colseCommandByReferenceCode(int inoutType, String referenceCode) {
        WhCommandExample example = new WhCommandExample();
        WhCommandExample.Criteria criteria = example.createCriteria();
        criteria.andInOutTypeEqualTo(inoutType);
        criteria.andReferenceCodeEqualTo(referenceCode);
        List<WhCommand> whCommandList = this.whCommandMapper.selectByExample(example);
        if (whCommandList != null && whCommandList.size() > 0) {
            WhCommand whCommand = whCommandList.get(0);
            whCommand.setCommandStatus(WhCommand.STATUS_CANCELED);
            return this.whCommandMapper.updateByPrimaryKey(whCommand) > 0;
        }
        return false;
    }

    @Override
    public WhWmsConnectInfoVO findWhWmsConnectInfoVOByCommandCode(String commandCode) {
        return this.whCommandMapper.findWhWmsConnectInfoVOByCommandCode(commandCode);
    }

    @Override
    @Transactional
    public void packageAssoExpressFED(PackageInfo pi) {
        this.whCommandMapper.packageAssoExpressFED(pi);
    }

    @Override
    @Transactional
    public void packageAssoExpressFEDAndCommand(PackageInfo pi) {
        this.whCommandMapper.packageAssoExpressFED(pi);
        this.whCommandMapper.packageAssoExpressCommand(pi);
        this.whCommandMapper.packageAssoExpressDispatchBill(pi);
    }

    @Override
    @Transactional
    public void packageAssoExpressExFreshAndCommand(PackageInfo pi) {
        this.whCommandMapper.packageAssoExpressExFresh(pi);
        this.whCommandMapper.packageAssoExpressCommand(pi);
    }

    @Override
    @Transactional
    public void packageAssoExpressSF(PackageInfo pi) {
        this.whCommandMapper.packageAssoExpressSF(pi);
    }

    @Override
    @Transactional
    public void packageAssoExpressSFAndPackage(PackageInfo pi) {
        this.whCommandMapper.packageAssoExpressSF(pi);
        this.whCommandMapper.packageAssoExpressCommand(pi);
        this.whCommandMapper.packageAssoExpressDispatchBill(pi);
    }

    @Override
    @Transactional
    public void packageAssoExpressZTAndPackage(ZTOrderSubmitResponse ztOrderSubmitResponse) {
        ZTOrderSubmitKeys keys = ztOrderSubmitResponse.getKeys();
        this.whCommandMapper.packageAssoExpressZT(keys);
        this.whCommandMapper.packageAssoExpressCommandZT(keys);
        this.whCommandMapper.packageAssoExpressDispatchBillZT(keys);
    }

    @Override
    public void packageAssoExpressTmsAndCommand(PackageInfo pi) {
        this.whCommandMapper.packageAssoTms(pi);
        this.whCommandMapper.packageAssoExpressCommand(pi);
        this.whCommandMapper.packageAssoExpressDispatchBill(pi);
    }

    @Override
    @Transactional
    public void updateCommand(WhCommand whCommand) {
        this.whCommandMapper.updateByPrimaryKey(whCommand);
    }

    @Override
    @Transactional
    public WhCommand updateCommandV2(WhCommand whCommand) {
        SWhCommandVO sWhCmd = this.sWhCommandService.updateWhCommandByKey((SWhCommandVO)BeanUtil.buildFrom((Object)whCommand, SWhCommandVO.class));
        return this.convertDtoToCommand(sWhCmd);
    }

    @Override
    @Transactional
    public void batchUpdateCommand(WhCommand whCommand, WhCommandExample example) {
        this.whCommandMapper.updateByExampleSelective(whCommand, example);
    }

    @Override
    public void commandWithPackageExpress() {
        this.whCommandMapper.commandWithPackageExpress();
    }

    @Override
    @Transactional
    public void recordCommandShortSku(String commandCode, String skuCode, int shortAmount) {
        WhWmsCommandShortRecordExample example = new WhWmsCommandShortRecordExample();
        WhWmsCommandShortRecordExample.Criteria criteria = example.createCriteria();
        criteria.andCommandCodeEqualTo(commandCode);
        criteria.andSkuCodeEqualTo(skuCode);
        List<WhWmsCommandShortRecord> records = this.whWmsCommandShortRecordMapper.selectByExample(example);
        if (records != null && records.size() > 0) {
            WhWmsCommandShortRecord record = records.get(0);
            record.setShortAmount(shortAmount);
            record.setSubmitTime(Calendar.getInstance().getTime());
            this.whWmsCommandShortRecordMapper.updateByPrimaryKey(record);
        } else {
            WhWmsCommandShortRecord record = new WhWmsCommandShortRecord();
            record.setCommandCode(commandCode);
            record.setSubmitTime(Calendar.getInstance().getTime());
            record.setSkuCode(skuCode);
            record.setShortAmount(shortAmount);
            this.whWmsCommandShortRecordMapper.insert(record);
        }
    }

    @Override
    @Transactional
    public boolean recordCommandShortSku(List<WhWmsCommandShortRecord> shortRecordList) {
        if (EmptyUtil.isNotEmpty(shortRecordList)) {
            HashSet<String> commandCodes = new HashSet<String>();
            for (WhWmsCommandShortRecord shortRecord : shortRecordList) {
                commandCodes.add(shortRecord.getCommandCode());
            }
            WhWmsCommandShortRecordExample example = new WhWmsCommandShortRecordExample();
            WhWmsCommandShortRecordExample.Criteria criteria = example.createCriteria();
            criteria.andCommandCodeIn((List)Arrays.asList(commandCodes.toArray(new String[commandCodes.size()])));
            this.whWmsCommandShortRecordMapper.deleteByExample(example);
            this.whWmsCommandShortRecordMapper.batchCreate(shortRecordList);
        }
        return true;
    }

    @Override
    public List<WhWmsCommandShortRecord> findWhWmsCommandShortRecordByCommandCode(String commandCode) {
        WhWmsCommandShortRecordExample example = new WhWmsCommandShortRecordExample();
        example.createCriteria().andCommandCodeEqualTo(commandCode);
        return this.whWmsCommandShortRecordMapper.selectByExample(example);
    }

    @Override
    public String synCommodityStocks(Long numIid, String outerId, long quantity, String channelCode, int syncType, String referenceCode, Long operatorId) throws Exception {
        int tmallQuantity;
        final TmallStockLog tmallStockLog = new TmallStockLog();
        tmallStockLog.setGoodsId(numIid);
        tmallStockLog.setQuantity((int)quantity);
        tmallStockLog.setSkuCode(outerId);
        tmallStockLog.setReferenceCode(referenceCode);
        tmallStockLog.setSyncType(syncType);
        tmallStockLog.setCreateTime(new Date());
        tmallStockLog.setChannelCode(channelCode);
        if (numIid == null) {
            tmallStockLog.setRemark("\u5929\u732b\u540e\u53f0\u5546\u54c1\u5f02\u5e38\u3010\u4e0d\u5b58\u5728\u5546\u54c1\u6216\u8005\u975e\u6d3b\u52a8\u94fe\u63a5\u3011");
            tmallStockLog.setSyncStatus((short)0);
            if (syncType == 1) {
                tmallStockLog.setDealStatus((short)1);
            }
            this.myScheduler.execute(new Runnable(){

                @Override
                public void run() {
                    WhCommandServiceImpl.this.tmallStockLogMapper.insertSelective(tmallStockLog);
                }
            });
            throw new WarehouseException("WH0101", "SKU\u3010" + outerId + "\u3011\u5929\u732b\u540e\u53f0\u5546\u54c1\u5f02\u5e38\u3010\u4e0d\u5b58\u5728\u5546\u54c1\u6216\u8005\u975e\u6d3b\u52a8\u94fe\u63a5\u3011");
        }
        if (quantity < 0L && (long)(tmallQuantity = this.pegasusUtilFacade.getSkuQuantity(outerId, channelCode, numIid)) + quantity < 0L) {
            tmallStockLog.setRemark("\u5929\u732b\u540e\u53f0\u5e93\u5b58\u4e0d\u8db3");
            tmallStockLog.setSyncStatus((short)0);
            if (syncType == 1) {
                tmallStockLog.setDealStatus((short)1);
            }
            this.myScheduler.execute(new Runnable(){

                @Override
                public void run() {
                    WhCommandServiceImpl.this.tmallStockLogMapper.insertSelective(tmallStockLog);
                }
            });
            throw new WarehouseException("WH0101", "SKU\u3010" + outerId + "\u3011\u5929\u732b\u540e\u53f0\u5e93\u5b58\u4e0d\u8db3,\u5f53\u524d\u5e93\u5b58" + tmallQuantity);
        }
        if (quantity != 0L && numIid != null) {
            ItemQuantityUpdateResponse rsp = this.pegasusUtilFacade.synCommodityStocks(channelCode, numIid, outerId, quantity);
            if (EmptyUtil.isNotEmpty((String)rsp.getErrorCode())) {
                throw new WarehouseException(rsp.getErrorCode(), rsp.getSubMsg());
            }
            this.log.info("\u5929\u732b\u5e93\u5b58\u540c\u6b65:\u5546\u54c1\u6570\u5b57ID(" + numIid + ") SKU(" + outerId + ") \u53d8\u66f4\u6570\u91cf" + quantity);
            JSONObject error = JSONObject.parseObject((String)rsp.getBody()).getJSONObject("error_response");
            if (JSONObject.parseObject((String)rsp.getBody()).getString("error_response") != null) {
                tmallStockLog.setRemark(error.getString("sub_msg"));
                tmallStockLog.setSyncStatus((short)0);
                if (syncType == 1) {
                    tmallStockLog.setDealStatus((short)1);
                }
                this.myScheduler.execute(new Runnable(){

                    @Override
                    public void run() {
                        WhCommandServiceImpl.this.tmallStockLogMapper.insertSelective(tmallStockLog);
                    }
                });
                String errorMsg = error.getString("sub_msg");
                if ("\u4fdd\u5b58\u5e93\u5b58\u4fe1\u606f\u5931\u8d25, \u5b9e\u9645\u5e93\u5b58\u6570\u4e0d\u80fd\u5c0f\u4e8e\u5df2\u5206\u914d\u7684\u6e20\u9053\u5e93\u5b58\u6570".equals(errorMsg)) {
                    errorMsg = "\u5929\u732b\u540e\u53f0\u5546\u54c1\u6b63\u5728\u53c2\u52a0\u6d3b\u52a8\u5e93\u5b58\u9501\u5b9a\uff0c\u4e0d\u80fd\u8c03\u62e8\uff01";
                }
                throw new WarehouseException("WH0101", "SKU\u3010" + outerId + "\u3011" + errorMsg);
            }
            tmallStockLog.setRemark("\u540c\u6b65\u6210\u529f");
            tmallStockLog.setSyncStatus((short)1);
            tmallStockLog.setDealStatus((short)1);
            this.myScheduler.execute(new Runnable(){

                @Override
                public void run() {
                    WhCommandServiceImpl.this.tmallStockLogMapper.insertSelective(tmallStockLog);
                }
            });
        }
        return "\u6210\u529f";
    }

    @Override
    public Map<String, JdStockSyncResult> syncJdSkuStock(String warehouseCode, Map<String, Integer> skuQuantityMap, Integer syncType, List<String> referenceCodes, Long operatorId) {
        Map<String, JdStockSyncResult> resultMap = this.syncJdSkuStock(warehouseCode, skuQuantityMap, syncType, referenceCodes, operatorId, false);
        return resultMap;
    }

    @Override
    public Map<String, JdStockSyncResult> syncJdSkuStock(String warehouseCode, Map<String, Integer> skuQuantityMap, Integer syncType, List<String> referenceCodes, Long operatorId, boolean failThenThrowException) {
        if (!failThenThrowException) {
            return this.syncJdSkuStockBatch(warehouseCode, skuQuantityMap, syncType, referenceCodes, operatorId);
        }
        HashMap<String, JdStockSyncResult> resultMap = new HashMap<String, JdStockSyncResult>();
        for (Map.Entry<String, Integer> entry : skuQuantityMap.entrySet()) {
            Map<String, JdStockSyncResult> tmpResultMap = this.syncJdSkuStockBatch(warehouseCode, Collections.singletonMap(entry.getKey(), entry.getValue()), syncType, referenceCodes, operatorId);
            resultMap.putAll(tmpResultMap);
            for (JdStockSyncResult syncResult : tmpResultMap.values()) {
                if (!NullUtil.isNull((Object)syncResult.getJdSkuId()) && syncResult.isSuccess()) continue;
                throw new WarehouseException("WH0001", String.format("[%s]\u540c\u6b65\u5931\u8d25:%s", entry.getKey(), syncResult.getErrorMsg()));
            }
        }
        return resultMap;
    }

    private Map<String, JdStockSyncResult> syncJdSkuStockBatch(String warehouseCode, Map<String, Integer> skuQuantityMap, Integer syncType, List<String> referenceCodes, Long operatorId) {
        Map resultMap = this.pegasusUtilFacade.syncJdSkuStock(warehouseCode, skuQuantityMap);
        int refSize = referenceCodes == null ? 0 : referenceCodes.size();
        int refIndex = 0;
        String publicReferenceCode = null;
        if (referenceCodes.size() == 1) {
            publicReferenceCode = referenceCodes.get(0);
        }
        for (JdStockSyncResult syncResult : resultMap.values()) {
            final TmallStockLog syncStockLog = new TmallStockLog();
            syncStockLog.setGoodsId(syncResult.getJdSkuId());
            syncStockLog.setQuantity(syncResult.getQuantity());
            syncStockLog.setSkuCode(syncResult.getSkuCode());
            if (publicReferenceCode != null) {
                syncStockLog.setReferenceCode(publicReferenceCode);
            } else {
                if (refIndex < refSize) {
                    syncStockLog.setReferenceCode(referenceCodes.get(refIndex));
                } else {
                    syncStockLog.setReferenceCode(referenceCodes.get(refSize - 1));
                }
                ++refIndex;
            }
            syncStockLog.setSyncType(syncType);
            syncStockLog.setCreateTime(DateUtil.getNow());
            syncStockLog.setChannelCode(syncResult.getChannelCode());
            syncStockLog.setRemark(syncResult.getErrorMsg());
            syncStockLog.setCreateOperatorId(operatorId);
            if (NullUtil.isNull((Object)syncResult.getJdSkuId()) || !syncResult.isSuccess()) {
                syncStockLog.setSyncStatus((short)0);
                if (syncType == 1) {
                    syncStockLog.setDealStatus((short)1);
                }
            } else {
                syncStockLog.setRemark("\u540c\u6b65\u6210\u529f");
                syncStockLog.setSyncStatus((short)1);
                syncStockLog.setDealStatus((short)1);
            }
            this.myScheduler.execute(new Runnable(){

                @Override
                public void run() {
                    WhCommandServiceImpl.this.tmallStockLogMapper.insertSelective(syncStockLog);
                }
            });
        }
        return resultMap;
    }

    @Override
    public TmallStockLog synCommodityStocksAllot(Long numIid, String outerId, long quantity, String channelCode, int syncType, String referenceCode) throws Exception {
        int tmallQuantity;
        TmallStockLog tmallStockLog = new TmallStockLog();
        tmallStockLog.setGoodsId(numIid);
        tmallStockLog.setQuantity((int)quantity);
        tmallStockLog.setSkuCode(outerId);
        tmallStockLog.setReferenceCode(referenceCode);
        tmallStockLog.setSyncType(syncType);
        tmallStockLog.setCreateTime(new Date());
        tmallStockLog.setChannelCode(channelCode);
        if (numIid == null) {
            tmallStockLog.setRemark("\u5929\u732b\u540e\u53f0\u5546\u54c1\u5f02\u5e38\u3010\u4e0d\u5b58\u5728\u5546\u54c1\u6216\u8005\u975e\u6d3b\u52a8\u94fe\u63a5\u3011");
            tmallStockLog.setSyncStatus((short)0);
            if (syncType == 1) {
                tmallStockLog.setDealStatus((short)1);
            }
            this.log.error("SKU\u3010" + outerId + "\u3011\u5929\u732b\u540e\u53f0\u5546\u54c1\u5f02\u5e38\u3010\u4e0d\u5b58\u5728\u5546\u54c1\u6216\u8005\u975e\u6d3b\u52a8\u94fe\u63a5\u3011");
            return tmallStockLog;
        }
        if (quantity < 0L && (long)(tmallQuantity = this.pegasusUtilFacade.getSkuQuantity(outerId, channelCode, numIid)) + quantity < 0L) {
            tmallStockLog.setRemark("\u5929\u732b\u540e\u53f0\u5e93\u5b58\u4e0d\u8db3");
            tmallStockLog.setSyncStatus((short)0);
            if (syncType == 1) {
                tmallStockLog.setDealStatus((short)1);
            }
            this.log.error("SKU\u3010" + outerId + "\u3011\u5929\u732b\u540e\u53f0\u5e93\u5b58\u4e0d\u8db3,\u5f53\u524d\u5e93\u5b58" + tmallQuantity);
            return tmallStockLog;
        }
        if (quantity != 0L && numIid != null) {
            ItemQuantityUpdateResponse rsp = this.pegasusUtilFacade.synCommodityStocks(channelCode, numIid, outerId, quantity);
            if (EmptyUtil.isNotEmpty((String)rsp.getErrorCode())) {
                tmallStockLog.setRemark("[" + rsp.getErrorCode() + "]" + rsp.getMsg());
                tmallStockLog.setSyncStatus((short)0);
                if (syncType == 1) {
                    tmallStockLog.setDealStatus((short)1);
                }
                return tmallStockLog;
            }
            this.log.info("\u5929\u732b\u5e93\u5b58\u540c\u6b65:\u5546\u54c1\u6570\u5b57ID(" + numIid + ") SKU(" + outerId + ") \u53d8\u66f4\u6570\u91cf" + quantity);
            JSONObject error = JSONObject.parseObject((String)rsp.getBody()).getJSONObject("error_response");
            if (JSONObject.parseObject((String)rsp.getBody()).getString("error_response") != null) {
                String errorMsg;
                tmallStockLog.setRemark(error.getString("sub_msg"));
                tmallStockLog.setSyncStatus((short)0);
                if (syncType == 1) {
                    tmallStockLog.setDealStatus((short)1);
                }
                if ("\u4fdd\u5b58\u5e93\u5b58\u4fe1\u606f\u5931\u8d25, \u5b9e\u9645\u5e93\u5b58\u6570\u4e0d\u80fd\u5c0f\u4e8e\u5df2\u5206\u914d\u7684\u6e20\u9053\u5e93\u5b58\u6570".equals(errorMsg = error.getString("sub_msg"))) {
                    errorMsg = "\u5929\u732b\u540e\u53f0\u5546\u54c1\u6b63\u5728\u53c2\u52a0\u6d3b\u52a8\u5e93\u5b58\u9501\u5b9a\uff0c\u4e0d\u80fd\u8c03\u62e8\uff01";
                }
                this.log.error("SKU\u3010" + outerId + "\u3011" + errorMsg);
                return tmallStockLog;
            }
            tmallStockLog.setRemark("\u540c\u6b65\u6210\u529f");
            tmallStockLog.setSyncStatus((short)1);
            tmallStockLog.setDealStatus((short)1);
        }
        return tmallStockLog;
    }

    @Override
    @Transactional
    public void insertWhCommandOutFinish(WhCommandOutFinish whCommandOutFinish) {
        this.whCommandOutFinishMapper.insert(whCommandOutFinish);
    }

    @Override
    public List<WhCommandOutFinish> findWhCommandOutFinishNoFinish() {
        WhCommandOutFinishExample example = new WhCommandOutFinishExample();
        example.createCriteria().andStatusEqualTo(0);
        return this.whCommandOutFinishMapper.selectByExample(example);
    }

    @Override
    public List<WhCommandCountVO> getCommandOutCountByCond(WhCommandCond cond) {
        if (NullUtil.isNotNull((Object)cond.getPhysicalWarehouseId())) {
            WhPhysicalWarehouse phyWh = this.whInfoService.findPhysicalWarehouseById(cond.getPhysicalWarehouseId());
            if (NullUtil.isNull((Object)phyWh)) {
                return Collections.emptyList();
            }
            cond.setPhysicalWarehouseCode(phyWh.getCode());
        }
        if (EmptyUtil.isEmpty((String)cond.getGroupBy())) {
            return this.whCommandMapper.getCommandOutCountByCond(cond);
        }
        if (WhCommand.TYPE_ALLOT_OUT.toString().equals(cond.getGroupBy())) {
            return this.whCommandMapper.getAltOutCommandCountByCond(cond);
        }
        if (WhCommand.TYPE_SALES_OUT.toString().equals(cond.getGroupBy())) {
            return this.whCommandMapper.getSaleOutCommandCountByCond(cond);
        }
        if (WhCommand.TYPE_CHANGE_OUT.toString().equals(cond.getGroupBy())) {
            return this.whCommandMapper.getChangeOutCommandCountByCond(cond);
        }
        if (WhCommand.TYPE_PURCHASE_RETURN_OUT.toString().equals(cond.getGroupBy())) {
            return this.whCommandMapper.getPurchaseRtnOutCommandCountByCond(cond);
        }
        return new ArrayList<WhCommandCountVO>();
    }

    @Override
    public List<WhPackageInfoVO> findCHN2053PackageInfo() {
        return this.whCommandMapper.findCHN2053PackageInfo();
    }

    @Override
    public List<WhWmsSubmitHandRecord> autoProcessSubmitHandData() {
        WhWmsSubmitHandRecordExample example = new WhWmsSubmitHandRecordExample();
        example.createCriteria().andStatusEqualTo(0);
        example.setOrderByClause("SKU_CODE");
        return this.whWmsSubmitHandRecordMapper.selectByExample(example);
    }

    @Override
    @Transactional
    public void processSubmitData(List<WhWmsSubmitHandRecord> submitList) {
        HashMap<String, WhWmsSubmitHandRecord> map = new HashMap<String, WhWmsSubmitHandRecord>();
        for (WhWmsSubmitHandRecord record : submitList) {
            WhWmsSkuStockRecord whWmsSkuStockRecord = new WhWmsSkuStockRecord();
            whWmsSkuStockRecord.setPhysicalWarehouseCode(record.getPhysicalWarehouseCode());
            whWmsSkuStockRecord.setHouseType(record.getHouseType());
            whWmsSkuStockRecord.setSkuCode(record.getSkuCode());
            whWmsSkuStockRecord.setBarCode(record.getBarCode());
            whWmsSkuStockRecord.setCreateTime(Calendar.getInstance().getTime());
            whWmsSkuStockRecord.setCreateUserId(record.getSubmitUserId() == null ? 1L : Long.parseLong(record.getSubmitUserId().toString()));
            whWmsSkuStockRecord.setInOutType(record.getInoutType());
            whWmsSkuStockRecord.setQuantity(record.getAmount());
            whWmsSkuStockRecord.setReceiptNo(record.getReceiptNo());
            whWmsSkuStockRecord.setSkuStatus(record.getSkuStatus());
            whWmsSkuStockRecord.setShelvesCode(record.getShelvesCode());
            whWmsSkuStockRecord.setMemo(record.getMemo());
            whWmsSkuStockRecord.setIsUpdateScm(record.getIsUpdateScm());
            whWmsSkuStockRecord.setOldQuantity(0);
            this.whWmsSkuStockRecordMapper.insert(whWmsSkuStockRecord);
            record.setStatus(1);
            this.whWmsSubmitHandRecordMapper.updateByPrimaryKey(record);
            StringBuffer key = new StringBuffer();
            key.append(record.getPhysicalWarehouseCode());
            key.append("_");
            key.append(record.getHouseType());
            key.append("_");
            key.append(record.getBarCode());
            key.append("_");
            key.append(record.getShelvesCode());
            key.append("_");
            key.append(record.getSkuCode());
            key.append("_");
            key.append(record.getSkuStatus());
            WhWmsSubmitHandRecord value = (WhWmsSubmitHandRecord)map.get(key.toString());
            if (value == null) {
                map.put(key.toString(), record);
                continue;
            }
            value.setAmount(value.getAmount() + record.getAmount());
        }
        for (String key : map.keySet()) {
            WhWmsSubmitHandRecord value = (WhWmsSubmitHandRecord)map.get(key);
            WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
            cond.setPhysicalWarehouseCode(value.getPhysicalWarehouseCode());
            cond.setHouseType(value.getHouseType());
            cond.setBarCode(value.getBarCode());
            cond.setShelvesCode(value.getShelvesCode());
            cond.setSkuCode(value.getSkuCode());
            cond.setSkuStatus(value.getSkuStatus());
            List<WhWmsSkuStock> list = this.whWmsSkuStockMapper.getByCond(cond);
            WhWmsSkuStock sk = null;
            if (null != list && list.size() == 1) {
                sk = list.get(0);
                if (sk.getAmount() + value.getAmount() < 0) {
                    throw new WarehouseException("WH0001", "[" + value.getShelvesCode() + "][" + value.getBarCode() + "][" + WhCommand.getSkuStatusName(value.getSkuStatus()) + "][" + sk.getAmount() + "<" + -value.getAmount().intValue() + "]\u5e93\u5b58\u4e0d\u8db3\uff0c\u4e0d\u53ef\u4ee5\u51fa\u5e93");
                }
                int i = 0;
                boolean isTurn = true;
                do {
                    int updateCount = this.whWmsSkuStockMapper.updateStockByPrimaryKey(value.getAmount(), sk.getVersion(), sk.getId());
                    if (i >= 3 || updateCount > 0) {
                        isTurn = false;
                    } else {
                        List<WhWmsSkuStock> newList = this.whWmsSkuStockMapper.getByCond(cond);
                        if (newList != null && newList.size() > 0) {
                            sk = newList.get(0);
                        }
                    }
                    ++i;
                } while (isTurn);
                if (i <= 3) continue;
                throw new WarehouseException("WH0001", "[" + value.getShelvesCode() + "][" + value.getBarCode() + "][" + WhCommand.getSkuStatusName(value.getSkuStatus()) + "][" + value.getAmount() + "]\u5e93\u5b58\u4fee\u6539\u5931\u8d25");
            }
            if (value.getAmount() < 0) {
                throw new WarehouseException("WH0001", "[" + value.getShelvesCode() + "][" + value.getBarCode() + "][" + WhCommand.getSkuStatusName(value.getSkuStatus()) + "][" + -value.getAmount().intValue() + "]\u8fd8\u6ca1\u6709\u5e93\u5b58\u8bb0\u5f55\u4e0d\u53ef\u4ee5\u51fa\u5e93");
            }
            WhWmsSkuStockVO stockVO = new WhWmsSkuStockVO();
            stockVO.setBarCode(value.getBarCode());
            stockVO.setSkuCode(value.getSkuCode());
            stockVO.setVersion(1);
            stockVO.setAmount(value.getAmount());
            stockVO.setSkuStatus(value.getSkuStatus());
            stockVO.setPhysicalWarehouseCode(value.getPhysicalWarehouseCode());
            stockVO.setHouseType(value.getHouseType());
            stockVO.setShelvesCode(value.getShelvesCode());
            this.whWmsSkuStockMapper.insert(stockVO);
        }
    }

    @Override
    public Boolean checkTmallSku(Long numIid, String outerId, long quantity, String sessionKey) throws Exception {
        if (numIid == null) {
            throw new WarehouseException("WH0101", "SKU\u3010" + outerId + "\u3011\u5929\u732b\u540e\u53f0\u5546\u54c1\u5f02\u5e38\u3010\u4e0d\u5b58\u5728\u5546\u54c1\u6216\u8005\u975e\u6d3b\u52a8\u94fe\u63a5\u3011");
        }
        if (quantity < 0L && (long)this.pegasusUtilFacade.getSkuQuantity(outerId, sessionKey, numIid) + quantity < 0L) {
            throw new WarehouseException("WH0101", "SKU\u3010" + outerId + "\u3011\u5929\u732b\u540e\u53f0\u5e93\u5b58\u4e0d\u8db3\uff0c\u65e0\u6cd5\u8c03\u51fa");
        }
        return true;
    }

    @Override
    public String findSalesOrderAddressByCond(String cond) {
        return this.whCommandMapper.findSalesOrderAddressByCond(cond);
    }

    @Override
    public Integer findSalesOrderTypeByCond(String cond) {
        return this.whCommandMapper.findSalesOrderTypeByCond(cond);
    }

    @Override
    public boolean cancelAllotRcdCommandByTypeAndReferenceCode(Integer type, String referenceCode) {
        WhCommand whCommand = this.findCommandByTypeAndReferenceCode(WhCommand.TYPE_MOVE_OUT, referenceCode, true);
        if (whCommand != null && whCommand.getWhCommandSkuList() != null) {
            ArrayList<WhReleaseOccupationVO> whReleaseOccupationVOList = new ArrayList<WhReleaseOccupationVO>();
            for (WhCommandSku whCommandSku : whCommand.getWhCommandSkuList()) {
                WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
                whReleaseOccupationVO.setReferenceCode(whCommandSku.getCode());
                whReleaseOccupationVO.setOccupyType(WhCommand.TYPE_MOVE_OUT);
            }
            this.cancelCommand(whCommand);
            this.whInvService.releaseOccupation(whReleaseOccupationVOList);
        }
        return true;
    }

    @Override
    public Integer autoCloseCommandInEndMonth() {
        return this.whCommandMapper.autoCloseCommandInEndMonth();
    }

    @Override
    public void updateCommandSku(WhCommandSku whCommandSku) {
        this.whCommandSkuMapper.updateByPrimaryKeySelective(whCommandSku);
    }

    @Override
    public List<WhCommandSku> findDiffCommandSkuByCommandReferenceCodes(List<String> allotCodeList) {
        return this.whCommandSkuMapper.findDiffCommandSkuByCommandReferenceCodes(allotCodeList);
    }

    @Override
    public Map<String, String> findReferenceCodesByCommdCodes(List<String> commdCodeList) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<Map> referenceCodeMaps = null;
        if (CollectionUtils.isNotEmpty(commdCodeList)) {
            referenceCodeMaps = this.whCommandMapper.selectReferenceCodesByCommdCodes(commdCodeList);
        }
        if (EmptyUtil.isNotEmpty(referenceCodeMaps)) {
            for (Map referenceCodeMap : referenceCodeMaps) {
                String referenceCode = referenceCodeMap.get("REFERENCE_CODE").toString();
                if (referenceCodeMap.get("IN_OUT_TYPE").toString().equals("15") || referenceCodeMap.get("IN_OUT_TYPE").toString().equals("27")) {
                    WhWmsPrdcJobTaskVO whWmsPrdcJobTaskVO;
                    String taskCode = null;
                    if (referenceCodeMap.get("REFERENCE_CODE").toString().indexOf("TKD") >= 0) {
                        WhWmsPrdcJobTaskDetail whWmsPrdcJobTaskDetail = this.whWmsPrdcJobTaskDetailService.getTaskDetailBycode(referenceCodeMap.get("REFERENCE_CODE").toString());
                        if (whWmsPrdcJobTaskDetail != null) {
                            taskCode = whWmsPrdcJobTaskDetail.getTaskCode();
                        }
                    } else if (referenceCodeMap.get("REFERENCE_CODE").toString().indexOf("TK") >= 0) {
                        taskCode = referenceCodeMap.get("REFERENCE_CODE").toString();
                    }
                    if (taskCode != null && !taskCode.equals("") && (whWmsPrdcJobTaskVO = this.whWmsPrdcJobTaskService.getPrdcJobTaskByTaskCode(taskCode)) != null) {
                        referenceCode = whWmsPrdcJobTaskVO.getPrdcJobCode();
                    }
                }
                map.put(referenceCodeMap.get("CODE").toString(), referenceCode);
            }
        }
        return map;
    }

    @Override
    public int updatePlanedDyDateByReCodes(List<WhCommand> whCommandList) {
        return this.whCommandMapper.updatePlanedDyDateByReCodes(whCommandList);
    }

    @Override
    @Transactional
    public String createAllotRcdAndFinishCommand(WhAllotRcd whAllotRcd, Integer type, boolean fetch) throws Exception {
        String allotCode = this.whAllotService.createAllotRcd(whAllotRcd);
        WhCommand whCommand = this.findCommandByTypeAndReferenceCode(type, allotCode, fetch);
        this.finishCommand(whCommand);
        return allotCode;
    }
}

