/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsMoveStockCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhCommandOutCancelMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandOutCancel;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandOutCancelExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouse;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandOutCancelService;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandCheckService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandConnectService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectDistributionService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectPickSkuService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWaitPutawayService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandCheckPara;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandConnectVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectDistributionVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectPickSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveStockVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Service(value="whCommandOutCancelService")
public class WhCommandOutCancelServiceImpl
implements WhCommandOutCancelService {
    @Autowired
    private WhCommandOutCancelMapper whCommandOutCancelMapper;
    @Autowired
    private WhWmsConnectInfoService whWmsConnectInfoService;
    @Autowired
    private WhWmsCommandCheckService whWmsCommandCheckService;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    WhInfoService whInfoService;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsWaitPutawayService whWmsWaitPutawayService;
    @Autowired
    private WhWmsConnectDistributionService whWmsConnectDistributionService;
    @Autowired
    private WhWmsCommandConnectService whWmsCommandConnectService;
    @Autowired
    private WhWmsConnectPickSkuService whWmsConnectPickSkuService;
    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;

    @Override
    public List<WhCommandOutCancel> findUnHandleCommand() {
        WhCommandOutCancelExample example = new WhCommandOutCancelExample();
        example.createCriteria().andStatusEqualTo(WhCommandOutCancel.STATUS_PENDING);
        List<WhCommandOutCancel> list = this.whCommandOutCancelMapper.selectByExample(example);
        return list;
    }

    @Override
    @Transactional
    public boolean insert(WhCommandOutCancel whCommandOutCancel) {
        this.whCommandOutCancelMapper.insert(whCommandOutCancel);
        return true;
    }

    @Override
    @Transactional
    public String cancelMakeCommandOnCheckOut(WhWmsMoveStockVO move, WhCommand command) {
        String commandCode = command.getCode();
        WhWmsCommandConnectVO commandConnectVO = this.whWmsCommandConnectService.findNotCanceledByWhCommandCode(commandCode);
        WhWmsConnectInfoVO connect = this.whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
        if (NullUtil.isNull((Object)connect)) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u4e0d\u5b58\u5728");
        }
        if ("bulk_order".equals(connect.getConnectType())) {
            this.whWmsConnectPickSkuService.deleteConnectBox(connect.getId());
        } else {
            this.whWmsConnectDistributionService.deleteConnectDistribution(connect.getId(), commandCode);
        }
        this.whCommandService.cancelCommandforShortage(commandCode);
        if (!EmptyUtil.isNotEmpty((Object)command.isNoCreateMoveStock()) || !command.isNoCreateMoveStock()) {
            this.whWmsMoveStockService.newMoveStock(move);
            return move.getCode();
        }
        return null;
    }

    @Override
    @Transactional
    public String commandCheckOutByParam(WhWmsCommandCheckPara whWmsCommandCheckPara) {
        WhCommand command = whWmsCommandCheckPara.getCancelCommand();
        WhWmsMoveStockVO move = whWmsCommandCheckPara.getCancelMoveStockVO();
        String commandCode = command.getCode();
        WhWmsCommandConnectVO commandConnectVO = this.whWmsCommandConnectService.findNotCanceledByWhCommandCode(commandCode);
        WhWmsConnectInfoVO connect = this.whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
        if (NullUtil.isNull((Object)connect)) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u4e0d\u5b58\u5728");
        }
        this.whWmsConnectDistributionService.deleteConnectDistribution(connect.getId(), commandCode);
        this.whCommandService.commandStatusToShortages(commandCode);
        if (!EmptyUtil.isNotEmpty((Object)command.isNoCreateMoveStock()) || !command.isNoCreateMoveStock()) {
            this.whWmsMoveStockService.newMoveStock(move);
            return move.getCode();
        }
        return null;
    }

    @Override
    @Transactional
    public boolean cancelMakeCommandHandover(WhCommand command, Long operatorId) {
        if (NullUtil.isNull((Object)command) || EmptyUtil.isEmpty(command.getWhCommandSkuList())) {
            throw new WarehouseException("WH0002", "\u53c2\u6570\u5f02\u5e38");
        }
        String commandCode = command.getCode();
        WhWmsCommandConnectVO commandConnectVO = this.whWmsCommandConnectService.findNotCanceledByWhCommandCode(commandCode);
        WhWmsConnectInfoVO connect = this.whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
        if (NullUtil.isNull((Object)connect)) {
            throw new WarehouseException("WH0001", "\u6ce2\u6b21\u4e0d\u5b58\u5728");
        }
        WhWmsMoveStockCond moveCond = new WhWmsMoveStockCond();
        String dispatchBillCode = command.getReferenceCode().split("_")[0];
        ArrayList<String> codes = new ArrayList<String>();
        codes.add(dispatchBillCode);
        moveCond.setReferenceCodeList(codes);
        Pagination<WhWmsMoveStockVO> list = this.whWmsMoveStockService.getMoveStockByCond(moveCond);
        if (EmptyUtil.isEmpty(list)) {
            WhPhysicalWarehouse physicalWarehouse = this.whInfoService.findPhysicalWarehouseByCode(command.getPhysicalWarehouseCode());
            WhWmsHouseShelvesCond shelvesCond = new WhWmsHouseShelvesCond();
            shelvesCond.setPhysicalWarehouseCode(physicalWarehouse.getCode());
            shelvesCond.setHouseType("HOUSE_TYPE_HANDOVER");
            List<WhWmsHouseShelvesVO> shelvesList = this.whWmsHouseShelvesService.getHouseShelvesByCond(shelvesCond);
            if (EmptyUtil.isEmpty(shelvesList)) {
                throw new WarehouseException("WH0001", "\u65e0\u53ef\u7528\u5e93\u4f4d");
            }
            WhWmsHouseShelvesVO oriShelves = shelvesList.get(0);
            String tarShelvesCode = PegasusUtilFacade.getInstance().findCancelStockToShelvesCode(physicalWarehouse.getCode(), connect.getSkuStatus());
            if (EmptyUtil.isEmpty((String)tarShelvesCode)) {
                throw new WarehouseException("WH0001", String.format("[%s][%s]\u5305\u88f9\u53d6\u6d88\u79fb\u5e93\u5e93\u4f4d\u672a\u8bbe\u7f6e", physicalWarehouse.getCode(), connect.getSkuStatus()));
            }
            WhWmsHouseShelvesVO tarShelves = this.whWmsHouseShelvesService.getHouseShelvesByCode(tarShelvesCode);
            if (NullUtil.isNull((Object)tarShelves)) {
                throw new WarehouseException("WH0001", String.format("[%s]\u5305\u88f9\u53d6\u6d88\u79fb\u5e93\u5e93\u4f4d[%s]\u4e0d\u5b58\u5728", physicalWarehouse.getCode(), tarShelvesCode));
            }
            List<WhWmsMoveSkuVO> moveSkuVOList = this.buildMoveStockSkuFormDistribution(command, oriShelves, tarShelves);
            if (EmptyUtil.isNotEmpty(moveSkuVOList)) {
                List<WhWmsConnectPickSkuVO> pickSkuList = this.whWmsConnectPickSkuService.findByConnectId(connect.getId());
                if (EmptyUtil.isEmpty(pickSkuList)) {
                    throw new WarehouseException("WH0001", "\u65e0\u62e3\u8d27\u6570\u636e");
                }
                moveSkuVOList = this.buildMoveStockSku(command.getWhCommandSkuList(), pickSkuList, oriShelves, tarShelves);
            }
            String string = this.doMoveStock(command, moveSkuVOList, operatorId);
        }
        this.whWmsConnectDistributionService.deleteConnectDistribution(connect.getId(), command.getCode());
        this.whCommandService.cancelCommandforShortage(commandCode);
        boolean result = this.finishCommandOutCancel(commandCode, null);
        if (!result) {
            throw new WarehouseException("WH0001", String.format("[%s]\u6307\u4ee4\u672a\u53d6\u6d88\u6216\u5df2\u5904\u7406", command.getCode()));
        }
        this.whWmsCommandCheckService.unBoundCheckGiftCard(dispatchBillCode);
        return true;
    }

    @Override
    public List<WhWmsMoveSkuVO> buildMoveStockSku(List<WhCommandSku> commandSkuList, List<WhWmsConnectPickSkuVO> picSkuList, WhWmsHouseShelvesVO oriShelves, WhWmsHouseShelvesVO tarShelves) {
        HashMap<String, HashSet<String>> skuBarcodeMap = new HashMap<String, HashSet<String>>();
        HashMap<String, ArrayList<WhWmsConnectPickSkuVO>> barCodePickMap = new HashMap<String, ArrayList<WhWmsConnectPickSkuVO>>();
        for (WhWmsConnectPickSkuVO pickSku : picSkuList) {
            HashSet<String> barCodes = (HashSet<String>)skuBarcodeMap.get(pickSku.getSkuCode());
            if (NullUtil.isNull((Object)barCodes)) {
                barCodes = new HashSet<String>();
                skuBarcodeMap.put(pickSku.getSkuCode(), barCodes);
            }
            barCodes.add(pickSku.getBarCode());
            ArrayList<WhWmsConnectPickSkuVO> barCodePickList = (ArrayList<WhWmsConnectPickSkuVO>)barCodePickMap.get(pickSku.getBarCode());
            if (NullUtil.isNull((Object)barCodePickList)) {
                barCodePickList = new ArrayList<WhWmsConnectPickSkuVO>();
                barCodePickMap.put(pickSku.getBarCode(), barCodePickList);
            }
            barCodePickList.add(pickSku);
        }
        ArrayList<WhWmsMoveSkuVO> moveSkuList = new ArrayList<WhWmsMoveSkuVO>();
        block1: for (WhCommandSku commandSku : commandSkuList) {
            Set barCodes = (Set)skuBarcodeMap.get(commandSku.getSkuCode());
            if (NullUtil.isNull((Object)barCodes) || barCodes.isEmpty()) continue;
            int needAmount = commandSku.getPlanedQuantity();
            block2: for (String barCode : barCodes) {
                List barCodePickList;
                if (needAmount <= 0 || EmptyUtil.isEmpty((List)(barCodePickList = (List)barCodePickMap.get(barCode)))) continue block1;
                for (WhWmsConnectPickSkuVO pickSku : barCodePickList) {
                    if (needAmount <= 0) continue block2;
                    if (pickSku.getActualAmount() <= 0) continue;
                    int moveAmount = pickSku.getActualAmount() >= needAmount ? needAmount : pickSku.getActualAmount();
                    pickSku.setActualAmount(pickSku.getActualAmount() - moveAmount);
                    needAmount -= moveAmount;
                    WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                    moveSkuVO.setSkuCode(pickSku.getSkuCode());
                    moveSkuVO.setSkuStatus(pickSku.getSkuStatus());
                    moveSkuVO.setBarCode(pickSku.getBarCode());
                    moveSkuVO.setPhysicalWarehouseCode(oriShelves.getPhysicalWarehouseCode());
                    moveSkuVO.setOriginalShelvesCode(oriShelves.getCode());
                    moveSkuVO.setOriginalHouseType(oriShelves.getHouseType());
                    moveSkuVO.setTargetShelvesCode(tarShelves.getCode());
                    moveSkuVO.setTargetHouseType(tarShelves.getHouseType());
                    moveSkuVO.setAmount(moveAmount);
                    moveSkuList.add(moveSkuVO);
                }
            }
        }
        return moveSkuList;
    }

    @Override
    public List<WhWmsMoveSkuVO> buildMoveStockSkuFormDistribution(WhCommand command, WhWmsHouseShelvesVO oriShelves, WhWmsHouseShelvesVO tarShelves) {
        WhWmsCommandConnectVO commandConnectVO = this.whWmsCommandConnectService.findNotCanceledByWhCommandCode(command.getCode());
        if (commandConnectVO == null) {
            return null;
        }
        WhWmsConnectInfoVO connect = this.whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
        WhWmsConnectDistributionVO distributeCond = new WhWmsConnectDistributionVO();
        distributeCond.setCommandCode(command.getCode());
        distributeCond.setConnectId(connect.getId());
        List<WhWmsConnectDistributionVO> distributeList = this.whWmsConnectDistributionService.findByCond(distributeCond);
        if (EmptyUtil.isNotEmpty(distributeList)) {
            ArrayList<WhWmsMoveSkuVO> moveSkuList = new ArrayList<WhWmsMoveSkuVO>();
            for (WhWmsConnectDistributionVO distribution : distributeList) {
                WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                moveSkuVO.setSkuCode(distribution.getSkuCode());
                moveSkuVO.setSkuStatus(distribution.getSkuStatus());
                moveSkuVO.setBarCode(distribution.getBarCode());
                moveSkuVO.setPhysicalWarehouseCode(oriShelves.getPhysicalWarehouseCode());
                moveSkuVO.setOriginalShelvesCode(oriShelves.getCode());
                moveSkuVO.setOriginalHouseType(oriShelves.getHouseType());
                moveSkuVO.setTargetShelvesCode(tarShelves.getCode());
                moveSkuVO.setTargetHouseType(tarShelves.getHouseType());
                moveSkuVO.setAmount(distribution.getDistributAmount());
                moveSkuList.add(moveSkuVO);
            }
            if (EmptyUtil.isNotEmpty(moveSkuList)) {
                return moveSkuList;
            }
        }
        return null;
    }

    private String doMoveStock(WhCommand whCommand, List<WhWmsMoveSkuVO> moveSkuList, Long operatorId) {
        if (EmptyUtil.isNotEmpty(moveSkuList)) {
            WhWmsMoveStockVO move = new WhWmsMoveStockVO();
            move.setMoveSkuList(moveSkuList);
            move.setPhysicalWarehouseCode(moveSkuList.get(0).getPhysicalWarehouseCode());
            move.setCreateUserId(operatorId);
            move.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_CANCEL_MAKE);
            move.setReferenceCode(whCommand.getReferenceCode().split("_")[0]);
            this.whWmsMoveStockService.newMoveStock(move);
            return move.getCode();
        }
        throw new WarehouseException("WH0001", "\u6307\u4ee4\u5df2\u53d6\u6d88");
    }

    private boolean finishCommandOutCancel(String commandCode, String moveCode) {
        WhCommandOutCancelExample example = new WhCommandOutCancelExample();
        example.createCriteria().andCommandCodeEqualTo(commandCode);
        List<WhCommandOutCancel> list = this.whCommandOutCancelMapper.selectByExample(example);
        if (EmptyUtil.isEmpty(list)) {
            throw new WarehouseException("WH0001", "\u6307\u4ee4\u53d6\u6d88\u4e0d\u5b58\u5728");
        }
        WhCommandOutCancel update = new WhCommandOutCancel();
        update.setId(list.get(0).getId());
        update.setStatus(WhCommandOutCancel.STATUS_FINISHED);
        update.setMoveCode(moveCode);
        update.setFinishDate(DateUtil.getNow());
        return this.whCommandOutCancelMapper.finishCommandOutCancel(update) == 1;
    }
}

