/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.service.warehouse.cond.WhCommandCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhCommandMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandAssociateExpressService;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhCommandAssoExpressVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="whCommandAssociateExpressService")
public class WhCommandAssociateExpressServiceImpl
implements WhCommandAssociateExpressService {
    private final Logger log = LoggerFactory.getLogger(WhCommandAssociateExpressServiceImpl.class);
    @Autowired
    private WhCommandMapper whCommandMapper;
    @Autowired
    private WhCommandService whCommandService;

    @Override
    public Boolean commandAssociateExpress(String commandCode, String expressCode) {
        this.validate(commandCode, expressCode);
        WhCommand command = this.whCommandService.findCommandByCode(commandCode, false);
        WhCommandAssoExpressVO cond = new WhCommandAssoExpressVO();
        cond.setPackageCode(command.getReferenceCode());
        List<WhCommandAssoExpressVO> infos = this.whCommandMapper.findCommandAssoExpressInfoByPackageCode(cond);
        if (CollectionUtils.isNotEmpty(infos) && infos.size() == 1) {
            WhCommandAssoExpressVO statusInfo = infos.get(0);
            if (EmptyUtil.isEmpty((Object)statusInfo.getDeliveryType()) || WhCommandAssoExpressVO.DELIVERY_TYPE_NOT_EXPRESS.equals(statusInfo.getDeliveryType())) {
                throw new WarehouseException("CO0002", "\u53ea\u6709\u914d\u9001\u7c7b\u578b\u662f\u5feb\u9012\u7684\u5305\u88f9\u53ef\u4ee5\u5173\u8054\u5feb\u9012\u5355");
            }
            if (EmptyUtil.isEmpty((Object)statusInfo.getPackageDeliveryInfoId())) {
                throw new WarehouseException("CO0002", "\u8be5\u5305\u88f9\u6ca1\u6709\u914d\u9001\u4fe1\u606f\u65e0\u6cd5\u5173\u8054\u5feb\u9012\u5355,packageCode:" + command.getReferenceCode());
            }
            if (this.whCommandMapper.existExpressCode(expressCode, statusInfo.getPackageDeliveryInfoId()) > 0) {
                throw new WarehouseException("CO0001", "\u5feb\u9012\u5355\u53f7\u91cd\u590d:" + expressCode);
            }
            this.whCommandMapper.packageAssoExpress(statusInfo.getPackageId(), expressCode);
        }
        return this.whCommandService.commandAssociateExpress(commandCode, expressCode);
    }

    @Override
    public Boolean batchCommandAssociateExpress(List<WhCommand> whCommands) {
        ArrayList<String> commandCodes = new ArrayList<String>();
        ArrayList<String> expressCodes = new ArrayList<String>();
        for (WhCommand whCommand : whCommands) {
            commandCodes.add(whCommand.getCode());
            expressCodes.add(whCommand.getReferenceCode());
        }
        this.validate(commandCodes, expressCodes);
        WhCommandAssoExpressVO cond = new WhCommandAssoExpressVO();
        cond.setPackageCodeList(expressCodes);
        List<WhCommandAssoExpressVO> infos = this.whCommandMapper.findCommandAssoExpressInfoByPackageCode(cond);
        if (CollectionUtils.isNotEmpty(infos)) {
            for (WhCommandAssoExpressVO statusInfo : infos) {
                if (EmptyUtil.isEmpty((Object)statusInfo.getDeliveryType()) || WhCommandAssoExpressVO.DELIVERY_TYPE_NOT_EXPRESS.equals(statusInfo.getDeliveryType())) {
                    throw new WarehouseException("CO0002", "\u53ea\u6709\u914d\u9001\u7c7b\u578b\u662f\u5feb\u9012\u7684\u5305\u88f9\u53ef\u4ee5\u5173\u8054\u5feb\u9012\u5355");
                }
                if (EmptyUtil.isEmpty((Object)statusInfo.getPackageDeliveryInfoId())) {
                    throw new WarehouseException("CO0002", "\u8be5\u5305\u88f9\u6ca1\u6709\u914d\u9001\u4fe1\u606f\u65e0\u6cd5\u5173\u8054\u5feb\u9012\u5355,packageCode:" + statusInfo.getPackageCode());
                }
                if (this.whCommandMapper.existExpressCode(statusInfo.getPackageCode(), statusInfo.getPackageDeliveryInfoId()) > 0) {
                    throw new WarehouseException("CO0001", "\u5feb\u9012\u5355\u53f7\u91cd\u590d:" + statusInfo.getPackageCode());
                }
                this.whCommandMapper.packageAssoExpress(statusInfo.getPackageId(), statusInfo.getPackageCode());
            }
        }
        for (WhCommand whCommand : whCommands) {
            this.whCommandService.commandAssociateExpress(whCommand.getCode(), whCommand.getReferenceCode());
        }
        return true;
    }

    @Override
    public Boolean commandAssociateExpress(String commandCode, String expressCode, String operationSource) {
        this.validate(commandCode, expressCode, operationSource);
        WhCommand command = this.whCommandService.findCommandByCode(commandCode, false);
        WhCommandAssoExpressVO cond = new WhCommandAssoExpressVO();
        cond.setPackageCode(command.getReferenceCode());
        List<WhCommandAssoExpressVO> infos = this.whCommandMapper.findCommandAssoExpressInfoByPackageCode(cond);
        if (CollectionUtils.isNotEmpty(infos) && infos.size() == 1) {
            WhCommandAssoExpressVO statusInfo = infos.get(0);
            if (EmptyUtil.isEmpty((Object)statusInfo.getDeliveryType()) || WhCommandAssoExpressVO.DELIVERY_TYPE_NOT_EXPRESS.equals(statusInfo.getDeliveryType())) {
                throw new WarehouseException("CO0002", "\u53ea\u6709\u914d\u9001\u7c7b\u578b\u662f\u5feb\u9012\u7684\u5305\u88f9\u53ef\u4ee5\u5173\u8054\u5feb\u9012\u5355");
            }
            if (EmptyUtil.isEmpty((Object)statusInfo.getPackageDeliveryInfoId())) {
                throw new WarehouseException("CO0002", "\u8be5\u5305\u88f9\u6ca1\u6709\u914d\u9001\u4fe1\u606f\u65e0\u6cd5\u5173\u8054\u5feb\u9012\u5355,packageCode:" + command.getReferenceCode());
            }
            if (this.whCommandMapper.existExpressCode(expressCode, statusInfo.getPackageDeliveryInfoId()) > 0) {
                throw new WarehouseException("CO0001", "\u5feb\u9012\u5355\u53f7\u91cd\u590d:" + expressCode);
            }
            this.whCommandMapper.packageAssoExpress(statusInfo.getPackageId(), expressCode);
        }
        return this.whCommandService.commandAssociateExpress(commandCode, expressCode, operationSource);
    }

    @Override
    public Boolean commandAssociateExpress(WhCommandAssoExpressVO vo) {
        String commandCode = vo.getCommandCode();
        String expressCode = vo.getExpressCode();
        if (NullUtil.isNull((Object)commandCode)) {
            throw new WarehouseException("CO0001", "\u65e0\u6548\u7684\u51fa\u5e93\u5355\u53f7");
        }
        if (EmptyUtil.isEmpty((Object)vo.getDeliveryType())) {
            throw new WarehouseException("CO0001", "\u65e0\u6548\u7684\u5feb\u9012\u7c7b\u578b");
        }
        WhCommand command = this.whCommandService.findCommandByCode(commandCode, false);
        if (EmptyUtil.isEmpty((Object)command)) {
            throw new WarehouseException("CO0001", "\u6307\u4ee4\u65e0\u6548:" + commandCode);
        }
        Integer status = command.getCommandStatus();
        if (!WhCommand.STATUS_HANDOVER.equals(status) && !WhCommand.STATUS_DELIVERYCOMPLETION.equals(status)) {
            throw new WarehouseException("CO0002", "\u51fa\u8d27\u5355\u662f\u5fc5\u987b\u662f\u5f85\u4ea4\u63a5\u72b6\u6001\u6216\u53d1\u8d27\u5b8c\u6210\u72b6\u6001,\u4e0d\u53ef\u64cd\u4f5c\uff01");
        }
        if (command.getInOutType().equals(WhCommand.TYPE_SALES_OUT) || command.getInOutType().equals(WhCommand.TYPE_CHANGE_OUT) || command.getInOutType().equals(WhCommand.TYPE_SAMPLE_OUT) || command.getInOutType().equals(WhCommand.TYPE_GIFT_OUT)) {
            List<Object> infos = new ArrayList();
            WhCommandAssoExpressVO cond = new WhCommandAssoExpressVO();
            if (CollectionUtils.isNotEmpty(vo.getPackageCodeList())) {
                cond.setPackageCodeList(vo.getPackageCodeList());
                infos = this.whCommandMapper.findCommandAssoExpressInfoByPackageCode(cond);
            }
            if (EmptyUtil.isEmpty(infos)) {
                throw new WarehouseException("CO0002", "\u5305\u88f9\u4e0d\u5b58\u5728:" + command.getReferenceCode());
            }
            WhCommandAssoExpressVO info = (WhCommandAssoExpressVO)infos.get(0);
            if (EmptyUtil.isEmpty((Object)info.getDeliveryType()) || WhCommandAssoExpressVO.DELIVERY_TYPE_NOT_EXPRESS.equals(info.getDeliveryType())) {
                throw new WarehouseException("CO0002", "\u53ea\u6709\u914d\u9001\u7c7b\u578b\u662f\u5feb\u9012\u7684\u5305\u88f9\u53ef\u4ee5\u5173\u8054\u5feb\u9012\u5355");
            }
            if (EmptyUtil.isEmpty((Object)info.getPackageDeliveryInfoId()) && EmptyUtil.isNotEmpty((String)expressCode)) {
                throw new WarehouseException("CO0002", "\u8be5\u5305\u88f9\u6ca1\u6709\u914d\u9001\u4fe1\u606f\u65e0\u6cd5\u5173\u8054\u5feb\u9012\u5355,packageCode:" + command.getReferenceCode());
            }
            if (EmptyUtil.isNotEmpty((String)expressCode) && this.whCommandMapper.existExpressCode(expressCode, info.getPackageDeliveryInfoId()) > 0) {
                throw new WarehouseException("CO0001", "\u5feb\u9012\u5355\u53f7\u91cd\u590d:" + expressCode);
            }
            if (NullUtil.isNotNull((Object)vo.getExpressCode())) {
                info.setExpressCode(vo.getExpressCode());
            }
            info.setCommandCode(vo.getCommandCode());
            info.setDeliveryType(vo.getDeliveryType());
            info.setPackageCodeList(vo.getPackageCodeList());
            this.whCommandMapper.packageAssoExpressWithExpressType(info);
            this.whCommandMapper.dispatchAssoExpressWithExpressType(info);
            return this.whCommandService.commandAssociateExpress(info);
        }
        if (command.getInOutType().equals(WhCommand.TYPE_ALLOT_OUT)) {
            return this.whCommandService.commandAssociateExpress(vo);
        }
        if (command.getInOutType().equals(WhCommand.TYPE_PURCHASE_RETURN_OUT)) {
            WhCommand cmd = this.whCommandService.findCommandByExpressCode(expressCode);
            if (NullUtil.isNotNull((Object)cmd) && !cmd.getCode().equals(commandCode)) {
                throw new WarehouseException("CO0001", "\u5feb\u9012\u5355\u53f7\u91cd\u590d:" + expressCode);
            }
            vo.setPackageCode(command.getReferenceCode());
            this.whCommandMapper.purchaseReturnAssoExpress(vo);
            return this.whCommandService.commandAssociateExpress(vo);
        }
        return false;
    }

    @Override
    public Boolean commandAssociateExpressSF(String commandCode, PackageInfo pi) {
        this.validate(commandCode, pi.getDeliveryCode());
        this.whCommandMapper.packageAssoExpressSF(pi);
        return this.whCommandService.commandAssociateExpress(commandCode, pi.getDeliveryCode());
    }

    @Override
    public Boolean commandAssociateExpressFED(String commandCode, PackageInfo pi) {
        this.validate(commandCode, pi.getDeliveryCode());
        this.whCommandMapper.packageAssoExpressFED(pi);
        return this.whCommandService.commandAssociateExpress(commandCode, pi.getDeliveryCode());
    }

    private boolean validate(String commandCode, String expressCode) {
        if (NullUtil.isNull((Object)commandCode)) {
            throw new WarehouseException("CO0001", "\u65e0\u6548\u7684\u51fa\u5e93\u5355\u53f7:" + commandCode);
        }
        if (EmptyUtil.isEmpty((String)expressCode)) {
            throw new WarehouseException("CO0001", "\u65e0\u6548\u7684\u5feb\u9012\u5355\u53f7:" + expressCode);
        }
        WhCommand command = this.whCommandService.findCommandByCode(commandCode, false);
        if (NullUtil.isNull((Object)command)) {
            throw new WarehouseException("CO0002", "\u51fa\u8d27\u5355\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7a0b\u5e8f\u5458\uff01");
        }
        return true;
    }

    private boolean validate(List<String> commandCodes, List<String> expressCodes) {
        for (String commandCode : commandCodes) {
            if (!NullUtil.isNull((Object)commandCode)) continue;
            throw new WarehouseException("CO0001", "\u65e0\u6548\u7684\u51fa\u5e93\u5355\u53f7:" + commandCode);
        }
        for (String expressCode : expressCodes) {
            if (!EmptyUtil.isEmpty((String)expressCode)) continue;
            throw new WarehouseException("CO0001", "\u65e0\u6548\u7684\u5feb\u9012\u5355\u53f7:" + expressCode);
        }
        List<WhCommand> commands = this.whCommandService.findCommandByCodes(commandCodes, false);
        if (CollectionUtils.isEmpty(commands)) {
            throw new WarehouseException("CO0002", "\u51fa\u8d27\u5355\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7a0b\u5e8f\u5458\uff01");
        }
        for (WhCommand whCommand : commands) {
            if (WhCommand.STATUS_HANDOVER.equals(whCommand.getCommandStatus())) continue;
            throw new WarehouseException("CO0002", "[" + whCommand.getCode() + "]\u51fa\u8d27\u5355\u662f\u5fc5\u987b\u662f\u5f85\u4ea4\u63a5\u72b6\u6001,\u4e0d\u53ef\u64cd\u4f5c\uff01");
        }
        return true;
    }

    private boolean validate(String commandCode, String expressCode, String operatorSource) {
        if (NullUtil.isNull((Object)commandCode)) {
            throw new WarehouseException("CO0001", "\u65e0\u6548\u7684\u51fa\u5e93\u5355\u53f7:" + commandCode);
        }
        if (EmptyUtil.isEmpty((String)expressCode)) {
            throw new WarehouseException("CO0001", "\u65e0\u6548\u7684\u5feb\u9012\u5355\u53f7:" + expressCode);
        }
        WhCommandCond cond = new WhCommandCond();
        cond.setCode(commandCode);
        List<WhCommand> commands = this.whCommandMapper.findCommandByCond(cond);
        WhCommand command = null;
        if (commands == null || commands.isEmpty()) {
            throw new WarehouseException("CO0002", "\u51fa\u8d27\u5355\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7a0b\u5e8f\u5458\uff01");
        }
        command = commands.get(0);
        return true;
    }
}

