/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.redis.RedisClient;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.service.warehouse.cond.WhTlBuyerApplyCondVO;
import com.thebeastshop.pegasus.service.warehouse.dao.WhTlBuyerApplyLineMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhTlBuyerApplyMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhInvOccupy;
import com.thebeastshop.pegasus.service.warehouse.model.WhTlBuyerApply;
import com.thebeastshop.pegasus.service.warehouse.model.WhTlBuyerApplyLine;
import com.thebeastshop.pegasus.service.warehouse.model.WhTlBuyerApplyLineExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhBondedWarehouseAllotApplyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInvService;
import com.thebeastshop.pegasus.service.warehouse.service.WhTlBuyerPackageService;
import com.thebeastshop.pegasus.service.warehouse.vo.BondedWarehouseAllotApplyVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhReleaseOccupationVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhTlBuyerApplyVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseSkuInvVO;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.stock.dto.SStockOccupyDTO;
import com.thebeastshop.stock.enums.SStockOccupyTypeEnum;
import com.thebeastshop.stock.enums.SStockOperationTypeEnum;
import com.thebeastshop.stock.service.SStockService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Service(value="whBondedWarehouseAllotApplyService")
public class WhBondedWarehouseAllotApplyServiceImpl
implements WhBondedWarehouseAllotApplyService {
    @Autowired
    private WhTlBuyerApplyMapper whTlBuyerApplyMapper;
    @Autowired
    private WhTlBuyerApplyLineMapper whTlBuyerApplyLineMapper;
    @Autowired
    private WhTlBuyerPackageService whTlBuyerPackageService;
    @Autowired
    private WhInvService whInvService;
    @Autowired
    private SStockService sStockService;
    @Autowired
    private McPcsSkuService mcPcsSkuService;
    private static final String ISYSPA = "ISYSPA";
    @Autowired
    private RedisClient redisClient;

    @Override
    @Transactional
    public Integer addOrEditBondedWarehouseAllotApply(BondedWarehouseAllotApplyVO allotApplyVO) {
        StringBuilder sb = new StringBuilder("");
        Boolean buildOccupy = false;
        Integer result = 0;
        if (allotApplyVO.getWhTlBuyerApply().getId() == null) {
            buildOccupy = true;
            result = this.whTlBuyerApplyMapper.insert(allotApplyVO.getWhTlBuyerApply());
            HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
            params.put("createTime", DateUtil.getNow());
            params.put("id", allotApplyVO.getWhTlBuyerApply().getId());
            String code = CodeGenerator.getInstance().generate("WH_BONDED_WAREHOUSE_APPLY_CODE", params);
            allotApplyVO.getWhTlBuyerApply().setCode(code);
            this.whTlBuyerApplyMapper.updateByPrimaryKeySelective(allotApplyVO.getWhTlBuyerApply());
            for (WhTlBuyerApplyLine whTlBuyerApplyLine : allotApplyVO.getWhTlBuyerApplyLines()) {
                Boolean skuTitle = true;
                if (null == whTlBuyerApplyLine.getBeastSourceWarehouseInv()) {
                    if (skuTitle.booleanValue()) {
                        sb.append("SKU\u3010" + whTlBuyerApplyLine.getSkuCode() + "\u3011" + whTlBuyerApplyLine.getSkuName() + "<br/>");
                        skuTitle = false;
                    }
                    sb.append("\u6e90\u4ed3\u5e93\u5e93\u5b58\u4e0d\u8db3,");
                } else if (whTlBuyerApplyLine.getBeastSourceWarehouseInv() < whTlBuyerApplyLine.getQuality()) {
                    if (skuTitle.booleanValue()) {
                        sb.append("SKU\u3010" + whTlBuyerApplyLine.getSkuCode() + "\u3011" + whTlBuyerApplyLine.getSkuName());
                        skuTitle = false;
                    }
                    sb.append("\u6e90\u4ed3\u5e93\u5e93\u5b58\u4e0d\u8db3,");
                }
                if (null == whTlBuyerApplyLine.getGaojieWarehouseInv()) {
                    if (skuTitle.booleanValue()) {
                        sb.append("SKU\u3010" + whTlBuyerApplyLine.getSkuCode() + "\u3011" + whTlBuyerApplyLine.getSkuName());
                        skuTitle = false;
                    }
                    sb.append("\u9ad8\u6377\u4ed3\u5e93\u5b58\u4e0d\u8db3,");
                } else if (whTlBuyerApplyLine.getGaojieWarehouseInv() < whTlBuyerApplyLine.getQuality()) {
                    if (skuTitle.booleanValue()) {
                        sb.append("SKU\u3010" + whTlBuyerApplyLine.getSkuCode() + "\u3011" + whTlBuyerApplyLine.getSkuName());
                        skuTitle = false;
                    }
                    sb.append("\u9ad8\u6377\u4ed3\u5e93\u5b58\u4e0d\u8db3,");
                }
                whTlBuyerApplyLine.setApplyId(allotApplyVO.getWhTlBuyerApply().getId());
            }
            if (sb.length() > 0) {
                throw new WarehouseException("", sb.toString());
            }
            this.whTlBuyerApplyLineMapper.batchInsertRecord(allotApplyVO.getWhTlBuyerApplyLines());
        } else {
            this.whTlBuyerApplyMapper.updateByPrimaryKeySelective(allotApplyVO.getWhTlBuyerApply());
            WhTlBuyerApplyLineExample example = new WhTlBuyerApplyLineExample();
            example.createCriteria().andApplyIdEqualTo(allotApplyVO.getWhTlBuyerApply().getId());
            this.whTlBuyerApplyLineMapper.deleteByExample(example);
            for (WhTlBuyerApplyLine whTlBuyerApplyLine : allotApplyVO.getWhTlBuyerApplyLines()) {
                whTlBuyerApplyLine.setApplyId(allotApplyVO.getWhTlBuyerApply().getId());
            }
            this.whTlBuyerApplyLineMapper.batchInsertRecord(allotApplyVO.getWhTlBuyerApplyLines());
            List<WhInvOccupy> whInvOccupyList = this.whInvService.findOccupyQttByReferenceCodeLike(allotApplyVO.getWhTlBuyerApply().getCode());
            ArrayList whReleaseOccupationVOList = Lists.newArrayList();
            for (WhInvOccupy whInvOccupy : whInvOccupyList) {
                WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
                whReleaseOccupationVO.setOccupyType(SStockOperationTypeEnum.DEFAULT.getId());
                whReleaseOccupationVO.setReferenceCode(whInvOccupy.getReferenceCode());
                whReleaseOccupationVOList.add(whReleaseOccupationVO);
            }
            this.whInvService.releaseOccupation(whReleaseOccupationVOList);
        }
        ArrayList<SStockOccupyDTO> occupyList = new ArrayList<SStockOccupyDTO>();
        this.buildWhOccupy(occupyList, allotApplyVO.getWhTlBuyerApplyLines(), SStockOccupyTypeEnum.QT.getCode(), allotApplyVO.getWhTlBuyerApply().getId(), allotApplyVO.getWhTlBuyerApply().getCode());
        try {
            ServiceResp serviceResp = this.sStockService.occupy(occupyList);
            if (serviceResp.isFailure()) {
                throw new WarehouseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
            }
        }
        catch (WarehouseException e) {
            throw new WarehouseException(e.getErrorCode(), e.getMessage());
        }
        if (allotApplyVO.getWhTlBuyerApply().getSourceWarehouseCode().equals("WH20250047")) {
            for (WhTlBuyerApplyLine whTlBuyerApplyLine : allotApplyVO.getWhTlBuyerApplyLines()) {
                this.mcPcsSkuService.saveOrUpdateItemNumber(whTlBuyerApplyLine.getSkuCode());
            }
        }
        return result;
    }

    private void buildWhOccupy(List<SStockOccupyDTO> occupyList, List<WhTlBuyerApplyLine> applyLineList, Integer occupyType, Integer applyId, String applyCode) {
        if (CollectionUtils.isEmpty(applyLineList)) {
            throw new WarehouseException("WH0001", "\u6784\u9020\u5360\u7528\u5e93\u5b58\u7684LIST\u5931\u8d25,applyLineList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int index = 0;
        for (WhTlBuyerApplyLine whTlBuyerapplyLine : applyLineList) {
            if (whTlBuyerapplyLine.getQuality().compareTo(0) <= 0) continue;
            ArrayList warehouseCodeList = Lists.newArrayList();
            warehouseCodeList.add("WH020600010096");
            warehouseCodeList.add("WH020600010102");
            Integer availiableQty = 0;
            Integer warehouse_wh020600010096Inv = 0;
            Integer warehouse_wh020600010102Inv = 0;
            List<WhWarehouseSkuInvVO> whWarehouseSkuInvVOList = this.whInvService.findWarehousesSkuInvByCond(warehouseCodeList, whTlBuyerapplyLine.getSkuCode());
            for (WhWarehouseSkuInvVO whWarehouseSkuInvVO : whWarehouseSkuInvVOList) {
                availiableQty = availiableQty + whWarehouseSkuInvVO.getCanUseInv();
                if (whWarehouseSkuInvVO.getWarehouseCode().equals("WH020600010096")) {
                    warehouse_wh020600010096Inv = whWarehouseSkuInvVO.getCanUseInv();
                    continue;
                }
                warehouse_wh020600010102Inv = whWarehouseSkuInvVO.getCanUseInv();
            }
            if (whTlBuyerapplyLine.getQuality() > availiableQty) {
                throw new WarehouseException("CO0001", "SKU\u3010" + whTlBuyerapplyLine.getSkuCode() + "\u3011\u5e93\u5b58\u4e0d\u8db3");
            }
            Boolean needMoreOne = false;
            SStockOccupyDTO whInvOccupy = new SStockOccupyDTO();
            whInvOccupy.setWarehouseCode("WH020600010096");
            whInvOccupy.setOccupyType(SStockOccupyTypeEnum.getEnumByCode((Integer)occupyType));
            whInvOccupy.setReferenceCode(applyCode + "_" + index);
            whInvOccupy.setSkuCode(whTlBuyerapplyLine.getSkuCode());
            if (warehouse_wh020600010096Inv == 0) {
                needMoreOne = true;
            } else {
                if (whTlBuyerapplyLine.getQuality() >= warehouse_wh020600010096Inv) {
                    whInvOccupy.setQuantity(warehouse_wh020600010096Inv);
                    needMoreOne = true;
                } else {
                    whInvOccupy.setQuantity(whTlBuyerapplyLine.getQuality());
                }
                whInvOccupy.setOperationType(SStockOperationTypeEnum.DEFAULT);
                occupyList.add(whInvOccupy);
                ++index;
            }
            if (!needMoreOne.booleanValue()) continue;
            SStockOccupyDTO whInvOccupy2 = new SStockOccupyDTO();
            whInvOccupy2.setWarehouseCode("WH020600010102");
            whInvOccupy2.setOccupyType(SStockOccupyTypeEnum.getEnumByCode((Integer)occupyType));
            whInvOccupy2.setReferenceCode(applyCode + "_" + index);
            whInvOccupy2.setSkuCode(whTlBuyerapplyLine.getSkuCode());
            whInvOccupy2.setQuantity(Integer.valueOf(whTlBuyerapplyLine.getQuality() - warehouse_wh020600010096Inv));
            whInvOccupy2.setOperationType(SStockOperationTypeEnum.DEFAULT);
            occupyList.add(whInvOccupy2);
            ++index;
        }
    }

    @Override
    public Pagination<WhTlBuyerApplyVO> findByCond(WhTlBuyerApplyCondVO whTlBuyerApplyCondVO) {
        Pagination page = new Pagination(whTlBuyerApplyCondVO.getCurrpage(), whTlBuyerApplyCondVO.getPagenum());
        Integer count = this.whTlBuyerApplyMapper.countByCond(whTlBuyerApplyCondVO);
        page.setRecord(count);
        if (NumberUtil.isNullOrZero((Number)count)) {
            return null;
        }
        page.setResultList(this.whTlBuyerApplyMapper.findByCond(whTlBuyerApplyCondVO));
        return page;
    }

    @Override
    public WhTlBuyerApplyVO findById(Integer id) {
        WhTlBuyerApplyVO vo = this.whTlBuyerApplyMapper.findById(id);
        List<WhTlBuyerApplyLine> lines = this.whTlBuyerApplyLineMapper.findByApplyId(id);
        Integer i = 0;
        while (i < lines.size()) {
            WhTlBuyerApplyLine line = lines.get(i);
            line.setTbIdStr("skuLine_" + line.getSkuCode() + "_" + i);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        vo.setWhTlBuyerApplyLines(lines);
        return vo;
    }

    @Override
    public List<WhTlBuyerApplyVO> findByIds(List<Integer> ids) {
        List<WhTlBuyerApplyVO> vos = this.whTlBuyerApplyMapper.findByIds(ids);
        for (WhTlBuyerApplyVO whTlBuyerApplyVO : vos) {
            List<WhTlBuyerApplyLine> lines = this.whTlBuyerApplyLineMapper.findByApplyId(whTlBuyerApplyVO.getId());
            whTlBuyerApplyVO.setWhTlBuyerApplyLines(lines);
        }
        return vos;
    }

    @Override
    public Integer updateApply(WhTlBuyerApply whTlBuyerApply) {
        return this.whTlBuyerApplyMapper.updateByPrimaryKeySelective(whTlBuyerApply);
    }

    @Override
    @Transactional
    public Integer approveApply(BondedWarehouseAllotApplyVO saveVO) {
        Integer res = 0;
        res = this.whTlBuyerApplyMapper.updateByPrimaryKeySelective(saveVO.getWhTlBuyerApply());
        if (saveVO.getWhTlBuyerApply().getStatus() != WhTlBuyerApply.STATUS_REFUSED) {
            this.whTlBuyerApplyLineMapper.batchUpdate(saveVO.getWhTlBuyerApplyLines());
        }
        return res;
    }

    @Override
    public Integer cancelApply(Integer id) {
        WhTlBuyerApply apply = new WhTlBuyerApply();
        apply.setId(id);
        apply.setStatus(WhTlBuyerApply.STATUS_CANCEL);
        Integer res = this.whTlBuyerApplyMapper.updateByPrimaryKeySelective(apply);
        WhTlBuyerApplyVO applyVO = this.whTlBuyerApplyMapper.findById(id);
        ArrayList whReleaseOccupationVOList = Lists.newArrayList();
        List<WhInvOccupy> whInvOccupyList = this.whInvService.findOccupyQttByReferenceCodeLike(applyVO.getCode());
        for (WhInvOccupy whInvOccupy : whInvOccupyList) {
            WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
            whReleaseOccupationVO.setOccupyType(SStockOperationTypeEnum.DEFAULT.getId());
            whReleaseOccupationVO.setReferenceCode(whInvOccupy.getReferenceCode());
            whReleaseOccupationVOList.add(whReleaseOccupationVO);
        }
        this.whInvService.releaseOccupation(whReleaseOccupationVOList);
        return res;
    }

    @Override
    public Integer batchPackage(List<Integer> ids, String name, Long operatorId) throws Exception {
        return this.whTlBuyerPackageService.batchCreatePackageOrder(ids, name, operatorId);
    }

    @Override
    public Integer batchUpdate(List<Integer> applyIds, Integer buyerPackageId) {
        return this.whTlBuyerApplyMapper.batchUpdate(applyIds, buyerPackageId);
    }
}

