/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageRowBounds;
import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuDTO;
import com.thebeastshop.pegasus.service.warehouse.cond.WhAutoAllotCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhAutoAllotCallbackExcludeCategoryMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhAutoAllotCallbackWhMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhAutoAllotExcludeCategoryMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhAutoAllotGroupSortMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhAutoAllotRecordDetailMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhAutoAllotRecordMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhAutoAllotRuleMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhAutoAllotSkuMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhCommandMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhLbLimitAllotSkuMapper;
import com.thebeastshop.pegasus.service.warehouse.enums.WhAllotTypeEnum;
import com.thebeastshop.pegasus.service.warehouse.enums.WhAutoAllotDifferenceEnum;
import com.thebeastshop.pegasus.service.warehouse.enums.WhAutoAllotStatusEnum;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcdSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhAutoAllotCallbackExcludeCategory;
import com.thebeastshop.pegasus.service.warehouse.model.WhAutoAllotCallbackWh;
import com.thebeastshop.pegasus.service.warehouse.model.WhAutoAllotExcludeCategory;
import com.thebeastshop.pegasus.service.warehouse.model.WhAutoAllotGroupSort;
import com.thebeastshop.pegasus.service.warehouse.model.WhAutoAllotRecord;
import com.thebeastshop.pegasus.service.warehouse.model.WhAutoAllotRecordDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhAutoAllotRule;
import com.thebeastshop.pegasus.service.warehouse.model.WhAutoAllotSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhAutoAllotSkuExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhLbLimitAllotSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhLbLimitAllotSkuExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.service.WhAllotService;
import com.thebeastshop.pegasus.service.warehouse.service.WhAutoAllotService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAutoAllotCalculateWhVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAutoAllotGroupVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAutoAllotGroupWhSortVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAutoAllotOnlineSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAutoAllotRecordDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAutoAllotRecordVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAutoAllotRuleVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAutoAllotSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAutoAllotVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseInvQttVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.Constants;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.ListUtil;
import com.thebeastshop.pegasus.util.model.CommDictionary;
import com.thebeastshop.stock.dto.SSkuStockQueryDTO;
import com.thebeastshop.stock.service.SPresaleService;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SPresaleVO;
import com.thebeastshop.stock.vo.SSkuStockVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="whAutoAllotService")
public class WhAutoAllotServiceImpl
implements WhAutoAllotService {
    private static final Logger logger = LoggerFactory.getLogger(WhAutoAllotServiceImpl.class);
    @Autowired
    private WhAutoAllotRuleMapper whAutoAllotRuleMapper;
    @Autowired
    private WhAutoAllotSkuMapper whAutoAllotSkuMapper;
    @Autowired
    private WhAutoAllotExcludeCategoryMapper whAutoAllotExcludeCategoryMapper;
    @Autowired
    private WhAutoAllotGroupSortMapper whAutoAllotGroupSortMapper;
    @Autowired
    private WhAutoAllotCallbackWhMapper whAutoAllotCallbackWhMapper;
    @Autowired
    private WhAutoAllotRecordMapper whAutoAllotRecordMapper;
    @Autowired
    private WhAutoAllotRecordDetailMapper whAutoAllotRecordDetailMapper;
    @Autowired
    private WhCommandMapper whCommandMapper;
    @Autowired
    private WhLbLimitAllotSkuMapper whLbLimitAllotSkuMapper;
    @Autowired
    private WhAllotService whAllotService;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private SPresaleService sPresaleService;
    @Autowired
    private SStockService sStockService;
    @Autowired
    private McPcsSkuService mcPcsSkuService;
    @Autowired
    private WhAutoAllotCallbackExcludeCategoryMapper whAutoAllotCallbackExcludeCategoryMapper;
    private static final String[] onlineWhArray = Constants.onlineWhArray;
    private static final String WAREHOUSECODE = "WH020600010096";

    @Override
    @Transactional
    public int saveAutoAllotRule(WhAutoAllotRuleVO whAutoAllotRule) throws Exception {
        short allotChannel = whAutoAllotRule.getAllotChannel();
        WhAutoAllotRuleVO currentRule = allotChannel == 0 ? this.findCurrentRule(whAutoAllotRule.getBu(), false) : this.findCurrentRuleOnline(false);
        this.whAutoAllotRuleMapper.invalidAvailableRule(whAutoAllotRule.getBu(), allotChannel);
        WhAutoAllotRule po = (WhAutoAllotRule)BeanUtil.buildFrom((Object)whAutoAllotRule, WhAutoAllotRule.class);
        this.whAutoAllotRuleMapper.insertSelective(po);
        whAutoAllotRule.setId(po.getId());
        Integer currentRuleId = EmptyUtil.isNotEmpty((Object)currentRule) ? currentRule.getId() : null;
        this.saveExcludeCategory(whAutoAllotRule, currentRuleId);
        if (allotChannel == 0) {
            this.saveCallbackExcludeCategory(whAutoAllotRule, currentRuleId);
            this.saveGroupSort(whAutoAllotRule, currentRuleId);
            this.saveCallbackWh(whAutoAllotRule, currentRuleId);
        }
        this.saveAllotSku(whAutoAllotRule, currentRuleId);
        return 0;
    }

    @Override
    public List<WhAutoAllotRuleVO> findHisRules(String bu, short allotChannel) {
        return this.whAutoAllotRuleMapper.selectHisRules(bu, allotChannel);
    }

    @Override
    public List<WhAutoAllotExcludeCategory> findExcludeCategorysByRuleId(Integer ruleId) {
        return this.whAutoAllotExcludeCategoryMapper.selectByRuleId(ruleId);
    }

    @Override
    public List<WhAutoAllotCallbackExcludeCategory> findCallbackExcludeCategorysByRuleId(Integer ruleId) {
        return this.whAutoAllotCallbackExcludeCategoryMapper.selectByRuleId(ruleId);
    }

    @Override
    @Transactional
    public void executeAutoAllot(Long operatorId, String bu, boolean isAuto) throws Exception {
        WhAutoAllotRuleVO currentRule = this.findCurrentRule(bu, true);
        if (EmptyUtil.isEmpty((Object)currentRule)) {
            throw new WarehouseException("WH0002", "\u4e0d\u5b58\u5728\u53ef\u7528\u5206\u8d27\u89c4\u5219");
        }
        if (!currentRule.getRuleSwitch().booleanValue() && isAuto) {
            throw new WarehouseException("WH0002", "\u5206\u8d27\u89c4\u5219\u5173\u95ed");
        }
        List<WhAllotRcd> rcdList = this.createAutoAllotRcd(currentRule);
        if (EmptyUtil.isNotEmpty(rcdList)) {
            List<WhAutoAllotRecordDetail> notNeedAutoAllotList = this.excludeNotNeedAutoAllotData(rcdList, currentRule);
            List<String> rcdCodeList = EmptyUtil.isNotEmpty(rcdList) ? this.whAllotService.createAllotRcds(rcdList) : null;
            this.generateAutoAllotRecords(rcdList, rcdCodeList, currentRule, operatorId, notNeedAutoAllotList);
        }
    }

    @Override
    public void cronExecuteAutoAllot(Long operatorId) throws Exception {
        List bus = PegasusUtilFacade.getInstance().findDictionaryByType("BU");
        for (CommDictionary bu : bus) {
            try {
                this.executeAutoAllot(operatorId, bu.getDictValue(), true);
            }
            catch (Exception e) {
                logger.error("BU\uff1a{}\u81ea\u52a8\u5206\u8d27\u5931\u8d25", (Object)bu.getDictValue());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void executeAutoAllotOnline(Long operatorId, boolean isAuto) throws Exception {
        WhAutoAllotRuleVO currentRule = this.findCurrentRuleOnline(true);
        currentRule.setAllotChannel((short)1);
        if (EmptyUtil.isEmpty((Object)currentRule)) {
            throw new WarehouseException("WH0002", "\u4e0d\u5b58\u5728\u53ef\u7528\u5206\u8d27\u89c4\u5219");
        }
        if (!currentRule.getRuleSwitch().booleanValue() && isAuto) {
            throw new WarehouseException("WH0002", "\u5206\u8d27\u89c4\u5219\u5173\u95ed");
        }
        List<WhAllotRcd> rcdList = this.createAutoAllotRcdOnline(currentRule, operatorId);
        if (EmptyUtil.isNotEmpty(rcdList)) {
            List<WhAutoAllotRecordDetail> notNeedAutoAllotList = this.excludeNotNeedAutoAllotData(rcdList, currentRule);
            List preRcds = ListUtil.deepCopyList(rcdList);
            this.buildRealAllotQuantity(preRcds, rcdList);
            Integer recordId = this.generateAutoAllotRecords(preRcds, null, currentRule, operatorId, notNeedAutoAllotList);
            List<WhAllotRcd> newAllotRcds = this.whAllotService.autoAllotCreateRcds(preRcds);
            if (preRcds != null && preRcds.size() > 0) {
                this.updateAllotFailRecordData(recordId, newAllotRcds);
            }
        }
    }

    private void updateAllotFailRecordData(Integer recordId, List<WhAllotRcd> rcds) {
        List<WhAutoAllotRecordDetail> details = this.whAutoAllotRecordDetailMapper.listDetailByRecordId(recordId);
        if (details != null) {
            int listSize = details.size();
            for (int i = 0; i < listSize; ++i) {
                WhAutoAllotRecordDetail detail = details.get(i);
                String recordLineCode = detail.getRecordLineCode();
                boolean isAllotSuccess = false;
                if (rcds != null && rcds.size() > 0) {
                    block1: for (WhAllotRcd rcd : rcds) {
                        detail.setAllotRcdCode(rcd.getCode());
                        if (isAllotSuccess) break;
                        List<WhAllotRcdSku> whAllotRcdSkuList = rcd.getWhAllotRcdSkuList();
                        if (whAllotRcdSkuList == null) continue;
                        for (WhAllotRcdSku rcdSku : whAllotRcdSkuList) {
                            if (!recordLineCode.equals(rcdSku.getPreOccupyRefCode())) continue;
                            isAllotSuccess = true;
                            continue block1;
                        }
                    }
                }
                if (isAllotSuccess) continue;
                detail.setAllotQuantity(0);
                detail.setAllotResult((short)WhAutoAllotDifferenceEnum.THIRDPARTY__GOODS_ERROR.getVal());
            }
            this.batchUpdateRecordLine(details);
        }
    }

    private List<WhAutoAllotRecordDetail> excludeNotNeedAutoAllotData(List<WhAllotRcd> rcdList, WhAutoAllotRuleVO currentRule) {
        List<WhAutoAllotSku> skuList = currentRule.getSkuList();
        HashSet<String> skuCodes = new HashSet<String>();
        if (EmptyUtil.isNotEmpty(skuList)) {
            for (WhAutoAllotSku allotSku : skuList) {
                skuCodes.add(allotSku.getSkuCode());
            }
        }
        Map<String, Boolean> skuMap = this.checkPresaleSku(skuCodes);
        Map<String, PcsSkuDTO> skuDTOMap = this.pagingQuerySku(skuCodes);
        int rcdTotal = rcdList.size();
        ArrayList<WhAutoAllotRecordDetail> recordDetails = new ArrayList<WhAutoAllotRecordDetail>();
        List<WhAutoAllotExcludeCategory> excludeCategories = currentRule.getExcludeCategoryList();
        short allotChannel = currentRule.getAllotChannel();
        Map<Object, Object> skuPresalePlanedDeliveryDateMap = allotChannel == 1 ? this.checkPresaleSkuPlanedDeliveryDate(skuCodes) : new HashMap();
        ArrayList<WhAllotRcd> newRcdList = new ArrayList<WhAllotRcd>();
        for (int i = 0; i < rcdTotal; ++i) {
            WhAllotRcd whAllotRcd = rcdList.get(i);
            String targetWarehouseCode = whAllotRcd.getTargetWarehouseCode();
            ArrayList<WhAllotRcdSku> newRcdSkuList = new ArrayList<WhAllotRcdSku>();
            List<WhAllotRcdSku> rcdSkuList = whAllotRcd.getWhAllotRcdSkuList();
            if (EmptyUtil.isNotEmpty(rcdSkuList)) {
                for (WhAllotRcdSku whAllotRcdSku : rcdSkuList) {
                    Integer planedQuantity = whAllotRcdSku.getPlanedQuantity();
                    Integer quantity = whAllotRcdSku.getQuantity();
                    WhAutoAllotRecordDetail recordDetail = new WhAutoAllotRecordDetail();
                    String skuCode = whAllotRcdSku.getSkuCode();
                    PcsSkuDTO pcsSkuDTO = skuDTOMap.get(skuCode);
                    recordDetail.setSkuCode(skuCode);
                    recordDetail.setPlanAllotQuantity(planedQuantity);
                    recordDetail.setAllotQuantity(quantity);
                    recordDetail.setTargetWarehouseCode(targetWarehouseCode);
                    if (pcsSkuDTO.getIsJit() == 1) {
                        recordDetail.setAllotResult((short)WhAutoAllotDifferenceEnum.IS_JIT.getVal());
                        recordDetail.setAllotQuantity(0);
                        recordDetails.add(recordDetail);
                        continue;
                    }
                    if (skuMap.containsKey(skuCode)) {
                        recordDetail.setAllotResult((short)WhAutoAllotDifferenceEnum.PRESALE_NOT_COMPLETE_ALLOT.getVal());
                        recordDetail.setAllotQuantity(0);
                        recordDetails.add(recordDetail);
                        continue;
                    }
                    if (this.isExcludeCategory(excludeCategories, pcsSkuDTO.getCategoryId().intValue())) {
                        recordDetail.setAllotResult((short)WhAutoAllotDifferenceEnum.EXCLUDE_CATEGORY.getVal());
                        recordDetail.setAllotQuantity(0);
                        recordDetails.add(recordDetail);
                        continue;
                    }
                    if (planedQuantity <= 0) {
                        recordDetail.setAllotResult((short)WhAutoAllotDifferenceEnum.NO_DIFFERENCE.getVal());
                        recordDetail.setAllotQuantity(0);
                        recordDetails.add(recordDetail);
                        continue;
                    }
                    if (quantity <= 0) {
                        recordDetail.setAllotResult((short)WhAutoAllotDifferenceEnum.LOW_STOCK.getVal());
                        recordDetail.setAllotQuantity(0);
                        recordDetails.add(recordDetail);
                        continue;
                    }
                    if (pcsSkuDTO.getCrossBorderFlag() == 1 && allotChannel == 1) {
                        recordDetail.setAllotResult((short)WhAutoAllotDifferenceEnum.CROSS_BORDER.getVal());
                        recordDetail.setAllotQuantity(0);
                        recordDetails.add(recordDetail);
                        continue;
                    }
                    if (allotChannel == 1 && skuPresalePlanedDeliveryDateMap.get(skuCode) != null && ((Boolean)skuPresalePlanedDeliveryDateMap.get(skuCode)).booleanValue()) {
                        recordDetail.setAllotResult((short)WhAutoAllotDifferenceEnum.PRESALE_NOT_SHIPPED.getVal());
                        recordDetail.setAllotQuantity(0);
                        recordDetails.add(recordDetail);
                        continue;
                    }
                    newRcdSkuList.add(whAllotRcdSku);
                }
            }
            if (!EmptyUtil.isNotEmpty(newRcdSkuList)) continue;
            whAllotRcd.setWhAllotRcdSkuList(newRcdSkuList);
            newRcdList.add(whAllotRcd);
        }
        rcdList.clear();
        rcdList.addAll(newRcdList);
        return recordDetails;
    }

    private Map<String, PcsSkuDTO> pagingQuerySku(Set<String> skuSet) {
        ArrayList<String> list = new ArrayList<String>(skuSet);
        List temps = Lists.partition(list, (int)1000);
        HashMap<String, PcsSkuDTO> skuDTOMap = new HashMap<String, PcsSkuDTO>();
        for (List subList : temps) {
            Map skuMap = this.mcPcsSkuService.getSkuNameByCodes(new HashSet(subList));
            if (!EmptyUtil.isNotEmpty((Map)skuMap)) continue;
            skuDTOMap.putAll(skuMap);
        }
        return skuDTOMap;
    }

    private boolean isExcludeCategory(List<WhAutoAllotExcludeCategory> excludeCategories, Integer categoryId) {
        boolean isExclude = false;
        if (EmptyUtil.isNotEmpty(excludeCategories)) {
            for (WhAutoAllotExcludeCategory excludeCategory : excludeCategories) {
                if (!excludeCategory.getCategoryId().equals(categoryId)) continue;
                isExclude = true;
            }
        }
        return isExclude;
    }

    private Integer generateAutoAllotRecords(List<WhAllotRcd> rcdList, List<String> rcdCodeList, WhAutoAllotRuleVO currentRule, Long operatorId, List<WhAutoAllotRecordDetail> notNeedAutoAllotList) {
        boolean difference = false;
        WhAutoAllotRecord autoAllotRecord = new WhAutoAllotRecord();
        boolean notNeedAllot = EmptyUtil.isNotEmpty(notNeedAutoAllotList);
        List<WhAutoAllotRecordDetail> recordDetails = notNeedAutoAllotList;
        short allotChannel = currentRule.getAllotChannel();
        autoAllotRecord.setAllotChannel(currentRule.getAllotChannel());
        if (EmptyUtil.isNotEmpty(rcdList)) {
            int rcdTotal = rcdList.size();
            int refIndex = 0;
            for (int i = 0; i < rcdTotal; ++i) {
                WhAllotRcd whAllotRcd = rcdList.get(i);
                String allotRcdCode = allotChannel == 1 ? null : rcdCodeList.get(i);
                allotRcdCode = allotRcdCode != null && allotRcdCode.contains("ALT") ? allotRcdCode.substring(0, 21) : null;
                String targetWarehouseCode = whAllotRcd.getTargetWarehouseCode();
                List<WhAllotRcdSku> rcdSkuList = whAllotRcd.getWhAllotRcdSkuList();
                if (!EmptyUtil.isNotEmpty(rcdSkuList)) continue;
                for (WhAllotRcdSku whAllotRcdSku : rcdSkuList) {
                    Integer planedQuantity = whAllotRcdSku.getPlanedQuantity();
                    Integer quantity = whAllotRcdSku.getQuantity();
                    WhAutoAllotRecordDetail recordDetail = new WhAutoAllotRecordDetail();
                    recordDetail.setRefIndex(refIndex);
                    whAllotRcdSku.setRefIndex(refIndex);
                    if (planedQuantity > quantity) {
                        if (!difference) {
                            difference = true;
                        }
                        recordDetail.setAllotResult((short)WhAutoAllotDifferenceEnum.LOW_STOCK.getVal());
                    } else {
                        recordDetail.setAllotResult((short)WhAutoAllotDifferenceEnum.NO_DIFFERENCE.getVal());
                    }
                    recordDetail.setSkuCode(whAllotRcdSku.getSkuCode());
                    recordDetail.setPlanAllotQuantity(planedQuantity);
                    recordDetail.setAllotQuantity(quantity);
                    recordDetail.setAllotRcdCode(allotRcdCode);
                    recordDetail.setTargetWarehouseCode(targetWarehouseCode);
                    recordDetails.add(recordDetail);
                    ++refIndex;
                }
            }
        }
        autoAllotRecord.setAllotTime(new Date());
        autoAllotRecord.setAllotStatus(allotChannel == 0 ? (short)WhAutoAllotStatusEnum.TO_BE_CONFIRMED.getVal() : (short)WhAutoAllotStatusEnum.COMPLETED.getVal());
        autoAllotRecord.setRuleId(currentRule.getId());
        autoAllotRecord.setAllotResult(difference ? (short)0 : 1);
        if (notNeedAllot) {
            autoAllotRecord.setAllotResult((short)0);
        }
        autoAllotRecord.setCreator(operatorId.intValue());
        this.whAutoAllotRecordMapper.insertSelective(autoAllotRecord);
        Integer recordId = autoAllotRecord.getId();
        if (EmptyUtil.isNotEmpty(recordDetails)) {
            for (WhAutoAllotRecordDetail recordDetail : recordDetails) {
                recordDetail.setRecordId(recordId);
            }
            this.whAutoAllotRecordDetailMapper.batchInsert(recordDetails);
            this.batchUpdateRecordLineCode(recordDetails);
        }
        this.buildRcdSkuPreRefCode(recordDetails, rcdList);
        return autoAllotRecord.getId();
    }

    private void batchUpdateRecordLineCode(List<WhAutoAllotRecordDetail> recordDetails) {
        if (recordDetails == null || recordDetails.size() == 0) {
            return;
        }
        int lineSize = recordDetails.size();
        for (int i = 0; i < lineSize; ++i) {
            WhAutoAllotRecordDetail allotRecordDetail = recordDetails.get(i);
            allotRecordDetail.setRecordLineCode(this.generatorRecordLineCode(allotRecordDetail.getId()));
        }
        this.batchUpdateRecordLine(recordDetails);
    }

    private void batchUpdateRecordLine(List<WhAutoAllotRecordDetail> recordDetails) {
        List allList = ListUtils.partition(recordDetails, (int)500);
        for (List list : allList) {
            logger.info("\u81ea\u52a8\u5206\u8d27\u5206\u7247\u66f4\u65b0\u8bb0\u5f55\u6570{}, \u660e\u7ec6{}", (Object)(list == null ? 0 : list.size()), (Object)JSON.toJSONString((Object)list));
            this.whAutoAllotRecordDetailMapper.batchUpdateRecordLine(list);
        }
    }

    private void buildRcdSkuPreRefCode(List<WhAutoAllotRecordDetail> recordDetails, List<WhAllotRcd> rcdList) {
        if (recordDetails == null || recordDetails.size() == 0 || rcdList == null || rcdList.size() == 0) {
            return;
        }
        for (WhAllotRcd rcd : rcdList) {
            List<WhAllotRcdSku> whAllotRcdSkuList = rcd.getWhAllotRcdSkuList();
            block1: for (WhAllotRcdSku rcdSku : whAllotRcdSkuList) {
                for (WhAutoAllotRecordDetail recordDetail : recordDetails) {
                    if (!rcdSku.getRefIndex().equals(recordDetail.getRefIndex())) continue;
                    rcdSku.setPreOccupyRefCode(recordDetail.getRecordLineCode());
                    continue block1;
                }
            }
        }
    }

    private Map<String, Boolean> checkPresaleSku(Set<String> skuCodes) {
        HashMap<String, Boolean> skuMap = new HashMap<String, Boolean>();
        List sPresaleVOList = this.sPresaleService.findUnfinishedAllotPreSale(new ArrayList<String>(skuCodes));
        if (EmptyUtil.isNotEmpty((List)sPresaleVOList)) {
            for (SPresaleVO sPresaleVO : sPresaleVOList) {
                skuMap.put(sPresaleVO.getSkuCode(), true);
            }
        }
        return skuMap;
    }

    private Map<String, Boolean> checkPresaleSkuPlanedDeliveryDate(Set<String> skuCodes) {
        HashMap<String, Boolean> skuMap = new HashMap<String, Boolean>();
        List sPresaleVOList = this.sPresaleService.findByCond(new ArrayList<String>(skuCodes), DateUtil.parse((String)DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd"));
        if (EmptyUtil.isNotEmpty((List)sPresaleVOList)) {
            for (SPresaleVO sPresaleVO : sPresaleVOList) {
                skuMap.put(sPresaleVO.getSkuCode(), true);
            }
        }
        return skuMap;
    }

    /*
     * WARNING - void declaration
     */
    private List<WhAllotRcd> createAutoAllotRcd(WhAutoAllotRuleVO currentRule) throws Exception {
        List<WhAutoAllotSku> skuList = currentRule.getSkuList();
        List<WhAutoAllotGroupSort> groupSortList = currentRule.getGroupSortList();
        Map<String, WhAutoAllotGroupSort> groupSortMap = this.buildGroupSortMap(groupSortList);
        if (EmptyUtil.isNotEmpty(skuList)) {
            HashMap<String, Set<String>> skuGroupMap = new HashMap<String, Set<String>>();
            ArrayList<SSkuStockQueryDTO> skuStockQueryDTOList = new ArrayList<SSkuStockQueryDTO>();
            HashMap<String, List<Map<String, List<String>>>> skuMap = new HashMap<String, List<Map<String, List<String>>>>();
            ArrayList<String> skuCodes = new ArrayList<String>();
            ArrayList<String> warehouseCodes = new ArrayList<String>();
            HashMap<String, Integer> planMap = new HashMap<String, Integer>();
            HashMap<String, Integer> invQttMap = new HashMap<String, Integer>();
            for (WhAutoAllotSku whAutoAllotSku : skuList) {
                void var20_28;
                SSkuStockQueryDTO sSkuStockQueryDTO = new SSkuStockQueryDTO();
                String skuCode = whAutoAllotSku.getSkuCode();
                String warehouseCode = whAutoAllotSku.getTargetWarehouseCode();
                String calculateWarehouseCode = whAutoAllotSku.getCalculateWarehouseCode();
                sSkuStockQueryDTO.setSkuCode(skuCode);
                sSkuStockQueryDTO.setWarehouseCode(calculateWarehouseCode);
                skuStockQueryDTOList.add(sSkuStockQueryDTO);
                ArrayList targetWhList = (ArrayList)skuMap.get(skuCode);
                if (EmptyUtil.isNotEmpty((List)targetWhList)) {
                    for (Map map : targetWhList) {
                        ArrayList<String> calculateWhList = (ArrayList<String>)map.get(warehouseCode);
                        if (EmptyUtil.isEmpty((List)calculateWhList)) {
                            calculateWhList = new ArrayList<String>();
                        }
                        calculateWhList.add(calculateWarehouseCode);
                        map.put(warehouseCode, calculateWhList);
                    }
                } else {
                    targetWhList = new ArrayList();
                    HashMap targetWhMap = new HashMap();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(calculateWarehouseCode);
                    targetWhMap.put(warehouseCode, arrayList);
                    targetWhList.add(targetWhMap);
                }
                skuMap.put(skuCode, targetWhList);
                String key = new StringBuffer().append(calculateWarehouseCode).append(":").append(skuCode).toString();
                planMap.put(key, whAutoAllotSku.getSafeStock());
                skuCodes.add(skuCode);
                warehouseCodes.add(warehouseCode);
                Set set = (Set)skuGroupMap.get(skuCode);
                if (EmptyUtil.isEmpty((Object)set)) {
                    HashSet hashSet = new HashSet();
                }
                var20_28.add(groupSortMap.get(warehouseCode).getOwnGroup());
                skuGroupMap.put(skuCode, (Set<String>)var20_28);
            }
            List<SSkuStockVO> sSkuStockVOList = this.pagingQueryStock(skuStockQueryDTOList);
            if (EmptyUtil.isNotEmpty(sSkuStockVOList)) {
                for (SSkuStockVO sSkuStockVO : sSkuStockVOList) {
                    String key = new StringBuffer().append(sSkuStockVO.getWarehouseCode()).append(":").append(sSkuStockVO.getSkuCode()).toString();
                    if (!planMap.containsKey(key)) continue;
                    planMap.put(key, (Integer)planMap.get(key) - sSkuStockVO.getCanUseQuantity());
                }
            }
            List<WhWarehouseInvQttVO> list = this.whCommandMapper.findAutoAllotWillInQttBySkuCode(skuCodes, warehouseCodes);
            if (EmptyUtil.isNotEmpty(sSkuStockVOList)) {
                for (WhWarehouseInvQttVO invQttVO : list) {
                    String key = new StringBuffer().append(invQttVO.getWarehouseCode()).append(":").append(invQttVO.getSkuCode()).toString();
                    if (invQttMap.containsKey(key)) continue;
                    invQttMap.put(key, invQttVO.getQuantity());
                }
            }
            List<WhAutoAllotSkuVO> list2 = this.buildSkuPlanQuantityVO(groupSortMap, skuMap, planMap, skuGroupMap, invQttMap);
            this.bulidCanUseQuantity(skuCodes, list2, currentRule.getCallbackExcludeCategoryList(), currentRule.getCallbackWhList(), false);
            this.buildCanAllotQunatity(list2);
            return this.buildAllotRcd(list2);
        }
        return null;
    }

    private List<WhAllotRcd> createAutoAllotRcdOnline(WhAutoAllotRuleVO currentRule, Long operatorId) throws Exception {
        List<WhAutoAllotSku> skuList = currentRule.getSkuList();
        if (EmptyUtil.isNotEmpty(skuList)) {
            ArrayList<SSkuStockQueryDTO> skuStockQueryDTOList = new ArrayList<SSkuStockQueryDTO>();
            HashSet<String> skuCodes = new HashSet<String>();
            List<String> warehouseCodes = Arrays.asList(Constants.onlineWhArray);
            HashMap<String, Integer> planMap = new HashMap<String, Integer>();
            TreeMap<String, Integer> safeStockMap = new TreeMap<String, Integer>();
            HashMap<String, Integer> skuCanUseStockMap = new HashMap<String, Integer>();
            HashMap<String, Integer> stockMap = new HashMap<String, Integer>();
            HashMap<String, Integer> invQttMap = new HashMap<String, Integer>();
            for (WhAutoAllotSku whAutoAllotSku : skuList) {
                SSkuStockQueryDTO sSkuStockQueryDTO = new SSkuStockQueryDTO();
                String skuCode = whAutoAllotSku.getSkuCode();
                String warehouseCode = whAutoAllotSku.getTargetWarehouseCode();
                sSkuStockQueryDTO.setSkuCode(skuCode);
                sSkuStockQueryDTO.setWarehouseCode(warehouseCode);
                skuStockQueryDTOList.add(sSkuStockQueryDTO);
                String key = new StringBuffer().append(warehouseCode).append(":").append(skuCode).toString();
                planMap.put(key, whAutoAllotSku.getSafeStock());
                safeStockMap.put(key, whAutoAllotSku.getSafeStock());
                skuCodes.add(skuCode);
            }
            List<SSkuStockVO> sSkuStockVOList = this.pagingQueryStock(skuStockQueryDTOList);
            if (EmptyUtil.isNotEmpty(sSkuStockVOList)) {
                for (SSkuStockVO sSkuStockVO : sSkuStockVOList) {
                    String key = new StringBuffer().append(sSkuStockVO.getWarehouseCode()).append(":").append(sSkuStockVO.getSkuCode()).toString();
                    String skuCode = sSkuStockVO.getSkuCode();
                    if (skuCanUseStockMap.containsKey(skuCode)) {
                        skuCanUseStockMap.put(skuCode, (Integer)skuCanUseStockMap.get(skuCode) + sSkuStockVO.getCanUseQuantity());
                    } else {
                        skuCanUseStockMap.put(skuCode, sSkuStockVO.getCanUseQuantity());
                    }
                    stockMap.put(key, sSkuStockVO.getCanUseQuantity());
                    if (!planMap.containsKey(key)) continue;
                    planMap.put(key, (Integer)planMap.get(key) - sSkuStockVO.getCanUseQuantity());
                }
            }
            List<WhWarehouseInvQttVO> list = this.whCommandMapper.findAutoAllotWillInQttBySkuCode(new ArrayList<String>(skuCodes), warehouseCodes);
            if (EmptyUtil.isNotEmpty(sSkuStockVOList)) {
                for (WhWarehouseInvQttVO invQttVO : list) {
                    String key = new StringBuffer().append(invQttVO.getWarehouseCode()).append(":").append(invQttVO.getSkuCode()).toString();
                    if (invQttMap.containsKey(key)) continue;
                    invQttMap.put(key, invQttVO.getQuantity());
                }
            }
            ArrayList<WhAutoAllotVO> arrayList = new ArrayList<WhAutoAllotVO>();
            for (String skuCode : skuCodes) {
                WhAutoAllotOnlineSkuVO onlineSku = new WhAutoAllotOnlineSkuVO();
                onlineSku.setSkuCode(skuCode);
                Integer totalSafeStock = 0;
                int totalNeedAllotQuantity = 0;
                boolean needAllot = false;
                Map<String, Integer> overStockMap = new TreeMap<String, Integer>();
                HashMap<String, Integer> needStockMap = new HashMap<String, Integer>();
                Map<String, Integer> skuSafeStockMap = new TreeMap<String, Integer>();
                block11: for (int i = 0; i < Constants.onlineWhArray.length; ++i) {
                    String warehouseCode = Constants.onlineWhArray[i];
                    String key = warehouseCode + ":" + skuCode;
                    int safeStock = (Integer)safeStockMap.get(key);
                    skuSafeStockMap.put(warehouseCode, safeStock);
                    totalSafeStock = totalSafeStock + safeStock;
                    int n = (Integer)planMap.get(key);
                    needAllot = n > 0 ? true : needAllot;
                    totalNeedAllotQuantity += n;
                    if (n < 0) {
                        overStockMap.put(warehouseCode, -n);
                    } else {
                        needStockMap.put(warehouseCode, n);
                    }
                    switch (i) {
                        case 0: {
                            onlineSku.setWH020600010102(safeStock);
                            onlineSku.setWH020600010102NeedAllotQunatity(n);
                            continue block11;
                        }
                        case 1: {
                            onlineSku.setWH020600010121(safeStock);
                            onlineSku.setWH020600010121NeedAllotQunatity(n);
                            continue block11;
                        }
                        case 2: {
                            onlineSku.setWH000275910275(safeStock);
                            onlineSku.setWH000275910275NeedAllotQunatity(n);
                            continue block11;
                        }
                        case 3: {
                            onlineSku.setWH020600010195(safeStock);
                            onlineSku.setWH020600010195NeedAllotQunatity(n);
                            continue block11;
                        }
                        case 4: {
                            onlineSku.setWH000332910332(safeStock);
                            onlineSku.setWH000332910332NeedAllotQunatity(n);
                            continue block11;
                        }
                    }
                }
                if (!needAllot) continue;
                if (totalNeedAllotQuantity < 0) {
                    overStockMap = this.sortMapByValue(overStockMap, false);
                    for (Map.Entry<String, Integer> overStockEntry : overStockMap.entrySet()) {
                        Integer canAllotQuantity = overStockEntry.getValue();
                        for (Map.Entry entry : needStockMap.entrySet()) {
                            Integer needAllotQuantity = (Integer)entry.getValue();
                            if (canAllotQuantity <= 0 || needAllotQuantity <= 0) continue;
                            WhAutoAllotVO whAutoAllotVO = new WhAutoAllotVO();
                            whAutoAllotVO.setSourceWarehouseCode(overStockEntry.getKey());
                            whAutoAllotVO.setTargetWarehouseCode((String)entry.getKey());
                            whAutoAllotVO.setPlanedQuantity(needAllotQuantity);
                            whAutoAllotVO.setSkuCode(skuCode);
                            if (canAllotQuantity - needAllotQuantity >= 0) {
                                whAutoAllotVO.setAllotQuantity(needAllotQuantity);
                                canAllotQuantity = canAllotQuantity - needAllotQuantity;
                                entry.setValue(0);
                            } else {
                                whAutoAllotVO.setAllotQuantity(canAllotQuantity);
                                canAllotQuantity = 0;
                                entry.setValue(needAllotQuantity - canAllotQuantity);
                            }
                            arrayList.add(whAutoAllotVO);
                        }
                    }
                    continue;
                }
                int canUseQuantity = (Integer)skuCanUseStockMap.get(skuCode);
                HashMap<String, Integer> needAllotOutMap = new HashMap<String, Integer>();
                HashMap<String, Integer> needAllotInMap = new HashMap<String, Integer>();
                skuSafeStockMap = this.sortMapByValue(skuSafeStockMap, false);
                Integer alreadyAllotQuantity = 0;
                for (Map.Entry<String, Integer> safeStockEntry : skuSafeStockMap.entrySet()) {
                    int canAllotQuantity = canUseQuantity * safeStockEntry.getValue() / totalSafeStock;
                    alreadyAllotQuantity = alreadyAllotQuantity + canAllotQuantity;
                    String string = safeStockEntry.getKey();
                    int alreadyQuantity = (Integer)stockMap.get(string + ":" + skuCode);
                    if (canAllotQuantity == alreadyQuantity) continue;
                    if (canAllotQuantity < alreadyQuantity) {
                        needAllotOutMap.put(string, alreadyQuantity - canAllotQuantity);
                        continue;
                    }
                    needAllotInMap.put(string, canAllotQuantity - alreadyQuantity);
                }
                Integer n = canUseQuantity - alreadyAllotQuantity;
                boolean firstElm = true;
                for (Map.Entry<String, Integer> entry : skuSafeStockMap.entrySet()) {
                    if (!firstElm) continue;
                    Integer needAllotOutQuantity = (Integer)needAllotOutMap.get(entry.getKey());
                    Integer needAllotInQuantity = (EmptyUtil.isNotEmpty(needAllotInMap.get(entry.getKey())) ? (Integer)needAllotInMap.get(entry.getKey()) : 0) + n;
                    needAllotOutQuantity = needAllotOutQuantity == null ? 0 : needAllotOutQuantity;
                    needAllotInMap.put(entry.getKey(), needAllotInQuantity - needAllotOutQuantity);
                    needAllotOutMap.put(entry.getKey(), needAllotOutQuantity - needAllotInQuantity);
                    firstElm = false;
                    break;
                }
                block16: for (Map.Entry<String, Integer> entry : needAllotInMap.entrySet()) {
                    int needAllotQuantity = entry.getValue();
                    String targetWarehouseCode = entry.getKey();
                    for (Map.Entry entry2 : needAllotOutMap.entrySet()) {
                        int allotOutQuantity = (Integer)entry2.getValue();
                        String sourceWarehouseCode = (String)entry2.getKey();
                        if (targetWarehouseCode.equals(sourceWarehouseCode) || allotOutQuantity <= 0 || needAllotQuantity <= 0) continue;
                        WhAutoAllotVO whAutoAllotVO = new WhAutoAllotVO();
                        whAutoAllotVO.setSourceWarehouseCode(sourceWarehouseCode);
                        whAutoAllotVO.setTargetWarehouseCode(targetWarehouseCode);
                        whAutoAllotVO.setSkuCode(skuCode);
                        whAutoAllotVO.setPlanedQuantity((Integer)needStockMap.get(targetWarehouseCode));
                        if (allotOutQuantity == needAllotQuantity) {
                            whAutoAllotVO.setAllotQuantity(needAllotQuantity);
                            arrayList.add(whAutoAllotVO);
                            needAllotQuantity = 0;
                            entry.setValue(0);
                            entry2.setValue(0);
                            continue block16;
                        }
                        if (allotOutQuantity > needAllotQuantity) {
                            whAutoAllotVO.setAllotQuantity(needAllotQuantity);
                            arrayList.add(whAutoAllotVO);
                            entry.setValue(0);
                            entry2.setValue(allotOutQuantity - needAllotQuantity);
                            continue block16;
                        }
                        whAutoAllotVO.setAllotQuantity(allotOutQuantity);
                        arrayList.add(whAutoAllotVO);
                        entry.setValue(needAllotQuantity -= allotOutQuantity);
                        entry2.setValue(0);
                    }
                }
            }
            return this.buildAllotRcdOnLine(arrayList, operatorId);
        }
        return null;
    }

    private List<SSkuStockVO> pagingQueryStock(List<SSkuStockQueryDTO> skuStockQueryDTOList) {
        List temps = Lists.partition(skuStockQueryDTOList, (int)1000);
        ArrayList<SSkuStockVO> allStockList = new ArrayList<SSkuStockVO>();
        for (List subList : temps) {
            List stockList = this.sStockService.getSkuStocks(subList);
            if (!EmptyUtil.isNotEmpty((List)stockList)) continue;
            allStockList.addAll(stockList);
        }
        return allStockList;
    }

    private List<WhAllotRcd> buildAllotRcd(List<WhAutoAllotSkuVO> autoAllotSkuVOList) throws Exception {
        if (EmptyUtil.isNotEmpty(autoAllotSkuVOList)) {
            HashMap<String, ArrayList<WhAllotRcdSku>> allotRcdMap = new HashMap<String, ArrayList<WhAllotRcdSku>>();
            for (WhAutoAllotSkuVO autoAllotSkuVO : autoAllotSkuVOList) {
                String skuCode = autoAllotSkuVO.getSkuCode();
                List<WhAutoAllotGroupVO> groupList = autoAllotSkuVO.getGroupList();
                if (!EmptyUtil.isNotEmpty(groupList)) continue;
                for (WhAutoAllotGroupVO whAutoAllotGroupVO : groupList) {
                    List<WhAutoAllotGroupWhSortVO> groupWhList = whAutoAllotGroupVO.getGroupWhList();
                    if (!EmptyUtil.isNotEmpty(groupWhList)) continue;
                    for (WhAutoAllotGroupWhSortVO autoAllotGroupWhSortVO : groupWhList) {
                        int targetCanUseQuantity = autoAllotGroupWhSortVO.getCanUseQuantity();
                        String targetWarehouseCode = autoAllotGroupWhSortVO.getWarehouseCode();
                        WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
                        whAllotRcdSku.setSkuCode(skuCode);
                        whAllotRcdSku.setPlanedQuantity(autoAllotGroupWhSortVO.getPlanAllotQuantity());
                        whAllotRcdSku.setQuantity(targetCanUseQuantity);
                        ArrayList<WhAllotRcdSku> allotRcdSkuList = (ArrayList<WhAllotRcdSku>)allotRcdMap.get(targetWarehouseCode);
                        if (allotRcdSkuList == null) {
                            allotRcdSkuList = new ArrayList<WhAllotRcdSku>();
                        }
                        allotRcdSkuList.add(whAllotRcdSku);
                        allotRcdMap.put(targetWarehouseCode, allotRcdSkuList);
                    }
                }
            }
            if (EmptyUtil.isNotEmpty(allotRcdMap)) {
                ArrayList<WhAllotRcd> rcdList = new ArrayList<WhAllotRcd>();
                List<String> warehouseCodeList = this.removeSameGroupWh(new ArrayList<String>(allotRcdMap.keySet()));
                HashMap whPhysicalWarehouseMap = warehouseCodeList.size() == 0 ? new HashMap() : this.whInfoService.findPhyWhMapByWarehouseCodes(new LinkedList<String>(warehouseCodeList));
                for (Map.Entry entry : allotRcdMap.entrySet()) {
                    String targetWarehouseCode = (String)entry.getKey();
                    List allotRcdSkuList = (List)entry.getValue();
                    WhAllotRcd whAllotRcd = new WhAllotRcd();
                    whAllotRcd.setSourcePhysicalWarehouseCode("WH02060001");
                    whAllotRcd.setSourceWarehouseCode(WAREHOUSECODE);
                    WhPhysicalWarehouse whPhysicalWarehouse = (WhPhysicalWarehouse)whPhysicalWarehouseMap.get(targetWarehouseCode);
                    whAllotRcd.setTargetPhysicalWarehouseCode(EmptyUtil.isNotEmpty((Object)whPhysicalWarehouse) ? whPhysicalWarehouse.getCode() : "WH02060001");
                    whAllotRcd.setTargetWarehouseCode(targetWarehouseCode);
                    whAllotRcd.setAllotType(WhAllotTypeEnum.AUTO_ALLOT.getVal());
                    whAllotRcd.setRemark("\u81ea\u52a8\u5206\u8d27\u8c03\u62e8");
                    whAllotRcd.setWhAllotRcdSkuList(allotRcdSkuList);
                    rcdList.add(whAllotRcd);
                }
                return rcdList;
            }
        }
        return null;
    }

    private List<String> removeSameGroupWh(List<String> warehouseCodeList) {
        ArrayList<String> whCodeList = new ArrayList<String>();
        List<WhWarehouse> whWarehouseList = this.whInfoService.findWarehouseByCodes(warehouseCodeList);
        if (EmptyUtil.isNotEmpty(whWarehouseList)) {
            int listSize = whWarehouseList.size();
            for (int i = 0; i < listSize; ++i) {
                WhWarehouse whWarehouse = whWarehouseList.get(i);
                if (whWarehouse.getWarehouseGroupId().equals(Constants.PHYSICAL_WAREHOUSE_DEFAULT_GROUP_ID)) continue;
                whCodeList.add(whWarehouse.getCode());
            }
        }
        return whCodeList;
    }

    private List<WhAllotRcd> buildAllotRcdOnLine(List<WhAutoAllotVO> autoAllotList, Long operatorId) {
        ArrayList<WhAllotRcd> rcdList = new ArrayList<WhAllotRcd>();
        HashSet<String> rcdKeyList = new HashSet<String>();
        for (WhAutoAllotVO whAutoAllotVO : autoAllotList) {
            rcdKeyList.add(whAutoAllotVO.getSourceWarehouseCode() + ":" + whAutoAllotVO.getTargetWarehouseCode());
        }
        for (String rcdKey : rcdKeyList) {
            WhAllotRcd whAllotRcd = new WhAllotRcd();
            String[] rcdWarehouseCodeArray = rcdKey.split(":");
            whAllotRcd.setSourcePhysicalWarehouseCode("WH02060001");
            whAllotRcd.setSourceWarehouseCode(rcdWarehouseCodeArray[0]);
            whAllotRcd.setTargetWarehouseCode(rcdWarehouseCodeArray[1]);
            whAllotRcd.setTargetPhysicalWarehouseCode("WH02060001");
            whAllotRcd.setAllotType(WhAllotTypeEnum.AUTO_ALLOT_ONLINE.getVal());
            whAllotRcd.setCreateUserId(operatorId == null ? null : Integer.valueOf(operatorId.intValue()));
            whAllotRcd.setRemark("\u7ebf\u4e0a\u81ea\u52a8\u5206\u8d27\u8c03\u62e8");
            ArrayList<WhAllotRcdSku> whAllotRcdSkuList = new ArrayList<WhAllotRcdSku>();
            for (WhAutoAllotVO whAutoAllotVO : autoAllotList) {
                if (!rcdKey.equals(whAutoAllotVO.getSourceWarehouseCode() + ":" + whAutoAllotVO.getTargetWarehouseCode())) continue;
                WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
                whAllotRcdSku.setQuantity(whAutoAllotVO.getAllotQuantity());
                whAllotRcdSku.setSkuCode(whAutoAllotVO.getSkuCode());
                whAllotRcdSku.setPlanedQuantity(whAutoAllotVO.getAllotQuantity());
                whAllotRcdSkuList.add(whAllotRcdSku);
            }
            whAllotRcd.setWhAllotRcdSkuList(whAllotRcdSkuList);
            rcdList.add(whAllotRcd);
        }
        return rcdList;
    }

    private void buildCanAllotQunatity(List<WhAutoAllotSkuVO> autoAllotSkuVOList) {
        if (EmptyUtil.isNotEmpty(autoAllotSkuVOList)) {
            for (WhAutoAllotSkuVO autoAllotSkuVO : autoAllotSkuVOList) {
                List<WhAutoAllotGroupVO> groupList;
                int planAllotQuantity = autoAllotSkuVO.getPlanAllotQuantity();
                int canUseQuantity = autoAllotSkuVO.getCanUseQuantity();
                if (canUseQuantity < planAllotQuantity && planAllotQuantity > 0) {
                    groupList = autoAllotSkuVO.getGroupList();
                    for (WhAutoAllotGroupVO whAutoAllotGroupVO : groupList) {
                        int targetCanUseQuantity;
                        int targetWhPlanAllotQunatity;
                        Integer groupCanUseQuantity = (int)Math.floor(canUseQuantity * whAutoAllotGroupVO.getPlanAllotQuantity() / planAllotQuantity);
                        int groupPlanAllotQunatity = whAutoAllotGroupVO.getPlanAllotQuantity();
                        if (groupPlanAllotQunatity <= 0) continue;
                        whAutoAllotGroupVO.setCanUseQuantity(groupCanUseQuantity);
                        List<WhAutoAllotGroupWhSortVO> groupWhList = whAutoAllotGroupVO.getGroupWhList();
                        int overQuantity = groupCanUseQuantity;
                        for (WhAutoAllotGroupWhSortVO autoAllotGroupWhSortVO : groupWhList) {
                            targetWhPlanAllotQunatity = autoAllotGroupWhSortVO.getPlanAllotQuantity();
                            targetCanUseQuantity = (int)Math.floor(groupCanUseQuantity * targetWhPlanAllotQunatity / groupPlanAllotQunatity);
                            autoAllotGroupWhSortVO.setCanUseQuantity(targetCanUseQuantity);
                            overQuantity -= targetCanUseQuantity;
                        }
                        Collections.sort(groupWhList);
                        if (overQuantity <= 0) continue;
                        for (WhAutoAllotGroupWhSortVO autoAllotGroupWhSortVO : groupWhList) {
                            targetWhPlanAllotQunatity = autoAllotGroupWhSortVO.getPlanAllotQuantity();
                            int lessQuantity = targetWhPlanAllotQunatity - (targetCanUseQuantity = autoAllotGroupWhSortVO.getCanUseQuantity().intValue());
                            if (lessQuantity <= 0) continue;
                            if (overQuantity <= lessQuantity) {
                                autoAllotGroupWhSortVO.setCanUseQuantity(targetCanUseQuantity + overQuantity);
                                overQuantity = 0;
                                continue;
                            }
                            autoAllotGroupWhSortVO.setCanUseQuantity(targetCanUseQuantity + lessQuantity);
                            overQuantity -= lessQuantity;
                        }
                    }
                    continue;
                }
                groupList = autoAllotSkuVO.getGroupList();
                for (WhAutoAllotGroupVO whAutoAllotGroupVO : groupList) {
                    whAutoAllotGroupVO.setCanUseQuantity(whAutoAllotGroupVO.getPlanAllotQuantity());
                    List<WhAutoAllotGroupWhSortVO> groupWhList = whAutoAllotGroupVO.getGroupWhList();
                    for (WhAutoAllotGroupWhSortVO autoAllotGroupWhSortVO : groupWhList) {
                        autoAllotGroupWhSortVO.setCanUseQuantity(autoAllotGroupWhSortVO.getPlanAllotQuantity());
                    }
                }
            }
        }
    }

    private void bulidCanUseQuantity(List<String> skuCodes, List<WhAutoAllotSkuVO> autoAllotSkuVOList, List<WhAutoAllotCallbackExcludeCategory> callbackExcludeCategoryList, List<WhAutoAllotCallbackWh> callbackWhList, boolean isCallback) throws Exception {
        Map stockMap = this.sStockService.getSkuStocks(skuCodes, WAREHOUSECODE);
        if (EmptyUtil.isNotEmpty(autoAllotSkuVOList)) {
            for (WhAutoAllotSkuVO whAutoAllotSkuVO : autoAllotSkuVOList) {
                String skuCode = whAutoAllotSkuVO.getSkuCode();
                SSkuStockVO skuStockVO = (SSkuStockVO)stockMap.get(skuCode);
                whAutoAllotSkuVO.setCanUseQuantity(skuStockVO.getCanUseQuantity());
            }
            if (!isCallback) {
                isCallback = this.callBackStock(skuCodes, callbackWhList, stockMap, callbackExcludeCategoryList);
                this.bulidCanUseQuantity(skuCodes, autoAllotSkuVOList, null, callbackWhList, isCallback);
            }
        }
    }

    private boolean callBackStock(List<String> skuCodes, List<WhAutoAllotCallbackWh> callbackWhList, Map<String, SSkuStockVO> stockMap, List<WhAutoAllotCallbackExcludeCategory> callbackExcludeCategoryList) throws Exception {
        if (EmptyUtil.isNotEmpty(callbackWhList)) {
            Map stockVOMap;
            ArrayList<String> warehouseCodeList = new ArrayList<String>();
            for (WhAutoAllotCallbackWh autoAllotCallbackWh : callbackWhList) {
                warehouseCodeList.add(autoAllotCallbackWh.getWarehouseCode());
            }
            Map<String, PcsSkuDTO> skuDTOMap = this.pagingQuerySku(new HashSet<String>(skuCodes));
            if (EmptyUtil.isNotEmpty(skuCodes)) {
                ArrayList<Long> allbackExcludeCategoryIds = new ArrayList<Long>();
                if (EmptyUtil.isNotEmpty(callbackExcludeCategoryList)) {
                    for (WhAutoAllotCallbackExcludeCategory whAutoAllotCallbackExcludeCategory : callbackExcludeCategoryList) {
                        allbackExcludeCategoryIds.add(whAutoAllotCallbackExcludeCategory.getCategoryId().longValue());
                    }
                }
                ArrayList<String> needCallbackSkuList = new ArrayList<String>();
                for (String string : skuCodes) {
                    PcsSkuDTO pcsSkuDTO = skuDTOMap.get(string);
                    if (!EmptyUtil.isEmpty((Object)pcsSkuDTO) && allbackExcludeCategoryIds.contains(pcsSkuDTO.getCategoryId())) continue;
                    needCallbackSkuList.add(string);
                }
                skuCodes = needCallbackSkuList;
            }
            if (EmptyUtil.isNotEmpty((Map)(stockVOMap = this.sStockService.getSkuStocks(skuCodes, warehouseCodeList)))) {
                ArrayList<WhAllotRcd> rcdList = new ArrayList<WhAllotRcd>();
                for (Map.Entry entry : stockVOMap.entrySet()) {
                    String warehouseCode = (String)entry.getKey();
                    ArrayList<WhAllotRcdSku> whAllotRcdSkuList = new ArrayList<WhAllotRcdSku>();
                    Map skuStockMap = (Map)entry.getValue();
                    for (Map.Entry skuStockEntry : skuStockMap.entrySet()) {
                        String skuCode = (String)skuStockEntry.getKey();
                        SSkuStockVO skuStockVO = (SSkuStockVO)skuStockEntry.getValue();
                        int canUseQuantity = skuStockVO.getCanUseQuantity();
                        if (canUseQuantity <= 0) continue;
                        WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
                        whAllotRcdSku.setPlanedQuantity(skuStockVO.getCanUseQuantity());
                        whAllotRcdSku.setQuantity(skuStockVO.getCanUseQuantity());
                        whAllotRcdSku.setSkuCode(skuCode);
                        whAllotRcdSkuList.add(whAllotRcdSku);
                        SSkuStockVO canAllotStock = stockMap.get(skuCode);
                        canAllotStock.setCanUseQuantity(Integer.valueOf(canAllotStock.getCanUseQuantity() + canUseQuantity));
                    }
                    if (!EmptyUtil.isNotEmpty(whAllotRcdSkuList)) continue;
                    WhAllotRcd whAllotRcd = new WhAllotRcd();
                    whAllotRcd.setSourcePhysicalWarehouseCode("WH02060001");
                    whAllotRcd.setSourceWarehouseCode(warehouseCode);
                    whAllotRcd.setTargetPhysicalWarehouseCode("WH02060001");
                    whAllotRcd.setTargetWarehouseCode(WAREHOUSECODE);
                    whAllotRcd.setAllotType(WhAllotTypeEnum.AUTO_ALLOT.getVal());
                    whAllotRcd.setRemark("\u81ea\u52a8\u5206\u8d27\u56de\u8c03\u5e93\u5b58");
                    whAllotRcd.setWhAllotRcdSkuList(whAllotRcdSkuList);
                    rcdList.add(whAllotRcd);
                }
                this.whAllotService.createAllotRcds(rcdList);
            }
        }
        return true;
    }

    private List<WhAutoAllotSkuVO> buildSkuPlanQuantityVO(Map<String, WhAutoAllotGroupSort> groupSortMap, Map<String, List<Map<String, List<String>>>> skuMap, Map<String, Integer> planMap, Map<String, Set<String>> skuGroupMap, Map<String, Integer> invQttMap) {
        ArrayList<WhAutoAllotSkuVO> autoAllotSkuVOList = new ArrayList<WhAutoAllotSkuVO>();
        if (EmptyUtil.isNotEmpty(skuMap)) {
            for (Map.Entry<String, List<Map<String, List<String>>>> skuEntry : skuMap.entrySet()) {
                String skuCode = skuEntry.getKey();
                WhAutoAllotSkuVO autoAllotSkuVO = new WhAutoAllotSkuVO();
                autoAllotSkuVO.setSkuCode(skuCode);
                Set<String> groupSet = skuGroupMap.get(skuCode);
                ArrayList<WhAutoAllotGroupVO> groupList = new ArrayList<WhAutoAllotGroupVO>();
                List<Map<String, List<String>>> targetWhList = skuEntry.getValue();
                for (String group : groupSet) {
                    WhAutoAllotGroupVO autoAllotGroupVO = new WhAutoAllotGroupVO();
                    autoAllotGroupVO.setOwnGroup(group);
                    ArrayList<WhAutoAllotGroupWhSortVO> groupWhList = new ArrayList<WhAutoAllotGroupWhSortVO>();
                    if (EmptyUtil.isNotEmpty(targetWhList)) {
                        for (Map<String, List<String>> targetWhMap : targetWhList) {
                            for (Map.Entry<String, List<String>> targetEntry : targetWhMap.entrySet()) {
                                String targetWhCode = targetEntry.getKey();
                                WhAutoAllotGroupSort whAutoAllotGroupSort = groupSortMap.get(targetWhCode);
                                String ownGroup = whAutoAllotGroupSort.getOwnGroup();
                                if (!ownGroup.equals(group)) continue;
                                WhAutoAllotGroupWhSortVO whAutoAllotGroupWhSortVO = new WhAutoAllotGroupWhSortVO();
                                whAutoAllotGroupWhSortVO.setWarehouseCode(targetWhCode);
                                whAutoAllotGroupWhSortVO.setPriorityInGroup(whAutoAllotGroupSort.getPriorityInGroup());
                                String allotOnTheWayKey = new StringBuffer().append(targetWhCode).append(":").append(skuCode).toString();
                                whAutoAllotGroupWhSortVO.setAllotOnTheWayQunatity(invQttMap.containsKey(allotOnTheWayKey) ? invQttMap.get(allotOnTheWayKey) : 0);
                                ArrayList<WhAutoAllotCalculateWhVO> calculateWhList = new ArrayList<WhAutoAllotCalculateWhVO>();
                                List<String> calculateWhCodeList = targetEntry.getValue();
                                for (String calculateCode : calculateWhCodeList) {
                                    WhAutoAllotCalculateWhVO allotCalculateWhVO = new WhAutoAllotCalculateWhVO();
                                    allotCalculateWhVO.setCalculateWarehouseCode(calculateCode);
                                    String key = new StringBuffer().append(calculateCode).append(":").append(skuCode).toString();
                                    allotCalculateWhVO.setPlanAllotQuantity(planMap.get(key) == null ? 0 : planMap.get(key));
                                    calculateWhList.add(allotCalculateWhVO);
                                }
                                whAutoAllotGroupWhSortVO.setCalculateWhList(calculateWhList);
                                groupWhList.add(whAutoAllotGroupWhSortVO);
                            }
                        }
                    }
                    autoAllotGroupVO.setGroupWhList(groupWhList);
                    groupList.add(autoAllotGroupVO);
                }
                autoAllotSkuVO.setGroupList(groupList);
                autoAllotSkuVOList.add(autoAllotSkuVO);
            }
        }
        return autoAllotSkuVOList;
    }

    private Map<String, WhAutoAllotGroupSort> buildGroupSortMap(List<WhAutoAllotGroupSort> groupSortList) {
        HashMap<String, WhAutoAllotGroupSort> groupSortMap = new HashMap<String, WhAutoAllotGroupSort>();
        for (WhAutoAllotGroupSort whAutoAllotGroupSort : groupSortList) {
            groupSortMap.put(whAutoAllotGroupSort.getWarehouseCode(), whAutoAllotGroupSort);
        }
        return groupSortMap;
    }

    @Override
    public WhAutoAllotRuleVO findCurrentRule(String bu, boolean cascade) {
        List<WhAutoAllotRuleVO> ruleList = this.whAutoAllotRuleMapper.selectCurrentRules(bu, (short)0);
        if (EmptyUtil.isNotEmpty(ruleList)) {
            WhAutoAllotRuleVO currentRule = ruleList.get(0);
            if (cascade) {
                Integer ruleId = currentRule.getId();
                currentRule.setSkuList(this.whAutoAllotSkuMapper.selectByRuleId(ruleId));
                currentRule.setCallbackWhList(this.whAutoAllotCallbackWhMapper.selectByRuleId(ruleId));
                currentRule.setGroupSortList(this.whAutoAllotGroupSortMapper.selectByRuleId(ruleId));
                currentRule.setCallbackExcludeCategoryList(this.whAutoAllotCallbackExcludeCategoryMapper.selectByRuleId(ruleId));
            }
            return currentRule;
        }
        return null;
    }

    @Override
    public WhAutoAllotRuleVO findCurrentRuleOnline(boolean cascade) {
        List<WhAutoAllotRuleVO> ruleList = this.whAutoAllotRuleMapper.selectCurrentRules(null, (short)1);
        if (EmptyUtil.isNotEmpty(ruleList)) {
            WhAutoAllotRuleVO currentRule = ruleList.get(0);
            if (cascade) {
                Integer ruleId = currentRule.getId();
                currentRule.setSkuList(this.whAutoAllotSkuMapper.selectByRuleId(ruleId));
                currentRule.setExcludeCategoryList(this.whAutoAllotExcludeCategoryMapper.selectByRuleId(ruleId));
            }
            return currentRule;
        }
        return null;
    }

    @Override
    public PageInfo<WhAutoAllotRecordVO> findAutoAllotRecords(WhAutoAllotCond whAutoAllotCond) {
        int offset = whAutoAllotCond.getCurrpage() * whAutoAllotCond.getPagenum();
        PageRowBounds pageRowBounds = new PageRowBounds(offset, whAutoAllotCond.getPagenum().intValue());
        PageInfo pageInfo = new PageInfo(this.whAutoAllotRecordMapper.selectAutoAllotRecords(whAutoAllotCond, pageRowBounds));
        pageInfo.setTotal(pageRowBounds.getTotal().longValue());
        return pageInfo;
    }

    @Override
    public List<WhAutoAllotRecordDetailVO> findDetailByRecordId(Integer recordId) {
        return this.whAutoAllotRecordDetailMapper.selectDetailByRecordId(recordId);
    }

    @Override
    @Transactional
    public Set<String> confirmExecuteAutoAllot(Integer recordId) throws Exception {
        WhAutoAllotRecord whAutoAllotRecord = this.whAutoAllotRecordMapper.selectByPrimaryKey(recordId);
        whAutoAllotRecord.setAllotStatus((short)WhAutoAllotStatusEnum.COMPLETED.getVal());
        this.whAutoAllotRecordMapper.updateByPrimaryKeySelective(whAutoAllotRecord);
        Set<String> allotRcdCodeList = this.findAllotRcdCodeByRecordId(recordId);
        if (allotRcdCodeList != null) {
            for (String allotRcdCode : allotRcdCodeList) {
                this.whAllotService.confirmExecuteAutoAllot(allotRcdCode);
            }
            return allotRcdCodeList;
        }
        return null;
    }

    private Set<String> findAllotRcdCodeByRecordId(Integer recordId) {
        List<WhAutoAllotRecordDetailVO> detailList = this.findDetailByRecordId(recordId);
        if (detailList != null) {
            HashSet<String> allotRcdCodeList = new HashSet<String>();
            for (WhAutoAllotRecordDetailVO detailVO : detailList) {
                if (!EmptyUtil.isNotEmpty((String)detailVO.getAllotRcdCode())) continue;
                allotRcdCodeList.add(detailVO.getAllotRcdCode());
            }
            return allotRcdCodeList;
        }
        return null;
    }

    @Override
    @Transactional
    public Set<String> cancleExecuteAutoAllot(Integer recordId) throws Exception {
        WhAutoAllotRecord whAutoAllotRecord = this.whAutoAllotRecordMapper.selectByPrimaryKey(recordId);
        whAutoAllotRecord.setAllotStatus((short)WhAutoAllotStatusEnum.CANCLE.getVal());
        this.whAutoAllotRecordMapper.updateByPrimaryKeySelective(whAutoAllotRecord);
        Set<String> allotRcdCodeList = this.findAllotRcdCodeByRecordId(recordId);
        if (allotRcdCodeList != null) {
            for (String allotRcdCode : allotRcdCodeList) {
                this.whAllotService.cancelAllotRcdByCode(allotRcdCode);
            }
            return allotRcdCodeList;
        }
        return null;
    }

    @Override
    public List<String> checkWhetherNeedAutoAllot(List<String> skuCodes, String warehouseCode) {
        WhAutoAllotRuleVO whAutoAllotRuleVO = this.findCurrentRule(null, false);
        if (whAutoAllotRuleVO == null) {
            return new ArrayList<String>();
        }
        WhAutoAllotSkuExample example = new WhAutoAllotSkuExample();
        example.createCriteria().andSkuCodeIn((List)skuCodes).andTargetWarehouseCodeEqualTo(warehouseCode).andRuleIdEqualTo(whAutoAllotRuleVO.getId());
        List<WhAutoAllotSku> list = this.whAutoAllotSkuMapper.selectByExample(example);
        if (EmptyUtil.isEmpty(list)) {
            return new ArrayList<String>();
        }
        ArrayList<String> results = new ArrayList<String>();
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            results.add(list.get(i).getSkuCode());
        }
        return results;
    }

    @Override
    public void autoAllotForLbLimitSale() {
        List<WhLbLimitAllotSku> allotSkus = this.getTodayLbLimitAllotSkus();
        List<String> warehouseCodeList = allotSkus.stream().map(allotSku -> allotSku.getWarehouseCode()).collect(Collectors.toList());
        HashMap whPhysicalWarehouseMap = (warehouseCodeList = this.removeSameGroupWh(warehouseCodeList)).size() == 0 ? new HashMap() : this.whInfoService.findPhyWhMapByWarehouseCodes(new LinkedList<String>(warehouseCodeList));
        allotSkus.stream().forEach(allotSku -> this.buildAllotRcd((WhLbLimitAllotSku)allotSku, whPhysicalWarehouseMap));
    }

    private List<WhLbLimitAllotSku> getTodayLbLimitAllotSkus() {
        String today = new StringBuffer().append(DateUtil.getCurrMonth()).append("\u6708").append(DateUtil.getCurrDayOfMonth()).append("\u65e5").toString();
        WhLbLimitAllotSkuExample example = new WhLbLimitAllotSkuExample();
        example.createCriteria().andLimitDateEqualTo(today);
        return this.whLbLimitAllotSkuMapper.selectByExample(example);
    }

    private void buildAllotRcd(WhLbLimitAllotSku allotSku, Map<String, WhPhysicalWarehouse> whPhysicalWarehouseMap) {
        try {
            if (allotSku != null && allotSku.getLimitQuantity() != null && allotSku.getLimitQuantity() > 0) {
                WhAllotRcd rcd = new WhAllotRcd();
                rcd.setSourceWarehouseCode(WAREHOUSECODE);
                rcd.setSourcePhysicalWarehouseCode("WH02060001");
                String targetWarehouseCode = allotSku.getWarehouseCode();
                rcd.setTargetPhysicalWarehouseCode(whPhysicalWarehouseMap.containsKey(targetWarehouseCode) ? whPhysicalWarehouseMap.get(targetWarehouseCode).getCode() : "WH02060001");
                rcd.setTargetWarehouseCode(targetWarehouseCode);
                rcd.setAllotType(WhAllotTypeEnum.TYPE_NORMAL.getVal());
                rcd.setCreateUserId(1);
                rcd.setRemark("LB\u95e8\u5e97\u95e8\u5e97\u9650\u91cf\u6d3b\u52a8\uff0c\u7cfb\u7edf\u81ea\u52a8\u8c03\u62e8");
                rcd.setEstimatedAllocationDate(new Date());
                ArrayList<WhAllotRcdSku> whAllotRcdSkuList = new ArrayList<WhAllotRcdSku>();
                WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
                whAllotRcdSku.setQuantity(allotSku.getLimitQuantity());
                whAllotRcdSku.setSkuCode(allotSku.getSkuCode());
                whAllotRcdSkuList.add(whAllotRcdSku);
                rcd.setWhAllotRcdSkuList(whAllotRcdSkuList);
                this.whAllotService.createAllotRcd(rcd);
            }
        }
        catch (Exception e) {
            logger.error("LB\u5546\u54c1\u9650\u91cf\u9500\u552e\u5206\u8d27\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)allotSku), (Object)e);
        }
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.getCurrMonth());
        System.out.println(DateUtil.getCurrDayOfMonth());
    }

    private int saveExcludeCategory(WhAutoAllotRuleVO whAutoAllotRule, Integer currentRuleId) {
        Integer ruleId = whAutoAllotRule.getId();
        if (ruleId == null) {
            throw new WarehouseException("ruleId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<WhAutoAllotExcludeCategory> excludeCategoryList = whAutoAllotRule.getExcludeCategoryList();
        if (whAutoAllotRule.getOptType() == 2 && currentRuleId != null) {
            excludeCategoryList = this.whAutoAllotExcludeCategoryMapper.selectByRuleId(currentRuleId);
        }
        if (EmptyUtil.isNotEmpty(excludeCategoryList)) {
            for (WhAutoAllotExcludeCategory excludeCategory : excludeCategoryList) {
                excludeCategory.setRuleId(ruleId);
            }
            return this.whAutoAllotExcludeCategoryMapper.batchInsert(excludeCategoryList);
        }
        return 1;
    }

    private int saveCallbackExcludeCategory(WhAutoAllotRuleVO whAutoAllotRule, Integer currentRuleId) {
        Integer ruleId = whAutoAllotRule.getId();
        if (ruleId == null) {
            throw new WarehouseException("ruleId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<WhAutoAllotCallbackExcludeCategory> excludeCategoryList = whAutoAllotRule.getCallbackExcludeCategoryList();
        if (whAutoAllotRule.getOptType() == 2 && currentRuleId != null) {
            excludeCategoryList = this.whAutoAllotCallbackExcludeCategoryMapper.selectByRuleId(currentRuleId);
        }
        if (EmptyUtil.isNotEmpty(excludeCategoryList)) {
            for (WhAutoAllotCallbackExcludeCategory excludeCategory : excludeCategoryList) {
                excludeCategory.setRuleId(ruleId);
            }
            return this.whAutoAllotCallbackExcludeCategoryMapper.batchInsert(excludeCategoryList);
        }
        return 1;
    }

    private int saveGroupSort(WhAutoAllotRuleVO whAutoAllotRule, Integer currentRuleId) {
        Integer ruleId = whAutoAllotRule.getId();
        if (ruleId == null) {
            throw new WarehouseException("ruleId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<WhAutoAllotGroupSort> groupSortList = whAutoAllotRule.getGroupSortList();
        if (whAutoAllotRule.getOptType() == 1 && currentRuleId != null) {
            groupSortList = this.whAutoAllotGroupSortMapper.selectByRuleId(currentRuleId);
        }
        if (EmptyUtil.isNotEmpty(groupSortList)) {
            for (WhAutoAllotGroupSort groupSort : groupSortList) {
                groupSort.setRuleId(ruleId);
            }
            return this.whAutoAllotGroupSortMapper.batchInsert(groupSortList);
        }
        return 1;
    }

    private int saveCallbackWh(WhAutoAllotRuleVO whAutoAllotRule, Integer currentRuleId) {
        Integer ruleId = whAutoAllotRule.getId();
        if (ruleId == null) {
            throw new WarehouseException("ruleId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<WhAutoAllotCallbackWh> callbackWhList = whAutoAllotRule.getCallbackWhList();
        if (whAutoAllotRule.getOptType() == 1 && currentRuleId != null) {
            callbackWhList = this.whAutoAllotCallbackWhMapper.selectByRuleId(currentRuleId);
        }
        if (EmptyUtil.isNotEmpty(callbackWhList)) {
            for (WhAutoAllotCallbackWh callbackWh : callbackWhList) {
                callbackWh.setRuleId(ruleId);
            }
            return this.whAutoAllotCallbackWhMapper.batchInsert(callbackWhList);
        }
        return 1;
    }

    private int saveAllotSku(WhAutoAllotRuleVO whAutoAllotRule, Integer currentRuleId) {
        Integer ruleId = whAutoAllotRule.getId();
        if (ruleId == null) {
            throw new WarehouseException("ruleId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<WhAutoAllotSku> skuList = whAutoAllotRule.getSkuList();
        if (whAutoAllotRule.getOptType() == 1 && currentRuleId != null) {
            skuList = this.whAutoAllotSkuMapper.selectByRuleId(currentRuleId);
        }
        if (EmptyUtil.isNotEmpty(skuList)) {
            for (WhAutoAllotSku allotSku : skuList) {
                allotSku.setRuleId(ruleId);
            }
            return this.whAutoAllotSkuMapper.batchInsert(skuList);
        }
        return 1;
    }

    private void buildRealAllotQuantity(List<WhAllotRcd> preRcds, List<WhAllotRcd> rcds) {
        if (preRcds != null && preRcds.size() > 0) {
            int preSize = preRcds.size();
            block0: for (int i = 0; i < preSize; ++i) {
                WhAllotRcd preRcd = preRcds.get(i);
                WhAllotRcd rcd = rcds.get(i);
                List<WhAllotRcdSku> preRcdSkuList = preRcd.getWhAllotRcdSkuList();
                if (preRcdSkuList == null || preRcdSkuList.size() <= 0) continue;
                List<WhAllotRcdSku> rcdSkuList = rcd.getWhAllotRcdSkuList();
                for (WhAllotRcdSku prRcdSku : preRcdSkuList) {
                    boolean allotSuccess = false;
                    if (rcdSkuList == null || rcdSkuList.size() == 0) {
                        prRcdSku.setQuantity(0);
                        continue block0;
                    }
                    for (WhAllotRcdSku rcdSku : rcdSkuList) {
                        if (!prRcdSku.getSkuCode().equals(rcdSku.getSkuCode())) continue;
                        allotSuccess = true;
                        break;
                    }
                    if (allotSuccess) continue;
                    prRcdSku.setQuantity(0);
                }
            }
        }
    }

    private String generatorRecordLineCode(Integer recodeLineId) {
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("createTime", DateUtil.getNow());
        params.put("id", recodeLineId);
        return CodeGenerator.getInstance().generate("AUTO_ALLOT_RECORD_LINE_CODE", params);
    }

    public Map<String, Integer> sortMapByValue(Map<String, Integer> oriMap, boolean asc) {
        if (oriMap == null || oriMap.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Integer> sortedMap = new LinkedHashMap<String, Integer>();
        ArrayList<Map.Entry<String, Integer>> entryList = new ArrayList<Map.Entry<String, Integer>>(oriMap.entrySet());
        Collections.sort(entryList, asc ? new MapValueComparator() : new MapValueComparatorDesc());
        Iterator iter = entryList.iterator();
        Map.Entry tmpEntry = null;
        while (iter.hasNext()) {
            tmpEntry = (Map.Entry)iter.next();
            sortedMap.put((String)tmpEntry.getKey(), (Integer)tmpEntry.getValue());
        }
        return sortedMap;
    }

    class MapValueComparatorDesc
    implements Comparator<Map.Entry<String, Integer>> {
        MapValueComparatorDesc() {
        }

        @Override
        public int compare(Map.Entry<String, Integer> me1, Map.Entry<String, Integer> me2) {
            return -me1.getValue().compareTo(me2.getValue());
        }
    }

    class MapValueComparator
    implements Comparator<Map.Entry<String, Integer>> {
        MapValueComparator() {
        }

        @Override
        public int compare(Map.Entry<String, Integer> me1, Map.Entry<String, Integer> me2) {
            return me1.getValue().compareTo(me2.getValue());
        }
    }
}

