/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageRowBounds;
import com.google.common.collect.Lists;
import com.thebeastshop.commdata.service.ChannelQueryService;
import com.thebeastshop.commdata.vo.ChannelWarehouseVO;
import com.thebeastshop.common.exception.BusinessException;
import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuDTO;
import com.thebeastshop.pegasus.service.warehouse.cond.WhAllotStoreApplicationCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhAllotStoreApplicationMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhAllotStoreApplicationSkuMapper;
import com.thebeastshop.pegasus.service.warehouse.enums.WhAllotStoreApplicationRejectTypeEnum;
import com.thebeastshop.pegasus.service.warehouse.enums.WhAllotStoreApplicationStatusEnum;
import com.thebeastshop.pegasus.service.warehouse.enums.WhAllotTypeEnum;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotRcdSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotStoreApplication;
import com.thebeastshop.pegasus.service.warehouse.model.WhAllotStoreApplicationSku;
import com.thebeastshop.pegasus.service.warehouse.service.WhAllotService;
import com.thebeastshop.pegasus.service.warehouse.service.WhAllotStoreApplicationService;
import com.thebeastshop.pegasus.service.warehouse.service.WhAutoAllotService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhInvService;
import com.thebeastshop.pegasus.service.warehouse.service.WhTakeStockService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotStoreApplicationApproveVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotStoreApplicationRcdVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotStoreApplicationSkuRefusedDateVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotStoreApplicationSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhAllotStoreApplicationVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPhysicalWarehouseVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.stock.service.SPresaleService;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SSkuStockVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Service(value="whAllotStoreApplicationService")
public class WhAllotStoreApplicationServiceImpl
implements WhAllotStoreApplicationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WhAllotStoreApplicationService.class);
    @Autowired
    private WhAllotStoreApplicationMapper whAllotStoreApplicationMapper;
    @Autowired
    private WhAllotStoreApplicationSkuMapper whAllotStoreApplicationSkuMapper;
    @Autowired
    private SPresaleService sPresaleService;
    @Autowired
    private SStockService sStockService;
    @Autowired
    private McOpChannelService mcOpChannelService;
    @Autowired
    private McPcsSkuService mcPcsSkuService;
    @Autowired
    private WhAllotService whAllotService;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhAutoAllotService whAutoAllotService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private ChannelQueryService channelQueryService;
    @Autowired
    private WhTakeStockService whTakeStockService;
    @Autowired
    private WhInvService whInvService;

    @Override
    @Transactional
    public int applicationAllot(WhAllotStoreApplicationVO storeApplication) throws Exception {
        WhAllotStoreApplication storeApplicationDO = this.buildStoreApplicationVO2DO(storeApplication);
        String result = this.canApplyAllot(this.takeOutSkuCode(storeApplication.getSkuList()), storeApplication.getChannelCode());
        if (EmptyUtil.isNotEmpty((String)result)) {
            throw new WarehouseException("WH0001", result);
        }
        this.whAllotStoreApplicationMapper.insertSelective(storeApplicationDO);
        List<WhAllotStoreApplicationSku> skuList = this.buildStoreApplicationSkuVO2DO(storeApplication.getSkuList());
        this.setApplicationID2SkuDO(storeApplicationDO.getId(), skuList);
        this.whAllotStoreApplicationSkuMapper.batchInsert(skuList);
        return storeApplicationDO.getId();
    }

    @Override
    public PageInfo<WhAllotStoreApplicationSkuVO> listApplicationRecord(WhAllotStoreApplicationCond cond) {
        PageRowBounds pageRowBounds = new PageRowBounds(cond.getOffset().intValue(), cond.getPagenum().intValue());
        PageInfo pageInfo = new PageInfo();
        pageInfo.setList(this.whAllotStoreApplicationSkuMapper.selectByCond(cond, pageRowBounds));
        pageInfo.setTotal(pageRowBounds.getTotal().longValue());
        return pageInfo;
    }

    @Override
    public WhAllotStoreApplication findApplicationByKey(Integer id) {
        return this.whAllotStoreApplicationMapper.selectByPrimaryKey(id);
    }

    @Override
    public PageInfo<WhAllotStoreApplicationSkuVO> listApprovalListByCond(WhAllotStoreApplicationCond cond) {
        cond.setApplicationStatus(WhAllotStoreApplicationStatusEnum.APPROVAL.getStatus());
        PageRowBounds pageRowBounds = new PageRowBounds(cond.getOffset().intValue(), cond.getPagenum().intValue());
        PageInfo pageInfo = new PageInfo();
        List<WhAllotStoreApplicationSkuVO> list = this.whAllotStoreApplicationSkuMapper.selectApprovalListByCond(cond, pageRowBounds);
        this.buildApprovalListOtherInfo(list);
        pageInfo.setList(list);
        pageInfo.setTotal(pageRowBounds.getTotal().longValue());
        return pageInfo;
    }

    @Override
    public PageInfo<WhAllotStoreApplicationSkuVO> listChannelGroupApplicationBySkuCode(WhAllotStoreApplicationCond cond) {
        cond.setApplicationStatus(WhAllotStoreApplicationStatusEnum.APPROVAL.getStatus());
        PageRowBounds pageRowBounds = new PageRowBounds(cond.getOffset().intValue(), cond.getPagenum().intValue());
        PageInfo pageInfo = new PageInfo();
        List<WhAllotStoreApplicationSkuVO> list = this.whAllotStoreApplicationSkuMapper.selectChannelGroupApplicationBySkuCode(cond.getSkuCodes().get(0), pageRowBounds);
        this.buildApprovalListOtherInfo(list);
        pageInfo.setList(list);
        pageInfo.setTotal(pageRowBounds.getTotal().longValue());
        return pageInfo;
    }

    @Override
    @Transactional
    public int cancelApplication(Integer applicationLineId, Long cancelPerson) throws Exception {
        int ret = this.whAllotStoreApplicationSkuMapper.cancelApplication(applicationLineId, cancelPerson);
        if (ret != 1) {
            throw new WarehouseException("", "\u72b6\u6001\u5f02\u5e38\uff0c\u65e0\u6cd5\u53d6\u6d88\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5\uff01");
        }
        return 1;
    }

    @Override
    @Transactional
    public List<WhAllotStoreApplicationSkuVO> approve(WhAllotStoreApplicationApproveVO approveVO, Map<String, WhAllotStoreApplicationSkuRefusedDateVO> skuPurchaseOrderMap) throws Exception {
        List<Object> list = new ArrayList();
        list = approveVO.isPass() ? this.createAllotRcd(approveVO, skuPurchaseOrderMap) : this.rejectApplication(approveVO, skuPurchaseOrderMap);
        return list;
    }

    private void resolve(List<WhAllotStoreApplicationSkuVO> allotStoreApplicationSkuVOS) {
        String errorMsgResult = new String();
        HashMap<String, StringBuilder> skuErrorMsgMap = new HashMap<String, StringBuilder>();
        ArrayList needToSendEmailList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(allotStoreApplicationSkuVOS)) {
            Iterator<WhAllotStoreApplicationSkuVO> iterator = allotStoreApplicationSkuVOS.iterator();
            while (iterator.hasNext()) {
                WhAllotStoreApplicationSkuVO allotStoreApplicationSkuVO = iterator.next();
                List warehouseVOS = this.channelQueryService.getWarehouseByCode(allotStoreApplicationSkuVO.getChannelCode());
                if (CollectionUtils.isEmpty((Collection)warehouseVOS)) {
                    needToSendEmailList.add(allotStoreApplicationSkuVO);
                    if (skuErrorMsgMap.get(allotStoreApplicationSkuVO.getChannelCode() + "0") == null) {
                        skuErrorMsgMap.put(allotStoreApplicationSkuVO.getChannelCode() + "0", new StringBuilder(allotStoreApplicationSkuVO.getChannelCode() + "\u672a\u8bbe\u7f6e\u6e20\u9053\u5206\u8d27\u4ed3"));
                        ((StringBuilder)skuErrorMsgMap.get(allotStoreApplicationSkuVO.getChannelCode() + "0")).append("<br/>");
                    }
                    iterator.remove();
                    continue;
                }
                Integer checkMutiply = 0;
                for (ChannelWarehouseVO channelWarehouseVO : warehouseVOS) {
                    if (!channelWarehouseVO.getType().equals(2)) continue;
                    allotStoreApplicationSkuVO.setWarehouseForChannel(channelWarehouseVO.getCode());
                    Integer n = checkMutiply;
                    Integer n2 = checkMutiply = Integer.valueOf(checkMutiply + 1);
                }
                if (checkMutiply == 0) {
                    if (skuErrorMsgMap.get(allotStoreApplicationSkuVO.getChannelCode() + "0") == null) {
                        skuErrorMsgMap.put(allotStoreApplicationSkuVO.getChannelCode() + "0", new StringBuilder(allotStoreApplicationSkuVO.getChannelCode() + "\u672a\u8bbe\u7f6e\u6e20\u9053\u5206\u8d27\u4ed3"));
                        ((StringBuilder)skuErrorMsgMap.get(allotStoreApplicationSkuVO.getChannelCode() + "0")).append("<br/>");
                    }
                    needToSendEmailList.add(allotStoreApplicationSkuVO);
                }
                if (checkMutiply <= 1 || skuErrorMsgMap.get(allotStoreApplicationSkuVO.getChannelCode() + "1") != null) continue;
                skuErrorMsgMap.put(allotStoreApplicationSkuVO.getChannelCode(), new StringBuilder(allotStoreApplicationSkuVO.getChannelCode() + "\u5b58\u5728\u591a\u4e2a\u5206\u8d27\u4ed3\u4f4d"));
                ((StringBuilder)skuErrorMsgMap.get(allotStoreApplicationSkuVO.getChannelCode())).append("<br/>");
            }
            for (Map.Entry entry : skuErrorMsgMap.entrySet()) {
                errorMsgResult = errorMsgResult + ((StringBuilder)entry.getValue()).toString();
            }
            if (CollectionUtils.isNotEmpty((Collection)needToSendEmailList)) {
                this.sendEmailForApproveApply(needToSendEmailList, PegasusUtilFacade.getInstance().findConfigByKey("wh.applyApprove.email").getConfigValue());
            }
            if (errorMsgResult.length() > 0) {
                throw new WarehouseException("WH0001", errorMsgResult);
            }
        }
    }

    private void sendEmailForApproveApply(List<WhAllotStoreApplicationSkuVO> applicationList, String contactEmails) {
        if (EmptyUtil.isNotEmpty(applicationList)) {
            StringBuffer emailContent = new StringBuffer();
            emailContent.append("<html><style>#table-5 thead th {background-color: rgb(156, 186, 95);color: #fff;border-bottom-width: 0;}");
            emailContent.append("#table-5 td {color: #000;}");
            emailContent.append("#table-5 tr, #table-5 th {border-width: 1px;border-style: solid;border-color: rgb(156, 186, 95);}");
            emailContent.append("#table-5 td, #table-5 th {padding: 5px 10px;font-size: 12px;font-family: Verdana;font-weight: bold;}</style>");
            emailContent.append("<table id='table-5'><caption>\u95e8\u5e97\u672a\u914d\u7f6e\u54c1\u724c\u4ed3\u5bfc\u81f4\u65e0\u6cd5\u5206\u8d27</caption><thead><th>SKU</th><th>\u6e20\u9053</th></thead>");
            emailContent.append("<tbody>");
            for (WhAllotStoreApplicationSkuVO application : applicationList) {
                emailContent.append("<tr>");
                emailContent.append("<td>" + application.getSkuCode() + "</td>");
                emailContent.append("<td>" + application.getChannelCode() + "</td>");
                emailContent.append("</tr>");
            }
            emailContent.append("</tbody></table></html>");
            String[] toNotifyUsers = contactEmails.split(",");
            EmailVO emailVO = new EmailVO();
            emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
            emailVO.setSubject("\u5ba1\u6279\u901a\u8fc7\u5206\u8d27\u672a\u914d\u7f6e\u54c1\u724c\u4ed3\u62a5\u9519\u90ae\u4ef6");
            emailVO.setContent(emailContent.toString());
            if (CollectionUtils.isNotEmpty((Collection)emailVO.getToAddressList()) && !EmailUtil.getInstance().send(emailVO)) {
                throw new WarehouseException("\u5ba1\u6279\u901a\u8fc7\u5206\u8d27\u672a\u914d\u7f6e\u54c1\u724c\u4ed3\u62a5\u9519\u90ae\u4ef6\u53d1\u9001\u5931\u8d25");
            }
        }
    }

    @Override
    public int batchUpdateSelective(List<WhAllotStoreApplicationSkuVO> recordList) {
        if (EmptyUtil.isEmpty(recordList)) {
            return 0;
        }
        return this.whAllotStoreApplicationSkuMapper.batchUpdateSelective(BeanUtil.buildListFrom(recordList, WhAllotStoreApplicationSku.class));
    }

    @Override
    @Transactional
    public int batchApprove(List<WhAllotStoreApplicationSkuVO> recordList) {
        if (EmptyUtil.isEmpty(recordList)) {
            return 0;
        }
        for (WhAllotStoreApplicationSkuVO applicationSkuVO : recordList) {
            ArrayList<WhAllotStoreApplicationSkuVO> list = new ArrayList<WhAllotStoreApplicationSkuVO>();
            list.add(applicationSkuVO);
            LOGGER.info("\u5ba1\u6279\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)applicationSkuVO));
            int rct = this.whAllotStoreApplicationSkuMapper.batchApprove(BeanUtil.buildListFrom(list, WhAllotStoreApplicationSku.class));
            if (rct != 0) continue;
            throw new WarehouseException("", "\u4e0d\u80fd\u91cd\u590d\u5ba1\u6279\uff01\uff01");
        }
        return 1;
    }

    @Override
    public Map<String, List<WhAllotStoreApplicationSkuVO>> mapNotNotifyApplication() {
        List<WhAllotStoreApplicationSkuVO> list = this.whAllotStoreApplicationSkuMapper.selectNotNotifyApplication();
        HashMap<String, List<WhAllotStoreApplicationSkuVO>> map = new HashMap<String, List<WhAllotStoreApplicationSkuVO>>();
        if (EmptyUtil.isNotEmpty(list)) {
            int listSize = list.size();
            HashSet<String> skuCodeSet = new HashSet<String>();
            for (int i = 0; i < listSize; ++i) {
                skuCodeSet.add(list.get(i).getSkuCode());
            }
            Map skuMap = this.mcPcsSkuService.getSkuNameByCodes(skuCodeSet);
            for (int i = 0; i < listSize; ++i) {
                WhAllotStoreApplicationSkuVO storeApplicationSkuVO = list.get(i);
                String channelCode = storeApplicationSkuVO.getChannelCode();
                PcsSkuDTO pcsSkuDTO = (PcsSkuDTO)skuMap.get(storeApplicationSkuVO.getSkuCode());
                storeApplicationSkuVO.setSkuName(pcsSkuDTO != null ? pcsSkuDTO.getNameCn() : "");
                if (map.containsKey(channelCode)) {
                    ((List)map.get(channelCode)).add(storeApplicationSkuVO);
                    continue;
                }
                ArrayList<WhAllotStoreApplicationSkuVO> newList = new ArrayList<WhAllotStoreApplicationSkuVO>();
                newList.add(storeApplicationSkuVO);
                map.put(channelCode, newList);
            }
        }
        return map;
    }

    @Override
    public void nofityApplovalResult() {
        Map<String, List<WhAllotStoreApplicationSkuVO>> map = this.mapNotNotifyApplication();
        ArrayList<String> channelCodes = new ArrayList<String>(map.keySet());
        List opChannelList = this.mcOpChannelService.findByCode(channelCodes);
        HashMap whOpChannelMap = new HashMap();
        HashMap<String, String> channelWhEmailMap = new HashMap<String, String>();
        if (EmptyUtil.isNotEmpty((List)opChannelList)) {
            ArrayList warehosueCodeList = new ArrayList();
            int listSize = opChannelList.size();
            for (int i = 0; i < listSize; ++i) {
                OpChannelVO opChannel = (OpChannelVO)opChannelList.get(i);
                channelWhEmailMap.put(opChannel.getCode(), opChannel.getNoticeEmails());
            }
            for (final Map.Entry<String, List<WhAllotStoreApplicationSkuVO>> entry : map.entrySet()) {
                String channelCode = entry.getKey();
                final String contactEmails = (String)channelWhEmailMap.get(channelCode);
                try {
                    this.transactionTemplate.execute(new TransactionCallback(){

                        public Object doInTransaction(TransactionStatus transactionStatus) {
                            WhAllotStoreApplicationServiceImpl.this.successNotify((List)entry.getValue());
                            WhAllotStoreApplicationServiceImpl.this.sendEmail((List)entry.getValue(), contactEmails);
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    LOGGER.error("\u95e8\u5e97\u8d27\u54c1\u7533\u8bf7\u7ed3\u679c\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff1a{}", (Object)channelCode, (Object)e);
                }
            }
        }
    }

    @Override
    public String canApplyAllot(List<String> skuCodes, String channelCode) {
        OpChannelVO opChannelVO = this.mcOpChannelService.findByCode(channelCode);
        Map map = this.mcPcsSkuService.getSkuNameByCodes(new HashSet<String>(skuCodes));
        StringBuilder result = new StringBuilder();
        int skuCodeCnt = skuCodes.size();
        for (int i = 0; i < skuCodeCnt; ++i) {
            String skuCode = skuCodes.get(i);
            PcsSkuDTO pcsSkuDTO = (PcsSkuDTO)map.get(skuCode);
            if (pcsSkuDTO.getCrossBorderFlag() != 0) {
                result.append("[").append(skuCode).append("]").append(pcsSkuDTO.getNameCn()).append(", \u8be5\u5546\u54c1\u4e3a\u8de8\u5883\u5546\u54c1\uff0c\u4e0d\u80fd\u7533\u8bf7</br>");
            }
            if (pcsSkuDTO.getIsJit() == 1) {
                result.append("[").append(skuCode).append("]").append(pcsSkuDTO.getNameCn()).append(", \u8be5\u5546\u54c1\u4e3a\u6765\u5355\u5546\u54c1\uff0c\u4e0d\u80fd\u7533\u8bf7</br>");
            }
            List warehouseVOS = this.channelQueryService.getWarehouseByCode(opChannelVO.getCode());
            Boolean flag = false;
            if (CollectionUtils.isEmpty((Collection)warehouseVOS)) {
                result.append("\u6ca1\u6709\u8bbe\u7f6e\u5206\u8d27\u4ed3\u4f4d\uff0c\u65e0\u6cd5\u7533\u8bf7");
            } else {
                for (ChannelWarehouseVO channelWarehouseVO : warehouseVOS) {
                    if (!channelWarehouseVO.getType().equals(2)) continue;
                    flag = true;
                    break;
                }
            }
            if (flag.booleanValue()) continue;
            result.append("\u6ca1\u6709\u8bbe\u7f6e\u5206\u8d27\u4ed3\u4f4d\uff0c\u65e0\u6cd5\u7533\u8bf7");
        }
        return result.toString();
    }

    @Override
    @Transactional
    public void createAllotsCron() throws Exception {
        ArrayList waitAllotWarhouseCodes = Lists.newArrayList();
        waitAllotWarhouseCodes.add("WH000254910254");
        waitAllotWarhouseCodes.add("WH000255910255");
        waitAllotWarhouseCodes.add("WH000562910562");
        waitAllotWarhouseCodes.add("WH000563910563");
        for (String warehouseCode : waitAllotWarhouseCodes) {
            Map<String, WhInvVO> whInvVOMap = this.whInvService.findCanUseQttByWarehouseCode(warehouseCode);
            if (whInvVOMap.isEmpty()) continue;
            WhAllotRcd whAllotRcd = new WhAllotRcd();
            List<WhPhysicalWarehouseVO> targetWarehouseList = this.whInfoService.findPhysicalWarehouseByWarehouseCode("WH020600010096");
            if (CollectionUtils.isEmpty(targetWarehouseList)) {
                throw new WarehouseException("WH0103", "\u903b\u8f91\u4ed3[" + warehouseCode + "]\u5728\u903b\u8f91\u4ed3\u5206\u7ec4\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u7406\u4ed3\uff0c\u64cd\u4f5c\u5931\u8d25");
            }
            List<WhPhysicalWarehouseVO> sourceWarehouseList = this.whInfoService.findPhysicalWarehouseByWarehouseCode(warehouseCode);
            if (CollectionUtils.isEmpty(sourceWarehouseList)) {
                throw new WarehouseException("WH0103", "\u903b\u8f91\u4ed3[" + warehouseCode + "]\u5728\u903b\u8f91\u4ed3\u5206\u7ec4\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u7406\u4ed3\uff0c\u64cd\u4f5c\u5931\u8d25");
            }
            whAllotRcd.setAllotType(WhAllotRcd.TYPE_NORMAL);
            whAllotRcd.setTargetPhysicalWarehouseCode(targetWarehouseList.get(0).getCode());
            whAllotRcd.setTargetWarehouseCode("WH020600010096");
            whAllotRcd.setSourcePhysicalWarehouseCode(sourceWarehouseList.get(0).getCode());
            whAllotRcd.setSourceWarehouseCode(warehouseCode);
            whAllotRcd.setReferenceCode("");
            whAllotRcd.setRemark("\u95e8\u5e97\u8d27\u54c1\u7533\u8bf7\u53ef\u7528\u5e93\u5b58\u81ea\u52a8\u8c03\u62e8");
            ArrayList whAllotRcdSkuList = Lists.newArrayList();
            for (Map.Entry<String, WhInvVO> entry : whInvVOMap.entrySet()) {
                String skuCode = entry.getKey();
                Integer quality = entry.getValue().getCanUseInv();
                if (quality <= 0) continue;
                WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
                whAllotRcdSku.setSkuCode(skuCode);
                whAllotRcdSku.setQuantity(quality);
                whAllotRcdSkuList.add(whAllotRcdSku);
            }
            if (!CollectionUtils.isNotEmpty((Collection)whAllotRcdSkuList)) continue;
            whAllotRcd.setWhAllotRcdSkuList(whAllotRcdSkuList);
            this.whAllotService.createAllotRcd(whAllotRcd);
        }
    }

    private WhAllotRcd buildWhAllotRcd(WhAllotRcd vo, HashMap<String, Integer> map) {
        WhAllotRcd whAllotRcd = new WhAllotRcd();
        whAllotRcd.setAllotType(WhAllotRcd.TYPE_NORMAL);
        whAllotRcd.setTargetPhysicalWarehouseCode(vo.getTargetPhysicalWarehouseCode());
        whAllotRcd.setTargetWarehouseCode(vo.getTargetWarehouseCode());
        whAllotRcd.setSourcePhysicalWarehouseCode(vo.getSourcePhysicalWarehouseCode());
        whAllotRcd.setSourceWarehouseCode(vo.getSourceWarehouseCode());
        whAllotRcd.setReferenceCode(vo.getCode());
        whAllotRcd.setRemark(vo.getRemark());
        whAllotRcd.setCreateUserId(vo.getCreateUserId() == null ? 1 : vo.getCreateUserId());
        ArrayList<WhAllotRcdSku> skuList = new ArrayList<WhAllotRcdSku>();
        whAllotRcd.setWhAllotRcdSkuList(skuList);
        if (map != null && map.size() > 0) {
            for (String key : map.keySet()) {
                WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
                whAllotRcdSku.setSkuCode(key);
                whAllotRcdSku.setQuantity(map.get(key));
                skuList.add(whAllotRcdSku);
            }
        } else {
            return null;
        }
        return whAllotRcd;
    }

    private void sendEmail(List<WhAllotStoreApplicationSkuVO> applicationList, String contactEmails) {
        if (EmptyUtil.isNotEmpty(applicationList)) {
            StringBuffer emailContent = new StringBuffer();
            emailContent.append("<html><style>#table-5 thead th {background-color: rgb(156, 186, 95);color: #fff;border-bottom-width: 0;}");
            emailContent.append("#table-5 td {color: #000;}");
            emailContent.append("#table-5 tr, #table-5 th {border-width: 1px;border-style: solid;border-color: rgb(156, 186, 95);}");
            emailContent.append("#table-5 td, #table-5 th {padding: 5px 10px;font-size: 12px;font-family: Verdana;font-weight: bold;}</style>");
            emailContent.append("<table id='table-5'><thead><th>SKU</th><th>SKU\u4e2d\u6587\u540d\u79f0</th><th>\u7533\u8bf7\u6570\u91cf</th><th>\u7533\u8bf7\u4eba</th><th>\u7533\u8bf7\u65f6\u95f4</th><th>\u5ba1\u6279\u7ed3\u679c</th></thead>");
            emailContent.append("<tbody>");
            for (WhAllotStoreApplicationSkuVO application : applicationList) {
                emailContent.append("<tr>");
                emailContent.append("<td>" + application.getSkuCode() + "</td>");
                emailContent.append("<td>" + application.getSkuName() + "</td>");
                emailContent.append("<td>" + application.getChannelCnt() + "</td>");
                emailContent.append("<td>" + application.getApplicantName() + "</td>");
                emailContent.append("<td>" + DateUtil.format((Date)application.getApplicationDate(), (String)"yyyy-MM-dd HH:mm:ss") + "</td>");
                emailContent.append("<td>(" + application.getApplicationStatusDesc() + ")</td>");
                emailContent.append("</tr>");
            }
            emailContent.append("</tbody></table></html>");
            String[] toNotifyUsers = contactEmails.split(",");
            EmailVO emailVO = new EmailVO();
            emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
            emailVO.setSubject("\u95e8\u5e97\u8d27\u54c1\u7533\u8bf7\u7ed3\u679c");
            emailVO.setContent(emailContent.toString());
            if (CollectionUtils.isNotEmpty((Collection)emailVO.getToAddressList()) && !EmailUtil.getInstance().send(emailVO)) {
                throw new WarehouseException("\u95e8\u5e97\u8d27\u54c1\u7533\u8bf7\u7ed3\u679c\u901a\u77e5\u90ae\u4ef6\u53d1\u9001\u5931\u8d25");
            }
        }
    }

    private void successNotify(List<WhAllotStoreApplicationSkuVO> applicationList) {
        if (EmptyUtil.isNotEmpty(applicationList)) {
            List poList = BeanUtil.buildListFrom(applicationList, WhAllotStoreApplicationSku.class);
            int listSize = applicationList.size();
            for (int i = 0; i < listSize; ++i) {
                ((WhAllotStoreApplicationSku)poList.get(i)).setIsNotify(true);
            }
            this.whAllotStoreApplicationSkuMapper.batchUpdateSelective(poList);
        }
    }

    public List<WhAllotStoreApplicationSkuVO> createAllotRcd(WhAllotStoreApplicationApproveVO approveVO, Map<String, WhAllotStoreApplicationSkuRefusedDateVO> skuPurchaseOrderMap) throws Exception {
        List<String> skuCodes = approveVO.getSkuCodes();
        List<WhAllotStoreApplicationSkuVO> list = this.whAllotStoreApplicationSkuMapper.selectApprovalDetailListBySkuCode(skuCodes, approveVO.getChannelCodes());
        this.resolve(list);
        ArrayList warehouseCodes = Lists.newArrayList();
        HashMap map = new HashMap();
        ArrayList<WhAllotRcd> rcdList = new ArrayList<WhAllotRcd>();
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            WhAllotStoreApplicationSkuVO applicationSkuVO = list.get(i);
            String skuCode = applicationSkuVO.getSkuCode();
            if (map.containsKey(skuCode)) {
                List existsList = (List)map.get(skuCode);
                existsList.add(applicationSkuVO);
            } else {
                LinkedList<WhAllotStoreApplicationSkuVO> newList = new LinkedList<WhAllotStoreApplicationSkuVO>();
                newList.add(applicationSkuVO);
                map.put(skuCode, newList);
            }
            warehouseCodes.add(applicationSkuVO.getWarehouseForChannel());
        }
        Map unAllotedCntMap = this.sPresaleService.mapUnAllotedCntBySkuCode(skuCodes);
        Map stockMap = this.sStockService.getSkuStocks(skuCodes, "WH020600010096");
        Map chn2018StockMap = this.sStockService.getSkuStocks(skuCodes, "WH020600010102");
        for (Map.Entry entry : map.entrySet()) {
            String skuCode = (String)entry.getKey();
            SSkuStockVO skuStockVO = (SSkuStockVO)stockMap.get(skuCode);
            SSkuStockVO chn2018SkuStockVO = (SSkuStockVO)chn2018StockMap.get(skuCode);
            int canUseQuantity = skuStockVO.getCanUseQuantity();
            int unAllotedCnt = 0;
            if (EmptyUtil.isNotEmpty((Map)unAllotedCntMap)) {
                int n = unAllotedCnt = unAllotedCntMap.get(skuCode) != null ? (Integer)unAllotedCntMap.get(skuCode) : 0;
            }
            if (unAllotedCnt < 0) {
                unAllotedCnt = 0;
            }
            canUseQuantity -= unAllotedCnt;
            int chn2018CanUseQuantity = chn2018SkuStockVO.getCanUseQuantity();
            List applicationList = (List)entry.getValue();
            int applicationListSize = applicationList.size();
            Date approvalTime = new Date();
            for (int i = 0; i < applicationListSize; ++i) {
                WhAllotStoreApplicationSkuVO applicationSkuVO = (WhAllotStoreApplicationSkuVO)applicationList.get(i);
                WhAllotStoreApplicationRcdVO applicationRcdVO = this.buildWhAllotRcd(canUseQuantity, chn2018CanUseQuantity, applicationSkuVO, approveVO.getApprover());
                applicationSkuVO.setApprovalTime(approvalTime);
                applicationSkuVO.setApprover(approveVO.getApprover());
                if (applicationRcdVO != null) {
                    List<WhAllotRcd> whAllotRcds = applicationRcdVO.getRcds();
                    if (whAllotRcds == null || whAllotRcds.size() <= 0) continue;
                    canUseQuantity = applicationRcdVO.getCanUseQuantity();
                    chn2018CanUseQuantity = applicationRcdVO.getChn2018CanUseQuantity();
                    rcdList.addAll(whAllotRcds);
                    applicationSkuVO.setApplicationStatus(WhAllotStoreApplicationStatusEnum.APPROVED.getStatus());
                    continue;
                }
                applicationSkuVO.setApplicationStatus(WhAllotStoreApplicationStatusEnum.REJECT.getStatus());
                applicationSkuVO.setRejectReason(WhAllotStoreApplicationRejectTypeEnum.STOCK_NOT_ENOUGH.getType());
                if (null == skuPurchaseOrderMap.get(applicationSkuVO.getSkuCode())) continue;
                WhAllotStoreApplicationSkuRefusedDateVO dateVO = skuPurchaseOrderMap.get(applicationSkuVO.getSkuCode());
                applicationSkuVO.setPlanReceiveDate(dateVO.getPlanReceiveDate());
            }
        }
        this.batchApprove(list);
        this.whAllotService.createAllotRcds(rcdList);
        return list;
    }

    private final WhAllotStoreApplicationRcdVO buildWhAllotRcd(int canUseQuantity, int chn2018CanUseQuantity, WhAllotStoreApplicationSkuVO applicationSkuVO, Long approver) {
        ArrayList<WhAllotRcdSku> whAllotRcdSkuList;
        WhAllotRcdSku whAllotRcdSku;
        WhAllotRcd whAllotRcd;
        WhAllotStoreApplicationRcdVO applicationRcdVO = new WhAllotStoreApplicationRcdVO();
        ArrayList<WhAllotRcd> rcds = new ArrayList<WhAllotRcd>();
        int totalCanUseQuantity = canUseQuantity + chn2018CanUseQuantity;
        int needAllotQuantity = applicationSkuVO.getQuantity();
        if (totalCanUseQuantity < needAllotQuantity) {
            return null;
        }
        int allotQuantity = 0;
        int chn2018AllotQuantity = 0;
        if (canUseQuantity >= needAllotQuantity) {
            allotQuantity = needAllotQuantity;
            canUseQuantity -= needAllotQuantity;
            needAllotQuantity = 0;
        } else {
            allotQuantity = canUseQuantity;
            needAllotQuantity -= canUseQuantity;
            canUseQuantity = 0;
            if (chn2018CanUseQuantity >= needAllotQuantity && needAllotQuantity > 0) {
                chn2018AllotQuantity = needAllotQuantity;
                chn2018CanUseQuantity -= needAllotQuantity;
            }
        }
        if (allotQuantity > 0) {
            whAllotRcd = new WhAllotRcd();
            whAllotRcd.setSourcePhysicalWarehouseCode("WH02060001");
            whAllotRcd.setSourceWarehouseCode("WH020600010096");
            whAllotRcd.setCreateUserId(approver.intValue());
            whAllotRcd.setTargetPhysicalWarehouseCode("WH02060001");
            whAllotRcd.setTargetWarehouseCode(applicationSkuVO.getWarehouseForChannel());
            whAllotRcd.setAllotType(WhAllotTypeEnum.STORE_ALLOT_APPLICATION.getVal());
            whAllotRcdSku = new WhAllotRcdSku();
            whAllotRcdSku.setSkuCode(applicationSkuVO.getSkuCode());
            whAllotRcdSku.setQuantity(allotQuantity);
            whAllotRcdSkuList = new ArrayList<WhAllotRcdSku>();
            whAllotRcdSkuList.add(whAllotRcdSku);
            whAllotRcd.setWhAllotRcdSkuList(whAllotRcdSkuList);
            rcds.add(whAllotRcd);
        }
        if (chn2018AllotQuantity > 0) {
            whAllotRcd = new WhAllotRcd();
            whAllotRcd.setSourcePhysicalWarehouseCode("WH02060001");
            whAllotRcd.setSourceWarehouseCode("WH020600010102");
            whAllotRcd.setCreateUserId(approver.intValue());
            whAllotRcd.setTargetPhysicalWarehouseCode("WH02060001");
            whAllotRcd.setTargetWarehouseCode(applicationSkuVO.getWarehouseForChannel());
            whAllotRcd.setAllotType(WhAllotTypeEnum.STORE_ALLOT_APPLICATION.getVal());
            whAllotRcdSku = new WhAllotRcdSku();
            whAllotRcdSku.setSkuCode(applicationSkuVO.getSkuCode());
            whAllotRcdSku.setQuantity(chn2018AllotQuantity);
            whAllotRcdSkuList = new ArrayList();
            whAllotRcdSkuList.add(whAllotRcdSku);
            whAllotRcd.setWhAllotRcdSkuList(whAllotRcdSkuList);
            rcds.add(whAllotRcd);
        }
        applicationRcdVO.setCanUseQuantity(canUseQuantity);
        applicationRcdVO.setChn2018CanUseQuantity(chn2018CanUseQuantity);
        applicationRcdVO.setRcds(rcds);
        return applicationRcdVO;
    }

    private List<WhAllotStoreApplicationSkuVO> rejectApplication(WhAllotStoreApplicationApproveVO approveVO, Map<String, WhAllotStoreApplicationSkuRefusedDateVO> skuPurchaseOrderMap) {
        List<WhAllotStoreApplicationSkuVO> list = this.whAllotStoreApplicationSkuMapper.selectApprovalDetailListBySkuCode(approveVO.getSkuCodes(), approveVO.getChannelCodes());
        if (EmptyUtil.isEmpty(list)) {
            throw new WarehouseException("\u4e0d\u5b58\u5728\u5f85\u5ba1\u6279\u4e2d\u7684\u8bb0\u5f55\uff01");
        }
        int listSize = list.size();
        Date approvalTime = new Date();
        Boolean stockNotEnough = false;
        if (approveVO.getRejectReason().equals((short)1)) {
            stockNotEnough = true;
        }
        for (int i = 0; i < listSize; ++i) {
            WhAllotStoreApplicationSkuVO applicationSkuVO = list.get(i);
            applicationSkuVO.setApplicationStatus(WhAllotStoreApplicationStatusEnum.REJECT.getStatus());
            applicationSkuVO.setRejectReason(approveVO.getRejectReason());
            applicationSkuVO.setApprover(approveVO.getApprover());
            applicationSkuVO.setApprovalTime(approvalTime);
            applicationSkuVO.setApprover((long)approveVO.getApprover());
            applicationSkuVO.setApprovalNote(approveVO.getApprovalNote());
            if (null == skuPurchaseOrderMap.get(applicationSkuVO.getSkuCode()) || !stockNotEnough.booleanValue()) continue;
            WhAllotStoreApplicationSkuRefusedDateVO dateVO = skuPurchaseOrderMap.get(applicationSkuVO.getSkuCode());
            applicationSkuVO.setPlanReceiveDate(dateVO.getPlanReceiveDate());
        }
        this.batchApprove(list);
        return list;
    }

    private final WhAllotStoreApplication buildStoreApplicationVO2DO(WhAllotStoreApplicationVO storeApplication) {
        if (storeApplication == null) {
            throw new BusinessException("storeApplication not be null");
        }
        return (WhAllotStoreApplication)BeanUtil.buildFrom((Object)storeApplication, WhAllotStoreApplication.class);
    }

    private final List<WhAllotStoreApplicationSku> buildStoreApplicationSkuVO2DO(List<WhAllotStoreApplicationSkuVO> storeApplicationSkuVOList) {
        if (storeApplicationSkuVOList == null) {
            throw new BusinessException("storeApplicationSkuVOList not be null");
        }
        return BeanUtil.buildListFrom(storeApplicationSkuVOList, WhAllotStoreApplicationSku.class);
    }

    private final void setApplicationID2SkuDO(Integer applicationId, List<WhAllotStoreApplicationSku> skuList) {
        if (applicationId == null || EmptyUtil.isEmpty(skuList)) {
            throw new BusinessException("applicationId or skuList not be empty");
        }
        int listSize = skuList.size();
        for (int i = 0; i < listSize; ++i) {
            skuList.get(i).setApplicationId(applicationId);
        }
    }

    private final void buildApprovalListOtherInfo(List<WhAllotStoreApplicationSkuVO> list) {
        if (EmptyUtil.isNotEmpty(list)) {
            ArrayList<String> skuCodeList = new ArrayList<String>();
            int listSize = list.size();
            for (int i = 0; i < listSize; ++i) {
                skuCodeList.add(list.get(i).getSkuCode());
            }
            Map unAllotedCntMap = this.sPresaleService.mapUnAllotedCntBySkuCode(skuCodeList);
            Map stockMap = this.sStockService.getSkuStocks(skuCodeList, "WH020600010096");
            Map chn2018StockMap = this.sStockService.getSkuStocks(skuCodeList, "WH020600010102");
            for (int i = 0; i < listSize; ++i) {
                WhAllotStoreApplicationSkuVO applicationSkuVO = list.get(i);
                String skuCode = applicationSkuVO.getSkuCode();
                SSkuStockVO chn2018Stock = chn2018StockMap != null ? (SSkuStockVO)chn2018StockMap.get(skuCode) : null;
                applicationSkuVO.setOfficialWebsiteQuantity(chn2018Stock != null ? chn2018Stock.getCanUseQuantity() : 0);
                SSkuStockVO skuStockVO = stockMap != null ? (SSkuStockVO)stockMap.get(skuCode) : null;
                int unAllotedCnt = unAllotedCntMap.get(skuCode) != null ? (Integer)unAllotedCntMap.get(skuCode) : 0;
                applicationSkuVO.setGoodWarehouseQuantity(skuStockVO != null ? skuStockVO.getCanUseQuantity() - unAllotedCnt : -unAllotedCnt);
            }
        }
    }

    private List<String> takeOutSkuCode(List<WhAllotStoreApplicationSkuVO> skuList) {
        ArrayList<String> skuCodes = new ArrayList<String>();
        int listSize = skuList.size();
        for (int i = 0; i < listSize; ++i) {
            skuCodes.add(skuList.get(i).getSkuCode());
        }
        return skuCodes;
    }
}

